/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.task;

import java.util.Objects;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.sejda.model.exception.TaskCancelledException;
import org.sejda.model.exception.TaskNonLenientExecutionException;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutionContext {
    private static final Logger LOG = LoggerFactory.getLogger(TaskExecutionContext.class);
    private StopWatch stopWatch = new StopWatch();
    private NotifiableTaskMetadata taskMetadata;
    private boolean cancelled = false;
    private Task<? extends TaskParameters> task;
    private boolean lenient;
    private int outputDocumentsCounter = 0;

    public TaskExecutionContext(Task<? extends TaskParameters> task, boolean lenient) {
        if (Objects.isNull(task)) {
            throw new IllegalArgumentException("Task cannot be null");
        }
        this.taskMetadata = new NotifiableTaskMetadata(task);
        this.task = task;
        this.lenient = lenient;
    }

    public NotifiableTaskMetadata notifiableTaskMetadata() {
        return this.taskMetadata;
    }

    public void cancelTask() {
        this.cancelled = true;
    }

    public void assertTaskNotCancelled() throws TaskCancelledException {
        if (this.cancelled) {
            throw new TaskCancelledException();
        }
    }

    public Task task() {
        return this.task;
    }

    public void taskStart() {
        this.stopWatch.start();
    }

    public void taskEnded() {
        this.stopWatch.stop();
        LOG.info("Task ({}) executed in {}", this.task, (Object)DurationFormatUtils.formatDurationWords((long)this.stopWatch.getTime(), (boolean)true, (boolean)true));
    }

    public long executionTime() {
        return this.stopWatch.getTime();
    }

    public int incrementAndGetOutputDocumentsCounter() {
        return ++this.outputDocumentsCounter;
    }

    public void assertTaskIsLenient(Exception e) throws TaskNonLenientExecutionException {
        if (!this.lenient) {
            throw new TaskNonLenientExecutionException(e);
        }
    }
}

