# WARNING ABOUT GENERATED CODE
#
# This file is generated. See the contributing guide for more information:
# https://github.com/aws/aws-sdk-ruby/blob/master/CONTRIBUTING.md
#
# WARNING ABOUT GENERATED CODE

require 'seahorse/client/plugins/content_length.rb'
require 'aws-sdk-core/plugins/credentials_configuration.rb'
require 'aws-sdk-core/plugins/logging.rb'
require 'aws-sdk-core/plugins/param_converter.rb'
require 'aws-sdk-core/plugins/param_validator.rb'
require 'aws-sdk-core/plugins/user_agent.rb'
require 'aws-sdk-core/plugins/helpful_socket_errors.rb'
require 'aws-sdk-core/plugins/retry_errors.rb'
require 'aws-sdk-core/plugins/global_configuration.rb'
require 'aws-sdk-core/plugins/regional_endpoint.rb'
require 'aws-sdk-core/plugins/endpoint_discovery.rb'
require 'aws-sdk-core/plugins/endpoint_pattern.rb'
require 'aws-sdk-core/plugins/response_paging.rb'
require 'aws-sdk-core/plugins/stub_responses.rb'
require 'aws-sdk-core/plugins/idempotency_token.rb'
require 'aws-sdk-core/plugins/jsonvalue_converter.rb'
require 'aws-sdk-core/plugins/client_metrics_plugin.rb'
require 'aws-sdk-core/plugins/client_metrics_send_plugin.rb'
require 'aws-sdk-core/plugins/transfer_encoding.rb'
require 'aws-sdk-core/plugins/signature_v4.rb'
require 'aws-sdk-core/plugins/protocols/ec2.rb'
require 'aws-sdk-ec2/plugins/copy_encrypted_snapshot.rb'
require 'aws-sdk-ec2/plugins/region_validation.rb'

Aws::Plugins::GlobalConfiguration.add_identifier(:ec2)

module Aws::EC2
  class Client < Seahorse::Client::Base

    include Aws::ClientStubs

    @identifier = :ec2

    set_api(ClientApi::API)

    add_plugin(Seahorse::Client::Plugins::ContentLength)
    add_plugin(Aws::Plugins::CredentialsConfiguration)
    add_plugin(Aws::Plugins::Logging)
    add_plugin(Aws::Plugins::ParamConverter)
    add_plugin(Aws::Plugins::ParamValidator)
    add_plugin(Aws::Plugins::UserAgent)
    add_plugin(Aws::Plugins::HelpfulSocketErrors)
    add_plugin(Aws::Plugins::RetryErrors)
    add_plugin(Aws::Plugins::GlobalConfiguration)
    add_plugin(Aws::Plugins::RegionalEndpoint)
    add_plugin(Aws::Plugins::EndpointDiscovery)
    add_plugin(Aws::Plugins::EndpointPattern)
    add_plugin(Aws::Plugins::ResponsePaging)
    add_plugin(Aws::Plugins::StubResponses)
    add_plugin(Aws::Plugins::IdempotencyToken)
    add_plugin(Aws::Plugins::JsonvalueConverter)
    add_plugin(Aws::Plugins::ClientMetricsPlugin)
    add_plugin(Aws::Plugins::ClientMetricsSendPlugin)
    add_plugin(Aws::Plugins::TransferEncoding)
    add_plugin(Aws::Plugins::SignatureV4)
    add_plugin(Aws::Plugins::Protocols::EC2)
    add_plugin(Aws::EC2::Plugins::CopyEncryptedSnapshot)
    add_plugin(Aws::EC2::Plugins::RegionValidation)

    # @overload initialize(options)
    #   @param [Hash] options
    #   @option options [required, Aws::CredentialProvider] :credentials
    #     Your AWS credentials. This can be an instance of any one of the
    #     following classes:
    #
    #     * `Aws::Credentials` - Used for configuring static, non-refreshing
    #       credentials.
    #
    #     * `Aws::InstanceProfileCredentials` - Used for loading credentials
    #       from an EC2 IMDS on an EC2 instance.
    #
    #     * `Aws::SharedCredentials` - Used for loading credentials from a
    #       shared file, such as `~/.aws/config`.
    #
    #     * `Aws::AssumeRoleCredentials` - Used when you need to assume a role.
    #
    #     When `:credentials` are not configured directly, the following
    #     locations will be searched for credentials:
    #
    #     * `Aws.config[:credentials]`
    #     * The `:access_key_id`, `:secret_access_key`, and `:session_token` options.
    #     * ENV['AWS_ACCESS_KEY_ID'], ENV['AWS_SECRET_ACCESS_KEY']
    #     * `~/.aws/credentials`
    #     * `~/.aws/config`
    #     * EC2 IMDS instance profile - When used by default, the timeouts are
    #       very aggressive. Construct and pass an instance of
    #       `Aws::InstanceProfileCredentails` to enable retries and extended
    #       timeouts.
    #
    #   @option options [required, String] :region
    #     The AWS region to connect to.  The configured `:region` is
    #     used to determine the service `:endpoint`. When not passed,
    #     a default `:region` is search for in the following locations:
    #
    #     * `Aws.config[:region]`
    #     * `ENV['AWS_REGION']`
    #     * `ENV['AMAZON_REGION']`
    #     * `ENV['AWS_DEFAULT_REGION']`
    #     * `~/.aws/credentials`
    #     * `~/.aws/config`
    #
    #   @option options [String] :access_key_id
    #
    #   @option options [Boolean] :active_endpoint_cache (false)
    #     When set to `true`, a thread polling for endpoints will be running in
    #     the background every 60 secs (default). Defaults to `false`.
    #
    #   @option options [Boolean] :client_side_monitoring (false)
    #     When `true`, client-side metrics will be collected for all API requests from
    #     this client.
    #
    #   @option options [String] :client_side_monitoring_client_id ("")
    #     Allows you to provide an identifier for this client which will be attached to
    #     all generated client side metrics. Defaults to an empty string.
    #
    #   @option options [String] :client_side_monitoring_host ("127.0.0.1")
    #     Allows you to specify the DNS hostname or IPv4 or IPv6 address that the client
    #     side monitoring agent is running on, where client metrics will be published via UDP.
    #
    #   @option options [Integer] :client_side_monitoring_port (31000)
    #     Required for publishing client metrics. The port that the client side monitoring
    #     agent is running on, where client metrics will be published via UDP.
    #
    #   @option options [Aws::ClientSideMonitoring::Publisher] :client_side_monitoring_publisher (Aws::ClientSideMonitoring::Publisher)
    #     Allows you to provide a custom client-side monitoring publisher class. By default,
    #     will use the Client Side Monitoring Agent Publisher.
    #
    #   @option options [Boolean] :convert_params (true)
    #     When `true`, an attempt is made to coerce request parameters into
    #     the required types.
    #
    #   @option options [Boolean] :disable_host_prefix_injection (false)
    #     Set to true to disable SDK automatically adding host prefix
    #     to default service endpoint when available.
    #
    #   @option options [String] :endpoint
    #     The client endpoint is normally constructed from the `:region`
    #     option. You should only configure an `:endpoint` when connecting
    #     to test endpoints. This should be avalid HTTP(S) URI.
    #
    #   @option options [Integer] :endpoint_cache_max_entries (1000)
    #     Used for the maximum size limit of the LRU cache storing endpoints data
    #     for endpoint discovery enabled operations. Defaults to 1000.
    #
    #   @option options [Integer] :endpoint_cache_max_threads (10)
    #     Used for the maximum threads in use for polling endpoints to be cached, defaults to 10.
    #
    #   @option options [Integer] :endpoint_cache_poll_interval (60)
    #     When :endpoint_discovery and :active_endpoint_cache is enabled,
    #     Use this option to config the time interval in seconds for making
    #     requests fetching endpoints information. Defaults to 60 sec.
    #
    #   @option options [Boolean] :endpoint_discovery (false)
    #     When set to `true`, endpoint discovery will be enabled for operations when available. Defaults to `false`.
    #
    #   @option options [Aws::Log::Formatter] :log_formatter (Aws::Log::Formatter.default)
    #     The log formatter.
    #
    #   @option options [Symbol] :log_level (:info)
    #     The log level to send messages to the `:logger` at.
    #
    #   @option options [Logger] :logger
    #     The Logger instance to send log messages to.  If this option
    #     is not set, logging will be disabled.
    #
    #   @option options [String] :profile ("default")
    #     Used when loading credentials from the shared credentials file
    #     at HOME/.aws/credentials.  When not specified, 'default' is used.
    #
    #   @option options [Float] :retry_base_delay (0.3)
    #     The base delay in seconds used by the default backoff function.
    #
    #   @option options [Symbol] :retry_jitter (:none)
    #     A delay randomiser function used by the default backoff function. Some predefined functions can be referenced by name - :none, :equal, :full, otherwise a Proc that takes and returns a number.
    #
    #     @see https://www.awsarchitectureblog.com/2015/03/backoff.html
    #
    #   @option options [Integer] :retry_limit (3)
    #     The maximum number of times to retry failed requests.  Only
    #     ~ 500 level server errors and certain ~ 400 level client errors
    #     are retried.  Generally, these are throttling errors, data
    #     checksum errors, networking errors, timeout errors and auth
    #     errors from expired credentials.
    #
    #   @option options [Integer] :retry_max_delay (0)
    #     The maximum number of seconds to delay between retries (0 for no limit) used by the default backoff function.
    #
    #   @option options [String] :secret_access_key
    #
    #   @option options [String] :session_token
    #
    #   @option options [Boolean] :stub_responses (false)
    #     Causes the client to return stubbed responses. By default
    #     fake responses are generated and returned. You can specify
    #     the response data to return or errors to raise by calling
    #     {ClientStubs#stub_responses}. See {ClientStubs} for more information.
    #
    #     ** Please note ** When response stubbing is enabled, no HTTP
    #     requests are made, and retries are disabled.
    #
    #   @option options [Boolean] :validate_params (true)
    #     When `true`, request parameters are validated before
    #     sending the request.
    #
    #   @option options [URI::HTTP,String] :http_proxy A proxy to send
    #     requests through.  Formatted like 'http://proxy.com:123'.
    #
    #   @option options [Float] :http_open_timeout (15) The number of
    #     seconds to wait when opening a HTTP session before rasing a
    #     `Timeout::Error`.
    #
    #   @option options [Integer] :http_read_timeout (60) The default
    #     number of seconds to wait for response data.  This value can
    #     safely be set
    #     per-request on the session yeidled by {#session_for}.
    #
    #   @option options [Float] :http_idle_timeout (5) The number of
    #     seconds a connection is allowed to sit idble before it is
    #     considered stale.  Stale connections are closed and removed
    #     from the pool before making a request.
    #
    #   @option options [Float] :http_continue_timeout (1) The number of
    #     seconds to wait for a 100-continue response before sending the
    #     request body.  This option has no effect unless the request has
    #     "Expect" header set to "100-continue".  Defaults to `nil` which
    #     disables this behaviour.  This value can safely be set per
    #     request on the session yeidled by {#session_for}.
    #
    #   @option options [Boolean] :http_wire_trace (false) When `true`,
    #     HTTP debug output will be sent to the `:logger`.
    #
    #   @option options [Boolean] :ssl_verify_peer (true) When `true`,
    #     SSL peer certificates are verified when establishing a
    #     connection.
    #
    #   @option options [String] :ssl_ca_bundle Full path to the SSL
    #     certificate authority bundle file that should be used when
    #     verifying peer certificates.  If you do not pass
    #     `:ssl_ca_bundle` or `:ssl_ca_directory` the the system default
    #     will be used if available.
    #
    #   @option options [String] :ssl_ca_directory Full path of the
    #     directory that contains the unbundled SSL certificate
    #     authority files for verifying peer certificates.  If you do
    #     not pass `:ssl_ca_bundle` or `:ssl_ca_directory` the the
    #     system default will be used if available.
    #
    def initialize(*args)
      super
    end

    # @!group API Operations

    # Accepts the Convertible Reserved Instance exchange quote described in
    # the GetReservedInstancesExchangeQuote call.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :reserved_instance_ids
    #   The IDs of the Convertible Reserved Instances to exchange for another
    #   Convertible Reserved Instance of the same or higher value.
    #
    # @option params [Array<Types::TargetConfigurationRequest>] :target_configurations
    #   The configuration of the target Convertible Reserved Instance to
    #   exchange for your current Convertible Reserved Instances.
    #
    # @return [Types::AcceptReservedInstancesExchangeQuoteResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AcceptReservedInstancesExchangeQuoteResult#exchange_id #exchange_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.accept_reserved_instances_exchange_quote({
    #     dry_run: false,
    #     reserved_instance_ids: ["String"], # required
    #     target_configurations: [
    #       {
    #         instance_count: 1,
    #         offering_id: "String", # required
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.exchange_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptReservedInstancesExchangeQuote AWS API Documentation
    #
    # @overload accept_reserved_instances_exchange_quote(params = {})
    # @param [Hash] params ({})
    def accept_reserved_instances_exchange_quote(params = {}, options = {})
      req = build_request(:accept_reserved_instances_exchange_quote, params)
      req.send_request(options)
    end

    # Accepts a request to attach a VPC to a transit gateway.
    #
    # The VPC attachment must be in the `pendingAcceptance` state. Use
    # DescribeTransitGatewayVpcAttachments to view your pending VPC
    # attachment requests. Use RejectTransitGatewayVpcAttachment to reject a
    # VPC attachment request.
    #
    # @option params [required, String] :transit_gateway_attachment_id
    #   The ID of the attachment.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AcceptTransitGatewayVpcAttachmentResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AcceptTransitGatewayVpcAttachmentResult#transit_gateway_vpc_attachment #transit_gateway_vpc_attachment} => Types::TransitGatewayVpcAttachment
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.accept_transit_gateway_vpc_attachment({
    #     transit_gateway_attachment_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_vpc_attachment.transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_vpc_attachment.transit_gateway_id #=> String
    #   resp.transit_gateway_vpc_attachment.vpc_id #=> String
    #   resp.transit_gateway_vpc_attachment.vpc_owner_id #=> String
    #   resp.transit_gateway_vpc_attachment.state #=> String, one of "pendingAcceptance", "rollingBack", "pending", "available", "modifying", "deleting", "deleted", "failed", "rejected", "rejecting", "failing"
    #   resp.transit_gateway_vpc_attachment.subnet_ids #=> Array
    #   resp.transit_gateway_vpc_attachment.subnet_ids[0] #=> String
    #   resp.transit_gateway_vpc_attachment.creation_time #=> Time
    #   resp.transit_gateway_vpc_attachment.options.dns_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_vpc_attachment.options.ipv_6_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_vpc_attachment.tags #=> Array
    #   resp.transit_gateway_vpc_attachment.tags[0].key #=> String
    #   resp.transit_gateway_vpc_attachment.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayVpcAttachment AWS API Documentation
    #
    # @overload accept_transit_gateway_vpc_attachment(params = {})
    # @param [Hash] params ({})
    def accept_transit_gateway_vpc_attachment(params = {}, options = {})
      req = build_request(:accept_transit_gateway_vpc_attachment, params)
      req.send_request(options)
    end

    # Accepts one or more interface VPC endpoint connection requests to your
    # VPC endpoint service.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :service_id
    #   The ID of the endpoint service.
    #
    # @option params [required, Array<String>] :vpc_endpoint_ids
    #   The IDs of one or more interface VPC endpoints.
    #
    # @return [Types::AcceptVpcEndpointConnectionsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AcceptVpcEndpointConnectionsResult#unsuccessful #unsuccessful} => Array&lt;Types::UnsuccessfulItem&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.accept_vpc_endpoint_connections({
    #     dry_run: false,
    #     service_id: "String", # required
    #     vpc_endpoint_ids: ["String"], # required
    #   })
    #
    # @example Response structure
    #
    #   resp.unsuccessful #=> Array
    #   resp.unsuccessful[0].error.code #=> String
    #   resp.unsuccessful[0].error.message #=> String
    #   resp.unsuccessful[0].resource_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcEndpointConnections AWS API Documentation
    #
    # @overload accept_vpc_endpoint_connections(params = {})
    # @param [Hash] params ({})
    def accept_vpc_endpoint_connections(params = {}, options = {})
      req = build_request(:accept_vpc_endpoint_connections, params)
      req.send_request(options)
    end

    # Accept a VPC peering connection request. To accept a request, the VPC
    # peering connection must be in the `pending-acceptance` state, and you
    # must be the owner of the peer VPC. Use DescribeVpcPeeringConnections
    # to view your outstanding VPC peering connection requests.
    #
    # For an inter-Region VPC peering connection request, you must accept
    # the VPC peering connection in the Region of the accepter VPC.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :vpc_peering_connection_id
    #   The ID of the VPC peering connection. You must specify this parameter
    #   in the request.
    #
    # @return [Types::AcceptVpcPeeringConnectionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AcceptVpcPeeringConnectionResult#vpc_peering_connection #vpc_peering_connection} => Types::VpcPeeringConnection
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.accept_vpc_peering_connection({
    #     dry_run: false,
    #     vpc_peering_connection_id: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.vpc_peering_connection.accepter_vpc_info.cidr_block #=> String
    #   resp.vpc_peering_connection.accepter_vpc_info.ipv_6_cidr_block_set #=> Array
    #   resp.vpc_peering_connection.accepter_vpc_info.ipv_6_cidr_block_set[0].ipv_6_cidr_block #=> String
    #   resp.vpc_peering_connection.accepter_vpc_info.cidr_block_set #=> Array
    #   resp.vpc_peering_connection.accepter_vpc_info.cidr_block_set[0].cidr_block #=> String
    #   resp.vpc_peering_connection.accepter_vpc_info.owner_id #=> String
    #   resp.vpc_peering_connection.accepter_vpc_info.peering_options.allow_dns_resolution_from_remote_vpc #=> Boolean
    #   resp.vpc_peering_connection.accepter_vpc_info.peering_options.allow_egress_from_local_classic_link_to_remote_vpc #=> Boolean
    #   resp.vpc_peering_connection.accepter_vpc_info.peering_options.allow_egress_from_local_vpc_to_remote_classic_link #=> Boolean
    #   resp.vpc_peering_connection.accepter_vpc_info.vpc_id #=> String
    #   resp.vpc_peering_connection.accepter_vpc_info.region #=> String
    #   resp.vpc_peering_connection.expiration_time #=> Time
    #   resp.vpc_peering_connection.requester_vpc_info.cidr_block #=> String
    #   resp.vpc_peering_connection.requester_vpc_info.ipv_6_cidr_block_set #=> Array
    #   resp.vpc_peering_connection.requester_vpc_info.ipv_6_cidr_block_set[0].ipv_6_cidr_block #=> String
    #   resp.vpc_peering_connection.requester_vpc_info.cidr_block_set #=> Array
    #   resp.vpc_peering_connection.requester_vpc_info.cidr_block_set[0].cidr_block #=> String
    #   resp.vpc_peering_connection.requester_vpc_info.owner_id #=> String
    #   resp.vpc_peering_connection.requester_vpc_info.peering_options.allow_dns_resolution_from_remote_vpc #=> Boolean
    #   resp.vpc_peering_connection.requester_vpc_info.peering_options.allow_egress_from_local_classic_link_to_remote_vpc #=> Boolean
    #   resp.vpc_peering_connection.requester_vpc_info.peering_options.allow_egress_from_local_vpc_to_remote_classic_link #=> Boolean
    #   resp.vpc_peering_connection.requester_vpc_info.vpc_id #=> String
    #   resp.vpc_peering_connection.requester_vpc_info.region #=> String
    #   resp.vpc_peering_connection.status.code #=> String, one of "initiating-request", "pending-acceptance", "active", "deleted", "rejected", "failed", "expired", "provisioning", "deleting"
    #   resp.vpc_peering_connection.status.message #=> String
    #   resp.vpc_peering_connection.tags #=> Array
    #   resp.vpc_peering_connection.tags[0].key #=> String
    #   resp.vpc_peering_connection.tags[0].value #=> String
    #   resp.vpc_peering_connection.vpc_peering_connection_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcPeeringConnection AWS API Documentation
    #
    # @overload accept_vpc_peering_connection(params = {})
    # @param [Hash] params ({})
    def accept_vpc_peering_connection(params = {}, options = {})
      req = build_request(:accept_vpc_peering_connection, params)
      req.send_request(options)
    end

    # Advertises an IPv4 address range that is provisioned for use with your
    # AWS resources through bring your own IP addresses (BYOIP).
    #
    # You can perform this operation at most once every 10 seconds, even if
    # you specify different address ranges each time.
    #
    # We recommend that you stop advertising the BYOIP CIDR from other
    # locations when you advertise it from AWS. To minimize down time, you
    # can configure your AWS resources to use an address from a BYOIP CIDR
    # before it is advertised, and then simultaneously stop advertising it
    # from the current location and start advertising it through AWS.
    #
    # It can take a few minutes before traffic to the specified addresses
    # starts routing to AWS because of BGP propagation delays.
    #
    # To stop advertising the BYOIP CIDR, use WithdrawByoipCidr.
    #
    # @option params [required, String] :cidr
    #   The IPv4 address range, in CIDR notation. This must be the exact range
    #   that you provisioned. You can't advertise only a portion of the
    #   provisioned range.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AdvertiseByoipCidrResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AdvertiseByoipCidrResult#byoip_cidr #byoip_cidr} => Types::ByoipCidr
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.advertise_byoip_cidr({
    #     cidr: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.byoip_cidr.cidr #=> String
    #   resp.byoip_cidr.description #=> String
    #   resp.byoip_cidr.status_message #=> String
    #   resp.byoip_cidr.state #=> String, one of "advertised", "deprovisioned", "failed-deprovision", "failed-provision", "pending-deprovision", "pending-provision", "provisioned"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AdvertiseByoipCidr AWS API Documentation
    #
    # @overload advertise_byoip_cidr(params = {})
    # @param [Hash] params ({})
    def advertise_byoip_cidr(params = {}, options = {})
      req = build_request(:advertise_byoip_cidr, params)
      req.send_request(options)
    end

    # Allocates an Elastic IP address to your AWS account. After you
    # allocate the Elastic IP address you can associate it with an instance
    # or network interface. After you release an Elastic IP address, it is
    # released to the IP address pool and can be allocated to a different
    # AWS account.
    #
    # You can allocate an Elastic IP address from an address pool owned by
    # AWS or from an address pool created from a public IPv4 address range
    # that you have brought to AWS for use with your AWS resources using
    # bring your own IP addresses (BYOIP). For more information, see [Bring
    # Your Own IP Addresses (BYOIP)][1] in the *Amazon Elastic Compute Cloud
    # User Guide*.
    #
    # \[EC2-VPC\] If you release an Elastic IP address, you might be able to
    # recover it. You cannot recover an Elastic IP address that you released
    # after it is allocated to another AWS account. You cannot recover an
    # Elastic IP address for EC2-Classic. To attempt to recover an Elastic
    # IP address that you released, specify it in this operation.
    #
    # An Elastic IP address is for use either in the EC2-Classic platform or
    # in a VPC. By default, you can allocate 5 Elastic IP addresses for
    # EC2-Classic per Region and 5 Elastic IP addresses for EC2-VPC per
    # Region.
    #
    # For more information, see [Elastic IP Addresses][2] in the *Amazon
    # Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html
    #
    # @option params [String] :domain
    #   Set to `vpc` to allocate the address for use with instances in a VPC.
    #
    #   Default: The address is for use with instances in EC2-Classic.
    #
    # @option params [String] :address
    #   \[EC2-VPC\] The Elastic IP address to recover or an IPv4 address from
    #   an address pool.
    #
    # @option params [String] :public_ipv_4_pool
    #   The ID of an address pool that you own. Use this parameter to let
    #   Amazon EC2 select an address from the address pool. To specify a
    #   specific address from the address pool, use the `Address` parameter
    #   instead.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AllocateAddressResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AllocateAddressResult#public_ip #public_ip} => String
    #   * {Types::AllocateAddressResult#allocation_id #allocation_id} => String
    #   * {Types::AllocateAddressResult#public_ipv_4_pool #public_ipv_4_pool} => String
    #   * {Types::AllocateAddressResult#domain #domain} => String
    #
    #
    # @example Example: To allocate an Elastic IP address for EC2-VPC
    #
    #   # This example allocates an Elastic IP address to use with an instance in a VPC.
    #
    #   resp = client.allocate_address({
    #     domain: "vpc", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     allocation_id: "eipalloc-64d5890a", 
    #     domain: "vpc", 
    #     public_ip: "203.0.113.0", 
    #   }
    #
    # @example Example: To allocate an Elastic IP address for EC2-Classic
    #
    #   # This example allocates an Elastic IP address to use with an instance in EC2-Classic.
    #
    #   resp = client.allocate_address({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     domain: "standard", 
    #     public_ip: "198.51.100.0", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.allocate_address({
    #     domain: "vpc", # accepts vpc, standard
    #     address: "String",
    #     public_ipv_4_pool: "String",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.public_ip #=> String
    #   resp.allocation_id #=> String
    #   resp.public_ipv_4_pool #=> String
    #   resp.domain #=> String, one of "vpc", "standard"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddress AWS API Documentation
    #
    # @overload allocate_address(params = {})
    # @param [Hash] params ({})
    def allocate_address(params = {}, options = {})
      req = build_request(:allocate_address, params)
      req.send_request(options)
    end

    # Allocates a Dedicated Host to your account. At a minimum, specify the
    # instance size type, Availability Zone, and quantity of hosts to
    # allocate.
    #
    # @option params [String] :auto_placement
    #   Indicates whether the host accepts any untargeted instance launches
    #   that match its instance type configuration, or if it only accepts Host
    #   tenancy instance launches that specify its unique host ID. For more
    #   information, see [ Understanding Instance Placement and Host
    #   Affinity][1] in the *Amazon EC2 User Guide for Linux Instances*.
    #
    #   Default: `on`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding
    #
    # @option params [required, String] :availability_zone
    #   The Availability Zone in which to allocate the Dedicated Host.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [required, String] :instance_type
    #   Specifies the instance type for which to configure your Dedicated
    #   Hosts. When you specify the instance type, that is the only instance
    #   type that you can launch onto that host.
    #
    # @option params [required, Integer] :quantity
    #   The number of Dedicated Hosts to allocate to your account with these
    #   parameters.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the Dedicated Host during creation.
    #
    # @option params [String] :host_recovery
    #   Indicates whether to enable or disable host recovery for the Dedicated
    #   Host. Host recovery is disabled by default. For more information, see
    #   [ Host Recovery][1] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #   Default: `off`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html
    #
    # @return [Types::AllocateHostsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AllocateHostsResult#host_ids #host_ids} => Array&lt;String&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.allocate_hosts({
    #     auto_placement: "on", # accepts on, off
    #     availability_zone: "String", # required
    #     client_token: "String",
    #     instance_type: "String", # required
    #     quantity: 1, # required
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, elastic-ip, fleet, fpga-image, host-reservation, image, instance, internet-gateway, launch-template, natgateway, network-acl, network-interface, reserved-instances, route-table, security-group, snapshot, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     host_recovery: "on", # accepts on, off
    #   })
    #
    # @example Response structure
    #
    #   resp.host_ids #=> Array
    #   resp.host_ids[0] #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateHosts AWS API Documentation
    #
    # @overload allocate_hosts(params = {})
    # @param [Hash] params ({})
    def allocate_hosts(params = {}, options = {})
      req = build_request(:allocate_hosts, params)
      req.send_request(options)
    end

    # Applies a security group to the association between the target network
    # and the Client VPN endpoint. This action replaces the existing
    # security groups with the specified security groups.
    #
    # @option params [required, String] :client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC in which the associated target network is located.
    #
    # @option params [required, Array<String>] :security_group_ids
    #   The IDs of the security groups to apply to the associated target
    #   network. Up to 5 security groups can be applied to an associated
    #   target network.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::ApplySecurityGroupsToClientVpnTargetNetworkResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ApplySecurityGroupsToClientVpnTargetNetworkResult#security_group_ids #security_group_ids} => Array&lt;String&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.apply_security_groups_to_client_vpn_target_network({
    #     client_vpn_endpoint_id: "String", # required
    #     vpc_id: "String", # required
    #     security_group_ids: ["String"], # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.security_group_ids #=> Array
    #   resp.security_group_ids[0] #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ApplySecurityGroupsToClientVpnTargetNetwork AWS API Documentation
    #
    # @overload apply_security_groups_to_client_vpn_target_network(params = {})
    # @param [Hash] params ({})
    def apply_security_groups_to_client_vpn_target_network(params = {}, options = {})
      req = build_request(:apply_security_groups_to_client_vpn_target_network, params)
      req.send_request(options)
    end

    # Assigns one or more IPv6 addresses to the specified network interface.
    # You can specify one or more specific IPv6 addresses, or you can
    # specify the number of IPv6 addresses to be automatically assigned from
    # within the subnet's IPv6 CIDR block range. You can assign as many
    # IPv6 addresses to a network interface as you can assign private IPv4
    # addresses, and the limit varies per instance type. For information,
    # see [IP Addresses Per Network Interface Per Instance Type][1] in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI
    #
    # @option params [Integer] :ipv_6_address_count
    #   The number of IPv6 addresses to assign to the network interface.
    #   Amazon EC2 automatically selects the IPv6 addresses from the subnet
    #   range. You can't use this option if specifying specific IPv6
    #   addresses.
    #
    # @option params [Array<String>] :ipv_6_addresses
    #   One or more specific IPv6 addresses to be assigned to the network
    #   interface. You can't use this option if you're specifying a number
    #   of IPv6 addresses.
    #
    # @option params [required, String] :network_interface_id
    #   The ID of the network interface.
    #
    # @return [Types::AssignIpv6AddressesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssignIpv6AddressesResult#assigned_ipv_6_addresses #assigned_ipv_6_addresses} => Array&lt;String&gt;
    #   * {Types::AssignIpv6AddressesResult#network_interface_id #network_interface_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.assign_ipv_6_addresses({
    #     ipv_6_address_count: 1,
    #     ipv_6_addresses: ["String"],
    #     network_interface_id: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.assigned_ipv_6_addresses #=> Array
    #   resp.assigned_ipv_6_addresses[0] #=> String
    #   resp.network_interface_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignIpv6Addresses AWS API Documentation
    #
    # @overload assign_ipv_6_addresses(params = {})
    # @param [Hash] params ({})
    def assign_ipv_6_addresses(params = {}, options = {})
      req = build_request(:assign_ipv_6_addresses, params)
      req.send_request(options)
    end

    # Assigns one or more secondary private IP addresses to the specified
    # network interface.
    #
    # You can specify one or more specific secondary IP addresses, or you
    # can specify the number of secondary IP addresses to be automatically
    # assigned within the subnet's CIDR block range. The number of
    # secondary IP addresses that you can assign to an instance varies by
    # instance type. For information about instance types, see [Instance
    # Types][1] in the *Amazon Elastic Compute Cloud User Guide*. For more
    # information about Elastic IP addresses, see [Elastic IP Addresses][2]
    # in the *Amazon Elastic Compute Cloud User Guide*.
    #
    # When you move a secondary private IP address to another network
    # interface, any Elastic IP address that is associated with the IP
    # address is also moved.
    #
    # Remapping an IP address is an asynchronous operation. When you move an
    # IP address from one network interface to another, check
    # `network/interfaces/macs/mac/local-ipv4s` in the instance metadata to
    # confirm that the remapping is complete.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html
    #
    # @option params [Boolean] :allow_reassignment
    #   Indicates whether to allow an IP address that is already assigned to
    #   another network interface or instance to be reassigned to the
    #   specified network interface.
    #
    # @option params [required, String] :network_interface_id
    #   The ID of the network interface.
    #
    # @option params [Array<String>] :private_ip_addresses
    #   One or more IP addresses to be assigned as a secondary private IP
    #   address to the network interface. You can't specify this parameter
    #   when also specifying a number of secondary IP addresses.
    #
    #   If you don't specify an IP address, Amazon EC2 automatically selects
    #   an IP address within the subnet range.
    #
    # @option params [Integer] :secondary_private_ip_address_count
    #   The number of secondary IP addresses to assign to the network
    #   interface. You can't specify this parameter when also specifying
    #   private IP addresses.
    #
    # @return [Types::AssignPrivateIpAddressesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssignPrivateIpAddressesResult#network_interface_id #network_interface_id} => String
    #   * {Types::AssignPrivateIpAddressesResult#assigned_private_ip_addresses #assigned_private_ip_addresses} => Array&lt;Types::AssignedPrivateIpAddress&gt;
    #
    #
    # @example Example: To assign a specific secondary private IP address to an interface
    #
    #   # This example assigns the specified secondary private IP address to the specified network interface.
    #
    #   resp = client.assign_private_ip_addresses({
    #     network_interface_id: "eni-e5aa89a3", 
    #     private_ip_addresses: [
    #       "10.0.0.82", 
    #     ], 
    #   })
    #
    # @example Example: To assign secondary private IP addresses that Amazon EC2 selects to an interface
    #
    #   # This example assigns two secondary private IP addresses to the specified network interface. Amazon EC2 automatically
    #   # assigns these IP addresses from the available IP addresses in the CIDR block range of the subnet the network interface
    #   # is associated with.
    #
    #   resp = client.assign_private_ip_addresses({
    #     network_interface_id: "eni-e5aa89a3", 
    #     secondary_private_ip_address_count: 2, 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.assign_private_ip_addresses({
    #     allow_reassignment: false,
    #     network_interface_id: "String", # required
    #     private_ip_addresses: ["String"],
    #     secondary_private_ip_address_count: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.network_interface_id #=> String
    #   resp.assigned_private_ip_addresses #=> Array
    #   resp.assigned_private_ip_addresses[0].private_ip_address #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateIpAddresses AWS API Documentation
    #
    # @overload assign_private_ip_addresses(params = {})
    # @param [Hash] params ({})
    def assign_private_ip_addresses(params = {}, options = {})
      req = build_request(:assign_private_ip_addresses, params)
      req.send_request(options)
    end

    # Associates an Elastic IP address with an instance or a network
    # interface. Before you can use an Elastic IP address, you must allocate
    # it to your account.
    #
    # An Elastic IP address is for use in either the EC2-Classic platform or
    # in a VPC. For more information, see [Elastic IP Addresses][1] in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    # \[EC2-Classic, VPC in an EC2-VPC-only account\] If the Elastic IP
    # address is already associated with a different instance, it is
    # disassociated from that instance and associated with the specified
    # instance. If you associate an Elastic IP address with an instance that
    # has an existing Elastic IP address, the existing address is
    # disassociated from the instance, but remains allocated to your
    # account.
    #
    # \[VPC in an EC2-Classic account\] If you don't specify a private IP
    # address, the Elastic IP address is associated with the primary IP
    # address. If the Elastic IP address is already associated with a
    # different instance or a network interface, you get an error unless you
    # allow reassociation. You cannot associate an Elastic IP address with
    # an instance or network interface that has an existing Elastic IP
    # address.
    #
    # This is an idempotent operation. If you perform the operation more
    # than once, Amazon EC2 doesn't return an error, and you may be charged
    # for each time the Elastic IP address is remapped to the same instance.
    # For more information, see the *Elastic IP Addresses* section of
    # [Amazon EC2 Pricing][2].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html
    # [2]: http://aws.amazon.com/ec2/pricing/
    #
    # @option params [String] :allocation_id
    #   \[EC2-VPC\] The allocation ID. This is required for EC2-VPC.
    #
    # @option params [String] :instance_id
    #   The ID of the instance. This is required for EC2-Classic. For EC2-VPC,
    #   you can specify either the instance ID or the network interface ID,
    #   but not both. The operation fails if you specify an instance ID unless
    #   exactly one network interface is attached.
    #
    # @option params [String] :public_ip
    #   The Elastic IP address to associate with the instance. This is
    #   required for EC2-Classic.
    #
    # @option params [Boolean] :allow_reassociation
    #   \[EC2-VPC\] For a VPC in an EC2-Classic account, specify true to allow
    #   an Elastic IP address that is already associated with an instance or
    #   network interface to be reassociated with the specified instance or
    #   network interface. Otherwise, the operation fails. In a VPC in an
    #   EC2-VPC-only account, reassociation is automatic, therefore you can
    #   specify false to ensure the operation fails if the Elastic IP address
    #   is already associated with another resource.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :network_interface_id
    #   \[EC2-VPC\] The ID of the network interface. If the instance has more
    #   than one network interface, you must specify a network interface ID.
    #
    #   For EC2-VPC, you can specify either the instance ID or the network
    #   interface ID, but not both.
    #
    # @option params [String] :private_ip_address
    #   \[EC2-VPC\] The primary or secondary private IP address to associate
    #   with the Elastic IP address. If no private IP address is specified,
    #   the Elastic IP address is associated with the primary private IP
    #   address.
    #
    # @return [Types::AssociateAddressResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateAddressResult#association_id #association_id} => String
    #
    #
    # @example Example: To associate an Elastic IP address in EC2-VPC
    #
    #   # This example associates the specified Elastic IP address with the specified instance in a VPC.
    #
    #   resp = client.associate_address({
    #     allocation_id: "eipalloc-64d5890a", 
    #     instance_id: "i-0b263919b6498b123", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     association_id: "eipassoc-2bebb745", 
    #   }
    #
    # @example Example: To associate an Elastic IP address with a network interface
    #
    #   # This example associates the specified Elastic IP address with the specified network interface.
    #
    #   resp = client.associate_address({
    #     allocation_id: "eipalloc-64d5890a", 
    #     network_interface_id: "eni-1a2b3c4d", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     association_id: "eipassoc-2bebb745", 
    #   }
    #
    # @example Example: To associate an Elastic IP address in EC2-Classic
    #
    #   # This example associates an Elastic IP address with an instance in EC2-Classic.
    #
    #   resp = client.associate_address({
    #     instance_id: "i-07ffe74c7330ebf53", 
    #     public_ip: "198.51.100.0", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_address({
    #     allocation_id: "String",
    #     instance_id: "String",
    #     public_ip: "String",
    #     allow_reassociation: false,
    #     dry_run: false,
    #     network_interface_id: "String",
    #     private_ip_address: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.association_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddress AWS API Documentation
    #
    # @overload associate_address(params = {})
    # @param [Hash] params ({})
    def associate_address(params = {}, options = {})
      req = build_request(:associate_address, params)
      req.send_request(options)
    end

    # Associates a target network with a Client VPN endpoint. A target
    # network is a subnet in a VPC. You can associate multiple subnets from
    # the same VPC with a Client VPN endpoint. You can associate only one
    # subnet in each Availability Zone. We recommend that you associate at
    # least two subnets to provide Availability Zone redundancy.
    #
    # @option params [required, String] :client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #
    # @option params [required, String] :subnet_id
    #   The ID of the subnet to associate with the Client VPN endpoint.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AssociateClientVpnTargetNetworkResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateClientVpnTargetNetworkResult#association_id #association_id} => String
    #   * {Types::AssociateClientVpnTargetNetworkResult#status #status} => Types::AssociationStatus
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_client_vpn_target_network({
    #     client_vpn_endpoint_id: "String", # required
    #     subnet_id: "String", # required
    #     client_token: "String",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.association_id #=> String
    #   resp.status.code #=> String, one of "associating", "associated", "association-failed", "disassociating", "disassociated"
    #   resp.status.message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateClientVpnTargetNetwork AWS API Documentation
    #
    # @overload associate_client_vpn_target_network(params = {})
    # @param [Hash] params ({})
    def associate_client_vpn_target_network(params = {}, options = {})
      req = build_request(:associate_client_vpn_target_network, params)
      req.send_request(options)
    end

    # Associates a set of DHCP options (that you've previously created)
    # with the specified VPC, or associates no DHCP options with the VPC.
    #
    # After you associate the options with the VPC, any existing instances
    # and all new instances that you launch in that VPC use the options. You
    # don't need to restart or relaunch the instances. They automatically
    # pick up the changes within a few hours, depending on how frequently
    # the instance renews its DHCP lease. You can explicitly renew the lease
    # using the operating system on the instance.
    #
    # For more information, see [DHCP Options Sets][1] in the *Amazon
    # Virtual Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html
    #
    # @option params [required, String] :dhcp_options_id
    #   The ID of the DHCP options set, or `default` to associate no DHCP
    #   options with the VPC.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To associate a DHCP options set with a VPC
    #
    #   # This example associates the specified DHCP options set with the specified VPC.
    #
    #   resp = client.associate_dhcp_options({
    #     dhcp_options_id: "dopt-d9070ebb", 
    #     vpc_id: "vpc-a01106c2", 
    #   })
    #
    # @example Example: To associate the default DHCP options set with a VPC
    #
    #   # This example associates the default DHCP options set with the specified VPC.
    #
    #   resp = client.associate_dhcp_options({
    #     dhcp_options_id: "default", 
    #     vpc_id: "vpc-a01106c2", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_dhcp_options({
    #     dhcp_options_id: "String", # required
    #     vpc_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateDhcpOptions AWS API Documentation
    #
    # @overload associate_dhcp_options(params = {})
    # @param [Hash] params ({})
    def associate_dhcp_options(params = {}, options = {})
      req = build_request(:associate_dhcp_options, params)
      req.send_request(options)
    end

    # Associates an IAM instance profile with a running or stopped instance.
    # You cannot associate more than one IAM instance profile with an
    # instance.
    #
    # @option params [required, Types::IamInstanceProfileSpecification] :iam_instance_profile
    #   The IAM instance profile.
    #
    # @option params [required, String] :instance_id
    #   The ID of the instance.
    #
    # @return [Types::AssociateIamInstanceProfileResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateIamInstanceProfileResult#iam_instance_profile_association #iam_instance_profile_association} => Types::IamInstanceProfileAssociation
    #
    #
    # @example Example: To associate an IAM instance profile with an instance
    #
    #   # This example associates an IAM instance profile named admin-role with the specified instance.
    #
    #   resp = client.associate_iam_instance_profile({
    #     iam_instance_profile: {
    #       name: "admin-role", 
    #     }, 
    #     instance_id: "i-123456789abcde123", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     iam_instance_profile_association: {
    #       association_id: "iip-assoc-0e7736511a163c209", 
    #       iam_instance_profile: {
    #         arn: "arn:aws:iam::123456789012:instance-profile/admin-role", 
    #         id: "AIPAJBLK7RKJKWDXVHIEC", 
    #       }, 
    #       instance_id: "i-123456789abcde123", 
    #       state: "associating", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_iam_instance_profile({
    #     iam_instance_profile: { # required
    #       arn: "String",
    #       name: "String",
    #     },
    #     instance_id: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.iam_instance_profile_association.association_id #=> String
    #   resp.iam_instance_profile_association.instance_id #=> String
    #   resp.iam_instance_profile_association.iam_instance_profile.arn #=> String
    #   resp.iam_instance_profile_association.iam_instance_profile.id #=> String
    #   resp.iam_instance_profile_association.state #=> String, one of "associating", "associated", "disassociating", "disassociated"
    #   resp.iam_instance_profile_association.timestamp #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIamInstanceProfile AWS API Documentation
    #
    # @overload associate_iam_instance_profile(params = {})
    # @param [Hash] params ({})
    def associate_iam_instance_profile(params = {}, options = {})
      req = build_request(:associate_iam_instance_profile, params)
      req.send_request(options)
    end

    # Associates a subnet with a route table. The subnet and route table
    # must be in the same VPC. This association causes traffic originating
    # from the subnet to be routed according to the routes in the route
    # table. The action returns an association ID, which you need in order
    # to disassociate the route table from the subnet later. A route table
    # can be associated with multiple subnets.
    #
    # For more information, see [Route Tables][1] in the *Amazon Virtual
    # Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :route_table_id
    #   The ID of the route table.
    #
    # @option params [required, String] :subnet_id
    #   The ID of the subnet.
    #
    # @return [Types::AssociateRouteTableResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateRouteTableResult#association_id #association_id} => String
    #
    #
    # @example Example: To associate a route table with a subnet
    #
    #   # This example associates the specified route table with the specified subnet.
    #
    #   resp = client.associate_route_table({
    #     route_table_id: "rtb-22574640", 
    #     subnet_id: "subnet-9d4a7b6", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     association_id: "rtbassoc-781d0d1a", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_route_table({
    #     dry_run: false,
    #     route_table_id: "String", # required
    #     subnet_id: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.association_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteTable AWS API Documentation
    #
    # @overload associate_route_table(params = {})
    # @param [Hash] params ({})
    def associate_route_table(params = {}, options = {})
      req = build_request(:associate_route_table, params)
      req.send_request(options)
    end

    # Associates a CIDR block with your subnet. You can only associate a
    # single IPv6 CIDR block with your subnet. An IPv6 CIDR block must have
    # a prefix length of /64.
    #
    # @option params [required, String] :ipv_6_cidr_block
    #   The IPv6 CIDR block for your subnet. The subnet must have a /64 prefix
    #   length.
    #
    # @option params [required, String] :subnet_id
    #   The ID of your subnet.
    #
    # @return [Types::AssociateSubnetCidrBlockResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateSubnetCidrBlockResult#ipv_6_cidr_block_association #ipv_6_cidr_block_association} => Types::SubnetIpv6CidrBlockAssociation
    #   * {Types::AssociateSubnetCidrBlockResult#subnet_id #subnet_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_subnet_cidr_block({
    #     ipv_6_cidr_block: "String", # required
    #     subnet_id: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.ipv_6_cidr_block_association.association_id #=> String
    #   resp.ipv_6_cidr_block_association.ipv_6_cidr_block #=> String
    #   resp.ipv_6_cidr_block_association.ipv_6_cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.ipv_6_cidr_block_association.ipv_6_cidr_block_state.status_message #=> String
    #   resp.subnet_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSubnetCidrBlock AWS API Documentation
    #
    # @overload associate_subnet_cidr_block(params = {})
    # @param [Hash] params ({})
    def associate_subnet_cidr_block(params = {}, options = {})
      req = build_request(:associate_subnet_cidr_block, params)
      req.send_request(options)
    end

    # Associates the specified attachment with the specified transit gateway
    # route table. You can associate only one route table with an
    # attachment.
    #
    # @option params [required, String] :transit_gateway_route_table_id
    #   The ID of the transit gateway route table.
    #
    # @option params [required, String] :transit_gateway_attachment_id
    #   The ID of the attachment.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AssociateTransitGatewayRouteTableResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateTransitGatewayRouteTableResult#association #association} => Types::TransitGatewayAssociation
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_transit_gateway_route_table({
    #     transit_gateway_route_table_id: "String", # required
    #     transit_gateway_attachment_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.association.transit_gateway_route_table_id #=> String
    #   resp.association.transit_gateway_attachment_id #=> String
    #   resp.association.resource_id #=> String
    #   resp.association.resource_type #=> String, one of "vpc", "vpn", "direct-connect-gateway"
    #   resp.association.state #=> String, one of "associating", "associated", "disassociating", "disassociated"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayRouteTable AWS API Documentation
    #
    # @overload associate_transit_gateway_route_table(params = {})
    # @param [Hash] params ({})
    def associate_transit_gateway_route_table(params = {}, options = {})
      req = build_request(:associate_transit_gateway_route_table, params)
      req.send_request(options)
    end

    # Associates a CIDR block with your VPC. You can associate a secondary
    # IPv4 CIDR block, or you can associate an Amazon-provided IPv6 CIDR
    # block. The IPv6 CIDR block size is fixed at /56.
    #
    # For more information about associating CIDR blocks with your VPC and
    # applicable restrictions, see [VPC and Subnet Sizing][1] in the *Amazon
    # Virtual Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#VPC_Sizing
    #
    # @option params [Boolean] :amazon_provided_ipv_6_cidr_block
    #   Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length
    #   for the VPC. You cannot specify the range of IPv6 addresses, or the
    #   size of the CIDR block.
    #
    # @option params [String] :cidr_block
    #   An IPv4 CIDR block to associate with the VPC.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @return [Types::AssociateVpcCidrBlockResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateVpcCidrBlockResult#ipv_6_cidr_block_association #ipv_6_cidr_block_association} => Types::VpcIpv6CidrBlockAssociation
    #   * {Types::AssociateVpcCidrBlockResult#cidr_block_association #cidr_block_association} => Types::VpcCidrBlockAssociation
    #   * {Types::AssociateVpcCidrBlockResult#vpc_id #vpc_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_vpc_cidr_block({
    #     amazon_provided_ipv_6_cidr_block: false,
    #     cidr_block: "String",
    #     vpc_id: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.ipv_6_cidr_block_association.association_id #=> String
    #   resp.ipv_6_cidr_block_association.ipv_6_cidr_block #=> String
    #   resp.ipv_6_cidr_block_association.ipv_6_cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.ipv_6_cidr_block_association.ipv_6_cidr_block_state.status_message #=> String
    #   resp.cidr_block_association.association_id #=> String
    #   resp.cidr_block_association.cidr_block #=> String
    #   resp.cidr_block_association.cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.cidr_block_association.cidr_block_state.status_message #=> String
    #   resp.vpc_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateVpcCidrBlock AWS API Documentation
    #
    # @overload associate_vpc_cidr_block(params = {})
    # @param [Hash] params ({})
    def associate_vpc_cidr_block(params = {}, options = {})
      req = build_request(:associate_vpc_cidr_block, params)
      req.send_request(options)
    end

    # Links an EC2-Classic instance to a ClassicLink-enabled VPC through one
    # or more of the VPC's security groups. You cannot link an EC2-Classic
    # instance to more than one VPC at a time. You can only link an instance
    # that's in the `running` state. An instance is automatically unlinked
    # from a VPC when it's stopped - you can link it to the VPC again when
    # you restart it.
    #
    # After you've linked an instance, you cannot change the VPC security
    # groups that are associated with it. To change the security groups, you
    # must first unlink the instance, and then link it again.
    #
    # Linking your instance to a VPC is sometimes referred to as *attaching*
    # your instance.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :groups
    #   The ID of one or more of the VPC's security groups. You cannot
    #   specify security groups from a different VPC.
    #
    # @option params [required, String] :instance_id
    #   The ID of an EC2-Classic instance to link to the ClassicLink-enabled
    #   VPC.
    #
    # @option params [required, String] :vpc_id
    #   The ID of a ClassicLink-enabled VPC.
    #
    # @return [Types::AttachClassicLinkVpcResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AttachClassicLinkVpcResult#return #return} => Boolean
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.attach_classic_link_vpc({
    #     dry_run: false,
    #     groups: ["String"], # required
    #     instance_id: "String", # required
    #     vpc_id: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.return #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpc AWS API Documentation
    #
    # @overload attach_classic_link_vpc(params = {})
    # @param [Hash] params ({})
    def attach_classic_link_vpc(params = {}, options = {})
      req = build_request(:attach_classic_link_vpc, params)
      req.send_request(options)
    end

    # Attaches an internet gateway to a VPC, enabling connectivity between
    # the internet and the VPC. For more information about your VPC and
    # internet gateway, see the [Amazon Virtual Private Cloud User
    # Guide][1].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :internet_gateway_id
    #   The ID of the internet gateway.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To attach an Internet gateway to a VPC
    #
    #   # This example attaches the specified Internet gateway to the specified VPC.
    #
    #   resp = client.attach_internet_gateway({
    #     internet_gateway_id: "igw-c0a643a9", 
    #     vpc_id: "vpc-a01106c2", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.attach_internet_gateway({
    #     dry_run: false,
    #     internet_gateway_id: "String", # required
    #     vpc_id: "String", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachInternetGateway AWS API Documentation
    #
    # @overload attach_internet_gateway(params = {})
    # @param [Hash] params ({})
    def attach_internet_gateway(params = {}, options = {})
      req = build_request(:attach_internet_gateway, params)
      req.send_request(options)
    end

    # Attaches a network interface to an instance.
    #
    # @option params [required, Integer] :device_index
    #   The index of the device for the network interface attachment.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :instance_id
    #   The ID of the instance.
    #
    # @option params [required, String] :network_interface_id
    #   The ID of the network interface.
    #
    # @return [Types::AttachNetworkInterfaceResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AttachNetworkInterfaceResult#attachment_id #attachment_id} => String
    #
    #
    # @example Example: To attach a network interface to an instance
    #
    #   # This example attaches the specified network interface to the specified instance.
    #
    #   resp = client.attach_network_interface({
    #     device_index: 1, 
    #     instance_id: "i-1234567890abcdef0", 
    #     network_interface_id: "eni-e5aa89a3", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     attachment_id: "eni-attach-66c4350a", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.attach_network_interface({
    #     device_index: 1, # required
    #     dry_run: false,
    #     instance_id: "String", # required
    #     network_interface_id: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.attachment_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachNetworkInterface AWS API Documentation
    #
    # @overload attach_network_interface(params = {})
    # @param [Hash] params ({})
    def attach_network_interface(params = {}, options = {})
      req = build_request(:attach_network_interface, params)
      req.send_request(options)
    end

    # Attaches an EBS volume to a running or stopped instance and exposes it
    # to the instance with the specified device name.
    #
    # Encrypted EBS volumes must be attached to instances that support
    # Amazon EBS encryption. For more information, see [Amazon EBS
    # Encryption][1] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    # After you attach an EBS volume, you must make it available. For more
    # information, see [Making an EBS Volume Available For Use][2].
    #
    # If a volume has an AWS Marketplace product code:
    #
    # * The volume can be attached only to a stopped instance.
    #
    # * AWS Marketplace product codes are copied from the volume to the
    #   instance.
    #
    # * You must be subscribed to the product.
    #
    # * The instance type and operating system of the instance must support
    #   the product. For example, you can't detach a volume from a Windows
    #   instance and attach it to a Linux instance.
    #
    # For more information, see [Attaching Amazon EBS Volumes][3] in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-using-volumes.html
    # [3]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-attaching-volume.html
    #
    # @option params [required, String] :device
    #   The device name (for example, `/dev/sdh` or `xvdh`).
    #
    # @option params [required, String] :instance_id
    #   The ID of the instance.
    #
    # @option params [required, String] :volume_id
    #   The ID of the EBS volume. The volume and instance must be within the
    #   same Availability Zone.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::VolumeAttachment] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::VolumeAttachment#attach_time #attach_time} => Time
    #   * {Types::VolumeAttachment#device #device} => String
    #   * {Types::VolumeAttachment#instance_id #instance_id} => String
    #   * {Types::VolumeAttachment#state #state} => String
    #   * {Types::VolumeAttachment#volume_id #volume_id} => String
    #   * {Types::VolumeAttachment#delete_on_termination #delete_on_termination} => Boolean
    #
    #
    # @example Example: To attach a volume to an instance
    #
    #   # This example attaches a volume (``vol-1234567890abcdef0``) to an instance (``i-01474ef662b89480``) as ``/dev/sdf``.
    #
    #   resp = client.attach_volume({
    #     device: "/dev/sdf", 
    #     instance_id: "i-01474ef662b89480", 
    #     volume_id: "vol-1234567890abcdef0", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     attach_time: Time.parse("2016-08-29T18:52:32.724Z"), 
    #     device: "/dev/sdf", 
    #     instance_id: "i-01474ef662b89480", 
    #     state: "attaching", 
    #     volume_id: "vol-1234567890abcdef0", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.attach_volume({
    #     device: "String", # required
    #     instance_id: "String", # required
    #     volume_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.attach_time #=> Time
    #   resp.device #=> String
    #   resp.instance_id #=> String
    #   resp.state #=> String, one of "attaching", "attached", "detaching", "detached", "busy"
    #   resp.volume_id #=> String
    #   resp.delete_on_termination #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVolume AWS API Documentation
    #
    # @overload attach_volume(params = {})
    # @param [Hash] params ({})
    def attach_volume(params = {}, options = {})
      req = build_request(:attach_volume, params)
      req.send_request(options)
    end

    # Attaches a virtual private gateway to a VPC. You can attach one
    # virtual private gateway to one VPC at a time.
    #
    # For more information, see [AWS Site-to-Site VPN][1] in the *AWS
    # Site-to-Site VPN User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @option params [required, String] :vpn_gateway_id
    #   The ID of the virtual private gateway.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AttachVpnGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AttachVpnGatewayResult#vpc_attachment #vpc_attachment} => Types::VpcAttachment
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.attach_vpn_gateway({
    #     vpc_id: "String", # required
    #     vpn_gateway_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.vpc_attachment.state #=> String, one of "attaching", "attached", "detaching", "detached"
    #   resp.vpc_attachment.vpc_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVpnGateway AWS API Documentation
    #
    # @overload attach_vpn_gateway(params = {})
    # @param [Hash] params ({})
    def attach_vpn_gateway(params = {}, options = {})
      req = build_request(:attach_vpn_gateway, params)
      req.send_request(options)
    end

    # Adds an ingress authorization rule to a Client VPN endpoint. Ingress
    # authorization rules act as firewall rules that grant access to
    # networks. You must configure ingress authorization rules to enable
    # clients to access resources in AWS or on-premises networks.
    #
    # @option params [required, String] :client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #
    # @option params [required, String] :target_network_cidr
    #   The IPv4 address range, in CIDR notation, of the network for which
    #   access is being authorized.
    #
    # @option params [String] :access_group_id
    #   The ID of the Active Directory group to grant access.
    #
    # @option params [Boolean] :authorize_all_groups
    #   Indicates whether to grant access to all clients. Use `true` to grant
    #   all clients who successfully establish a VPN connection access to the
    #   network.
    #
    # @option params [String] :description
    #   A brief description of the authorization rule.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AuthorizeClientVpnIngressResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AuthorizeClientVpnIngressResult#status #status} => Types::ClientVpnAuthorizationRuleStatus
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.authorize_client_vpn_ingress({
    #     client_vpn_endpoint_id: "String", # required
    #     target_network_cidr: "String", # required
    #     access_group_id: "String",
    #     authorize_all_groups: false,
    #     description: "String",
    #     client_token: "String",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.status.code #=> String, one of "authorizing", "active", "failed", "revoking"
    #   resp.status.message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeClientVpnIngress AWS API Documentation
    #
    # @overload authorize_client_vpn_ingress(params = {})
    # @param [Hash] params ({})
    def authorize_client_vpn_ingress(params = {}, options = {})
      req = build_request(:authorize_client_vpn_ingress, params)
      req.send_request(options)
    end

    # \[VPC only\] Adds the specified egress rules to a security group for
    # use with a VPC.
    #
    # An outbound rule permits instances to send traffic to the specified
    # IPv4 or IPv6 CIDR address ranges, or to the instances associated with
    # the specified destination security groups.
    #
    # You specify a protocol for each rule (for example, TCP). For the TCP
    # and UDP protocols, you must also specify the destination port or port
    # range. For the ICMP protocol, you must also specify the ICMP type and
    # code. You can use -1 for the type or code to mean all types or all
    # codes.
    #
    # Rule changes are propagated to affected instances as quickly as
    # possible. However, a small delay might occur.
    #
    # For more information about VPC security group limits, see [Amazon VPC
    # Limits][1].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :group_id
    #   The ID of the security group.
    #
    # @option params [Array<Types::IpPermission>] :ip_permissions
    #   The sets of IP permissions. You can't specify a destination security
    #   group and a CIDR IP address range in the same set of permissions.
    #
    # @option params [String] :cidr_ip
    #   Not supported. Use a set of IP permissions to specify the CIDR.
    #
    # @option params [Integer] :from_port
    #   Not supported. Use a set of IP permissions to specify the port.
    #
    # @option params [String] :ip_protocol
    #   Not supported. Use a set of IP permissions to specify the protocol
    #   name or number.
    #
    # @option params [Integer] :to_port
    #   Not supported. Use a set of IP permissions to specify the port.
    #
    # @option params [String] :source_security_group_name
    #   Not supported. Use a set of IP permissions to specify a destination
    #   security group.
    #
    # @option params [String] :source_security_group_owner_id
    #   Not supported. Use a set of IP permissions to specify a destination
    #   security group.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To add a rule that allows outbound traffic to a specific address range
    #
    #   # This example adds a rule that grants access to the specified address ranges on TCP port 80.
    #
    #   resp = client.authorize_security_group_egress({
    #     group_id: "sg-1a2b3c4d", 
    #     ip_permissions: [
    #       {
    #         from_port: 80, 
    #         ip_protocol: "tcp", 
    #         ip_ranges: [
    #           {
    #             cidr_ip: "10.0.0.0/16", 
    #           }, 
    #         ], 
    #         to_port: 80, 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Example: To add a rule that allows outbound traffic to a specific security group
    #
    #   # This example adds a rule that grants access to the specified security group on TCP port 80.
    #
    #   resp = client.authorize_security_group_egress({
    #     group_id: "sg-1a2b3c4d", 
    #     ip_permissions: [
    #       {
    #         from_port: 80, 
    #         ip_protocol: "tcp", 
    #         to_port: 80, 
    #         user_id_group_pairs: [
    #           {
    #             group_id: "sg-4b51a32f", 
    #           }, 
    #         ], 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.authorize_security_group_egress({
    #     dry_run: false,
    #     group_id: "String", # required
    #     ip_permissions: [
    #       {
    #         from_port: 1,
    #         ip_protocol: "String",
    #         ip_ranges: [
    #           {
    #             cidr_ip: "String",
    #             description: "String",
    #           },
    #         ],
    #         ipv_6_ranges: [
    #           {
    #             cidr_ipv_6: "String",
    #             description: "String",
    #           },
    #         ],
    #         prefix_list_ids: [
    #           {
    #             description: "String",
    #             prefix_list_id: "String",
    #           },
    #         ],
    #         to_port: 1,
    #         user_id_group_pairs: [
    #           {
    #             description: "String",
    #             group_id: "String",
    #             group_name: "String",
    #             peering_status: "String",
    #             user_id: "String",
    #             vpc_id: "String",
    #             vpc_peering_connection_id: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     cidr_ip: "String",
    #     from_port: 1,
    #     ip_protocol: "String",
    #     to_port: 1,
    #     source_security_group_name: "String",
    #     source_security_group_owner_id: "String",
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupEgress AWS API Documentation
    #
    # @overload authorize_security_group_egress(params = {})
    # @param [Hash] params ({})
    def authorize_security_group_egress(params = {}, options = {})
      req = build_request(:authorize_security_group_egress, params)
      req.send_request(options)
    end

    # Adds the specified ingress rules to a security group.
    #
    # An inbound rule permits instances to receive traffic from the
    # specified IPv4 or IPv6 CIDR address ranges, or from the instances
    # associated with the specified destination security groups.
    #
    # You specify a protocol for each rule (for example, TCP). For TCP and
    # UDP, you must also specify the destination port or port range. For
    # ICMP/ICMPv6, you must also specify the ICMP/ICMPv6 type and code. You
    # can use -1 to mean all types or all codes.
    #
    # Rule changes are propagated to instances within the security group as
    # quickly as possible. However, a small delay might occur.
    #
    # For more information about VPC security group limits, see [Amazon VPC
    # Limits][1].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html
    #
    # @option params [String] :cidr_ip
    #   The IPv4 address range, in CIDR format. You can't specify this
    #   parameter when specifying a source security group. To specify an IPv6
    #   address range, use a set of IP permissions.
    #
    #   Alternatively, use a set of IP permissions to specify multiple rules
    #   and a description for the rule.
    #
    # @option params [Integer] :from_port
    #   The start of port range for the TCP and UDP protocols, or an ICMP type
    #   number. For the ICMP type number, use `-1` to specify all types. If
    #   you specify all ICMP types, you must specify all codes.
    #
    #   Alternatively, use a set of IP permissions to specify multiple rules
    #   and a description for the rule.
    #
    # @option params [String] :group_id
    #   The ID of the security group. You must specify either the security
    #   group ID or the security group name in the request. For security
    #   groups in a nondefault VPC, you must specify the security group ID.
    #
    # @option params [String] :group_name
    #   \[EC2-Classic, default VPC\] The name of the security group. You must
    #   specify either the security group ID or the security group name in the
    #   request.
    #
    # @option params [Array<Types::IpPermission>] :ip_permissions
    #   The sets of IP permissions.
    #
    # @option params [String] :ip_protocol
    #   The IP protocol name (`tcp`, `udp`, `icmp`) or number (see [Protocol
    #   Numbers][1]). To specify `icmpv6`, use a set of IP permissions.
    #
    #   \[VPC only\] Use `-1` to specify all protocols. If you specify `-1` or
    #   a protocol other than `tcp`, `udp`, or `icmp`, traffic on all ports is
    #   allowed, regardless of any ports you specify.
    #
    #   Alternatively, use a set of IP permissions to specify multiple rules
    #   and a description for the rule.
    #
    #
    #
    #   [1]: http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml
    #
    # @option params [String] :source_security_group_name
    #   \[EC2-Classic, default VPC\] The name of the source security group.
    #   You can't specify this parameter in combination with the following
    #   parameters: the CIDR IP address range, the start of the port range,
    #   the IP protocol, and the end of the port range. Creates rules that
    #   grant full ICMP, UDP, and TCP access. To create a rule with a specific
    #   IP protocol and port range, use a set of IP permissions instead. For
    #   EC2-VPC, the source security group must be in the same VPC.
    #
    # @option params [String] :source_security_group_owner_id
    #   \[nondefault VPC\] The AWS account ID for the source security group,
    #   if the source security group is in a different account. You can't
    #   specify this parameter in combination with the following parameters:
    #   the CIDR IP address range, the IP protocol, the start of the port
    #   range, and the end of the port range. Creates rules that grant full
    #   ICMP, UDP, and TCP access. To create a rule with a specific IP
    #   protocol and port range, use a set of IP permissions instead.
    #
    # @option params [Integer] :to_port
    #   The end of port range for the TCP and UDP protocols, or an ICMP code
    #   number. For the ICMP code number, use `-1` to specify all codes. If
    #   you specify all ICMP types, you must specify all codes.
    #
    #   Alternatively, use a set of IP permissions to specify multiple rules
    #   and a description for the rule.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To add a rule that allows inbound SSH traffic from an IPv4 address range
    #
    #   # This example enables inbound traffic on TCP port 22 (SSH). The rule includes a description to help you identify it
    #   # later.
    #
    #   resp = client.authorize_security_group_ingress({
    #     group_id: "sg-903004f8", 
    #     ip_permissions: [
    #       {
    #         from_port: 22, 
    #         ip_protocol: "tcp", 
    #         ip_ranges: [
    #           {
    #             cidr_ip: "203.0.113.0/24", 
    #             description: "SSH access from the LA office", 
    #           }, 
    #         ], 
    #         to_port: 22, 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Example: To add a rule that allows inbound HTTP traffic from another security group
    #
    #   # This example enables inbound traffic on TCP port 80 from the specified security group. The group must be in the same VPC
    #   # or a peer VPC. Incoming traffic is allowed based on the private IP addresses of instances that are associated with the
    #   # specified security group.
    #
    #   resp = client.authorize_security_group_ingress({
    #     group_id: "sg-111aaa22", 
    #     ip_permissions: [
    #       {
    #         from_port: 80, 
    #         ip_protocol: "tcp", 
    #         to_port: 80, 
    #         user_id_group_pairs: [
    #           {
    #             description: "HTTP access from other instances", 
    #             group_id: "sg-1a2b3c4d", 
    #           }, 
    #         ], 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Example: To add a rule that allows inbound RDP traffic from an IPv6 address range
    #
    #   # This example adds an inbound rule that allows RDP traffic from the specified IPv6 address range. The rule includes a
    #   # description to help you identify it later.
    #
    #   resp = client.authorize_security_group_ingress({
    #     group_id: "sg-123abc12 ", 
    #     ip_permissions: [
    #       {
    #         from_port: 3389, 
    #         ip_protocol: "tcp", 
    #         ipv_6_ranges: [
    #           {
    #             cidr_ipv_6: "2001:db8:1234:1a00::/64", 
    #             description: "RDP access from the NY office", 
    #           }, 
    #         ], 
    #         to_port: 3389, 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.authorize_security_group_ingress({
    #     cidr_ip: "String",
    #     from_port: 1,
    #     group_id: "String",
    #     group_name: "String",
    #     ip_permissions: [
    #       {
    #         from_port: 1,
    #         ip_protocol: "String",
    #         ip_ranges: [
    #           {
    #             cidr_ip: "String",
    #             description: "String",
    #           },
    #         ],
    #         ipv_6_ranges: [
    #           {
    #             cidr_ipv_6: "String",
    #             description: "String",
    #           },
    #         ],
    #         prefix_list_ids: [
    #           {
    #             description: "String",
    #             prefix_list_id: "String",
    #           },
    #         ],
    #         to_port: 1,
    #         user_id_group_pairs: [
    #           {
    #             description: "String",
    #             group_id: "String",
    #             group_name: "String",
    #             peering_status: "String",
    #             user_id: "String",
    #             vpc_id: "String",
    #             vpc_peering_connection_id: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     ip_protocol: "String",
    #     source_security_group_name: "String",
    #     source_security_group_owner_id: "String",
    #     to_port: 1,
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupIngress AWS API Documentation
    #
    # @overload authorize_security_group_ingress(params = {})
    # @param [Hash] params ({})
    def authorize_security_group_ingress(params = {}, options = {})
      req = build_request(:authorize_security_group_ingress, params)
      req.send_request(options)
    end

    # Bundles an Amazon instance store-backed Windows instance.
    #
    # During bundling, only the root device volume (C:\\) is bundled. Data
    # on other instance store volumes is not preserved.
    #
    # <note markdown="1"> This action is not applicable for Linux/Unix instances or Windows
    # instances that are backed by Amazon EBS.
    #
    #  </note>
    #
    # @option params [required, String] :instance_id
    #   The ID of the instance to bundle.
    #
    #   Type: String
    #
    #   Default: None
    #
    #   Required: Yes
    #
    # @option params [required, Types::Storage] :storage
    #   The bucket in which to store the AMI. You can specify a bucket that
    #   you already own or a new bucket that Amazon EC2 creates on your
    #   behalf. If you specify a bucket that belongs to someone else, Amazon
    #   EC2 returns an error.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::BundleInstanceResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::BundleInstanceResult#bundle_task #bundle_task} => Types::BundleTask
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.bundle_instance({
    #     instance_id: "String", # required
    #     storage: { # required
    #       s3: {
    #         aws_access_key_id: "String",
    #         bucket: "String",
    #         prefix: "String",
    #         upload_policy: "data",
    #         upload_policy_signature: "String",
    #       },
    #     },
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.bundle_task.bundle_id #=> String
    #   resp.bundle_task.bundle_task_error.code #=> String
    #   resp.bundle_task.bundle_task_error.message #=> String
    #   resp.bundle_task.instance_id #=> String
    #   resp.bundle_task.progress #=> String
    #   resp.bundle_task.start_time #=> Time
    #   resp.bundle_task.state #=> String, one of "pending", "waiting-for-shutdown", "bundling", "storing", "cancelling", "complete", "failed"
    #   resp.bundle_task.storage.s3.aws_access_key_id #=> String
    #   resp.bundle_task.storage.s3.bucket #=> String
    #   resp.bundle_task.storage.s3.prefix #=> String
    #   resp.bundle_task.storage.s3.upload_policy #=> String
    #   resp.bundle_task.storage.s3.upload_policy_signature #=> String
    #   resp.bundle_task.update_time #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstance AWS API Documentation
    #
    # @overload bundle_instance(params = {})
    # @param [Hash] params ({})
    def bundle_instance(params = {}, options = {})
      req = build_request(:bundle_instance, params)
      req.send_request(options)
    end

    # Cancels a bundling operation for an instance store-backed Windows
    # instance.
    #
    # @option params [required, String] :bundle_id
    #   The ID of the bundle task.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CancelBundleTaskResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CancelBundleTaskResult#bundle_task #bundle_task} => Types::BundleTask
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_bundle_task({
    #     bundle_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.bundle_task.bundle_id #=> String
    #   resp.bundle_task.bundle_task_error.code #=> String
    #   resp.bundle_task.bundle_task_error.message #=> String
    #   resp.bundle_task.instance_id #=> String
    #   resp.bundle_task.progress #=> String
    #   resp.bundle_task.start_time #=> Time
    #   resp.bundle_task.state #=> String, one of "pending", "waiting-for-shutdown", "bundling", "storing", "cancelling", "complete", "failed"
    #   resp.bundle_task.storage.s3.aws_access_key_id #=> String
    #   resp.bundle_task.storage.s3.bucket #=> String
    #   resp.bundle_task.storage.s3.prefix #=> String
    #   resp.bundle_task.storage.s3.upload_policy #=> String
    #   resp.bundle_task.storage.s3.upload_policy_signature #=> String
    #   resp.bundle_task.update_time #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTask AWS API Documentation
    #
    # @overload cancel_bundle_task(params = {})
    # @param [Hash] params ({})
    def cancel_bundle_task(params = {}, options = {})
      req = build_request(:cancel_bundle_task, params)
      req.send_request(options)
    end

    # Cancels the specified Capacity Reservation, releases the reserved
    # capacity, and changes the Capacity Reservation's state to
    # `cancelled`.
    #
    # Instances running in the reserved capacity continue running until you
    # stop them. Stopped instances that target the Capacity Reservation can
    # no longer launch. Modify these instances to either target a different
    # Capacity Reservation, launch On-Demand Instance capacity, or run in
    # any open Capacity Reservation that has matching attributes and
    # sufficient capacity.
    #
    # @option params [required, String] :capacity_reservation_id
    #   The ID of the Capacity Reservation to be cancelled.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CancelCapacityReservationResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CancelCapacityReservationResult#return #return} => Boolean
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_capacity_reservation({
    #     capacity_reservation_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.return #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservation AWS API Documentation
    #
    # @overload cancel_capacity_reservation(params = {})
    # @param [Hash] params ({})
    def cancel_capacity_reservation(params = {}, options = {})
      req = build_request(:cancel_capacity_reservation, params)
      req.send_request(options)
    end

    # Cancels an active conversion task. The task can be the import of an
    # instance or volume. The action removes all artifacts of the
    # conversion, including a partially uploaded volume or instance. If the
    # conversion is complete or is in the process of transferring the final
    # disk image, the command fails and returns an exception.
    #
    # For more information, see [Importing a Virtual Machine Using the
    # Amazon EC2 CLI][1].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html
    #
    # @option params [required, String] :conversion_task_id
    #   The ID of the conversion task.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :reason_message
    #   The reason for canceling the conversion task.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_conversion_task({
    #     conversion_task_id: "String", # required
    #     dry_run: false,
    #     reason_message: "String",
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelConversionTask AWS API Documentation
    #
    # @overload cancel_conversion_task(params = {})
    # @param [Hash] params ({})
    def cancel_conversion_task(params = {}, options = {})
      req = build_request(:cancel_conversion_task, params)
      req.send_request(options)
    end

    # Cancels an active export task. The request removes all artifacts of
    # the export, including any partially-created Amazon S3 objects. If the
    # export task is complete or is in the process of transferring the final
    # disk image, the command fails and returns an error.
    #
    # @option params [required, String] :export_task_id
    #   The ID of the export task. This is the ID returned by
    #   `CreateInstanceExportTask`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_export_task({
    #     export_task_id: "String", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelExportTask AWS API Documentation
    #
    # @overload cancel_export_task(params = {})
    # @param [Hash] params ({})
    def cancel_export_task(params = {}, options = {})
      req = build_request(:cancel_export_task, params)
      req.send_request(options)
    end

    # Cancels an in-process import virtual machine or import snapshot task.
    #
    # @option params [String] :cancel_reason
    #   The reason for canceling the task.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :import_task_id
    #   The ID of the import image or import snapshot task to be canceled.
    #
    # @return [Types::CancelImportTaskResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CancelImportTaskResult#import_task_id #import_task_id} => String
    #   * {Types::CancelImportTaskResult#previous_state #previous_state} => String
    #   * {Types::CancelImportTaskResult#state #state} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_import_task({
    #     cancel_reason: "String",
    #     dry_run: false,
    #     import_task_id: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.import_task_id #=> String
    #   resp.previous_state #=> String
    #   resp.state #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTask AWS API Documentation
    #
    # @overload cancel_import_task(params = {})
    # @param [Hash] params ({})
    def cancel_import_task(params = {}, options = {})
      req = build_request(:cancel_import_task, params)
      req.send_request(options)
    end

    # Cancels the specified Reserved Instance listing in the Reserved
    # Instance Marketplace.
    #
    # For more information, see [Reserved Instance Marketplace][1] in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html
    #
    # @option params [required, String] :reserved_instances_listing_id
    #   The ID of the Reserved Instance listing.
    #
    # @return [Types::CancelReservedInstancesListingResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CancelReservedInstancesListingResult#reserved_instances_listings #reserved_instances_listings} => Array&lt;Types::ReservedInstancesListing&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_reserved_instances_listing({
    #     reserved_instances_listing_id: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.reserved_instances_listings #=> Array
    #   resp.reserved_instances_listings[0].client_token #=> String
    #   resp.reserved_instances_listings[0].create_date #=> Time
    #   resp.reserved_instances_listings[0].instance_counts #=> Array
    #   resp.reserved_instances_listings[0].instance_counts[0].instance_count #=> Integer
    #   resp.reserved_instances_listings[0].instance_counts[0].state #=> String, one of "available", "sold", "cancelled", "pending"
    #   resp.reserved_instances_listings[0].price_schedules #=> Array
    #   resp.reserved_instances_listings[0].price_schedules[0].active #=> Boolean
    #   resp.reserved_instances_listings[0].price_schedules[0].currency_code #=> String, one of "USD"
    #   resp.reserved_instances_listings[0].price_schedules[0].price #=> Float
    #   resp.reserved_instances_listings[0].price_schedules[0].term #=> Integer
    #   resp.reserved_instances_listings[0].reserved_instances_id #=> String
    #   resp.reserved_instances_listings[0].reserved_instances_listing_id #=> String
    #   resp.reserved_instances_listings[0].status #=> String, one of "active", "pending", "cancelled", "closed"
    #   resp.reserved_instances_listings[0].status_message #=> String
    #   resp.reserved_instances_listings[0].tags #=> Array
    #   resp.reserved_instances_listings[0].tags[0].key #=> String
    #   resp.reserved_instances_listings[0].tags[0].value #=> String
    #   resp.reserved_instances_listings[0].update_date #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelReservedInstancesListing AWS API Documentation
    #
    # @overload cancel_reserved_instances_listing(params = {})
    # @param [Hash] params ({})
    def cancel_reserved_instances_listing(params = {}, options = {})
      req = build_request(:cancel_reserved_instances_listing, params)
      req.send_request(options)
    end

    # Cancels the specified Spot Fleet requests.
    #
    # After you cancel a Spot Fleet request, the Spot Fleet launches no new
    # Spot Instances. You must specify whether the Spot Fleet should also
    # terminate its Spot Instances. If you terminate the instances, the Spot
    # Fleet request enters the `cancelled_terminating` state. Otherwise, the
    # Spot Fleet request enters the `cancelled_running` state and the
    # instances continue to run until they are interrupted or you terminate
    # them manually.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :spot_fleet_request_ids
    #   The IDs of the Spot Fleet requests.
    #
    # @option params [required, Boolean] :terminate_instances
    #   Indicates whether to terminate instances for a Spot Fleet request if
    #   it is canceled successfully.
    #
    # @return [Types::CancelSpotFleetRequestsResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CancelSpotFleetRequestsResponse#successful_fleet_requests #successful_fleet_requests} => Array&lt;Types::CancelSpotFleetRequestsSuccessItem&gt;
    #   * {Types::CancelSpotFleetRequestsResponse#unsuccessful_fleet_requests #unsuccessful_fleet_requests} => Array&lt;Types::CancelSpotFleetRequestsErrorItem&gt;
    #
    #
    # @example Example: To cancel a Spot fleet request
    #
    #   # This example cancels the specified Spot fleet request and terminates its associated Spot Instances.
    #
    #   resp = client.cancel_spot_fleet_requests({
    #     spot_fleet_request_ids: [
    #       "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE", 
    #     ], 
    #     terminate_instances: true, 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     successful_fleet_requests: [
    #       {
    #         current_spot_fleet_request_state: "cancelled_running", 
    #         previous_spot_fleet_request_state: "active", 
    #         spot_fleet_request_id: "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Example: To cancel a Spot fleet request without terminating its Spot Instances
    #
    #   # This example cancels the specified Spot fleet request without terminating its associated Spot Instances.
    #
    #   resp = client.cancel_spot_fleet_requests({
    #     spot_fleet_request_ids: [
    #       "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE", 
    #     ], 
    #     terminate_instances: false, 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     successful_fleet_requests: [
    #       {
    #         current_spot_fleet_request_state: "cancelled_terminating", 
    #         previous_spot_fleet_request_state: "active", 
    #         spot_fleet_request_id: "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_spot_fleet_requests({
    #     dry_run: false,
    #     spot_fleet_request_ids: ["String"], # required
    #     terminate_instances: false, # required
    #   })
    #
    # @example Response structure
    #
    #   resp.successful_fleet_requests #=> Array
    #   resp.successful_fleet_requests[0].current_spot_fleet_request_state #=> String, one of "submitted", "active", "cancelled", "failed", "cancelled_running", "cancelled_terminating", "modifying"
    #   resp.successful_fleet_requests[0].previous_spot_fleet_request_state #=> String, one of "submitted", "active", "cancelled", "failed", "cancelled_running", "cancelled_terminating", "modifying"
    #   resp.successful_fleet_requests[0].spot_fleet_request_id #=> String
    #   resp.unsuccessful_fleet_requests #=> Array
    #   resp.unsuccessful_fleet_requests[0].error.code #=> String, one of "fleetRequestIdDoesNotExist", "fleetRequestIdMalformed", "fleetRequestNotInCancellableState", "unexpectedError"
    #   resp.unsuccessful_fleet_requests[0].error.message #=> String
    #   resp.unsuccessful_fleet_requests[0].spot_fleet_request_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequests AWS API Documentation
    #
    # @overload cancel_spot_fleet_requests(params = {})
    # @param [Hash] params ({})
    def cancel_spot_fleet_requests(params = {}, options = {})
      req = build_request(:cancel_spot_fleet_requests, params)
      req.send_request(options)
    end

    # Cancels one or more Spot Instance requests.
    #
    # Canceling a Spot Instance request does not terminate running Spot
    # Instances associated with the request.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :spot_instance_request_ids
    #   One or more Spot Instance request IDs.
    #
    # @return [Types::CancelSpotInstanceRequestsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CancelSpotInstanceRequestsResult#cancelled_spot_instance_requests #cancelled_spot_instance_requests} => Array&lt;Types::CancelledSpotInstanceRequest&gt;
    #
    #
    # @example Example: To cancel Spot Instance requests
    #
    #   # This example cancels a Spot Instance request.
    #
    #   resp = client.cancel_spot_instance_requests({
    #     spot_instance_request_ids: [
    #       "sir-08b93456", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     cancelled_spot_instance_requests: [
    #       {
    #         spot_instance_request_id: "sir-08b93456", 
    #         state: "cancelled", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_spot_instance_requests({
    #     dry_run: false,
    #     spot_instance_request_ids: ["String"], # required
    #   })
    #
    # @example Response structure
    #
    #   resp.cancelled_spot_instance_requests #=> Array
    #   resp.cancelled_spot_instance_requests[0].spot_instance_request_id #=> String
    #   resp.cancelled_spot_instance_requests[0].state #=> String, one of "active", "open", "closed", "cancelled", "completed"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotInstanceRequests AWS API Documentation
    #
    # @overload cancel_spot_instance_requests(params = {})
    # @param [Hash] params ({})
    def cancel_spot_instance_requests(params = {}, options = {})
      req = build_request(:cancel_spot_instance_requests, params)
      req.send_request(options)
    end

    # Determines whether a product code is associated with an instance. This
    # action can only be used by the owner of the product code. It is useful
    # when a product code owner must verify whether another user's instance
    # is eligible for support.
    #
    # @option params [required, String] :instance_id
    #   The ID of the instance.
    #
    # @option params [required, String] :product_code
    #   The product code. This must be a product code that you own.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::ConfirmProductInstanceResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ConfirmProductInstanceResult#owner_id #owner_id} => String
    #   * {Types::ConfirmProductInstanceResult#return #return} => Boolean
    #
    #
    # @example Example: To confirm the product instance
    #
    #   # This example determines whether the specified product code is associated with the specified instance.
    #
    #   resp = client.confirm_product_instance({
    #     instance_id: "i-1234567890abcdef0", 
    #     product_code: "774F4FF8", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     owner_id: "123456789012", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.confirm_product_instance({
    #     instance_id: "String", # required
    #     product_code: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.owner_id #=> String
    #   resp.return #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConfirmProductInstance AWS API Documentation
    #
    # @overload confirm_product_instance(params = {})
    # @param [Hash] params ({})
    def confirm_product_instance(params = {}, options = {})
      req = build_request(:confirm_product_instance, params)
      req.send_request(options)
    end

    # Copies the specified Amazon FPGA Image (AFI) to the current Region.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :source_fpga_image_id
    #   The ID of the source AFI.
    #
    # @option params [String] :description
    #   The description for the new AFI.
    #
    # @option params [String] :name
    #   The name for the new AFI. The default is the name of the source AFI.
    #
    # @option params [required, String] :source_region
    #   The Region that contains the source AFI.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html
    #
    # @return [Types::CopyFpgaImageResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CopyFpgaImageResult#fpga_image_id #fpga_image_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.copy_fpga_image({
    #     dry_run: false,
    #     source_fpga_image_id: "String", # required
    #     description: "String",
    #     name: "String",
    #     source_region: "String", # required
    #     client_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.fpga_image_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyFpgaImage AWS API Documentation
    #
    # @overload copy_fpga_image(params = {})
    # @param [Hash] params ({})
    def copy_fpga_image(params = {}, options = {})
      req = build_request(:copy_fpga_image, params)
      req.send_request(options)
    end

    # Initiates the copy of an AMI from the specified source Region to the
    # current Region. You specify the destination Region by using its
    # endpoint when making the request.
    #
    # Copies of encrypted backing snapshots for the AMI are encrypted.
    # Copies of unencrypted backing snapshots remain unencrypted, unless you
    # set `Encrypted` during the copy operation. You cannot create an
    # unencrypted copy of an encrypted backing snapshot.
    #
    # For more information about the prerequisites and limits when copying
    # an AMI, see [Copying an AMI][1] in the *Amazon Elastic Compute Cloud
    # User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier you provide to ensure idempotency of
    #   the request. For more information, see [How to Ensure Idempotency][1]
    #   in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html
    #
    # @option params [String] :description
    #   A description for the new AMI in the destination Region.
    #
    # @option params [Boolean] :encrypted
    #   Specifies whether the destination snapshots of the copied image should
    #   be encrypted. You can encrypt a copy of an unencrypted snapshot, but
    #   you cannot create an unencrypted copy of an encrypted snapshot. The
    #   default CMK for EBS is used unless you specify a non-default AWS Key
    #   Management Service (AWS KMS) CMK using `KmsKeyId`. For more
    #   information, see [Amazon EBS Encryption][1] in the *Amazon Elastic
    #   Compute Cloud User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html
    #
    # @option params [String] :kms_key_id
    #   An identifier for the AWS Key Management Service (AWS KMS) customer
    #   master key (CMK) to use when creating the encrypted volume. This
    #   parameter is only required if you want to use a non-default CMK; if
    #   this parameter is not specified, the default CMK for EBS is used. If a
    #   `KmsKeyId` is specified, the `Encrypted` flag must also be set.
    #
    #   To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
    #   name, or alias ARN. When using an alias name, prefix it with
    #   "alias/". For example:
    #
    #   * Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
    #
    #   * Key ARN:
    #     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
    #
    #   * Alias name: `alias/ExampleAlias`
    #
    #   * Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
    #
    #   AWS parses `KmsKeyId` asynchronously, meaning that the action you call
    #   may appear to complete even though you provided an invalid identifier.
    #   This action will eventually report failure.
    #
    #   The specified CMK must exist in the Region that the snapshot is being
    #   copied to.
    #
    # @option params [required, String] :name
    #   The name of the new AMI in the destination Region.
    #
    # @option params [required, String] :source_image_id
    #   The ID of the AMI to copy.
    #
    # @option params [required, String] :source_region
    #   The name of the Region that contains the AMI to copy.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CopyImageResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CopyImageResult#image_id #image_id} => String
    #
    #
    # @example Example: To copy an AMI to another region
    #
    #   # This example copies the specified AMI from the us-east-1 region to the current region.
    #
    #   resp = client.copy_image({
    #     description: "", 
    #     name: "My server", 
    #     source_image_id: "ami-5731123e", 
    #     source_region: "us-east-1", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     image_id: "ami-438bea42", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.copy_image({
    #     client_token: "String",
    #     description: "String",
    #     encrypted: false,
    #     kms_key_id: "String",
    #     name: "String", # required
    #     source_image_id: "String", # required
    #     source_region: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.image_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyImage AWS API Documentation
    #
    # @overload copy_image(params = {})
    # @param [Hash] params ({})
    def copy_image(params = {}, options = {})
      req = build_request(:copy_image, params)
      req.send_request(options)
    end

    # Copies a point-in-time snapshot of an EBS volume and stores it in
    # Amazon S3. You can copy the snapshot within the same Region or from
    # one Region to another. You can use the snapshot to create EBS volumes
    # or Amazon Machine Images (AMIs).
    #
    # Copies of encrypted EBS snapshots remain encrypted. Copies of
    # unencrypted snapshots remain unencrypted, unless you enable encryption
    # for the snapshot copy operation. By default, encrypted snapshot copies
    # use the default AWS Key Management Service (AWS KMS) customer master
    # key (CMK); however, you can specify a different CMK.
    #
    # To copy an encrypted snapshot that has been shared from another
    # account, you must have permissions for the CMK used to encrypt the
    # snapshot.
    #
    # Snapshots created by copying another snapshot have an arbitrary volume
    # ID that should not be used for any purpose.
    #
    # For more information, see [Copying an Amazon EBS Snapshot][1] in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-copy-snapshot.html
    #
    # @option params [String] :description
    #   A description for the EBS snapshot.
    #
    # @option params [String] :destination_region
    #   The destination Region to use in the `PresignedUrl` parameter of a
    #   snapshot copy operation. This parameter is only valid for specifying
    #   the destination Region in a `PresignedUrl` parameter, where it is
    #   required.
    #
    #   The snapshot copy is sent to the regional endpoint that you sent the
    #   HTTP request to (for example, `ec2.us-east-1.amazonaws.com`). With the
    #   AWS CLI, this is specified using the `--region` parameter or the
    #   default Region in your AWS configuration file.
    #
    # @option params [Boolean] :encrypted
    #   To encrypt a copy of an unencrypted snapshot if encryption by default
    #   is not enabled, enable encryption using this parameter. Otherwise,
    #   omit this parameter. Encrypted snapshots are encrypted, even if you
    #   omit this parameter and encryption by default is not enabled. You
    #   cannot set this parameter to false. For more information, see [Amazon
    #   EBS Encryption][1] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html
    #
    # @option params [String] :kms_key_id
    #   The identifier of the AWS Key Management Service (AWS KMS) customer
    #   master key (CMK) to use for Amazon EBS encryption. If this parameter
    #   is not specified, your AWS managed CMK for EBS is used. If `KmsKeyId`
    #   is specified, the encrypted state must be `true`.
    #
    #   You can specify the CMK using any of the following:
    #
    #   * Key ID. For example, key/1234abcd-12ab-34cd-56ef-1234567890ab.
    #
    #   * Key alias. For example, alias/ExampleAlias.
    #
    #   * Key ARN. For example,
    #     arn:aws:kms:*us-east-1*\:*012345678910*\:key/*abcd1234-a123-456a-a12b-a123b4cd56ef*.
    #
    #   * Alias ARN. For example,
    #     arn:aws:kms:*us-east-1*\:*012345678910*\:alias/*ExampleAlias*.
    #
    #   AWS authenticates the CMK asynchronously. Therefore, if you specify an
    #   ID, alias, or ARN that is not valid, the action can appear to
    #   complete, but eventually fails.
    #
    # @option params [String] :presigned_url
    #   When you copy an encrypted source snapshot using the Amazon EC2 Query
    #   API, you must supply a pre-signed URL. This parameter is optional for
    #   unencrypted snapshots. For more information, see [Query Requests][1].
    #
    #   The `PresignedUrl` should use the snapshot source endpoint, the
    #   `CopySnapshot` action, and include the `SourceRegion`,
    #   `SourceSnapshotId`, and `DestinationRegion` parameters. The
    #   `PresignedUrl` must be signed using AWS Signature Version 4. Because
    #   EBS snapshots are stored in Amazon S3, the signing algorithm for this
    #   parameter uses the same logic that is described in [Authenticating
    #   Requests by Using Query Parameters (AWS Signature Version 4)][2] in
    #   the *Amazon Simple Storage Service API Reference*. An invalid or
    #   improperly signed `PresignedUrl` will cause the copy operation to fail
    #   asynchronously, and the snapshot will move to an `error` state.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html
    #   [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html
    #
    # @option params [required, String] :source_region
    #   The ID of the Region that contains the snapshot to be copied.
    #
    # @option params [required, String] :source_snapshot_id
    #   The ID of the EBS snapshot to copy.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CopySnapshotResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CopySnapshotResult#snapshot_id #snapshot_id} => String
    #
    #
    # @example Example: To copy a snapshot
    #
    #   # This example copies a snapshot with the snapshot ID of ``snap-066877671789bd71b`` from the ``us-west-2`` region to the
    #   # ``us-east-1`` region and adds a short description to identify the snapshot.
    #
    #   resp = client.copy_snapshot({
    #     description: "This is my copied snapshot.", 
    #     destination_region: "us-east-1", 
    #     source_region: "us-west-2", 
    #     source_snapshot_id: "snap-066877671789bd71b", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     snapshot_id: "snap-066877671789bd71b", 
    #   }
    #
    # @example Copy snapshot example
    #   source_snapshot_id = 'snapshot-id'
    #   source_region = 'us-east-1'
    #   target_region = 'us-west-2'
    #
    #   # You must configure your EC2 client for the destination region to copy
    #   ec2 = Aws::EC2::Client(region: target_region)
    #
    #   resp = ec2.copy_snapshot({
    #       source_region: source_region,
    #       source_snapshot_id: source_snapshot_id,
    #   })
    #
    #   snapshot_id = resp.snapshot_id
    #
    #   ec2.wait_until(:snapshot_completed, snapshot_ids: [snapshot_id])
    #
    # @example Copy an encrypted snapshot
    #   # same as above, expect you must pass `encrypted: true`
    #   resp = ec2.copy_snapshot({
    #       source_region: source_region,
    #       source_snapshot_id: source_snapshot_id,
    #       encrypted: true, # required for encrypted snapshots
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.copy_snapshot({
    #     description: "String",
    #     destination_region: "String",
    #     encrypted: false,
    #     kms_key_id: "String",
    #     presigned_url: "String",
    #     source_region: "String", # required
    #     source_snapshot_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.snapshot_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshot AWS API Documentation
    #
    # @overload copy_snapshot(params = {})
    # @param [Hash] params ({})
    def copy_snapshot(params = {}, options = {})
      req = build_request(:copy_snapshot, params)
      req.send_request(options)
    end

    # Creates a new Capacity Reservation with the specified attributes.
    #
    # Capacity Reservations enable you to reserve capacity for your Amazon
    # EC2 instances in a specific Availability Zone for any duration. This
    # gives you the flexibility to selectively add capacity reservations and
    # still get the Regional RI discounts for that usage. By creating
    # Capacity Reservations, you ensure that you always have access to
    # Amazon EC2 capacity when you need it, for as long as you need it. For
    # more information, see [Capacity Reservations][1] in the *Amazon
    # Elastic Compute Cloud User Guide*.
    #
    # Your request to create a Capacity Reservation could fail if Amazon EC2
    # does not have sufficient capacity to fulfill the request. If your
    # request fails due to Amazon EC2 capacity constraints, either try again
    # at a later time, try in a different Availability Zone, or request a
    # smaller capacity reservation. If your application is flexible across
    # instance types and sizes, try to create a Capacity Reservation with
    # different instance attributes.
    #
    # Your request could also fail if the requested quantity exceeds your
    # On-Demand Instance limit for the selected instance type. If your
    # request fails due to limit constraints, increase your On-Demand
    # Instance limit for the required instance type and try again. For more
    # information about increasing your instance limits, see [Amazon EC2
    # Service Limits][2] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   Constraint: Maximum 64 ASCII characters.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [required, String] :instance_type
    #   The instance type for which to reserve capacity. For more information,
    #   see [Instance Types][1] in the *Amazon Elastic Compute Cloud User
    #   Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html
    #
    # @option params [required, String] :instance_platform
    #   The type of operating system for which to reserve capacity.
    #
    # @option params [String] :availability_zone
    #   The Availability Zone in which to create the Capacity Reservation.
    #
    # @option params [String] :availability_zone_id
    #   The ID of the Availability Zone in which to create the Capacity
    #   Reservation.
    #
    # @option params [String] :tenancy
    #   Indicates the tenancy of the Capacity Reservation. A Capacity
    #   Reservation can have one of the following tenancy settings:
    #
    #   * `default` - The Capacity Reservation is created on hardware that is
    #     shared with other AWS accounts.
    #
    #   * `dedicated` - The Capacity Reservation is created on single-tenant
    #     hardware that is dedicated to a single AWS account.
    #
    # @option params [required, Integer] :instance_count
    #   The number of instances for which to reserve capacity.
    #
    # @option params [Boolean] :ebs_optimized
    #   Indicates whether the Capacity Reservation supports EBS-optimized
    #   instances. This optimization provides dedicated throughput to Amazon
    #   EBS and an optimized configuration stack to provide optimal I/O
    #   performance. This optimization isn't available with all instance
    #   types. Additional usage charges apply when using an EBS- optimized
    #   instance.
    #
    # @option params [Boolean] :ephemeral_storage
    #   Indicates whether the Capacity Reservation supports instances with
    #   temporary, block-level storage.
    #
    # @option params [Time,DateTime,Date,Integer,String] :end_date
    #   The date and time at which the Capacity Reservation expires. When a
    #   Capacity Reservation expires, the reserved capacity is released and
    #   you can no longer launch instances into it. The Capacity
    #   Reservation's state changes to `expired` when it reaches its end date
    #   and time.
    #
    #   You must provide an `EndDate` value if `EndDateType` is `limited`.
    #   Omit `EndDate` if `EndDateType` is `unlimited`.
    #
    #   If the `EndDateType` is `limited`, the Capacity Reservation is
    #   cancelled within an hour from the specified time. For example, if you
    #   specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to
    #   end between 13:30:55 and 14:30:55 on 5/31/2019.
    #
    # @option params [String] :end_date_type
    #   Indicates the way in which the Capacity Reservation ends. A Capacity
    #   Reservation can have one of the following end types:
    #
    #   * `unlimited` - The Capacity Reservation remains active until you
    #     explicitly cancel it. Do not provide an `EndDate` if the
    #     `EndDateType` is `unlimited`.
    #
    #   * `limited` - The Capacity Reservation expires automatically at a
    #     specified date and time. You must provide an `EndDate` value if the
    #     `EndDateType` value is `limited`.
    #
    # @option params [String] :instance_match_criteria
    #   Indicates the type of instance launches that the Capacity Reservation
    #   accepts. The options include:
    #
    #   * `open` - The Capacity Reservation automatically matches all
    #     instances that have matching attributes (instance type, platform,
    #     and Availability Zone). Instances that have matching attributes run
    #     in the Capacity Reservation automatically without specifying any
    #     additional parameters.
    #
    #   * `targeted` - The Capacity Reservation only accepts instances that
    #     have matching attributes (instance type, platform, and Availability
    #     Zone), and explicitly target the Capacity Reservation. This ensures
    #     that only permitted instances can use the reserved capacity.
    #
    #   Default: `open`
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the Capacity Reservation during launch.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateCapacityReservationResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateCapacityReservationResult#capacity_reservation #capacity_reservation} => Types::CapacityReservation
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_capacity_reservation({
    #     client_token: "String",
    #     instance_type: "String", # required
    #     instance_platform: "Linux/UNIX", # required, accepts Linux/UNIX, Red Hat Enterprise Linux, SUSE Linux, Windows, Windows with SQL Server, Windows with SQL Server Enterprise, Windows with SQL Server Standard, Windows with SQL Server Web, Linux with SQL Server Standard, Linux with SQL Server Web, Linux with SQL Server Enterprise
    #     availability_zone: "String",
    #     availability_zone_id: "String",
    #     tenancy: "default", # accepts default, dedicated
    #     instance_count: 1, # required
    #     ebs_optimized: false,
    #     ephemeral_storage: false,
    #     end_date: Time.now,
    #     end_date_type: "unlimited", # accepts unlimited, limited
    #     instance_match_criteria: "open", # accepts open, targeted
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, elastic-ip, fleet, fpga-image, host-reservation, image, instance, internet-gateway, launch-template, natgateway, network-acl, network-interface, reserved-instances, route-table, security-group, snapshot, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.capacity_reservation.capacity_reservation_id #=> String
    #   resp.capacity_reservation.owner_id #=> String
    #   resp.capacity_reservation.capacity_reservation_arn #=> String
    #   resp.capacity_reservation.availability_zone_id #=> String
    #   resp.capacity_reservation.instance_type #=> String
    #   resp.capacity_reservation.instance_platform #=> String, one of "Linux/UNIX", "Red Hat Enterprise Linux", "SUSE Linux", "Windows", "Windows with SQL Server", "Windows with SQL Server Enterprise", "Windows with SQL Server Standard", "Windows with SQL Server Web", "Linux with SQL Server Standard", "Linux with SQL Server Web", "Linux with SQL Server Enterprise"
    #   resp.capacity_reservation.availability_zone #=> String
    #   resp.capacity_reservation.tenancy #=> String, one of "default", "dedicated"
    #   resp.capacity_reservation.total_instance_count #=> Integer
    #   resp.capacity_reservation.available_instance_count #=> Integer
    #   resp.capacity_reservation.ebs_optimized #=> Boolean
    #   resp.capacity_reservation.ephemeral_storage #=> Boolean
    #   resp.capacity_reservation.state #=> String, one of "active", "expired", "cancelled", "pending", "failed"
    #   resp.capacity_reservation.end_date #=> Time
    #   resp.capacity_reservation.end_date_type #=> String, one of "unlimited", "limited"
    #   resp.capacity_reservation.instance_match_criteria #=> String, one of "open", "targeted"
    #   resp.capacity_reservation.create_date #=> Time
    #   resp.capacity_reservation.tags #=> Array
    #   resp.capacity_reservation.tags[0].key #=> String
    #   resp.capacity_reservation.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservation AWS API Documentation
    #
    # @overload create_capacity_reservation(params = {})
    # @param [Hash] params ({})
    def create_capacity_reservation(params = {}, options = {})
      req = build_request(:create_capacity_reservation, params)
      req.send_request(options)
    end

    # Creates a Client VPN endpoint. A Client VPN endpoint is the resource
    # you create and configure to enable and manage client VPN sessions. It
    # is the destination endpoint at which all client VPN sessions are
    # terminated.
    #
    # @option params [required, String] :client_cidr_block
    #   The IPv4 address range, in CIDR notation, from which to assign client
    #   IP addresses. The address range cannot overlap with the local CIDR of
    #   the VPC in which the associated subnet is located, or the routes that
    #   you add manually. The address range cannot be changed after the Client
    #   VPN endpoint has been created. The CIDR block should be /22 or
    #   greater.
    #
    # @option params [required, String] :server_certificate_arn
    #   The ARN of the server certificate. For more information, see the [AWS
    #   Certificate Manager User Guide][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/acm/latest/userguide/
    #
    # @option params [required, Array<Types::ClientVpnAuthenticationRequest>] :authentication_options
    #   Information about the authentication method to be used to authenticate
    #   clients.
    #
    # @option params [required, Types::ConnectionLogOptions] :connection_log_options
    #   Information about the client connection logging options.
    #
    #   If you enable client connection logging, data about client connections
    #   is sent to a Cloudwatch Logs log stream. The following information is
    #   logged:
    #
    #   * Client connection requests
    #
    #   * Client connection results (successful and unsuccessful)
    #
    #   * Reasons for unsuccessful client connection requests
    #
    #   * Client connection termination time
    #
    # @option params [Array<String>] :dns_servers
    #   Information about the DNS servers to be used for DNS resolution. A
    #   Client VPN endpoint can have up to two DNS servers. If no DNS server
    #   is specified, the DNS address configured on the device is used for the
    #   DNS server.
    #
    # @option params [String] :transport_protocol
    #   The transport protocol to be used by the VPN session.
    #
    #   Default value: `udp`
    #
    # @option params [String] :description
    #   A brief description of the Client VPN endpoint.
    #
    # @option params [Boolean] :split_tunnel
    #   Indicates whether split-tunnel is enabled on the AWS Client VPN
    #   endpoint.
    #
    #   By default, split-tunnel on a VPN endpoint is disabled.
    #
    #   For information about split-tunnel VPN endpoints, see [Split-Tunnel
    #   AWS Client VPN Endpoint][1] in the *AWS Client VPN Administrator
    #   Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the Client VPN endpoint during creation.
    #
    # @return [Types::CreateClientVpnEndpointResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateClientVpnEndpointResult#client_vpn_endpoint_id #client_vpn_endpoint_id} => String
    #   * {Types::CreateClientVpnEndpointResult#status #status} => Types::ClientVpnEndpointStatus
    #   * {Types::CreateClientVpnEndpointResult#dns_name #dns_name} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_client_vpn_endpoint({
    #     client_cidr_block: "String", # required
    #     server_certificate_arn: "String", # required
    #     authentication_options: [ # required
    #       {
    #         type: "certificate-authentication", # accepts certificate-authentication, directory-service-authentication
    #         active_directory: {
    #           directory_id: "String",
    #         },
    #         mutual_authentication: {
    #           client_root_certificate_chain_arn: "String",
    #         },
    #       },
    #     ],
    #     connection_log_options: { # required
    #       enabled: false,
    #       cloudwatch_log_group: "String",
    #       cloudwatch_log_stream: "String",
    #     },
    #     dns_servers: ["String"],
    #     transport_protocol: "tcp", # accepts tcp, udp
    #     description: "String",
    #     split_tunnel: false,
    #     dry_run: false,
    #     client_token: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, elastic-ip, fleet, fpga-image, host-reservation, image, instance, internet-gateway, launch-template, natgateway, network-acl, network-interface, reserved-instances, route-table, security-group, snapshot, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.client_vpn_endpoint_id #=> String
    #   resp.status.code #=> String, one of "pending-associate", "available", "deleting", "deleted"
    #   resp.status.message #=> String
    #   resp.dns_name #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnEndpoint AWS API Documentation
    #
    # @overload create_client_vpn_endpoint(params = {})
    # @param [Hash] params ({})
    def create_client_vpn_endpoint(params = {}, options = {})
      req = build_request(:create_client_vpn_endpoint, params)
      req.send_request(options)
    end

    # Adds a route to a network to a Client VPN endpoint. Each Client VPN
    # endpoint has a route table that describes the available destination
    # network routes. Each route in the route table specifies the path for
    # traﬃc to speciﬁc resources or networks.
    #
    # @option params [required, String] :client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint to which to add the route.
    #
    # @option params [required, String] :destination_cidr_block
    #   The IPv4 address range, in CIDR notation, of the route destination.
    #   For example:
    #
    #   * To add a route for Internet access, enter `0.0.0.0/0`
    #
    #   * To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR
    #     range
    #
    #   * To add a route for an on-premises network, enter the AWS
    #     Site-to-Site VPN connection's IPv4 CIDR range
    #
    #   Route address ranges cannot overlap with the CIDR range specified for
    #   client allocation.
    #
    # @option params [required, String] :target_vpc_subnet_id
    #   The ID of the subnet through which you want to route traffic. The
    #   specified subnet must be an existing target network of the Client VPN
    #   endpoint.
    #
    # @option params [String] :description
    #   A brief description of the route.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateClientVpnRouteResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateClientVpnRouteResult#status #status} => Types::ClientVpnRouteStatus
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_client_vpn_route({
    #     client_vpn_endpoint_id: "String", # required
    #     destination_cidr_block: "String", # required
    #     target_vpc_subnet_id: "String", # required
    #     description: "String",
    #     client_token: "String",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.status.code #=> String, one of "creating", "active", "failed", "deleting"
    #   resp.status.message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnRoute AWS API Documentation
    #
    # @overload create_client_vpn_route(params = {})
    # @param [Hash] params ({})
    def create_client_vpn_route(params = {}, options = {})
      req = build_request(:create_client_vpn_route, params)
      req.send_request(options)
    end

    # Provides information to AWS about your VPN customer gateway device.
    # The customer gateway is the appliance at your end of the VPN
    # connection. (The device on the AWS side of the VPN connection is the
    # virtual private gateway.) You must provide the Internet-routable IP
    # address of the customer gateway's external interface. The IP address
    # must be static and can be behind a device performing network address
    # translation (NAT).
    #
    # For devices that use Border Gateway Protocol (BGP), you can also
    # provide the device's BGP Autonomous System Number (ASN). You can use
    # an existing ASN assigned to your network. If you don't have an ASN
    # already, you can use a private ASN (in the 64512 - 65534 range).
    #
    # <note markdown="1"> Amazon EC2 supports all 2-byte ASN numbers in the range of 1 - 65534,
    # with the exception of 7224, which is reserved in the `us-east-1`
    # Region, and 9059, which is reserved in the `eu-west-1` Region.
    #
    #  </note>
    #
    # For more information, see [AWS Site-to-Site VPN][1] in the *AWS
    # Site-to-Site VPN User Guide*.
    #
    # You cannot create more than one customer gateway with the same VPN
    # type, IP address, and BGP ASN parameter values. If you run an
    # identical request more than one time, the first request creates the
    # customer gateway, and subsequent requests return information about the
    # existing customer gateway. The subsequent requests do not create new
    # customer gateway resources.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html
    #
    # @option params [required, Integer] :bgp_asn
    #   For devices that support BGP, the customer gateway's BGP ASN.
    #
    #   Default: 65000
    #
    # @option params [String] :public_ip
    #   The Internet-routable IP address for the customer gateway's outside
    #   interface. The address must be static.
    #
    # @option params [String] :certificate_arn
    #   The Amazon Resource Name (ARN) for the customer gateway certificate.
    #
    # @option params [required, String] :type
    #   The type of VPN connection that this customer gateway supports
    #   (`ipsec.1`).
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateCustomerGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateCustomerGatewayResult#customer_gateway #customer_gateway} => Types::CustomerGateway
    #
    #
    # @example Example: To create a customer gateway
    #
    #   # This example creates a customer gateway with the specified IP address for its outside interface.
    #
    #   resp = client.create_customer_gateway({
    #     bgp_asn: 65534, 
    #     public_ip: "12.1.2.3", 
    #     type: "ipsec.1", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     customer_gateway: {
    #       bgp_asn: "65534", 
    #       customer_gateway_id: "cgw-0e11f167", 
    #       ip_address: "12.1.2.3", 
    #       state: "available", 
    #       type: "ipsec.1", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_customer_gateway({
    #     bgp_asn: 1, # required
    #     public_ip: "String",
    #     certificate_arn: "String",
    #     type: "ipsec.1", # required, accepts ipsec.1
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.customer_gateway.bgp_asn #=> String
    #   resp.customer_gateway.customer_gateway_id #=> String
    #   resp.customer_gateway.ip_address #=> String
    #   resp.customer_gateway.certificate_arn #=> String
    #   resp.customer_gateway.state #=> String
    #   resp.customer_gateway.type #=> String
    #   resp.customer_gateway.tags #=> Array
    #   resp.customer_gateway.tags[0].key #=> String
    #   resp.customer_gateway.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCustomerGateway AWS API Documentation
    #
    # @overload create_customer_gateway(params = {})
    # @param [Hash] params ({})
    def create_customer_gateway(params = {}, options = {})
      req = build_request(:create_customer_gateway, params)
      req.send_request(options)
    end

    # Creates a default subnet with a size `/20` IPv4 CIDR block in the
    # specified Availability Zone in your default VPC. You can have only one
    # default subnet per Availability Zone. For more information, see
    # [Creating a Default Subnet][1] in the *Amazon Virtual Private Cloud
    # User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html#create-default-subnet
    #
    # @option params [required, String] :availability_zone
    #   The Availability Zone in which to create the default subnet.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateDefaultSubnetResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateDefaultSubnetResult#subnet #subnet} => Types::Subnet
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_default_subnet({
    #     availability_zone: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.subnet.availability_zone #=> String
    #   resp.subnet.availability_zone_id #=> String
    #   resp.subnet.available_ip_address_count #=> Integer
    #   resp.subnet.cidr_block #=> String
    #   resp.subnet.default_for_az #=> Boolean
    #   resp.subnet.map_public_ip_on_launch #=> Boolean
    #   resp.subnet.state #=> String, one of "pending", "available"
    #   resp.subnet.subnet_id #=> String
    #   resp.subnet.vpc_id #=> String
    #   resp.subnet.owner_id #=> String
    #   resp.subnet.assign_ipv_6_address_on_creation #=> Boolean
    #   resp.subnet.ipv_6_cidr_block_association_set #=> Array
    #   resp.subnet.ipv_6_cidr_block_association_set[0].association_id #=> String
    #   resp.subnet.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block #=> String
    #   resp.subnet.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.subnet.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block_state.status_message #=> String
    #   resp.subnet.tags #=> Array
    #   resp.subnet.tags[0].key #=> String
    #   resp.subnet.tags[0].value #=> String
    #   resp.subnet.subnet_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultSubnet AWS API Documentation
    #
    # @overload create_default_subnet(params = {})
    # @param [Hash] params ({})
    def create_default_subnet(params = {}, options = {})
      req = build_request(:create_default_subnet, params)
      req.send_request(options)
    end

    # Creates a default VPC with a size `/16` IPv4 CIDR block and a default
    # subnet in each Availability Zone. For more information about the
    # components of a default VPC, see [Default VPC and Default Subnets][1]
    # in the *Amazon Virtual Private Cloud User Guide*. You cannot specify
    # the components of the default VPC yourself.
    #
    # If you deleted your previous default VPC, you can create a default
    # VPC. You cannot have more than one default VPC per Region.
    #
    # If your account supports EC2-Classic, you cannot use this action to
    # create a default VPC in a Region that supports EC2-Classic. If you
    # want a default VPC in a Region that supports EC2-Classic, see "I
    # really want a default VPC for my existing EC2 account. Is that
    # possible?" in the [Default VPCs FAQ][2].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html
    # [2]: http://aws.amazon.com/vpc/faqs/#Default_VPCs
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateDefaultVpcResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateDefaultVpcResult#vpc #vpc} => Types::Vpc
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_default_vpc({
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.vpc.cidr_block #=> String
    #   resp.vpc.dhcp_options_id #=> String
    #   resp.vpc.state #=> String, one of "pending", "available"
    #   resp.vpc.vpc_id #=> String
    #   resp.vpc.owner_id #=> String
    #   resp.vpc.instance_tenancy #=> String, one of "default", "dedicated", "host"
    #   resp.vpc.ipv_6_cidr_block_association_set #=> Array
    #   resp.vpc.ipv_6_cidr_block_association_set[0].association_id #=> String
    #   resp.vpc.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block #=> String
    #   resp.vpc.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.vpc.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block_state.status_message #=> String
    #   resp.vpc.cidr_block_association_set #=> Array
    #   resp.vpc.cidr_block_association_set[0].association_id #=> String
    #   resp.vpc.cidr_block_association_set[0].cidr_block #=> String
    #   resp.vpc.cidr_block_association_set[0].cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.vpc.cidr_block_association_set[0].cidr_block_state.status_message #=> String
    #   resp.vpc.is_default #=> Boolean
    #   resp.vpc.tags #=> Array
    #   resp.vpc.tags[0].key #=> String
    #   resp.vpc.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultVpc AWS API Documentation
    #
    # @overload create_default_vpc(params = {})
    # @param [Hash] params ({})
    def create_default_vpc(params = {}, options = {})
      req = build_request(:create_default_vpc, params)
      req.send_request(options)
    end

    # Creates a set of DHCP options for your VPC. After creating the set,
    # you must associate it with the VPC, causing all existing and new
    # instances that you launch in the VPC to use this set of DHCP options.
    # The following are the individual DHCP options you can specify. For
    # more information about the options, see [RFC 2132][1].
    #
    # * `domain-name-servers` - The IP addresses of up to four domain name
    #   servers, or AmazonProvidedDNS. The default DHCP option set specifies
    #   AmazonProvidedDNS. If specifying more than one domain name server,
    #   specify the IP addresses in a single parameter, separated by commas.
    #   To have your instance receive a custom DNS hostname as specified in
    #   `domain-name`, you must set `domain-name-servers` to a custom DNS
    #   server.
    #
    # * `domain-name` - If you're using AmazonProvidedDNS in `us-east-1`,
    #   specify `ec2.internal`. If you're using AmazonProvidedDNS in
    #   another Region, specify `region.compute.internal` (for example,
    #   `ap-northeast-1.compute.internal`). Otherwise, specify a domain name
    #   (for example, `MyCompany.com`). This value is used to complete
    #   unqualified DNS hostnames. **Important**\: Some Linux operating
    #   systems accept multiple domain names separated by spaces. However,
    #   Windows and other Linux operating systems treat the value as a
    #   single domain, which results in unexpected behavior. If your DHCP
    #   options set is associated with a VPC that has instances with
    #   multiple operating systems, specify only one domain name.
    #
    # * `ntp-servers` - The IP addresses of up to four Network Time Protocol
    #   (NTP) servers.
    #
    # * `netbios-name-servers` - The IP addresses of up to four NetBIOS name
    #   servers.
    #
    # * `netbios-node-type` - The NetBIOS node type (1, 2, 4, or 8). We
    #   recommend that you specify 2 (broadcast and multicast are not
    #   currently supported). For more information about these node types,
    #   see [RFC 2132][1].
    #
    # Your VPC automatically starts out with a set of DHCP options that
    # includes only a DNS server that we provide (AmazonProvidedDNS). If you
    # create a set of options, and if your VPC has an internet gateway, make
    # sure to set the `domain-name-servers` option either to
    # `AmazonProvidedDNS` or to a domain name server of your choice. For
    # more information, see [DHCP Options Sets][2] in the *Amazon Virtual
    # Private Cloud User Guide*.
    #
    #
    #
    # [1]: http://www.ietf.org/rfc/rfc2132.txt
    # [2]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html
    #
    # @option params [required, Array<Types::NewDhcpConfiguration>] :dhcp_configurations
    #   A DHCP configuration option.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateDhcpOptionsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateDhcpOptionsResult#dhcp_options #dhcp_options} => Types::DhcpOptions
    #
    #
    # @example Example: To create a DHCP options set
    #
    #   # This example creates a DHCP options set.
    #
    #   resp = client.create_dhcp_options({
    #     dhcp_configurations: [
    #       {
    #         key: "domain-name-servers", 
    #         values: [
    #           "10.2.5.1", 
    #           "10.2.5.2", 
    #         ], 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     dhcp_options: {
    #       dhcp_configurations: [
    #         {
    #           key: "domain-name-servers", 
    #           values: [
    #             {
    #               value: "10.2.5.2", 
    #             }, 
    #             {
    #               value: "10.2.5.1", 
    #             }, 
    #           ], 
    #         }, 
    #       ], 
    #       dhcp_options_id: "dopt-d9070ebb", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_dhcp_options({
    #     dhcp_configurations: [ # required
    #       {
    #         key: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.dhcp_options.dhcp_configurations #=> Array
    #   resp.dhcp_options.dhcp_configurations[0].key #=> String
    #   resp.dhcp_options.dhcp_configurations[0].values #=> Array
    #   resp.dhcp_options.dhcp_configurations[0].values[0] #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #   resp.dhcp_options.dhcp_options_id #=> String
    #   resp.dhcp_options.owner_id #=> String
    #   resp.dhcp_options.tags #=> Array
    #   resp.dhcp_options.tags[0].key #=> String
    #   resp.dhcp_options.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDhcpOptions AWS API Documentation
    #
    # @overload create_dhcp_options(params = {})
    # @param [Hash] params ({})
    def create_dhcp_options(params = {}, options = {})
      req = build_request(:create_dhcp_options, params)
      req.send_request(options)
    end

    # \[IPv6 only\] Creates an egress-only internet gateway for your VPC. An
    # egress-only internet gateway is used to enable outbound communication
    # over IPv6 from instances in your VPC to the internet, and prevents
    # hosts outside of your VPC from initiating an IPv6 connection with your
    # instance.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC for which to create the egress-only internet
    #   gateway.
    #
    # @return [Types::CreateEgressOnlyInternetGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateEgressOnlyInternetGatewayResult#client_token #client_token} => String
    #   * {Types::CreateEgressOnlyInternetGatewayResult#egress_only_internet_gateway #egress_only_internet_gateway} => Types::EgressOnlyInternetGateway
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_egress_only_internet_gateway({
    #     client_token: "String",
    #     dry_run: false,
    #     vpc_id: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.client_token #=> String
    #   resp.egress_only_internet_gateway.attachments #=> Array
    #   resp.egress_only_internet_gateway.attachments[0].state #=> String, one of "attaching", "attached", "detaching", "detached"
    #   resp.egress_only_internet_gateway.attachments[0].vpc_id #=> String
    #   resp.egress_only_internet_gateway.egress_only_internet_gateway_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateEgressOnlyInternetGateway AWS API Documentation
    #
    # @overload create_egress_only_internet_gateway(params = {})
    # @param [Hash] params ({})
    def create_egress_only_internet_gateway(params = {}, options = {})
      req = build_request(:create_egress_only_internet_gateway, params)
      req.send_request(options)
    end

    # Launches an EC2 Fleet.
    #
    # You can create a single EC2 Fleet that includes multiple launch
    # specifications that vary by instance type, AMI, Availability Zone, or
    # subnet.
    #
    # For more information, see [Launching an EC2 Fleet][1] in the *Amazon
    # Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [Types::SpotOptionsRequest] :spot_options
    #   Describes the configuration of Spot Instances in an EC2 Fleet.
    #
    # @option params [Types::OnDemandOptionsRequest] :on_demand_options
    #   Describes the configuration of On-Demand Instances in an EC2 Fleet.
    #
    # @option params [String] :excess_capacity_termination_policy
    #   Indicates whether running instances should be terminated if the total
    #   target capacity of the EC2 Fleet is decreased below the current size
    #   of the EC2 Fleet.
    #
    # @option params [required, Array<Types::FleetLaunchTemplateConfigRequest>] :launch_template_configs
    #   The configuration for the EC2 Fleet.
    #
    # @option params [required, Types::TargetCapacitySpecificationRequest] :target_capacity_specification
    #   The number of units to request.
    #
    # @option params [Boolean] :terminate_instances_with_expiration
    #   Indicates whether running instances should be terminated when the EC2
    #   Fleet expires.
    #
    # @option params [String] :type
    #   The type of the request. By default, the EC2 Fleet places an
    #   asynchronous request for your desired capacity, and maintains it by
    #   replenishing interrupted Spot Instances (`maintain`). A value of
    #   `instant` places a synchronous one-time request, and returns errors
    #   for any instances that could not be launched. A value of `request`
    #   places an asynchronous one-time request without maintaining capacity
    #   or submitting requests in alternative capacity pools if capacity is
    #   unavailable. For more information, see [EC2 Fleet Request Types][1] in
    #   the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-request-type
    #
    # @option params [Time,DateTime,Date,Integer,String] :valid_from
    #   The start date and time of the request, in UTC format (for example,
    #   *YYYY*-*MM*-*DD*T*HH*\:*MM*\:*SS*Z). The default is to start
    #   fulfilling the request immediately.
    #
    # @option params [Time,DateTime,Date,Integer,String] :valid_until
    #   The end date and time of the request, in UTC format (for example,
    #   *YYYY*-*MM*-*DD*T*HH*\:*MM*\:*SS*Z). At this point, no new EC2 Fleet
    #   requests are placed or able to fulfill the request. If no value is
    #   specified, the request remains until you cancel it.
    #
    # @option params [Boolean] :replace_unhealthy_instances
    #   Indicates whether EC2 Fleet should replace unhealthy instances.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The key-value pair for tagging the EC2 Fleet request on creation. The
    #   value for `ResourceType` must be `fleet`, otherwise the fleet request
    #   fails. To tag instances at launch, specify the tags in the [launch
    #   template][1]. For information about tagging after launch, see [Tagging
    #   Your Resources][2].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template
    #   [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources
    #
    # @return [Types::CreateFleetResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateFleetResult#fleet_id #fleet_id} => String
    #   * {Types::CreateFleetResult#errors #errors} => Array&lt;Types::CreateFleetError&gt;
    #   * {Types::CreateFleetResult#instances #instances} => Array&lt;Types::CreateFleetInstance&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_fleet({
    #     dry_run: false,
    #     client_token: "String",
    #     spot_options: {
    #       allocation_strategy: "lowest-price", # accepts lowest-price, diversified, capacity-optimized
    #       instance_interruption_behavior: "hibernate", # accepts hibernate, stop, terminate
    #       instance_pools_to_use_count: 1,
    #       single_instance_type: false,
    #       single_availability_zone: false,
    #       min_target_capacity: 1,
    #       max_total_price: "String",
    #     },
    #     on_demand_options: {
    #       allocation_strategy: "lowest-price", # accepts lowest-price, prioritized
    #       single_instance_type: false,
    #       single_availability_zone: false,
    #       min_target_capacity: 1,
    #       max_total_price: "String",
    #     },
    #     excess_capacity_termination_policy: "no-termination", # accepts no-termination, termination
    #     launch_template_configs: [ # required
    #       {
    #         launch_template_specification: {
    #           launch_template_id: "String",
    #           launch_template_name: "LaunchTemplateName",
    #           version: "String",
    #         },
    #         overrides: [
    #           {
    #             instance_type: "t1.micro", # accepts t1.micro, t2.nano, t2.micro, t2.small, t2.medium, t2.large, t2.xlarge, t2.2xlarge, t3.nano, t3.micro, t3.small, t3.medium, t3.large, t3.xlarge, t3.2xlarge, t3a.nano, t3a.micro, t3a.small, t3a.medium, t3a.large, t3a.xlarge, t3a.2xlarge, m1.small, m1.medium, m1.large, m1.xlarge, m3.medium, m3.large, m3.xlarge, m3.2xlarge, m4.large, m4.xlarge, m4.2xlarge, m4.4xlarge, m4.10xlarge, m4.16xlarge, m2.xlarge, m2.2xlarge, m2.4xlarge, cr1.8xlarge, r3.large, r3.xlarge, r3.2xlarge, r3.4xlarge, r3.8xlarge, r4.large, r4.xlarge, r4.2xlarge, r4.4xlarge, r4.8xlarge, r4.16xlarge, r5.large, r5.xlarge, r5.2xlarge, r5.4xlarge, r5.8xlarge, r5.12xlarge, r5.16xlarge, r5.24xlarge, r5.metal, r5a.large, r5a.xlarge, r5a.2xlarge, r5a.4xlarge, r5a.8xlarge, r5a.12xlarge, r5a.16xlarge, r5a.24xlarge, r5d.large, r5d.xlarge, r5d.2xlarge, r5d.4xlarge, r5d.8xlarge, r5d.12xlarge, r5d.16xlarge, r5d.24xlarge, r5d.metal, r5ad.large, r5ad.xlarge, r5ad.2xlarge, r5ad.4xlarge, r5ad.8xlarge, r5ad.12xlarge, r5ad.16xlarge, r5ad.24xlarge, x1.16xlarge, x1.32xlarge, x1e.xlarge, x1e.2xlarge, x1e.4xlarge, x1e.8xlarge, x1e.16xlarge, x1e.32xlarge, i2.xlarge, i2.2xlarge, i2.4xlarge, i2.8xlarge, i3.large, i3.xlarge, i3.2xlarge, i3.4xlarge, i3.8xlarge, i3.16xlarge, i3.metal, i3en.large, i3en.xlarge, i3en.2xlarge, i3en.3xlarge, i3en.6xlarge, i3en.12xlarge, i3en.24xlarge, i3en.metal, hi1.4xlarge, hs1.8xlarge, c1.medium, c1.xlarge, c3.large, c3.xlarge, c3.2xlarge, c3.4xlarge, c3.8xlarge, c4.large, c4.xlarge, c4.2xlarge, c4.4xlarge, c4.8xlarge, c5.large, c5.xlarge, c5.2xlarge, c5.4xlarge, c5.9xlarge, c5.12xlarge, c5.18xlarge, c5.24xlarge, c5.metal, c5d.large, c5d.xlarge, c5d.2xlarge, c5d.4xlarge, c5d.9xlarge, c5d.18xlarge, c5n.large, c5n.xlarge, c5n.2xlarge, c5n.4xlarge, c5n.9xlarge, c5n.18xlarge, cc1.4xlarge, cc2.8xlarge, g2.2xlarge, g2.8xlarge, g3.4xlarge, g3.8xlarge, g3.16xlarge, g3s.xlarge, cg1.4xlarge, p2.xlarge, p2.8xlarge, p2.16xlarge, p3.2xlarge, p3.8xlarge, p3.16xlarge, p3dn.24xlarge, d2.xlarge, d2.2xlarge, d2.4xlarge, d2.8xlarge, f1.2xlarge, f1.4xlarge, f1.16xlarge, m5.large, m5.xlarge, m5.2xlarge, m5.4xlarge, m5.8xlarge, m5.12xlarge, m5.16xlarge, m5.24xlarge, m5.metal, m5a.large, m5a.xlarge, m5a.2xlarge, m5a.4xlarge, m5a.8xlarge, m5a.12xlarge, m5a.16xlarge, m5a.24xlarge, m5d.large, m5d.xlarge, m5d.2xlarge, m5d.4xlarge, m5d.8xlarge, m5d.12xlarge, m5d.16xlarge, m5d.24xlarge, m5d.metal, m5ad.large, m5ad.xlarge, m5ad.2xlarge, m5ad.4xlarge, m5ad.8xlarge, m5ad.12xlarge, m5ad.16xlarge, m5ad.24xlarge, h1.2xlarge, h1.4xlarge, h1.8xlarge, h1.16xlarge, z1d.large, z1d.xlarge, z1d.2xlarge, z1d.3xlarge, z1d.6xlarge, z1d.12xlarge, z1d.metal, u-6tb1.metal, u-9tb1.metal, u-12tb1.metal, a1.medium, a1.large, a1.xlarge, a1.2xlarge, a1.4xlarge
    #             max_price: "String",
    #             subnet_id: "String",
    #             availability_zone: "String",
    #             weighted_capacity: 1.0,
    #             priority: 1.0,
    #             placement: {
    #               availability_zone: "String",
    #               affinity: "String",
    #               group_name: "String",
    #               partition_number: 1,
    #               host_id: "String",
    #               tenancy: "default", # accepts default, dedicated, host
    #               spread_domain: "String",
    #             },
    #           },
    #         ],
    #       },
    #     ],
    #     target_capacity_specification: { # required
    #       total_target_capacity: 1, # required
    #       on_demand_target_capacity: 1,
    #       spot_target_capacity: 1,
    #       default_target_capacity_type: "spot", # accepts spot, on-demand
    #     },
    #     terminate_instances_with_expiration: false,
    #     type: "request", # accepts request, maintain, instant
    #     valid_from: Time.now,
    #     valid_until: Time.now,
    #     replace_unhealthy_instances: false,
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, elastic-ip, fleet, fpga-image, host-reservation, image, instance, internet-gateway, launch-template, natgateway, network-acl, network-interface, reserved-instances, route-table, security-group, snapshot, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.fleet_id #=> String
    #   resp.errors #=> Array
    #   resp.errors[0].launch_template_and_overrides.launch_template_specification.launch_template_id #=> String
    #   resp.errors[0].launch_template_and_overrides.launch_template_specification.launch_template_name #=> String
    #   resp.errors[0].launch_template_and_overrides.launch_template_specification.version #=> String
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.18xlarge", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge"
    #   resp.errors[0].launch_template_and_overrides.overrides.max_price #=> String
    #   resp.errors[0].launch_template_and_overrides.overrides.subnet_id #=> String
    #   resp.errors[0].launch_template_and_overrides.overrides.availability_zone #=> String
    #   resp.errors[0].launch_template_and_overrides.overrides.weighted_capacity #=> Float
    #   resp.errors[0].launch_template_and_overrides.overrides.priority #=> Float
    #   resp.errors[0].launch_template_and_overrides.overrides.placement.group_name #=> String
    #   resp.errors[0].lifecycle #=> String, one of "spot", "on-demand"
    #   resp.errors[0].error_code #=> String
    #   resp.errors[0].error_message #=> String
    #   resp.instances #=> Array
    #   resp.instances[0].launch_template_and_overrides.launch_template_specification.launch_template_id #=> String
    #   resp.instances[0].launch_template_and_overrides.launch_template_specification.launch_template_name #=> String
    #   resp.instances[0].launch_template_and_overrides.launch_template_specification.version #=> String
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.18xlarge", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge"
    #   resp.instances[0].launch_template_and_overrides.overrides.max_price #=> String
    #   resp.instances[0].launch_template_and_overrides.overrides.subnet_id #=> String
    #   resp.instances[0].launch_template_and_overrides.overrides.availability_zone #=> String
    #   resp.instances[0].launch_template_and_overrides.overrides.weighted_capacity #=> Float
    #   resp.instances[0].launch_template_and_overrides.overrides.priority #=> Float
    #   resp.instances[0].launch_template_and_overrides.overrides.placement.group_name #=> String
    #   resp.instances[0].lifecycle #=> String, one of "spot", "on-demand"
    #   resp.instances[0].instance_ids #=> Array
    #   resp.instances[0].instance_ids[0] #=> String
    #   resp.instances[0].instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.18xlarge", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge"
    #   resp.instances[0].platform #=> String, one of "Windows"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleet AWS API Documentation
    #
    # @overload create_fleet(params = {})
    # @param [Hash] params ({})
    def create_fleet(params = {}, options = {})
      req = build_request(:create_fleet, params)
      req.send_request(options)
    end

    # Creates one or more flow logs to capture information about IP traffic
    # for a specific network interface, subnet, or VPC.
    #
    # Flow log data for a monitored network interface is recorded as flow
    # log records, which are log events consisting of fields that describe
    # the traffic flow. For more information, see [Flow Log Records][1] in
    # the *Amazon Virtual Private Cloud User Guide*.
    #
    # When publishing to CloudWatch Logs, flow log records are published to
    # a log group, and each network interface has a unique log stream in the
    # log group. When publishing to Amazon S3, flow log records for all of
    # the monitored network interfaces are published to a single log file
    # object that is stored in the specified bucket.
    #
    # For more information, see [VPC Flow Logs][2] in the *Amazon Virtual
    # Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records
    # [2]: https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html
    #
    # @option params [String] :deliver_logs_permission_arn
    #   The ARN for the IAM role that permits Amazon EC2 to publish flow logs
    #   to a CloudWatch Logs log group in your account.
    #
    #   If you specify `LogDestinationType` as `s3`, do not specify
    #   `DeliverLogsPermissionArn` or `LogGroupName`.
    #
    # @option params [String] :log_group_name
    #   The name of a new or existing CloudWatch Logs log group where Amazon
    #   EC2 publishes your flow logs.
    #
    #   If you specify `LogDestinationType` as `s3`, do not specify
    #   `DeliverLogsPermissionArn` or `LogGroupName`.
    #
    # @option params [required, Array<String>] :resource_ids
    #   The ID of the subnet, network interface, or VPC for which you want to
    #   create a flow log.
    #
    #   Constraints: Maximum of 1000 resources
    #
    # @option params [required, String] :resource_type
    #   The type of resource for which to create the flow log. For example, if
    #   you specified a VPC ID for the `ResourceId` property, specify `VPC`
    #   for this property.
    #
    # @option params [required, String] :traffic_type
    #   The type of traffic to log. You can log traffic that the resource
    #   accepts or rejects, or all traffic.
    #
    # @option params [String] :log_destination_type
    #   Specifies the type of destination to which the flow log data is to be
    #   published. Flow log data can be published to CloudWatch Logs or Amazon
    #   S3. To publish flow log data to CloudWatch Logs, specify
    #   `cloud-watch-logs`. To publish flow log data to Amazon S3, specify
    #   `s3`.
    #
    #   If you specify `LogDestinationType` as `s3`, do not specify
    #   `DeliverLogsPermissionArn` or `LogGroupName`.
    #
    #   Default: `cloud-watch-logs`
    #
    # @option params [String] :log_destination
    #   Specifies the destination to which the flow log data is to be
    #   published. Flow log data can be published to a CloudWatch Logs log
    #   group or an Amazon S3 bucket. The value specified for this parameter
    #   depends on the value specified for `LogDestinationType`.
    #
    #   If LogDestinationType is not specified or `cloud-watch-logs`, specify
    #   the Amazon Resource Name (ARN) of the CloudWatch Logs log group.
    #
    #   If LogDestinationType is `s3`, specify the ARN of the Amazon S3
    #   bucket. You can also specify a subfolder in the bucket. To specify a
    #   subfolder in the bucket, use the following ARN format:
    #   `bucket_ARN/subfolder_name/`. For example, to specify a subfolder
    #   named `my-logs` in a bucket named `my-bucket`, use the following ARN:
    #   `arn:aws:s3:::my-bucket/my-logs/`. You cannot use `AWSLogs` as a
    #   subfolder name. This is a reserved term.
    #
    # @option params [String] :log_format
    #   The fields to include in the flow log record, in the order in which
    #   they should appear. For a list of available fields, see [Flow Log
    #   Records][1]. If you omit this parameter, the flow log is created using
    #   the default format. If you specify this parameter, you must specify at
    #   least one field.
    #
    #   Specify the fields using the `$\{field-id\}` format, separated by
    #   spaces. For the AWS CLI, use single quotation marks (' ') to
    #   surround the parameter value.
    #
    #   Only applicable to flow logs that are published to an Amazon S3
    #   bucket.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records
    #
    # @return [Types::CreateFlowLogsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateFlowLogsResult#client_token #client_token} => String
    #   * {Types::CreateFlowLogsResult#flow_log_ids #flow_log_ids} => Array&lt;String&gt;
    #   * {Types::CreateFlowLogsResult#unsuccessful #unsuccessful} => Array&lt;Types::UnsuccessfulItem&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_flow_logs({
    #     dry_run: false,
    #     client_token: "String",
    #     deliver_logs_permission_arn: "String",
    #     log_group_name: "String",
    #     resource_ids: ["String"], # required
    #     resource_type: "VPC", # required, accepts VPC, Subnet, NetworkInterface
    #     traffic_type: "ACCEPT", # required, accepts ACCEPT, REJECT, ALL
    #     log_destination_type: "cloud-watch-logs", # accepts cloud-watch-logs, s3
    #     log_destination: "String",
    #     log_format: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.client_token #=> String
    #   resp.flow_log_ids #=> Array
    #   resp.flow_log_ids[0] #=> String
    #   resp.unsuccessful #=> Array
    #   resp.unsuccessful[0].error.code #=> String
    #   resp.unsuccessful[0].error.message #=> String
    #   resp.unsuccessful[0].resource_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFlowLogs AWS API Documentation
    #
    # @overload create_flow_logs(params = {})
    # @param [Hash] params ({})
    def create_flow_logs(params = {}, options = {})
      req = build_request(:create_flow_logs, params)
      req.send_request(options)
    end

    # Creates an Amazon FPGA Image (AFI) from the specified design
    # checkpoint (DCP).
    #
    # The create operation is asynchronous. To verify that the AFI is ready
    # for use, check the output logs.
    #
    # An AFI contains the FPGA bitstream that is ready to download to an
    # FPGA. You can securely deploy an AFI on multiple FPGA-accelerated
    # instances. For more information, see the [AWS FPGA Hardware
    # Development Kit][1].
    #
    #
    #
    # [1]: https://github.com/aws/aws-fpga/
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Types::StorageLocation] :input_storage_location
    #   The location of the encrypted design checkpoint in Amazon S3. The
    #   input must be a tarball.
    #
    # @option params [Types::StorageLocation] :logs_storage_location
    #   The location in Amazon S3 for the output logs.
    #
    # @option params [String] :description
    #   A description for the AFI.
    #
    # @option params [String] :name
    #   A name for the AFI.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html
    #
    # @return [Types::CreateFpgaImageResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateFpgaImageResult#fpga_image_id #fpga_image_id} => String
    #   * {Types::CreateFpgaImageResult#fpga_image_global_id #fpga_image_global_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_fpga_image({
    #     dry_run: false,
    #     input_storage_location: { # required
    #       bucket: "String",
    #       key: "String",
    #     },
    #     logs_storage_location: {
    #       bucket: "String",
    #       key: "String",
    #     },
    #     description: "String",
    #     name: "String",
    #     client_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.fpga_image_id #=> String
    #   resp.fpga_image_global_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFpgaImage AWS API Documentation
    #
    # @overload create_fpga_image(params = {})
    # @param [Hash] params ({})
    def create_fpga_image(params = {}, options = {})
      req = build_request(:create_fpga_image, params)
      req.send_request(options)
    end

    # Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance
    # that is either running or stopped.
    #
    # If you customized your instance with instance store volumes or EBS
    # volumes in addition to the root device volume, the new AMI contains
    # block device mapping information for those volumes. When you launch an
    # instance from this new AMI, the instance automatically launches with
    # those additional volumes.
    #
    # For more information, see [Creating Amazon EBS-Backed Linux AMIs][1]
    # in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html
    #
    # @option params [Array<Types::BlockDeviceMapping>] :block_device_mappings
    #   The block device mappings. This parameter cannot be used to modify the
    #   encryption status of existing volumes or snapshots. To create an AMI
    #   with encrypted snapshots, use the CopyImage action.
    #
    # @option params [String] :description
    #   A description for the new image.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :instance_id
    #   The ID of the instance.
    #
    # @option params [required, String] :name
    #   A name for the new image.
    #
    #   Constraints: 3-128 alphanumeric characters, parentheses (()), square
    #   brackets (\[\]), spaces ( ), periods (.), slashes (/), dashes (-),
    #   single quotes ('), at-signs (@), or underscores(\_)
    #
    # @option params [Boolean] :no_reboot
    #   By default, Amazon EC2 attempts to shut down and reboot the instance
    #   before creating the image. If the 'No Reboot' option is set, Amazon
    #   EC2 doesn't shut down the instance before creating the image. When
    #   this option is used, file system integrity on the created image can't
    #   be guaranteed.
    #
    # @return [Types::CreateImageResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateImageResult#image_id #image_id} => String
    #
    #
    # @example Example: To create an AMI from an Amazon EBS-backed instance
    #
    #   # This example creates an AMI from the specified instance and adds an EBS volume with the device name /dev/sdh and an
    #   # instance store volume with the device name /dev/sdc.
    #
    #   resp = client.create_image({
    #     block_device_mappings: [
    #       {
    #         device_name: "/dev/sdh", 
    #         ebs: {
    #           volume_size: 100, 
    #         }, 
    #       }, 
    #       {
    #         device_name: "/dev/sdc", 
    #         virtual_name: "ephemeral1", 
    #       }, 
    #     ], 
    #     description: "An AMI for my server", 
    #     instance_id: "i-1234567890abcdef0", 
    #     name: "My server", 
    #     no_reboot: true, 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     image_id: "ami-1a2b3c4d", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_image({
    #     block_device_mappings: [
    #       {
    #         device_name: "String",
    #         virtual_name: "String",
    #         ebs: {
    #           delete_on_termination: false,
    #           iops: 1,
    #           snapshot_id: "String",
    #           volume_size: 1,
    #           volume_type: "standard", # accepts standard, io1, gp2, sc1, st1
    #           encrypted: false,
    #           kms_key_id: "String",
    #         },
    #         no_device: "String",
    #       },
    #     ],
    #     description: "String",
    #     dry_run: false,
    #     instance_id: "String", # required
    #     name: "String", # required
    #     no_reboot: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.image_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImage AWS API Documentation
    #
    # @overload create_image(params = {})
    # @param [Hash] params ({})
    def create_image(params = {}, options = {})
      req = build_request(:create_image, params)
      req.send_request(options)
    end

    # Exports a running or stopped instance to an S3 bucket.
    #
    # For information about the supported operating systems, image formats,
    # and known limitations for the types of instances you can export, see
    # [Exporting an Instance as a VM Using VM Import/Export][1] in the *VM
    # Import/Export User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html
    #
    # @option params [String] :description
    #   A description for the conversion task or the resource being exported.
    #   The maximum length is 255 bytes.
    #
    # @option params [Types::ExportToS3TaskSpecification] :export_to_s3_task
    #   The format and location for an instance export task.
    #
    # @option params [required, String] :instance_id
    #   The ID of the instance.
    #
    # @option params [String] :target_environment
    #   The target virtualization environment.
    #
    # @return [Types::CreateInstanceExportTaskResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateInstanceExportTaskResult#export_task #export_task} => Types::ExportTask
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_instance_export_task({
    #     description: "String",
    #     export_to_s3_task: {
    #       container_format: "ova", # accepts ova
    #       disk_image_format: "VMDK", # accepts VMDK, RAW, VHD
    #       s3_bucket: "String",
    #       s3_prefix: "String",
    #     },
    #     instance_id: "String", # required
    #     target_environment: "citrix", # accepts citrix, vmware, microsoft
    #   })
    #
    # @example Response structure
    #
    #   resp.export_task.description #=> String
    #   resp.export_task.export_task_id #=> String
    #   resp.export_task.export_to_s3_task.container_format #=> String, one of "ova"
    #   resp.export_task.export_to_s3_task.disk_image_format #=> String, one of "VMDK", "RAW", "VHD"
    #   resp.export_task.export_to_s3_task.s3_bucket #=> String
    #   resp.export_task.export_to_s3_task.s3_key #=> String
    #   resp.export_task.instance_export_details.instance_id #=> String
    #   resp.export_task.instance_export_details.target_environment #=> String, one of "citrix", "vmware", "microsoft"
    #   resp.export_task.state #=> String, one of "active", "cancelling", "cancelled", "completed"
    #   resp.export_task.status_message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceExportTask AWS API Documentation
    #
    # @overload create_instance_export_task(params = {})
    # @param [Hash] params ({})
    def create_instance_export_task(params = {}, options = {})
      req = build_request(:create_instance_export_task, params)
      req.send_request(options)
    end

    # Creates an internet gateway for use with a VPC. After creating the
    # internet gateway, you attach it to a VPC using AttachInternetGateway.
    #
    # For more information about your VPC and internet gateway, see the
    # [Amazon Virtual Private Cloud User Guide][1].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateInternetGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateInternetGatewayResult#internet_gateway #internet_gateway} => Types::InternetGateway
    #
    #
    # @example Example: To create an Internet gateway
    #
    #   # This example creates an Internet gateway.
    #
    #   resp = client.create_internet_gateway({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     internet_gateway: {
    #       attachments: [
    #       ], 
    #       internet_gateway_id: "igw-c0a643a9", 
    #       tags: [
    #       ], 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_internet_gateway({
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.internet_gateway.attachments #=> Array
    #   resp.internet_gateway.attachments[0].state #=> String, one of "attaching", "attached", "detaching", "detached"
    #   resp.internet_gateway.attachments[0].vpc_id #=> String
    #   resp.internet_gateway.internet_gateway_id #=> String
    #   resp.internet_gateway.owner_id #=> String
    #   resp.internet_gateway.tags #=> Array
    #   resp.internet_gateway.tags[0].key #=> String
    #   resp.internet_gateway.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGateway AWS API Documentation
    #
    # @overload create_internet_gateway(params = {})
    # @param [Hash] params ({})
    def create_internet_gateway(params = {}, options = {})
      req = build_request(:create_internet_gateway, params)
      req.send_request(options)
    end

    # Creates a 2048-bit RSA key pair with the specified name. Amazon EC2
    # stores the public key and displays the private key for you to save to
    # a file. The private key is returned as an unencrypted PEM encoded
    # PKCS#1 private key. If a key with the specified name already exists,
    # Amazon EC2 returns an error.
    #
    # You can have up to five thousand key pairs per Region.
    #
    # The key pair returned to you is available only in the Region in which
    # you create it. If you prefer, you can create your own key pair using a
    # third-party tool and upload it to any Region using ImportKeyPair.
    #
    # For more information, see [Key Pairs][1] in the *Amazon Elastic
    # Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
    #
    # @option params [required, String] :key_name
    #   A unique name for the key pair.
    #
    #   Constraints: Up to 255 ASCII characters
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::KeyPair] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::KeyPair#key_fingerprint #key_fingerprint} => String
    #   * {Types::KeyPair#key_material #key_material} => String
    #   * {Types::KeyPair#key_name #key_name} => String
    #
    #
    # @example Example: To create a key pair
    #
    #   # This example creates a key pair named my-key-pair.
    #
    #   resp = client.create_key_pair({
    #     key_name: "my-key-pair", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_key_pair({
    #     key_name: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.key_fingerprint #=> String
    #   resp.key_material #=> String
    #   resp.key_name #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateKeyPair AWS API Documentation
    #
    # @overload create_key_pair(params = {})
    # @param [Hash] params ({})
    def create_key_pair(params = {}, options = {})
      req = build_request(:create_key_pair, params)
      req.send_request(options)
    end

    # Creates a launch template. A launch template contains the parameters
    # to launch an instance. When you launch an instance using RunInstances,
    # you can specify a launch template instead of providing the launch
    # parameters in the request.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #   Constraint: Maximum 128 ASCII characters.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [required, String] :launch_template_name
    #   A name for the launch template.
    #
    # @option params [String] :version_description
    #   A description for the first version of the launch template.
    #
    # @option params [required, Types::RequestLaunchTemplateData] :launch_template_data
    #   The information for the launch template.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the launch template during creation.
    #
    # @return [Types::CreateLaunchTemplateResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateLaunchTemplateResult#launch_template #launch_template} => Types::LaunchTemplate
    #
    #
    # @example Example: To create a launch template
    #
    #   # This example creates a launch template that specifies the subnet in which to launch the instance, assigns a public IP
    #   # address and an IPv6 address to the instance, and creates a tag for the instance.
    #
    #   resp = client.create_launch_template({
    #     launch_template_data: {
    #       image_id: "ami-8c1be5f6", 
    #       instance_type: "t2.small", 
    #       network_interfaces: [
    #         {
    #           associate_public_ip_address: true, 
    #           device_index: 0, 
    #           ipv_6_address_count: 1, 
    #           subnet_id: "subnet-7b16de0c", 
    #         }, 
    #       ], 
    #       tag_specifications: [
    #         {
    #           resource_type: "instance", 
    #           tags: [
    #             {
    #               key: "Name", 
    #               value: "webserver", 
    #             }, 
    #           ], 
    #         }, 
    #       ], 
    #     }, 
    #     launch_template_name: "my-template", 
    #     version_description: "WebVersion1", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     launch_template: {
    #       create_time: Time.parse("2017-11-27T09:13:24.000Z"), 
    #       created_by: "arn:aws:iam::123456789012:root", 
    #       default_version_number: 1, 
    #       latest_version_number: 1, 
    #       launch_template_id: "lt-01238c059e3466abc", 
    #       launch_template_name: "my-template", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_launch_template({
    #     dry_run: false,
    #     client_token: "String",
    #     launch_template_name: "LaunchTemplateName", # required
    #     version_description: "VersionDescription",
    #     launch_template_data: { # required
    #       kernel_id: "String",
    #       ebs_optimized: false,
    #       iam_instance_profile: {
    #         arn: "String",
    #         name: "String",
    #       },
    #       block_device_mappings: [
    #         {
    #           device_name: "String",
    #           virtual_name: "String",
    #           ebs: {
    #             encrypted: false,
    #             delete_on_termination: false,
    #             iops: 1,
    #             kms_key_id: "String",
    #             snapshot_id: "String",
    #             volume_size: 1,
    #             volume_type: "standard", # accepts standard, io1, gp2, sc1, st1
    #           },
    #           no_device: "String",
    #         },
    #       ],
    #       network_interfaces: [
    #         {
    #           associate_public_ip_address: false,
    #           delete_on_termination: false,
    #           description: "String",
    #           device_index: 1,
    #           groups: ["String"],
    #           interface_type: "String",
    #           ipv_6_address_count: 1,
    #           ipv_6_addresses: [
    #             {
    #               ipv_6_address: "String",
    #             },
    #           ],
    #           network_interface_id: "String",
    #           private_ip_address: "String",
    #           private_ip_addresses: [
    #             {
    #               primary: false,
    #               private_ip_address: "String",
    #             },
    #           ],
    #           secondary_private_ip_address_count: 1,
    #           subnet_id: "String",
    #         },
    #       ],
    #       image_id: "String",
    #       instance_type: "t1.micro", # accepts t1.micro, t2.nano, t2.micro, t2.small, t2.medium, t2.large, t2.xlarge, t2.2xlarge, t3.nano, t3.micro, t3.small, t3.medium, t3.large, t3.xlarge, t3.2xlarge, t3a.nano, t3a.micro, t3a.small, t3a.medium, t3a.large, t3a.xlarge, t3a.2xlarge, m1.small, m1.medium, m1.large, m1.xlarge, m3.medium, m3.large, m3.xlarge, m3.2xlarge, m4.large, m4.xlarge, m4.2xlarge, m4.4xlarge, m4.10xlarge, m4.16xlarge, m2.xlarge, m2.2xlarge, m2.4xlarge, cr1.8xlarge, r3.large, r3.xlarge, r3.2xlarge, r3.4xlarge, r3.8xlarge, r4.large, r4.xlarge, r4.2xlarge, r4.4xlarge, r4.8xlarge, r4.16xlarge, r5.large, r5.xlarge, r5.2xlarge, r5.4xlarge, r5.8xlarge, r5.12xlarge, r5.16xlarge, r5.24xlarge, r5.metal, r5a.large, r5a.xlarge, r5a.2xlarge, r5a.4xlarge, r5a.8xlarge, r5a.12xlarge, r5a.16xlarge, r5a.24xlarge, r5d.large, r5d.xlarge, r5d.2xlarge, r5d.4xlarge, r5d.8xlarge, r5d.12xlarge, r5d.16xlarge, r5d.24xlarge, r5d.metal, r5ad.large, r5ad.xlarge, r5ad.2xlarge, r5ad.4xlarge, r5ad.8xlarge, r5ad.12xlarge, r5ad.16xlarge, r5ad.24xlarge, x1.16xlarge, x1.32xlarge, x1e.xlarge, x1e.2xlarge, x1e.4xlarge, x1e.8xlarge, x1e.16xlarge, x1e.32xlarge, i2.xlarge, i2.2xlarge, i2.4xlarge, i2.8xlarge, i3.large, i3.xlarge, i3.2xlarge, i3.4xlarge, i3.8xlarge, i3.16xlarge, i3.metal, i3en.large, i3en.xlarge, i3en.2xlarge, i3en.3xlarge, i3en.6xlarge, i3en.12xlarge, i3en.24xlarge, i3en.metal, hi1.4xlarge, hs1.8xlarge, c1.medium, c1.xlarge, c3.large, c3.xlarge, c3.2xlarge, c3.4xlarge, c3.8xlarge, c4.large, c4.xlarge, c4.2xlarge, c4.4xlarge, c4.8xlarge, c5.large, c5.xlarge, c5.2xlarge, c5.4xlarge, c5.9xlarge, c5.12xlarge, c5.18xlarge, c5.24xlarge, c5.metal, c5d.large, c5d.xlarge, c5d.2xlarge, c5d.4xlarge, c5d.9xlarge, c5d.18xlarge, c5n.large, c5n.xlarge, c5n.2xlarge, c5n.4xlarge, c5n.9xlarge, c5n.18xlarge, cc1.4xlarge, cc2.8xlarge, g2.2xlarge, g2.8xlarge, g3.4xlarge, g3.8xlarge, g3.16xlarge, g3s.xlarge, cg1.4xlarge, p2.xlarge, p2.8xlarge, p2.16xlarge, p3.2xlarge, p3.8xlarge, p3.16xlarge, p3dn.24xlarge, d2.xlarge, d2.2xlarge, d2.4xlarge, d2.8xlarge, f1.2xlarge, f1.4xlarge, f1.16xlarge, m5.large, m5.xlarge, m5.2xlarge, m5.4xlarge, m5.8xlarge, m5.12xlarge, m5.16xlarge, m5.24xlarge, m5.metal, m5a.large, m5a.xlarge, m5a.2xlarge, m5a.4xlarge, m5a.8xlarge, m5a.12xlarge, m5a.16xlarge, m5a.24xlarge, m5d.large, m5d.xlarge, m5d.2xlarge, m5d.4xlarge, m5d.8xlarge, m5d.12xlarge, m5d.16xlarge, m5d.24xlarge, m5d.metal, m5ad.large, m5ad.xlarge, m5ad.2xlarge, m5ad.4xlarge, m5ad.8xlarge, m5ad.12xlarge, m5ad.16xlarge, m5ad.24xlarge, h1.2xlarge, h1.4xlarge, h1.8xlarge, h1.16xlarge, z1d.large, z1d.xlarge, z1d.2xlarge, z1d.3xlarge, z1d.6xlarge, z1d.12xlarge, z1d.metal, u-6tb1.metal, u-9tb1.metal, u-12tb1.metal, a1.medium, a1.large, a1.xlarge, a1.2xlarge, a1.4xlarge
    #       key_name: "String",
    #       monitoring: {
    #         enabled: false,
    #       },
    #       placement: {
    #         availability_zone: "String",
    #         affinity: "String",
    #         group_name: "String",
    #         host_id: "String",
    #         tenancy: "default", # accepts default, dedicated, host
    #         spread_domain: "String",
    #       },
    #       ram_disk_id: "String",
    #       disable_api_termination: false,
    #       instance_initiated_shutdown_behavior: "stop", # accepts stop, terminate
    #       user_data: "String",
    #       tag_specifications: [
    #         {
    #           resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, elastic-ip, fleet, fpga-image, host-reservation, image, instance, internet-gateway, launch-template, natgateway, network-acl, network-interface, reserved-instances, route-table, security-group, snapshot, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway
    #           tags: [
    #             {
    #               key: "String",
    #               value: "String",
    #             },
    #           ],
    #         },
    #       ],
    #       elastic_gpu_specifications: [
    #         {
    #           type: "String", # required
    #         },
    #       ],
    #       elastic_inference_accelerators: [
    #         {
    #           type: "String", # required
    #         },
    #       ],
    #       security_group_ids: ["String"],
    #       security_groups: ["String"],
    #       instance_market_options: {
    #         market_type: "spot", # accepts spot
    #         spot_options: {
    #           max_price: "String",
    #           spot_instance_type: "one-time", # accepts one-time, persistent
    #           block_duration_minutes: 1,
    #           valid_until: Time.now,
    #           instance_interruption_behavior: "hibernate", # accepts hibernate, stop, terminate
    #         },
    #       },
    #       credit_specification: {
    #         cpu_credits: "String", # required
    #       },
    #       cpu_options: {
    #         core_count: 1,
    #         threads_per_core: 1,
    #       },
    #       capacity_reservation_specification: {
    #         capacity_reservation_preference: "open", # accepts open, none
    #         capacity_reservation_target: {
    #           capacity_reservation_id: "String",
    #         },
    #       },
    #       license_specifications: [
    #         {
    #           license_configuration_arn: "String",
    #         },
    #       ],
    #       hibernation_options: {
    #         configured: false,
    #       },
    #     },
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, elastic-ip, fleet, fpga-image, host-reservation, image, instance, internet-gateway, launch-template, natgateway, network-acl, network-interface, reserved-instances, route-table, security-group, snapshot, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.launch_template.launch_template_id #=> String
    #   resp.launch_template.launch_template_name #=> String
    #   resp.launch_template.create_time #=> Time
    #   resp.launch_template.created_by #=> String
    #   resp.launch_template.default_version_number #=> Integer
    #   resp.launch_template.latest_version_number #=> Integer
    #   resp.launch_template.tags #=> Array
    #   resp.launch_template.tags[0].key #=> String
    #   resp.launch_template.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplate AWS API Documentation
    #
    # @overload create_launch_template(params = {})
    # @param [Hash] params ({})
    def create_launch_template(params = {}, options = {})
      req = build_request(:create_launch_template, params)
      req.send_request(options)
    end

    # Creates a new version for a launch template. You can specify an
    # existing version of launch template from which to base the new
    # version.
    #
    # Launch template versions are numbered in the order in which they are
    # created. You cannot specify, change, or replace the numbering of
    # launch template versions.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #   Constraint: Maximum 128 ASCII characters.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [String] :launch_template_id
    #   The ID of the launch template. You must specify either the launch
    #   template ID or launch template name in the request.
    #
    # @option params [String] :launch_template_name
    #   The name of the launch template. You must specify either the launch
    #   template ID or launch template name in the request.
    #
    # @option params [String] :source_version
    #   The version number of the launch template version on which to base the
    #   new version. The new version inherits the same launch parameters as
    #   the source version, except for parameters that you specify in
    #   `LaunchTemplateData`. Snapshots applied to the block device mapping
    #   are ignored when creating a new version unless they are explicitly
    #   included.
    #
    # @option params [String] :version_description
    #   A description for the version of the launch template.
    #
    # @option params [required, Types::RequestLaunchTemplateData] :launch_template_data
    #   The information for the launch template.
    #
    # @return [Types::CreateLaunchTemplateVersionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateLaunchTemplateVersionResult#launch_template_version #launch_template_version} => Types::LaunchTemplateVersion
    #
    #
    # @example Example: To create a launch template version
    #
    #   # This example creates a new launch template version based on version 1 of the specified launch template and specifies a
    #   # different AMI ID.
    #
    #   resp = client.create_launch_template_version({
    #     launch_template_data: {
    #       image_id: "ami-c998b6b2", 
    #     }, 
    #     launch_template_id: "lt-0abcd290751193123", 
    #     source_version: "1", 
    #     version_description: "WebVersion2", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     launch_template_version: {
    #       create_time: Time.parse("2017-12-01T13:35:46.000Z"), 
    #       created_by: "arn:aws:iam::123456789012:root", 
    #       default_version: false, 
    #       launch_template_data: {
    #         image_id: "ami-c998b6b2", 
    #         instance_type: "t2.micro", 
    #         network_interfaces: [
    #           {
    #             associate_public_ip_address: true, 
    #             device_index: 0, 
    #             ipv_6_addresses: [
    #               {
    #                 ipv_6_address: "2001:db8:1234:1a00::123", 
    #               }, 
    #             ], 
    #             subnet_id: "subnet-7b16de0c", 
    #           }, 
    #         ], 
    #       }, 
    #       launch_template_id: "lt-0abcd290751193123", 
    #       launch_template_name: "my-template", 
    #       version_description: "WebVersion2", 
    #       version_number: 2, 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_launch_template_version({
    #     dry_run: false,
    #     client_token: "String",
    #     launch_template_id: "String",
    #     launch_template_name: "LaunchTemplateName",
    #     source_version: "String",
    #     version_description: "VersionDescription",
    #     launch_template_data: { # required
    #       kernel_id: "String",
    #       ebs_optimized: false,
    #       iam_instance_profile: {
    #         arn: "String",
    #         name: "String",
    #       },
    #       block_device_mappings: [
    #         {
    #           device_name: "String",
    #           virtual_name: "String",
    #           ebs: {
    #             encrypted: false,
    #             delete_on_termination: false,
    #             iops: 1,
    #             kms_key_id: "String",
    #             snapshot_id: "String",
    #             volume_size: 1,
    #             volume_type: "standard", # accepts standard, io1, gp2, sc1, st1
    #           },
    #           no_device: "String",
    #         },
    #       ],
    #       network_interfaces: [
    #         {
    #           associate_public_ip_address: false,
    #           delete_on_termination: false,
    #           description: "String",
    #           device_index: 1,
    #           groups: ["String"],
    #           interface_type: "String",
    #           ipv_6_address_count: 1,
    #           ipv_6_addresses: [
    #             {
    #               ipv_6_address: "String",
    #             },
    #           ],
    #           network_interface_id: "String",
    #           private_ip_address: "String",
    #           private_ip_addresses: [
    #             {
    #               primary: false,
    #               private_ip_address: "String",
    #             },
    #           ],
    #           secondary_private_ip_address_count: 1,
    #           subnet_id: "String",
    #         },
    #       ],
    #       image_id: "String",
    #       instance_type: "t1.micro", # accepts t1.micro, t2.nano, t2.micro, t2.small, t2.medium, t2.large, t2.xlarge, t2.2xlarge, t3.nano, t3.micro, t3.small, t3.medium, t3.large, t3.xlarge, t3.2xlarge, t3a.nano, t3a.micro, t3a.small, t3a.medium, t3a.large, t3a.xlarge, t3a.2xlarge, m1.small, m1.medium, m1.large, m1.xlarge, m3.medium, m3.large, m3.xlarge, m3.2xlarge, m4.large, m4.xlarge, m4.2xlarge, m4.4xlarge, m4.10xlarge, m4.16xlarge, m2.xlarge, m2.2xlarge, m2.4xlarge, cr1.8xlarge, r3.large, r3.xlarge, r3.2xlarge, r3.4xlarge, r3.8xlarge, r4.large, r4.xlarge, r4.2xlarge, r4.4xlarge, r4.8xlarge, r4.16xlarge, r5.large, r5.xlarge, r5.2xlarge, r5.4xlarge, r5.8xlarge, r5.12xlarge, r5.16xlarge, r5.24xlarge, r5.metal, r5a.large, r5a.xlarge, r5a.2xlarge, r5a.4xlarge, r5a.8xlarge, r5a.12xlarge, r5a.16xlarge, r5a.24xlarge, r5d.large, r5d.xlarge, r5d.2xlarge, r5d.4xlarge, r5d.8xlarge, r5d.12xlarge, r5d.16xlarge, r5d.24xlarge, r5d.metal, r5ad.large, r5ad.xlarge, r5ad.2xlarge, r5ad.4xlarge, r5ad.8xlarge, r5ad.12xlarge, r5ad.16xlarge, r5ad.24xlarge, x1.16xlarge, x1.32xlarge, x1e.xlarge, x1e.2xlarge, x1e.4xlarge, x1e.8xlarge, x1e.16xlarge, x1e.32xlarge, i2.xlarge, i2.2xlarge, i2.4xlarge, i2.8xlarge, i3.large, i3.xlarge, i3.2xlarge, i3.4xlarge, i3.8xlarge, i3.16xlarge, i3.metal, i3en.large, i3en.xlarge, i3en.2xlarge, i3en.3xlarge, i3en.6xlarge, i3en.12xlarge, i3en.24xlarge, i3en.metal, hi1.4xlarge, hs1.8xlarge, c1.medium, c1.xlarge, c3.large, c3.xlarge, c3.2xlarge, c3.4xlarge, c3.8xlarge, c4.large, c4.xlarge, c4.2xlarge, c4.4xlarge, c4.8xlarge, c5.large, c5.xlarge, c5.2xlarge, c5.4xlarge, c5.9xlarge, c5.12xlarge, c5.18xlarge, c5.24xlarge, c5.metal, c5d.large, c5d.xlarge, c5d.2xlarge, c5d.4xlarge, c5d.9xlarge, c5d.18xlarge, c5n.large, c5n.xlarge, c5n.2xlarge, c5n.4xlarge, c5n.9xlarge, c5n.18xlarge, cc1.4xlarge, cc2.8xlarge, g2.2xlarge, g2.8xlarge, g3.4xlarge, g3.8xlarge, g3.16xlarge, g3s.xlarge, cg1.4xlarge, p2.xlarge, p2.8xlarge, p2.16xlarge, p3.2xlarge, p3.8xlarge, p3.16xlarge, p3dn.24xlarge, d2.xlarge, d2.2xlarge, d2.4xlarge, d2.8xlarge, f1.2xlarge, f1.4xlarge, f1.16xlarge, m5.large, m5.xlarge, m5.2xlarge, m5.4xlarge, m5.8xlarge, m5.12xlarge, m5.16xlarge, m5.24xlarge, m5.metal, m5a.large, m5a.xlarge, m5a.2xlarge, m5a.4xlarge, m5a.8xlarge, m5a.12xlarge, m5a.16xlarge, m5a.24xlarge, m5d.large, m5d.xlarge, m5d.2xlarge, m5d.4xlarge, m5d.8xlarge, m5d.12xlarge, m5d.16xlarge, m5d.24xlarge, m5d.metal, m5ad.large, m5ad.xlarge, m5ad.2xlarge, m5ad.4xlarge, m5ad.8xlarge, m5ad.12xlarge, m5ad.16xlarge, m5ad.24xlarge, h1.2xlarge, h1.4xlarge, h1.8xlarge, h1.16xlarge, z1d.large, z1d.xlarge, z1d.2xlarge, z1d.3xlarge, z1d.6xlarge, z1d.12xlarge, z1d.metal, u-6tb1.metal, u-9tb1.metal, u-12tb1.metal, a1.medium, a1.large, a1.xlarge, a1.2xlarge, a1.4xlarge
    #       key_name: "String",
    #       monitoring: {
    #         enabled: false,
    #       },
    #       placement: {
    #         availability_zone: "String",
    #         affinity: "String",
    #         group_name: "String",
    #         host_id: "String",
    #         tenancy: "default", # accepts default, dedicated, host
    #         spread_domain: "String",
    #       },
    #       ram_disk_id: "String",
    #       disable_api_termination: false,
    #       instance_initiated_shutdown_behavior: "stop", # accepts stop, terminate
    #       user_data: "String",
    #       tag_specifications: [
    #         {
    #           resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, elastic-ip, fleet, fpga-image, host-reservation, image, instance, internet-gateway, launch-template, natgateway, network-acl, network-interface, reserved-instances, route-table, security-group, snapshot, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway
    #           tags: [
    #             {
    #               key: "String",
    #               value: "String",
    #             },
    #           ],
    #         },
    #       ],
    #       elastic_gpu_specifications: [
    #         {
    #           type: "String", # required
    #         },
    #       ],
    #       elastic_inference_accelerators: [
    #         {
    #           type: "String", # required
    #         },
    #       ],
    #       security_group_ids: ["String"],
    #       security_groups: ["String"],
    #       instance_market_options: {
    #         market_type: "spot", # accepts spot
    #         spot_options: {
    #           max_price: "String",
    #           spot_instance_type: "one-time", # accepts one-time, persistent
    #           block_duration_minutes: 1,
    #           valid_until: Time.now,
    #           instance_interruption_behavior: "hibernate", # accepts hibernate, stop, terminate
    #         },
    #       },
    #       credit_specification: {
    #         cpu_credits: "String", # required
    #       },
    #       cpu_options: {
    #         core_count: 1,
    #         threads_per_core: 1,
    #       },
    #       capacity_reservation_specification: {
    #         capacity_reservation_preference: "open", # accepts open, none
    #         capacity_reservation_target: {
    #           capacity_reservation_id: "String",
    #         },
    #       },
    #       license_specifications: [
    #         {
    #           license_configuration_arn: "String",
    #         },
    #       ],
    #       hibernation_options: {
    #         configured: false,
    #       },
    #     },
    #   })
    #
    # @example Response structure
    #
    #   resp.launch_template_version.launch_template_id #=> String
    #   resp.launch_template_version.launch_template_name #=> String
    #   resp.launch_template_version.version_number #=> Integer
    #   resp.launch_template_version.version_description #=> String
    #   resp.launch_template_version.create_time #=> Time
    #   resp.launch_template_version.created_by #=> String
    #   resp.launch_template_version.default_version #=> Boolean
    #   resp.launch_template_version.launch_template_data.kernel_id #=> String
    #   resp.launch_template_version.launch_template_data.ebs_optimized #=> Boolean
    #   resp.launch_template_version.launch_template_data.iam_instance_profile.arn #=> String
    #   resp.launch_template_version.launch_template_data.iam_instance_profile.name #=> String
    #   resp.launch_template_version.launch_template_data.block_device_mappings #=> Array
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].device_name #=> String
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].virtual_name #=> String
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].ebs.encrypted #=> Boolean
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].ebs.delete_on_termination #=> Boolean
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].ebs.iops #=> Integer
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].ebs.kms_key_id #=> String
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].ebs.snapshot_id #=> String
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].ebs.volume_size #=> Integer
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].ebs.volume_type #=> String, one of "standard", "io1", "gp2", "sc1", "st1"
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].no_device #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces #=> Array
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].associate_public_ip_address #=> Boolean
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].delete_on_termination #=> Boolean
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].description #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].device_index #=> Integer
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].groups #=> Array
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].groups[0] #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].interface_type #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].ipv_6_address_count #=> Integer
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].ipv_6_addresses #=> Array
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].ipv_6_addresses[0].ipv_6_address #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].network_interface_id #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].private_ip_address #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].private_ip_addresses #=> Array
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].private_ip_addresses[0].primary #=> Boolean
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].private_ip_addresses[0].private_ip_address #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].secondary_private_ip_address_count #=> Integer
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].subnet_id #=> String
    #   resp.launch_template_version.launch_template_data.image_id #=> String
    #   resp.launch_template_version.launch_template_data.instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.18xlarge", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge"
    #   resp.launch_template_version.launch_template_data.key_name #=> String
    #   resp.launch_template_version.launch_template_data.monitoring.enabled #=> Boolean
    #   resp.launch_template_version.launch_template_data.placement.availability_zone #=> String
    #   resp.launch_template_version.launch_template_data.placement.affinity #=> String
    #   resp.launch_template_version.launch_template_data.placement.group_name #=> String
    #   resp.launch_template_version.launch_template_data.placement.host_id #=> String
    #   resp.launch_template_version.launch_template_data.placement.tenancy #=> String, one of "default", "dedicated", "host"
    #   resp.launch_template_version.launch_template_data.placement.spread_domain #=> String
    #   resp.launch_template_version.launch_template_data.ram_disk_id #=> String
    #   resp.launch_template_version.launch_template_data.disable_api_termination #=> Boolean
    #   resp.launch_template_version.launch_template_data.instance_initiated_shutdown_behavior #=> String, one of "stop", "terminate"
    #   resp.launch_template_version.launch_template_data.user_data #=> String
    #   resp.launch_template_version.launch_template_data.tag_specifications #=> Array
    #   resp.launch_template_version.launch_template_data.tag_specifications[0].resource_type #=> String, one of "client-vpn-endpoint", "customer-gateway", "dedicated-host", "dhcp-options", "elastic-ip", "fleet", "fpga-image", "host-reservation", "image", "instance", "internet-gateway", "launch-template", "natgateway", "network-acl", "network-interface", "reserved-instances", "route-table", "security-group", "snapshot", "spot-instances-request", "subnet", "traffic-mirror-filter", "traffic-mirror-session", "traffic-mirror-target", "transit-gateway", "transit-gateway-attachment", "transit-gateway-route-table", "volume", "vpc", "vpc-peering-connection", "vpn-connection", "vpn-gateway"
    #   resp.launch_template_version.launch_template_data.tag_specifications[0].tags #=> Array
    #   resp.launch_template_version.launch_template_data.tag_specifications[0].tags[0].key #=> String
    #   resp.launch_template_version.launch_template_data.tag_specifications[0].tags[0].value #=> String
    #   resp.launch_template_version.launch_template_data.elastic_gpu_specifications #=> Array
    #   resp.launch_template_version.launch_template_data.elastic_gpu_specifications[0].type #=> String
    #   resp.launch_template_version.launch_template_data.elastic_inference_accelerators #=> Array
    #   resp.launch_template_version.launch_template_data.elastic_inference_accelerators[0].type #=> String
    #   resp.launch_template_version.launch_template_data.security_group_ids #=> Array
    #   resp.launch_template_version.launch_template_data.security_group_ids[0] #=> String
    #   resp.launch_template_version.launch_template_data.security_groups #=> Array
    #   resp.launch_template_version.launch_template_data.security_groups[0] #=> String
    #   resp.launch_template_version.launch_template_data.instance_market_options.market_type #=> String, one of "spot"
    #   resp.launch_template_version.launch_template_data.instance_market_options.spot_options.max_price #=> String
    #   resp.launch_template_version.launch_template_data.instance_market_options.spot_options.spot_instance_type #=> String, one of "one-time", "persistent"
    #   resp.launch_template_version.launch_template_data.instance_market_options.spot_options.block_duration_minutes #=> Integer
    #   resp.launch_template_version.launch_template_data.instance_market_options.spot_options.valid_until #=> Time
    #   resp.launch_template_version.launch_template_data.instance_market_options.spot_options.instance_interruption_behavior #=> String, one of "hibernate", "stop", "terminate"
    #   resp.launch_template_version.launch_template_data.credit_specification.cpu_credits #=> String
    #   resp.launch_template_version.launch_template_data.cpu_options.core_count #=> Integer
    #   resp.launch_template_version.launch_template_data.cpu_options.threads_per_core #=> Integer
    #   resp.launch_template_version.launch_template_data.capacity_reservation_specification.capacity_reservation_preference #=> String, one of "open", "none"
    #   resp.launch_template_version.launch_template_data.capacity_reservation_specification.capacity_reservation_target.capacity_reservation_id #=> String
    #   resp.launch_template_version.launch_template_data.license_specifications #=> Array
    #   resp.launch_template_version.launch_template_data.license_specifications[0].license_configuration_arn #=> String
    #   resp.launch_template_version.launch_template_data.hibernation_options.configured #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplateVersion AWS API Documentation
    #
    # @overload create_launch_template_version(params = {})
    # @param [Hash] params ({})
    def create_launch_template_version(params = {}, options = {})
      req = build_request(:create_launch_template_version, params)
      req.send_request(options)
    end

    # Creates a NAT gateway in the specified public subnet. This action
    # creates a network interface in the specified subnet with a private IP
    # address from the IP address range of the subnet. Internet-bound
    # traffic from a private subnet can be routed to the NAT gateway,
    # therefore enabling instances in the private subnet to connect to the
    # internet. For more information, see [NAT Gateways][1] in the *Amazon
    # Virtual Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html
    #
    # @option params [required, String] :allocation_id
    #   The allocation ID of an Elastic IP address to associate with the NAT
    #   gateway. If the Elastic IP address is associated with another
    #   resource, you must first disassociate it.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   Constraint: Maximum 64 ASCII characters.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [required, String] :subnet_id
    #   The subnet in which to create the NAT gateway.
    #
    # @return [Types::CreateNatGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateNatGatewayResult#client_token #client_token} => String
    #   * {Types::CreateNatGatewayResult#nat_gateway #nat_gateway} => Types::NatGateway
    #
    #
    # @example Example: To create a NAT gateway
    #
    #   # This example creates a NAT gateway in subnet subnet-1a2b3c4d and associates an Elastic IP address with the allocation ID
    #   # eipalloc-37fc1a52 with the NAT gateway.
    #
    #   resp = client.create_nat_gateway({
    #     allocation_id: "eipalloc-37fc1a52", 
    #     subnet_id: "subnet-1a2b3c4d", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     nat_gateway: {
    #       create_time: Time.parse("2015-12-17T12:45:26.732Z"), 
    #       nat_gateway_addresses: [
    #         {
    #           allocation_id: "eipalloc-37fc1a52", 
    #         }, 
    #       ], 
    #       nat_gateway_id: "nat-08d48af2a8e83edfd", 
    #       state: "pending", 
    #       subnet_id: "subnet-1a2b3c4d", 
    #       vpc_id: "vpc-1122aabb", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_nat_gateway({
    #     allocation_id: "String", # required
    #     client_token: "String",
    #     subnet_id: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.client_token #=> String
    #   resp.nat_gateway.create_time #=> Time
    #   resp.nat_gateway.delete_time #=> Time
    #   resp.nat_gateway.failure_code #=> String
    #   resp.nat_gateway.failure_message #=> String
    #   resp.nat_gateway.nat_gateway_addresses #=> Array
    #   resp.nat_gateway.nat_gateway_addresses[0].allocation_id #=> String
    #   resp.nat_gateway.nat_gateway_addresses[0].network_interface_id #=> String
    #   resp.nat_gateway.nat_gateway_addresses[0].private_ip #=> String
    #   resp.nat_gateway.nat_gateway_addresses[0].public_ip #=> String
    #   resp.nat_gateway.nat_gateway_id #=> String
    #   resp.nat_gateway.provisioned_bandwidth.provision_time #=> Time
    #   resp.nat_gateway.provisioned_bandwidth.provisioned #=> String
    #   resp.nat_gateway.provisioned_bandwidth.request_time #=> Time
    #   resp.nat_gateway.provisioned_bandwidth.requested #=> String
    #   resp.nat_gateway.provisioned_bandwidth.status #=> String
    #   resp.nat_gateway.state #=> String, one of "pending", "failed", "available", "deleting", "deleted"
    #   resp.nat_gateway.subnet_id #=> String
    #   resp.nat_gateway.vpc_id #=> String
    #   resp.nat_gateway.tags #=> Array
    #   resp.nat_gateway.tags[0].key #=> String
    #   resp.nat_gateway.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNatGateway AWS API Documentation
    #
    # @overload create_nat_gateway(params = {})
    # @param [Hash] params ({})
    def create_nat_gateway(params = {}, options = {})
      req = build_request(:create_nat_gateway, params)
      req.send_request(options)
    end

    # Creates a network ACL in a VPC. Network ACLs provide an optional layer
    # of security (in addition to security groups) for the instances in your
    # VPC.
    #
    # For more information, see [Network ACLs][1] in the *Amazon Virtual
    # Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @return [Types::CreateNetworkAclResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateNetworkAclResult#network_acl #network_acl} => Types::NetworkAcl
    #
    #
    # @example Example: To create a network ACL
    #
    #   # This example creates a network ACL for the specified VPC.
    #
    #   resp = client.create_network_acl({
    #     vpc_id: "vpc-a01106c2", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     network_acl: {
    #       associations: [
    #       ], 
    #       entries: [
    #         {
    #           cidr_block: "0.0.0.0/0", 
    #           egress: true, 
    #           protocol: "-1", 
    #           rule_action: "deny", 
    #           rule_number: 32767, 
    #         }, 
    #         {
    #           cidr_block: "0.0.0.0/0", 
    #           egress: false, 
    #           protocol: "-1", 
    #           rule_action: "deny", 
    #           rule_number: 32767, 
    #         }, 
    #       ], 
    #       is_default: false, 
    #       network_acl_id: "acl-5fb85d36", 
    #       tags: [
    #       ], 
    #       vpc_id: "vpc-a01106c2", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_network_acl({
    #     dry_run: false,
    #     vpc_id: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.network_acl.associations #=> Array
    #   resp.network_acl.associations[0].network_acl_association_id #=> String
    #   resp.network_acl.associations[0].network_acl_id #=> String
    #   resp.network_acl.associations[0].subnet_id #=> String
    #   resp.network_acl.entries #=> Array
    #   resp.network_acl.entries[0].cidr_block #=> String
    #   resp.network_acl.entries[0].egress #=> Boolean
    #   resp.network_acl.entries[0].icmp_type_code.code #=> Integer
    #   resp.network_acl.entries[0].icmp_type_code.type #=> Integer
    #   resp.network_acl.entries[0].ipv_6_cidr_block #=> String
    #   resp.network_acl.entries[0].port_range.from #=> Integer
    #   resp.network_acl.entries[0].port_range.to #=> Integer
    #   resp.network_acl.entries[0].protocol #=> String
    #   resp.network_acl.entries[0].rule_action #=> String, one of "allow", "deny"
    #   resp.network_acl.entries[0].rule_number #=> Integer
    #   resp.network_acl.is_default #=> Boolean
    #   resp.network_acl.network_acl_id #=> String
    #   resp.network_acl.tags #=> Array
    #   resp.network_acl.tags[0].key #=> String
    #   resp.network_acl.tags[0].value #=> String
    #   resp.network_acl.vpc_id #=> String
    #   resp.network_acl.owner_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAcl AWS API Documentation
    #
    # @overload create_network_acl(params = {})
    # @param [Hash] params ({})
    def create_network_acl(params = {}, options = {})
      req = build_request(:create_network_acl, params)
      req.send_request(options)
    end

    # Creates an entry (a rule) in a network ACL with the specified rule
    # number. Each network ACL has a set of numbered ingress rules and a
    # separate set of numbered egress rules. When determining whether a
    # packet should be allowed in or out of a subnet associated with the
    # ACL, we process the entries in the ACL according to the rule numbers,
    # in ascending order. Each network ACL has a set of ingress rules and a
    # separate set of egress rules.
    #
    # We recommend that you leave room between the rule numbers (for
    # example, 100, 110, 120, ...), and not number them one right after the
    # other (for example, 101, 102, 103, ...). This makes it easier to add a
    # rule between existing ones without having to renumber the rules.
    #
    # After you add an entry, you can't modify it; you must either replace
    # it, or create an entry and delete the old one.
    #
    # For more information about network ACLs, see [Network ACLs][1] in the
    # *Amazon Virtual Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html
    #
    # @option params [String] :cidr_block
    #   The IPv4 network range to allow or deny, in CIDR notation (for example
    #   `172.16.0.0/24`).
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Boolean] :egress
    #   Indicates whether this is an egress rule (rule is applied to traffic
    #   leaving the subnet).
    #
    # @option params [Types::IcmpTypeCode] :icmp_type_code
    #   ICMP protocol: The ICMP or ICMPv6 type and code. Required if
    #   specifying protocol 1 (ICMP) or protocol 58 (ICMPv6) with an IPv6 CIDR
    #   block.
    #
    # @option params [String] :ipv_6_cidr_block
    #   The IPv6 network range to allow or deny, in CIDR notation (for example
    #   `2001:db8:1234:1a00::/64`).
    #
    # @option params [required, String] :network_acl_id
    #   The ID of the network ACL.
    #
    # @option params [Types::PortRange] :port_range
    #   TCP or UDP protocols: The range of ports the rule applies to. Required
    #   if specifying protocol 6 (TCP) or 17 (UDP).
    #
    # @option params [required, String] :protocol
    #   The protocol number. A value of "-1" means all protocols. If you
    #   specify "-1" or a protocol number other than "6" (TCP), "17"
    #   (UDP), or "1" (ICMP), traffic on all ports is allowed, regardless of
    #   any ports or ICMP types or codes that you specify. If you specify
    #   protocol "58" (ICMPv6) and specify an IPv4 CIDR block, traffic for
    #   all ICMP types and codes allowed, regardless of any that you specify.
    #   If you specify protocol "58" (ICMPv6) and specify an IPv6 CIDR
    #   block, you must specify an ICMP type and code.
    #
    # @option params [required, String] :rule_action
    #   Indicates whether to allow or deny the traffic that matches the rule.
    #
    # @option params [required, Integer] :rule_number
    #   The rule number for the entry (for example, 100). ACL entries are
    #   processed in ascending order by rule number.
    #
    #   Constraints: Positive integer from 1 to 32766. The range 32767 to
    #   65535 is reserved for internal use.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To create a network ACL entry
    #
    #   # This example creates an entry for the specified network ACL. The rule allows ingress traffic from anywhere (0.0.0.0/0)
    #   # on UDP port 53 (DNS) into any associated subnet.
    #
    #   resp = client.create_network_acl_entry({
    #     cidr_block: "0.0.0.0/0", 
    #     egress: false, 
    #     network_acl_id: "acl-5fb85d36", 
    #     port_range: {
    #       from: 53, 
    #       to: 53, 
    #     }, 
    #     protocol: "17", 
    #     rule_action: "allow", 
    #     rule_number: 100, 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_network_acl_entry({
    #     cidr_block: "String",
    #     dry_run: false,
    #     egress: false, # required
    #     icmp_type_code: {
    #       code: 1,
    #       type: 1,
    #     },
    #     ipv_6_cidr_block: "String",
    #     network_acl_id: "String", # required
    #     port_range: {
    #       from: 1,
    #       to: 1,
    #     },
    #     protocol: "String", # required
    #     rule_action: "allow", # required, accepts allow, deny
    #     rule_number: 1, # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclEntry AWS API Documentation
    #
    # @overload create_network_acl_entry(params = {})
    # @param [Hash] params ({})
    def create_network_acl_entry(params = {}, options = {})
      req = build_request(:create_network_acl_entry, params)
      req.send_request(options)
    end

    # Creates a network interface in the specified subnet.
    #
    # For more information about network interfaces, see [Elastic Network
    # Interfaces][1] in the *Amazon Virtual Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html
    #
    # @option params [String] :description
    #   A description for the network interface.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<String>] :groups
    #   The IDs of one or more security groups.
    #
    # @option params [Integer] :ipv_6_address_count
    #   The number of IPv6 addresses to assign to a network interface. Amazon
    #   EC2 automatically selects the IPv6 addresses from the subnet range.
    #   You can't use this option if specifying specific IPv6 addresses. If
    #   your subnet has the `AssignIpv6AddressOnCreation` attribute set to
    #   `true`, you can specify `0` to override this setting.
    #
    # @option params [Array<Types::InstanceIpv6Address>] :ipv_6_addresses
    #   One or more specific IPv6 addresses from the IPv6 CIDR block range of
    #   your subnet. You can't use this option if you're specifying a number
    #   of IPv6 addresses.
    #
    # @option params [String] :private_ip_address
    #   The primary private IPv4 address of the network interface. If you
    #   don't specify an IPv4 address, Amazon EC2 selects one for you from
    #   the subnet's IPv4 CIDR range. If you specify an IP address, you
    #   cannot indicate any IP addresses specified in `privateIpAddresses` as
    #   primary (only one IP address can be designated as primary).
    #
    # @option params [Array<Types::PrivateIpAddressSpecification>] :private_ip_addresses
    #   One or more private IPv4 addresses.
    #
    # @option params [Integer] :secondary_private_ip_address_count
    #   The number of secondary private IPv4 addresses to assign to a network
    #   interface. When you specify a number of secondary IPv4 addresses,
    #   Amazon EC2 selects these IP addresses within the subnet's IPv4 CIDR
    #   range. You can't specify this option and specify more than one
    #   private IP address using `privateIpAddresses`.
    #
    #   The number of IP addresses you can assign to a network interface
    #   varies by instance type. For more information, see [IP Addresses Per
    #   ENI Per Instance Type][1] in the *Amazon Virtual Private Cloud User
    #   Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI
    #
    # @option params [String] :interface_type
    #   Indicates the type of network interface. To create an Elastic Fabric
    #   Adapter (EFA), specify `efa`. For more information, see [ Elastic
    #   Fabric Adapter][1] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html
    #
    # @option params [required, String] :subnet_id
    #   The ID of the subnet to associate with the network interface.
    #
    # @return [Types::CreateNetworkInterfaceResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateNetworkInterfaceResult#network_interface #network_interface} => Types::NetworkInterface
    #
    #
    # @example Example: To create a network interface
    #
    #   # This example creates a network interface for the specified subnet.
    #
    #   resp = client.create_network_interface({
    #     description: "my network interface", 
    #     groups: [
    #       "sg-903004f8", 
    #     ], 
    #     private_ip_address: "10.0.2.17", 
    #     subnet_id: "subnet-9d4a7b6c", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     network_interface: {
    #       availability_zone: "us-east-1d", 
    #       description: "my network interface", 
    #       groups: [
    #         {
    #           group_id: "sg-903004f8", 
    #           group_name: "default", 
    #         }, 
    #       ], 
    #       mac_address: "02:1a:80:41:52:9c", 
    #       network_interface_id: "eni-e5aa89a3", 
    #       owner_id: "123456789012", 
    #       private_ip_address: "10.0.2.17", 
    #       private_ip_addresses: [
    #         {
    #           primary: true, 
    #           private_ip_address: "10.0.2.17", 
    #         }, 
    #       ], 
    #       requester_managed: false, 
    #       source_dest_check: true, 
    #       status: "pending", 
    #       subnet_id: "subnet-9d4a7b6c", 
    #       tag_set: [
    #       ], 
    #       vpc_id: "vpc-a01106c2", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_network_interface({
    #     description: "String",
    #     dry_run: false,
    #     groups: ["String"],
    #     ipv_6_address_count: 1,
    #     ipv_6_addresses: [
    #       {
    #         ipv_6_address: "String",
    #       },
    #     ],
    #     private_ip_address: "String",
    #     private_ip_addresses: [
    #       {
    #         primary: false,
    #         private_ip_address: "String",
    #       },
    #     ],
    #     secondary_private_ip_address_count: 1,
    #     interface_type: "efa", # accepts efa
    #     subnet_id: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.network_interface.association.allocation_id #=> String
    #   resp.network_interface.association.association_id #=> String
    #   resp.network_interface.association.ip_owner_id #=> String
    #   resp.network_interface.association.public_dns_name #=> String
    #   resp.network_interface.association.public_ip #=> String
    #   resp.network_interface.attachment.attach_time #=> Time
    #   resp.network_interface.attachment.attachment_id #=> String
    #   resp.network_interface.attachment.delete_on_termination #=> Boolean
    #   resp.network_interface.attachment.device_index #=> Integer
    #   resp.network_interface.attachment.instance_id #=> String
    #   resp.network_interface.attachment.instance_owner_id #=> String
    #   resp.network_interface.attachment.status #=> String, one of "attaching", "attached", "detaching", "detached"
    #   resp.network_interface.availability_zone #=> String
    #   resp.network_interface.description #=> String
    #   resp.network_interface.groups #=> Array
    #   resp.network_interface.groups[0].group_name #=> String
    #   resp.network_interface.groups[0].group_id #=> String
    #   resp.network_interface.interface_type #=> String, one of "interface", "natGateway", "efa"
    #   resp.network_interface.ipv_6_addresses #=> Array
    #   resp.network_interface.ipv_6_addresses[0].ipv_6_address #=> String
    #   resp.network_interface.mac_address #=> String
    #   resp.network_interface.network_interface_id #=> String
    #   resp.network_interface.owner_id #=> String
    #   resp.network_interface.private_dns_name #=> String
    #   resp.network_interface.private_ip_address #=> String
    #   resp.network_interface.private_ip_addresses #=> Array
    #   resp.network_interface.private_ip_addresses[0].association.allocation_id #=> String
    #   resp.network_interface.private_ip_addresses[0].association.association_id #=> String
    #   resp.network_interface.private_ip_addresses[0].association.ip_owner_id #=> String
    #   resp.network_interface.private_ip_addresses[0].association.public_dns_name #=> String
    #   resp.network_interface.private_ip_addresses[0].association.public_ip #=> String
    #   resp.network_interface.private_ip_addresses[0].primary #=> Boolean
    #   resp.network_interface.private_ip_addresses[0].private_dns_name #=> String
    #   resp.network_interface.private_ip_addresses[0].private_ip_address #=> String
    #   resp.network_interface.requester_id #=> String
    #   resp.network_interface.requester_managed #=> Boolean
    #   resp.network_interface.source_dest_check #=> Boolean
    #   resp.network_interface.status #=> String, one of "available", "associated", "attaching", "in-use", "detaching"
    #   resp.network_interface.subnet_id #=> String
    #   resp.network_interface.tag_set #=> Array
    #   resp.network_interface.tag_set[0].key #=> String
    #   resp.network_interface.tag_set[0].value #=> String
    #   resp.network_interface.vpc_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterface AWS API Documentation
    #
    # @overload create_network_interface(params = {})
    # @param [Hash] params ({})
    def create_network_interface(params = {}, options = {})
      req = build_request(:create_network_interface, params)
      req.send_request(options)
    end

    # Grants an AWS-authorized account permission to attach the specified
    # network interface to an instance in their account.
    #
    # You can grant permission to a single AWS account only, and only one
    # account at a time.
    #
    # @option params [required, String] :network_interface_id
    #   The ID of the network interface.
    #
    # @option params [String] :aws_account_id
    #   The AWS account ID.
    #
    # @option params [String] :aws_service
    #   The AWS service. Currently not supported.
    #
    # @option params [required, String] :permission
    #   The type of permission to grant.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateNetworkInterfacePermissionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateNetworkInterfacePermissionResult#interface_permission #interface_permission} => Types::NetworkInterfacePermission
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_network_interface_permission({
    #     network_interface_id: "String", # required
    #     aws_account_id: "String",
    #     aws_service: "String",
    #     permission: "INSTANCE-ATTACH", # required, accepts INSTANCE-ATTACH, EIP-ASSOCIATE
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.interface_permission.network_interface_permission_id #=> String
    #   resp.interface_permission.network_interface_id #=> String
    #   resp.interface_permission.aws_account_id #=> String
    #   resp.interface_permission.aws_service #=> String
    #   resp.interface_permission.permission #=> String, one of "INSTANCE-ATTACH", "EIP-ASSOCIATE"
    #   resp.interface_permission.permission_state.state #=> String, one of "pending", "granted", "revoking", "revoked"
    #   resp.interface_permission.permission_state.status_message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfacePermission AWS API Documentation
    #
    # @overload create_network_interface_permission(params = {})
    # @param [Hash] params ({})
    def create_network_interface_permission(params = {}, options = {})
      req = build_request(:create_network_interface_permission, params)
      req.send_request(options)
    end

    # Creates a placement group in which to launch instances. The strategy
    # of the placement group determines how the instances are organized
    # within the group.
    #
    # A `cluster` placement group is a logical grouping of instances within
    # a single Availability Zone that benefit from low network latency, high
    # network throughput. A `spread` placement group places instances on
    # distinct hardware. A `partition` placement group places groups of
    # instances in different partitions, where instances in one partition do
    # not share the same hardware with instances in another partition.
    #
    # For more information, see [Placement Groups][1] in the *Amazon Elastic
    # Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :group_name
    #   A name for the placement group. Must be unique within the scope of
    #   your account for the Region.
    #
    #   Constraints: Up to 255 ASCII characters
    #
    # @option params [String] :strategy
    #   The placement strategy.
    #
    # @option params [Integer] :partition_count
    #   The number of partitions. Valid only when **Strategy** is set to
    #   `partition`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To create a placement group
    #
    #   # This example creates a placement group with the specified name.
    #
    #   resp = client.create_placement_group({
    #     group_name: "my-cluster", 
    #     strategy: "cluster", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_placement_group({
    #     dry_run: false,
    #     group_name: "String",
    #     strategy: "cluster", # accepts cluster, spread, partition
    #     partition_count: 1,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroup AWS API Documentation
    #
    # @overload create_placement_group(params = {})
    # @param [Hash] params ({})
    def create_placement_group(params = {}, options = {})
      req = build_request(:create_placement_group, params)
      req.send_request(options)
    end

    # Creates a listing for Amazon EC2 Standard Reserved Instances to be
    # sold in the Reserved Instance Marketplace. You can submit one Standard
    # Reserved Instance listing at a time. To get a list of your Standard
    # Reserved Instances, you can use the DescribeReservedInstances
    # operation.
    #
    # <note markdown="1"> Only Standard Reserved Instances can be sold in the Reserved Instance
    # Marketplace. Convertible Reserved Instances cannot be sold.
    #
    #  </note>
    #
    # The Reserved Instance Marketplace matches sellers who want to resell
    # Standard Reserved Instance capacity that they no longer need with
    # buyers who want to purchase additional capacity. Reserved Instances
    # bought and sold through the Reserved Instance Marketplace work like
    # any other Reserved Instances.
    #
    # To sell your Standard Reserved Instances, you must first register as a
    # seller in the Reserved Instance Marketplace. After completing the
    # registration process, you can create a Reserved Instance Marketplace
    # listing of some or all of your Standard Reserved Instances, and
    # specify the upfront price to receive for them. Your Standard Reserved
    # Instance listings then become available for purchase. To view the
    # details of your Standard Reserved Instance listing, you can use the
    # DescribeReservedInstancesListings operation.
    #
    # For more information, see [Reserved Instance Marketplace][1] in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html
    #
    # @option params [required, String] :client_token
    #   Unique, case-sensitive identifier you provide to ensure idempotency of
    #   your listings. This helps avoid duplicate listings. For more
    #   information, see [Ensuring Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [required, Integer] :instance_count
    #   The number of instances that are a part of a Reserved Instance account
    #   to be listed in the Reserved Instance Marketplace. This number should
    #   be less than or equal to the instance count associated with the
    #   Reserved Instance ID specified in this call.
    #
    # @option params [required, Array<Types::PriceScheduleSpecification>] :price_schedules
    #   A list specifying the price of the Standard Reserved Instance for each
    #   month remaining in the Reserved Instance term.
    #
    # @option params [required, String] :reserved_instances_id
    #   The ID of the active Standard Reserved Instance.
    #
    # @return [Types::CreateReservedInstancesListingResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateReservedInstancesListingResult#reserved_instances_listings #reserved_instances_listings} => Array&lt;Types::ReservedInstancesListing&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_reserved_instances_listing({
    #     client_token: "String", # required
    #     instance_count: 1, # required
    #     price_schedules: [ # required
    #       {
    #         currency_code: "USD", # accepts USD
    #         price: 1.0,
    #         term: 1,
    #       },
    #     ],
    #     reserved_instances_id: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.reserved_instances_listings #=> Array
    #   resp.reserved_instances_listings[0].client_token #=> String
    #   resp.reserved_instances_listings[0].create_date #=> Time
    #   resp.reserved_instances_listings[0].instance_counts #=> Array
    #   resp.reserved_instances_listings[0].instance_counts[0].instance_count #=> Integer
    #   resp.reserved_instances_listings[0].instance_counts[0].state #=> String, one of "available", "sold", "cancelled", "pending"
    #   resp.reserved_instances_listings[0].price_schedules #=> Array
    #   resp.reserved_instances_listings[0].price_schedules[0].active #=> Boolean
    #   resp.reserved_instances_listings[0].price_schedules[0].currency_code #=> String, one of "USD"
    #   resp.reserved_instances_listings[0].price_schedules[0].price #=> Float
    #   resp.reserved_instances_listings[0].price_schedules[0].term #=> Integer
    #   resp.reserved_instances_listings[0].reserved_instances_id #=> String
    #   resp.reserved_instances_listings[0].reserved_instances_listing_id #=> String
    #   resp.reserved_instances_listings[0].status #=> String, one of "active", "pending", "cancelled", "closed"
    #   resp.reserved_instances_listings[0].status_message #=> String
    #   resp.reserved_instances_listings[0].tags #=> Array
    #   resp.reserved_instances_listings[0].tags[0].key #=> String
    #   resp.reserved_instances_listings[0].tags[0].value #=> String
    #   resp.reserved_instances_listings[0].update_date #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReservedInstancesListing AWS API Documentation
    #
    # @overload create_reserved_instances_listing(params = {})
    # @param [Hash] params ({})
    def create_reserved_instances_listing(params = {}, options = {})
      req = build_request(:create_reserved_instances_listing, params)
      req.send_request(options)
    end

    # Creates a route in a route table within a VPC.
    #
    # You must specify one of the following targets: internet gateway or
    # virtual private gateway, NAT instance, NAT gateway, VPC peering
    # connection, network interface, or egress-only internet gateway.
    #
    # When determining how to route traffic, we use the route with the most
    # specific match. For example, traffic is destined for the IPv4 address
    # `192.0.2.3`, and the route table includes the following two IPv4
    # routes:
    #
    # * `192.0.2.0/24` (goes to some target A)
    #
    # * `192.0.2.0/28` (goes to some target B)
    #
    # Both routes apply to the traffic destined for `192.0.2.3`. However,
    # the second route in the list covers a smaller number of IP addresses
    # and is therefore more specific, so we use that route to determine
    # where to target the traffic.
    #
    # For more information about route tables, see [Route Tables][1] in the
    # *Amazon Virtual Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html
    #
    # @option params [String] :destination_cidr_block
    #   The IPv4 CIDR address block used for the destination match. Routing
    #   decisions are based on the most specific match.
    #
    # @option params [String] :destination_ipv_6_cidr_block
    #   The IPv6 CIDR block used for the destination match. Routing decisions
    #   are based on the most specific match.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :egress_only_internet_gateway_id
    #   \[IPv6 traffic only\] The ID of an egress-only internet gateway.
    #
    # @option params [String] :gateway_id
    #   The ID of an internet gateway or virtual private gateway attached to
    #   your VPC.
    #
    # @option params [String] :instance_id
    #   The ID of a NAT instance in your VPC. The operation fails if you
    #   specify an instance ID unless exactly one network interface is
    #   attached.
    #
    # @option params [String] :nat_gateway_id
    #   \[IPv4 traffic only\] The ID of a NAT gateway.
    #
    # @option params [String] :transit_gateway_id
    #   The ID of a transit gateway.
    #
    # @option params [String] :network_interface_id
    #   The ID of a network interface.
    #
    # @option params [required, String] :route_table_id
    #   The ID of the route table for the route.
    #
    # @option params [String] :vpc_peering_connection_id
    #   The ID of a VPC peering connection.
    #
    # @return [Types::CreateRouteResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateRouteResult#return #return} => Boolean
    #
    #
    # @example Example: To create a route
    #
    #   # This example creates a route for the specified route table. The route matches all traffic (0.0.0.0/0) and routes it to
    #   # the specified Internet gateway.
    #
    #   resp = client.create_route({
    #     destination_cidr_block: "0.0.0.0/0", 
    #     gateway_id: "igw-c0a643a9", 
    #     route_table_id: "rtb-22574640", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_route({
    #     destination_cidr_block: "String",
    #     destination_ipv_6_cidr_block: "String",
    #     dry_run: false,
    #     egress_only_internet_gateway_id: "String",
    #     gateway_id: "String",
    #     instance_id: "String",
    #     nat_gateway_id: "String",
    #     transit_gateway_id: "String",
    #     network_interface_id: "String",
    #     route_table_id: "String", # required
    #     vpc_peering_connection_id: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.return #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRoute AWS API Documentation
    #
    # @overload create_route(params = {})
    # @param [Hash] params ({})
    def create_route(params = {}, options = {})
      req = build_request(:create_route, params)
      req.send_request(options)
    end

    # Creates a route table for the specified VPC. After you create a route
    # table, you can add routes and associate the table with a subnet.
    #
    # For more information, see [Route Tables][1] in the *Amazon Virtual
    # Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @return [Types::CreateRouteTableResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateRouteTableResult#route_table #route_table} => Types::RouteTable
    #
    #
    # @example Example: To create a route table
    #
    #   # This example creates a route table for the specified VPC.
    #
    #   resp = client.create_route_table({
    #     vpc_id: "vpc-a01106c2", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     route_table: {
    #       associations: [
    #       ], 
    #       propagating_vgws: [
    #       ], 
    #       route_table_id: "rtb-22574640", 
    #       routes: [
    #         {
    #           destination_cidr_block: "10.0.0.0/16", 
    #           gateway_id: "local", 
    #           state: "active", 
    #         }, 
    #       ], 
    #       tags: [
    #       ], 
    #       vpc_id: "vpc-a01106c2", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_route_table({
    #     dry_run: false,
    #     vpc_id: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.route_table.associations #=> Array
    #   resp.route_table.associations[0].main #=> Boolean
    #   resp.route_table.associations[0].route_table_association_id #=> String
    #   resp.route_table.associations[0].route_table_id #=> String
    #   resp.route_table.associations[0].subnet_id #=> String
    #   resp.route_table.propagating_vgws #=> Array
    #   resp.route_table.propagating_vgws[0].gateway_id #=> String
    #   resp.route_table.route_table_id #=> String
    #   resp.route_table.routes #=> Array
    #   resp.route_table.routes[0].destination_cidr_block #=> String
    #   resp.route_table.routes[0].destination_ipv_6_cidr_block #=> String
    #   resp.route_table.routes[0].destination_prefix_list_id #=> String
    #   resp.route_table.routes[0].egress_only_internet_gateway_id #=> String
    #   resp.route_table.routes[0].gateway_id #=> String
    #   resp.route_table.routes[0].instance_id #=> String
    #   resp.route_table.routes[0].instance_owner_id #=> String
    #   resp.route_table.routes[0].nat_gateway_id #=> String
    #   resp.route_table.routes[0].transit_gateway_id #=> String
    #   resp.route_table.routes[0].network_interface_id #=> String
    #   resp.route_table.routes[0].origin #=> String, one of "CreateRouteTable", "CreateRoute", "EnableVgwRoutePropagation"
    #   resp.route_table.routes[0].state #=> String, one of "active", "blackhole"
    #   resp.route_table.routes[0].vpc_peering_connection_id #=> String
    #   resp.route_table.tags #=> Array
    #   resp.route_table.tags[0].key #=> String
    #   resp.route_table.tags[0].value #=> String
    #   resp.route_table.vpc_id #=> String
    #   resp.route_table.owner_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteTable AWS API Documentation
    #
    # @overload create_route_table(params = {})
    # @param [Hash] params ({})
    def create_route_table(params = {}, options = {})
      req = build_request(:create_route_table, params)
      req.send_request(options)
    end

    # Creates a security group.
    #
    # A security group acts as a virtual firewall for your instance to
    # control inbound and outbound traffic. For more information, see
    # [Amazon EC2 Security Groups][1] in the *Amazon Elastic Compute Cloud
    # User Guide* and [Security Groups for Your VPC][2] in the *Amazon
    # Virtual Private Cloud User Guide*.
    #
    # When you create a security group, you specify a friendly name of your
    # choice. You can have a security group for use in EC2-Classic with the
    # same name as a security group for use in a VPC. However, you can't
    # have two security groups for use in EC2-Classic with the same name or
    # two security groups for use in a VPC with the same name.
    #
    # You have a default security group for use in EC2-Classic and a default
    # security group for use in your VPC. If you don't specify a security
    # group when you launch an instance, the instance is launched into the
    # appropriate default security group. A default security group includes
    # a default rule that grants instances unrestricted network access to
    # each other.
    #
    # You can add or remove rules from your security groups using
    # AuthorizeSecurityGroupIngress, AuthorizeSecurityGroupEgress,
    # RevokeSecurityGroupIngress, and RevokeSecurityGroupEgress.
    #
    # For more information about VPC security group limits, see [Amazon VPC
    # Limits][3].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html
    # [2]: https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html
    # [3]: https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html
    #
    # @option params [required, String] :description
    #   A description for the security group. This is informational only.
    #
    #   Constraints: Up to 255 characters in length
    #
    #   Constraints for EC2-Classic: ASCII characters
    #
    #   Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and
    #   .\_-:/()#,@\[\]+=&amp;;\\\{\\}!$*
    #
    # @option params [required, String] :group_name
    #   The name of the security group.
    #
    #   Constraints: Up to 255 characters in length. Cannot start with `sg-`.
    #
    #   Constraints for EC2-Classic: ASCII characters
    #
    #   Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and
    #   .\_-:/()#,@\[\]+=&amp;;\\\{\\}!$*
    #
    # @option params [String] :vpc_id
    #   \[EC2-VPC\] The ID of the VPC. Required for EC2-VPC.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateSecurityGroupResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateSecurityGroupResult#group_id #group_id} => String
    #
    #
    # @example Example: To create a security group for a VPC
    #
    #   # This example creates a security group for the specified VPC.
    #
    #   resp = client.create_security_group({
    #     description: "My security group", 
    #     group_name: "my-security-group", 
    #     vpc_id: "vpc-1a2b3c4d", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     group_id: "sg-903004f8", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_security_group({
    #     description: "String", # required
    #     group_name: "String", # required
    #     vpc_id: "String",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.group_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroup AWS API Documentation
    #
    # @overload create_security_group(params = {})
    # @param [Hash] params ({})
    def create_security_group(params = {}, options = {})
      req = build_request(:create_security_group, params)
      req.send_request(options)
    end

    # Creates a snapshot of an EBS volume and stores it in Amazon S3. You
    # can use snapshots for backups, to make copies of EBS volumes, and to
    # save data before shutting down an instance.
    #
    # When a snapshot is created, any AWS Marketplace product codes that are
    # associated with the source volume are propagated to the snapshot.
    #
    # You can take a snapshot of an attached volume that is in use. However,
    # snapshots only capture data that has been written to your EBS volume
    # at the time the snapshot command is issued; this may exclude any data
    # that has been cached by any applications or the operating system. If
    # you can pause any file systems on the volume long enough to take a
    # snapshot, your snapshot should be complete. However, if you cannot
    # pause all file writes to the volume, you should unmount the volume
    # from within the instance, issue the snapshot command, and then remount
    # the volume to ensure a consistent and complete snapshot. You may
    # remount and use your volume while the snapshot status is `pending`.
    #
    # To create a snapshot for EBS volumes that serve as root devices, you
    # should stop the instance before taking the snapshot.
    #
    # Snapshots that are taken from encrypted volumes are automatically
    # encrypted. Volumes that are created from encrypted snapshots are also
    # automatically encrypted. Your encrypted volumes and any associated
    # snapshots always remain protected.
    #
    # You can tag your snapshots during creation. For more information, see
    # [Tagging Your Amazon EC2 Resources][1] in the *Amazon Elastic Compute
    # Cloud User Guide*.
    #
    # For more information, see [Amazon Elastic Block Store][2] and [Amazon
    # EBS Encryption][3] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AmazonEBS.html
    # [3]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html
    #
    # @option params [String] :description
    #   A description for the snapshot.
    #
    # @option params [required, String] :volume_id
    #   The ID of the EBS volume.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the snapshot during creation.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::Snapshot] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::Snapshot#data_encryption_key_id #data_encryption_key_id} => String
    #   * {Types::Snapshot#description #description} => String
    #   * {Types::Snapshot#encrypted #encrypted} => Boolean
    #   * {Types::Snapshot#kms_key_id #kms_key_id} => String
    #   * {Types::Snapshot#owner_id #owner_id} => String
    #   * {Types::Snapshot#progress #progress} => String
    #   * {Types::Snapshot#snapshot_id #snapshot_id} => String
    #   * {Types::Snapshot#start_time #start_time} => Time
    #   * {Types::Snapshot#state #state} => String
    #   * {Types::Snapshot#state_message #state_message} => String
    #   * {Types::Snapshot#volume_id #volume_id} => String
    #   * {Types::Snapshot#volume_size #volume_size} => Integer
    #   * {Types::Snapshot#owner_alias #owner_alias} => String
    #   * {Types::Snapshot#tags #tags} => Array&lt;Types::Tag&gt;
    #
    #
    # @example Example: To create a snapshot
    #
    #   # This example creates a snapshot of the volume with a volume ID of ``vol-1234567890abcdef0`` and a short description to
    #   # identify the snapshot.
    #
    #   resp = client.create_snapshot({
    #     description: "This is my root volume snapshot.", 
    #     volume_id: "vol-1234567890abcdef0", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     description: "This is my root volume snapshot.", 
    #     owner_id: "012345678910", 
    #     snapshot_id: "snap-066877671789bd71b", 
    #     start_time: Time.parse("2014-02-28T21:06:01.000Z"), 
    #     state: "pending", 
    #     tags: [
    #     ], 
    #     volume_id: "vol-1234567890abcdef0", 
    #     volume_size: 8, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_snapshot({
    #     description: "String",
    #     volume_id: "String", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, elastic-ip, fleet, fpga-image, host-reservation, image, instance, internet-gateway, launch-template, natgateway, network-acl, network-interface, reserved-instances, route-table, security-group, snapshot, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.data_encryption_key_id #=> String
    #   resp.description #=> String
    #   resp.encrypted #=> Boolean
    #   resp.kms_key_id #=> String
    #   resp.owner_id #=> String
    #   resp.progress #=> String
    #   resp.snapshot_id #=> String
    #   resp.start_time #=> Time
    #   resp.state #=> String, one of "pending", "completed", "error"
    #   resp.state_message #=> String
    #   resp.volume_id #=> String
    #   resp.volume_size #=> Integer
    #   resp.owner_alias #=> String
    #   resp.tags #=> Array
    #   resp.tags[0].key #=> String
    #   resp.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshot AWS API Documentation
    #
    # @overload create_snapshot(params = {})
    # @param [Hash] params ({})
    def create_snapshot(params = {}, options = {})
      req = build_request(:create_snapshot, params)
      req.send_request(options)
    end

    # Creates crash-consistent snapshots of multiple EBS volumes and stores
    # the data in S3. Volumes are chosen by specifying an instance. Any
    # attached volumes will produce one snapshot each that is
    # crash-consistent across the instance. Boot volumes can be excluded by
    # changing the paramaters.
    #
    # @option params [String] :description
    #   A description propagated to every snapshot specified by the instance.
    #
    # @option params [required, Types::InstanceSpecification] :instance_specification
    #   The instance to specify which volumes should be included in the
    #   snapshots.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   Tags to apply to every snapshot specified by the instance.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action
    #   without actually making the request. Provides an error response. If
    #   you have the required permissions, the error response is
    #   DryRunOperation. Otherwise, it is UnauthorizedOperation.
    #
    # @option params [String] :copy_tags_from_source
    #   Copies the tags from the specified volume to corresponding snapshot.
    #
    # @return [Types::CreateSnapshotsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateSnapshotsResult#snapshots #snapshots} => Array&lt;Types::SnapshotInfo&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_snapshots({
    #     description: "String",
    #     instance_specification: { # required
    #       instance_id: "String",
    #       exclude_boot_volume: false,
    #     },
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, elastic-ip, fleet, fpga-image, host-reservation, image, instance, internet-gateway, launch-template, natgateway, network-acl, network-interface, reserved-instances, route-table, security-group, snapshot, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #     copy_tags_from_source: "volume", # accepts volume
    #   })
    #
    # @example Response structure
    #
    #   resp.snapshots #=> Array
    #   resp.snapshots[0].description #=> String
    #   resp.snapshots[0].tags #=> Array
    #   resp.snapshots[0].tags[0].key #=> String
    #   resp.snapshots[0].tags[0].value #=> String
    #   resp.snapshots[0].encrypted #=> Boolean
    #   resp.snapshots[0].volume_id #=> String
    #   resp.snapshots[0].state #=> String, one of "pending", "completed", "error"
    #   resp.snapshots[0].volume_size #=> Integer
    #   resp.snapshots[0].start_time #=> Time
    #   resp.snapshots[0].progress #=> String
    #   resp.snapshots[0].owner_id #=> String
    #   resp.snapshots[0].snapshot_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshots AWS API Documentation
    #
    # @overload create_snapshots(params = {})
    # @param [Hash] params ({})
    def create_snapshots(params = {}, options = {})
      req = build_request(:create_snapshots, params)
      req.send_request(options)
    end

    # Creates a data feed for Spot Instances, enabling you to view Spot
    # Instance usage logs. You can create one data feed per AWS account. For
    # more information, see [Spot Instance Data Feed][1] in the *Amazon EC2
    # User Guide for Linux Instances*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html
    #
    # @option params [required, String] :bucket
    #   The Amazon S3 bucket in which to store the Spot Instance data feed.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :prefix
    #   A prefix for the data feed file names.
    #
    # @return [Types::CreateSpotDatafeedSubscriptionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateSpotDatafeedSubscriptionResult#spot_datafeed_subscription #spot_datafeed_subscription} => Types::SpotDatafeedSubscription
    #
    #
    # @example Example: To create a Spot Instance datafeed
    #
    #   # This example creates a Spot Instance data feed for your AWS account.
    #
    #   resp = client.create_spot_datafeed_subscription({
    #     bucket: "my-s3-bucket", 
    #     prefix: "spotdata", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     spot_datafeed_subscription: {
    #       bucket: "my-s3-bucket", 
    #       owner_id: "123456789012", 
    #       prefix: "spotdata", 
    #       state: "Active", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_spot_datafeed_subscription({
    #     bucket: "String", # required
    #     dry_run: false,
    #     prefix: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.spot_datafeed_subscription.bucket #=> String
    #   resp.spot_datafeed_subscription.fault.code #=> String
    #   resp.spot_datafeed_subscription.fault.message #=> String
    #   resp.spot_datafeed_subscription.owner_id #=> String
    #   resp.spot_datafeed_subscription.prefix #=> String
    #   resp.spot_datafeed_subscription.state #=> String, one of "Active", "Inactive"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSpotDatafeedSubscription AWS API Documentation
    #
    # @overload create_spot_datafeed_subscription(params = {})
    # @param [Hash] params ({})
    def create_spot_datafeed_subscription(params = {}, options = {})
      req = build_request(:create_spot_datafeed_subscription, params)
      req.send_request(options)
    end

    # Creates a subnet in an existing VPC.
    #
    # When you create each subnet, you provide the VPC ID and IPv4 CIDR
    # block for the subnet. After you create a subnet, you can't change its
    # CIDR block. The size of the subnet's IPv4 CIDR block can be the same
    # as a VPC's IPv4 CIDR block, or a subset of a VPC's IPv4 CIDR block.
    # If you create more than one subnet in a VPC, the subnets' CIDR blocks
    # must not overlap. The smallest IPv4 subnet (and VPC) you can create
    # uses a /28 netmask (16 IPv4 addresses), and the largest uses a /16
    # netmask (65,536 IPv4 addresses).
    #
    # If you've associated an IPv6 CIDR block with your VPC, you can create
    # a subnet with an IPv6 CIDR block that uses a /64 prefix length.
    #
    # AWS reserves both the first four and the last IPv4 address in each
    # subnet's CIDR block. They're not available for use.
    #
    # If you add more than one subnet to a VPC, they're set up in a star
    # topology with a logical router in the middle.
    #
    # If you launch an instance in a VPC using an Amazon EBS-backed AMI, the
    # IP address doesn't change if you stop and restart the instance
    # (unlike a similar instance launched outside a VPC, which gets a new IP
    # address when restarted). It's therefore possible to have a subnet
    # with no running instances (they're all stopped), but no remaining IP
    # addresses available.
    #
    # For more information about subnets, see [Your VPC and Subnets][1] in
    # the *Amazon Virtual Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html
    #
    # @option params [String] :availability_zone
    #   The Availability Zone for the subnet.
    #
    #   Default: AWS selects one for you. If you create more than one subnet
    #   in your VPC, we may not necessarily select a different zone for each
    #   subnet.
    #
    # @option params [String] :availability_zone_id
    #   The AZ ID of the subnet.
    #
    # @option params [required, String] :cidr_block
    #   The IPv4 network range for the subnet, in CIDR notation. For example,
    #   `10.0.0.0/24`.
    #
    # @option params [String] :ipv_6_cidr_block
    #   The IPv6 network range for the subnet, in CIDR notation. The subnet
    #   size must use a /64 prefix length.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateSubnetResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateSubnetResult#subnet #subnet} => Types::Subnet
    #
    #
    # @example Example: To create a subnet
    #
    #   # This example creates a subnet in the specified VPC with the specified CIDR block. We recommend that you let us select an
    #   # Availability Zone for you.
    #
    #   resp = client.create_subnet({
    #     cidr_block: "10.0.1.0/24", 
    #     vpc_id: "vpc-a01106c2", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     subnet: {
    #       availability_zone: "us-west-2c", 
    #       available_ip_address_count: 251, 
    #       cidr_block: "10.0.1.0/24", 
    #       state: "pending", 
    #       subnet_id: "subnet-9d4a7b6c", 
    #       vpc_id: "vpc-a01106c2", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_subnet({
    #     availability_zone: "String",
    #     availability_zone_id: "String",
    #     cidr_block: "String", # required
    #     ipv_6_cidr_block: "String",
    #     vpc_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.subnet.availability_zone #=> String
    #   resp.subnet.availability_zone_id #=> String
    #   resp.subnet.available_ip_address_count #=> Integer
    #   resp.subnet.cidr_block #=> String
    #   resp.subnet.default_for_az #=> Boolean
    #   resp.subnet.map_public_ip_on_launch #=> Boolean
    #   resp.subnet.state #=> String, one of "pending", "available"
    #   resp.subnet.subnet_id #=> String
    #   resp.subnet.vpc_id #=> String
    #   resp.subnet.owner_id #=> String
    #   resp.subnet.assign_ipv_6_address_on_creation #=> Boolean
    #   resp.subnet.ipv_6_cidr_block_association_set #=> Array
    #   resp.subnet.ipv_6_cidr_block_association_set[0].association_id #=> String
    #   resp.subnet.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block #=> String
    #   resp.subnet.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.subnet.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block_state.status_message #=> String
    #   resp.subnet.tags #=> Array
    #   resp.subnet.tags[0].key #=> String
    #   resp.subnet.tags[0].value #=> String
    #   resp.subnet.subnet_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnet AWS API Documentation
    #
    # @overload create_subnet(params = {})
    # @param [Hash] params ({})
    def create_subnet(params = {}, options = {})
      req = build_request(:create_subnet, params)
      req.send_request(options)
    end

    # Adds or overwrites the specified tags for the specified Amazon EC2
    # resource or resources. Each resource can have a maximum of 50 tags.
    # Each tag consists of a key and optional value. Tag keys must be unique
    # per resource.
    #
    # For more information about tags, see [Tagging Your Resources][1] in
    # the *Amazon Elastic Compute Cloud User Guide*. For more information
    # about creating IAM policies that control users' access to resources
    # based on tags, see [Supported Resource-Level Permissions for Amazon
    # EC2 API Actions][2] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :resources
    #   The IDs of the resources, separated by spaces.
    #
    #   Constraints: Up to 1000 resource IDs. We recommend breaking up this
    #   request into smaller batches.
    #
    # @option params [required, Array<Types::Tag>] :tags
    #   The tags. The `value` parameter is required, but if you don't want
    #   the tag to have a value, specify the parameter with no value, and we
    #   set the value to an empty string.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To add a tag to a resource
    #
    #   # This example adds the tag Stack=production to the specified image, or overwrites an existing tag for the AMI where the
    #   # tag key is Stack.
    #
    #   resp = client.create_tags({
    #     resources: [
    #       "ami-78a54011", 
    #     ], 
    #     tags: [
    #       {
    #         key: "Stack", 
    #         value: "production", 
    #       }, 
    #     ], 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_tags({
    #     dry_run: false,
    #     resources: ["String"], # required
    #     tags: [ # required
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTags AWS API Documentation
    #
    # @overload create_tags(params = {})
    # @param [Hash] params ({})
    def create_tags(params = {}, options = {})
      req = build_request(:create_tags, params)
      req.send_request(options)
    end

    # Creates a Traffic Mirror filter.
    #
    # A Traffic Mirror filter is a set of rules that defines the traffic to
    # mirror.
    #
    # By default, no traffic is mirrored. To mirror traffic, use
    # CreateTrafficMirrorFilterRule to add Traffic Mirror rules to the
    # filter. The rules you add define what traffic gets mirrored. You can
    # also use ModifyTrafficMirrorFilterNetworkServices to mirror supported
    # network services.
    #
    # @option params [String] :description
    #   The description of the Traffic Mirror filter.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to a Traffic Mirror filter.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @return [Types::CreateTrafficMirrorFilterResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTrafficMirrorFilterResult#traffic_mirror_filter #traffic_mirror_filter} => Types::TrafficMirrorFilter
    #   * {Types::CreateTrafficMirrorFilterResult#client_token #client_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_traffic_mirror_filter({
    #     description: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, elastic-ip, fleet, fpga-image, host-reservation, image, instance, internet-gateway, launch-template, natgateway, network-acl, network-interface, reserved-instances, route-table, security-group, snapshot, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #     client_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.traffic_mirror_filter.traffic_mirror_filter_id #=> String
    #   resp.traffic_mirror_filter.ingress_filter_rules #=> Array
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].traffic_mirror_filter_rule_id #=> String
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].traffic_mirror_filter_id #=> String
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].traffic_direction #=> String, one of "ingress", "egress"
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].rule_number #=> Integer
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].rule_action #=> String, one of "accept", "reject"
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].protocol #=> Integer
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].destination_port_range.from_port #=> Integer
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].destination_port_range.to_port #=> Integer
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].source_port_range.from_port #=> Integer
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].source_port_range.to_port #=> Integer
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].destination_cidr_block #=> String
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].source_cidr_block #=> String
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].description #=> String
    #   resp.traffic_mirror_filter.egress_filter_rules #=> Array
    #   resp.traffic_mirror_filter.egress_filter_rules[0].traffic_mirror_filter_rule_id #=> String
    #   resp.traffic_mirror_filter.egress_filter_rules[0].traffic_mirror_filter_id #=> String
    #   resp.traffic_mirror_filter.egress_filter_rules[0].traffic_direction #=> String, one of "ingress", "egress"
    #   resp.traffic_mirror_filter.egress_filter_rules[0].rule_number #=> Integer
    #   resp.traffic_mirror_filter.egress_filter_rules[0].rule_action #=> String, one of "accept", "reject"
    #   resp.traffic_mirror_filter.egress_filter_rules[0].protocol #=> Integer
    #   resp.traffic_mirror_filter.egress_filter_rules[0].destination_port_range.from_port #=> Integer
    #   resp.traffic_mirror_filter.egress_filter_rules[0].destination_port_range.to_port #=> Integer
    #   resp.traffic_mirror_filter.egress_filter_rules[0].source_port_range.from_port #=> Integer
    #   resp.traffic_mirror_filter.egress_filter_rules[0].source_port_range.to_port #=> Integer
    #   resp.traffic_mirror_filter.egress_filter_rules[0].destination_cidr_block #=> String
    #   resp.traffic_mirror_filter.egress_filter_rules[0].source_cidr_block #=> String
    #   resp.traffic_mirror_filter.egress_filter_rules[0].description #=> String
    #   resp.traffic_mirror_filter.network_services #=> Array
    #   resp.traffic_mirror_filter.network_services[0] #=> String, one of "amazon-dns"
    #   resp.traffic_mirror_filter.description #=> String
    #   resp.traffic_mirror_filter.tags #=> Array
    #   resp.traffic_mirror_filter.tags[0].key #=> String
    #   resp.traffic_mirror_filter.tags[0].value #=> String
    #   resp.client_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilter AWS API Documentation
    #
    # @overload create_traffic_mirror_filter(params = {})
    # @param [Hash] params ({})
    def create_traffic_mirror_filter(params = {}, options = {})
      req = build_request(:create_traffic_mirror_filter, params)
      req.send_request(options)
    end

    # Creates a Traffic Mirror rule.
    #
    # A Traffic Mirror rule defines the Traffic Mirror source traffic to
    # mirror.
    #
    # You need the Traffic Mirror filter ID when you create the rule.
    #
    # @option params [required, String] :traffic_mirror_filter_id
    #   The ID of the filter that this rule is associated with.
    #
    # @option params [required, String] :traffic_direction
    #   The type of traffic (`ingress` \| `egress`).
    #
    # @option params [required, Integer] :rule_number
    #   The number of the Traffic Mirror rule. This number must be unique for
    #   each Traffic Mirror rule in a given direction. The rules are processed
    #   in ascending order by rule number.
    #
    # @option params [required, String] :rule_action
    #   The action to take (`accept` \| `reject`) on the filtered traffic.
    #
    # @option params [Types::TrafficMirrorPortRangeRequest] :destination_port_range
    #   The destination port range.
    #
    # @option params [Types::TrafficMirrorPortRangeRequest] :source_port_range
    #   The source port range.
    #
    # @option params [Integer] :protocol
    #   The protocol, for example UDP, to assign to the Traffic Mirror rule.
    #
    #   For information about the protocol value, see [Protocol Numbers][1] on
    #   the Internet Assigned Numbers Authority (IANA) website.
    #
    #
    #
    #   [1]: https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml
    #
    # @option params [required, String] :destination_cidr_block
    #   The destination CIDR block to assign to the Traffic Mirror rule.
    #
    # @option params [required, String] :source_cidr_block
    #   The source CIDR block to assign to the Traffic Mirror rule.
    #
    # @option params [String] :description
    #   The description of the Traffic Mirror rule.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @return [Types::CreateTrafficMirrorFilterRuleResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTrafficMirrorFilterRuleResult#traffic_mirror_filter_rule #traffic_mirror_filter_rule} => Types::TrafficMirrorFilterRule
    #   * {Types::CreateTrafficMirrorFilterRuleResult#client_token #client_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_traffic_mirror_filter_rule({
    #     traffic_mirror_filter_id: "String", # required
    #     traffic_direction: "ingress", # required, accepts ingress, egress
    #     rule_number: 1, # required
    #     rule_action: "accept", # required, accepts accept, reject
    #     destination_port_range: {
    #       from_port: 1,
    #       to_port: 1,
    #     },
    #     source_port_range: {
    #       from_port: 1,
    #       to_port: 1,
    #     },
    #     protocol: 1,
    #     destination_cidr_block: "String", # required
    #     source_cidr_block: "String", # required
    #     description: "String",
    #     dry_run: false,
    #     client_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.traffic_mirror_filter_rule.traffic_mirror_filter_rule_id #=> String
    #   resp.traffic_mirror_filter_rule.traffic_mirror_filter_id #=> String
    #   resp.traffic_mirror_filter_rule.traffic_direction #=> String, one of "ingress", "egress"
    #   resp.traffic_mirror_filter_rule.rule_number #=> Integer
    #   resp.traffic_mirror_filter_rule.rule_action #=> String, one of "accept", "reject"
    #   resp.traffic_mirror_filter_rule.protocol #=> Integer
    #   resp.traffic_mirror_filter_rule.destination_port_range.from_port #=> Integer
    #   resp.traffic_mirror_filter_rule.destination_port_range.to_port #=> Integer
    #   resp.traffic_mirror_filter_rule.source_port_range.from_port #=> Integer
    #   resp.traffic_mirror_filter_rule.source_port_range.to_port #=> Integer
    #   resp.traffic_mirror_filter_rule.destination_cidr_block #=> String
    #   resp.traffic_mirror_filter_rule.source_cidr_block #=> String
    #   resp.traffic_mirror_filter_rule.description #=> String
    #   resp.client_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilterRule AWS API Documentation
    #
    # @overload create_traffic_mirror_filter_rule(params = {})
    # @param [Hash] params ({})
    def create_traffic_mirror_filter_rule(params = {}, options = {})
      req = build_request(:create_traffic_mirror_filter_rule, params)
      req.send_request(options)
    end

    # Creates a Traffic Mirror session.
    #
    # A Traffic Mirror session actively copies packets from a Traffic Mirror
    # source to a Traffic Mirror target. Create a filter, and then assign it
    # to the session to define a subset of the traffic to mirror, for
    # example all TCP traffic.
    #
    # The Traffic Mirror source and the Traffic Mirror target (monitoring
    # appliances) can be in the same VPC, or in a different VPC connected
    # via VPC peering or a transit gateway.
    #
    # By default, no traffic is mirrored. Use CreateTrafficMirrorFilter to
    # create filter rules that specify the traffic to mirror.
    #
    # @option params [required, String] :network_interface_id
    #   The ID of the source network interface.
    #
    # @option params [required, String] :traffic_mirror_target_id
    #   The ID of the Traffic Mirror target.
    #
    # @option params [required, String] :traffic_mirror_filter_id
    #   The ID of the Traffic Mirror filter.
    #
    # @option params [Integer] :packet_length
    #   The number of bytes in each packet to mirror. These are bytes after
    #   the VXLAN header. Do not specify this parameter when you want to
    #   mirror the entire packet. To mirror a subset of the packet, set this
    #   to the length (in bytes) that you want to mirror. For example, if you
    #   set this value to 1network0, then the first 100 bytes that meet the
    #   filter criteria are copied to the target.
    #
    #   If you do not want to mirror the entire packet, use the `PacketLength`
    #   parameter to specify the number of bytes in each packet to mirror.
    #
    # @option params [required, Integer] :session_number
    #   The session number determines the order in which sessions are
    #   evaluated when an interface is used by multiple sessions. The first
    #   session with a matching filter is the one that mirrors the packets.
    #
    #   Valid values are 1-32766.
    #
    # @option params [Integer] :virtual_network_id
    #   The VXLAN ID for the Traffic Mirror session. For more information
    #   about the VXLAN protocol, see [RFC 7348][1]. If you do not specify a
    #   `VirtualNetworkId`, an account-wide unique id is chosen at random.
    #
    #
    #
    #   [1]: https://tools.ietf.org/html/rfc7348
    #
    # @option params [String] :description
    #   The description of the Traffic Mirror session.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to a Traffic Mirror session.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @return [Types::CreateTrafficMirrorSessionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTrafficMirrorSessionResult#traffic_mirror_session #traffic_mirror_session} => Types::TrafficMirrorSession
    #   * {Types::CreateTrafficMirrorSessionResult#client_token #client_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_traffic_mirror_session({
    #     network_interface_id: "String", # required
    #     traffic_mirror_target_id: "String", # required
    #     traffic_mirror_filter_id: "String", # required
    #     packet_length: 1,
    #     session_number: 1, # required
    #     virtual_network_id: 1,
    #     description: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, elastic-ip, fleet, fpga-image, host-reservation, image, instance, internet-gateway, launch-template, natgateway, network-acl, network-interface, reserved-instances, route-table, security-group, snapshot, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #     client_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.traffic_mirror_session.traffic_mirror_session_id #=> String
    #   resp.traffic_mirror_session.traffic_mirror_target_id #=> String
    #   resp.traffic_mirror_session.traffic_mirror_filter_id #=> String
    #   resp.traffic_mirror_session.network_interface_id #=> String
    #   resp.traffic_mirror_session.owner_id #=> String
    #   resp.traffic_mirror_session.packet_length #=> Integer
    #   resp.traffic_mirror_session.session_number #=> Integer
    #   resp.traffic_mirror_session.virtual_network_id #=> Integer
    #   resp.traffic_mirror_session.description #=> String
    #   resp.traffic_mirror_session.tags #=> Array
    #   resp.traffic_mirror_session.tags[0].key #=> String
    #   resp.traffic_mirror_session.tags[0].value #=> String
    #   resp.client_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorSession AWS API Documentation
    #
    # @overload create_traffic_mirror_session(params = {})
    # @param [Hash] params ({})
    def create_traffic_mirror_session(params = {}, options = {})
      req = build_request(:create_traffic_mirror_session, params)
      req.send_request(options)
    end

    # Creates a target for your Traffic Mirror session.
    #
    # A Traffic Mirror target is the destination for mirrored traffic. The
    # Traffic Mirror source and the Traffic Mirror target (monitoring
    # appliances) can be in the same VPC, or in different VPCs connected via
    # VPC peering or a transit gateway.
    #
    # A Traffic Mirror target can be a network interface, or a Network Load
    # Balancer.
    #
    # To use the target in a Traffic Mirror session, use
    # CreateTrafficMirrorSession.
    #
    # @option params [String] :network_interface_id
    #   The network interface ID that is associated with the target.
    #
    # @option params [String] :network_load_balancer_arn
    #   The Amazon Resource Name (ARN) of the Network Load Balancer that is
    #   associated with the target.
    #
    # @option params [String] :description
    #   The description of the Traffic Mirror target.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the Traffic Mirror target.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @return [Types::CreateTrafficMirrorTargetResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTrafficMirrorTargetResult#traffic_mirror_target #traffic_mirror_target} => Types::TrafficMirrorTarget
    #   * {Types::CreateTrafficMirrorTargetResult#client_token #client_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_traffic_mirror_target({
    #     network_interface_id: "String",
    #     network_load_balancer_arn: "String",
    #     description: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, elastic-ip, fleet, fpga-image, host-reservation, image, instance, internet-gateway, launch-template, natgateway, network-acl, network-interface, reserved-instances, route-table, security-group, snapshot, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #     client_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.traffic_mirror_target.traffic_mirror_target_id #=> String
    #   resp.traffic_mirror_target.network_interface_id #=> String
    #   resp.traffic_mirror_target.network_load_balancer_arn #=> String
    #   resp.traffic_mirror_target.type #=> String, one of "network-interface", "network-load-balancer"
    #   resp.traffic_mirror_target.description #=> String
    #   resp.traffic_mirror_target.owner_id #=> String
    #   resp.traffic_mirror_target.tags #=> Array
    #   resp.traffic_mirror_target.tags[0].key #=> String
    #   resp.traffic_mirror_target.tags[0].value #=> String
    #   resp.client_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorTarget AWS API Documentation
    #
    # @overload create_traffic_mirror_target(params = {})
    # @param [Hash] params ({})
    def create_traffic_mirror_target(params = {}, options = {})
      req = build_request(:create_traffic_mirror_target, params)
      req.send_request(options)
    end

    # Creates a transit gateway.
    #
    # You can use a transit gateway to interconnect your virtual private
    # clouds (VPC) and on-premises networks. After the transit gateway
    # enters the `available` state, you can attach your VPCs and VPN
    # connections to the transit gateway.
    #
    # To attach your VPCs, use CreateTransitGatewayVpcAttachment.
    #
    # To attach a VPN connection, use CreateCustomerGateway to create a
    # customer gateway and specify the ID of the customer gateway and the ID
    # of the transit gateway in a call to CreateVpnConnection.
    #
    # When you create a transit gateway, we create a default transit gateway
    # route table and use it as the default association route table and the
    # default propagation route table. You can use
    # CreateTransitGatewayRouteTable to create additional transit gateway
    # route tables. If you disable automatic route propagation, we do not
    # create a default transit gateway route table. You can use
    # EnableTransitGatewayRouteTablePropagation to propagate routes from a
    # resource attachment to a transit gateway route table. If you disable
    # automatic associations, you can use AssociateTransitGatewayRouteTable
    # to associate a resource attachment with a transit gateway route table.
    #
    # @option params [String] :description
    #   A description of the transit gateway.
    #
    # @option params [Types::TransitGatewayRequestOptions] :options
    #   The transit gateway options.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the transit gateway.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateTransitGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTransitGatewayResult#transit_gateway #transit_gateway} => Types::TransitGateway
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_transit_gateway({
    #     description: "String",
    #     options: {
    #       amazon_side_asn: 1,
    #       auto_accept_shared_attachments: "enable", # accepts enable, disable
    #       default_route_table_association: "enable", # accepts enable, disable
    #       default_route_table_propagation: "enable", # accepts enable, disable
    #       vpn_ecmp_support: "enable", # accepts enable, disable
    #       dns_support: "enable", # accepts enable, disable
    #     },
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, elastic-ip, fleet, fpga-image, host-reservation, image, instance, internet-gateway, launch-template, natgateway, network-acl, network-interface, reserved-instances, route-table, security-group, snapshot, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway.transit_gateway_id #=> String
    #   resp.transit_gateway.transit_gateway_arn #=> String
    #   resp.transit_gateway.state #=> String, one of "pending", "available", "modifying", "deleting", "deleted"
    #   resp.transit_gateway.owner_id #=> String
    #   resp.transit_gateway.description #=> String
    #   resp.transit_gateway.creation_time #=> Time
    #   resp.transit_gateway.options.amazon_side_asn #=> Integer
    #   resp.transit_gateway.options.auto_accept_shared_attachments #=> String, one of "enable", "disable"
    #   resp.transit_gateway.options.default_route_table_association #=> String, one of "enable", "disable"
    #   resp.transit_gateway.options.association_default_route_table_id #=> String
    #   resp.transit_gateway.options.default_route_table_propagation #=> String, one of "enable", "disable"
    #   resp.transit_gateway.options.propagation_default_route_table_id #=> String
    #   resp.transit_gateway.options.vpn_ecmp_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway.options.dns_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway.tags #=> Array
    #   resp.transit_gateway.tags[0].key #=> String
    #   resp.transit_gateway.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGateway AWS API Documentation
    #
    # @overload create_transit_gateway(params = {})
    # @param [Hash] params ({})
    def create_transit_gateway(params = {}, options = {})
      req = build_request(:create_transit_gateway, params)
      req.send_request(options)
    end

    # Creates a static route for the specified transit gateway route table.
    #
    # @option params [required, String] :destination_cidr_block
    #   The CIDR range used for destination matches. Routing decisions are
    #   based on the most specific match.
    #
    # @option params [required, String] :transit_gateway_route_table_id
    #   The ID of the transit gateway route table.
    #
    # @option params [String] :transit_gateway_attachment_id
    #   The ID of the attachment.
    #
    # @option params [Boolean] :blackhole
    #   Indicates whether to drop traffic that matches this route.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateTransitGatewayRouteResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTransitGatewayRouteResult#route #route} => Types::TransitGatewayRoute
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_transit_gateway_route({
    #     destination_cidr_block: "String", # required
    #     transit_gateway_route_table_id: "String", # required
    #     transit_gateway_attachment_id: "String",
    #     blackhole: false,
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.route.destination_cidr_block #=> String
    #   resp.route.transit_gateway_attachments #=> Array
    #   resp.route.transit_gateway_attachments[0].resource_id #=> String
    #   resp.route.transit_gateway_attachments[0].transit_gateway_attachment_id #=> String
    #   resp.route.transit_gateway_attachments[0].resource_type #=> String, one of "vpc", "vpn", "direct-connect-gateway"
    #   resp.route.type #=> String, one of "static", "propagated"
    #   resp.route.state #=> String, one of "pending", "active", "blackhole", "deleting", "deleted"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRoute AWS API Documentation
    #
    # @overload create_transit_gateway_route(params = {})
    # @param [Hash] params ({})
    def create_transit_gateway_route(params = {}, options = {})
      req = build_request(:create_transit_gateway_route, params)
      req.send_request(options)
    end

    # Creates a route table for the specified transit gateway.
    #
    # @option params [required, String] :transit_gateway_id
    #   The ID of the transit gateway.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the transit gateway route table.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateTransitGatewayRouteTableResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTransitGatewayRouteTableResult#transit_gateway_route_table #transit_gateway_route_table} => Types::TransitGatewayRouteTable
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_transit_gateway_route_table({
    #     transit_gateway_id: "String", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, elastic-ip, fleet, fpga-image, host-reservation, image, instance, internet-gateway, launch-template, natgateway, network-acl, network-interface, reserved-instances, route-table, security-group, snapshot, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_route_table.transit_gateway_route_table_id #=> String
    #   resp.transit_gateway_route_table.transit_gateway_id #=> String
    #   resp.transit_gateway_route_table.state #=> String, one of "pending", "available", "deleting", "deleted"
    #   resp.transit_gateway_route_table.default_association_route_table #=> Boolean
    #   resp.transit_gateway_route_table.default_propagation_route_table #=> Boolean
    #   resp.transit_gateway_route_table.creation_time #=> Time
    #   resp.transit_gateway_route_table.tags #=> Array
    #   resp.transit_gateway_route_table.tags[0].key #=> String
    #   resp.transit_gateway_route_table.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTable AWS API Documentation
    #
    # @overload create_transit_gateway_route_table(params = {})
    # @param [Hash] params ({})
    def create_transit_gateway_route_table(params = {}, options = {})
      req = build_request(:create_transit_gateway_route_table, params)
      req.send_request(options)
    end

    # Attaches the specified VPC to the specified transit gateway.
    #
    # If you attach a VPC with a CIDR range that overlaps the CIDR range of
    # a VPC that is already attached, the new VPC CIDR range is not
    # propagated to the default propagation route table.
    #
    # To send VPC traffic to an attached transit gateway, add a route to the
    # VPC route table using CreateRoute.
    #
    # @option params [required, String] :transit_gateway_id
    #   The ID of the transit gateway.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @option params [required, Array<String>] :subnet_ids
    #   The IDs of one or more subnets. You can specify only one subnet per
    #   Availability Zone. You must specify at least one subnet, but we
    #   recommend that you specify two subnets for better availability. The
    #   transit gateway uses one IP address from each specified subnet.
    #
    # @option params [Types::CreateTransitGatewayVpcAttachmentRequestOptions] :options
    #   The VPC attachment options.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the VPC attachment.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateTransitGatewayVpcAttachmentResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTransitGatewayVpcAttachmentResult#transit_gateway_vpc_attachment #transit_gateway_vpc_attachment} => Types::TransitGatewayVpcAttachment
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_transit_gateway_vpc_attachment({
    #     transit_gateway_id: "String", # required
    #     vpc_id: "String", # required
    #     subnet_ids: ["String"], # required
    #     options: {
    #       dns_support: "enable", # accepts enable, disable
    #       ipv_6_support: "enable", # accepts enable, disable
    #     },
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, elastic-ip, fleet, fpga-image, host-reservation, image, instance, internet-gateway, launch-template, natgateway, network-acl, network-interface, reserved-instances, route-table, security-group, snapshot, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_vpc_attachment.transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_vpc_attachment.transit_gateway_id #=> String
    #   resp.transit_gateway_vpc_attachment.vpc_id #=> String
    #   resp.transit_gateway_vpc_attachment.vpc_owner_id #=> String
    #   resp.transit_gateway_vpc_attachment.state #=> String, one of "pendingAcceptance", "rollingBack", "pending", "available", "modifying", "deleting", "deleted", "failed", "rejected", "rejecting", "failing"
    #   resp.transit_gateway_vpc_attachment.subnet_ids #=> Array
    #   resp.transit_gateway_vpc_attachment.subnet_ids[0] #=> String
    #   resp.transit_gateway_vpc_attachment.creation_time #=> Time
    #   resp.transit_gateway_vpc_attachment.options.dns_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_vpc_attachment.options.ipv_6_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_vpc_attachment.tags #=> Array
    #   resp.transit_gateway_vpc_attachment.tags[0].key #=> String
    #   resp.transit_gateway_vpc_attachment.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayVpcAttachment AWS API Documentation
    #
    # @overload create_transit_gateway_vpc_attachment(params = {})
    # @param [Hash] params ({})
    def create_transit_gateway_vpc_attachment(params = {}, options = {})
      req = build_request(:create_transit_gateway_vpc_attachment, params)
      req.send_request(options)
    end

    # Creates an EBS volume that can be attached to an instance in the same
    # Availability Zone. The volume is created in the regional endpoint that
    # you send the HTTP request to. For more information see [Regions and
    # Endpoints][1].
    #
    # You can create a new empty volume or restore a volume from an EBS
    # snapshot. Any AWS Marketplace product codes from the snapshot are
    # propagated to the volume.
    #
    # You can create encrypted volumes. Encrypted volumes must be attached
    # to instances that support Amazon EBS encryption. Volumes that are
    # created from encrypted snapshots are also automatically encrypted. For
    # more information, see [Amazon EBS Encryption][2] in the *Amazon
    # Elastic Compute Cloud User Guide*.
    #
    # You can tag your volumes during creation. For more information, see
    # [Tagging Your Amazon EC2 Resources][3] in the *Amazon Elastic Compute
    # Cloud User Guide*.
    #
    # For more information, see [Creating an Amazon EBS Volume][4] in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/general/latest/gr/rande.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html
    # [3]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html
    # [4]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-creating-volume.html
    #
    # @option params [required, String] :availability_zone
    #   The Availability Zone in which to create the volume.
    #
    # @option params [Boolean] :encrypted
    #   Specifies whether the volume should be encrypted. The effect of
    #   setting the encryption state to `true` depends on the volume origin
    #   (new or from a snapshot), starting encryption state, ownership, and
    #   whether encryption by default is enabled. For more information, see
    #   [Encryption by Default][1] in the *Amazon Elastic Compute Cloud User
    #   Guide*.
    #
    #   Encrypted Amazon EBS volumes must be attached to instances that
    #   support Amazon EBS encryption. For more information, see [Supported
    #   Instance Types][2].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default
    #   [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances
    #
    # @option params [Integer] :iops
    #   The number of I/O operations per second (IOPS) to provision for the
    #   volume, with a maximum ratio of 50 IOPS/GiB. Range is 100 to 64,000
    #   IOPS for volumes in most Regions. Maximum IOPS of 64,000 is guaranteed
    #   only on [Nitro-based instances][1]. Other instance families guarantee
    #   performance up to 32,000 IOPS. For more information, see [Amazon EBS
    #   Volume Types][2] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #   This parameter is valid only for Provisioned IOPS SSD (io1) volumes.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances
    #   [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html
    #
    # @option params [String] :kms_key_id
    #   The identifier of the AWS Key Management Service (AWS KMS) customer
    #   master key (CMK) to use for Amazon EBS encryption. If this parameter
    #   is not specified, your AWS managed CMK for EBS is used. If `KmsKeyId`
    #   is specified, the encrypted state must be `true`.
    #
    #   You can specify the CMK using any of the following:
    #
    #   * Key ID. For example, key/1234abcd-12ab-34cd-56ef-1234567890ab.
    #
    #   * Key alias. For example, alias/ExampleAlias.
    #
    #   * Key ARN. For example,
    #     arn:aws:kms:*us-east-1*\:*012345678910*\:key/*abcd1234-a123-456a-a12b-a123b4cd56ef*.
    #
    #   * Alias ARN. For example,
    #     arn:aws:kms:*us-east-1*\:*012345678910*\:alias/*ExampleAlias*.
    #
    #   AWS authenticates the CMK asynchronously. Therefore, if you specify an
    #   ID, alias, or ARN that is not valid, the action can appear to
    #   complete, but eventually fails.
    #
    # @option params [Integer] :size
    #   The size of the volume, in GiBs.
    #
    #   Constraints: 1-16,384 for `gp2`, 4-16,384 for `io1`, 500-16,384 for
    #   `st1`, 500-16,384 for `sc1`, and 1-1,024 for `standard`. If you
    #   specify a snapshot, the volume size must be equal to or larger than
    #   the snapshot size.
    #
    #   Default: If you're creating the volume from a snapshot and don't
    #   specify a volume size, the default is the snapshot size.
    #
    #   <note markdown="1"> At least one of Size or SnapshotId is required.
    #
    #    </note>
    #
    # @option params [String] :snapshot_id
    #   The snapshot from which to create the volume.
    #
    #   <note markdown="1"> At least one of Size or SnapshotId are required.
    #
    #    </note>
    #
    # @option params [String] :volume_type
    #   The volume type. This can be `gp2` for General Purpose SSD, `io1` for
    #   Provisioned IOPS SSD, `st1` for Throughput Optimized HDD, `sc1` for
    #   Cold HDD, or `standard` for Magnetic volumes.
    #
    #   Default: `gp2`
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the volume during creation.
    #
    # @return [Types::Volume] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::Volume#attachments #attachments} => Array&lt;Types::VolumeAttachment&gt;
    #   * {Types::Volume#availability_zone #availability_zone} => String
    #   * {Types::Volume#create_time #create_time} => Time
    #   * {Types::Volume#encrypted #encrypted} => Boolean
    #   * {Types::Volume#kms_key_id #kms_key_id} => String
    #   * {Types::Volume#size #size} => Integer
    #   * {Types::Volume#snapshot_id #snapshot_id} => String
    #   * {Types::Volume#state #state} => String
    #   * {Types::Volume#volume_id #volume_id} => String
    #   * {Types::Volume#iops #iops} => Integer
    #   * {Types::Volume#tags #tags} => Array&lt;Types::Tag&gt;
    #   * {Types::Volume#volume_type #volume_type} => String
    #
    #
    # @example Example: To create a new volume
    #
    #   # This example creates an 80 GiB General Purpose (SSD) volume in the Availability Zone ``us-east-1a``.
    #
    #   resp = client.create_volume({
    #     availability_zone: "us-east-1a", 
    #     size: 80, 
    #     volume_type: "gp2", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     availability_zone: "us-east-1a", 
    #     create_time: Time.parse("2016-08-29T18:52:32.724Z"), 
    #     encrypted: false, 
    #     iops: 240, 
    #     size: 80, 
    #     snapshot_id: "", 
    #     state: "creating", 
    #     volume_id: "vol-6b60b7c7", 
    #     volume_type: "gp2", 
    #   }
    #
    # @example Example: To create a new Provisioned IOPS (SSD) volume from a snapshot
    #
    #   # This example creates a new Provisioned IOPS (SSD) volume with 1000 provisioned IOPS from a snapshot in the Availability
    #   # Zone ``us-east-1a``.
    #
    #   resp = client.create_volume({
    #     availability_zone: "us-east-1a", 
    #     iops: 1000, 
    #     snapshot_id: "snap-066877671789bd71b", 
    #     volume_type: "io1", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     attachments: [
    #     ], 
    #     availability_zone: "us-east-1a", 
    #     create_time: Time.parse("2016-08-29T18:52:32.724Z"), 
    #     iops: 1000, 
    #     size: 500, 
    #     snapshot_id: "snap-066877671789bd71b", 
    #     state: "creating", 
    #     tags: [
    #     ], 
    #     volume_id: "vol-1234567890abcdef0", 
    #     volume_type: "io1", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_volume({
    #     availability_zone: "String", # required
    #     encrypted: false,
    #     iops: 1,
    #     kms_key_id: "String",
    #     size: 1,
    #     snapshot_id: "String",
    #     volume_type: "standard", # accepts standard, io1, gp2, sc1, st1
    #     dry_run: false,
    #     tag_specifications: [
    #       {
    #         resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, elastic-ip, fleet, fpga-image, host-reservation, image, instance, internet-gateway, launch-template, natgateway, network-acl, network-interface, reserved-instances, route-table, security-group, snapshot, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.attachments #=> Array
    #   resp.attachments[0].attach_time #=> Time
    #   resp.attachments[0].device #=> String
    #   resp.attachments[0].instance_id #=> String
    #   resp.attachments[0].state #=> String, one of "attaching", "attached", "detaching", "detached", "busy"
    #   resp.attachments[0].volume_id #=> String
    #   resp.attachments[0].delete_on_termination #=> Boolean
    #   resp.availability_zone #=> String
    #   resp.create_time #=> Time
    #   resp.encrypted #=> Boolean
    #   resp.kms_key_id #=> String
    #   resp.size #=> Integer
    #   resp.snapshot_id #=> String
    #   resp.state #=> String, one of "creating", "available", "in-use", "deleting", "deleted", "error"
    #   resp.volume_id #=> String
    #   resp.iops #=> Integer
    #   resp.tags #=> Array
    #   resp.tags[0].key #=> String
    #   resp.tags[0].value #=> String
    #   resp.volume_type #=> String, one of "standard", "io1", "gp2", "sc1", "st1"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolume AWS API Documentation
    #
    # @overload create_volume(params = {})
    # @param [Hash] params ({})
    def create_volume(params = {}, options = {})
      req = build_request(:create_volume, params)
      req.send_request(options)
    end

    # Creates a VPC with the specified IPv4 CIDR block. The smallest VPC you
    # can create uses a /28 netmask (16 IPv4 addresses), and the largest
    # uses a /16 netmask (65,536 IPv4 addresses). For more information about
    # how large to make your VPC, see [Your VPC and Subnets][1] in the
    # *Amazon Virtual Private Cloud User Guide*.
    #
    # You can optionally request an Amazon-provided IPv6 CIDR block for the
    # VPC. The IPv6 CIDR block uses a /56 prefix length, and is allocated
    # from Amazon's pool of IPv6 addresses. You cannot choose the IPv6
    # range for your VPC.
    #
    # By default, each instance you launch in the VPC has the default DHCP
    # options, which include only a default DNS server that we provide
    # (AmazonProvidedDNS). For more information, see [DHCP Options Sets][2]
    # in the *Amazon Virtual Private Cloud User Guide*.
    #
    # You can specify the instance tenancy value for the VPC when you create
    # it. You can't change this value for the VPC after you create it. For
    # more information, see [Dedicated Instances][3] in the *Amazon Elastic
    # Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html
    # [2]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html
    # [3]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html
    #
    # @option params [required, String] :cidr_block
    #   The IPv4 network range for the VPC, in CIDR notation. For example,
    #   `10.0.0.0/16`.
    #
    # @option params [Boolean] :amazon_provided_ipv_6_cidr_block
    #   Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length
    #   for the VPC. You cannot specify the range of IP addresses, or the size
    #   of the CIDR block.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :instance_tenancy
    #   The tenancy options for instances launched into the VPC. For
    #   `default`, instances are launched with shared tenancy by default. You
    #   can launch instances with any tenancy into a shared tenancy VPC. For
    #   `dedicated`, instances are launched as dedicated tenancy instances by
    #   default. You can only launch instances with a tenancy of `dedicated`
    #   or `host` into a dedicated tenancy VPC.
    #
    #   **Important:** The `host` value cannot be used with this parameter.
    #   Use the `default` or `dedicated` values only.
    #
    #   Default: `default`
    #
    # @return [Types::CreateVpcResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateVpcResult#vpc #vpc} => Types::Vpc
    #
    #
    # @example Example: To create a VPC
    #
    #   # This example creates a VPC with the specified CIDR block.
    #
    #   resp = client.create_vpc({
    #     cidr_block: "10.0.0.0/16", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     vpc: {
    #       cidr_block: "10.0.0.0/16", 
    #       dhcp_options_id: "dopt-7a8b9c2d", 
    #       instance_tenancy: "default", 
    #       state: "pending", 
    #       vpc_id: "vpc-a01106c2", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_vpc({
    #     cidr_block: "String", # required
    #     amazon_provided_ipv_6_cidr_block: false,
    #     dry_run: false,
    #     instance_tenancy: "default", # accepts default, dedicated, host
    #   })
    #
    # @example Response structure
    #
    #   resp.vpc.cidr_block #=> String
    #   resp.vpc.dhcp_options_id #=> String
    #   resp.vpc.state #=> String, one of "pending", "available"
    #   resp.vpc.vpc_id #=> String
    #   resp.vpc.owner_id #=> String
    #   resp.vpc.instance_tenancy #=> String, one of "default", "dedicated", "host"
    #   resp.vpc.ipv_6_cidr_block_association_set #=> Array
    #   resp.vpc.ipv_6_cidr_block_association_set[0].association_id #=> String
    #   resp.vpc.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block #=> String
    #   resp.vpc.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.vpc.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block_state.status_message #=> String
    #   resp.vpc.cidr_block_association_set #=> Array
    #   resp.vpc.cidr_block_association_set[0].association_id #=> String
    #   resp.vpc.cidr_block_association_set[0].cidr_block #=> String
    #   resp.vpc.cidr_block_association_set[0].cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.vpc.cidr_block_association_set[0].cidr_block_state.status_message #=> String
    #   resp.vpc.is_default #=> Boolean
    #   resp.vpc.tags #=> Array
    #   resp.vpc.tags[0].key #=> String
    #   resp.vpc.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpc AWS API Documentation
    #
    # @overload create_vpc(params = {})
    # @param [Hash] params ({})
    def create_vpc(params = {}, options = {})
      req = build_request(:create_vpc, params)
      req.send_request(options)
    end

    # Creates a VPC endpoint for a specified service. An endpoint enables
    # you to create a private connection between your VPC and the service.
    # The service may be provided by AWS, an AWS Marketplace partner, or
    # another AWS account. For more information, see [VPC Endpoints][1] in
    # the *Amazon Virtual Private Cloud User Guide*.
    #
    # A `gateway` endpoint serves as a target for a route in your route
    # table for traffic destined for the AWS service. You can specify an
    # endpoint policy to attach to the endpoint that will control access to
    # the service from your VPC. You can also specify the VPC route tables
    # that use the endpoint.
    #
    # An `interface` endpoint is a network interface in your subnet that
    # serves as an endpoint for communicating with the specified service.
    # You can specify the subnets in which to create an endpoint, and the
    # security groups to associate with the endpoint network interface.
    #
    # Use DescribeVpcEndpointServices to get a list of supported services.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :vpc_endpoint_type
    #   The type of endpoint.
    #
    #   Default: Gateway
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC in which the endpoint will be used.
    #
    # @option params [required, String] :service_name
    #   The service name. To get a list of available services, use the
    #   DescribeVpcEndpointServices request, or get the name from the service
    #   provider.
    #
    # @option params [String] :policy_document
    #   A policy to attach to the endpoint that controls access to the
    #   service. The policy must be in valid JSON format. If this parameter is
    #   not specified, we attach a default policy that allows full access to
    #   the service.
    #
    # @option params [Array<String>] :route_table_ids
    #   (Gateway endpoint) One or more route table IDs.
    #
    # @option params [Array<String>] :subnet_ids
    #   (Interface endpoint) The ID of one or more subnets in which to create
    #   an endpoint network interface.
    #
    # @option params [Array<String>] :security_group_ids
    #   (Interface endpoint) The ID of one or more security groups to
    #   associate with the endpoint network interface.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [Boolean] :private_dns_enabled
    #   (Interface endpoint) Indicate whether to associate a private hosted
    #   zone with the specified VPC. The private hosted zone contains a record
    #   set for the default public DNS name for the service for the Region
    #   (for example, `kinesis.us-east-1.amazonaws.com`) which resolves to the
    #   private IP addresses of the endpoint network interfaces in the VPC.
    #   This enables you to make requests to the default public DNS name for
    #   the service instead of the public DNS names that are automatically
    #   generated by the VPC endpoint service.
    #
    #   To use a private hosted zone, you must set the following VPC
    #   attributes to `true`\: `enableDnsHostnames` and `enableDnsSupport`.
    #   Use ModifyVpcAttribute to set the VPC attributes.
    #
    #   Default: `true`
    #
    # @return [Types::CreateVpcEndpointResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateVpcEndpointResult#vpc_endpoint #vpc_endpoint} => Types::VpcEndpoint
    #   * {Types::CreateVpcEndpointResult#client_token #client_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_vpc_endpoint({
    #     dry_run: false,
    #     vpc_endpoint_type: "Interface", # accepts Interface, Gateway
    #     vpc_id: "String", # required
    #     service_name: "String", # required
    #     policy_document: "String",
    #     route_table_ids: ["String"],
    #     subnet_ids: ["String"],
    #     security_group_ids: ["String"],
    #     client_token: "String",
    #     private_dns_enabled: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.vpc_endpoint.vpc_endpoint_id #=> String
    #   resp.vpc_endpoint.vpc_endpoint_type #=> String, one of "Interface", "Gateway"
    #   resp.vpc_endpoint.vpc_id #=> String
    #   resp.vpc_endpoint.service_name #=> String
    #   resp.vpc_endpoint.state #=> String, one of "PendingAcceptance", "Pending", "Available", "Deleting", "Deleted", "Rejected", "Failed", "Expired"
    #   resp.vpc_endpoint.policy_document #=> String
    #   resp.vpc_endpoint.route_table_ids #=> Array
    #   resp.vpc_endpoint.route_table_ids[0] #=> String
    #   resp.vpc_endpoint.subnet_ids #=> Array
    #   resp.vpc_endpoint.subnet_ids[0] #=> String
    #   resp.vpc_endpoint.groups #=> Array
    #   resp.vpc_endpoint.groups[0].group_id #=> String
    #   resp.vpc_endpoint.groups[0].group_name #=> String
    #   resp.vpc_endpoint.private_dns_enabled #=> Boolean
    #   resp.vpc_endpoint.requester_managed #=> Boolean
    #   resp.vpc_endpoint.network_interface_ids #=> Array
    #   resp.vpc_endpoint.network_interface_ids[0] #=> String
    #   resp.vpc_endpoint.dns_entries #=> Array
    #   resp.vpc_endpoint.dns_entries[0].dns_name #=> String
    #   resp.vpc_endpoint.dns_entries[0].hosted_zone_id #=> String
    #   resp.vpc_endpoint.creation_timestamp #=> Time
    #   resp.vpc_endpoint.tags #=> Array
    #   resp.vpc_endpoint.tags[0].key #=> String
    #   resp.vpc_endpoint.tags[0].value #=> String
    #   resp.vpc_endpoint.owner_id #=> String
    #   resp.client_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpoint AWS API Documentation
    #
    # @overload create_vpc_endpoint(params = {})
    # @param [Hash] params ({})
    def create_vpc_endpoint(params = {}, options = {})
      req = build_request(:create_vpc_endpoint, params)
      req.send_request(options)
    end

    # Creates a connection notification for a specified VPC endpoint or VPC
    # endpoint service. A connection notification notifies you of specific
    # endpoint events. You must create an SNS topic to receive
    # notifications. For more information, see [Create a Topic][1] in the
    # *Amazon Simple Notification Service Developer Guide*.
    #
    # You can create a connection notification for interface endpoints only.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :service_id
    #   The ID of the endpoint service.
    #
    # @option params [String] :vpc_endpoint_id
    #   The ID of the endpoint.
    #
    # @option params [required, String] :connection_notification_arn
    #   The ARN of the SNS topic for the notifications.
    #
    # @option params [required, Array<String>] :connection_events
    #   One or more endpoint events for which to receive notifications. Valid
    #   values are `Accept`, `Connect`, `Delete`, and `Reject`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @return [Types::CreateVpcEndpointConnectionNotificationResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateVpcEndpointConnectionNotificationResult#connection_notification #connection_notification} => Types::ConnectionNotification
    #   * {Types::CreateVpcEndpointConnectionNotificationResult#client_token #client_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_vpc_endpoint_connection_notification({
    #     dry_run: false,
    #     service_id: "String",
    #     vpc_endpoint_id: "String",
    #     connection_notification_arn: "String", # required
    #     connection_events: ["String"], # required
    #     client_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.connection_notification.connection_notification_id #=> String
    #   resp.connection_notification.service_id #=> String
    #   resp.connection_notification.vpc_endpoint_id #=> String
    #   resp.connection_notification.connection_notification_type #=> String, one of "Topic"
    #   resp.connection_notification.connection_notification_arn #=> String
    #   resp.connection_notification.connection_events #=> Array
    #   resp.connection_notification.connection_events[0] #=> String
    #   resp.connection_notification.connection_notification_state #=> String, one of "Enabled", "Disabled"
    #   resp.client_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointConnectionNotification AWS API Documentation
    #
    # @overload create_vpc_endpoint_connection_notification(params = {})
    # @param [Hash] params ({})
    def create_vpc_endpoint_connection_notification(params = {}, options = {})
      req = build_request(:create_vpc_endpoint_connection_notification, params)
      req.send_request(options)
    end

    # Creates a VPC endpoint service configuration to which service
    # consumers (AWS accounts, IAM users, and IAM roles) can connect.
    # Service consumers can create an interface VPC endpoint to connect to
    # your service.
    #
    # To create an endpoint service configuration, you must first create a
    # Network Load Balancer for your service. For more information, see [VPC
    # Endpoint Services][1] in the *Amazon Virtual Private Cloud User
    # Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Boolean] :acceptance_required
    #   Indicate whether requests from service consumers to create an endpoint
    #   to your service must be accepted. To accept a request, use
    #   AcceptVpcEndpointConnections.
    #
    # @option params [required, Array<String>] :network_load_balancer_arns
    #   The Amazon Resource Names (ARNs) of one or more Network Load Balancers
    #   for your service.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html
    #
    # @return [Types::CreateVpcEndpointServiceConfigurationResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateVpcEndpointServiceConfigurationResult#service_configuration #service_configuration} => Types::ServiceConfiguration
    #   * {Types::CreateVpcEndpointServiceConfigurationResult#client_token #client_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_vpc_endpoint_service_configuration({
    #     dry_run: false,
    #     acceptance_required: false,
    #     network_load_balancer_arns: ["String"], # required
    #     client_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.service_configuration.service_type #=> Array
    #   resp.service_configuration.service_type[0].service_type #=> String, one of "Interface", "Gateway"
    #   resp.service_configuration.service_id #=> String
    #   resp.service_configuration.service_name #=> String
    #   resp.service_configuration.service_state #=> String, one of "Pending", "Available", "Deleting", "Deleted", "Failed"
    #   resp.service_configuration.availability_zones #=> Array
    #   resp.service_configuration.availability_zones[0] #=> String
    #   resp.service_configuration.acceptance_required #=> Boolean
    #   resp.service_configuration.manages_vpc_endpoints #=> Boolean
    #   resp.service_configuration.network_load_balancer_arns #=> Array
    #   resp.service_configuration.network_load_balancer_arns[0] #=> String
    #   resp.service_configuration.base_endpoint_dns_names #=> Array
    #   resp.service_configuration.base_endpoint_dns_names[0] #=> String
    #   resp.service_configuration.private_dns_name #=> String
    #   resp.service_configuration.tags #=> Array
    #   resp.service_configuration.tags[0].key #=> String
    #   resp.service_configuration.tags[0].value #=> String
    #   resp.client_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointServiceConfiguration AWS API Documentation
    #
    # @overload create_vpc_endpoint_service_configuration(params = {})
    # @param [Hash] params ({})
    def create_vpc_endpoint_service_configuration(params = {}, options = {})
      req = build_request(:create_vpc_endpoint_service_configuration, params)
      req.send_request(options)
    end

    # Requests a VPC peering connection between two VPCs: a requester VPC
    # that you own and an accepter VPC with which to create the connection.
    # The accepter VPC can belong to another AWS account and can be in a
    # different Region to the requester VPC. The requester VPC and accepter
    # VPC cannot have overlapping CIDR blocks.
    #
    # <note markdown="1"> Limitations and rules apply to a VPC peering connection. For more
    # information, see the [limitations][1] section in the *VPC Peering
    # Guide*.
    #
    #  </note>
    #
    # The owner of the accepter VPC must accept the peering request to
    # activate the peering connection. The VPC peering connection request
    # expires after 7 days, after which it cannot be accepted or rejected.
    #
    # If you create a VPC peering connection request between VPCs with
    # overlapping CIDR blocks, the VPC peering connection has a status of
    # `failed`.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-basics.html#vpc-peering-limitations
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :peer_owner_id
    #   The AWS account ID of the owner of the accepter VPC.
    #
    #   Default: Your AWS account ID
    #
    # @option params [String] :peer_vpc_id
    #   The ID of the VPC with which you are creating the VPC peering
    #   connection. You must specify this parameter in the request.
    #
    # @option params [String] :vpc_id
    #   The ID of the requester VPC. You must specify this parameter in the
    #   request.
    #
    # @option params [String] :peer_region
    #   The Region code for the accepter VPC, if the accepter VPC is located
    #   in a Region other than the Region in which you make the request.
    #
    #   Default: The Region in which you make the request.
    #
    # @return [Types::CreateVpcPeeringConnectionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateVpcPeeringConnectionResult#vpc_peering_connection #vpc_peering_connection} => Types::VpcPeeringConnection
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_vpc_peering_connection({
    #     dry_run: false,
    #     peer_owner_id: "String",
    #     peer_vpc_id: "String",
    #     vpc_id: "String",
    #     peer_region: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.vpc_peering_connection.accepter_vpc_info.cidr_block #=> String
    #   resp.vpc_peering_connection.accepter_vpc_info.ipv_6_cidr_block_set #=> Array
    #   resp.vpc_peering_connection.accepter_vpc_info.ipv_6_cidr_block_set[0].ipv_6_cidr_block #=> String
    #   resp.vpc_peering_connection.accepter_vpc_info.cidr_block_set #=> Array
    #   resp.vpc_peering_connection.accepter_vpc_info.cidr_block_set[0].cidr_block #=> String
    #   resp.vpc_peering_connection.accepter_vpc_info.owner_id #=> String
    #   resp.vpc_peering_connection.accepter_vpc_info.peering_options.allow_dns_resolution_from_remote_vpc #=> Boolean
    #   resp.vpc_peering_connection.accepter_vpc_info.peering_options.allow_egress_from_local_classic_link_to_remote_vpc #=> Boolean
    #   resp.vpc_peering_connection.accepter_vpc_info.peering_options.allow_egress_from_local_vpc_to_remote_classic_link #=> Boolean
    #   resp.vpc_peering_connection.accepter_vpc_info.vpc_id #=> String
    #   resp.vpc_peering_connection.accepter_vpc_info.region #=> String
    #   resp.vpc_peering_connection.expiration_time #=> Time
    #   resp.vpc_peering_connection.requester_vpc_info.cidr_block #=> String
    #   resp.vpc_peering_connection.requester_vpc_info.ipv_6_cidr_block_set #=> Array
    #   resp.vpc_peering_connection.requester_vpc_info.ipv_6_cidr_block_set[0].ipv_6_cidr_block #=> String
    #   resp.vpc_peering_connection.requester_vpc_info.cidr_block_set #=> Array
    #   resp.vpc_peering_connection.requester_vpc_info.cidr_block_set[0].cidr_block #=> String
    #   resp.vpc_peering_connection.requester_vpc_info.owner_id #=> String
    #   resp.vpc_peering_connection.requester_vpc_info.peering_options.allow_dns_resolution_from_remote_vpc #=> Boolean
    #   resp.vpc_peering_connection.requester_vpc_info.peering_options.allow_egress_from_local_classic_link_to_remote_vpc #=> Boolean
    #   resp.vpc_peering_connection.requester_vpc_info.peering_options.allow_egress_from_local_vpc_to_remote_classic_link #=> Boolean
    #   resp.vpc_peering_connection.requester_vpc_info.vpc_id #=> String
    #   resp.vpc_peering_connection.requester_vpc_info.region #=> String
    #   resp.vpc_peering_connection.status.code #=> String, one of "initiating-request", "pending-acceptance", "active", "deleted", "rejected", "failed", "expired", "provisioning", "deleting"
    #   resp.vpc_peering_connection.status.message #=> String
    #   resp.vpc_peering_connection.tags #=> Array
    #   resp.vpc_peering_connection.tags[0].key #=> String
    #   resp.vpc_peering_connection.tags[0].value #=> String
    #   resp.vpc_peering_connection.vpc_peering_connection_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcPeeringConnection AWS API Documentation
    #
    # @overload create_vpc_peering_connection(params = {})
    # @param [Hash] params ({})
    def create_vpc_peering_connection(params = {}, options = {})
      req = build_request(:create_vpc_peering_connection, params)
      req.send_request(options)
    end

    # Creates a VPN connection between an existing virtual private gateway
    # and a VPN customer gateway. The supported connection type is
    # `ipsec.1`.
    #
    # The response includes information that you need to give to your
    # network administrator to configure your customer gateway.
    #
    # We strongly recommend that you use HTTPS when calling this operation
    # because the response contains sensitive cryptographic information for
    # configuring your customer gateway.
    #
    # If you decide to shut down your VPN connection for any reason and
    # later create a new VPN connection, you must reconfigure your customer
    # gateway with the new information returned from this call.
    #
    # This is an idempotent operation. If you perform the operation more
    # than once, Amazon EC2 doesn't return an error.
    #
    # For more information, see [AWS Site-to-Site VPN][1] in the *AWS
    # Site-to-Site VPN User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html
    #
    # @option params [required, String] :customer_gateway_id
    #   The ID of the customer gateway.
    #
    # @option params [required, String] :type
    #   The type of VPN connection (`ipsec.1`).
    #
    # @option params [String] :vpn_gateway_id
    #   The ID of the virtual private gateway. If you specify a virtual
    #   private gateway, you cannot specify a transit gateway.
    #
    # @option params [String] :transit_gateway_id
    #   The ID of the transit gateway. If you specify a transit gateway, you
    #   cannot specify a virtual private gateway.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Types::VpnConnectionOptionsSpecification] :options
    #   The options for the VPN connection.
    #
    # @return [Types::CreateVpnConnectionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateVpnConnectionResult#vpn_connection #vpn_connection} => Types::VpnConnection
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_vpn_connection({
    #     customer_gateway_id: "String", # required
    #     type: "String", # required
    #     vpn_gateway_id: "String",
    #     transit_gateway_id: "String",
    #     dry_run: false,
    #     options: {
    #       static_routes_only: false,
    #       tunnel_options: [
    #         {
    #           tunnel_inside_cidr: "String",
    #           pre_shared_key: "String",
    #           phase_1_lifetime_seconds: 1,
    #           phase_2_lifetime_seconds: 1,
    #           rekey_margin_time_seconds: 1,
    #           rekey_fuzz_percentage: 1,
    #           replay_window_size: 1,
    #           dpd_timeout_seconds: 1,
    #           phase_1_encryption_algorithms: [
    #             {
    #               value: "String",
    #             },
    #           ],
    #           phase_2_encryption_algorithms: [
    #             {
    #               value: "String",
    #             },
    #           ],
    #           phase_1_integrity_algorithms: [
    #             {
    #               value: "String",
    #             },
    #           ],
    #           phase_2_integrity_algorithms: [
    #             {
    #               value: "String",
    #             },
    #           ],
    #           phase_1_dh_group_numbers: [
    #             {
    #               value: 1,
    #             },
    #           ],
    #           phase_2_dh_group_numbers: [
    #             {
    #               value: 1,
    #             },
    #           ],
    #           ike_versions: [
    #             {
    #               value: "String",
    #             },
    #           ],
    #         },
    #       ],
    #     },
    #   })
    #
    # @example Response structure
    #
    #   resp.vpn_connection.customer_gateway_configuration #=> String
    #   resp.vpn_connection.customer_gateway_id #=> String
    #   resp.vpn_connection.category #=> String
    #   resp.vpn_connection.state #=> String, one of "pending", "available", "deleting", "deleted"
    #   resp.vpn_connection.type #=> String, one of "ipsec.1"
    #   resp.vpn_connection.vpn_connection_id #=> String
    #   resp.vpn_connection.vpn_gateway_id #=> String
    #   resp.vpn_connection.transit_gateway_id #=> String
    #   resp.vpn_connection.options.static_routes_only #=> Boolean
    #   resp.vpn_connection.options.tunnel_options #=> Array
    #   resp.vpn_connection.options.tunnel_options[0].outside_ip_address #=> String
    #   resp.vpn_connection.options.tunnel_options[0].tunnel_inside_cidr #=> String
    #   resp.vpn_connection.options.tunnel_options[0].pre_shared_key #=> String
    #   resp.vpn_connection.options.tunnel_options[0].phase_1_lifetime_seconds #=> Integer
    #   resp.vpn_connection.options.tunnel_options[0].phase_2_lifetime_seconds #=> Integer
    #   resp.vpn_connection.options.tunnel_options[0].rekey_margin_time_seconds #=> Integer
    #   resp.vpn_connection.options.tunnel_options[0].rekey_fuzz_percentage #=> Integer
    #   resp.vpn_connection.options.tunnel_options[0].replay_window_size #=> Integer
    #   resp.vpn_connection.options.tunnel_options[0].dpd_timeout_seconds #=> Integer
    #   resp.vpn_connection.options.tunnel_options[0].phase_1_encryption_algorithms #=> Array
    #   resp.vpn_connection.options.tunnel_options[0].phase_1_encryption_algorithms[0].value #=> String
    #   resp.vpn_connection.options.tunnel_options[0].phase_2_encryption_algorithms #=> Array
    #   resp.vpn_connection.options.tunnel_options[0].phase_2_encryption_algorithms[0].value #=> String
    #   resp.vpn_connection.options.tunnel_options[0].phase_1_integrity_algorithms #=> Array
    #   resp.vpn_connection.options.tunnel_options[0].phase_1_integrity_algorithms[0].value #=> String
    #   resp.vpn_connection.options.tunnel_options[0].phase_2_integrity_algorithms #=> Array
    #   resp.vpn_connection.options.tunnel_options[0].phase_2_integrity_algorithms[0].value #=> String
    #   resp.vpn_connection.options.tunnel_options[0].phase_1_dh_group_numbers #=> Array
    #   resp.vpn_connection.options.tunnel_options[0].phase_1_dh_group_numbers[0].value #=> Integer
    #   resp.vpn_connection.options.tunnel_options[0].phase_2_dh_group_numbers #=> Array
    #   resp.vpn_connection.options.tunnel_options[0].phase_2_dh_group_numbers[0].value #=> Integer
    #   resp.vpn_connection.options.tunnel_options[0].ike_versions #=> Array
    #   resp.vpn_connection.options.tunnel_options[0].ike_versions[0].value #=> String
    #   resp.vpn_connection.routes #=> Array
    #   resp.vpn_connection.routes[0].destination_cidr_block #=> String
    #   resp.vpn_connection.routes[0].source #=> String, one of "Static"
    #   resp.vpn_connection.routes[0].state #=> String, one of "pending", "available", "deleting", "deleted"
    #   resp.vpn_connection.tags #=> Array
    #   resp.vpn_connection.tags[0].key #=> String
    #   resp.vpn_connection.tags[0].value #=> String
    #   resp.vpn_connection.vgw_telemetry #=> Array
    #   resp.vpn_connection.vgw_telemetry[0].accepted_route_count #=> Integer
    #   resp.vpn_connection.vgw_telemetry[0].last_status_change #=> Time
    #   resp.vpn_connection.vgw_telemetry[0].outside_ip_address #=> String
    #   resp.vpn_connection.vgw_telemetry[0].status #=> String, one of "UP", "DOWN"
    #   resp.vpn_connection.vgw_telemetry[0].status_message #=> String
    #   resp.vpn_connection.vgw_telemetry[0].certificate_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnection AWS API Documentation
    #
    # @overload create_vpn_connection(params = {})
    # @param [Hash] params ({})
    def create_vpn_connection(params = {}, options = {})
      req = build_request(:create_vpn_connection, params)
      req.send_request(options)
    end

    # Creates a static route associated with a VPN connection between an
    # existing virtual private gateway and a VPN customer gateway. The
    # static route allows traffic to be routed from the virtual private
    # gateway to the VPN customer gateway.
    #
    # For more information, see [AWS Site-to-Site VPN][1] in the *AWS
    # Site-to-Site VPN User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html
    #
    # @option params [required, String] :destination_cidr_block
    #   The CIDR block associated with the local subnet of the customer
    #   network.
    #
    # @option params [required, String] :vpn_connection_id
    #   The ID of the VPN connection.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_vpn_connection_route({
    #     destination_cidr_block: "String", # required
    #     vpn_connection_id: "String", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionRoute AWS API Documentation
    #
    # @overload create_vpn_connection_route(params = {})
    # @param [Hash] params ({})
    def create_vpn_connection_route(params = {}, options = {})
      req = build_request(:create_vpn_connection_route, params)
      req.send_request(options)
    end

    # Creates a virtual private gateway. A virtual private gateway is the
    # endpoint on the VPC side of your VPN connection. You can create a
    # virtual private gateway before creating the VPC itself.
    #
    # For more information, see [AWS Site-to-Site VPN][1] in the *AWS
    # Site-to-Site VPN User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html
    #
    # @option params [String] :availability_zone
    #   The Availability Zone for the virtual private gateway.
    #
    # @option params [required, String] :type
    #   The type of VPN connection this virtual private gateway supports.
    #
    # @option params [Integer] :amazon_side_asn
    #   A private Autonomous System Number (ASN) for the Amazon side of a BGP
    #   session. If you're using a 16-bit ASN, it must be in the 64512 to
    #   65534 range. If you're using a 32-bit ASN, it must be in the
    #   4200000000 to 4294967294 range.
    #
    #   Default: 64512
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateVpnGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateVpnGatewayResult#vpn_gateway #vpn_gateway} => Types::VpnGateway
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_vpn_gateway({
    #     availability_zone: "String",
    #     type: "ipsec.1", # required, accepts ipsec.1
    #     amazon_side_asn: 1,
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.vpn_gateway.availability_zone #=> String
    #   resp.vpn_gateway.state #=> String, one of "pending", "available", "deleting", "deleted"
    #   resp.vpn_gateway.type #=> String, one of "ipsec.1"
    #   resp.vpn_gateway.vpc_attachments #=> Array
    #   resp.vpn_gateway.vpc_attachments[0].state #=> String, one of "attaching", "attached", "detaching", "detached"
    #   resp.vpn_gateway.vpc_attachments[0].vpc_id #=> String
    #   resp.vpn_gateway.vpn_gateway_id #=> String
    #   resp.vpn_gateway.amazon_side_asn #=> Integer
    #   resp.vpn_gateway.tags #=> Array
    #   resp.vpn_gateway.tags[0].key #=> String
    #   resp.vpn_gateway.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnGateway AWS API Documentation
    #
    # @overload create_vpn_gateway(params = {})
    # @param [Hash] params ({})
    def create_vpn_gateway(params = {}, options = {})
      req = build_request(:create_vpn_gateway, params)
      req.send_request(options)
    end

    # Deletes the specified Client VPN endpoint. You must disassociate all
    # target networks before you can delete a Client VPN endpoint.
    #
    # @option params [required, String] :client_vpn_endpoint_id
    #   The ID of the Client VPN to be deleted.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteClientVpnEndpointResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteClientVpnEndpointResult#status #status} => Types::ClientVpnEndpointStatus
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_client_vpn_endpoint({
    #     client_vpn_endpoint_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.status.code #=> String, one of "pending-associate", "available", "deleting", "deleted"
    #   resp.status.message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnEndpoint AWS API Documentation
    #
    # @overload delete_client_vpn_endpoint(params = {})
    # @param [Hash] params ({})
    def delete_client_vpn_endpoint(params = {}, options = {})
      req = build_request(:delete_client_vpn_endpoint, params)
      req.send_request(options)
    end

    # Deletes a route from a Client VPN endpoint. You can only delete routes
    # that you manually added using the **CreateClientVpnRoute** action. You
    # cannot delete routes that were automatically added when associating a
    # subnet. To remove routes that have been automatically added,
    # disassociate the target subnet from the Client VPN endpoint.
    #
    # @option params [required, String] :client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint from which the route is to be
    #   deleted.
    #
    # @option params [String] :target_vpc_subnet_id
    #   The ID of the target subnet used by the route.
    #
    # @option params [required, String] :destination_cidr_block
    #   The IPv4 address range, in CIDR notation, of the route to be deleted.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteClientVpnRouteResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteClientVpnRouteResult#status #status} => Types::ClientVpnRouteStatus
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_client_vpn_route({
    #     client_vpn_endpoint_id: "String", # required
    #     target_vpc_subnet_id: "String",
    #     destination_cidr_block: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.status.code #=> String, one of "creating", "active", "failed", "deleting"
    #   resp.status.message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnRoute AWS API Documentation
    #
    # @overload delete_client_vpn_route(params = {})
    # @param [Hash] params ({})
    def delete_client_vpn_route(params = {}, options = {})
      req = build_request(:delete_client_vpn_route, params)
      req.send_request(options)
    end

    # Deletes the specified customer gateway. You must delete the VPN
    # connection before you can delete the customer gateway.
    #
    # @option params [required, String] :customer_gateway_id
    #   The ID of the customer gateway.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a customer gateway
    #
    #   # This example deletes the specified customer gateway.
    #
    #   resp = client.delete_customer_gateway({
    #     customer_gateway_id: "cgw-0e11f167", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_customer_gateway({
    #     customer_gateway_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCustomerGateway AWS API Documentation
    #
    # @overload delete_customer_gateway(params = {})
    # @param [Hash] params ({})
    def delete_customer_gateway(params = {}, options = {})
      req = build_request(:delete_customer_gateway, params)
      req.send_request(options)
    end

    # Deletes the specified set of DHCP options. You must disassociate the
    # set of DHCP options before you can delete it. You can disassociate the
    # set of DHCP options by associating either a new set of options or the
    # default set of options with the VPC.
    #
    # @option params [required, String] :dhcp_options_id
    #   The ID of the DHCP options set.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a DHCP options set
    #
    #   # This example deletes the specified DHCP options set.
    #
    #   resp = client.delete_dhcp_options({
    #     dhcp_options_id: "dopt-d9070ebb", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_dhcp_options({
    #     dhcp_options_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteDhcpOptions AWS API Documentation
    #
    # @overload delete_dhcp_options(params = {})
    # @param [Hash] params ({})
    def delete_dhcp_options(params = {}, options = {})
      req = build_request(:delete_dhcp_options, params)
      req.send_request(options)
    end

    # Deletes an egress-only internet gateway.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :egress_only_internet_gateway_id
    #   The ID of the egress-only internet gateway.
    #
    # @return [Types::DeleteEgressOnlyInternetGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteEgressOnlyInternetGatewayResult#return_code #return_code} => Boolean
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_egress_only_internet_gateway({
    #     dry_run: false,
    #     egress_only_internet_gateway_id: "EgressOnlyInternetGatewayId", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.return_code #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteEgressOnlyInternetGateway AWS API Documentation
    #
    # @overload delete_egress_only_internet_gateway(params = {})
    # @param [Hash] params ({})
    def delete_egress_only_internet_gateway(params = {}, options = {})
      req = build_request(:delete_egress_only_internet_gateway, params)
      req.send_request(options)
    end

    # Deletes the specified EC2 Fleet.
    #
    # After you delete an EC2 Fleet, it launches no new instances. You must
    # specify whether an EC2 Fleet should also terminate its instances. If
    # you terminate the instances, the EC2 Fleet enters the
    # `deleted_terminating` state. Otherwise, the EC2 Fleet enters the
    # `deleted_running` state, and the instances continue to run until they
    # are interrupted or you terminate them manually.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :fleet_ids
    #   The IDs of the EC2 Fleets.
    #
    # @option params [required, Boolean] :terminate_instances
    #   Indicates whether to terminate instances for an EC2 Fleet if it is
    #   deleted successfully.
    #
    # @return [Types::DeleteFleetsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteFleetsResult#successful_fleet_deletions #successful_fleet_deletions} => Array&lt;Types::DeleteFleetSuccessItem&gt;
    #   * {Types::DeleteFleetsResult#unsuccessful_fleet_deletions #unsuccessful_fleet_deletions} => Array&lt;Types::DeleteFleetErrorItem&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_fleets({
    #     dry_run: false,
    #     fleet_ids: ["FleetIdentifier"], # required
    #     terminate_instances: false, # required
    #   })
    #
    # @example Response structure
    #
    #   resp.successful_fleet_deletions #=> Array
    #   resp.successful_fleet_deletions[0].current_fleet_state #=> String, one of "submitted", "active", "deleted", "failed", "deleted_running", "deleted_terminating", "modifying"
    #   resp.successful_fleet_deletions[0].previous_fleet_state #=> String, one of "submitted", "active", "deleted", "failed", "deleted_running", "deleted_terminating", "modifying"
    #   resp.successful_fleet_deletions[0].fleet_id #=> String
    #   resp.unsuccessful_fleet_deletions #=> Array
    #   resp.unsuccessful_fleet_deletions[0].error.code #=> String, one of "fleetIdDoesNotExist", "fleetIdMalformed", "fleetNotInDeletableState", "unexpectedError"
    #   resp.unsuccessful_fleet_deletions[0].error.message #=> String
    #   resp.unsuccessful_fleet_deletions[0].fleet_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleets AWS API Documentation
    #
    # @overload delete_fleets(params = {})
    # @param [Hash] params ({})
    def delete_fleets(params = {}, options = {})
      req = build_request(:delete_fleets, params)
      req.send_request(options)
    end

    # Deletes one or more flow logs.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :flow_log_ids
    #   One or more flow log IDs.
    #
    #   Constraint: Maximum of 1000 flow log IDs.
    #
    # @return [Types::DeleteFlowLogsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteFlowLogsResult#unsuccessful #unsuccessful} => Array&lt;Types::UnsuccessfulItem&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_flow_logs({
    #     dry_run: false,
    #     flow_log_ids: ["String"], # required
    #   })
    #
    # @example Response structure
    #
    #   resp.unsuccessful #=> Array
    #   resp.unsuccessful[0].error.code #=> String
    #   resp.unsuccessful[0].error.message #=> String
    #   resp.unsuccessful[0].resource_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFlowLogs AWS API Documentation
    #
    # @overload delete_flow_logs(params = {})
    # @param [Hash] params ({})
    def delete_flow_logs(params = {}, options = {})
      req = build_request(:delete_flow_logs, params)
      req.send_request(options)
    end

    # Deletes the specified Amazon FPGA Image (AFI).
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :fpga_image_id
    #   The ID of the AFI.
    #
    # @return [Types::DeleteFpgaImageResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteFpgaImageResult#return #return} => Boolean
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_fpga_image({
    #     dry_run: false,
    #     fpga_image_id: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.return #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFpgaImage AWS API Documentation
    #
    # @overload delete_fpga_image(params = {})
    # @param [Hash] params ({})
    def delete_fpga_image(params = {}, options = {})
      req = build_request(:delete_fpga_image, params)
      req.send_request(options)
    end

    # Deletes the specified internet gateway. You must detach the internet
    # gateway from the VPC before you can delete it.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :internet_gateway_id
    #   The ID of the internet gateway.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete an Internet gateway
    #
    #   # This example deletes the specified Internet gateway.
    #
    #   resp = client.delete_internet_gateway({
    #     internet_gateway_id: "igw-c0a643a9", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_internet_gateway({
    #     dry_run: false,
    #     internet_gateway_id: "String", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInternetGateway AWS API Documentation
    #
    # @overload delete_internet_gateway(params = {})
    # @param [Hash] params ({})
    def delete_internet_gateway(params = {}, options = {})
      req = build_request(:delete_internet_gateway, params)
      req.send_request(options)
    end

    # Deletes the specified key pair, by removing the public key from Amazon
    # EC2.
    #
    # @option params [required, String] :key_name
    #   The name of the key pair.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a key pair
    #
    #   # This example deletes the specified key pair.
    #
    #   resp = client.delete_key_pair({
    #     key_name: "my-key-pair", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_key_pair({
    #     key_name: "String", # required
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPair AWS API Documentation
    #
    # @overload delete_key_pair(params = {})
    # @param [Hash] params ({})
    def delete_key_pair(params = {}, options = {})
      req = build_request(:delete_key_pair, params)
      req.send_request(options)
    end

    # Deletes a launch template. Deleting a launch template deletes all of
    # its versions.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :launch_template_id
    #   The ID of the launch template. You must specify either the launch
    #   template ID or launch template name in the request.
    #
    # @option params [String] :launch_template_name
    #   The name of the launch template. You must specify either the launch
    #   template ID or launch template name in the request.
    #
    # @return [Types::DeleteLaunchTemplateResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteLaunchTemplateResult#launch_template #launch_template} => Types::LaunchTemplate
    #
    #
    # @example Example: To delete a launch template
    #
    #   # This example deletes the specified launch template.
    #
    #   resp = client.delete_launch_template({
    #     launch_template_id: "lt-0abcd290751193123", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     launch_template: {
    #       create_time: Time.parse("2017-11-23T16:46:25.000Z"), 
    #       created_by: "arn:aws:iam::123456789012:root", 
    #       default_version_number: 2, 
    #       latest_version_number: 2, 
    #       launch_template_id: "lt-0abcd290751193123", 
    #       launch_template_name: "my-template", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_launch_template({
    #     dry_run: false,
    #     launch_template_id: "String",
    #     launch_template_name: "LaunchTemplateName",
    #   })
    #
    # @example Response structure
    #
    #   resp.launch_template.launch_template_id #=> String
    #   resp.launch_template.launch_template_name #=> String
    #   resp.launch_template.create_time #=> Time
    #   resp.launch_template.created_by #=> String
    #   resp.launch_template.default_version_number #=> Integer
    #   resp.launch_template.latest_version_number #=> Integer
    #   resp.launch_template.tags #=> Array
    #   resp.launch_template.tags[0].key #=> String
    #   resp.launch_template.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplate AWS API Documentation
    #
    # @overload delete_launch_template(params = {})
    # @param [Hash] params ({})
    def delete_launch_template(params = {}, options = {})
      req = build_request(:delete_launch_template, params)
      req.send_request(options)
    end

    # Deletes one or more versions of a launch template. You cannot delete
    # the default version of a launch template; you must first assign a
    # different version as the default. If the default version is the only
    # version for the launch template, you must delete the entire launch
    # template using DeleteLaunchTemplate.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :launch_template_id
    #   The ID of the launch template. You must specify either the launch
    #   template ID or launch template name in the request.
    #
    # @option params [String] :launch_template_name
    #   The name of the launch template. You must specify either the launch
    #   template ID or launch template name in the request.
    #
    # @option params [required, Array<String>] :versions
    #   The version numbers of one or more launch template versions to delete.
    #
    # @return [Types::DeleteLaunchTemplateVersionsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteLaunchTemplateVersionsResult#successfully_deleted_launch_template_versions #successfully_deleted_launch_template_versions} => Array&lt;Types::DeleteLaunchTemplateVersionsResponseSuccessItem&gt;
    #   * {Types::DeleteLaunchTemplateVersionsResult#unsuccessfully_deleted_launch_template_versions #unsuccessfully_deleted_launch_template_versions} => Array&lt;Types::DeleteLaunchTemplateVersionsResponseErrorItem&gt;
    #
    #
    # @example Example: To delete a launch template version
    #
    #   # This example deletes the specified launch template version.
    #
    #   resp = client.delete_launch_template_versions({
    #     launch_template_id: "lt-0abcd290751193123", 
    #     versions: [
    #       "1", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     successfully_deleted_launch_template_versions: [
    #       {
    #         launch_template_id: "lt-0abcd290751193123", 
    #         launch_template_name: "my-template", 
    #         version_number: 1, 
    #       }, 
    #     ], 
    #     unsuccessfully_deleted_launch_template_versions: [
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_launch_template_versions({
    #     dry_run: false,
    #     launch_template_id: "String",
    #     launch_template_name: "LaunchTemplateName",
    #     versions: ["String"], # required
    #   })
    #
    # @example Response structure
    #
    #   resp.successfully_deleted_launch_template_versions #=> Array
    #   resp.successfully_deleted_launch_template_versions[0].launch_template_id #=> String
    #   resp.successfully_deleted_launch_template_versions[0].launch_template_name #=> String
    #   resp.successfully_deleted_launch_template_versions[0].version_number #=> Integer
    #   resp.unsuccessfully_deleted_launch_template_versions #=> Array
    #   resp.unsuccessfully_deleted_launch_template_versions[0].launch_template_id #=> String
    #   resp.unsuccessfully_deleted_launch_template_versions[0].launch_template_name #=> String
    #   resp.unsuccessfully_deleted_launch_template_versions[0].version_number #=> Integer
    #   resp.unsuccessfully_deleted_launch_template_versions[0].response_error.code #=> String, one of "launchTemplateIdDoesNotExist", "launchTemplateIdMalformed", "launchTemplateNameDoesNotExist", "launchTemplateNameMalformed", "launchTemplateVersionDoesNotExist", "unexpectedError"
    #   resp.unsuccessfully_deleted_launch_template_versions[0].response_error.message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateVersions AWS API Documentation
    #
    # @overload delete_launch_template_versions(params = {})
    # @param [Hash] params ({})
    def delete_launch_template_versions(params = {}, options = {})
      req = build_request(:delete_launch_template_versions, params)
      req.send_request(options)
    end

    # Deletes the specified NAT gateway. Deleting a NAT gateway
    # disassociates its Elastic IP address, but does not release the address
    # from your account. Deleting a NAT gateway does not delete any NAT
    # gateway routes in your route tables.
    #
    # @option params [required, String] :nat_gateway_id
    #   The ID of the NAT gateway.
    #
    # @return [Types::DeleteNatGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteNatGatewayResult#nat_gateway_id #nat_gateway_id} => String
    #
    #
    # @example Example: To delete a NAT gateway
    #
    #   # This example deletes the specified NAT gateway.
    #
    #   resp = client.delete_nat_gateway({
    #     nat_gateway_id: "nat-04ae55e711cec5680", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     nat_gateway_id: "nat-04ae55e711cec5680", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_nat_gateway({
    #     nat_gateway_id: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.nat_gateway_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNatGateway AWS API Documentation
    #
    # @overload delete_nat_gateway(params = {})
    # @param [Hash] params ({})
    def delete_nat_gateway(params = {}, options = {})
      req = build_request(:delete_nat_gateway, params)
      req.send_request(options)
    end

    # Deletes the specified network ACL. You can't delete the ACL if it's
    # associated with any subnets. You can't delete the default network
    # ACL.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :network_acl_id
    #   The ID of the network ACL.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a network ACL
    #
    #   # This example deletes the specified network ACL.
    #
    #   resp = client.delete_network_acl({
    #     network_acl_id: "acl-5fb85d36", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_network_acl({
    #     dry_run: false,
    #     network_acl_id: "String", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAcl AWS API Documentation
    #
    # @overload delete_network_acl(params = {})
    # @param [Hash] params ({})
    def delete_network_acl(params = {}, options = {})
      req = build_request(:delete_network_acl, params)
      req.send_request(options)
    end

    # Deletes the specified ingress or egress entry (rule) from the
    # specified network ACL.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Boolean] :egress
    #   Indicates whether the rule is an egress rule.
    #
    # @option params [required, String] :network_acl_id
    #   The ID of the network ACL.
    #
    # @option params [required, Integer] :rule_number
    #   The rule number of the entry to delete.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a network ACL entry
    #
    #   # This example deletes ingress rule number 100 from the specified network ACL.
    #
    #   resp = client.delete_network_acl_entry({
    #     egress: true, 
    #     network_acl_id: "acl-5fb85d36", 
    #     rule_number: 100, 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_network_acl_entry({
    #     dry_run: false,
    #     egress: false, # required
    #     network_acl_id: "String", # required
    #     rule_number: 1, # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclEntry AWS API Documentation
    #
    # @overload delete_network_acl_entry(params = {})
    # @param [Hash] params ({})
    def delete_network_acl_entry(params = {}, options = {})
      req = build_request(:delete_network_acl_entry, params)
      req.send_request(options)
    end

    # Deletes the specified network interface. You must detach the network
    # interface before you can delete it.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :network_interface_id
    #   The ID of the network interface.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a network interface
    #
    #   # This example deletes the specified network interface.
    #
    #   resp = client.delete_network_interface({
    #     network_interface_id: "eni-e5aa89a3", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_network_interface({
    #     dry_run: false,
    #     network_interface_id: "String", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterface AWS API Documentation
    #
    # @overload delete_network_interface(params = {})
    # @param [Hash] params ({})
    def delete_network_interface(params = {}, options = {})
      req = build_request(:delete_network_interface, params)
      req.send_request(options)
    end

    # Deletes a permission for a network interface. By default, you cannot
    # delete the permission if the account for which you're removing the
    # permission has attached the network interface to an instance. However,
    # you can force delete the permission, regardless of any attachment.
    #
    # @option params [required, String] :network_interface_permission_id
    #   The ID of the network interface permission.
    #
    # @option params [Boolean] :force
    #   Specify `true` to remove the permission even if the network interface
    #   is attached to an instance.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteNetworkInterfacePermissionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteNetworkInterfacePermissionResult#return #return} => Boolean
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_network_interface_permission({
    #     network_interface_permission_id: "String", # required
    #     force: false,
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.return #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfacePermission AWS API Documentation
    #
    # @overload delete_network_interface_permission(params = {})
    # @param [Hash] params ({})
    def delete_network_interface_permission(params = {}, options = {})
      req = build_request(:delete_network_interface_permission, params)
      req.send_request(options)
    end

    # Deletes the specified placement group. You must terminate all
    # instances in the placement group before you can delete the placement
    # group. For more information, see [Placement Groups][1] in the *Amazon
    # Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :group_name
    #   The name of the placement group.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a placement group
    #
    #   # This example deletes the specified placement group.
    #
    #   resp = client.delete_placement_group({
    #     group_name: "my-cluster", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_placement_group({
    #     dry_run: false,
    #     group_name: "String", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePlacementGroup AWS API Documentation
    #
    # @overload delete_placement_group(params = {})
    # @param [Hash] params ({})
    def delete_placement_group(params = {}, options = {})
      req = build_request(:delete_placement_group, params)
      req.send_request(options)
    end

    # Deletes the specified route from the specified route table.
    #
    # @option params [String] :destination_cidr_block
    #   The IPv4 CIDR range for the route. The value you specify must match
    #   the CIDR for the route exactly.
    #
    # @option params [String] :destination_ipv_6_cidr_block
    #   The IPv6 CIDR range for the route. The value you specify must match
    #   the CIDR for the route exactly.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :route_table_id
    #   The ID of the route table.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a route
    #
    #   # This example deletes the specified route from the specified route table.
    #
    #   resp = client.delete_route({
    #     destination_cidr_block: "0.0.0.0/0", 
    #     route_table_id: "rtb-22574640", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_route({
    #     destination_cidr_block: "String",
    #     destination_ipv_6_cidr_block: "String",
    #     dry_run: false,
    #     route_table_id: "String", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRoute AWS API Documentation
    #
    # @overload delete_route(params = {})
    # @param [Hash] params ({})
    def delete_route(params = {}, options = {})
      req = build_request(:delete_route, params)
      req.send_request(options)
    end

    # Deletes the specified route table. You must disassociate the route
    # table from any subnets before you can delete it. You can't delete the
    # main route table.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :route_table_id
    #   The ID of the route table.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a route table
    #
    #   # This example deletes the specified route table.
    #
    #   resp = client.delete_route_table({
    #     route_table_id: "rtb-22574640", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_route_table({
    #     dry_run: false,
    #     route_table_id: "String", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteTable AWS API Documentation
    #
    # @overload delete_route_table(params = {})
    # @param [Hash] params ({})
    def delete_route_table(params = {}, options = {})
      req = build_request(:delete_route_table, params)
      req.send_request(options)
    end

    # Deletes a security group.
    #
    # If you attempt to delete a security group that is associated with an
    # instance, or is referenced by another security group, the operation
    # fails with `InvalidGroup.InUse` in EC2-Classic or
    # `DependencyViolation` in EC2-VPC.
    #
    # @option params [String] :group_id
    #   The ID of the security group. Required for a nondefault VPC.
    #
    # @option params [String] :group_name
    #   \[EC2-Classic, default VPC\] The name of the security group. You can
    #   specify either the security group name or the security group ID.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a security group
    #
    #   # This example deletes the specified security group.
    #
    #   resp = client.delete_security_group({
    #     group_id: "sg-903004f8", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_security_group({
    #     group_id: "String",
    #     group_name: "String",
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecurityGroup AWS API Documentation
    #
    # @overload delete_security_group(params = {})
    # @param [Hash] params ({})
    def delete_security_group(params = {}, options = {})
      req = build_request(:delete_security_group, params)
      req.send_request(options)
    end

    # Deletes the specified snapshot.
    #
    # When you make periodic snapshots of a volume, the snapshots are
    # incremental, and only the blocks on the device that have changed since
    # your last snapshot are saved in the new snapshot. When you delete a
    # snapshot, only the data not needed for any other snapshot is removed.
    # So regardless of which prior snapshots have been deleted, all active
    # snapshots will have access to all the information needed to restore
    # the volume.
    #
    # You cannot delete a snapshot of the root device of an EBS volume used
    # by a registered AMI. You must first de-register the AMI before you can
    # delete the snapshot.
    #
    # For more information, see [Deleting an Amazon EBS Snapshot][1] in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-snapshot.html
    #
    # @option params [required, String] :snapshot_id
    #   The ID of the EBS snapshot.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a snapshot
    #
    #   # This example deletes a snapshot with the snapshot ID of ``snap-1234567890abcdef0``. If the command succeeds, no output
    #   # is returned.
    #
    #   resp = client.delete_snapshot({
    #     snapshot_id: "snap-1234567890abcdef0", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_snapshot({
    #     snapshot_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSnapshot AWS API Documentation
    #
    # @overload delete_snapshot(params = {})
    # @param [Hash] params ({})
    def delete_snapshot(params = {}, options = {})
      req = build_request(:delete_snapshot, params)
      req.send_request(options)
    end

    # Deletes the data feed for Spot Instances.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To cancel a Spot Instance data feed subscription
    #
    #   # This example deletes a Spot data feed subscription for the account.
    #
    #   resp = client.delete_spot_datafeed_subscription({
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_spot_datafeed_subscription({
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSpotDatafeedSubscription AWS API Documentation
    #
    # @overload delete_spot_datafeed_subscription(params = {})
    # @param [Hash] params ({})
    def delete_spot_datafeed_subscription(params = {}, options = {})
      req = build_request(:delete_spot_datafeed_subscription, params)
      req.send_request(options)
    end

    # Deletes the specified subnet. You must terminate all running instances
    # in the subnet before you can delete the subnet.
    #
    # @option params [required, String] :subnet_id
    #   The ID of the subnet.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a subnet
    #
    #   # This example deletes the specified subnet.
    #
    #   resp = client.delete_subnet({
    #     subnet_id: "subnet-9d4a7b6c", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_subnet({
    #     subnet_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnet AWS API Documentation
    #
    # @overload delete_subnet(params = {})
    # @param [Hash] params ({})
    def delete_subnet(params = {}, options = {})
      req = build_request(:delete_subnet, params)
      req.send_request(options)
    end

    # Deletes the specified set of tags from the specified set of resources.
    #
    # To list the current tags, use DescribeTags. For more information about
    # tags, see [Tagging Your Resources][1] in the *Amazon Elastic Compute
    # Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :resources
    #   The IDs of the resources, separated by spaces.
    #
    #   Constraints: Up to 1000 resource IDs. We recommend breaking up this
    #   request into smaller batches.
    #
    # @option params [Array<Types::Tag>] :tags
    #   The tags to delete. Specify a tag key and an optional tag value to
    #   delete specific tags. If you specify a tag key without a tag value, we
    #   delete any tag with this key regardless of its value. If you specify a
    #   tag key with an empty string as the tag value, we delete the tag only
    #   if its value is an empty string.
    #
    #   If you omit this parameter, we delete all user-defined tags for the
    #   specified resources. We do not delete AWS-generated tags (tags that
    #   have the `aws:` prefix).
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a tag from a resource
    #
    #   # This example deletes the tag Stack=test from the specified image.
    #
    #   resp = client.delete_tags({
    #     resources: [
    #       "ami-78a54011", 
    #     ], 
    #     tags: [
    #       {
    #         key: "Stack", 
    #         value: "test", 
    #       }, 
    #     ], 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_tags({
    #     dry_run: false,
    #     resources: ["String"], # required
    #     tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTags AWS API Documentation
    #
    # @overload delete_tags(params = {})
    # @param [Hash] params ({})
    def delete_tags(params = {}, options = {})
      req = build_request(:delete_tags, params)
      req.send_request(options)
    end

    # Deletes the specified Traffic Mirror filter.
    #
    # You cannot delete a Traffic Mirror filter that is in use by a Traffic
    # Mirror session.
    #
    # @option params [required, String] :traffic_mirror_filter_id
    #   The ID of the Traffic Mirror filter.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteTrafficMirrorFilterResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteTrafficMirrorFilterResult#traffic_mirror_filter_id #traffic_mirror_filter_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_traffic_mirror_filter({
    #     traffic_mirror_filter_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.traffic_mirror_filter_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilter AWS API Documentation
    #
    # @overload delete_traffic_mirror_filter(params = {})
    # @param [Hash] params ({})
    def delete_traffic_mirror_filter(params = {}, options = {})
      req = build_request(:delete_traffic_mirror_filter, params)
      req.send_request(options)
    end

    # Deletes the specified Traffic Mirror rule.
    #
    # @option params [required, String] :traffic_mirror_filter_rule_id
    #   The ID of the Traffic Mirror rule.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteTrafficMirrorFilterRuleResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteTrafficMirrorFilterRuleResult#traffic_mirror_filter_rule_id #traffic_mirror_filter_rule_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_traffic_mirror_filter_rule({
    #     traffic_mirror_filter_rule_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.traffic_mirror_filter_rule_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilterRule AWS API Documentation
    #
    # @overload delete_traffic_mirror_filter_rule(params = {})
    # @param [Hash] params ({})
    def delete_traffic_mirror_filter_rule(params = {}, options = {})
      req = build_request(:delete_traffic_mirror_filter_rule, params)
      req.send_request(options)
    end

    # Deletes the specified Traffic Mirror session.
    #
    # @option params [required, String] :traffic_mirror_session_id
    #   The ID of the Traffic Mirror session.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteTrafficMirrorSessionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteTrafficMirrorSessionResult#traffic_mirror_session_id #traffic_mirror_session_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_traffic_mirror_session({
    #     traffic_mirror_session_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.traffic_mirror_session_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorSession AWS API Documentation
    #
    # @overload delete_traffic_mirror_session(params = {})
    # @param [Hash] params ({})
    def delete_traffic_mirror_session(params = {}, options = {})
      req = build_request(:delete_traffic_mirror_session, params)
      req.send_request(options)
    end

    # Deletes the specified Traffic Mirror target.
    #
    # You cannot delete a Traffic Mirror target that is in use by a Traffic
    # Mirror session.
    #
    # @option params [required, String] :traffic_mirror_target_id
    #   The ID of the Traffic Mirror target.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteTrafficMirrorTargetResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteTrafficMirrorTargetResult#traffic_mirror_target_id #traffic_mirror_target_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_traffic_mirror_target({
    #     traffic_mirror_target_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.traffic_mirror_target_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorTarget AWS API Documentation
    #
    # @overload delete_traffic_mirror_target(params = {})
    # @param [Hash] params ({})
    def delete_traffic_mirror_target(params = {}, options = {})
      req = build_request(:delete_traffic_mirror_target, params)
      req.send_request(options)
    end

    # Deletes the specified transit gateway.
    #
    # @option params [required, String] :transit_gateway_id
    #   The ID of the transit gateway.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteTransitGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteTransitGatewayResult#transit_gateway #transit_gateway} => Types::TransitGateway
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_transit_gateway({
    #     transit_gateway_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway.transit_gateway_id #=> String
    #   resp.transit_gateway.transit_gateway_arn #=> String
    #   resp.transit_gateway.state #=> String, one of "pending", "available", "modifying", "deleting", "deleted"
    #   resp.transit_gateway.owner_id #=> String
    #   resp.transit_gateway.description #=> String
    #   resp.transit_gateway.creation_time #=> Time
    #   resp.transit_gateway.options.amazon_side_asn #=> Integer
    #   resp.transit_gateway.options.auto_accept_shared_attachments #=> String, one of "enable", "disable"
    #   resp.transit_gateway.options.default_route_table_association #=> String, one of "enable", "disable"
    #   resp.transit_gateway.options.association_default_route_table_id #=> String
    #   resp.transit_gateway.options.default_route_table_propagation #=> String, one of "enable", "disable"
    #   resp.transit_gateway.options.propagation_default_route_table_id #=> String
    #   resp.transit_gateway.options.vpn_ecmp_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway.options.dns_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway.tags #=> Array
    #   resp.transit_gateway.tags[0].key #=> String
    #   resp.transit_gateway.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGateway AWS API Documentation
    #
    # @overload delete_transit_gateway(params = {})
    # @param [Hash] params ({})
    def delete_transit_gateway(params = {}, options = {})
      req = build_request(:delete_transit_gateway, params)
      req.send_request(options)
    end

    # Deletes the specified route from the specified transit gateway route
    # table.
    #
    # @option params [required, String] :transit_gateway_route_table_id
    #   The ID of the transit gateway route table.
    #
    # @option params [required, String] :destination_cidr_block
    #   The CIDR range for the route. This must match the CIDR for the route
    #   exactly.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteTransitGatewayRouteResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteTransitGatewayRouteResult#route #route} => Types::TransitGatewayRoute
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_transit_gateway_route({
    #     transit_gateway_route_table_id: "String", # required
    #     destination_cidr_block: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.route.destination_cidr_block #=> String
    #   resp.route.transit_gateway_attachments #=> Array
    #   resp.route.transit_gateway_attachments[0].resource_id #=> String
    #   resp.route.transit_gateway_attachments[0].transit_gateway_attachment_id #=> String
    #   resp.route.transit_gateway_attachments[0].resource_type #=> String, one of "vpc", "vpn", "direct-connect-gateway"
    #   resp.route.type #=> String, one of "static", "propagated"
    #   resp.route.state #=> String, one of "pending", "active", "blackhole", "deleting", "deleted"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRoute AWS API Documentation
    #
    # @overload delete_transit_gateway_route(params = {})
    # @param [Hash] params ({})
    def delete_transit_gateway_route(params = {}, options = {})
      req = build_request(:delete_transit_gateway_route, params)
      req.send_request(options)
    end

    # Deletes the specified transit gateway route table. You must
    # disassociate the route table from any transit gateway route tables
    # before you can delete it.
    #
    # @option params [required, String] :transit_gateway_route_table_id
    #   The ID of the transit gateway route table.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteTransitGatewayRouteTableResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteTransitGatewayRouteTableResult#transit_gateway_route_table #transit_gateway_route_table} => Types::TransitGatewayRouteTable
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_transit_gateway_route_table({
    #     transit_gateway_route_table_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_route_table.transit_gateway_route_table_id #=> String
    #   resp.transit_gateway_route_table.transit_gateway_id #=> String
    #   resp.transit_gateway_route_table.state #=> String, one of "pending", "available", "deleting", "deleted"
    #   resp.transit_gateway_route_table.default_association_route_table #=> Boolean
    #   resp.transit_gateway_route_table.default_propagation_route_table #=> Boolean
    #   resp.transit_gateway_route_table.creation_time #=> Time
    #   resp.transit_gateway_route_table.tags #=> Array
    #   resp.transit_gateway_route_table.tags[0].key #=> String
    #   resp.transit_gateway_route_table.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTable AWS API Documentation
    #
    # @overload delete_transit_gateway_route_table(params = {})
    # @param [Hash] params ({})
    def delete_transit_gateway_route_table(params = {}, options = {})
      req = build_request(:delete_transit_gateway_route_table, params)
      req.send_request(options)
    end

    # Deletes the specified VPC attachment.
    #
    # @option params [required, String] :transit_gateway_attachment_id
    #   The ID of the attachment.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeleteTransitGatewayVpcAttachmentResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteTransitGatewayVpcAttachmentResult#transit_gateway_vpc_attachment #transit_gateway_vpc_attachment} => Types::TransitGatewayVpcAttachment
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_transit_gateway_vpc_attachment({
    #     transit_gateway_attachment_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_vpc_attachment.transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_vpc_attachment.transit_gateway_id #=> String
    #   resp.transit_gateway_vpc_attachment.vpc_id #=> String
    #   resp.transit_gateway_vpc_attachment.vpc_owner_id #=> String
    #   resp.transit_gateway_vpc_attachment.state #=> String, one of "pendingAcceptance", "rollingBack", "pending", "available", "modifying", "deleting", "deleted", "failed", "rejected", "rejecting", "failing"
    #   resp.transit_gateway_vpc_attachment.subnet_ids #=> Array
    #   resp.transit_gateway_vpc_attachment.subnet_ids[0] #=> String
    #   resp.transit_gateway_vpc_attachment.creation_time #=> Time
    #   resp.transit_gateway_vpc_attachment.options.dns_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_vpc_attachment.options.ipv_6_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_vpc_attachment.tags #=> Array
    #   resp.transit_gateway_vpc_attachment.tags[0].key #=> String
    #   resp.transit_gateway_vpc_attachment.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayVpcAttachment AWS API Documentation
    #
    # @overload delete_transit_gateway_vpc_attachment(params = {})
    # @param [Hash] params ({})
    def delete_transit_gateway_vpc_attachment(params = {}, options = {})
      req = build_request(:delete_transit_gateway_vpc_attachment, params)
      req.send_request(options)
    end

    # Deletes the specified EBS volume. The volume must be in the
    # `available` state (not attached to an instance).
    #
    # The volume can remain in the `deleting` state for several minutes.
    #
    # For more information, see [Deleting an Amazon EBS Volume][1] in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-volume.html
    #
    # @option params [required, String] :volume_id
    #   The ID of the volume.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a volume
    #
    #   # This example deletes an available volume with the volume ID of ``vol-049df61146c4d7901``. If the command succeeds, no
    #   # output is returned.
    #
    #   resp = client.delete_volume({
    #     volume_id: "vol-049df61146c4d7901", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_volume({
    #     volume_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVolume AWS API Documentation
    #
    # @overload delete_volume(params = {})
    # @param [Hash] params ({})
    def delete_volume(params = {}, options = {})
      req = build_request(:delete_volume, params)
      req.send_request(options)
    end

    # Deletes the specified VPC. You must detach or delete all gateways and
    # resources that are associated with the VPC before you can delete it.
    # For example, you must terminate all instances running in the VPC,
    # delete all security groups associated with the VPC (except the default
    # one), delete all route tables associated with the VPC (except the
    # default one), and so on.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To delete a VPC
    #
    #   # This example deletes the specified VPC.
    #
    #   resp = client.delete_vpc({
    #     vpc_id: "vpc-a01106c2", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_vpc({
    #     vpc_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpc AWS API Documentation
    #
    # @overload delete_vpc(params = {})
    # @param [Hash] params ({})
    def delete_vpc(params = {}, options = {})
      req = build_request(:delete_vpc, params)
      req.send_request(options)
    end

    # Deletes one or more VPC endpoint connection notifications.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :connection_notification_ids
    #   One or more notification IDs.
    #
    # @return [Types::DeleteVpcEndpointConnectionNotificationsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteVpcEndpointConnectionNotificationsResult#unsuccessful #unsuccessful} => Array&lt;Types::UnsuccessfulItem&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_vpc_endpoint_connection_notifications({
    #     dry_run: false,
    #     connection_notification_ids: ["String"], # required
    #   })
    #
    # @example Response structure
    #
    #   resp.unsuccessful #=> Array
    #   resp.unsuccessful[0].error.code #=> String
    #   resp.unsuccessful[0].error.message #=> String
    #   resp.unsuccessful[0].resource_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointConnectionNotifications AWS API Documentation
    #
    # @overload delete_vpc_endpoint_connection_notifications(params = {})
    # @param [Hash] params ({})
    def delete_vpc_endpoint_connection_notifications(params = {}, options = {})
      req = build_request(:delete_vpc_endpoint_connection_notifications, params)
      req.send_request(options)
    end

    # Deletes one or more VPC endpoint service configurations in your
    # account. Before you delete the endpoint service configuration, you
    # must reject any `Available` or `PendingAcceptance` interface endpoint
    # connections that are attached to the service.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :service_ids
    #   The IDs of one or more services.
    #
    # @return [Types::DeleteVpcEndpointServiceConfigurationsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteVpcEndpointServiceConfigurationsResult#unsuccessful #unsuccessful} => Array&lt;Types::UnsuccessfulItem&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_vpc_endpoint_service_configurations({
    #     dry_run: false,
    #     service_ids: ["String"], # required
    #   })
    #
    # @example Response structure
    #
    #   resp.unsuccessful #=> Array
    #   resp.unsuccessful[0].error.code #=> String
    #   resp.unsuccessful[0].error.message #=> String
    #   resp.unsuccessful[0].resource_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointServiceConfigurations AWS API Documentation
    #
    # @overload delete_vpc_endpoint_service_configurations(params = {})
    # @param [Hash] params ({})
    def delete_vpc_endpoint_service_configurations(params = {}, options = {})
      req = build_request(:delete_vpc_endpoint_service_configurations, params)
      req.send_request(options)
    end

    # Deletes one or more specified VPC endpoints. Deleting a gateway
    # endpoint also deletes the endpoint routes in the route tables that
    # were associated with the endpoint. Deleting an interface endpoint
    # deletes the endpoint network interfaces.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :vpc_endpoint_ids
    #   One or more VPC endpoint IDs.
    #
    # @return [Types::DeleteVpcEndpointsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteVpcEndpointsResult#unsuccessful #unsuccessful} => Array&lt;Types::UnsuccessfulItem&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_vpc_endpoints({
    #     dry_run: false,
    #     vpc_endpoint_ids: ["String"], # required
    #   })
    #
    # @example Response structure
    #
    #   resp.unsuccessful #=> Array
    #   resp.unsuccessful[0].error.code #=> String
    #   resp.unsuccessful[0].error.message #=> String
    #   resp.unsuccessful[0].resource_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpoints AWS API Documentation
    #
    # @overload delete_vpc_endpoints(params = {})
    # @param [Hash] params ({})
    def delete_vpc_endpoints(params = {}, options = {})
      req = build_request(:delete_vpc_endpoints, params)
      req.send_request(options)
    end

    # Deletes a VPC peering connection. Either the owner of the requester
    # VPC or the owner of the accepter VPC can delete the VPC peering
    # connection if it's in the `active` state. The owner of the requester
    # VPC can delete a VPC peering connection in the `pending-acceptance`
    # state. You cannot delete a VPC peering connection that's in the
    # `failed` state.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :vpc_peering_connection_id
    #   The ID of the VPC peering connection.
    #
    # @return [Types::DeleteVpcPeeringConnectionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteVpcPeeringConnectionResult#return #return} => Boolean
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_vpc_peering_connection({
    #     dry_run: false,
    #     vpc_peering_connection_id: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.return #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcPeeringConnection AWS API Documentation
    #
    # @overload delete_vpc_peering_connection(params = {})
    # @param [Hash] params ({})
    def delete_vpc_peering_connection(params = {}, options = {})
      req = build_request(:delete_vpc_peering_connection, params)
      req.send_request(options)
    end

    # Deletes the specified VPN connection.
    #
    # If you're deleting the VPC and its associated components, we
    # recommend that you detach the virtual private gateway from the VPC and
    # delete the VPC before deleting the VPN connection. If you believe that
    # the tunnel credentials for your VPN connection have been compromised,
    # you can delete the VPN connection and create a new one that has new
    # keys, without needing to delete the VPC or virtual private gateway. If
    # you create a new VPN connection, you must reconfigure the customer
    # gateway using the new configuration information returned with the new
    # VPN connection ID.
    #
    # @option params [required, String] :vpn_connection_id
    #   The ID of the VPN connection.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_vpn_connection({
    #     vpn_connection_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnection AWS API Documentation
    #
    # @overload delete_vpn_connection(params = {})
    # @param [Hash] params ({})
    def delete_vpn_connection(params = {}, options = {})
      req = build_request(:delete_vpn_connection, params)
      req.send_request(options)
    end

    # Deletes the specified static route associated with a VPN connection
    # between an existing virtual private gateway and a VPN customer
    # gateway. The static route allows traffic to be routed from the virtual
    # private gateway to the VPN customer gateway.
    #
    # @option params [required, String] :destination_cidr_block
    #   The CIDR block associated with the local subnet of the customer
    #   network.
    #
    # @option params [required, String] :vpn_connection_id
    #   The ID of the VPN connection.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_vpn_connection_route({
    #     destination_cidr_block: "String", # required
    #     vpn_connection_id: "String", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnectionRoute AWS API Documentation
    #
    # @overload delete_vpn_connection_route(params = {})
    # @param [Hash] params ({})
    def delete_vpn_connection_route(params = {}, options = {})
      req = build_request(:delete_vpn_connection_route, params)
      req.send_request(options)
    end

    # Deletes the specified virtual private gateway. We recommend that
    # before you delete a virtual private gateway, you detach it from the
    # VPC and delete the VPN connection. Note that you don't need to delete
    # the virtual private gateway if you plan to delete and recreate the VPN
    # connection between your VPC and your network.
    #
    # @option params [required, String] :vpn_gateway_id
    #   The ID of the virtual private gateway.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_vpn_gateway({
    #     vpn_gateway_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnGateway AWS API Documentation
    #
    # @overload delete_vpn_gateway(params = {})
    # @param [Hash] params ({})
    def delete_vpn_gateway(params = {}, options = {})
      req = build_request(:delete_vpn_gateway, params)
      req.send_request(options)
    end

    # Releases the specified address range that you provisioned for use with
    # your AWS resources through bring your own IP addresses (BYOIP) and
    # deletes the corresponding address pool.
    #
    # Before you can release an address range, you must stop advertising it
    # using WithdrawByoipCidr and you must not have any IP addresses
    # allocated from its address range.
    #
    # @option params [required, String] :cidr
    #   The public IPv4 address range, in CIDR notation. The prefix must be
    #   the same prefix that you specified when you provisioned the address
    #   range.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DeprovisionByoipCidrResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeprovisionByoipCidrResult#byoip_cidr #byoip_cidr} => Types::ByoipCidr
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.deprovision_byoip_cidr({
    #     cidr: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.byoip_cidr.cidr #=> String
    #   resp.byoip_cidr.description #=> String
    #   resp.byoip_cidr.status_message #=> String
    #   resp.byoip_cidr.state #=> String, one of "advertised", "deprovisioned", "failed-deprovision", "failed-provision", "pending-deprovision", "pending-provision", "provisioned"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionByoipCidr AWS API Documentation
    #
    # @overload deprovision_byoip_cidr(params = {})
    # @param [Hash] params ({})
    def deprovision_byoip_cidr(params = {}, options = {})
      req = build_request(:deprovision_byoip_cidr, params)
      req.send_request(options)
    end

    # Deregisters the specified AMI. After you deregister an AMI, it can't
    # be used to launch new instances; however, it doesn't affect any
    # instances that you've already launched from the AMI. You'll continue
    # to incur usage costs for those instances until you terminate them.
    #
    # When you deregister an Amazon EBS-backed AMI, it doesn't affect the
    # snapshot that was created for the root volume of the instance during
    # the AMI creation process. When you deregister an instance store-backed
    # AMI, it doesn't affect the files that you uploaded to Amazon S3 when
    # you created the AMI.
    #
    # @option params [required, String] :image_id
    #   The ID of the AMI.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.deregister_image({
    #     image_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterImage AWS API Documentation
    #
    # @overload deregister_image(params = {})
    # @param [Hash] params ({})
    def deregister_image(params = {}, options = {})
      req = build_request(:deregister_image, params)
      req.send_request(options)
    end

    # Describes attributes of your AWS account. The following are the
    # supported account attributes:
    #
    # * `supported-platforms`\: Indicates whether your account can launch
    #   instances into EC2-Classic and EC2-VPC, or only into EC2-VPC.
    #
    # * `default-vpc`\: The ID of the default VPC for your account, or
    #   `none`.
    #
    # * `max-instances`\: The maximum number of On-Demand Instances that you
    #   can run.
    #
    # * `vpc-max-security-groups-per-interface`\: The maximum number of
    #   security groups that you can assign to a network interface.
    #
    # * `max-elastic-ips`\: The maximum number of Elastic IP addresses that
    #   you can allocate for use with EC2-Classic.
    #
    # * `vpc-max-elastic-ips`\: The maximum number of Elastic IP addresses
    #   that you can allocate for use with EC2-VPC.
    #
    # @option params [Array<String>] :attribute_names
    #   The account attribute names.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeAccountAttributesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeAccountAttributesResult#account_attributes #account_attributes} => Array&lt;Types::AccountAttribute&gt;
    #
    #
    # @example Example: To describe a single attribute for your AWS account
    #
    #   # This example describes the supported-platforms attribute for your AWS account.
    #
    #   resp = client.describe_account_attributes({
    #     attribute_names: [
    #       "supported-platforms", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     account_attributes: [
    #       {
    #         attribute_name: "supported-platforms", 
    #         attribute_values: [
    #           {
    #             attribute_value: "EC2", 
    #           }, 
    #           {
    #             attribute_value: "VPC", 
    #           }, 
    #         ], 
    #       }, 
    #     ], 
    #   }
    #
    # @example Example: To describe all attributes for your AWS account
    #
    #   # This example describes the attributes for your AWS account.
    #
    #   resp = client.describe_account_attributes({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     account_attributes: [
    #       {
    #         attribute_name: "supported-platforms", 
    #         attribute_values: [
    #           {
    #             attribute_value: "EC2", 
    #           }, 
    #           {
    #             attribute_value: "VPC", 
    #           }, 
    #         ], 
    #       }, 
    #       {
    #         attribute_name: "vpc-max-security-groups-per-interface", 
    #         attribute_values: [
    #           {
    #             attribute_value: "5", 
    #           }, 
    #         ], 
    #       }, 
    #       {
    #         attribute_name: "max-elastic-ips", 
    #         attribute_values: [
    #           {
    #             attribute_value: "5", 
    #           }, 
    #         ], 
    #       }, 
    #       {
    #         attribute_name: "max-instances", 
    #         attribute_values: [
    #           {
    #             attribute_value: "20", 
    #           }, 
    #         ], 
    #       }, 
    #       {
    #         attribute_name: "vpc-max-elastic-ips", 
    #         attribute_values: [
    #           {
    #             attribute_value: "5", 
    #           }, 
    #         ], 
    #       }, 
    #       {
    #         attribute_name: "default-vpc", 
    #         attribute_values: [
    #           {
    #             attribute_value: "none", 
    #           }, 
    #         ], 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_account_attributes({
    #     attribute_names: ["supported-platforms"], # accepts supported-platforms, default-vpc
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.account_attributes #=> Array
    #   resp.account_attributes[0].attribute_name #=> String
    #   resp.account_attributes[0].attribute_values #=> Array
    #   resp.account_attributes[0].attribute_values[0].attribute_value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAccountAttributes AWS API Documentation
    #
    # @overload describe_account_attributes(params = {})
    # @param [Hash] params ({})
    def describe_account_attributes(params = {}, options = {})
      req = build_request(:describe_account_attributes, params)
      req.send_request(options)
    end

    # Describes the specified Elastic IP addresses or all of your Elastic IP
    # addresses.
    #
    # An Elastic IP address is for use in either the EC2-Classic platform or
    # in a VPC. For more information, see [Elastic IP Addresses][1] in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    #   * `allocation-id` - \[EC2-VPC\] The allocation ID for the address.
    #
    #   * `association-id` - \[EC2-VPC\] The association ID for the address.
    #
    #   * `domain` - Indicates whether the address is for use in EC2-Classic
    #     (`standard`) or in a VPC (`vpc`).
    #
    #   * `instance-id` - The ID of the instance the address is associated
    #     with, if any.
    #
    #   * `network-interface-id` - \[EC2-VPC\] The ID of the network interface
    #     that the address is associated with, if any.
    #
    #   * `network-interface-owner-id` - The AWS account ID of the owner.
    #
    #   * `private-ip-address` - \[EC2-VPC\] The private IP address associated
    #     with the Elastic IP address.
    #
    #   * `public-ip` - The Elastic IP address.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    # @option params [Array<String>] :public_ips
    #   One or more Elastic IP addresses.
    #
    #   Default: Describes all your Elastic IP addresses.
    #
    # @option params [Array<String>] :allocation_ids
    #   \[EC2-VPC\] Information about the allocation IDs.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeAddressesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeAddressesResult#addresses #addresses} => Array&lt;Types::Address&gt;
    #
    #
    # @example Example: To describe your Elastic IP addresses
    #
    #   # This example describes your Elastic IP addresses.
    #
    #   resp = client.describe_addresses({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     addresses: [
    #       {
    #         domain: "standard", 
    #         instance_id: "i-1234567890abcdef0", 
    #         public_ip: "198.51.100.0", 
    #       }, 
    #       {
    #         allocation_id: "eipalloc-12345678", 
    #         association_id: "eipassoc-12345678", 
    #         domain: "vpc", 
    #         instance_id: "i-1234567890abcdef0", 
    #         network_interface_id: "eni-12345678", 
    #         network_interface_owner_id: "123456789012", 
    #         private_ip_address: "10.0.1.241", 
    #         public_ip: "203.0.113.0", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Example: To describe your Elastic IP addresses for EC2-VPC
    #
    #   # This example describes your Elastic IP addresses for use with instances in a VPC.
    #
    #   resp = client.describe_addresses({
    #     filters: [
    #       {
    #         name: "domain", 
    #         values: [
    #           "vpc", 
    #         ], 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     addresses: [
    #       {
    #         allocation_id: "eipalloc-12345678", 
    #         association_id: "eipassoc-12345678", 
    #         domain: "vpc", 
    #         instance_id: "i-1234567890abcdef0", 
    #         network_interface_id: "eni-12345678", 
    #         network_interface_owner_id: "123456789012", 
    #         private_ip_address: "10.0.1.241", 
    #         public_ip: "203.0.113.0", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Example: To describe your Elastic IP addresses for EC2-Classic
    #
    #   # This example describes your Elastic IP addresses for use with instances in EC2-Classic.
    #
    #   resp = client.describe_addresses({
    #     filters: [
    #       {
    #         name: "domain", 
    #         values: [
    #           "standard", 
    #         ], 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     addresses: [
    #       {
    #         domain: "standard", 
    #         instance_id: "i-1234567890abcdef0", 
    #         public_ip: "198.51.100.0", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_addresses({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     public_ips: ["String"],
    #     allocation_ids: ["String"],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.addresses #=> Array
    #   resp.addresses[0].instance_id #=> String
    #   resp.addresses[0].public_ip #=> String
    #   resp.addresses[0].allocation_id #=> String
    #   resp.addresses[0].association_id #=> String
    #   resp.addresses[0].domain #=> String, one of "vpc", "standard"
    #   resp.addresses[0].network_interface_id #=> String
    #   resp.addresses[0].network_interface_owner_id #=> String
    #   resp.addresses[0].private_ip_address #=> String
    #   resp.addresses[0].tags #=> Array
    #   resp.addresses[0].tags[0].key #=> String
    #   resp.addresses[0].tags[0].value #=> String
    #   resp.addresses[0].public_ipv_4_pool #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddresses AWS API Documentation
    #
    # @overload describe_addresses(params = {})
    # @param [Hash] params ({})
    def describe_addresses(params = {}, options = {})
      req = build_request(:describe_addresses, params)
      req.send_request(options)
    end

    # Describes the longer ID format settings for all resource types in a
    # specific Region. This request is useful for performing a quick audit
    # to determine whether a specific Region is fully opted in for longer
    # IDs (17-character IDs).
    #
    # This request only returns information about resource types that
    # support longer IDs.
    #
    # The following resource types support longer IDs: `bundle` \|
    # `conversion-task` \| `customer-gateway` \| `dhcp-options` \|
    # `elastic-ip-allocation` \| `elastic-ip-association` \| `export-task`
    # \| `flow-log` \| `image` \| `import-task` \| `instance` \|
    # `internet-gateway` \| `network-acl` \| `network-acl-association` \|
    # `network-interface` \| `network-interface-attachment` \| `prefix-list`
    # \| `reservation` \| `route-table` \| `route-table-association` \|
    # `security-group` \| `snapshot` \| `subnet` \|
    # `subnet-cidr-block-association` \| `volume` \| `vpc` \|
    # `vpc-cidr-block-association` \| `vpc-endpoint` \|
    # `vpc-peering-connection` \| `vpn-connection` \| `vpn-gateway`.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeAggregateIdFormatResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeAggregateIdFormatResult#use_long_ids_aggregated #use_long_ids_aggregated} => Boolean
    #   * {Types::DescribeAggregateIdFormatResult#statuses #statuses} => Array&lt;Types::IdFormat&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_aggregate_id_format({
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.use_long_ids_aggregated #=> Boolean
    #   resp.statuses #=> Array
    #   resp.statuses[0].deadline #=> Time
    #   resp.statuses[0].resource #=> String
    #   resp.statuses[0].use_long_ids #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAggregateIdFormat AWS API Documentation
    #
    # @overload describe_aggregate_id_format(params = {})
    # @param [Hash] params ({})
    def describe_aggregate_id_format(params = {}, options = {})
      req = build_request(:describe_aggregate_id_format, params)
      req.send_request(options)
    end

    # Describes the Availability Zones that are available to you. The
    # results include zones only for the Region you're currently using. If
    # there is an event impacting an Availability Zone, you can use this
    # request to view the state and any provided message for that
    # Availability Zone.
    #
    # For more information, see [Regions and Availability Zones][1] in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `message` - Information about the Availability Zone.
    #
    #   * `region-name` - The name of the Region for the Availability Zone
    #     (for example, `us-east-1`).
    #
    #   * `state` - The state of the Availability Zone (`available` \|
    #     `information` \| `impaired` \| `unavailable`).
    #
    #   * `zone-id` - The ID of the Availability Zone (for example,
    #     `use1-az1`).
    #
    #   * `zone-name` - The name of the Availability Zone (for example,
    #     `us-east-1a`).
    #
    # @option params [Array<String>] :zone_names
    #   The names of the Availability Zones.
    #
    # @option params [Array<String>] :zone_ids
    #   The IDs of the Availability Zones.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeAvailabilityZonesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeAvailabilityZonesResult#availability_zones #availability_zones} => Array&lt;Types::AvailabilityZone&gt;
    #
    #
    # @example Example: To describe your Availability Zones
    #
    #   # This example describes the Availability Zones that are available to you. The response includes Availability Zones only
    #   # for the current region.
    #
    #   resp = client.describe_availability_zones({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     availability_zones: [
    #       {
    #         messages: [
    #         ], 
    #         region_name: "us-east-1", 
    #         state: "available", 
    #         zone_name: "us-east-1b", 
    #       }, 
    #       {
    #         messages: [
    #         ], 
    #         region_name: "us-east-1", 
    #         state: "available", 
    #         zone_name: "us-east-1c", 
    #       }, 
    #       {
    #         messages: [
    #         ], 
    #         region_name: "us-east-1", 
    #         state: "available", 
    #         zone_name: "us-east-1d", 
    #       }, 
    #       {
    #         messages: [
    #         ], 
    #         region_name: "us-east-1", 
    #         state: "available", 
    #         zone_name: "us-east-1e", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_availability_zones({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     zone_names: ["String"],
    #     zone_ids: ["String"],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.availability_zones #=> Array
    #   resp.availability_zones[0].state #=> String, one of "available", "information", "impaired", "unavailable"
    #   resp.availability_zones[0].messages #=> Array
    #   resp.availability_zones[0].messages[0].message #=> String
    #   resp.availability_zones[0].region_name #=> String
    #   resp.availability_zones[0].zone_name #=> String
    #   resp.availability_zones[0].zone_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAvailabilityZones AWS API Documentation
    #
    # @overload describe_availability_zones(params = {})
    # @param [Hash] params ({})
    def describe_availability_zones(params = {}, options = {})
      req = build_request(:describe_availability_zones, params)
      req.send_request(options)
    end

    # Describes the specified bundle tasks or all of your bundle tasks.
    #
    # <note markdown="1"> Completed bundle tasks are listed for only a limited time. If your
    # bundle task is no longer in the list, you can still register an AMI
    # from it. Just use `RegisterImage` with the Amazon S3 bucket name and
    # image manifest name you provided to the bundle task.
    #
    #  </note>
    #
    # @option params [Array<String>] :bundle_ids
    #   The bundle task IDs.
    #
    #   Default: Describes all your bundle tasks.
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `bundle-id` - The ID of the bundle task.
    #
    #   * `error-code` - If the task failed, the error code returned.
    #
    #   * `error-message` - If the task failed, the error message returned.
    #
    #   * `instance-id` - The ID of the instance.
    #
    #   * `progress` - The level of task completion, as a percentage (for
    #     example, 20%).
    #
    #   * `s3-bucket` - The Amazon S3 bucket to store the AMI.
    #
    #   * `s3-prefix` - The beginning of the AMI name.
    #
    #   * `start-time` - The time the task started (for example,
    #     2013-09-15T17:15:20.000Z).
    #
    #   * `state` - The state of the task (`pending` \| `waiting-for-shutdown`
    #     \| `bundling` \| `storing` \| `cancelling` \| `complete` \|
    #     `failed`).
    #
    #   * `update-time` - The time of the most recent update for the task.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeBundleTasksResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeBundleTasksResult#bundle_tasks #bundle_tasks} => Array&lt;Types::BundleTask&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_bundle_tasks({
    #     bundle_ids: ["String"],
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.bundle_tasks #=> Array
    #   resp.bundle_tasks[0].bundle_id #=> String
    #   resp.bundle_tasks[0].bundle_task_error.code #=> String
    #   resp.bundle_tasks[0].bundle_task_error.message #=> String
    #   resp.bundle_tasks[0].instance_id #=> String
    #   resp.bundle_tasks[0].progress #=> String
    #   resp.bundle_tasks[0].start_time #=> Time
    #   resp.bundle_tasks[0].state #=> String, one of "pending", "waiting-for-shutdown", "bundling", "storing", "cancelling", "complete", "failed"
    #   resp.bundle_tasks[0].storage.s3.aws_access_key_id #=> String
    #   resp.bundle_tasks[0].storage.s3.bucket #=> String
    #   resp.bundle_tasks[0].storage.s3.prefix #=> String
    #   resp.bundle_tasks[0].storage.s3.upload_policy #=> String
    #   resp.bundle_tasks[0].storage.s3.upload_policy_signature #=> String
    #   resp.bundle_tasks[0].update_time #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeBundleTasks AWS API Documentation
    #
    # @overload describe_bundle_tasks(params = {})
    # @param [Hash] params ({})
    def describe_bundle_tasks(params = {}, options = {})
      req = build_request(:describe_bundle_tasks, params)
      req.send_request(options)
    end

    # Describes the IP address ranges that were specified in calls to
    # ProvisionByoipCidr.
    #
    # To describe the address pools that were created when you provisioned
    # the address ranges, use DescribePublicIpv4Pools.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @return [Types::DescribeByoipCidrsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeByoipCidrsResult#byoip_cidrs #byoip_cidrs} => Array&lt;Types::ByoipCidr&gt;
    #   * {Types::DescribeByoipCidrsResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_byoip_cidrs({
    #     dry_run: false,
    #     max_results: 1, # required
    #     next_token: "NextToken",
    #   })
    #
    # @example Response structure
    #
    #   resp.byoip_cidrs #=> Array
    #   resp.byoip_cidrs[0].cidr #=> String
    #   resp.byoip_cidrs[0].description #=> String
    #   resp.byoip_cidrs[0].status_message #=> String
    #   resp.byoip_cidrs[0].state #=> String, one of "advertised", "deprovisioned", "failed-deprovision", "failed-provision", "pending-deprovision", "pending-provision", "provisioned"
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeByoipCidrs AWS API Documentation
    #
    # @overload describe_byoip_cidrs(params = {})
    # @param [Hash] params ({})
    def describe_byoip_cidrs(params = {}, options = {})
      req = build_request(:describe_byoip_cidrs, params)
      req.send_request(options)
    end

    # Describes one or more of your Capacity Reservations. The results
    # describe only the Capacity Reservations in the AWS Region that you're
    # currently using.
    #
    # @option params [Array<String>] :capacity_reservation_ids
    #   The ID of the Capacity Reservation.
    #
    # @option params [String] :next_token
    #   The token to retrieve the next page of results.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the returned nextToken value.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeCapacityReservationsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeCapacityReservationsResult#next_token #next_token} => String
    #   * {Types::DescribeCapacityReservationsResult#capacity_reservations #capacity_reservations} => Array&lt;Types::CapacityReservation&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_capacity_reservations({
    #     capacity_reservation_ids: ["String"],
    #     next_token: "String",
    #     max_results: 1,
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.next_token #=> String
    #   resp.capacity_reservations #=> Array
    #   resp.capacity_reservations[0].capacity_reservation_id #=> String
    #   resp.capacity_reservations[0].owner_id #=> String
    #   resp.capacity_reservations[0].capacity_reservation_arn #=> String
    #   resp.capacity_reservations[0].availability_zone_id #=> String
    #   resp.capacity_reservations[0].instance_type #=> String
    #   resp.capacity_reservations[0].instance_platform #=> String, one of "Linux/UNIX", "Red Hat Enterprise Linux", "SUSE Linux", "Windows", "Windows with SQL Server", "Windows with SQL Server Enterprise", "Windows with SQL Server Standard", "Windows with SQL Server Web", "Linux with SQL Server Standard", "Linux with SQL Server Web", "Linux with SQL Server Enterprise"
    #   resp.capacity_reservations[0].availability_zone #=> String
    #   resp.capacity_reservations[0].tenancy #=> String, one of "default", "dedicated"
    #   resp.capacity_reservations[0].total_instance_count #=> Integer
    #   resp.capacity_reservations[0].available_instance_count #=> Integer
    #   resp.capacity_reservations[0].ebs_optimized #=> Boolean
    #   resp.capacity_reservations[0].ephemeral_storage #=> Boolean
    #   resp.capacity_reservations[0].state #=> String, one of "active", "expired", "cancelled", "pending", "failed"
    #   resp.capacity_reservations[0].end_date #=> Time
    #   resp.capacity_reservations[0].end_date_type #=> String, one of "unlimited", "limited"
    #   resp.capacity_reservations[0].instance_match_criteria #=> String, one of "open", "targeted"
    #   resp.capacity_reservations[0].create_date #=> Time
    #   resp.capacity_reservations[0].tags #=> Array
    #   resp.capacity_reservations[0].tags[0].key #=> String
    #   resp.capacity_reservations[0].tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservations AWS API Documentation
    #
    # @overload describe_capacity_reservations(params = {})
    # @param [Hash] params ({})
    def describe_capacity_reservations(params = {}, options = {})
      req = build_request(:describe_capacity_reservations, params)
      req.send_request(options)
    end

    # Describes one or more of your linked EC2-Classic instances. This
    # request only returns information about EC2-Classic instances linked to
    # a VPC through ClassicLink. You cannot use this request to return
    # information about other instances.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `group-id` - The ID of a VPC security group that's associated with
    #     the instance.
    #
    #   * `instance-id` - The ID of the instance.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `vpc-id` - The ID of the VPC to which the instance is linked.
    #
    #     `vpc-id` - The ID of the VPC that the instance is linked to.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<String>] :instance_ids
    #   One or more instance IDs. Must be instances linked to a VPC through
    #   ClassicLink.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    #   Constraint: If the value is greater than 1000, we return only 1000
    #   items.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @return [Types::DescribeClassicLinkInstancesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeClassicLinkInstancesResult#instances #instances} => Array&lt;Types::ClassicLinkInstance&gt;
    #   * {Types::DescribeClassicLinkInstancesResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_classic_link_instances({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     dry_run: false,
    #     instance_ids: ["String"],
    #     max_results: 1,
    #     next_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.instances #=> Array
    #   resp.instances[0].groups #=> Array
    #   resp.instances[0].groups[0].group_name #=> String
    #   resp.instances[0].groups[0].group_id #=> String
    #   resp.instances[0].instance_id #=> String
    #   resp.instances[0].tags #=> Array
    #   resp.instances[0].tags[0].key #=> String
    #   resp.instances[0].tags[0].value #=> String
    #   resp.instances[0].vpc_id #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClassicLinkInstances AWS API Documentation
    #
    # @overload describe_classic_link_instances(params = {})
    # @param [Hash] params ({})
    def describe_classic_link_instances(params = {}, options = {})
      req = build_request(:describe_classic_link_instances, params)
      req.send_request(options)
    end

    # Describes the authorization rules for a specified Client VPN endpoint.
    #
    # @option params [required, String] :client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :next_token
    #   The token to retrieve the next page of results.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the nextToken value.
    #
    # @return [Types::DescribeClientVpnAuthorizationRulesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeClientVpnAuthorizationRulesResult#authorization_rules #authorization_rules} => Array&lt;Types::AuthorizationRule&gt;
    #   * {Types::DescribeClientVpnAuthorizationRulesResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_client_vpn_authorization_rules({
    #     client_vpn_endpoint_id: "String", # required
    #     dry_run: false,
    #     next_token: "NextToken",
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.authorization_rules #=> Array
    #   resp.authorization_rules[0].client_vpn_endpoint_id #=> String
    #   resp.authorization_rules[0].description #=> String
    #   resp.authorization_rules[0].group_id #=> String
    #   resp.authorization_rules[0].access_all #=> Boolean
    #   resp.authorization_rules[0].destination_cidr #=> String
    #   resp.authorization_rules[0].status.code #=> String, one of "authorizing", "active", "failed", "revoking"
    #   resp.authorization_rules[0].status.message #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnAuthorizationRules AWS API Documentation
    #
    # @overload describe_client_vpn_authorization_rules(params = {})
    # @param [Hash] params ({})
    def describe_client_vpn_authorization_rules(params = {}, options = {})
      req = build_request(:describe_client_vpn_authorization_rules, params)
      req.send_request(options)
    end

    # Describes active client connections and connections that have been
    # terminated within the last 60 minutes for the specified Client VPN
    # endpoint.
    #
    # @option params [required, String] :client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    # @option params [String] :next_token
    #   The token to retrieve the next page of results.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the nextToken value.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeClientVpnConnectionsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeClientVpnConnectionsResult#connections #connections} => Array&lt;Types::ClientVpnConnection&gt;
    #   * {Types::DescribeClientVpnConnectionsResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_client_vpn_connections({
    #     client_vpn_endpoint_id: "String", # required
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     next_token: "NextToken",
    #     max_results: 1,
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.connections #=> Array
    #   resp.connections[0].client_vpn_endpoint_id #=> String
    #   resp.connections[0].timestamp #=> String
    #   resp.connections[0].connection_id #=> String
    #   resp.connections[0].username #=> String
    #   resp.connections[0].connection_established_time #=> String
    #   resp.connections[0].ingress_bytes #=> String
    #   resp.connections[0].egress_bytes #=> String
    #   resp.connections[0].ingress_packets #=> String
    #   resp.connections[0].egress_packets #=> String
    #   resp.connections[0].client_ip #=> String
    #   resp.connections[0].common_name #=> String
    #   resp.connections[0].status.code #=> String, one of "active", "failed-to-terminate", "terminating", "terminated"
    #   resp.connections[0].status.message #=> String
    #   resp.connections[0].connection_end_time #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnConnections AWS API Documentation
    #
    # @overload describe_client_vpn_connections(params = {})
    # @param [Hash] params ({})
    def describe_client_vpn_connections(params = {}, options = {})
      req = build_request(:describe_client_vpn_connections, params)
      req.send_request(options)
    end

    # Describes one or more Client VPN endpoints in the account.
    #
    # @option params [Array<String>] :client_vpn_endpoint_ids
    #   The ID of the Client VPN endpoint.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the nextToken value.
    #
    # @option params [String] :next_token
    #   The token to retrieve the next page of results.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeClientVpnEndpointsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeClientVpnEndpointsResult#client_vpn_endpoints #client_vpn_endpoints} => Array&lt;Types::ClientVpnEndpoint&gt;
    #   * {Types::DescribeClientVpnEndpointsResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_client_vpn_endpoints({
    #     client_vpn_endpoint_ids: ["String"],
    #     max_results: 1,
    #     next_token: "NextToken",
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.client_vpn_endpoints #=> Array
    #   resp.client_vpn_endpoints[0].client_vpn_endpoint_id #=> String
    #   resp.client_vpn_endpoints[0].description #=> String
    #   resp.client_vpn_endpoints[0].status.code #=> String, one of "pending-associate", "available", "deleting", "deleted"
    #   resp.client_vpn_endpoints[0].status.message #=> String
    #   resp.client_vpn_endpoints[0].creation_time #=> String
    #   resp.client_vpn_endpoints[0].deletion_time #=> String
    #   resp.client_vpn_endpoints[0].dns_name #=> String
    #   resp.client_vpn_endpoints[0].client_cidr_block #=> String
    #   resp.client_vpn_endpoints[0].dns_servers #=> Array
    #   resp.client_vpn_endpoints[0].dns_servers[0] #=> String
    #   resp.client_vpn_endpoints[0].split_tunnel #=> Boolean
    #   resp.client_vpn_endpoints[0].vpn_protocol #=> String, one of "openvpn"
    #   resp.client_vpn_endpoints[0].transport_protocol #=> String, one of "tcp", "udp"
    #   resp.client_vpn_endpoints[0].associated_target_networks #=> Array
    #   resp.client_vpn_endpoints[0].associated_target_networks[0].network_id #=> String
    #   resp.client_vpn_endpoints[0].associated_target_networks[0].network_type #=> String, one of "vpc"
    #   resp.client_vpn_endpoints[0].server_certificate_arn #=> String
    #   resp.client_vpn_endpoints[0].authentication_options #=> Array
    #   resp.client_vpn_endpoints[0].authentication_options[0].type #=> String, one of "certificate-authentication", "directory-service-authentication"
    #   resp.client_vpn_endpoints[0].authentication_options[0].active_directory.directory_id #=> String
    #   resp.client_vpn_endpoints[0].authentication_options[0].mutual_authentication.client_root_certificate_chain #=> String
    #   resp.client_vpn_endpoints[0].connection_log_options.enabled #=> Boolean
    #   resp.client_vpn_endpoints[0].connection_log_options.cloudwatch_log_group #=> String
    #   resp.client_vpn_endpoints[0].connection_log_options.cloudwatch_log_stream #=> String
    #   resp.client_vpn_endpoints[0].tags #=> Array
    #   resp.client_vpn_endpoints[0].tags[0].key #=> String
    #   resp.client_vpn_endpoints[0].tags[0].value #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnEndpoints AWS API Documentation
    #
    # @overload describe_client_vpn_endpoints(params = {})
    # @param [Hash] params ({})
    def describe_client_vpn_endpoints(params = {}, options = {})
      req = build_request(:describe_client_vpn_endpoints, params)
      req.send_request(options)
    end

    # Describes the routes for the specified Client VPN endpoint.
    #
    # @option params [required, String] :client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the nextToken value.
    #
    # @option params [String] :next_token
    #   The token to retrieve the next page of results.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeClientVpnRoutesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeClientVpnRoutesResult#routes #routes} => Array&lt;Types::ClientVpnRoute&gt;
    #   * {Types::DescribeClientVpnRoutesResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_client_vpn_routes({
    #     client_vpn_endpoint_id: "String", # required
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #     next_token: "NextToken",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.routes #=> Array
    #   resp.routes[0].client_vpn_endpoint_id #=> String
    #   resp.routes[0].destination_cidr #=> String
    #   resp.routes[0].target_subnet #=> String
    #   resp.routes[0].type #=> String
    #   resp.routes[0].origin #=> String
    #   resp.routes[0].status.code #=> String, one of "creating", "active", "failed", "deleting"
    #   resp.routes[0].status.message #=> String
    #   resp.routes[0].description #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnRoutes AWS API Documentation
    #
    # @overload describe_client_vpn_routes(params = {})
    # @param [Hash] params ({})
    def describe_client_vpn_routes(params = {}, options = {})
      req = build_request(:describe_client_vpn_routes, params)
      req.send_request(options)
    end

    # Describes the target networks associated with the specified Client VPN
    # endpoint.
    #
    # @option params [required, String] :client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #
    # @option params [Array<String>] :association_ids
    #   The IDs of the target network associations.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the nextToken value.
    #
    # @option params [String] :next_token
    #   The token to retrieve the next page of results.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeClientVpnTargetNetworksResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeClientVpnTargetNetworksResult#client_vpn_target_networks #client_vpn_target_networks} => Array&lt;Types::TargetNetwork&gt;
    #   * {Types::DescribeClientVpnTargetNetworksResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_client_vpn_target_networks({
    #     client_vpn_endpoint_id: "String", # required
    #     association_ids: ["String"],
    #     max_results: 1,
    #     next_token: "NextToken",
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.client_vpn_target_networks #=> Array
    #   resp.client_vpn_target_networks[0].association_id #=> String
    #   resp.client_vpn_target_networks[0].vpc_id #=> String
    #   resp.client_vpn_target_networks[0].target_network_id #=> String
    #   resp.client_vpn_target_networks[0].client_vpn_endpoint_id #=> String
    #   resp.client_vpn_target_networks[0].status.code #=> String, one of "associating", "associated", "association-failed", "disassociating", "disassociated"
    #   resp.client_vpn_target_networks[0].status.message #=> String
    #   resp.client_vpn_target_networks[0].security_groups #=> Array
    #   resp.client_vpn_target_networks[0].security_groups[0] #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnTargetNetworks AWS API Documentation
    #
    # @overload describe_client_vpn_target_networks(params = {})
    # @param [Hash] params ({})
    def describe_client_vpn_target_networks(params = {}, options = {})
      req = build_request(:describe_client_vpn_target_networks, params)
      req.send_request(options)
    end

    # Describes the specified conversion tasks or all your conversion tasks.
    # For more information, see the [VM Import/Export User Guide][1].
    #
    # For information about the import manifest referenced by this API
    # action, see [VM Import Manifest][2].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vm-import/latest/userguide/
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html
    #
    # @option params [Array<String>] :conversion_task_ids
    #   The conversion task IDs.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeConversionTasksResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeConversionTasksResult#conversion_tasks #conversion_tasks} => Array&lt;Types::ConversionTask&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_conversion_tasks({
    #     conversion_task_ids: ["String"],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.conversion_tasks #=> Array
    #   resp.conversion_tasks[0].conversion_task_id #=> String
    #   resp.conversion_tasks[0].expiration_time #=> String
    #   resp.conversion_tasks[0].import_instance.description #=> String
    #   resp.conversion_tasks[0].import_instance.instance_id #=> String
    #   resp.conversion_tasks[0].import_instance.platform #=> String, one of "Windows"
    #   resp.conversion_tasks[0].import_instance.volumes #=> Array
    #   resp.conversion_tasks[0].import_instance.volumes[0].availability_zone #=> String
    #   resp.conversion_tasks[0].import_instance.volumes[0].bytes_converted #=> Integer
    #   resp.conversion_tasks[0].import_instance.volumes[0].description #=> String
    #   resp.conversion_tasks[0].import_instance.volumes[0].image.checksum #=> String
    #   resp.conversion_tasks[0].import_instance.volumes[0].image.format #=> String, one of "VMDK", "RAW", "VHD"
    #   resp.conversion_tasks[0].import_instance.volumes[0].image.import_manifest_url #=> String
    #   resp.conversion_tasks[0].import_instance.volumes[0].image.size #=> Integer
    #   resp.conversion_tasks[0].import_instance.volumes[0].status #=> String
    #   resp.conversion_tasks[0].import_instance.volumes[0].status_message #=> String
    #   resp.conversion_tasks[0].import_instance.volumes[0].volume.id #=> String
    #   resp.conversion_tasks[0].import_instance.volumes[0].volume.size #=> Integer
    #   resp.conversion_tasks[0].import_volume.availability_zone #=> String
    #   resp.conversion_tasks[0].import_volume.bytes_converted #=> Integer
    #   resp.conversion_tasks[0].import_volume.description #=> String
    #   resp.conversion_tasks[0].import_volume.image.checksum #=> String
    #   resp.conversion_tasks[0].import_volume.image.format #=> String, one of "VMDK", "RAW", "VHD"
    #   resp.conversion_tasks[0].import_volume.image.import_manifest_url #=> String
    #   resp.conversion_tasks[0].import_volume.image.size #=> Integer
    #   resp.conversion_tasks[0].import_volume.volume.id #=> String
    #   resp.conversion_tasks[0].import_volume.volume.size #=> Integer
    #   resp.conversion_tasks[0].state #=> String, one of "active", "cancelling", "cancelled", "completed"
    #   resp.conversion_tasks[0].status_message #=> String
    #   resp.conversion_tasks[0].tags #=> Array
    #   resp.conversion_tasks[0].tags[0].key #=> String
    #   resp.conversion_tasks[0].tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeConversionTasks AWS API Documentation
    #
    # @overload describe_conversion_tasks(params = {})
    # @param [Hash] params ({})
    def describe_conversion_tasks(params = {}, options = {})
      req = build_request(:describe_conversion_tasks, params)
      req.send_request(options)
    end

    # Describes one or more of your VPN customer gateways.
    #
    # For more information, see [AWS Site-to-Site VPN][1] in the *AWS
    # Site-to-Site VPN User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html
    #
    # @option params [Array<String>] :customer_gateway_ids
    #   One or more customer gateway IDs.
    #
    #   Default: Describes all your customer gateways.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `bgp-asn` - The customer gateway's Border Gateway Protocol (BGP)
    #     Autonomous System Number (ASN).
    #
    #   * `customer-gateway-id` - The ID of the customer gateway.
    #
    #   * `ip-address` - The IP address of the customer gateway's
    #     Internet-routable external interface.
    #
    #   * `state` - The state of the customer gateway (`pending` \|
    #     `available` \| `deleting` \| `deleted`).
    #
    #   * `type` - The type of customer gateway. Currently, the only supported
    #     type is `ipsec.1`.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeCustomerGatewaysResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeCustomerGatewaysResult#customer_gateways #customer_gateways} => Array&lt;Types::CustomerGateway&gt;
    #
    #
    # @example Example: To describe a customer gateway
    #
    #   # This example describes the specified customer gateway.
    #
    #   resp = client.describe_customer_gateways({
    #     customer_gateway_ids: [
    #       "cgw-0e11f167", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     customer_gateways: [
    #       {
    #         bgp_asn: "65534", 
    #         customer_gateway_id: "cgw-0e11f167", 
    #         ip_address: "12.1.2.3", 
    #         state: "available", 
    #         type: "ipsec.1", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_customer_gateways({
    #     customer_gateway_ids: ["String"],
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.customer_gateways #=> Array
    #   resp.customer_gateways[0].bgp_asn #=> String
    #   resp.customer_gateways[0].customer_gateway_id #=> String
    #   resp.customer_gateways[0].ip_address #=> String
    #   resp.customer_gateways[0].certificate_arn #=> String
    #   resp.customer_gateways[0].state #=> String
    #   resp.customer_gateways[0].type #=> String
    #   resp.customer_gateways[0].tags #=> Array
    #   resp.customer_gateways[0].tags[0].key #=> String
    #   resp.customer_gateways[0].tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCustomerGateways AWS API Documentation
    #
    # @overload describe_customer_gateways(params = {})
    # @param [Hash] params ({})
    def describe_customer_gateways(params = {}, options = {})
      req = build_request(:describe_customer_gateways, params)
      req.send_request(options)
    end

    # Describes one or more of your DHCP options sets.
    #
    # For more information, see [DHCP Options Sets][1] in the *Amazon
    # Virtual Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html
    #
    # @option params [Array<String>] :dhcp_options_ids
    #   The IDs of one or more DHCP options sets.
    #
    #   Default: Describes all your DHCP options sets.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `dhcp-options-id` - The ID of a DHCP options set.
    #
    #   * `key` - The key for one of the options (for example, `domain-name`).
    #
    #   * `value` - The value for one of the options.
    #
    #   * `owner-id` - The ID of the AWS account that owns the DHCP options
    #     set.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @return [Types::DescribeDhcpOptionsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeDhcpOptionsResult#dhcp_options #dhcp_options} => Array&lt;Types::DhcpOptions&gt;
    #   * {Types::DescribeDhcpOptionsResult#next_token #next_token} => String
    #
    #
    # @example Example: To describe a DHCP options set
    #
    #   # This example describes the specified DHCP options set.
    #
    #   resp = client.describe_dhcp_options({
    #     dhcp_options_ids: [
    #       "dopt-d9070ebb", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     dhcp_options: [
    #       {
    #         dhcp_configurations: [
    #           {
    #             key: "domain-name-servers", 
    #             values: [
    #               {
    #                 value: "10.2.5.2", 
    #               }, 
    #               {
    #                 value: "10.2.5.1", 
    #               }, 
    #             ], 
    #           }, 
    #         ], 
    #         dhcp_options_id: "dopt-d9070ebb", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_dhcp_options({
    #     dhcp_options_ids: ["String"],
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     dry_run: false,
    #     next_token: "String",
    #     max_results: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.dhcp_options #=> Array
    #   resp.dhcp_options[0].dhcp_configurations #=> Array
    #   resp.dhcp_options[0].dhcp_configurations[0].key #=> String
    #   resp.dhcp_options[0].dhcp_configurations[0].values #=> Array
    #   resp.dhcp_options[0].dhcp_configurations[0].values[0] #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #   resp.dhcp_options[0].dhcp_options_id #=> String
    #   resp.dhcp_options[0].owner_id #=> String
    #   resp.dhcp_options[0].tags #=> Array
    #   resp.dhcp_options[0].tags[0].key #=> String
    #   resp.dhcp_options[0].tags[0].value #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeDhcpOptions AWS API Documentation
    #
    # @overload describe_dhcp_options(params = {})
    # @param [Hash] params ({})
    def describe_dhcp_options(params = {}, options = {})
      req = build_request(:describe_dhcp_options, params)
      req.send_request(options)
    end

    # Describes one or more of your egress-only internet gateways.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<String>] :egress_only_internet_gateway_ids
    #   One or more egress-only internet gateway IDs.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @return [Types::DescribeEgressOnlyInternetGatewaysResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeEgressOnlyInternetGatewaysResult#egress_only_internet_gateways #egress_only_internet_gateways} => Array&lt;Types::EgressOnlyInternetGateway&gt;
    #   * {Types::DescribeEgressOnlyInternetGatewaysResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_egress_only_internet_gateways({
    #     dry_run: false,
    #     egress_only_internet_gateway_ids: ["EgressOnlyInternetGatewayId"],
    #     max_results: 1,
    #     next_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.egress_only_internet_gateways #=> Array
    #   resp.egress_only_internet_gateways[0].attachments #=> Array
    #   resp.egress_only_internet_gateways[0].attachments[0].state #=> String, one of "attaching", "attached", "detaching", "detached"
    #   resp.egress_only_internet_gateways[0].attachments[0].vpc_id #=> String
    #   resp.egress_only_internet_gateways[0].egress_only_internet_gateway_id #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeEgressOnlyInternetGateways AWS API Documentation
    #
    # @overload describe_egress_only_internet_gateways(params = {})
    # @param [Hash] params ({})
    def describe_egress_only_internet_gateways(params = {}, options = {})
      req = build_request(:describe_egress_only_internet_gateways, params)
      req.send_request(options)
    end

    # Describes the Elastic Graphics accelerator associated with your
    # instances. For more information about Elastic Graphics, see [Amazon
    # Elastic Graphics][1].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html
    #
    # @option params [Array<String>] :elastic_gpu_ids
    #   The Elastic Graphics accelerator IDs.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `availability-zone` - The Availability Zone in which the Elastic
    #     Graphics accelerator resides.
    #
    #   * `elastic-gpu-health` - The status of the Elastic Graphics
    #     accelerator (`OK` \| `IMPAIRED`).
    #
    #   * `elastic-gpu-state` - The state of the Elastic Graphics accelerator
    #     (`ATTACHED`).
    #
    #   * `elastic-gpu-type` - The type of Elastic Graphics accelerator; for
    #     example, `eg1.medium`.
    #
    #   * `instance-id` - The ID of the instance to which the Elastic Graphics
    #     accelerator is associated.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. To retrieve
    #   the remaining results, make another call with the returned `NextToken`
    #   value. This value can be between 5 and 1000.
    #
    # @option params [String] :next_token
    #   The token to request the next page of results.
    #
    # @return [Types::DescribeElasticGpusResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeElasticGpusResult#elastic_gpu_set #elastic_gpu_set} => Array&lt;Types::ElasticGpus&gt;
    #   * {Types::DescribeElasticGpusResult#max_results #max_results} => Integer
    #   * {Types::DescribeElasticGpusResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_elastic_gpus({
    #     elastic_gpu_ids: ["String"],
    #     dry_run: false,
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #     next_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.elastic_gpu_set #=> Array
    #   resp.elastic_gpu_set[0].elastic_gpu_id #=> String
    #   resp.elastic_gpu_set[0].availability_zone #=> String
    #   resp.elastic_gpu_set[0].elastic_gpu_type #=> String
    #   resp.elastic_gpu_set[0].elastic_gpu_health.status #=> String, one of "OK", "IMPAIRED"
    #   resp.elastic_gpu_set[0].elastic_gpu_state #=> String, one of "ATTACHED"
    #   resp.elastic_gpu_set[0].instance_id #=> String
    #   resp.max_results #=> Integer
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeElasticGpus AWS API Documentation
    #
    # @overload describe_elastic_gpus(params = {})
    # @param [Hash] params ({})
    def describe_elastic_gpus(params = {}, options = {})
      req = build_request(:describe_elastic_gpus, params)
      req.send_request(options)
    end

    # Describes the specified export image tasks or all your export image
    # tasks.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::Filter>] :filters
    #   Filter tasks using the `task-state` filter and one of the following
    #   values: `active`, `completed`, `deleting`, or `deleted`.
    #
    # @option params [Array<String>] :export_image_task_ids
    #   The IDs of the export image tasks.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call.
    #
    # @option params [String] :next_token
    #   A token that indicates the next page of results.
    #
    # @return [Types::DescribeExportImageTasksResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeExportImageTasksResult#export_image_tasks #export_image_tasks} => Array&lt;Types::ExportImageTask&gt;
    #   * {Types::DescribeExportImageTasksResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_export_image_tasks({
    #     dry_run: false,
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     export_image_task_ids: ["String"],
    #     max_results: 1,
    #     next_token: "NextToken",
    #   })
    #
    # @example Response structure
    #
    #   resp.export_image_tasks #=> Array
    #   resp.export_image_tasks[0].description #=> String
    #   resp.export_image_tasks[0].export_image_task_id #=> String
    #   resp.export_image_tasks[0].image_id #=> String
    #   resp.export_image_tasks[0].progress #=> String
    #   resp.export_image_tasks[0].s3_export_location.s3_bucket #=> String
    #   resp.export_image_tasks[0].s3_export_location.s3_prefix #=> String
    #   resp.export_image_tasks[0].status #=> String
    #   resp.export_image_tasks[0].status_message #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportImageTasks AWS API Documentation
    #
    # @overload describe_export_image_tasks(params = {})
    # @param [Hash] params ({})
    def describe_export_image_tasks(params = {}, options = {})
      req = build_request(:describe_export_image_tasks, params)
      req.send_request(options)
    end

    # Describes the specified export instance tasks or all your export
    # instance tasks.
    #
    # @option params [Array<String>] :export_task_ids
    #   The export task IDs.
    #
    # @return [Types::DescribeExportTasksResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeExportTasksResult#export_tasks #export_tasks} => Array&lt;Types::ExportTask&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_export_tasks({
    #     export_task_ids: ["String"],
    #   })
    #
    # @example Response structure
    #
    #   resp.export_tasks #=> Array
    #   resp.export_tasks[0].description #=> String
    #   resp.export_tasks[0].export_task_id #=> String
    #   resp.export_tasks[0].export_to_s3_task.container_format #=> String, one of "ova"
    #   resp.export_tasks[0].export_to_s3_task.disk_image_format #=> String, one of "VMDK", "RAW", "VHD"
    #   resp.export_tasks[0].export_to_s3_task.s3_bucket #=> String
    #   resp.export_tasks[0].export_to_s3_task.s3_key #=> String
    #   resp.export_tasks[0].instance_export_details.instance_id #=> String
    #   resp.export_tasks[0].instance_export_details.target_environment #=> String, one of "citrix", "vmware", "microsoft"
    #   resp.export_tasks[0].state #=> String, one of "active", "cancelling", "cancelled", "completed"
    #   resp.export_tasks[0].status_message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportTasks AWS API Documentation
    #
    # @overload describe_export_tasks(params = {})
    # @param [Hash] params ({})
    def describe_export_tasks(params = {}, options = {})
      req = build_request(:describe_export_tasks, params)
      req.send_request(options)
    end

    # Describes the events for the specified EC2 Fleet during the specified
    # time.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :event_type
    #   The type of events to describe. By default, all events are described.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. Specify a
    #   value between 1 and 1000. The default value is 1000. To retrieve the
    #   remaining results, make another call with the returned `NextToken`
    #   value.
    #
    # @option params [String] :next_token
    #   The token for the next set of results.
    #
    # @option params [required, String] :fleet_id
    #   The ID of the EC2 Fleet.
    #
    # @option params [required, Time,DateTime,Date,Integer,String] :start_time
    #   The start date and time for the events, in UTC format (for example,
    #   *YYYY*-*MM*-*DD*T*HH*\:*MM*\:*SS*Z).
    #
    # @return [Types::DescribeFleetHistoryResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeFleetHistoryResult#history_records #history_records} => Array&lt;Types::HistoryRecordEntry&gt;
    #   * {Types::DescribeFleetHistoryResult#last_evaluated_time #last_evaluated_time} => Time
    #   * {Types::DescribeFleetHistoryResult#next_token #next_token} => String
    #   * {Types::DescribeFleetHistoryResult#fleet_id #fleet_id} => String
    #   * {Types::DescribeFleetHistoryResult#start_time #start_time} => Time
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_fleet_history({
    #     dry_run: false,
    #     event_type: "instance-change", # accepts instance-change, fleet-change, service-error
    #     max_results: 1,
    #     next_token: "String",
    #     fleet_id: "FleetIdentifier", # required
    #     start_time: Time.now, # required
    #   })
    #
    # @example Response structure
    #
    #   resp.history_records #=> Array
    #   resp.history_records[0].event_information.event_description #=> String
    #   resp.history_records[0].event_information.event_sub_type #=> String
    #   resp.history_records[0].event_information.instance_id #=> String
    #   resp.history_records[0].event_type #=> String, one of "instance-change", "fleet-change", "service-error"
    #   resp.history_records[0].timestamp #=> Time
    #   resp.last_evaluated_time #=> Time
    #   resp.next_token #=> String
    #   resp.fleet_id #=> String
    #   resp.start_time #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetHistory AWS API Documentation
    #
    # @overload describe_fleet_history(params = {})
    # @param [Hash] params ({})
    def describe_fleet_history(params = {}, options = {})
      req = build_request(:describe_fleet_history, params)
      req.send_request(options)
    end

    # Describes the running instances for the specified EC2 Fleet.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. Specify a
    #   value between 1 and 1000. The default value is 1000. To retrieve the
    #   remaining results, make another call with the returned `NextToken`
    #   value.
    #
    # @option params [String] :next_token
    #   The token for the next set of results.
    #
    # @option params [required, String] :fleet_id
    #   The ID of the EC2 Fleet.
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `instance-type` - The instance type.
    #
    #   ^
    #
    # @return [Types::DescribeFleetInstancesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeFleetInstancesResult#active_instances #active_instances} => Array&lt;Types::ActiveInstance&gt;
    #   * {Types::DescribeFleetInstancesResult#next_token #next_token} => String
    #   * {Types::DescribeFleetInstancesResult#fleet_id #fleet_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_fleet_instances({
    #     dry_run: false,
    #     max_results: 1,
    #     next_token: "String",
    #     fleet_id: "FleetIdentifier", # required
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.active_instances #=> Array
    #   resp.active_instances[0].instance_id #=> String
    #   resp.active_instances[0].instance_type #=> String
    #   resp.active_instances[0].spot_instance_request_id #=> String
    #   resp.active_instances[0].instance_health #=> String, one of "healthy", "unhealthy"
    #   resp.next_token #=> String
    #   resp.fleet_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetInstances AWS API Documentation
    #
    # @overload describe_fleet_instances(params = {})
    # @param [Hash] params ({})
    def describe_fleet_instances(params = {}, options = {})
      req = build_request(:describe_fleet_instances, params)
      req.send_request(options)
    end

    # Describes the specified EC2 Fleets or all your EC2 Fleets.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. Specify a
    #   value between 1 and 1000. The default value is 1000. To retrieve the
    #   remaining results, make another call with the returned `NextToken`
    #   value.
    #
    # @option params [String] :next_token
    #   The token for the next set of results.
    #
    # @option params [Array<String>] :fleet_ids
    #   The ID of the EC2 Fleets.
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `activity-status` - The progress of the EC2 Fleet ( `error` \|
    #     `pending-fulfillment` \| `pending-termination` \| `fulfilled`).
    #
    #   * `excess-capacity-termination-policy` - Indicates whether to
    #     terminate running instances if the target capacity is decreased
    #     below the current EC2 Fleet size (`true` \| `false`).
    #
    #   * `fleet-state` - The state of the EC2 Fleet (`submitted` \| `active`
    #     \| `deleted` \| `failed` \| `deleted-running` \|
    #     `deleted-terminating` \| `modifying`).
    #
    #   * `replace-unhealthy-instances` - Indicates whether EC2 Fleet should
    #     replace unhealthy instances (`true` \| `false`).
    #
    #   * `type` - The type of request (`instant` \| `request` \| `maintain`).
    #
    # @return [Types::DescribeFleetsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeFleetsResult#next_token #next_token} => String
    #   * {Types::DescribeFleetsResult#fleets #fleets} => Array&lt;Types::FleetData&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_fleets({
    #     dry_run: false,
    #     max_results: 1,
    #     next_token: "String",
    #     fleet_ids: ["FleetIdentifier"],
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.next_token #=> String
    #   resp.fleets #=> Array
    #   resp.fleets[0].activity_status #=> String, one of "error", "pending_fulfillment", "pending_termination", "fulfilled"
    #   resp.fleets[0].create_time #=> Time
    #   resp.fleets[0].fleet_id #=> String
    #   resp.fleets[0].fleet_state #=> String, one of "submitted", "active", "deleted", "failed", "deleted_running", "deleted_terminating", "modifying"
    #   resp.fleets[0].client_token #=> String
    #   resp.fleets[0].excess_capacity_termination_policy #=> String, one of "no-termination", "termination"
    #   resp.fleets[0].fulfilled_capacity #=> Float
    #   resp.fleets[0].fulfilled_on_demand_capacity #=> Float
    #   resp.fleets[0].launch_template_configs #=> Array
    #   resp.fleets[0].launch_template_configs[0].launch_template_specification.launch_template_id #=> String
    #   resp.fleets[0].launch_template_configs[0].launch_template_specification.launch_template_name #=> String
    #   resp.fleets[0].launch_template_configs[0].launch_template_specification.version #=> String
    #   resp.fleets[0].launch_template_configs[0].overrides #=> Array
    #   resp.fleets[0].launch_template_configs[0].overrides[0].instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.18xlarge", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge"
    #   resp.fleets[0].launch_template_configs[0].overrides[0].max_price #=> String
    #   resp.fleets[0].launch_template_configs[0].overrides[0].subnet_id #=> String
    #   resp.fleets[0].launch_template_configs[0].overrides[0].availability_zone #=> String
    #   resp.fleets[0].launch_template_configs[0].overrides[0].weighted_capacity #=> Float
    #   resp.fleets[0].launch_template_configs[0].overrides[0].priority #=> Float
    #   resp.fleets[0].launch_template_configs[0].overrides[0].placement.group_name #=> String
    #   resp.fleets[0].target_capacity_specification.total_target_capacity #=> Integer
    #   resp.fleets[0].target_capacity_specification.on_demand_target_capacity #=> Integer
    #   resp.fleets[0].target_capacity_specification.spot_target_capacity #=> Integer
    #   resp.fleets[0].target_capacity_specification.default_target_capacity_type #=> String, one of "spot", "on-demand"
    #   resp.fleets[0].terminate_instances_with_expiration #=> Boolean
    #   resp.fleets[0].type #=> String, one of "request", "maintain", "instant"
    #   resp.fleets[0].valid_from #=> Time
    #   resp.fleets[0].valid_until #=> Time
    #   resp.fleets[0].replace_unhealthy_instances #=> Boolean
    #   resp.fleets[0].spot_options.allocation_strategy #=> String, one of "lowest-price", "diversified", "capacity-optimized"
    #   resp.fleets[0].spot_options.instance_interruption_behavior #=> String, one of "hibernate", "stop", "terminate"
    #   resp.fleets[0].spot_options.instance_pools_to_use_count #=> Integer
    #   resp.fleets[0].spot_options.single_instance_type #=> Boolean
    #   resp.fleets[0].spot_options.single_availability_zone #=> Boolean
    #   resp.fleets[0].spot_options.min_target_capacity #=> Integer
    #   resp.fleets[0].spot_options.max_total_price #=> String
    #   resp.fleets[0].on_demand_options.allocation_strategy #=> String, one of "lowest-price", "prioritized"
    #   resp.fleets[0].on_demand_options.single_instance_type #=> Boolean
    #   resp.fleets[0].on_demand_options.single_availability_zone #=> Boolean
    #   resp.fleets[0].on_demand_options.min_target_capacity #=> Integer
    #   resp.fleets[0].on_demand_options.max_total_price #=> String
    #   resp.fleets[0].tags #=> Array
    #   resp.fleets[0].tags[0].key #=> String
    #   resp.fleets[0].tags[0].value #=> String
    #   resp.fleets[0].errors #=> Array
    #   resp.fleets[0].errors[0].launch_template_and_overrides.launch_template_specification.launch_template_id #=> String
    #   resp.fleets[0].errors[0].launch_template_and_overrides.launch_template_specification.launch_template_name #=> String
    #   resp.fleets[0].errors[0].launch_template_and_overrides.launch_template_specification.version #=> String
    #   resp.fleets[0].errors[0].launch_template_and_overrides.overrides.instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.18xlarge", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge"
    #   resp.fleets[0].errors[0].launch_template_and_overrides.overrides.max_price #=> String
    #   resp.fleets[0].errors[0].launch_template_and_overrides.overrides.subnet_id #=> String
    #   resp.fleets[0].errors[0].launch_template_and_overrides.overrides.availability_zone #=> String
    #   resp.fleets[0].errors[0].launch_template_and_overrides.overrides.weighted_capacity #=> Float
    #   resp.fleets[0].errors[0].launch_template_and_overrides.overrides.priority #=> Float
    #   resp.fleets[0].errors[0].launch_template_and_overrides.overrides.placement.group_name #=> String
    #   resp.fleets[0].errors[0].lifecycle #=> String, one of "spot", "on-demand"
    #   resp.fleets[0].errors[0].error_code #=> String
    #   resp.fleets[0].errors[0].error_message #=> String
    #   resp.fleets[0].instances #=> Array
    #   resp.fleets[0].instances[0].launch_template_and_overrides.launch_template_specification.launch_template_id #=> String
    #   resp.fleets[0].instances[0].launch_template_and_overrides.launch_template_specification.launch_template_name #=> String
    #   resp.fleets[0].instances[0].launch_template_and_overrides.launch_template_specification.version #=> String
    #   resp.fleets[0].instances[0].launch_template_and_overrides.overrides.instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.18xlarge", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge"
    #   resp.fleets[0].instances[0].launch_template_and_overrides.overrides.max_price #=> String
    #   resp.fleets[0].instances[0].launch_template_and_overrides.overrides.subnet_id #=> String
    #   resp.fleets[0].instances[0].launch_template_and_overrides.overrides.availability_zone #=> String
    #   resp.fleets[0].instances[0].launch_template_and_overrides.overrides.weighted_capacity #=> Float
    #   resp.fleets[0].instances[0].launch_template_and_overrides.overrides.priority #=> Float
    #   resp.fleets[0].instances[0].launch_template_and_overrides.overrides.placement.group_name #=> String
    #   resp.fleets[0].instances[0].lifecycle #=> String, one of "spot", "on-demand"
    #   resp.fleets[0].instances[0].instance_ids #=> Array
    #   resp.fleets[0].instances[0].instance_ids[0] #=> String
    #   resp.fleets[0].instances[0].instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.18xlarge", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge"
    #   resp.fleets[0].instances[0].platform #=> String, one of "Windows"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleets AWS API Documentation
    #
    # @overload describe_fleets(params = {})
    # @param [Hash] params ({})
    def describe_fleets(params = {}, options = {})
      req = build_request(:describe_fleets, params)
      req.send_request(options)
    end

    # Describes one or more flow logs. To view the information in your flow
    # logs (the log streams for the network interfaces), you must use the
    # CloudWatch Logs console or the CloudWatch Logs API.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::Filter>] :filter
    #   One or more filters.
    #
    #   * `deliver-log-status` - The status of the logs delivery (`SUCCESS` \|
    #     `FAILED`).
    #
    #   * `log-destination-type` - The type of destination to which the flow
    #     log publishes data. Possible destination types include
    #     `cloud-watch-logs` and `S3`.
    #
    #   * `flow-log-id` - The ID of the flow log.
    #
    #   * `log-group-name` - The name of the log group.
    #
    #   * `resource-id` - The ID of the VPC, subnet, or network interface.
    #
    #   * `traffic-type` - The type of traffic (`ACCEPT` \| `REJECT` \|
    #     `ALL`).
    #
    # @option params [Array<String>] :flow_log_ids
    #   One or more flow log IDs.
    #
    #   Constraint: Maximum of 1000 flow log IDs.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @return [Types::DescribeFlowLogsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeFlowLogsResult#flow_logs #flow_logs} => Array&lt;Types::FlowLog&gt;
    #   * {Types::DescribeFlowLogsResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_flow_logs({
    #     dry_run: false,
    #     filter: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     flow_log_ids: ["String"],
    #     max_results: 1,
    #     next_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.flow_logs #=> Array
    #   resp.flow_logs[0].creation_time #=> Time
    #   resp.flow_logs[0].deliver_logs_error_message #=> String
    #   resp.flow_logs[0].deliver_logs_permission_arn #=> String
    #   resp.flow_logs[0].deliver_logs_status #=> String
    #   resp.flow_logs[0].flow_log_id #=> String
    #   resp.flow_logs[0].flow_log_status #=> String
    #   resp.flow_logs[0].log_group_name #=> String
    #   resp.flow_logs[0].resource_id #=> String
    #   resp.flow_logs[0].traffic_type #=> String, one of "ACCEPT", "REJECT", "ALL"
    #   resp.flow_logs[0].log_destination_type #=> String, one of "cloud-watch-logs", "s3"
    #   resp.flow_logs[0].log_destination #=> String
    #   resp.flow_logs[0].log_format #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFlowLogs AWS API Documentation
    #
    # @overload describe_flow_logs(params = {})
    # @param [Hash] params ({})
    def describe_flow_logs(params = {}, options = {})
      req = build_request(:describe_flow_logs, params)
      req.send_request(options)
    end

    # Describes the specified attribute of the specified Amazon FPGA Image
    # (AFI).
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :fpga_image_id
    #   The ID of the AFI.
    #
    # @option params [required, String] :attribute
    #   The AFI attribute.
    #
    # @return [Types::DescribeFpgaImageAttributeResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeFpgaImageAttributeResult#fpga_image_attribute #fpga_image_attribute} => Types::FpgaImageAttribute
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_fpga_image_attribute({
    #     dry_run: false,
    #     fpga_image_id: "String", # required
    #     attribute: "description", # required, accepts description, name, loadPermission, productCodes
    #   })
    #
    # @example Response structure
    #
    #   resp.fpga_image_attribute.fpga_image_id #=> String
    #   resp.fpga_image_attribute.name #=> String
    #   resp.fpga_image_attribute.description #=> String
    #   resp.fpga_image_attribute.load_permissions #=> Array
    #   resp.fpga_image_attribute.load_permissions[0].user_id #=> String
    #   resp.fpga_image_attribute.load_permissions[0].group #=> String, one of "all"
    #   resp.fpga_image_attribute.product_codes #=> Array
    #   resp.fpga_image_attribute.product_codes[0].product_code_id #=> String
    #   resp.fpga_image_attribute.product_codes[0].product_code_type #=> String, one of "devpay", "marketplace"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImageAttribute AWS API Documentation
    #
    # @overload describe_fpga_image_attribute(params = {})
    # @param [Hash] params ({})
    def describe_fpga_image_attribute(params = {}, options = {})
      req = build_request(:describe_fpga_image_attribute, params)
      req.send_request(options)
    end

    # Describes the Amazon FPGA Images (AFIs) available to you. These
    # include public AFIs, private AFIs that you own, and AFIs owned by
    # other AWS accounts for which you have load permissions.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<String>] :fpga_image_ids
    #   The AFI IDs.
    #
    # @option params [Array<String>] :owners
    #   Filters the AFI by owner. Specify an AWS account ID, `self` (owner is
    #   the sender of the request), or an AWS owner alias (valid values are
    #   `amazon` \| `aws-marketplace`).
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `create-time` - The creation time of the AFI.
    #
    #   * `fpga-image-id` - The FPGA image identifier (AFI ID).
    #
    #   * `fpga-image-global-id` - The global FPGA image identifier (AGFI ID).
    #
    #   * `name` - The name of the AFI.
    #
    #   * `owner-id` - The AWS account ID of the AFI owner.
    #
    #   * `product-code` - The product code.
    #
    #   * `shell-version` - The version of the AWS Shell that was used to
    #     create the bitstream.
    #
    #   * `state` - The state of the AFI (`pending` \| `failed` \| `available`
    #     \| `unavailable`).
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `update-time` - The time of the most recent update.
    #
    # @option params [String] :next_token
    #   The token to retrieve the next page of results.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call.
    #
    # @return [Types::DescribeFpgaImagesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeFpgaImagesResult#fpga_images #fpga_images} => Array&lt;Types::FpgaImage&gt;
    #   * {Types::DescribeFpgaImagesResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_fpga_images({
    #     dry_run: false,
    #     fpga_image_ids: ["String"],
    #     owners: ["String"],
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     next_token: "NextToken",
    #     max_results: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.fpga_images #=> Array
    #   resp.fpga_images[0].fpga_image_id #=> String
    #   resp.fpga_images[0].fpga_image_global_id #=> String
    #   resp.fpga_images[0].name #=> String
    #   resp.fpga_images[0].description #=> String
    #   resp.fpga_images[0].shell_version #=> String
    #   resp.fpga_images[0].pci_id.device_id #=> String
    #   resp.fpga_images[0].pci_id.vendor_id #=> String
    #   resp.fpga_images[0].pci_id.subsystem_id #=> String
    #   resp.fpga_images[0].pci_id.subsystem_vendor_id #=> String
    #   resp.fpga_images[0].state.code #=> String, one of "pending", "failed", "available", "unavailable"
    #   resp.fpga_images[0].state.message #=> String
    #   resp.fpga_images[0].create_time #=> Time
    #   resp.fpga_images[0].update_time #=> Time
    #   resp.fpga_images[0].owner_id #=> String
    #   resp.fpga_images[0].owner_alias #=> String
    #   resp.fpga_images[0].product_codes #=> Array
    #   resp.fpga_images[0].product_codes[0].product_code_id #=> String
    #   resp.fpga_images[0].product_codes[0].product_code_type #=> String, one of "devpay", "marketplace"
    #   resp.fpga_images[0].tags #=> Array
    #   resp.fpga_images[0].tags[0].key #=> String
    #   resp.fpga_images[0].tags[0].value #=> String
    #   resp.fpga_images[0].public #=> Boolean
    #   resp.fpga_images[0].data_retention_support #=> Boolean
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImages AWS API Documentation
    #
    # @overload describe_fpga_images(params = {})
    # @param [Hash] params ({})
    def describe_fpga_images(params = {}, options = {})
      req = build_request(:describe_fpga_images, params)
      req.send_request(options)
    end

    # Describes the Dedicated Host reservations that are available to
    # purchase.
    #
    # The results describe all the Dedicated Host reservation offerings,
    # including offerings that may not match the instance family and Region
    # of your Dedicated Hosts. When purchasing an offering, ensure that the
    # instance family and Region of the offering matches that of the
    # Dedicated Hosts with which it is to be associated. For more
    # information about supported instance types, see [Dedicated Hosts
    # Overview][1] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html
    #
    # @option params [Array<Types::Filter>] :filter
    #   The filters.
    #
    #   * `instance-family` - The instance family of the offering (for
    #     example, `m4`).
    #
    #   * `payment-option` - The payment option (`NoUpfront` \|
    #     `PartialUpfront` \| `AllUpfront`).
    #
    # @option params [Integer] :max_duration
    #   This is the maximum duration of the reservation to purchase, specified
    #   in seconds. Reservations are available in one-year and three-year
    #   terms. The number of seconds specified must be the number of seconds
    #   in a year (365x24x60x60) times one of the supported durations (1 or
    #   3). For example, specify 94608000 for three years.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the returned `nextToken` value. This value can be between 5 and
    #   500. If `maxResults` is given a larger value than 500, you receive an
    #   error.
    #
    # @option params [Integer] :min_duration
    #   This is the minimum duration of the reservation you'd like to
    #   purchase, specified in seconds. Reservations are available in one-year
    #   and three-year terms. The number of seconds specified must be the
    #   number of seconds in a year (365x24x60x60) times one of the supported
    #   durations (1 or 3). For example, specify 31536000 for one year.
    #
    # @option params [String] :next_token
    #   The token to use to retrieve the next page of results.
    #
    # @option params [String] :offering_id
    #   The ID of the reservation offering.
    #
    # @return [Types::DescribeHostReservationOfferingsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeHostReservationOfferingsResult#next_token #next_token} => String
    #   * {Types::DescribeHostReservationOfferingsResult#offering_set #offering_set} => Array&lt;Types::HostOffering&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_host_reservation_offerings({
    #     filter: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_duration: 1,
    #     max_results: 1,
    #     min_duration: 1,
    #     next_token: "String",
    #     offering_id: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.next_token #=> String
    #   resp.offering_set #=> Array
    #   resp.offering_set[0].currency_code #=> String, one of "USD"
    #   resp.offering_set[0].duration #=> Integer
    #   resp.offering_set[0].hourly_price #=> String
    #   resp.offering_set[0].instance_family #=> String
    #   resp.offering_set[0].offering_id #=> String
    #   resp.offering_set[0].payment_option #=> String, one of "AllUpfront", "PartialUpfront", "NoUpfront"
    #   resp.offering_set[0].upfront_price #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservationOfferings AWS API Documentation
    #
    # @overload describe_host_reservation_offerings(params = {})
    # @param [Hash] params ({})
    def describe_host_reservation_offerings(params = {}, options = {})
      req = build_request(:describe_host_reservation_offerings, params)
      req.send_request(options)
    end

    # Describes reservations that are associated with Dedicated Hosts in
    # your account.
    #
    # @option params [Array<Types::Filter>] :filter
    #   The filters.
    #
    #   * `instance-family` - The instance family (for example, `m4`).
    #
    #   * `payment-option` - The payment option (`NoUpfront` \|
    #     `PartialUpfront` \| `AllUpfront`).
    #
    #   * `state` - The state of the reservation (`payment-pending` \|
    #     `payment-failed` \| `active` \| `retired`).
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    # @option params [Array<String>] :host_reservation_id_set
    #   The host reservation IDs.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the returned `nextToken` value. This value can be between 5 and
    #   500. If `maxResults` is given a larger value than 500, you receive an
    #   error.
    #
    # @option params [String] :next_token
    #   The token to use to retrieve the next page of results.
    #
    # @return [Types::DescribeHostReservationsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeHostReservationsResult#host_reservation_set #host_reservation_set} => Array&lt;Types::HostReservation&gt;
    #   * {Types::DescribeHostReservationsResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_host_reservations({
    #     filter: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     host_reservation_id_set: ["String"],
    #     max_results: 1,
    #     next_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.host_reservation_set #=> Array
    #   resp.host_reservation_set[0].count #=> Integer
    #   resp.host_reservation_set[0].currency_code #=> String, one of "USD"
    #   resp.host_reservation_set[0].duration #=> Integer
    #   resp.host_reservation_set[0].end #=> Time
    #   resp.host_reservation_set[0].host_id_set #=> Array
    #   resp.host_reservation_set[0].host_id_set[0] #=> String
    #   resp.host_reservation_set[0].host_reservation_id #=> String
    #   resp.host_reservation_set[0].hourly_price #=> String
    #   resp.host_reservation_set[0].instance_family #=> String
    #   resp.host_reservation_set[0].offering_id #=> String
    #   resp.host_reservation_set[0].payment_option #=> String, one of "AllUpfront", "PartialUpfront", "NoUpfront"
    #   resp.host_reservation_set[0].start #=> Time
    #   resp.host_reservation_set[0].state #=> String, one of "payment-pending", "payment-failed", "active", "retired"
    #   resp.host_reservation_set[0].upfront_price #=> String
    #   resp.host_reservation_set[0].tags #=> Array
    #   resp.host_reservation_set[0].tags[0].key #=> String
    #   resp.host_reservation_set[0].tags[0].value #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservations AWS API Documentation
    #
    # @overload describe_host_reservations(params = {})
    # @param [Hash] params ({})
    def describe_host_reservations(params = {}, options = {})
      req = build_request(:describe_host_reservations, params)
      req.send_request(options)
    end

    # Describes the specified Dedicated Hosts or all your Dedicated Hosts.
    #
    # The results describe only the Dedicated Hosts in the Region you're
    # currently using. All listed instances consume capacity on your
    # Dedicated Host. Dedicated Hosts that have recently been released are
    # listed with the state `released`.
    #
    # @option params [Array<Types::Filter>] :filter
    #   The filters.
    #
    #   * `auto-placement` - Whether auto-placement is enabled or disabled
    #     (`on` \| `off`).
    #
    #   * `availability-zone` - The Availability Zone of the host.
    #
    #   * `client-token` - The idempotency token that you provided when you
    #     allocated the host.
    #
    #   * `host-reservation-id` - The ID of the reservation assigned to this
    #     host.
    #
    #   * `instance-type` - The instance type size that the Dedicated Host is
    #     configured to support.
    #
    #   * `state` - The allocation state of the Dedicated Host (`available` \|
    #     `under-assessment` \| `permanent-failure` \| `released` \|
    #     `released-permanent-failure`).
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    # @option params [Array<String>] :host_ids
    #   The IDs of the Dedicated Hosts. The IDs are used for targeted instance
    #   launches.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the returned `nextToken` value. This value can be between 5 and
    #   500. If `maxResults` is given a larger value than 500, you receive an
    #   error.
    #
    #   You cannot specify this parameter and the host IDs parameter in the
    #   same request.
    #
    # @option params [String] :next_token
    #   The token to use to retrieve the next page of results.
    #
    # @return [Types::DescribeHostsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeHostsResult#hosts #hosts} => Array&lt;Types::Host&gt;
    #   * {Types::DescribeHostsResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_hosts({
    #     filter: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     host_ids: ["String"],
    #     max_results: 1,
    #     next_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.hosts #=> Array
    #   resp.hosts[0].auto_placement #=> String, one of "on", "off"
    #   resp.hosts[0].availability_zone #=> String
    #   resp.hosts[0].available_capacity.available_instance_capacity #=> Array
    #   resp.hosts[0].available_capacity.available_instance_capacity[0].available_capacity #=> Integer
    #   resp.hosts[0].available_capacity.available_instance_capacity[0].instance_type #=> String
    #   resp.hosts[0].available_capacity.available_instance_capacity[0].total_capacity #=> Integer
    #   resp.hosts[0].available_capacity.available_v_cpus #=> Integer
    #   resp.hosts[0].client_token #=> String
    #   resp.hosts[0].host_id #=> String
    #   resp.hosts[0].host_properties.cores #=> Integer
    #   resp.hosts[0].host_properties.instance_type #=> String
    #   resp.hosts[0].host_properties.sockets #=> Integer
    #   resp.hosts[0].host_properties.total_v_cpus #=> Integer
    #   resp.hosts[0].host_reservation_id #=> String
    #   resp.hosts[0].instances #=> Array
    #   resp.hosts[0].instances[0].instance_id #=> String
    #   resp.hosts[0].instances[0].instance_type #=> String
    #   resp.hosts[0].state #=> String, one of "available", "under-assessment", "permanent-failure", "released", "released-permanent-failure", "pending"
    #   resp.hosts[0].allocation_time #=> Time
    #   resp.hosts[0].release_time #=> Time
    #   resp.hosts[0].tags #=> Array
    #   resp.hosts[0].tags[0].key #=> String
    #   resp.hosts[0].tags[0].value #=> String
    #   resp.hosts[0].host_recovery #=> String, one of "on", "off"
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHosts AWS API Documentation
    #
    # @overload describe_hosts(params = {})
    # @param [Hash] params ({})
    def describe_hosts(params = {}, options = {})
      req = build_request(:describe_hosts, params)
      req.send_request(options)
    end

    # Describes your IAM instance profile associations.
    #
    # @option params [Array<String>] :association_ids
    #   The IAM instance profile associations.
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `instance-id` - The ID of the instance.
    #
    #   * `state` - The state of the association (`associating` \|
    #     `associated` \| `disassociating` \| `disassociated`).
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. To retrieve
    #   the remaining results, make another call with the returned `NextToken`
    #   value.
    #
    # @option params [String] :next_token
    #   The token to request the next page of results.
    #
    # @return [Types::DescribeIamInstanceProfileAssociationsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeIamInstanceProfileAssociationsResult#iam_instance_profile_associations #iam_instance_profile_associations} => Array&lt;Types::IamInstanceProfileAssociation&gt;
    #   * {Types::DescribeIamInstanceProfileAssociationsResult#next_token #next_token} => String
    #
    #
    # @example Example: To describe an IAM instance profile association
    #
    #   # This example describes the specified IAM instance profile association.
    #
    #   resp = client.describe_iam_instance_profile_associations({
    #     association_ids: [
    #       "iip-assoc-0db249b1f25fa24b8", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     iam_instance_profile_associations: [
    #       {
    #         association_id: "iip-assoc-0db249b1f25fa24b8", 
    #         iam_instance_profile: {
    #           arn: "arn:aws:iam::123456789012:instance-profile/admin-role", 
    #           id: "AIPAJVQN4F5WVLGCJDRGM", 
    #         }, 
    #         instance_id: "i-09eb09efa73ec1dee", 
    #         state: "associated", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_iam_instance_profile_associations({
    #     association_ids: ["String"],
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #     next_token: "NextToken",
    #   })
    #
    # @example Response structure
    #
    #   resp.iam_instance_profile_associations #=> Array
    #   resp.iam_instance_profile_associations[0].association_id #=> String
    #   resp.iam_instance_profile_associations[0].instance_id #=> String
    #   resp.iam_instance_profile_associations[0].iam_instance_profile.arn #=> String
    #   resp.iam_instance_profile_associations[0].iam_instance_profile.id #=> String
    #   resp.iam_instance_profile_associations[0].state #=> String, one of "associating", "associated", "disassociating", "disassociated"
    #   resp.iam_instance_profile_associations[0].timestamp #=> Time
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIamInstanceProfileAssociations AWS API Documentation
    #
    # @overload describe_iam_instance_profile_associations(params = {})
    # @param [Hash] params ({})
    def describe_iam_instance_profile_associations(params = {}, options = {})
      req = build_request(:describe_iam_instance_profile_associations, params)
      req.send_request(options)
    end

    # Describes the ID format settings for your resources on a per-Region
    # basis, for example, to view which resource types are enabled for
    # longer IDs. This request only returns information about resource types
    # whose ID formats can be modified; it does not return information about
    # other resource types.
    #
    # The following resource types support longer IDs: `bundle` \|
    # `conversion-task` \| `customer-gateway` \| `dhcp-options` \|
    # `elastic-ip-allocation` \| `elastic-ip-association` \| `export-task`
    # \| `flow-log` \| `image` \| `import-task` \| `instance` \|
    # `internet-gateway` \| `network-acl` \| `network-acl-association` \|
    # `network-interface` \| `network-interface-attachment` \| `prefix-list`
    # \| `reservation` \| `route-table` \| `route-table-association` \|
    # `security-group` \| `snapshot` \| `subnet` \|
    # `subnet-cidr-block-association` \| `volume` \| `vpc` \|
    # `vpc-cidr-block-association` \| `vpc-endpoint` \|
    # `vpc-peering-connection` \| `vpn-connection` \| `vpn-gateway`.
    #
    # These settings apply to the IAM user who makes the request; they do
    # not apply to the entire AWS account. By default, an IAM user defaults
    # to the same settings as the root user, unless they explicitly override
    # the settings by running the ModifyIdFormat command. Resources created
    # with longer IDs are visible to all IAM users, regardless of these
    # settings and provided that they have permission to use the relevant
    # `Describe` command for the resource type.
    #
    # @option params [String] :resource
    #   The type of resource: `bundle` \| `conversion-task` \|
    #   `customer-gateway` \| `dhcp-options` \| `elastic-ip-allocation` \|
    #   `elastic-ip-association` \| `export-task` \| `flow-log` \| `image` \|
    #   `import-task` \| `instance` \| `internet-gateway` \| `network-acl` \|
    #   `network-acl-association` \| `network-interface` \|
    #   `network-interface-attachment` \| `prefix-list` \| `reservation` \|
    #   `route-table` \| `route-table-association` \| `security-group` \|
    #   `snapshot` \| `subnet` \| `subnet-cidr-block-association` \| `volume`
    #   \| `vpc` \| `vpc-cidr-block-association` \| `vpc-endpoint` \|
    #   `vpc-peering-connection` \| `vpn-connection` \| `vpn-gateway`
    #
    # @return [Types::DescribeIdFormatResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeIdFormatResult#statuses #statuses} => Array&lt;Types::IdFormat&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_id_format({
    #     resource: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.statuses #=> Array
    #   resp.statuses[0].deadline #=> Time
    #   resp.statuses[0].resource #=> String
    #   resp.statuses[0].use_long_ids #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdFormat AWS API Documentation
    #
    # @overload describe_id_format(params = {})
    # @param [Hash] params ({})
    def describe_id_format(params = {}, options = {})
      req = build_request(:describe_id_format, params)
      req.send_request(options)
    end

    # Describes the ID format settings for resources for the specified IAM
    # user, IAM role, or root user. For example, you can view the resource
    # types that are enabled for longer IDs. This request only returns
    # information about resource types whose ID formats can be modified; it
    # does not return information about other resource types. For more
    # information, see [Resource IDs][1] in the *Amazon Elastic Compute
    # Cloud User Guide*.
    #
    # The following resource types support longer IDs: `bundle` \|
    # `conversion-task` \| `customer-gateway` \| `dhcp-options` \|
    # `elastic-ip-allocation` \| `elastic-ip-association` \| `export-task`
    # \| `flow-log` \| `image` \| `import-task` \| `instance` \|
    # `internet-gateway` \| `network-acl` \| `network-acl-association` \|
    # `network-interface` \| `network-interface-attachment` \| `prefix-list`
    # \| `reservation` \| `route-table` \| `route-table-association` \|
    # `security-group` \| `snapshot` \| `subnet` \|
    # `subnet-cidr-block-association` \| `volume` \| `vpc` \|
    # `vpc-cidr-block-association` \| `vpc-endpoint` \|
    # `vpc-peering-connection` \| `vpn-connection` \| `vpn-gateway`.
    #
    # These settings apply to the principal specified in the request. They
    # do not apply to the principal that makes the request.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html
    #
    # @option params [required, String] :principal_arn
    #   The ARN of the principal, which can be an IAM role, IAM user, or the
    #   root user.
    #
    # @option params [String] :resource
    #   The type of resource: `bundle` \| `conversion-task` \|
    #   `customer-gateway` \| `dhcp-options` \| `elastic-ip-allocation` \|
    #   `elastic-ip-association` \| `export-task` \| `flow-log` \| `image` \|
    #   `import-task` \| `instance` \| `internet-gateway` \| `network-acl` \|
    #   `network-acl-association` \| `network-interface` \|
    #   `network-interface-attachment` \| `prefix-list` \| `reservation` \|
    #   `route-table` \| `route-table-association` \| `security-group` \|
    #   `snapshot` \| `subnet` \| `subnet-cidr-block-association` \| `volume`
    #   \| `vpc` \| `vpc-cidr-block-association` \| `vpc-endpoint` \|
    #   `vpc-peering-connection` \| `vpn-connection` \| `vpn-gateway`
    #
    # @return [Types::DescribeIdentityIdFormatResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeIdentityIdFormatResult#statuses #statuses} => Array&lt;Types::IdFormat&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_identity_id_format({
    #     principal_arn: "String", # required
    #     resource: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.statuses #=> Array
    #   resp.statuses[0].deadline #=> Time
    #   resp.statuses[0].resource #=> String
    #   resp.statuses[0].use_long_ids #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdentityIdFormat AWS API Documentation
    #
    # @overload describe_identity_id_format(params = {})
    # @param [Hash] params ({})
    def describe_identity_id_format(params = {}, options = {})
      req = build_request(:describe_identity_id_format, params)
      req.send_request(options)
    end

    # Describes the specified attribute of the specified AMI. You can
    # specify only one attribute at a time.
    #
    # @option params [required, String] :attribute
    #   The AMI attribute.
    #
    #   **Note**\: Depending on your account privileges, the
    #   `blockDeviceMapping` attribute may return a `Client.AuthFailure`
    #   error. If this happens, use DescribeImages to get information about
    #   the block device mapping for the AMI.
    #
    # @option params [required, String] :image_id
    #   The ID of the AMI.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::ImageAttribute] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ImageAttribute#block_device_mappings #block_device_mappings} => Array&lt;Types::BlockDeviceMapping&gt;
    #   * {Types::ImageAttribute#image_id #image_id} => String
    #   * {Types::ImageAttribute#launch_permissions #launch_permissions} => Array&lt;Types::LaunchPermission&gt;
    #   * {Types::ImageAttribute#product_codes #product_codes} => Array&lt;Types::ProductCode&gt;
    #   * {Types::ImageAttribute#description #description} => Types::AttributeValue
    #   * {Types::ImageAttribute#kernel_id #kernel_id} => Types::AttributeValue
    #   * {Types::ImageAttribute#ramdisk_id #ramdisk_id} => Types::AttributeValue
    #   * {Types::ImageAttribute#sriov_net_support #sriov_net_support} => Types::AttributeValue
    #
    #
    # @example Example: To describe the launch permissions for an AMI
    #
    #   # This example describes the launch permissions for the specified AMI.
    #
    #   resp = client.describe_image_attribute({
    #     attribute: "launchPermission", 
    #     image_id: "ami-5731123e", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     image_id: "ami-5731123e", 
    #     launch_permissions: [
    #       {
    #         user_id: "123456789012", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_image_attribute({
    #     attribute: "description", # required, accepts description, kernel, ramdisk, launchPermission, productCodes, blockDeviceMapping, sriovNetSupport
    #     image_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.block_device_mappings #=> Array
    #   resp.block_device_mappings[0].device_name #=> String
    #   resp.block_device_mappings[0].virtual_name #=> String
    #   resp.block_device_mappings[0].ebs.delete_on_termination #=> Boolean
    #   resp.block_device_mappings[0].ebs.iops #=> Integer
    #   resp.block_device_mappings[0].ebs.snapshot_id #=> String
    #   resp.block_device_mappings[0].ebs.volume_size #=> Integer
    #   resp.block_device_mappings[0].ebs.volume_type #=> String, one of "standard", "io1", "gp2", "sc1", "st1"
    #   resp.block_device_mappings[0].ebs.encrypted #=> Boolean
    #   resp.block_device_mappings[0].ebs.kms_key_id #=> String
    #   resp.block_device_mappings[0].no_device #=> String
    #   resp.image_id #=> String
    #   resp.launch_permissions #=> Array
    #   resp.launch_permissions[0].group #=> String, one of "all"
    #   resp.launch_permissions[0].user_id #=> String
    #   resp.product_codes #=> Array
    #   resp.product_codes[0].product_code_id #=> String
    #   resp.product_codes[0].product_code_type #=> String, one of "devpay", "marketplace"
    #   resp.description #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #   resp.kernel_id #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #   resp.ramdisk_id #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #   resp.sriov_net_support #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImageAttribute AWS API Documentation
    #
    # @overload describe_image_attribute(params = {})
    # @param [Hash] params ({})
    def describe_image_attribute(params = {}, options = {})
      req = build_request(:describe_image_attribute, params)
      req.send_request(options)
    end

    # Describes the specified images (AMIs, AKIs, and ARIs) available to you
    # or all of the images available to you.
    #
    # The images available to you include public images, private images that
    # you own, and private images owned by other AWS accounts for which you
    # have explicit launch permissions.
    #
    # Recently deregistered images appear in the returned results for a
    # short interval and then return empty results. After all instances that
    # reference a deregistered AMI are terminated, specifying the ID of the
    # image results in an error indicating that the AMI ID cannot be found.
    #
    # @option params [Array<String>] :executable_users
    #   Scopes the images by users with explicit launch permissions. Specify
    #   an AWS account ID, `self` (the sender of the request), or `all`
    #   (public AMIs).
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `architecture` - The image architecture (`i386` \| `x86_64` \|
    #     `arm64`).
    #
    #   * `block-device-mapping.delete-on-termination` - A Boolean value that
    #     indicates whether the Amazon EBS volume is deleted on instance
    #     termination.
    #
    #   * `block-device-mapping.device-name` - The device name specified in
    #     the block device mapping (for example, `/dev/sdh` or `xvdh`).
    #
    #   * `block-device-mapping.snapshot-id` - The ID of the snapshot used for
    #     the EBS volume.
    #
    #   * `block-device-mapping.volume-size` - The volume size of the EBS
    #     volume, in GiB.
    #
    #   * `block-device-mapping.volume-type` - The volume type of the EBS
    #     volume (`gp2` \| `io1` \| `st1 `\| `sc1` \| `standard`).
    #
    #   * `block-device-mapping.encrypted` - A Boolean that indicates whether
    #     the EBS volume is encrypted.
    #
    #   * `description` - The description of the image (provided during image
    #     creation).
    #
    #   * `ena-support` - A Boolean that indicates whether enhanced networking
    #     with ENA is enabled.
    #
    #   * `hypervisor` - The hypervisor type (`ovm` \| `xen`).
    #
    #   * `image-id` - The ID of the image.
    #
    #   * `image-type` - The image type (`machine` \| `kernel` \| `ramdisk`).
    #
    #   * `is-public` - A Boolean that indicates whether the image is public.
    #
    #   * `kernel-id` - The kernel ID.
    #
    #   * `manifest-location` - The location of the image manifest.
    #
    #   * `name` - The name of the AMI (provided during image creation).
    #
    #   * `owner-alias` - String value from an Amazon-maintained list
    #     (`amazon` \| `aws-marketplace` \| `microsoft`) of snapshot owners.
    #     Not to be confused with the user-configured AWS account alias, which
    #     is set from the IAM console.
    #
    #   * `owner-id` - The AWS account ID of the image owner.
    #
    #   * `platform` - The platform. To only list Windows-based AMIs, use
    #     `windows`.
    #
    #   * `product-code` - The product code.
    #
    #   * `product-code.type` - The type of the product code (`devpay` \|
    #     `marketplace`).
    #
    #   * `ramdisk-id` - The RAM disk ID.
    #
    #   * `root-device-name` - The device name of the root device volume (for
    #     example, `/dev/sda1`).
    #
    #   * `root-device-type` - The type of the root device volume (`ebs` \|
    #     `instance-store`).
    #
    #   * `state` - The state of the image (`available` \| `pending` \|
    #     `failed`).
    #
    #   * `state-reason-code` - The reason code for the state change.
    #
    #   * `state-reason-message` - The message for the state change.
    #
    #   * `sriov-net-support` - A value of `simple` indicates that enhanced
    #     networking with the Intel 82599 VF interface is enabled.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `virtualization-type` - The virtualization type (`paravirtual` \|
    #     `hvm`).
    #
    # @option params [Array<String>] :image_ids
    #   The image IDs.
    #
    #   Default: Describes all images available to you.
    #
    # @option params [Array<String>] :owners
    #   Filters the images by the owner. Specify an AWS account ID, `self`
    #   (owner is the sender of the request), or an AWS owner alias (valid
    #   values are `amazon` \| `aws-marketplace` \| `microsoft`). Omitting
    #   this option returns all images for which you have launch permissions,
    #   regardless of ownership.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeImagesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeImagesResult#images #images} => Array&lt;Types::Image&gt;
    #
    #
    # @example Example: To describe an AMI
    #
    #   # This example describes the specified AMI.
    #
    #   resp = client.describe_images({
    #     image_ids: [
    #       "ami-5731123e", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     images: [
    #       {
    #         architecture: "x86_64", 
    #         block_device_mappings: [
    #           {
    #             device_name: "/dev/sda1", 
    #             ebs: {
    #               delete_on_termination: true, 
    #               snapshot_id: "snap-1234567890abcdef0", 
    #               volume_size: 8, 
    #               volume_type: "standard", 
    #             }, 
    #           }, 
    #         ], 
    #         description: "An AMI for my server", 
    #         hypervisor: "xen", 
    #         image_id: "ami-5731123e", 
    #         image_location: "123456789012/My server", 
    #         image_type: "machine", 
    #         kernel_id: "aki-88aa75e1", 
    #         name: "My server", 
    #         owner_id: "123456789012", 
    #         public: false, 
    #         root_device_name: "/dev/sda1", 
    #         root_device_type: "ebs", 
    #         state: "available", 
    #         virtualization_type: "paravirtual", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_images({
    #     executable_users: ["String"],
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     image_ids: ["String"],
    #     owners: ["String"],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.images #=> Array
    #   resp.images[0].architecture #=> String, one of "i386", "x86_64", "arm64"
    #   resp.images[0].creation_date #=> String
    #   resp.images[0].image_id #=> String
    #   resp.images[0].image_location #=> String
    #   resp.images[0].image_type #=> String, one of "machine", "kernel", "ramdisk"
    #   resp.images[0].public #=> Boolean
    #   resp.images[0].kernel_id #=> String
    #   resp.images[0].owner_id #=> String
    #   resp.images[0].platform #=> String, one of "Windows"
    #   resp.images[0].product_codes #=> Array
    #   resp.images[0].product_codes[0].product_code_id #=> String
    #   resp.images[0].product_codes[0].product_code_type #=> String, one of "devpay", "marketplace"
    #   resp.images[0].ramdisk_id #=> String
    #   resp.images[0].state #=> String, one of "pending", "available", "invalid", "deregistered", "transient", "failed", "error"
    #   resp.images[0].block_device_mappings #=> Array
    #   resp.images[0].block_device_mappings[0].device_name #=> String
    #   resp.images[0].block_device_mappings[0].virtual_name #=> String
    #   resp.images[0].block_device_mappings[0].ebs.delete_on_termination #=> Boolean
    #   resp.images[0].block_device_mappings[0].ebs.iops #=> Integer
    #   resp.images[0].block_device_mappings[0].ebs.snapshot_id #=> String
    #   resp.images[0].block_device_mappings[0].ebs.volume_size #=> Integer
    #   resp.images[0].block_device_mappings[0].ebs.volume_type #=> String, one of "standard", "io1", "gp2", "sc1", "st1"
    #   resp.images[0].block_device_mappings[0].ebs.encrypted #=> Boolean
    #   resp.images[0].block_device_mappings[0].ebs.kms_key_id #=> String
    #   resp.images[0].block_device_mappings[0].no_device #=> String
    #   resp.images[0].description #=> String
    #   resp.images[0].ena_support #=> Boolean
    #   resp.images[0].hypervisor #=> String, one of "ovm", "xen"
    #   resp.images[0].image_owner_alias #=> String
    #   resp.images[0].name #=> String
    #   resp.images[0].root_device_name #=> String
    #   resp.images[0].root_device_type #=> String, one of "ebs", "instance-store"
    #   resp.images[0].sriov_net_support #=> String
    #   resp.images[0].state_reason.code #=> String
    #   resp.images[0].state_reason.message #=> String
    #   resp.images[0].tags #=> Array
    #   resp.images[0].tags[0].key #=> String
    #   resp.images[0].tags[0].value #=> String
    #   resp.images[0].virtualization_type #=> String, one of "hvm", "paravirtual"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImages AWS API Documentation
    #
    # @overload describe_images(params = {})
    # @param [Hash] params ({})
    def describe_images(params = {}, options = {})
      req = build_request(:describe_images, params)
      req.send_request(options)
    end

    # Displays details about an import virtual machine or import snapshot
    # tasks that are already created.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::Filter>] :filters
    #   Filter tasks using the `task-state` filter and one of the following
    #   values: `active`, `completed`, `deleting`, or `deleted`.
    #
    # @option params [Array<String>] :import_task_ids
    #   The IDs of the import image tasks.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call.
    #
    # @option params [String] :next_token
    #   A token that indicates the next page of results.
    #
    # @return [Types::DescribeImportImageTasksResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeImportImageTasksResult#import_image_tasks #import_image_tasks} => Array&lt;Types::ImportImageTask&gt;
    #   * {Types::DescribeImportImageTasksResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_import_image_tasks({
    #     dry_run: false,
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     import_task_ids: ["String"],
    #     max_results: 1,
    #     next_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.import_image_tasks #=> Array
    #   resp.import_image_tasks[0].architecture #=> String
    #   resp.import_image_tasks[0].description #=> String
    #   resp.import_image_tasks[0].encrypted #=> Boolean
    #   resp.import_image_tasks[0].hypervisor #=> String
    #   resp.import_image_tasks[0].image_id #=> String
    #   resp.import_image_tasks[0].import_task_id #=> String
    #   resp.import_image_tasks[0].kms_key_id #=> String
    #   resp.import_image_tasks[0].license_type #=> String
    #   resp.import_image_tasks[0].platform #=> String
    #   resp.import_image_tasks[0].progress #=> String
    #   resp.import_image_tasks[0].snapshot_details #=> Array
    #   resp.import_image_tasks[0].snapshot_details[0].description #=> String
    #   resp.import_image_tasks[0].snapshot_details[0].device_name #=> String
    #   resp.import_image_tasks[0].snapshot_details[0].disk_image_size #=> Float
    #   resp.import_image_tasks[0].snapshot_details[0].format #=> String
    #   resp.import_image_tasks[0].snapshot_details[0].progress #=> String
    #   resp.import_image_tasks[0].snapshot_details[0].snapshot_id #=> String
    #   resp.import_image_tasks[0].snapshot_details[0].status #=> String
    #   resp.import_image_tasks[0].snapshot_details[0].status_message #=> String
    #   resp.import_image_tasks[0].snapshot_details[0].url #=> String
    #   resp.import_image_tasks[0].snapshot_details[0].user_bucket.s3_bucket #=> String
    #   resp.import_image_tasks[0].snapshot_details[0].user_bucket.s3_key #=> String
    #   resp.import_image_tasks[0].status #=> String
    #   resp.import_image_tasks[0].status_message #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportImageTasks AWS API Documentation
    #
    # @overload describe_import_image_tasks(params = {})
    # @param [Hash] params ({})
    def describe_import_image_tasks(params = {}, options = {})
      req = build_request(:describe_import_image_tasks, params)
      req.send_request(options)
    end

    # Describes your import snapshot tasks.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    # @option params [Array<String>] :import_task_ids
    #   A list of import snapshot task IDs.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. To retrieve
    #   the remaining results, make another call with the returned `NextToken`
    #   value.
    #
    # @option params [String] :next_token
    #   A token that indicates the next page of results.
    #
    # @return [Types::DescribeImportSnapshotTasksResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeImportSnapshotTasksResult#import_snapshot_tasks #import_snapshot_tasks} => Array&lt;Types::ImportSnapshotTask&gt;
    #   * {Types::DescribeImportSnapshotTasksResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_import_snapshot_tasks({
    #     dry_run: false,
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     import_task_ids: ["String"],
    #     max_results: 1,
    #     next_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.import_snapshot_tasks #=> Array
    #   resp.import_snapshot_tasks[0].description #=> String
    #   resp.import_snapshot_tasks[0].import_task_id #=> String
    #   resp.import_snapshot_tasks[0].snapshot_task_detail.description #=> String
    #   resp.import_snapshot_tasks[0].snapshot_task_detail.disk_image_size #=> Float
    #   resp.import_snapshot_tasks[0].snapshot_task_detail.encrypted #=> Boolean
    #   resp.import_snapshot_tasks[0].snapshot_task_detail.format #=> String
    #   resp.import_snapshot_tasks[0].snapshot_task_detail.kms_key_id #=> String
    #   resp.import_snapshot_tasks[0].snapshot_task_detail.progress #=> String
    #   resp.import_snapshot_tasks[0].snapshot_task_detail.snapshot_id #=> String
    #   resp.import_snapshot_tasks[0].snapshot_task_detail.status #=> String
    #   resp.import_snapshot_tasks[0].snapshot_task_detail.status_message #=> String
    #   resp.import_snapshot_tasks[0].snapshot_task_detail.url #=> String
    #   resp.import_snapshot_tasks[0].snapshot_task_detail.user_bucket.s3_bucket #=> String
    #   resp.import_snapshot_tasks[0].snapshot_task_detail.user_bucket.s3_key #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportSnapshotTasks AWS API Documentation
    #
    # @overload describe_import_snapshot_tasks(params = {})
    # @param [Hash] params ({})
    def describe_import_snapshot_tasks(params = {}, options = {})
      req = build_request(:describe_import_snapshot_tasks, params)
      req.send_request(options)
    end

    # Describes the specified attribute of the specified instance. You can
    # specify only one attribute at a time. Valid attribute values are:
    # `instanceType` \| `kernel` \| `ramdisk` \| `userData` \|
    # `disableApiTermination` \| `instanceInitiatedShutdownBehavior` \|
    # `rootDeviceName` \| `blockDeviceMapping` \| `productCodes` \|
    # `sourceDestCheck` \| `groupSet` \| `ebsOptimized` \| `sriovNetSupport`
    #
    # @option params [required, String] :attribute
    #   The instance attribute.
    #
    #   Note: The `enaSupport` attribute is not supported at this time.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :instance_id
    #   The ID of the instance.
    #
    # @return [Types::InstanceAttribute] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::InstanceAttribute#groups #groups} => Array&lt;Types::GroupIdentifier&gt;
    #   * {Types::InstanceAttribute#block_device_mappings #block_device_mappings} => Array&lt;Types::InstanceBlockDeviceMapping&gt;
    #   * {Types::InstanceAttribute#disable_api_termination #disable_api_termination} => Types::AttributeBooleanValue
    #   * {Types::InstanceAttribute#ena_support #ena_support} => Types::AttributeBooleanValue
    #   * {Types::InstanceAttribute#ebs_optimized #ebs_optimized} => Types::AttributeBooleanValue
    #   * {Types::InstanceAttribute#instance_id #instance_id} => String
    #   * {Types::InstanceAttribute#instance_initiated_shutdown_behavior #instance_initiated_shutdown_behavior} => Types::AttributeValue
    #   * {Types::InstanceAttribute#instance_type #instance_type} => Types::AttributeValue
    #   * {Types::InstanceAttribute#kernel_id #kernel_id} => Types::AttributeValue
    #   * {Types::InstanceAttribute#product_codes #product_codes} => Array&lt;Types::ProductCode&gt;
    #   * {Types::InstanceAttribute#ramdisk_id #ramdisk_id} => Types::AttributeValue
    #   * {Types::InstanceAttribute#root_device_name #root_device_name} => Types::AttributeValue
    #   * {Types::InstanceAttribute#source_dest_check #source_dest_check} => Types::AttributeBooleanValue
    #   * {Types::InstanceAttribute#sriov_net_support #sriov_net_support} => Types::AttributeValue
    #   * {Types::InstanceAttribute#user_data #user_data} => Types::AttributeValue
    #
    #
    # @example Example: To describe the instance type
    #
    #   # This example describes the instance type of the specified instance.
    #
    #   resp = client.describe_instance_attribute({
    #     attribute: "instanceType", 
    #     instance_id: "i-1234567890abcdef0", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     instance_id: "i-1234567890abcdef0", 
    #     instance_type: {
    #       value: "t1.micro", 
    #     }, 
    #   }
    #
    # @example Example: To describe the disableApiTermination attribute
    #
    #   # This example describes the ``disableApiTermination`` attribute of the specified instance.
    #
    #   resp = client.describe_instance_attribute({
    #     attribute: "disableApiTermination", 
    #     instance_id: "i-1234567890abcdef0", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     disable_api_termination: {
    #       value: false, 
    #     }, 
    #     instance_id: "i-1234567890abcdef0", 
    #   }
    #
    # @example Example: To describe the block device mapping for an instance
    #
    #   # This example describes the ``blockDeviceMapping`` attribute of the specified instance.
    #
    #   resp = client.describe_instance_attribute({
    #     attribute: "blockDeviceMapping", 
    #     instance_id: "i-1234567890abcdef0", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     block_device_mappings: [
    #       {
    #         device_name: "/dev/sda1", 
    #         ebs: {
    #           attach_time: Time.parse("2013-05-17T22:42:34.000Z"), 
    #           delete_on_termination: true, 
    #           status: "attached", 
    #           volume_id: "vol-049df61146c4d7901", 
    #         }, 
    #       }, 
    #       {
    #         device_name: "/dev/sdf", 
    #         ebs: {
    #           attach_time: Time.parse("2013-09-10T23:07:00.000Z"), 
    #           delete_on_termination: false, 
    #           status: "attached", 
    #           volume_id: "vol-049df61146c4d7901", 
    #         }, 
    #       }, 
    #     ], 
    #     instance_id: "i-1234567890abcdef0", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_instance_attribute({
    #     attribute: "instanceType", # required, accepts instanceType, kernel, ramdisk, userData, disableApiTermination, instanceInitiatedShutdownBehavior, rootDeviceName, blockDeviceMapping, productCodes, sourceDestCheck, groupSet, ebsOptimized, sriovNetSupport, enaSupport
    #     dry_run: false,
    #     instance_id: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.groups #=> Array
    #   resp.groups[0].group_name #=> String
    #   resp.groups[0].group_id #=> String
    #   resp.block_device_mappings #=> Array
    #   resp.block_device_mappings[0].device_name #=> String
    #   resp.block_device_mappings[0].ebs.attach_time #=> Time
    #   resp.block_device_mappings[0].ebs.delete_on_termination #=> Boolean
    #   resp.block_device_mappings[0].ebs.status #=> String, one of "attaching", "attached", "detaching", "detached"
    #   resp.block_device_mappings[0].ebs.volume_id #=> String
    #   resp.disable_api_termination.value #=> Boolean
    #   resp.ena_support.value #=> Boolean
    #   resp.ebs_optimized.value #=> Boolean
    #   resp.instance_id #=> String
    #   resp.instance_initiated_shutdown_behavior #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #   resp.instance_type #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #   resp.kernel_id #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #   resp.product_codes #=> Array
    #   resp.product_codes[0].product_code_id #=> String
    #   resp.product_codes[0].product_code_type #=> String, one of "devpay", "marketplace"
    #   resp.ramdisk_id #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #   resp.root_device_name #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #   resp.source_dest_check.value #=> Boolean
    #   resp.sriov_net_support #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #   resp.user_data #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceAttribute AWS API Documentation
    #
    # @overload describe_instance_attribute(params = {})
    # @param [Hash] params ({})
    def describe_instance_attribute(params = {}, options = {})
      req = build_request(:describe_instance_attribute, params)
      req.send_request(options)
    end

    # Describes the credit option for CPU usage of the specified T2 or T3
    # instances. The credit options are `standard` and `unlimited`.
    #
    # If you do not specify an instance ID, Amazon EC2 returns T2 and T3
    # instances with the `unlimited` credit option, as well as instances
    # that were previously configured as T2 or T3 with the `unlimited`
    # credit option. For example, if you resize a T2 instance, while it is
    # configured as `unlimited`, to an M4 instance, Amazon EC2 returns the
    # M4 instance.
    #
    # If you specify one or more instance IDs, Amazon EC2 returns the credit
    # option (`standard` or `unlimited`) of those instances. If you specify
    # an instance ID that is not valid, such as an instance that is not a T2
    # or T3 instance, an error is returned.
    #
    # Recently terminated instances might appear in the returned results.
    # This interval is usually less than one hour.
    #
    # If an Availability Zone is experiencing a service disruption and you
    # specify instance IDs in the affected zone, or do not specify any
    # instance IDs at all, the call fails. If you specify only instance IDs
    # in an unaffected zone, the call works normally.
    #
    # For more information, see [Burstable Performance Instances][1] in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `instance-id` - The ID of the instance.
    #
    #   ^
    #
    # @option params [Array<String>] :instance_ids
    #   The instance IDs.
    #
    #   Default: Describes all your instances.
    #
    #   Constraints: Maximum 1000 explicitly specified instance IDs.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. To retrieve
    #   the remaining results, make another call with the returned `NextToken`
    #   value. This value can be between 5 and 1000. You cannot specify this
    #   parameter and the instance IDs parameter in the same call.
    #
    # @option params [String] :next_token
    #   The token to retrieve the next page of results.
    #
    # @return [Types::DescribeInstanceCreditSpecificationsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeInstanceCreditSpecificationsResult#instance_credit_specifications #instance_credit_specifications} => Array&lt;Types::InstanceCreditSpecification&gt;
    #   * {Types::DescribeInstanceCreditSpecificationsResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_instance_credit_specifications({
    #     dry_run: false,
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     instance_ids: ["String"],
    #     max_results: 1,
    #     next_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.instance_credit_specifications #=> Array
    #   resp.instance_credit_specifications[0].instance_id #=> String
    #   resp.instance_credit_specifications[0].cpu_credits #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceCreditSpecifications AWS API Documentation
    #
    # @overload describe_instance_credit_specifications(params = {})
    # @param [Hash] params ({})
    def describe_instance_credit_specifications(params = {}, options = {})
      req = build_request(:describe_instance_credit_specifications, params)
      req.send_request(options)
    end

    # Describes the status of the specified instances or all of your
    # instances. By default, only running instances are described, unless
    # you specifically indicate to return the status of all instances.
    #
    # Instance status includes the following components:
    #
    # * **Status checks** - Amazon EC2 performs status checks on running EC2
    #   instances to identify hardware and software issues. For more
    #   information, see [Status Checks for Your Instances][1] and
    #   [Troubleshooting Instances with Failed Status Checks][2] in the
    #   *Amazon Elastic Compute Cloud User Guide*.
    #
    # * **Scheduled events** - Amazon EC2 can schedule events (such as
    #   reboot, stop, or terminate) for your instances related to hardware
    #   issues, software updates, or system maintenance. For more
    #   information, see [Scheduled Events for Your Instances][3] in the
    #   *Amazon Elastic Compute Cloud User Guide*.
    #
    # * **Instance state** - You can manage your instances from the moment
    #   you launch them through their termination. For more information, see
    #   [Instance Lifecycle][4] in the *Amazon Elastic Compute Cloud User
    #   Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-system-instance-status-check.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstances.html
    # [3]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-instances-status-check_sched.html
    # [4]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `availability-zone` - The Availability Zone of the instance.
    #
    #   * `event.code` - The code for the scheduled event (`instance-reboot`
    #     \| `system-reboot` \| `system-maintenance` \| `instance-retirement`
    #     \| `instance-stop`).
    #
    #   * `event.description` - A description of the event.
    #
    #   * `event.instance-event-id` - The ID of the event whose date and time
    #     you are modifying.
    #
    #   * `event.not-after` - The latest end time for the scheduled event (for
    #     example, `2014-09-15T17:15:20.000Z`).
    #
    #   * `event.not-before` - The earliest start time for the scheduled event
    #     (for example, `2014-09-15T17:15:20.000Z`).
    #
    #   * `event.not-before-deadline` - The deadline for starting the event
    #     (for example, `2014-09-15T17:15:20.000Z`).
    #
    #   * `instance-state-code` - The code for the instance state, as a 16-bit
    #     unsigned integer. The high byte is used for internal purposes and
    #     should be ignored. The low byte is set based on the state
    #     represented. The valid values are 0 (pending), 16 (running), 32
    #     (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).
    #
    #   * `instance-state-name` - The state of the instance (`pending` \|
    #     `running` \| `shutting-down` \| `terminated` \| `stopping` \|
    #     `stopped`).
    #
    #   * `instance-status.reachability` - Filters on instance status where
    #     the name is `reachability` (`passed` \| `failed` \| `initializing`
    #     \| `insufficient-data`).
    #
    #   * `instance-status.status` - The status of the instance (`ok` \|
    #     `impaired` \| `initializing` \| `insufficient-data` \|
    #     `not-applicable`).
    #
    #   * `system-status.reachability` - Filters on system status where the
    #     name is `reachability` (`passed` \| `failed` \| `initializing` \|
    #     `insufficient-data`).
    #
    #   * `system-status.status` - The system status of the instance (`ok` \|
    #     `impaired` \| `initializing` \| `insufficient-data` \|
    #     `not-applicable`).
    #
    # @option params [Array<String>] :instance_ids
    #   The instance IDs.
    #
    #   Default: Describes all your instances.
    #
    #   Constraints: Maximum 100 explicitly specified instance IDs.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. To retrieve
    #   the remaining results, make another call with the returned `NextToken`
    #   value. This value can be between 5 and 1000. You cannot specify this
    #   parameter and the instance IDs parameter in the same call.
    #
    # @option params [String] :next_token
    #   The token to retrieve the next page of results.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Boolean] :include_all_instances
    #   When `true`, includes the health status for all instances. When
    #   `false`, includes the health status for running instances only.
    #
    #   Default: `false`
    #
    # @return [Types::DescribeInstanceStatusResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeInstanceStatusResult#instance_statuses #instance_statuses} => Array&lt;Types::InstanceStatus&gt;
    #   * {Types::DescribeInstanceStatusResult#next_token #next_token} => String
    #
    #
    # @example Example: To describe the status of an instance
    #
    #   # This example describes the current status of the specified instance.
    #
    #   resp = client.describe_instance_status({
    #     instance_ids: [
    #       "i-1234567890abcdef0", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     instance_statuses: [
    #       {
    #         availability_zone: "us-east-1d", 
    #         instance_id: "i-1234567890abcdef0", 
    #         instance_state: {
    #           code: 16, 
    #           name: "running", 
    #         }, 
    #         instance_status: {
    #           details: [
    #             {
    #               name: "reachability", 
    #               status: "passed", 
    #             }, 
    #           ], 
    #           status: "ok", 
    #         }, 
    #         system_status: {
    #           details: [
    #             {
    #               name: "reachability", 
    #               status: "passed", 
    #             }, 
    #           ], 
    #           status: "ok", 
    #         }, 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_instance_status({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     instance_ids: ["String"],
    #     max_results: 1,
    #     next_token: "String",
    #     dry_run: false,
    #     include_all_instances: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.instance_statuses #=> Array
    #   resp.instance_statuses[0].availability_zone #=> String
    #   resp.instance_statuses[0].events #=> Array
    #   resp.instance_statuses[0].events[0].instance_event_id #=> String
    #   resp.instance_statuses[0].events[0].code #=> String, one of "instance-reboot", "system-reboot", "system-maintenance", "instance-retirement", "instance-stop"
    #   resp.instance_statuses[0].events[0].description #=> String
    #   resp.instance_statuses[0].events[0].not_after #=> Time
    #   resp.instance_statuses[0].events[0].not_before #=> Time
    #   resp.instance_statuses[0].events[0].not_before_deadline #=> Time
    #   resp.instance_statuses[0].instance_id #=> String
    #   resp.instance_statuses[0].instance_state.code #=> Integer
    #   resp.instance_statuses[0].instance_state.name #=> String, one of "pending", "running", "shutting-down", "terminated", "stopping", "stopped"
    #   resp.instance_statuses[0].instance_status.details #=> Array
    #   resp.instance_statuses[0].instance_status.details[0].impaired_since #=> Time
    #   resp.instance_statuses[0].instance_status.details[0].name #=> String, one of "reachability"
    #   resp.instance_statuses[0].instance_status.details[0].status #=> String, one of "passed", "failed", "insufficient-data", "initializing"
    #   resp.instance_statuses[0].instance_status.status #=> String, one of "ok", "impaired", "insufficient-data", "not-applicable", "initializing"
    #   resp.instance_statuses[0].system_status.details #=> Array
    #   resp.instance_statuses[0].system_status.details[0].impaired_since #=> Time
    #   resp.instance_statuses[0].system_status.details[0].name #=> String, one of "reachability"
    #   resp.instance_statuses[0].system_status.details[0].status #=> String, one of "passed", "failed", "insufficient-data", "initializing"
    #   resp.instance_statuses[0].system_status.status #=> String, one of "ok", "impaired", "insufficient-data", "not-applicable", "initializing"
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceStatus AWS API Documentation
    #
    # @overload describe_instance_status(params = {})
    # @param [Hash] params ({})
    def describe_instance_status(params = {}, options = {})
      req = build_request(:describe_instance_status, params)
      req.send_request(options)
    end

    # Describes the specified instances or all of AWS account's instances.
    #
    # If you specify one or more instance IDs, Amazon EC2 returns
    # information for those instances. If you do not specify instance IDs,
    # Amazon EC2 returns information for all relevant instances. If you
    # specify an instance ID that is not valid, an error is returned. If you
    # specify an instance that you do not own, it is not included in the
    # returned results.
    #
    # Recently terminated instances might appear in the returned results.
    # This interval is usually less than one hour.
    #
    # If you describe instances in the rare case where an Availability Zone
    # is experiencing a service disruption and you specify instance IDs that
    # are in the affected zone, or do not specify any instance IDs at all,
    # the call fails. If you describe instances and specify only instance
    # IDs that are in an unaffected zone, the call works normally.
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `affinity` - The affinity setting for an instance running on a
    #     Dedicated Host (`default` \| `host`).
    #
    #   * `architecture` - The instance architecture (`i386` \| `x86_64` \|
    #     `arm64`).
    #
    #   * `availability-zone` - The Availability Zone of the instance.
    #
    #   * `block-device-mapping.attach-time` - The attach time for an EBS
    #     volume mapped to the instance, for example,
    #     `2010-09-15T17:15:20.000Z`.
    #
    #   * `block-device-mapping.delete-on-termination` - A Boolean that
    #     indicates whether the EBS volume is deleted on instance termination.
    #
    #   * `block-device-mapping.device-name` - The device name specified in
    #     the block device mapping (for example, `/dev/sdh` or `xvdh`).
    #
    #   * `block-device-mapping.status` - The status for the EBS volume
    #     (`attaching` \| `attached` \| `detaching` \| `detached`).
    #
    #   * `block-device-mapping.volume-id` - The volume ID of the EBS volume.
    #
    #   * `client-token` - The idempotency token you provided when you
    #     launched the instance.
    #
    #   * `dns-name` - The public DNS name of the instance.
    #
    #   * `group-id` - The ID of the security group for the instance.
    #     EC2-Classic only.
    #
    #   * `group-name` - The name of the security group for the instance.
    #     EC2-Classic only.
    #
    #   * `hibernation-options.configured` - A Boolean that indicates whether
    #     the instance is enabled for hibernation. A value of `true` means
    #     that the instance is enabled for hibernation.
    #
    #   * `host-id` - The ID of the Dedicated Host on which the instance is
    #     running, if applicable.
    #
    #   * `hypervisor` - The hypervisor type of the instance (`ovm` \| `xen`).
    #
    #   * `iam-instance-profile.arn` - The instance profile associated with
    #     the instance. Specified as an ARN.
    #
    #   * `image-id` - The ID of the image used to launch the instance.
    #
    #   * `instance-id` - The ID of the instance.
    #
    #   * `instance-lifecycle` - Indicates whether this is a Spot Instance or
    #     a Scheduled Instance (`spot` \| `scheduled`).
    #
    #   * `instance-state-code` - The state of the instance, as a 16-bit
    #     unsigned integer. The high byte is used for internal purposes and
    #     should be ignored. The low byte is set based on the state
    #     represented. The valid values are: 0 (pending), 16 (running), 32
    #     (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).
    #
    #   * `instance-state-name` - The state of the instance (`pending` \|
    #     `running` \| `shutting-down` \| `terminated` \| `stopping` \|
    #     `stopped`).
    #
    #   * `instance-type` - The type of instance (for example, `t2.micro`).
    #
    #   * `instance.group-id` - The ID of the security group for the instance.
    #
    #   * `instance.group-name` - The name of the security group for the
    #     instance.
    #
    #   * `ip-address` - The public IPv4 address of the instance.
    #
    #   * `kernel-id` - The kernel ID.
    #
    #   * `key-name` - The name of the key pair used when the instance was
    #     launched.
    #
    #   * `launch-index` - When launching multiple instances, this is the
    #     index for the instance in the launch group (for example, 0, 1, 2,
    #     and so on).
    #
    #   * `launch-time` - The time when the instance was launched.
    #
    #   * `monitoring-state` - Indicates whether detailed monitoring is
    #     enabled (`disabled` \| `enabled`).
    #
    #   * `network-interface.addresses.private-ip-address` - The private IPv4
    #     address associated with the network interface.
    #
    #   * `network-interface.addresses.primary` - Specifies whether the IPv4
    #     address of the network interface is the primary private IPv4
    #     address.
    #
    #   * `network-interface.addresses.association.public-ip` - The ID of the
    #     association of an Elastic IP address (IPv4) with a network
    #     interface.
    #
    #   * `network-interface.addresses.association.ip-owner-id` - The owner ID
    #     of the private IPv4 address associated with the network interface.
    #
    #   * `network-interface.association.public-ip` - The address of the
    #     Elastic IP address (IPv4) bound to the network interface.
    #
    #   * `network-interface.association.ip-owner-id` - The owner of the
    #     Elastic IP address (IPv4) associated with the network interface.
    #
    #   * `network-interface.association.allocation-id` - The allocation ID
    #     returned when you allocated the Elastic IP address (IPv4) for your
    #     network interface.
    #
    #   * `network-interface.association.association-id` - The association ID
    #     returned when the network interface was associated with an IPv4
    #     address.
    #
    #   * `network-interface.attachment.attachment-id` - The ID of the
    #     interface attachment.
    #
    #   * `network-interface.attachment.instance-id` - The ID of the instance
    #     to which the network interface is attached.
    #
    #   * `network-interface.attachment.instance-owner-id` - The owner ID of
    #     the instance to which the network interface is attached.
    #
    #   * `network-interface.attachment.device-index` - The device index to
    #     which the network interface is attached.
    #
    #   * `network-interface.attachment.status` - The status of the attachment
    #     (`attaching` \| `attached` \| `detaching` \| `detached`).
    #
    #   * `network-interface.attachment.attach-time` - The time that the
    #     network interface was attached to an instance.
    #
    #   * `network-interface.attachment.delete-on-termination` - Specifies
    #     whether the attachment is deleted when an instance is terminated.
    #
    #   * `network-interface.availability-zone` - The Availability Zone for
    #     the network interface.
    #
    #   * `network-interface.description` - The description of the network
    #     interface.
    #
    #   * `network-interface.group-id` - The ID of a security group associated
    #     with the network interface.
    #
    #   * `network-interface.group-name` - The name of a security group
    #     associated with the network interface.
    #
    #   * `network-interface.ipv6-addresses.ipv6-address` - The IPv6 address
    #     associated with the network interface.
    #
    #   * `network-interface.mac-address` - The MAC address of the network
    #     interface.
    #
    #   * `network-interface.network-interface-id` - The ID of the network
    #     interface.
    #
    #   * `network-interface.owner-id` - The ID of the owner of the network
    #     interface.
    #
    #   * `network-interface.private-dns-name` - The private DNS name of the
    #     network interface.
    #
    #   * `network-interface.requester-id` - The requester ID for the network
    #     interface.
    #
    #   * `network-interface.requester-managed` - Indicates whether the
    #     network interface is being managed by AWS.
    #
    #   * `network-interface.status` - The status of the network interface
    #     (`available`) \| `in-use`).
    #
    #   * `network-interface.source-dest-check` - Whether the network
    #     interface performs source/destination checking. A value of `true`
    #     means that checking is enabled, and `false` means that checking is
    #     disabled. The value must be `false` for the network interface to
    #     perform network address translation (NAT) in your VPC.
    #
    #   * `network-interface.subnet-id` - The ID of the subnet for the network
    #     interface.
    #
    #   * `network-interface.vpc-id` - The ID of the VPC for the network
    #     interface.
    #
    #   * `owner-id` - The AWS account ID of the instance owner.
    #
    #   * `placement-group-name` - The name of the placement group for the
    #     instance.
    #
    #   * `placement-partition-number` - The partition in which the instance
    #     is located.
    #
    #   * `platform` - The platform. To list only Windows instances, use
    #     `windows`.
    #
    #   * `private-dns-name` - The private IPv4 DNS name of the instance.
    #
    #   * `private-ip-address` - The private IPv4 address of the instance.
    #
    #   * `product-code` - The product code associated with the AMI used to
    #     launch the instance.
    #
    #   * `product-code.type` - The type of product code (`devpay` \|
    #     `marketplace`).
    #
    #   * `ramdisk-id` - The RAM disk ID.
    #
    #   * `reason` - The reason for the current state of the instance (for
    #     example, shows "User Initiated \[date\]" when you stop or
    #     terminate the instance). Similar to the state-reason-code filter.
    #
    #   * `requester-id` - The ID of the entity that launched the instance on
    #     your behalf (for example, AWS Management Console, Auto Scaling, and
    #     so on).
    #
    #   * `reservation-id` - The ID of the instance's reservation. A
    #     reservation ID is created any time you launch an instance. A
    #     reservation ID has a one-to-one relationship with an instance launch
    #     request, but can be associated with more than one instance if you
    #     launch multiple instances using the same launch request. For
    #     example, if you launch one instance, you get one reservation ID. If
    #     you launch ten instances using the same launch request, you also get
    #     one reservation ID.
    #
    #   * `root-device-name` - The device name of the root device volume (for
    #     example, `/dev/sda1`).
    #
    #   * `root-device-type` - The type of the root device volume (`ebs` \|
    #     `instance-store`).
    #
    #   * `source-dest-check` - Indicates whether the instance performs
    #     source/destination checking. A value of `true` means that checking
    #     is enabled, and `false` means that checking is disabled. The value
    #     must be `false` for the instance to perform network address
    #     translation (NAT) in your VPC.
    #
    #   * `spot-instance-request-id` - The ID of the Spot Instance request.
    #
    #   * `state-reason-code` - The reason code for the state change.
    #
    #   * `state-reason-message` - A message that describes the state change.
    #
    #   * `subnet-id` - The ID of the subnet for the instance.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources that have a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `tenancy` - The tenancy of an instance (`dedicated` \| `default` \|
    #     `host`).
    #
    #   * `virtualization-type` - The virtualization type of the instance
    #     (`paravirtual` \| `hvm`).
    #
    #   * `vpc-id` - The ID of the VPC that the instance is running in.
    #
    # @option params [Array<String>] :instance_ids
    #   The instance IDs.
    #
    #   Default: Describes all your instances.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. To retrieve
    #   the remaining results, make another call with the returned `NextToken`
    #   value. This value can be between 5 and 1000. You cannot specify this
    #   parameter and the instance IDs parameter in the same call.
    #
    # @option params [String] :next_token
    #   The token to request the next page of results.
    #
    # @return [Types::DescribeInstancesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeInstancesResult#reservations #reservations} => Array&lt;Types::Reservation&gt;
    #   * {Types::DescribeInstancesResult#next_token #next_token} => String
    #
    #
    # @example Example: To describe an Amazon EC2 instance
    #
    #   # This example describes the specified instance.
    #
    #   resp = client.describe_instances({
    #     instance_ids: [
    #       "i-1234567890abcdef0", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Example: To describe the instances with a specific instance type
    #
    #   # This example describes the instances with the t2.micro instance type.
    #
    #   resp = client.describe_instances({
    #     filters: [
    #       {
    #         name: "instance-type", 
    #         values: [
    #           "t2.micro", 
    #         ], 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Example: To describe the instances with a specific tag
    #
    #   # This example describes the instances with the Purpose=test tag.
    #
    #   resp = client.describe_instances({
    #     filters: [
    #       {
    #         name: "tag:Purpose", 
    #         values: [
    #           "test", 
    #         ], 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Filtering by tags examples
    #   # filtering by tag keys "key1" or "key2"
    #   ec2.describe_instances(filters:[{ name: 'tag-key', values: ['key1', 'key2'] }])
    #
    #   # filtering by tag values "value1" or "value1"
    #   ec2.describe_instances(filters:[{ name: 'tag-value', values: ['value1', 'value2'] }])
    #
    #   # filtering by key and value, key equals "key1" and value equals "value1" or "value2"
    #   ec2.describe_instances(filters:[{ name: "tag:key1", values: ['value1'] }])
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_instances({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     instance_ids: ["String"],
    #     dry_run: false,
    #     max_results: 1,
    #     next_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.reservations #=> Array
    #   resp.reservations[0].groups #=> Array
    #   resp.reservations[0].groups[0].group_name #=> String
    #   resp.reservations[0].groups[0].group_id #=> String
    #   resp.reservations[0].instances #=> Array
    #   resp.reservations[0].instances[0].ami_launch_index #=> Integer
    #   resp.reservations[0].instances[0].image_id #=> String
    #   resp.reservations[0].instances[0].instance_id #=> String
    #   resp.reservations[0].instances[0].instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.18xlarge", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge"
    #   resp.reservations[0].instances[0].kernel_id #=> String
    #   resp.reservations[0].instances[0].key_name #=> String
    #   resp.reservations[0].instances[0].launch_time #=> Time
    #   resp.reservations[0].instances[0].monitoring.state #=> String, one of "disabled", "disabling", "enabled", "pending"
    #   resp.reservations[0].instances[0].placement.availability_zone #=> String
    #   resp.reservations[0].instances[0].placement.affinity #=> String
    #   resp.reservations[0].instances[0].placement.group_name #=> String
    #   resp.reservations[0].instances[0].placement.partition_number #=> Integer
    #   resp.reservations[0].instances[0].placement.host_id #=> String
    #   resp.reservations[0].instances[0].placement.tenancy #=> String, one of "default", "dedicated", "host"
    #   resp.reservations[0].instances[0].placement.spread_domain #=> String
    #   resp.reservations[0].instances[0].platform #=> String, one of "Windows"
    #   resp.reservations[0].instances[0].private_dns_name #=> String
    #   resp.reservations[0].instances[0].private_ip_address #=> String
    #   resp.reservations[0].instances[0].product_codes #=> Array
    #   resp.reservations[0].instances[0].product_codes[0].product_code_id #=> String
    #   resp.reservations[0].instances[0].product_codes[0].product_code_type #=> String, one of "devpay", "marketplace"
    #   resp.reservations[0].instances[0].public_dns_name #=> String
    #   resp.reservations[0].instances[0].public_ip_address #=> String
    #   resp.reservations[0].instances[0].ramdisk_id #=> String
    #   resp.reservations[0].instances[0].state.code #=> Integer
    #   resp.reservations[0].instances[0].state.name #=> String, one of "pending", "running", "shutting-down", "terminated", "stopping", "stopped"
    #   resp.reservations[0].instances[0].state_transition_reason #=> String
    #   resp.reservations[0].instances[0].subnet_id #=> String
    #   resp.reservations[0].instances[0].vpc_id #=> String
    #   resp.reservations[0].instances[0].architecture #=> String, one of "i386", "x86_64", "arm64"
    #   resp.reservations[0].instances[0].block_device_mappings #=> Array
    #   resp.reservations[0].instances[0].block_device_mappings[0].device_name #=> String
    #   resp.reservations[0].instances[0].block_device_mappings[0].ebs.attach_time #=> Time
    #   resp.reservations[0].instances[0].block_device_mappings[0].ebs.delete_on_termination #=> Boolean
    #   resp.reservations[0].instances[0].block_device_mappings[0].ebs.status #=> String, one of "attaching", "attached", "detaching", "detached"
    #   resp.reservations[0].instances[0].block_device_mappings[0].ebs.volume_id #=> String
    #   resp.reservations[0].instances[0].client_token #=> String
    #   resp.reservations[0].instances[0].ebs_optimized #=> Boolean
    #   resp.reservations[0].instances[0].ena_support #=> Boolean
    #   resp.reservations[0].instances[0].hypervisor #=> String, one of "ovm", "xen"
    #   resp.reservations[0].instances[0].iam_instance_profile.arn #=> String
    #   resp.reservations[0].instances[0].iam_instance_profile.id #=> String
    #   resp.reservations[0].instances[0].instance_lifecycle #=> String, one of "spot", "scheduled"
    #   resp.reservations[0].instances[0].elastic_gpu_associations #=> Array
    #   resp.reservations[0].instances[0].elastic_gpu_associations[0].elastic_gpu_id #=> String
    #   resp.reservations[0].instances[0].elastic_gpu_associations[0].elastic_gpu_association_id #=> String
    #   resp.reservations[0].instances[0].elastic_gpu_associations[0].elastic_gpu_association_state #=> String
    #   resp.reservations[0].instances[0].elastic_gpu_associations[0].elastic_gpu_association_time #=> String
    #   resp.reservations[0].instances[0].elastic_inference_accelerator_associations #=> Array
    #   resp.reservations[0].instances[0].elastic_inference_accelerator_associations[0].elastic_inference_accelerator_arn #=> String
    #   resp.reservations[0].instances[0].elastic_inference_accelerator_associations[0].elastic_inference_accelerator_association_id #=> String
    #   resp.reservations[0].instances[0].elastic_inference_accelerator_associations[0].elastic_inference_accelerator_association_state #=> String
    #   resp.reservations[0].instances[0].elastic_inference_accelerator_associations[0].elastic_inference_accelerator_association_time #=> Time
    #   resp.reservations[0].instances[0].network_interfaces #=> Array
    #   resp.reservations[0].instances[0].network_interfaces[0].association.ip_owner_id #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].association.public_dns_name #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].association.public_ip #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].attachment.attach_time #=> Time
    #   resp.reservations[0].instances[0].network_interfaces[0].attachment.attachment_id #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].attachment.delete_on_termination #=> Boolean
    #   resp.reservations[0].instances[0].network_interfaces[0].attachment.device_index #=> Integer
    #   resp.reservations[0].instances[0].network_interfaces[0].attachment.status #=> String, one of "attaching", "attached", "detaching", "detached"
    #   resp.reservations[0].instances[0].network_interfaces[0].description #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].groups #=> Array
    #   resp.reservations[0].instances[0].network_interfaces[0].groups[0].group_name #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].groups[0].group_id #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].ipv_6_addresses #=> Array
    #   resp.reservations[0].instances[0].network_interfaces[0].ipv_6_addresses[0].ipv_6_address #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].mac_address #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].network_interface_id #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].owner_id #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].private_dns_name #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].private_ip_address #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].private_ip_addresses #=> Array
    #   resp.reservations[0].instances[0].network_interfaces[0].private_ip_addresses[0].association.ip_owner_id #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].private_ip_addresses[0].association.public_dns_name #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].private_ip_addresses[0].association.public_ip #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].private_ip_addresses[0].primary #=> Boolean
    #   resp.reservations[0].instances[0].network_interfaces[0].private_ip_addresses[0].private_dns_name #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].private_ip_addresses[0].private_ip_address #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].source_dest_check #=> Boolean
    #   resp.reservations[0].instances[0].network_interfaces[0].status #=> String, one of "available", "associated", "attaching", "in-use", "detaching"
    #   resp.reservations[0].instances[0].network_interfaces[0].subnet_id #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].vpc_id #=> String
    #   resp.reservations[0].instances[0].network_interfaces[0].interface_type #=> String
    #   resp.reservations[0].instances[0].root_device_name #=> String
    #   resp.reservations[0].instances[0].root_device_type #=> String, one of "ebs", "instance-store"
    #   resp.reservations[0].instances[0].security_groups #=> Array
    #   resp.reservations[0].instances[0].security_groups[0].group_name #=> String
    #   resp.reservations[0].instances[0].security_groups[0].group_id #=> String
    #   resp.reservations[0].instances[0].source_dest_check #=> Boolean
    #   resp.reservations[0].instances[0].spot_instance_request_id #=> String
    #   resp.reservations[0].instances[0].sriov_net_support #=> String
    #   resp.reservations[0].instances[0].state_reason.code #=> String
    #   resp.reservations[0].instances[0].state_reason.message #=> String
    #   resp.reservations[0].instances[0].tags #=> Array
    #   resp.reservations[0].instances[0].tags[0].key #=> String
    #   resp.reservations[0].instances[0].tags[0].value #=> String
    #   resp.reservations[0].instances[0].virtualization_type #=> String, one of "hvm", "paravirtual"
    #   resp.reservations[0].instances[0].cpu_options.core_count #=> Integer
    #   resp.reservations[0].instances[0].cpu_options.threads_per_core #=> Integer
    #   resp.reservations[0].instances[0].capacity_reservation_id #=> String
    #   resp.reservations[0].instances[0].capacity_reservation_specification.capacity_reservation_preference #=> String, one of "open", "none"
    #   resp.reservations[0].instances[0].capacity_reservation_specification.capacity_reservation_target.capacity_reservation_id #=> String
    #   resp.reservations[0].instances[0].hibernation_options.configured #=> Boolean
    #   resp.reservations[0].instances[0].licenses #=> Array
    #   resp.reservations[0].instances[0].licenses[0].license_configuration_arn #=> String
    #   resp.reservations[0].owner_id #=> String
    #   resp.reservations[0].requester_id #=> String
    #   resp.reservations[0].reservation_id #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstances AWS API Documentation
    #
    # @overload describe_instances(params = {})
    # @param [Hash] params ({})
    def describe_instances(params = {}, options = {})
      req = build_request(:describe_instances, params)
      req.send_request(options)
    end

    # Describes one or more of your internet gateways.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `attachment.state` - The current state of the attachment between the
    #     gateway and the VPC (`available`). Present only if a VPC is
    #     attached.
    #
    #   * `attachment.vpc-id` - The ID of an attached VPC.
    #
    #   * `internet-gateway-id` - The ID of the Internet gateway.
    #
    #   * `owner-id` - The ID of the AWS account that owns the internet
    #     gateway.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<String>] :internet_gateway_ids
    #   One or more internet gateway IDs.
    #
    #   Default: Describes all your internet gateways.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @return [Types::DescribeInternetGatewaysResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeInternetGatewaysResult#internet_gateways #internet_gateways} => Array&lt;Types::InternetGateway&gt;
    #   * {Types::DescribeInternetGatewaysResult#next_token #next_token} => String
    #
    #
    # @example Example: To describe the Internet gateway for a VPC
    #
    #   # This example describes the Internet gateway for the specified VPC.
    #
    #   resp = client.describe_internet_gateways({
    #     filters: [
    #       {
    #         name: "attachment.vpc-id", 
    #         values: [
    #           "vpc-a01106c2", 
    #         ], 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     internet_gateways: [
    #       {
    #         attachments: [
    #           {
    #             state: "available", 
    #             vpc_id: "vpc-a01106c2", 
    #           }, 
    #         ], 
    #         internet_gateway_id: "igw-c0a643a9", 
    #         tags: [
    #         ], 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_internet_gateways({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     dry_run: false,
    #     internet_gateway_ids: ["String"],
    #     next_token: "String",
    #     max_results: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.internet_gateways #=> Array
    #   resp.internet_gateways[0].attachments #=> Array
    #   resp.internet_gateways[0].attachments[0].state #=> String, one of "attaching", "attached", "detaching", "detached"
    #   resp.internet_gateways[0].attachments[0].vpc_id #=> String
    #   resp.internet_gateways[0].internet_gateway_id #=> String
    #   resp.internet_gateways[0].owner_id #=> String
    #   resp.internet_gateways[0].tags #=> Array
    #   resp.internet_gateways[0].tags[0].key #=> String
    #   resp.internet_gateways[0].tags[0].value #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInternetGateways AWS API Documentation
    #
    # @overload describe_internet_gateways(params = {})
    # @param [Hash] params ({})
    def describe_internet_gateways(params = {}, options = {})
      req = build_request(:describe_internet_gateways, params)
      req.send_request(options)
    end

    # Describes the specified key pairs or all of your key pairs.
    #
    # For more information about key pairs, see [Key Pairs][1] in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `fingerprint` - The fingerprint of the key pair.
    #
    #   * `key-name` - The name of the key pair.
    #
    # @option params [Array<String>] :key_names
    #   The key pair names.
    #
    #   Default: Describes all your key pairs.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeKeyPairsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeKeyPairsResult#key_pairs #key_pairs} => Array&lt;Types::KeyPairInfo&gt;
    #
    #
    # @example Example: To display a key pair
    #
    #   # This example displays the fingerprint for the specified key.
    #
    #   resp = client.describe_key_pairs({
    #     key_names: [
    #       "my-key-pair", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     key_pairs: [
    #       {
    #         key_fingerprint: "1f:51:ae:28:bf:89:e9:d8:1f:25:5d:37:2d:7d:b8:ca:9f:f5:f1:6f", 
    #         key_name: "my-key-pair", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_key_pairs({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     key_names: ["String"],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.key_pairs #=> Array
    #   resp.key_pairs[0].key_fingerprint #=> String
    #   resp.key_pairs[0].key_name #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeKeyPairs AWS API Documentation
    #
    # @overload describe_key_pairs(params = {})
    # @param [Hash] params ({})
    def describe_key_pairs(params = {}, options = {})
      req = build_request(:describe_key_pairs, params)
      req.send_request(options)
    end

    # Describes one or more versions of a specified launch template. You can
    # describe all versions, individual versions, or a range of versions.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :launch_template_id
    #   The ID of the launch template. You must specify either the launch
    #   template ID or launch template name in the request.
    #
    # @option params [String] :launch_template_name
    #   The name of the launch template. You must specify either the launch
    #   template ID or launch template name in the request.
    #
    # @option params [Array<String>] :versions
    #   One or more versions of the launch template.
    #
    # @option params [String] :min_version
    #   The version number after which to describe launch template versions.
    #
    # @option params [String] :max_version
    #   The version number up to which to describe launch template versions.
    #
    # @option params [String] :next_token
    #   The token to request the next page of results.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. To retrieve
    #   the remaining results, make another call with the returned `NextToken`
    #   value. This value can be between 1 and 200.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `create-time` - The time the launch template version was created.
    #
    #   * `ebs-optimized` - A boolean that indicates whether the instance is
    #     optimized for Amazon EBS I/O.
    #
    #   * `iam-instance-profile` - The ARN of the IAM instance profile.
    #
    #   * `image-id` - The ID of the AMI.
    #
    #   * `instance-type` - The instance type.
    #
    #   * `is-default-version` - A boolean that indicates whether the launch
    #     template version is the default version.
    #
    #   * `kernel-id` - The kernel ID.
    #
    #   * `ram-disk-id` - The RAM disk ID.
    #
    # @return [Types::DescribeLaunchTemplateVersionsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeLaunchTemplateVersionsResult#launch_template_versions #launch_template_versions} => Array&lt;Types::LaunchTemplateVersion&gt;
    #   * {Types::DescribeLaunchTemplateVersionsResult#next_token #next_token} => String
    #
    #
    # @example Example: To describe the versions for a launch template
    #
    #   # This example describes the versions for the specified launch template.
    #
    #   resp = client.describe_launch_template_versions({
    #     launch_template_id: "068f72b72934aff71", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     launch_template_versions: [
    #       {
    #         create_time: Time.parse("2017-11-20T13:12:32.000Z"), 
    #         created_by: "arn:aws:iam::123456789102:root", 
    #         default_version: false, 
    #         launch_template_data: {
    #           image_id: "ami-6057e21a", 
    #           instance_type: "t2.medium", 
    #           key_name: "kp-us-east", 
    #           network_interfaces: [
    #             {
    #               device_index: 0, 
    #               groups: [
    #                 "sg-7c227019", 
    #               ], 
    #               subnet_id: "subnet-1a2b3c4d", 
    #             }, 
    #           ], 
    #         }, 
    #         launch_template_id: "lt-068f72b72934aff71", 
    #         launch_template_name: "Webservers", 
    #         version_number: 2, 
    #       }, 
    #       {
    #         create_time: Time.parse("2017-11-20T12:52:33.000Z"), 
    #         created_by: "arn:aws:iam::123456789102:root", 
    #         default_version: true, 
    #         launch_template_data: {
    #           image_id: "ami-aabbcc11", 
    #           instance_type: "t2.medium", 
    #           key_name: "kp-us-east", 
    #           network_interfaces: [
    #             {
    #               associate_public_ip_address: true, 
    #               delete_on_termination: false, 
    #               device_index: 0, 
    #               groups: [
    #                 "sg-7c227019", 
    #               ], 
    #               subnet_id: "subnet-7b16de0c", 
    #             }, 
    #           ], 
    #           user_data: "", 
    #         }, 
    #         launch_template_id: "lt-068f72b72934aff71", 
    #         launch_template_name: "Webservers", 
    #         version_number: 1, 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_launch_template_versions({
    #     dry_run: false,
    #     launch_template_id: "String",
    #     launch_template_name: "LaunchTemplateName",
    #     versions: ["String"],
    #     min_version: "String",
    #     max_version: "String",
    #     next_token: "String",
    #     max_results: 1,
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.launch_template_versions #=> Array
    #   resp.launch_template_versions[0].launch_template_id #=> String
    #   resp.launch_template_versions[0].launch_template_name #=> String
    #   resp.launch_template_versions[0].version_number #=> Integer
    #   resp.launch_template_versions[0].version_description #=> String
    #   resp.launch_template_versions[0].create_time #=> Time
    #   resp.launch_template_versions[0].created_by #=> String
    #   resp.launch_template_versions[0].default_version #=> Boolean
    #   resp.launch_template_versions[0].launch_template_data.kernel_id #=> String
    #   resp.launch_template_versions[0].launch_template_data.ebs_optimized #=> Boolean
    #   resp.launch_template_versions[0].launch_template_data.iam_instance_profile.arn #=> String
    #   resp.launch_template_versions[0].launch_template_data.iam_instance_profile.name #=> String
    #   resp.launch_template_versions[0].launch_template_data.block_device_mappings #=> Array
    #   resp.launch_template_versions[0].launch_template_data.block_device_mappings[0].device_name #=> String
    #   resp.launch_template_versions[0].launch_template_data.block_device_mappings[0].virtual_name #=> String
    #   resp.launch_template_versions[0].launch_template_data.block_device_mappings[0].ebs.encrypted #=> Boolean
    #   resp.launch_template_versions[0].launch_template_data.block_device_mappings[0].ebs.delete_on_termination #=> Boolean
    #   resp.launch_template_versions[0].launch_template_data.block_device_mappings[0].ebs.iops #=> Integer
    #   resp.launch_template_versions[0].launch_template_data.block_device_mappings[0].ebs.kms_key_id #=> String
    #   resp.launch_template_versions[0].launch_template_data.block_device_mappings[0].ebs.snapshot_id #=> String
    #   resp.launch_template_versions[0].launch_template_data.block_device_mappings[0].ebs.volume_size #=> Integer
    #   resp.launch_template_versions[0].launch_template_data.block_device_mappings[0].ebs.volume_type #=> String, one of "standard", "io1", "gp2", "sc1", "st1"
    #   resp.launch_template_versions[0].launch_template_data.block_device_mappings[0].no_device #=> String
    #   resp.launch_template_versions[0].launch_template_data.network_interfaces #=> Array
    #   resp.launch_template_versions[0].launch_template_data.network_interfaces[0].associate_public_ip_address #=> Boolean
    #   resp.launch_template_versions[0].launch_template_data.network_interfaces[0].delete_on_termination #=> Boolean
    #   resp.launch_template_versions[0].launch_template_data.network_interfaces[0].description #=> String
    #   resp.launch_template_versions[0].launch_template_data.network_interfaces[0].device_index #=> Integer
    #   resp.launch_template_versions[0].launch_template_data.network_interfaces[0].groups #=> Array
    #   resp.launch_template_versions[0].launch_template_data.network_interfaces[0].groups[0] #=> String
    #   resp.launch_template_versions[0].launch_template_data.network_interfaces[0].interface_type #=> String
    #   resp.launch_template_versions[0].launch_template_data.network_interfaces[0].ipv_6_address_count #=> Integer
    #   resp.launch_template_versions[0].launch_template_data.network_interfaces[0].ipv_6_addresses #=> Array
    #   resp.launch_template_versions[0].launch_template_data.network_interfaces[0].ipv_6_addresses[0].ipv_6_address #=> String
    #   resp.launch_template_versions[0].launch_template_data.network_interfaces[0].network_interface_id #=> String
    #   resp.launch_template_versions[0].launch_template_data.network_interfaces[0].private_ip_address #=> String
    #   resp.launch_template_versions[0].launch_template_data.network_interfaces[0].private_ip_addresses #=> Array
    #   resp.launch_template_versions[0].launch_template_data.network_interfaces[0].private_ip_addresses[0].primary #=> Boolean
    #   resp.launch_template_versions[0].launch_template_data.network_interfaces[0].private_ip_addresses[0].private_ip_address #=> String
    #   resp.launch_template_versions[0].launch_template_data.network_interfaces[0].secondary_private_ip_address_count #=> Integer
    #   resp.launch_template_versions[0].launch_template_data.network_interfaces[0].subnet_id #=> String
    #   resp.launch_template_versions[0].launch_template_data.image_id #=> String
    #   resp.launch_template_versions[0].launch_template_data.instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.18xlarge", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge"
    #   resp.launch_template_versions[0].launch_template_data.key_name #=> String
    #   resp.launch_template_versions[0].launch_template_data.monitoring.enabled #=> Boolean
    #   resp.launch_template_versions[0].launch_template_data.placement.availability_zone #=> String
    #   resp.launch_template_versions[0].launch_template_data.placement.affinity #=> String
    #   resp.launch_template_versions[0].launch_template_data.placement.group_name #=> String
    #   resp.launch_template_versions[0].launch_template_data.placement.host_id #=> String
    #   resp.launch_template_versions[0].launch_template_data.placement.tenancy #=> String, one of "default", "dedicated", "host"
    #   resp.launch_template_versions[0].launch_template_data.placement.spread_domain #=> String
    #   resp.launch_template_versions[0].launch_template_data.ram_disk_id #=> String
    #   resp.launch_template_versions[0].launch_template_data.disable_api_termination #=> Boolean
    #   resp.launch_template_versions[0].launch_template_data.instance_initiated_shutdown_behavior #=> String, one of "stop", "terminate"
    #   resp.launch_template_versions[0].launch_template_data.user_data #=> String
    #   resp.launch_template_versions[0].launch_template_data.tag_specifications #=> Array
    #   resp.launch_template_versions[0].launch_template_data.tag_specifications[0].resource_type #=> String, one of "client-vpn-endpoint", "customer-gateway", "dedicated-host", "dhcp-options", "elastic-ip", "fleet", "fpga-image", "host-reservation", "image", "instance", "internet-gateway", "launch-template", "natgateway", "network-acl", "network-interface", "reserved-instances", "route-table", "security-group", "snapshot", "spot-instances-request", "subnet", "traffic-mirror-filter", "traffic-mirror-session", "traffic-mirror-target", "transit-gateway", "transit-gateway-attachment", "transit-gateway-route-table", "volume", "vpc", "vpc-peering-connection", "vpn-connection", "vpn-gateway"
    #   resp.launch_template_versions[0].launch_template_data.tag_specifications[0].tags #=> Array
    #   resp.launch_template_versions[0].launch_template_data.tag_specifications[0].tags[0].key #=> String
    #   resp.launch_template_versions[0].launch_template_data.tag_specifications[0].tags[0].value #=> String
    #   resp.launch_template_versions[0].launch_template_data.elastic_gpu_specifications #=> Array
    #   resp.launch_template_versions[0].launch_template_data.elastic_gpu_specifications[0].type #=> String
    #   resp.launch_template_versions[0].launch_template_data.elastic_inference_accelerators #=> Array
    #   resp.launch_template_versions[0].launch_template_data.elastic_inference_accelerators[0].type #=> String
    #   resp.launch_template_versions[0].launch_template_data.security_group_ids #=> Array
    #   resp.launch_template_versions[0].launch_template_data.security_group_ids[0] #=> String
    #   resp.launch_template_versions[0].launch_template_data.security_groups #=> Array
    #   resp.launch_template_versions[0].launch_template_data.security_groups[0] #=> String
    #   resp.launch_template_versions[0].launch_template_data.instance_market_options.market_type #=> String, one of "spot"
    #   resp.launch_template_versions[0].launch_template_data.instance_market_options.spot_options.max_price #=> String
    #   resp.launch_template_versions[0].launch_template_data.instance_market_options.spot_options.spot_instance_type #=> String, one of "one-time", "persistent"
    #   resp.launch_template_versions[0].launch_template_data.instance_market_options.spot_options.block_duration_minutes #=> Integer
    #   resp.launch_template_versions[0].launch_template_data.instance_market_options.spot_options.valid_until #=> Time
    #   resp.launch_template_versions[0].launch_template_data.instance_market_options.spot_options.instance_interruption_behavior #=> String, one of "hibernate", "stop", "terminate"
    #   resp.launch_template_versions[0].launch_template_data.credit_specification.cpu_credits #=> String
    #   resp.launch_template_versions[0].launch_template_data.cpu_options.core_count #=> Integer
    #   resp.launch_template_versions[0].launch_template_data.cpu_options.threads_per_core #=> Integer
    #   resp.launch_template_versions[0].launch_template_data.capacity_reservation_specification.capacity_reservation_preference #=> String, one of "open", "none"
    #   resp.launch_template_versions[0].launch_template_data.capacity_reservation_specification.capacity_reservation_target.capacity_reservation_id #=> String
    #   resp.launch_template_versions[0].launch_template_data.license_specifications #=> Array
    #   resp.launch_template_versions[0].launch_template_data.license_specifications[0].license_configuration_arn #=> String
    #   resp.launch_template_versions[0].launch_template_data.hibernation_options.configured #=> Boolean
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLaunchTemplateVersions AWS API Documentation
    #
    # @overload describe_launch_template_versions(params = {})
    # @param [Hash] params ({})
    def describe_launch_template_versions(params = {}, options = {})
      req = build_request(:describe_launch_template_versions, params)
      req.send_request(options)
    end

    # Describes one or more launch templates.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<String>] :launch_template_ids
    #   One or more launch template IDs.
    #
    # @option params [Array<String>] :launch_template_names
    #   One or more launch template names.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `create-time` - The time the launch template was created.
    #
    #   * `launch-template-name` - The name of the launch template.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    # @option params [String] :next_token
    #   The token to request the next page of results.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. To retrieve
    #   the remaining results, make another call with the returned `NextToken`
    #   value. This value can be between 1 and 200.
    #
    # @return [Types::DescribeLaunchTemplatesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeLaunchTemplatesResult#launch_templates #launch_templates} => Array&lt;Types::LaunchTemplate&gt;
    #   * {Types::DescribeLaunchTemplatesResult#next_token #next_token} => String
    #
    #
    # @example Example: To describe a launch template
    #
    #   # This example describes the specified launch template.
    #
    #   resp = client.describe_launch_templates({
    #     launch_template_ids: [
    #       "lt-01238c059e3466abc", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     launch_templates: [
    #       {
    #         create_time: Time.parse("2018-01-16T04:32:57.000Z"), 
    #         created_by: "arn:aws:iam::123456789012:root", 
    #         default_version_number: 1, 
    #         latest_version_number: 1, 
    #         launch_template_id: "lt-01238c059e3466abc", 
    #         launch_template_name: "my-template", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_launch_templates({
    #     dry_run: false,
    #     launch_template_ids: ["String"],
    #     launch_template_names: ["LaunchTemplateName"],
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     next_token: "String",
    #     max_results: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.launch_templates #=> Array
    #   resp.launch_templates[0].launch_template_id #=> String
    #   resp.launch_templates[0].launch_template_name #=> String
    #   resp.launch_templates[0].create_time #=> Time
    #   resp.launch_templates[0].created_by #=> String
    #   resp.launch_templates[0].default_version_number #=> Integer
    #   resp.launch_templates[0].latest_version_number #=> Integer
    #   resp.launch_templates[0].tags #=> Array
    #   resp.launch_templates[0].tags[0].key #=> String
    #   resp.launch_templates[0].tags[0].value #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLaunchTemplates AWS API Documentation
    #
    # @overload describe_launch_templates(params = {})
    # @param [Hash] params ({})
    def describe_launch_templates(params = {}, options = {})
      req = build_request(:describe_launch_templates, params)
      req.send_request(options)
    end

    # Describes your Elastic IP addresses that are being moved to the
    # EC2-VPC platform, or that are being restored to the EC2-Classic
    # platform. This request does not return information about any other
    # Elastic IP addresses in your account.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `moving-status` - The status of the Elastic IP address
    #     (`MovingToVpc` \| `RestoringToClassic`).
    #
    #   ^
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results of the initial request can be seen by
    #   sending another request with the returned `NextToken` value. This
    #   value can be between 5 and 1000; if `MaxResults` is given a value
    #   outside of this range, an error is returned.
    #
    #   Default: If no value is provided, the default is 1000.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @option params [Array<String>] :public_ips
    #   One or more Elastic IP addresses.
    #
    # @return [Types::DescribeMovingAddressesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeMovingAddressesResult#moving_address_statuses #moving_address_statuses} => Array&lt;Types::MovingAddressStatus&gt;
    #   * {Types::DescribeMovingAddressesResult#next_token #next_token} => String
    #
    #
    # @example Example: To describe your moving addresses
    #
    #   # This example describes all of your moving Elastic IP addresses.
    #
    #   resp = client.describe_moving_addresses({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     moving_address_statuses: [
    #       {
    #         move_status: "MovingToVpc", 
    #         public_ip: "198.51.100.0", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_moving_addresses({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     dry_run: false,
    #     max_results: 1,
    #     next_token: "String",
    #     public_ips: ["String"],
    #   })
    #
    # @example Response structure
    #
    #   resp.moving_address_statuses #=> Array
    #   resp.moving_address_statuses[0].move_status #=> String, one of "movingToVpc", "restoringToClassic"
    #   resp.moving_address_statuses[0].public_ip #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeMovingAddresses AWS API Documentation
    #
    # @overload describe_moving_addresses(params = {})
    # @param [Hash] params ({})
    def describe_moving_addresses(params = {}, options = {})
      req = build_request(:describe_moving_addresses, params)
      req.send_request(options)
    end

    # Describes one or more of your NAT gateways.
    #
    # @option params [Array<Types::Filter>] :filter
    #   One or more filters.
    #
    #   * `nat-gateway-id` - The ID of the NAT gateway.
    #
    #   * `state` - The state of the NAT gateway (`pending` \| `failed` \|
    #     `available` \| `deleting` \| `deleted`).
    #
    #   * `subnet-id` - The ID of the subnet in which the NAT gateway resides.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `vpc-id` - The ID of the VPC in which the NAT gateway resides.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @option params [Array<String>] :nat_gateway_ids
    #   One or more NAT gateway IDs.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @return [Types::DescribeNatGatewaysResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeNatGatewaysResult#nat_gateways #nat_gateways} => Array&lt;Types::NatGateway&gt;
    #   * {Types::DescribeNatGatewaysResult#next_token #next_token} => String
    #
    #
    # @example Example: To describe a NAT gateway
    #
    #   # This example describes the NAT gateway for the specified VPC.
    #
    #   resp = client.describe_nat_gateways({
    #     filter: [
    #       {
    #         name: "vpc-id", 
    #         values: [
    #           "vpc-1a2b3c4d", 
    #         ], 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     nat_gateways: [
    #       {
    #         create_time: Time.parse("2015-12-01T12:26:55.983Z"), 
    #         nat_gateway_addresses: [
    #           {
    #             allocation_id: "eipalloc-89c620ec", 
    #             network_interface_id: "eni-9dec76cd", 
    #             private_ip: "10.0.0.149", 
    #             public_ip: "198.11.222.333", 
    #           }, 
    #         ], 
    #         nat_gateway_id: "nat-05dba92075d71c408", 
    #         state: "available", 
    #         subnet_id: "subnet-847e4dc2", 
    #         vpc_id: "vpc-1a2b3c4d", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_nat_gateways({
    #     filter: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #     nat_gateway_ids: ["String"],
    #     next_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.nat_gateways #=> Array
    #   resp.nat_gateways[0].create_time #=> Time
    #   resp.nat_gateways[0].delete_time #=> Time
    #   resp.nat_gateways[0].failure_code #=> String
    #   resp.nat_gateways[0].failure_message #=> String
    #   resp.nat_gateways[0].nat_gateway_addresses #=> Array
    #   resp.nat_gateways[0].nat_gateway_addresses[0].allocation_id #=> String
    #   resp.nat_gateways[0].nat_gateway_addresses[0].network_interface_id #=> String
    #   resp.nat_gateways[0].nat_gateway_addresses[0].private_ip #=> String
    #   resp.nat_gateways[0].nat_gateway_addresses[0].public_ip #=> String
    #   resp.nat_gateways[0].nat_gateway_id #=> String
    #   resp.nat_gateways[0].provisioned_bandwidth.provision_time #=> Time
    #   resp.nat_gateways[0].provisioned_bandwidth.provisioned #=> String
    #   resp.nat_gateways[0].provisioned_bandwidth.request_time #=> Time
    #   resp.nat_gateways[0].provisioned_bandwidth.requested #=> String
    #   resp.nat_gateways[0].provisioned_bandwidth.status #=> String
    #   resp.nat_gateways[0].state #=> String, one of "pending", "failed", "available", "deleting", "deleted"
    #   resp.nat_gateways[0].subnet_id #=> String
    #   resp.nat_gateways[0].vpc_id #=> String
    #   resp.nat_gateways[0].tags #=> Array
    #   resp.nat_gateways[0].tags[0].key #=> String
    #   resp.nat_gateways[0].tags[0].value #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNatGateways AWS API Documentation
    #
    # @overload describe_nat_gateways(params = {})
    # @param [Hash] params ({})
    def describe_nat_gateways(params = {}, options = {})
      req = build_request(:describe_nat_gateways, params)
      req.send_request(options)
    end

    # Describes one or more of your network ACLs.
    #
    # For more information, see [Network ACLs][1] in the *Amazon Virtual
    # Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `association.association-id` - The ID of an association ID for the
    #     ACL.
    #
    #   * `association.network-acl-id` - The ID of the network ACL involved in
    #     the association.
    #
    #   * `association.subnet-id` - The ID of the subnet involved in the
    #     association.
    #
    #   * `default` - Indicates whether the ACL is the default network ACL for
    #     the VPC.
    #
    #   * `entry.cidr` - The IPv4 CIDR range specified in the entry.
    #
    #   * `entry.icmp.code` - The ICMP code specified in the entry, if any.
    #
    #   * `entry.icmp.type` - The ICMP type specified in the entry, if any.
    #
    #   * `entry.ipv6-cidr` - The IPv6 CIDR range specified in the entry.
    #
    #   * `entry.port-range.from` - The start of the port range specified in
    #     the entry.
    #
    #   * `entry.port-range.to` - The end of the port range specified in the
    #     entry.
    #
    #   * `entry.protocol` - The protocol specified in the entry (`tcp` \|
    #     `udp` \| `icmp` or a protocol number).
    #
    #   * `entry.rule-action` - Allows or denies the matching traffic (`allow`
    #     \| `deny`).
    #
    #   * `entry.rule-number` - The number of an entry (in other words, rule)
    #     in the set of ACL entries.
    #
    #   * `network-acl-id` - The ID of the network ACL.
    #
    #   * `owner-id` - The ID of the AWS account that owns the network ACL.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `vpc-id` - The ID of the VPC for the network ACL.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<String>] :network_acl_ids
    #   One or more network ACL IDs.
    #
    #   Default: Describes all your network ACLs.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @return [Types::DescribeNetworkAclsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeNetworkAclsResult#network_acls #network_acls} => Array&lt;Types::NetworkAcl&gt;
    #   * {Types::DescribeNetworkAclsResult#next_token #next_token} => String
    #
    #
    # @example Example: To describe a network ACL
    #
    #   # This example describes the specified network ACL.
    #
    #   resp = client.describe_network_acls({
    #     network_acl_ids: [
    #       "acl-5fb85d36", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     network_acls: [
    #       {
    #         associations: [
    #           {
    #             network_acl_association_id: "aclassoc-66ea5f0b", 
    #             network_acl_id: "acl-9aeb5ef7", 
    #             subnet_id: "subnet-65ea5f08", 
    #           }, 
    #         ], 
    #         entries: [
    #           {
    #             cidr_block: "0.0.0.0/0", 
    #             egress: true, 
    #             protocol: "-1", 
    #             rule_action: "deny", 
    #             rule_number: 32767, 
    #           }, 
    #           {
    #             cidr_block: "0.0.0.0/0", 
    #             egress: false, 
    #             protocol: "-1", 
    #             rule_action: "deny", 
    #             rule_number: 32767, 
    #           }, 
    #         ], 
    #         is_default: false, 
    #         network_acl_id: "acl-5fb85d36", 
    #         tags: [
    #         ], 
    #         vpc_id: "vpc-a01106c2", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_network_acls({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     dry_run: false,
    #     network_acl_ids: ["String"],
    #     next_token: "String",
    #     max_results: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.network_acls #=> Array
    #   resp.network_acls[0].associations #=> Array
    #   resp.network_acls[0].associations[0].network_acl_association_id #=> String
    #   resp.network_acls[0].associations[0].network_acl_id #=> String
    #   resp.network_acls[0].associations[0].subnet_id #=> String
    #   resp.network_acls[0].entries #=> Array
    #   resp.network_acls[0].entries[0].cidr_block #=> String
    #   resp.network_acls[0].entries[0].egress #=> Boolean
    #   resp.network_acls[0].entries[0].icmp_type_code.code #=> Integer
    #   resp.network_acls[0].entries[0].icmp_type_code.type #=> Integer
    #   resp.network_acls[0].entries[0].ipv_6_cidr_block #=> String
    #   resp.network_acls[0].entries[0].port_range.from #=> Integer
    #   resp.network_acls[0].entries[0].port_range.to #=> Integer
    #   resp.network_acls[0].entries[0].protocol #=> String
    #   resp.network_acls[0].entries[0].rule_action #=> String, one of "allow", "deny"
    #   resp.network_acls[0].entries[0].rule_number #=> Integer
    #   resp.network_acls[0].is_default #=> Boolean
    #   resp.network_acls[0].network_acl_id #=> String
    #   resp.network_acls[0].tags #=> Array
    #   resp.network_acls[0].tags[0].key #=> String
    #   resp.network_acls[0].tags[0].value #=> String
    #   resp.network_acls[0].vpc_id #=> String
    #   resp.network_acls[0].owner_id #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkAcls AWS API Documentation
    #
    # @overload describe_network_acls(params = {})
    # @param [Hash] params ({})
    def describe_network_acls(params = {}, options = {})
      req = build_request(:describe_network_acls, params)
      req.send_request(options)
    end

    # Describes a network interface attribute. You can specify only one
    # attribute at a time.
    #
    # @option params [String] :attribute
    #   The attribute of the network interface. This parameter is required.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :network_interface_id
    #   The ID of the network interface.
    #
    # @return [Types::DescribeNetworkInterfaceAttributeResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeNetworkInterfaceAttributeResult#attachment #attachment} => Types::NetworkInterfaceAttachment
    #   * {Types::DescribeNetworkInterfaceAttributeResult#description #description} => Types::AttributeValue
    #   * {Types::DescribeNetworkInterfaceAttributeResult#groups #groups} => Array&lt;Types::GroupIdentifier&gt;
    #   * {Types::DescribeNetworkInterfaceAttributeResult#network_interface_id #network_interface_id} => String
    #   * {Types::DescribeNetworkInterfaceAttributeResult#source_dest_check #source_dest_check} => Types::AttributeBooleanValue
    #
    #
    # @example Example: To describe the attachment attribute of a network interface
    #
    #   # This example describes the attachment attribute of the specified network interface.
    #
    #   resp = client.describe_network_interface_attribute({
    #     attribute: "attachment", 
    #     network_interface_id: "eni-686ea200", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     attachment: {
    #       attach_time: Time.parse("2015-05-21T20:02:20.000Z"), 
    #       attachment_id: "eni-attach-43348162", 
    #       delete_on_termination: true, 
    #       device_index: 0, 
    #       instance_id: "i-1234567890abcdef0", 
    #       instance_owner_id: "123456789012", 
    #       status: "attached", 
    #     }, 
    #     network_interface_id: "eni-686ea200", 
    #   }
    #
    # @example Example: To describe the description attribute of a network interface
    #
    #   # This example describes the description attribute of the specified network interface.
    #
    #   resp = client.describe_network_interface_attribute({
    #     attribute: "description", 
    #     network_interface_id: "eni-686ea200", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     description: {
    #       value: "My description", 
    #     }, 
    #     network_interface_id: "eni-686ea200", 
    #   }
    #
    # @example Example: To describe the groupSet attribute of a network interface
    #
    #   # This example describes the groupSet attribute of the specified network interface.
    #
    #   resp = client.describe_network_interface_attribute({
    #     attribute: "groupSet", 
    #     network_interface_id: "eni-686ea200", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     groups: [
    #       {
    #         group_id: "sg-903004f8", 
    #         group_name: "my-security-group", 
    #       }, 
    #     ], 
    #     network_interface_id: "eni-686ea200", 
    #   }
    #
    # @example Example: To describe the sourceDestCheck attribute of a network interface
    #
    #   # This example describes the sourceDestCheck attribute of the specified network interface.
    #
    #   resp = client.describe_network_interface_attribute({
    #     attribute: "sourceDestCheck", 
    #     network_interface_id: "eni-686ea200", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     network_interface_id: "eni-686ea200", 
    #     source_dest_check: {
    #       value: true, 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_network_interface_attribute({
    #     attribute: "description", # accepts description, groupSet, sourceDestCheck, attachment
    #     dry_run: false,
    #     network_interface_id: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.attachment.attach_time #=> Time
    #   resp.attachment.attachment_id #=> String
    #   resp.attachment.delete_on_termination #=> Boolean
    #   resp.attachment.device_index #=> Integer
    #   resp.attachment.instance_id #=> String
    #   resp.attachment.instance_owner_id #=> String
    #   resp.attachment.status #=> String, one of "attaching", "attached", "detaching", "detached"
    #   resp.description #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #   resp.groups #=> Array
    #   resp.groups[0].group_name #=> String
    #   resp.groups[0].group_id #=> String
    #   resp.network_interface_id #=> String
    #   resp.source_dest_check.value #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfaceAttribute AWS API Documentation
    #
    # @overload describe_network_interface_attribute(params = {})
    # @param [Hash] params ({})
    def describe_network_interface_attribute(params = {}, options = {})
      req = build_request(:describe_network_interface_attribute, params)
      req.send_request(options)
    end

    # Describes the permissions for your network interfaces.
    #
    # @option params [Array<String>] :network_interface_permission_ids
    #   One or more network interface permission IDs.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `network-interface-permission.network-interface-permission-id` - The
    #     ID of the permission.
    #
    #   * `network-interface-permission.network-interface-id` - The ID of the
    #     network interface.
    #
    #   * `network-interface-permission.aws-account-id` - The AWS account ID.
    #
    #   * `network-interface-permission.aws-service` - The AWS service.
    #
    #   * `network-interface-permission.permission` - The type of permission
    #     (`INSTANCE-ATTACH` \| `EIP-ASSOCIATE`).
    #
    # @option params [String] :next_token
    #   The token to request the next page of results.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. To retrieve
    #   the remaining results, make another call with the returned `NextToken`
    #   value. If this parameter is not specified, up to 50 results are
    #   returned by default.
    #
    # @return [Types::DescribeNetworkInterfacePermissionsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeNetworkInterfacePermissionsResult#network_interface_permissions #network_interface_permissions} => Array&lt;Types::NetworkInterfacePermission&gt;
    #   * {Types::DescribeNetworkInterfacePermissionsResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_network_interface_permissions({
    #     network_interface_permission_ids: ["String"],
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     next_token: "String",
    #     max_results: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.network_interface_permissions #=> Array
    #   resp.network_interface_permissions[0].network_interface_permission_id #=> String
    #   resp.network_interface_permissions[0].network_interface_id #=> String
    #   resp.network_interface_permissions[0].aws_account_id #=> String
    #   resp.network_interface_permissions[0].aws_service #=> String
    #   resp.network_interface_permissions[0].permission #=> String, one of "INSTANCE-ATTACH", "EIP-ASSOCIATE"
    #   resp.network_interface_permissions[0].permission_state.state #=> String, one of "pending", "granted", "revoking", "revoked"
    #   resp.network_interface_permissions[0].permission_state.status_message #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfacePermissions AWS API Documentation
    #
    # @overload describe_network_interface_permissions(params = {})
    # @param [Hash] params ({})
    def describe_network_interface_permissions(params = {}, options = {})
      req = build_request(:describe_network_interface_permissions, params)
      req.send_request(options)
    end

    # Describes one or more of your network interfaces.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `addresses.private-ip-address` - The private IPv4 addresses
    #     associated with the network interface.
    #
    #   * `addresses.primary` - Whether the private IPv4 address is the
    #     primary IP address associated with the network interface.
    #
    #   * `addresses.association.public-ip` - The association ID returned when
    #     the network interface was associated with the Elastic IP address
    #     (IPv4).
    #
    #   * `addresses.association.owner-id` - The owner ID of the addresses
    #     associated with the network interface.
    #
    #   * `association.association-id` - The association ID returned when the
    #     network interface was associated with an IPv4 address.
    #
    #   * `association.allocation-id` - The allocation ID returned when you
    #     allocated the Elastic IP address (IPv4) for your network interface.
    #
    #   * `association.ip-owner-id` - The owner of the Elastic IP address
    #     (IPv4) associated with the network interface.
    #
    #   * `association.public-ip` - The address of the Elastic IP address
    #     (IPv4) bound to the network interface.
    #
    #   * `association.public-dns-name` - The public DNS name for the network
    #     interface (IPv4).
    #
    #   * `attachment.attachment-id` - The ID of the interface attachment.
    #
    #   * `attachment.attach-time` - The time that the network interface was
    #     attached to an instance.
    #
    #   * `attachment.delete-on-termination` - Indicates whether the
    #     attachment is deleted when an instance is terminated.
    #
    #   * `attachment.device-index` - The device index to which the network
    #     interface is attached.
    #
    #   * `attachment.instance-id` - The ID of the instance to which the
    #     network interface is attached.
    #
    #   * `attachment.instance-owner-id` - The owner ID of the instance to
    #     which the network interface is attached.
    #
    #   * `attachment.nat-gateway-id` - The ID of the NAT gateway to which the
    #     network interface is attached.
    #
    #   * `attachment.status` - The status of the attachment (`attaching` \|
    #     `attached` \| `detaching` \| `detached`).
    #
    #   * `availability-zone` - The Availability Zone of the network
    #     interface.
    #
    #   * `description` - The description of the network interface.
    #
    #   * `group-id` - The ID of a security group associated with the network
    #     interface.
    #
    #   * `group-name` - The name of a security group associated with the
    #     network interface.
    #
    #   * `ipv6-addresses.ipv6-address` - An IPv6 address associated with the
    #     network interface.
    #
    #   * `mac-address` - The MAC address of the network interface.
    #
    #   * `network-interface-id` - The ID of the network interface.
    #
    #   * `owner-id` - The AWS account ID of the network interface owner.
    #
    #   * `private-ip-address` - The private IPv4 address or addresses of the
    #     network interface.
    #
    #   * `private-dns-name` - The private DNS name of the network interface
    #     (IPv4).
    #
    #   * `requester-id` - The ID of the entity that launched the instance on
    #     your behalf (for example, AWS Management Console, Auto Scaling, and
    #     so on).
    #
    #   * `requester-managed` - Indicates whether the network interface is
    #     being managed by an AWS service (for example, AWS Management
    #     Console, Auto Scaling, and so on).
    #
    #   * `source-dest-check` - Indicates whether the network interface
    #     performs source/destination checking. A value of `true` means
    #     checking is enabled, and `false` means checking is disabled. The
    #     value must be `false` for the network interface to perform network
    #     address translation (NAT) in your VPC.
    #
    #   * `status` - The status of the network interface. If the network
    #     interface is not attached to an instance, the status is `available`;
    #     if a network interface is attached to an instance the status is
    #     `in-use`.
    #
    #   * `subnet-id` - The ID of the subnet for the network interface.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `vpc-id` - The ID of the VPC for the network interface.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<String>] :network_interface_ids
    #   One or more network interface IDs.
    #
    #   Default: Describes all your network interfaces.
    #
    # @option params [String] :next_token
    #   The token to retrieve the next page of results.
    #
    # @option params [Integer] :max_results
    #   The maximum number of items to return for this request. The request
    #   returns a token that you can specify in a subsequent call to get the
    #   next set of results.
    #
    # @return [Types::DescribeNetworkInterfacesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeNetworkInterfacesResult#network_interfaces #network_interfaces} => Array&lt;Types::NetworkInterface&gt;
    #   * {Types::DescribeNetworkInterfacesResult#next_token #next_token} => String
    #
    #
    # @example Example: To describe a network interface
    #
    #   resp = client.describe_network_interfaces({
    #     network_interface_ids: [
    #       "eni-e5aa89a3", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     network_interfaces: [
    #       {
    #         association: {
    #           association_id: "eipassoc-0fbb766a", 
    #           ip_owner_id: "123456789012", 
    #           public_dns_name: "ec2-203-0-113-12.compute-1.amazonaws.com", 
    #           public_ip: "203.0.113.12", 
    #         }, 
    #         attachment: {
    #           attach_time: Time.parse("2013-11-30T23:36:42.000Z"), 
    #           attachment_id: "eni-attach-66c4350a", 
    #           delete_on_termination: false, 
    #           device_index: 1, 
    #           instance_id: "i-1234567890abcdef0", 
    #           instance_owner_id: "123456789012", 
    #           status: "attached", 
    #         }, 
    #         availability_zone: "us-east-1d", 
    #         description: "my network interface", 
    #         groups: [
    #           {
    #             group_id: "sg-8637d3e3", 
    #             group_name: "default", 
    #           }, 
    #         ], 
    #         mac_address: "02:2f:8f:b0:cf:75", 
    #         network_interface_id: "eni-e5aa89a3", 
    #         owner_id: "123456789012", 
    #         private_dns_name: "ip-10-0-1-17.ec2.internal", 
    #         private_ip_address: "10.0.1.17", 
    #         private_ip_addresses: [
    #           {
    #             association: {
    #               association_id: "eipassoc-0fbb766a", 
    #               ip_owner_id: "123456789012", 
    #               public_dns_name: "ec2-203-0-113-12.compute-1.amazonaws.com", 
    #               public_ip: "203.0.113.12", 
    #             }, 
    #             primary: true, 
    #             private_dns_name: "ip-10-0-1-17.ec2.internal", 
    #             private_ip_address: "10.0.1.17", 
    #           }, 
    #         ], 
    #         requester_managed: false, 
    #         source_dest_check: true, 
    #         status: "in-use", 
    #         subnet_id: "subnet-b61f49f0", 
    #         tag_set: [
    #         ], 
    #         vpc_id: "vpc-a01106c2", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_network_interfaces({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     dry_run: false,
    #     network_interface_ids: ["String"],
    #     next_token: "String",
    #     max_results: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.network_interfaces #=> Array
    #   resp.network_interfaces[0].association.allocation_id #=> String
    #   resp.network_interfaces[0].association.association_id #=> String
    #   resp.network_interfaces[0].association.ip_owner_id #=> String
    #   resp.network_interfaces[0].association.public_dns_name #=> String
    #   resp.network_interfaces[0].association.public_ip #=> String
    #   resp.network_interfaces[0].attachment.attach_time #=> Time
    #   resp.network_interfaces[0].attachment.attachment_id #=> String
    #   resp.network_interfaces[0].attachment.delete_on_termination #=> Boolean
    #   resp.network_interfaces[0].attachment.device_index #=> Integer
    #   resp.network_interfaces[0].attachment.instance_id #=> String
    #   resp.network_interfaces[0].attachment.instance_owner_id #=> String
    #   resp.network_interfaces[0].attachment.status #=> String, one of "attaching", "attached", "detaching", "detached"
    #   resp.network_interfaces[0].availability_zone #=> String
    #   resp.network_interfaces[0].description #=> String
    #   resp.network_interfaces[0].groups #=> Array
    #   resp.network_interfaces[0].groups[0].group_name #=> String
    #   resp.network_interfaces[0].groups[0].group_id #=> String
    #   resp.network_interfaces[0].interface_type #=> String, one of "interface", "natGateway", "efa"
    #   resp.network_interfaces[0].ipv_6_addresses #=> Array
    #   resp.network_interfaces[0].ipv_6_addresses[0].ipv_6_address #=> String
    #   resp.network_interfaces[0].mac_address #=> String
    #   resp.network_interfaces[0].network_interface_id #=> String
    #   resp.network_interfaces[0].owner_id #=> String
    #   resp.network_interfaces[0].private_dns_name #=> String
    #   resp.network_interfaces[0].private_ip_address #=> String
    #   resp.network_interfaces[0].private_ip_addresses #=> Array
    #   resp.network_interfaces[0].private_ip_addresses[0].association.allocation_id #=> String
    #   resp.network_interfaces[0].private_ip_addresses[0].association.association_id #=> String
    #   resp.network_interfaces[0].private_ip_addresses[0].association.ip_owner_id #=> String
    #   resp.network_interfaces[0].private_ip_addresses[0].association.public_dns_name #=> String
    #   resp.network_interfaces[0].private_ip_addresses[0].association.public_ip #=> String
    #   resp.network_interfaces[0].private_ip_addresses[0].primary #=> Boolean
    #   resp.network_interfaces[0].private_ip_addresses[0].private_dns_name #=> String
    #   resp.network_interfaces[0].private_ip_addresses[0].private_ip_address #=> String
    #   resp.network_interfaces[0].requester_id #=> String
    #   resp.network_interfaces[0].requester_managed #=> Boolean
    #   resp.network_interfaces[0].source_dest_check #=> Boolean
    #   resp.network_interfaces[0].status #=> String, one of "available", "associated", "attaching", "in-use", "detaching"
    #   resp.network_interfaces[0].subnet_id #=> String
    #   resp.network_interfaces[0].tag_set #=> Array
    #   resp.network_interfaces[0].tag_set[0].key #=> String
    #   resp.network_interfaces[0].tag_set[0].value #=> String
    #   resp.network_interfaces[0].vpc_id #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfaces AWS API Documentation
    #
    # @overload describe_network_interfaces(params = {})
    # @param [Hash] params ({})
    def describe_network_interfaces(params = {}, options = {})
      req = build_request(:describe_network_interfaces, params)
      req.send_request(options)
    end

    # Describes the specified placement groups or all of your placement
    # groups. For more information, see [Placement Groups][1] in the *Amazon
    # Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `group-name` - The name of the placement group.
    #
    #   * `state` - The state of the placement group (`pending` \| `available`
    #     \| `deleting` \| `deleted`).
    #
    #   * `strategy` - The strategy of the placement group (`cluster` \|
    #     `spread` \| `partition`).
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<String>] :group_names
    #   The names of the placement groups.
    #
    #   Default: Describes all your placement groups, or only those otherwise
    #   specified.
    #
    # @return [Types::DescribePlacementGroupsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribePlacementGroupsResult#placement_groups #placement_groups} => Array&lt;Types::PlacementGroup&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_placement_groups({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     dry_run: false,
    #     group_names: ["String"],
    #   })
    #
    # @example Response structure
    #
    #   resp.placement_groups #=> Array
    #   resp.placement_groups[0].group_name #=> String
    #   resp.placement_groups[0].state #=> String, one of "pending", "available", "deleting", "deleted"
    #   resp.placement_groups[0].strategy #=> String, one of "cluster", "spread", "partition"
    #   resp.placement_groups[0].partition_count #=> Integer
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePlacementGroups AWS API Documentation
    #
    # @overload describe_placement_groups(params = {})
    # @param [Hash] params ({})
    def describe_placement_groups(params = {}, options = {})
      req = build_request(:describe_placement_groups, params)
      req.send_request(options)
    end

    # Describes available AWS services in a prefix list format, which
    # includes the prefix list name and prefix list ID of the service and
    # the IP address range for the service. A prefix list ID is required for
    # creating an outbound security group rule that allows traffic from a
    # VPC to access an AWS service through a gateway VPC endpoint.
    # Currently, the services that support this action are Amazon S3 and
    # Amazon DynamoDB.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `prefix-list-id`\: The ID of a prefix list.
    #
    #   * `prefix-list-name`\: The name of a prefix list.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @option params [Array<String>] :prefix_list_ids
    #   One or more prefix list IDs.
    #
    # @return [Types::DescribePrefixListsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribePrefixListsResult#next_token #next_token} => String
    #   * {Types::DescribePrefixListsResult#prefix_lists #prefix_lists} => Array&lt;Types::PrefixList&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_prefix_lists({
    #     dry_run: false,
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #     next_token: "String",
    #     prefix_list_ids: ["String"],
    #   })
    #
    # @example Response structure
    #
    #   resp.next_token #=> String
    #   resp.prefix_lists #=> Array
    #   resp.prefix_lists[0].cidrs #=> Array
    #   resp.prefix_lists[0].cidrs[0] #=> String
    #   resp.prefix_lists[0].prefix_list_id #=> String
    #   resp.prefix_lists[0].prefix_list_name #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePrefixLists AWS API Documentation
    #
    # @overload describe_prefix_lists(params = {})
    # @param [Hash] params ({})
    def describe_prefix_lists(params = {}, options = {})
      req = build_request(:describe_prefix_lists, params)
      req.send_request(options)
    end

    # Describes the ID format settings for the root user and all IAM roles
    # and IAM users that have explicitly specified a longer ID (17-character
    # ID) preference.
    #
    # By default, all IAM roles and IAM users default to the same ID
    # settings as the root user, unless they explicitly override the
    # settings. This request is useful for identifying those IAM users and
    # IAM roles that have overridden the default ID settings.
    #
    # The following resource types support longer IDs: `bundle` \|
    # `conversion-task` \| `customer-gateway` \| `dhcp-options` \|
    # `elastic-ip-allocation` \| `elastic-ip-association` \| `export-task`
    # \| `flow-log` \| `image` \| `import-task` \| `instance` \|
    # `internet-gateway` \| `network-acl` \| `network-acl-association` \|
    # `network-interface` \| `network-interface-attachment` \| `prefix-list`
    # \| `reservation` \| `route-table` \| `route-table-association` \|
    # `security-group` \| `snapshot` \| `subnet` \|
    # `subnet-cidr-block-association` \| `volume` \| `vpc` \|
    # `vpc-cidr-block-association` \| `vpc-endpoint` \|
    # `vpc-peering-connection` \| `vpn-connection` \| `vpn-gateway`.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<String>] :resources
    #   The type of resource: `bundle` \| `conversion-task` \|
    #   `customer-gateway` \| `dhcp-options` \| `elastic-ip-allocation` \|
    #   `elastic-ip-association` \| `export-task` \| `flow-log` \| `image` \|
    #   `import-task` \| `instance` \| `internet-gateway` \| `network-acl` \|
    #   `network-acl-association` \| `network-interface` \|
    #   `network-interface-attachment` \| `prefix-list` \| `reservation` \|
    #   `route-table` \| `route-table-association` \| `security-group` \|
    #   `snapshot` \| `subnet` \| `subnet-cidr-block-association` \| `volume`
    #   \| `vpc` \| `vpc-cidr-block-association` \| `vpc-endpoint` \|
    #   `vpc-peering-connection` \| `vpn-connection` \| `vpn-gateway`
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. To retrieve
    #   the remaining results, make another call with the returned NextToken
    #   value.
    #
    # @option params [String] :next_token
    #   The token to request the next page of results.
    #
    # @return [Types::DescribePrincipalIdFormatResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribePrincipalIdFormatResult#principals #principals} => Array&lt;Types::PrincipalIdFormat&gt;
    #   * {Types::DescribePrincipalIdFormatResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_principal_id_format({
    #     dry_run: false,
    #     resources: ["String"],
    #     max_results: 1,
    #     next_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.principals #=> Array
    #   resp.principals[0].arn #=> String
    #   resp.principals[0].statuses #=> Array
    #   resp.principals[0].statuses[0].deadline #=> Time
    #   resp.principals[0].statuses[0].resource #=> String
    #   resp.principals[0].statuses[0].use_long_ids #=> Boolean
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePrincipalIdFormat AWS API Documentation
    #
    # @overload describe_principal_id_format(params = {})
    # @param [Hash] params ({})
    def describe_principal_id_format(params = {}, options = {})
      req = build_request(:describe_principal_id_format, params)
      req.send_request(options)
    end

    # Describes the specified IPv4 address pools.
    #
    # @option params [Array<String>] :pool_ids
    #   The IDs of the address pools.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @return [Types::DescribePublicIpv4PoolsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribePublicIpv4PoolsResult#public_ipv_4_pools #public_ipv_4_pools} => Array&lt;Types::PublicIpv4Pool&gt;
    #   * {Types::DescribePublicIpv4PoolsResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_public_ipv_4_pools({
    #     pool_ids: ["String"],
    #     next_token: "NextToken",
    #     max_results: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.public_ipv_4_pools #=> Array
    #   resp.public_ipv_4_pools[0].pool_id #=> String
    #   resp.public_ipv_4_pools[0].description #=> String
    #   resp.public_ipv_4_pools[0].pool_address_ranges #=> Array
    #   resp.public_ipv_4_pools[0].pool_address_ranges[0].first_address #=> String
    #   resp.public_ipv_4_pools[0].pool_address_ranges[0].last_address #=> String
    #   resp.public_ipv_4_pools[0].pool_address_ranges[0].address_count #=> Integer
    #   resp.public_ipv_4_pools[0].pool_address_ranges[0].available_address_count #=> Integer
    #   resp.public_ipv_4_pools[0].total_address_count #=> Integer
    #   resp.public_ipv_4_pools[0].total_available_address_count #=> Integer
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePublicIpv4Pools AWS API Documentation
    #
    # @overload describe_public_ipv_4_pools(params = {})
    # @param [Hash] params ({})
    def describe_public_ipv_4_pools(params = {}, options = {})
      req = build_request(:describe_public_ipv_4_pools, params)
      req.send_request(options)
    end

    # Describes the Regions that are enabled for your account, or all
    # Regions.
    #
    # For a list of the Regions supported by Amazon EC2, see [ Regions and
    # Endpoints][1].
    #
    # For information about enabling and disabling Regions for your account,
    # see [Managing AWS Regions][2] in the *AWS General Reference*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/general/latest/gr/rande.html#ec2_region
    # [2]: https://docs.aws.amazon.com/general/latest/gr/rande-manage.html
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `endpoint` - The endpoint of the Region (for example,
    #     `ec2.us-east-1.amazonaws.com`).
    #
    #   * `opt-in-status` - The opt-in status of the Region
    #     (`opt-in-not-required` \| `opted-in` \| `not-opted-in`).
    #
    #   * `region-name` - The name of the Region (for example, `us-east-1`).
    #
    # @option params [Array<String>] :region_names
    #   The names of the Regions. You can specify any Regions, whether they
    #   are enabled and disabled for your account.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Boolean] :all_regions
    #   Indicates whether to display all Regions, including Regions that are
    #   disabled for your account.
    #
    # @return [Types::DescribeRegionsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeRegionsResult#regions #regions} => Array&lt;Types::Region&gt;
    #
    #
    # @example Example: To describe your regions
    #
    #   # This example describes all the regions that are available to you.
    #
    #   resp = client.describe_regions({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     regions: [
    #       {
    #         endpoint: "ec2.ap-south-1.amazonaws.com", 
    #         region_name: "ap-south-1", 
    #       }, 
    #       {
    #         endpoint: "ec2.eu-west-1.amazonaws.com", 
    #         region_name: "eu-west-1", 
    #       }, 
    #       {
    #         endpoint: "ec2.ap-southeast-1.amazonaws.com", 
    #         region_name: "ap-southeast-1", 
    #       }, 
    #       {
    #         endpoint: "ec2.ap-southeast-2.amazonaws.com", 
    #         region_name: "ap-southeast-2", 
    #       }, 
    #       {
    #         endpoint: "ec2.eu-central-1.amazonaws.com", 
    #         region_name: "eu-central-1", 
    #       }, 
    #       {
    #         endpoint: "ec2.ap-northeast-2.amazonaws.com", 
    #         region_name: "ap-northeast-2", 
    #       }, 
    #       {
    #         endpoint: "ec2.ap-northeast-1.amazonaws.com", 
    #         region_name: "ap-northeast-1", 
    #       }, 
    #       {
    #         endpoint: "ec2.us-east-1.amazonaws.com", 
    #         region_name: "us-east-1", 
    #       }, 
    #       {
    #         endpoint: "ec2.sa-east-1.amazonaws.com", 
    #         region_name: "sa-east-1", 
    #       }, 
    #       {
    #         endpoint: "ec2.us-west-1.amazonaws.com", 
    #         region_name: "us-west-1", 
    #       }, 
    #       {
    #         endpoint: "ec2.us-west-2.amazonaws.com", 
    #         region_name: "us-west-2", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_regions({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     region_names: ["String"],
    #     dry_run: false,
    #     all_regions: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.regions #=> Array
    #   resp.regions[0].endpoint #=> String
    #   resp.regions[0].region_name #=> String
    #   resp.regions[0].opt_in_status #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeRegions AWS API Documentation
    #
    # @overload describe_regions(params = {})
    # @param [Hash] params ({})
    def describe_regions(params = {}, options = {})
      req = build_request(:describe_regions, params)
      req.send_request(options)
    end

    # Describes one or more of the Reserved Instances that you purchased.
    #
    # For more information about Reserved Instances, see [Reserved
    # Instances][1] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `availability-zone` - The Availability Zone where the Reserved
    #     Instance can be used.
    #
    #   * `duration` - The duration of the Reserved Instance (one year or
    #     three years), in seconds (`31536000` \| `94608000`).
    #
    #   * `end` - The time when the Reserved Instance expires (for example,
    #     2015-08-07T11:54:42.000Z).
    #
    #   * `fixed-price` - The purchase price of the Reserved Instance (for
    #     example, 9800.0).
    #
    #   * `instance-type` - The instance type that is covered by the
    #     reservation.
    #
    #   * `scope` - The scope of the Reserved Instance (`Region` or
    #     `Availability Zone`).
    #
    #   * `product-description` - The Reserved Instance product platform
    #     description. Instances that include `(Amazon VPC)` in the product
    #     platform description will only be displayed to EC2-Classic account
    #     holders and are for use with Amazon VPC (`Linux/UNIX` \| `Linux/UNIX
    #     (Amazon VPC)` \| `SUSE Linux` \| `SUSE Linux (Amazon VPC)` \| `Red
    #     Hat Enterprise Linux` \| `Red Hat Enterprise Linux (Amazon VPC)` \|
    #     `Windows` \| `Windows (Amazon VPC)` \| `Windows with SQL Server
    #     Standard` \| `Windows with SQL Server Standard (Amazon VPC)` \|
    #     `Windows with SQL Server Web` \| `Windows with SQL Server Web
    #     (Amazon VPC)` \| `Windows with SQL Server Enterprise` \| `Windows
    #     with SQL Server Enterprise (Amazon VPC)`).
    #
    #   * `reserved-instances-id` - The ID of the Reserved Instance.
    #
    #   * `start` - The time at which the Reserved Instance purchase request
    #     was placed (for example, 2014-08-07T11:54:42.000Z).
    #
    #   * `state` - The state of the Reserved Instance (`payment-pending` \|
    #     `active` \| `payment-failed` \| `retired`).
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `usage-price` - The usage price of the Reserved Instance, per hour
    #     (for example, 0.84).
    #
    # @option params [String] :offering_class
    #   Describes whether the Reserved Instance is Standard or Convertible.
    #
    # @option params [Array<String>] :reserved_instances_ids
    #   One or more Reserved Instance IDs.
    #
    #   Default: Describes all your Reserved Instances, or only those
    #   otherwise specified.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :offering_type
    #   The Reserved Instance offering type. If you are using tools that
    #   predate the 2011-11-01 API version, you only have access to the
    #   `Medium Utilization` Reserved Instance offering type.
    #
    # @return [Types::DescribeReservedInstancesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeReservedInstancesResult#reserved_instances #reserved_instances} => Array&lt;Types::ReservedInstances&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_reserved_instances({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     offering_class: "standard", # accepts standard, convertible
    #     reserved_instances_ids: ["String"],
    #     dry_run: false,
    #     offering_type: "Heavy Utilization", # accepts Heavy Utilization, Medium Utilization, Light Utilization, No Upfront, Partial Upfront, All Upfront
    #   })
    #
    # @example Response structure
    #
    #   resp.reserved_instances #=> Array
    #   resp.reserved_instances[0].availability_zone #=> String
    #   resp.reserved_instances[0].duration #=> Integer
    #   resp.reserved_instances[0].end #=> Time
    #   resp.reserved_instances[0].fixed_price #=> Float
    #   resp.reserved_instances[0].instance_count #=> Integer
    #   resp.reserved_instances[0].instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.18xlarge", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge"
    #   resp.reserved_instances[0].product_description #=> String, one of "Linux/UNIX", "Linux/UNIX (Amazon VPC)", "Windows", "Windows (Amazon VPC)"
    #   resp.reserved_instances[0].reserved_instances_id #=> String
    #   resp.reserved_instances[0].start #=> Time
    #   resp.reserved_instances[0].state #=> String, one of "payment-pending", "active", "payment-failed", "retired"
    #   resp.reserved_instances[0].usage_price #=> Float
    #   resp.reserved_instances[0].currency_code #=> String, one of "USD"
    #   resp.reserved_instances[0].instance_tenancy #=> String, one of "default", "dedicated", "host"
    #   resp.reserved_instances[0].offering_class #=> String, one of "standard", "convertible"
    #   resp.reserved_instances[0].offering_type #=> String, one of "Heavy Utilization", "Medium Utilization", "Light Utilization", "No Upfront", "Partial Upfront", "All Upfront"
    #   resp.reserved_instances[0].recurring_charges #=> Array
    #   resp.reserved_instances[0].recurring_charges[0].amount #=> Float
    #   resp.reserved_instances[0].recurring_charges[0].frequency #=> String, one of "Hourly"
    #   resp.reserved_instances[0].scope #=> String, one of "Availability Zone", "Region"
    #   resp.reserved_instances[0].tags #=> Array
    #   resp.reserved_instances[0].tags[0].key #=> String
    #   resp.reserved_instances[0].tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstances AWS API Documentation
    #
    # @overload describe_reserved_instances(params = {})
    # @param [Hash] params ({})
    def describe_reserved_instances(params = {}, options = {})
      req = build_request(:describe_reserved_instances, params)
      req.send_request(options)
    end

    # Describes your account's Reserved Instance listings in the Reserved
    # Instance Marketplace.
    #
    # The Reserved Instance Marketplace matches sellers who want to resell
    # Reserved Instance capacity that they no longer need with buyers who
    # want to purchase additional capacity. Reserved Instances bought and
    # sold through the Reserved Instance Marketplace work like any other
    # Reserved Instances.
    #
    # As a seller, you choose to list some or all of your Reserved
    # Instances, and you specify the upfront price to receive for them. Your
    # Reserved Instances are then listed in the Reserved Instance
    # Marketplace and are available for purchase.
    #
    # As a buyer, you specify the configuration of the Reserved Instance to
    # purchase, and the Marketplace matches what you're searching for with
    # what's available. The Marketplace first sells the lowest priced
    # Reserved Instances to you, and continues to sell available Reserved
    # Instance listings to you until your demand is met. You are charged
    # based on the total price of all of the listings that you purchase.
    #
    # For more information, see [Reserved Instance Marketplace][1] in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `reserved-instances-id` - The ID of the Reserved Instances.
    #
    #   * `reserved-instances-listing-id` - The ID of the Reserved Instances
    #     listing.
    #
    #   * `status` - The status of the Reserved Instance listing (`pending` \|
    #     `active` \| `cancelled` \| `closed`).
    #
    #   * `status-message` - The reason for the status.
    #
    # @option params [String] :reserved_instances_id
    #   One or more Reserved Instance IDs.
    #
    # @option params [String] :reserved_instances_listing_id
    #   One or more Reserved Instance listing IDs.
    #
    # @return [Types::DescribeReservedInstancesListingsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeReservedInstancesListingsResult#reserved_instances_listings #reserved_instances_listings} => Array&lt;Types::ReservedInstancesListing&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_reserved_instances_listings({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     reserved_instances_id: "String",
    #     reserved_instances_listing_id: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.reserved_instances_listings #=> Array
    #   resp.reserved_instances_listings[0].client_token #=> String
    #   resp.reserved_instances_listings[0].create_date #=> Time
    #   resp.reserved_instances_listings[0].instance_counts #=> Array
    #   resp.reserved_instances_listings[0].instance_counts[0].instance_count #=> Integer
    #   resp.reserved_instances_listings[0].instance_counts[0].state #=> String, one of "available", "sold", "cancelled", "pending"
    #   resp.reserved_instances_listings[0].price_schedules #=> Array
    #   resp.reserved_instances_listings[0].price_schedules[0].active #=> Boolean
    #   resp.reserved_instances_listings[0].price_schedules[0].currency_code #=> String, one of "USD"
    #   resp.reserved_instances_listings[0].price_schedules[0].price #=> Float
    #   resp.reserved_instances_listings[0].price_schedules[0].term #=> Integer
    #   resp.reserved_instances_listings[0].reserved_instances_id #=> String
    #   resp.reserved_instances_listings[0].reserved_instances_listing_id #=> String
    #   resp.reserved_instances_listings[0].status #=> String, one of "active", "pending", "cancelled", "closed"
    #   resp.reserved_instances_listings[0].status_message #=> String
    #   resp.reserved_instances_listings[0].tags #=> Array
    #   resp.reserved_instances_listings[0].tags[0].key #=> String
    #   resp.reserved_instances_listings[0].tags[0].value #=> String
    #   resp.reserved_instances_listings[0].update_date #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesListings AWS API Documentation
    #
    # @overload describe_reserved_instances_listings(params = {})
    # @param [Hash] params ({})
    def describe_reserved_instances_listings(params = {}, options = {})
      req = build_request(:describe_reserved_instances_listings, params)
      req.send_request(options)
    end

    # Describes the modifications made to your Reserved Instances. If no
    # parameter is specified, information about all your Reserved Instances
    # modification requests is returned. If a modification ID is specified,
    # only information about the specific modification is returned.
    #
    # For more information, see [Modifying Reserved Instances][1] in the
    # Amazon Elastic Compute Cloud User Guide.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `client-token` - The idempotency token for the modification request.
    #
    #   * `create-date` - The time when the modification request was created.
    #
    #   * `effective-date` - The time when the modification becomes effective.
    #
    #   * `modification-result.reserved-instances-id` - The ID for the
    #     Reserved Instances created as part of the modification request. This
    #     ID is only available when the status of the modification is
    #     `fulfilled`.
    #
    #   * `modification-result.target-configuration.availability-zone` - The
    #     Availability Zone for the new Reserved Instances.
    #
    #   * `modification-result.target-configuration.instance-count ` - The
    #     number of new Reserved Instances.
    #
    #   * `modification-result.target-configuration.instance-type` - The
    #     instance type of the new Reserved Instances.
    #
    #   * `modification-result.target-configuration.platform` - The network
    #     platform of the new Reserved Instances (`EC2-Classic` \| `EC2-VPC`).
    #
    #   * `reserved-instances-id` - The ID of the Reserved Instances modified.
    #
    #   * `reserved-instances-modification-id` - The ID of the modification
    #     request.
    #
    #   * `status` - The status of the Reserved Instances modification request
    #     (`processing` \| `fulfilled` \| `failed`).
    #
    #   * `status-message` - The reason for the status.
    #
    #   * `update-date` - The time when the modification request was last
    #     updated.
    #
    # @option params [Array<String>] :reserved_instances_modification_ids
    #   IDs for the submitted modification request.
    #
    # @option params [String] :next_token
    #   The token to retrieve the next page of results.
    #
    # @return [Types::DescribeReservedInstancesModificationsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeReservedInstancesModificationsResult#next_token #next_token} => String
    #   * {Types::DescribeReservedInstancesModificationsResult#reserved_instances_modifications #reserved_instances_modifications} => Array&lt;Types::ReservedInstancesModification&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_reserved_instances_modifications({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     reserved_instances_modification_ids: ["String"],
    #     next_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.next_token #=> String
    #   resp.reserved_instances_modifications #=> Array
    #   resp.reserved_instances_modifications[0].client_token #=> String
    #   resp.reserved_instances_modifications[0].create_date #=> Time
    #   resp.reserved_instances_modifications[0].effective_date #=> Time
    #   resp.reserved_instances_modifications[0].modification_results #=> Array
    #   resp.reserved_instances_modifications[0].modification_results[0].reserved_instances_id #=> String
    #   resp.reserved_instances_modifications[0].modification_results[0].target_configuration.availability_zone #=> String
    #   resp.reserved_instances_modifications[0].modification_results[0].target_configuration.instance_count #=> Integer
    #   resp.reserved_instances_modifications[0].modification_results[0].target_configuration.instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.18xlarge", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge"
    #   resp.reserved_instances_modifications[0].modification_results[0].target_configuration.platform #=> String
    #   resp.reserved_instances_modifications[0].modification_results[0].target_configuration.scope #=> String, one of "Availability Zone", "Region"
    #   resp.reserved_instances_modifications[0].reserved_instances_ids #=> Array
    #   resp.reserved_instances_modifications[0].reserved_instances_ids[0].reserved_instances_id #=> String
    #   resp.reserved_instances_modifications[0].reserved_instances_modification_id #=> String
    #   resp.reserved_instances_modifications[0].status #=> String
    #   resp.reserved_instances_modifications[0].status_message #=> String
    #   resp.reserved_instances_modifications[0].update_date #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesModifications AWS API Documentation
    #
    # @overload describe_reserved_instances_modifications(params = {})
    # @param [Hash] params ({})
    def describe_reserved_instances_modifications(params = {}, options = {})
      req = build_request(:describe_reserved_instances_modifications, params)
      req.send_request(options)
    end

    # Describes Reserved Instance offerings that are available for purchase.
    # With Reserved Instances, you purchase the right to launch instances
    # for a period of time. During that time period, you do not receive
    # insufficient capacity errors, and you pay a lower usage rate than the
    # rate charged for On-Demand instances for the actual time used.
    #
    # If you have listed your own Reserved Instances for sale in the
    # Reserved Instance Marketplace, they will be excluded from these
    # results. This is to ensure that you do not purchase your own Reserved
    # Instances.
    #
    # For more information, see [Reserved Instance Marketplace][1] in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html
    #
    # @option params [String] :availability_zone
    #   The Availability Zone in which the Reserved Instance can be used.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `availability-zone` - The Availability Zone where the Reserved
    #     Instance can be used.
    #
    #   * `duration` - The duration of the Reserved Instance (for example, one
    #     year or three years), in seconds (`31536000` \| `94608000`).
    #
    #   * `fixed-price` - The purchase price of the Reserved Instance (for
    #     example, 9800.0).
    #
    #   * `instance-type` - The instance type that is covered by the
    #     reservation.
    #
    #   * `marketplace` - Set to `true` to show only Reserved Instance
    #     Marketplace offerings. When this filter is not used, which is the
    #     default behavior, all offerings from both AWS and the Reserved
    #     Instance Marketplace are listed.
    #
    #   * `product-description` - The Reserved Instance product platform
    #     description. Instances that include `(Amazon VPC)` in the product
    #     platform description will only be displayed to EC2-Classic account
    #     holders and are for use with Amazon VPC. (`Linux/UNIX` \|
    #     `Linux/UNIX (Amazon VPC)` \| `SUSE Linux` \| `SUSE Linux (Amazon
    #     VPC)` \| `Red Hat Enterprise Linux` \| `Red Hat Enterprise Linux
    #     (Amazon VPC)` \| `Windows` \| `Windows (Amazon VPC)` \| `Windows
    #     with SQL Server Standard` \| `Windows with SQL Server Standard
    #     (Amazon VPC)` \| `Windows with SQL Server Web` \| ` Windows with SQL
    #     Server Web (Amazon VPC)` \| `Windows with SQL Server Enterprise` \|
    #     `Windows with SQL Server Enterprise (Amazon VPC)`)
    #
    #   * `reserved-instances-offering-id` - The Reserved Instances offering
    #     ID.
    #
    #   * `scope` - The scope of the Reserved Instance (`Availability Zone` or
    #     `Region`).
    #
    #   * `usage-price` - The usage price of the Reserved Instance, per hour
    #     (for example, 0.84).
    #
    # @option params [Boolean] :include_marketplace
    #   Include Reserved Instance Marketplace offerings in the response.
    #
    # @option params [String] :instance_type
    #   The instance type that the reservation will cover (for example,
    #   `m1.small`). For more information, see [Instance Types][1] in the
    #   *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html
    #
    # @option params [Integer] :max_duration
    #   The maximum duration (in seconds) to filter when searching for
    #   offerings.
    #
    #   Default: 94608000 (3 years)
    #
    # @option params [Integer] :max_instance_count
    #   The maximum number of instances to filter when searching for
    #   offerings.
    #
    #   Default: 20
    #
    # @option params [Integer] :min_duration
    #   The minimum duration (in seconds) to filter when searching for
    #   offerings.
    #
    #   Default: 2592000 (1 month)
    #
    # @option params [String] :offering_class
    #   The offering class of the Reserved Instance. Can be `standard` or
    #   `convertible`.
    #
    # @option params [String] :product_description
    #   The Reserved Instance product platform description. Instances that
    #   include `(Amazon VPC)` in the description are for use with Amazon VPC.
    #
    # @option params [Array<String>] :reserved_instances_offering_ids
    #   One or more Reserved Instances offering IDs.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :instance_tenancy
    #   The tenancy of the instances covered by the reservation. A Reserved
    #   Instance with a tenancy of `dedicated` is applied to instances that
    #   run in a VPC on single-tenant hardware (i.e., Dedicated Instances).
    #
    #   **Important:** The `host` value cannot be used with this parameter.
    #   Use the `default` or `dedicated` values only.
    #
    #   Default: `default`
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results of the initial request can be seen by
    #   sending another request with the returned `NextToken` value. The
    #   maximum is 100.
    #
    #   Default: 100
    #
    # @option params [String] :next_token
    #   The token to retrieve the next page of results.
    #
    # @option params [String] :offering_type
    #   The Reserved Instance offering type. If you are using tools that
    #   predate the 2011-11-01 API version, you only have access to the
    #   `Medium Utilization` Reserved Instance offering type.
    #
    # @return [Types::DescribeReservedInstancesOfferingsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeReservedInstancesOfferingsResult#reserved_instances_offerings #reserved_instances_offerings} => Array&lt;Types::ReservedInstancesOffering&gt;
    #   * {Types::DescribeReservedInstancesOfferingsResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_reserved_instances_offerings({
    #     availability_zone: "String",
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     include_marketplace: false,
    #     instance_type: "t1.micro", # accepts t1.micro, t2.nano, t2.micro, t2.small, t2.medium, t2.large, t2.xlarge, t2.2xlarge, t3.nano, t3.micro, t3.small, t3.medium, t3.large, t3.xlarge, t3.2xlarge, t3a.nano, t3a.micro, t3a.small, t3a.medium, t3a.large, t3a.xlarge, t3a.2xlarge, m1.small, m1.medium, m1.large, m1.xlarge, m3.medium, m3.large, m3.xlarge, m3.2xlarge, m4.large, m4.xlarge, m4.2xlarge, m4.4xlarge, m4.10xlarge, m4.16xlarge, m2.xlarge, m2.2xlarge, m2.4xlarge, cr1.8xlarge, r3.large, r3.xlarge, r3.2xlarge, r3.4xlarge, r3.8xlarge, r4.large, r4.xlarge, r4.2xlarge, r4.4xlarge, r4.8xlarge, r4.16xlarge, r5.large, r5.xlarge, r5.2xlarge, r5.4xlarge, r5.8xlarge, r5.12xlarge, r5.16xlarge, r5.24xlarge, r5.metal, r5a.large, r5a.xlarge, r5a.2xlarge, r5a.4xlarge, r5a.8xlarge, r5a.12xlarge, r5a.16xlarge, r5a.24xlarge, r5d.large, r5d.xlarge, r5d.2xlarge, r5d.4xlarge, r5d.8xlarge, r5d.12xlarge, r5d.16xlarge, r5d.24xlarge, r5d.metal, r5ad.large, r5ad.xlarge, r5ad.2xlarge, r5ad.4xlarge, r5ad.8xlarge, r5ad.12xlarge, r5ad.16xlarge, r5ad.24xlarge, x1.16xlarge, x1.32xlarge, x1e.xlarge, x1e.2xlarge, x1e.4xlarge, x1e.8xlarge, x1e.16xlarge, x1e.32xlarge, i2.xlarge, i2.2xlarge, i2.4xlarge, i2.8xlarge, i3.large, i3.xlarge, i3.2xlarge, i3.4xlarge, i3.8xlarge, i3.16xlarge, i3.metal, i3en.large, i3en.xlarge, i3en.2xlarge, i3en.3xlarge, i3en.6xlarge, i3en.12xlarge, i3en.24xlarge, i3en.metal, hi1.4xlarge, hs1.8xlarge, c1.medium, c1.xlarge, c3.large, c3.xlarge, c3.2xlarge, c3.4xlarge, c3.8xlarge, c4.large, c4.xlarge, c4.2xlarge, c4.4xlarge, c4.8xlarge, c5.large, c5.xlarge, c5.2xlarge, c5.4xlarge, c5.9xlarge, c5.12xlarge, c5.18xlarge, c5.24xlarge, c5.metal, c5d.large, c5d.xlarge, c5d.2xlarge, c5d.4xlarge, c5d.9xlarge, c5d.18xlarge, c5n.large, c5n.xlarge, c5n.2xlarge, c5n.4xlarge, c5n.9xlarge, c5n.18xlarge, cc1.4xlarge, cc2.8xlarge, g2.2xlarge, g2.8xlarge, g3.4xlarge, g3.8xlarge, g3.16xlarge, g3s.xlarge, cg1.4xlarge, p2.xlarge, p2.8xlarge, p2.16xlarge, p3.2xlarge, p3.8xlarge, p3.16xlarge, p3dn.24xlarge, d2.xlarge, d2.2xlarge, d2.4xlarge, d2.8xlarge, f1.2xlarge, f1.4xlarge, f1.16xlarge, m5.large, m5.xlarge, m5.2xlarge, m5.4xlarge, m5.8xlarge, m5.12xlarge, m5.16xlarge, m5.24xlarge, m5.metal, m5a.large, m5a.xlarge, m5a.2xlarge, m5a.4xlarge, m5a.8xlarge, m5a.12xlarge, m5a.16xlarge, m5a.24xlarge, m5d.large, m5d.xlarge, m5d.2xlarge, m5d.4xlarge, m5d.8xlarge, m5d.12xlarge, m5d.16xlarge, m5d.24xlarge, m5d.metal, m5ad.large, m5ad.xlarge, m5ad.2xlarge, m5ad.4xlarge, m5ad.8xlarge, m5ad.12xlarge, m5ad.16xlarge, m5ad.24xlarge, h1.2xlarge, h1.4xlarge, h1.8xlarge, h1.16xlarge, z1d.large, z1d.xlarge, z1d.2xlarge, z1d.3xlarge, z1d.6xlarge, z1d.12xlarge, z1d.metal, u-6tb1.metal, u-9tb1.metal, u-12tb1.metal, a1.medium, a1.large, a1.xlarge, a1.2xlarge, a1.4xlarge
    #     max_duration: 1,
    #     max_instance_count: 1,
    #     min_duration: 1,
    #     offering_class: "standard", # accepts standard, convertible
    #     product_description: "Linux/UNIX", # accepts Linux/UNIX, Linux/UNIX (Amazon VPC), Windows, Windows (Amazon VPC)
    #     reserved_instances_offering_ids: ["String"],
    #     dry_run: false,
    #     instance_tenancy: "default", # accepts default, dedicated, host
    #     max_results: 1,
    #     next_token: "String",
    #     offering_type: "Heavy Utilization", # accepts Heavy Utilization, Medium Utilization, Light Utilization, No Upfront, Partial Upfront, All Upfront
    #   })
    #
    # @example Response structure
    #
    #   resp.reserved_instances_offerings #=> Array
    #   resp.reserved_instances_offerings[0].availability_zone #=> String
    #   resp.reserved_instances_offerings[0].duration #=> Integer
    #   resp.reserved_instances_offerings[0].fixed_price #=> Float
    #   resp.reserved_instances_offerings[0].instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.18xlarge", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge"
    #   resp.reserved_instances_offerings[0].product_description #=> String, one of "Linux/UNIX", "Linux/UNIX (Amazon VPC)", "Windows", "Windows (Amazon VPC)"
    #   resp.reserved_instances_offerings[0].reserved_instances_offering_id #=> String
    #   resp.reserved_instances_offerings[0].usage_price #=> Float
    #   resp.reserved_instances_offerings[0].currency_code #=> String, one of "USD"
    #   resp.reserved_instances_offerings[0].instance_tenancy #=> String, one of "default", "dedicated", "host"
    #   resp.reserved_instances_offerings[0].marketplace #=> Boolean
    #   resp.reserved_instances_offerings[0].offering_class #=> String, one of "standard", "convertible"
    #   resp.reserved_instances_offerings[0].offering_type #=> String, one of "Heavy Utilization", "Medium Utilization", "Light Utilization", "No Upfront", "Partial Upfront", "All Upfront"
    #   resp.reserved_instances_offerings[0].pricing_details #=> Array
    #   resp.reserved_instances_offerings[0].pricing_details[0].count #=> Integer
    #   resp.reserved_instances_offerings[0].pricing_details[0].price #=> Float
    #   resp.reserved_instances_offerings[0].recurring_charges #=> Array
    #   resp.reserved_instances_offerings[0].recurring_charges[0].amount #=> Float
    #   resp.reserved_instances_offerings[0].recurring_charges[0].frequency #=> String, one of "Hourly"
    #   resp.reserved_instances_offerings[0].scope #=> String, one of "Availability Zone", "Region"
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesOfferings AWS API Documentation
    #
    # @overload describe_reserved_instances_offerings(params = {})
    # @param [Hash] params ({})
    def describe_reserved_instances_offerings(params = {}, options = {})
      req = build_request(:describe_reserved_instances_offerings, params)
      req.send_request(options)
    end

    # Describes one or more of your route tables.
    #
    # Each subnet in your VPC must be associated with a route table. If a
    # subnet is not explicitly associated with any route table, it is
    # implicitly associated with the main route table. This command does not
    # return the subnet ID for implicit associations.
    #
    # For more information, see [Route Tables][1] in the *Amazon Virtual
    # Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `association.route-table-association-id` - The ID of an association
    #     ID for the route table.
    #
    #   * `association.route-table-id` - The ID of the route table involved in
    #     the association.
    #
    #   * `association.subnet-id` - The ID of the subnet involved in the
    #     association.
    #
    #   * `association.main` - Indicates whether the route table is the main
    #     route table for the VPC (`true` \| `false`). Route tables that do
    #     not have an association ID are not returned in the response.
    #
    #   * `owner-id` - The ID of the AWS account that owns the route table.
    #
    #   * `route-table-id` - The ID of the route table.
    #
    #   * `route.destination-cidr-block` - The IPv4 CIDR range specified in a
    #     route in the table.
    #
    #   * `route.destination-ipv6-cidr-block` - The IPv6 CIDR range specified
    #     in a route in the route table.
    #
    #   * `route.destination-prefix-list-id` - The ID (prefix) of the AWS
    #     service specified in a route in the table.
    #
    #   * `route.egress-only-internet-gateway-id` - The ID of an egress-only
    #     Internet gateway specified in a route in the route table.
    #
    #   * `route.gateway-id` - The ID of a gateway specified in a route in the
    #     table.
    #
    #   * `route.instance-id` - The ID of an instance specified in a route in
    #     the table.
    #
    #   * `route.nat-gateway-id` - The ID of a NAT gateway.
    #
    #   * `route.transit-gateway-id` - The ID of a transit gateway.
    #
    #   * `route.origin` - Describes how the route was created.
    #     `CreateRouteTable` indicates that the route was automatically
    #     created when the route table was created; `CreateRoute` indicates
    #     that the route was manually added to the route table;
    #     `EnableVgwRoutePropagation` indicates that the route was propagated
    #     by route propagation.
    #
    #   * `route.state` - The state of a route in the route table (`active` \|
    #     `blackhole`). The blackhole state indicates that the route's target
    #     isn't available (for example, the specified gateway isn't attached
    #     to the VPC, the specified NAT instance has been terminated, and so
    #     on).
    #
    #   * `route.vpc-peering-connection-id` - The ID of a VPC peering
    #     connection specified in a route in the table.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `transit-gateway-id` - The ID of a transit gateway.
    #
    #   * `vpc-id` - The ID of the VPC for the route table.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<String>] :route_table_ids
    #   One or more route table IDs.
    #
    #   Default: Describes all your route tables.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @return [Types::DescribeRouteTablesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeRouteTablesResult#route_tables #route_tables} => Array&lt;Types::RouteTable&gt;
    #   * {Types::DescribeRouteTablesResult#next_token #next_token} => String
    #
    #
    # @example Example: To describe a route table
    #
    #   # This example describes the specified route table.
    #
    #   resp = client.describe_route_tables({
    #     route_table_ids: [
    #       "rtb-1f382e7d", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     route_tables: [
    #       {
    #         associations: [
    #           {
    #             main: true, 
    #             route_table_association_id: "rtbassoc-d8ccddba", 
    #             route_table_id: "rtb-1f382e7d", 
    #           }, 
    #         ], 
    #         propagating_vgws: [
    #         ], 
    #         route_table_id: "rtb-1f382e7d", 
    #         routes: [
    #           {
    #             destination_cidr_block: "10.0.0.0/16", 
    #             gateway_id: "local", 
    #             state: "active", 
    #           }, 
    #         ], 
    #         tags: [
    #         ], 
    #         vpc_id: "vpc-a01106c2", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_route_tables({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     dry_run: false,
    #     route_table_ids: ["String"],
    #     next_token: "String",
    #     max_results: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.route_tables #=> Array
    #   resp.route_tables[0].associations #=> Array
    #   resp.route_tables[0].associations[0].main #=> Boolean
    #   resp.route_tables[0].associations[0].route_table_association_id #=> String
    #   resp.route_tables[0].associations[0].route_table_id #=> String
    #   resp.route_tables[0].associations[0].subnet_id #=> String
    #   resp.route_tables[0].propagating_vgws #=> Array
    #   resp.route_tables[0].propagating_vgws[0].gateway_id #=> String
    #   resp.route_tables[0].route_table_id #=> String
    #   resp.route_tables[0].routes #=> Array
    #   resp.route_tables[0].routes[0].destination_cidr_block #=> String
    #   resp.route_tables[0].routes[0].destination_ipv_6_cidr_block #=> String
    #   resp.route_tables[0].routes[0].destination_prefix_list_id #=> String
    #   resp.route_tables[0].routes[0].egress_only_internet_gateway_id #=> String
    #   resp.route_tables[0].routes[0].gateway_id #=> String
    #   resp.route_tables[0].routes[0].instance_id #=> String
    #   resp.route_tables[0].routes[0].instance_owner_id #=> String
    #   resp.route_tables[0].routes[0].nat_gateway_id #=> String
    #   resp.route_tables[0].routes[0].transit_gateway_id #=> String
    #   resp.route_tables[0].routes[0].network_interface_id #=> String
    #   resp.route_tables[0].routes[0].origin #=> String, one of "CreateRouteTable", "CreateRoute", "EnableVgwRoutePropagation"
    #   resp.route_tables[0].routes[0].state #=> String, one of "active", "blackhole"
    #   resp.route_tables[0].routes[0].vpc_peering_connection_id #=> String
    #   resp.route_tables[0].tags #=> Array
    #   resp.route_tables[0].tags[0].key #=> String
    #   resp.route_tables[0].tags[0].value #=> String
    #   resp.route_tables[0].vpc_id #=> String
    #   resp.route_tables[0].owner_id #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeRouteTables AWS API Documentation
    #
    # @overload describe_route_tables(params = {})
    # @param [Hash] params ({})
    def describe_route_tables(params = {}, options = {})
      req = build_request(:describe_route_tables, params)
      req.send_request(options)
    end

    # Finds available schedules that meet the specified criteria.
    #
    # You can search for an available schedule no more than 3 months in
    # advance. You must meet the minimum required duration of 1,200 hours
    # per year. For example, the minimum daily schedule is 4 hours, the
    # minimum weekly schedule is 24 hours, and the minimum monthly schedule
    # is 100 hours.
    #
    # After you find a schedule that meets your needs, call
    # PurchaseScheduledInstances to purchase Scheduled Instances with that
    # schedule.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `availability-zone` - The Availability Zone (for example,
    #     `us-west-2a`).
    #
    #   * `instance-type` - The instance type (for example, `c4.large`).
    #
    #   * `network-platform` - The network platform (`EC2-Classic` or
    #     `EC2-VPC`).
    #
    #   * `platform` - The platform (`Linux/UNIX` or `Windows`).
    #
    # @option params [required, Types::SlotDateTimeRangeRequest] :first_slot_start_time_range
    #   The time period for the first schedule to start.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. This value
    #   can be between 5 and 300. The default value is 300. To retrieve the
    #   remaining results, make another call with the returned `NextToken`
    #   value.
    #
    # @option params [Integer] :max_slot_duration_in_hours
    #   The maximum available duration, in hours. This value must be greater
    #   than `MinSlotDurationInHours` and less than 1,720.
    #
    # @option params [Integer] :min_slot_duration_in_hours
    #   The minimum available duration, in hours. The minimum required
    #   duration is 1,200 hours per year. For example, the minimum daily
    #   schedule is 4 hours, the minimum weekly schedule is 24 hours, and the
    #   minimum monthly schedule is 100 hours.
    #
    # @option params [String] :next_token
    #   The token for the next set of results.
    #
    # @option params [required, Types::ScheduledInstanceRecurrenceRequest] :recurrence
    #   The schedule recurrence.
    #
    # @return [Types::DescribeScheduledInstanceAvailabilityResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeScheduledInstanceAvailabilityResult#next_token #next_token} => String
    #   * {Types::DescribeScheduledInstanceAvailabilityResult#scheduled_instance_availability_set #scheduled_instance_availability_set} => Array&lt;Types::ScheduledInstanceAvailability&gt;
    #
    #
    # @example Example: To describe an available schedule
    #
    #   # This example describes a schedule that occurs every week on Sunday, starting on the specified date. Note that the output
    #   # contains a single schedule as an example.
    #
    #   resp = client.describe_scheduled_instance_availability({
    #     first_slot_start_time_range: {
    #       earliest_time: Time.parse("2016-01-31T00:00:00Z"), 
    #       latest_time: Time.parse("2016-01-31T04:00:00Z"), 
    #     }, 
    #     recurrence: {
    #       frequency: "Weekly", 
    #       interval: 1, 
    #       occurrence_days: [
    #         1, 
    #       ], 
    #     }, 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     scheduled_instance_availability_set: [
    #       {
    #         availability_zone: "us-west-2b", 
    #         available_instance_count: 20, 
    #         first_slot_start_time: Time.parse("2016-01-31T00:00:00Z"), 
    #         hourly_price: "0.095", 
    #         instance_type: "c4.large", 
    #         max_term_duration_in_days: 366, 
    #         min_term_duration_in_days: 366, 
    #         network_platform: "EC2-VPC", 
    #         platform: "Linux/UNIX", 
    #         purchase_token: "eyJ2IjoiMSIsInMiOjEsImMiOi...", 
    #         recurrence: {
    #           frequency: "Weekly", 
    #           interval: 1, 
    #           occurrence_day_set: [
    #             1, 
    #           ], 
    #           occurrence_relative_to_end: false, 
    #         }, 
    #         slot_duration_in_hours: 23, 
    #         total_scheduled_instance_hours: 1219, 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_scheduled_instance_availability({
    #     dry_run: false,
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     first_slot_start_time_range: { # required
    #       earliest_time: Time.now, # required
    #       latest_time: Time.now, # required
    #     },
    #     max_results: 1,
    #     max_slot_duration_in_hours: 1,
    #     min_slot_duration_in_hours: 1,
    #     next_token: "String",
    #     recurrence: { # required
    #       frequency: "String",
    #       interval: 1,
    #       occurrence_days: [1],
    #       occurrence_relative_to_end: false,
    #       occurrence_unit: "String",
    #     },
    #   })
    #
    # @example Response structure
    #
    #   resp.next_token #=> String
    #   resp.scheduled_instance_availability_set #=> Array
    #   resp.scheduled_instance_availability_set[0].availability_zone #=> String
    #   resp.scheduled_instance_availability_set[0].available_instance_count #=> Integer
    #   resp.scheduled_instance_availability_set[0].first_slot_start_time #=> Time
    #   resp.scheduled_instance_availability_set[0].hourly_price #=> String
    #   resp.scheduled_instance_availability_set[0].instance_type #=> String
    #   resp.scheduled_instance_availability_set[0].max_term_duration_in_days #=> Integer
    #   resp.scheduled_instance_availability_set[0].min_term_duration_in_days #=> Integer
    #   resp.scheduled_instance_availability_set[0].network_platform #=> String
    #   resp.scheduled_instance_availability_set[0].platform #=> String
    #   resp.scheduled_instance_availability_set[0].purchase_token #=> String
    #   resp.scheduled_instance_availability_set[0].recurrence.frequency #=> String
    #   resp.scheduled_instance_availability_set[0].recurrence.interval #=> Integer
    #   resp.scheduled_instance_availability_set[0].recurrence.occurrence_day_set #=> Array
    #   resp.scheduled_instance_availability_set[0].recurrence.occurrence_day_set[0] #=> Integer
    #   resp.scheduled_instance_availability_set[0].recurrence.occurrence_relative_to_end #=> Boolean
    #   resp.scheduled_instance_availability_set[0].recurrence.occurrence_unit #=> String
    #   resp.scheduled_instance_availability_set[0].slot_duration_in_hours #=> Integer
    #   resp.scheduled_instance_availability_set[0].total_scheduled_instance_hours #=> Integer
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeScheduledInstanceAvailability AWS API Documentation
    #
    # @overload describe_scheduled_instance_availability(params = {})
    # @param [Hash] params ({})
    def describe_scheduled_instance_availability(params = {}, options = {})
      req = build_request(:describe_scheduled_instance_availability, params)
      req.send_request(options)
    end

    # Describes the specified Scheduled Instances or all your Scheduled
    # Instances.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `availability-zone` - The Availability Zone (for example,
    #     `us-west-2a`).
    #
    #   * `instance-type` - The instance type (for example, `c4.large`).
    #
    #   * `network-platform` - The network platform (`EC2-Classic` or
    #     `EC2-VPC`).
    #
    #   * `platform` - The platform (`Linux/UNIX` or `Windows`).
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. This value
    #   can be between 5 and 300. The default value is 100. To retrieve the
    #   remaining results, make another call with the returned `NextToken`
    #   value.
    #
    # @option params [String] :next_token
    #   The token for the next set of results.
    #
    # @option params [Array<String>] :scheduled_instance_ids
    #   The Scheduled Instance IDs.
    #
    # @option params [Types::SlotStartTimeRangeRequest] :slot_start_time_range
    #   The time period for the first schedule to start.
    #
    # @return [Types::DescribeScheduledInstancesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeScheduledInstancesResult#next_token #next_token} => String
    #   * {Types::DescribeScheduledInstancesResult#scheduled_instance_set #scheduled_instance_set} => Array&lt;Types::ScheduledInstance&gt;
    #
    #
    # @example Example: To describe your Scheduled Instances
    #
    #   # This example describes the specified Scheduled Instance.
    #
    #   resp = client.describe_scheduled_instances({
    #     scheduled_instance_ids: [
    #       "sci-1234-1234-1234-1234-123456789012", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     scheduled_instance_set: [
    #       {
    #         availability_zone: "us-west-2b", 
    #         create_date: Time.parse("2016-01-25T21:43:38.612Z"), 
    #         hourly_price: "0.095", 
    #         instance_count: 1, 
    #         instance_type: "c4.large", 
    #         network_platform: "EC2-VPC", 
    #         next_slot_start_time: Time.parse("2016-01-31T09:00:00Z"), 
    #         platform: "Linux/UNIX", 
    #         recurrence: {
    #           frequency: "Weekly", 
    #           interval: 1, 
    #           occurrence_day_set: [
    #             1, 
    #           ], 
    #           occurrence_relative_to_end: false, 
    #           occurrence_unit: "", 
    #         }, 
    #         scheduled_instance_id: "sci-1234-1234-1234-1234-123456789012", 
    #         slot_duration_in_hours: 32, 
    #         term_end_date: Time.parse("2017-01-31T09:00:00Z"), 
    #         term_start_date: Time.parse("2016-01-31T09:00:00Z"), 
    #         total_scheduled_instance_hours: 1696, 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_scheduled_instances({
    #     dry_run: false,
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #     next_token: "String",
    #     scheduled_instance_ids: ["String"],
    #     slot_start_time_range: {
    #       earliest_time: Time.now,
    #       latest_time: Time.now,
    #     },
    #   })
    #
    # @example Response structure
    #
    #   resp.next_token #=> String
    #   resp.scheduled_instance_set #=> Array
    #   resp.scheduled_instance_set[0].availability_zone #=> String
    #   resp.scheduled_instance_set[0].create_date #=> Time
    #   resp.scheduled_instance_set[0].hourly_price #=> String
    #   resp.scheduled_instance_set[0].instance_count #=> Integer
    #   resp.scheduled_instance_set[0].instance_type #=> String
    #   resp.scheduled_instance_set[0].network_platform #=> String
    #   resp.scheduled_instance_set[0].next_slot_start_time #=> Time
    #   resp.scheduled_instance_set[0].platform #=> String
    #   resp.scheduled_instance_set[0].previous_slot_end_time #=> Time
    #   resp.scheduled_instance_set[0].recurrence.frequency #=> String
    #   resp.scheduled_instance_set[0].recurrence.interval #=> Integer
    #   resp.scheduled_instance_set[0].recurrence.occurrence_day_set #=> Array
    #   resp.scheduled_instance_set[0].recurrence.occurrence_day_set[0] #=> Integer
    #   resp.scheduled_instance_set[0].recurrence.occurrence_relative_to_end #=> Boolean
    #   resp.scheduled_instance_set[0].recurrence.occurrence_unit #=> String
    #   resp.scheduled_instance_set[0].scheduled_instance_id #=> String
    #   resp.scheduled_instance_set[0].slot_duration_in_hours #=> Integer
    #   resp.scheduled_instance_set[0].term_end_date #=> Time
    #   resp.scheduled_instance_set[0].term_start_date #=> Time
    #   resp.scheduled_instance_set[0].total_scheduled_instance_hours #=> Integer
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeScheduledInstances AWS API Documentation
    #
    # @overload describe_scheduled_instances(params = {})
    # @param [Hash] params ({})
    def describe_scheduled_instances(params = {}, options = {})
      req = build_request(:describe_scheduled_instances, params)
      req.send_request(options)
    end

    # \[VPC only\] Describes the VPCs on the other side of a VPC peering
    # connection that are referencing the security groups you've specified
    # in this request.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :group_id
    #   The IDs of the security groups in your account.
    #
    # @return [Types::DescribeSecurityGroupReferencesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeSecurityGroupReferencesResult#security_group_reference_set #security_group_reference_set} => Array&lt;Types::SecurityGroupReference&gt;
    #
    #
    # @example Example: To describe security group references
    #
    #   # This example describes the security group references for the specified security group.
    #
    #   resp = client.describe_security_group_references({
    #     group_id: [
    #       "sg-903004f8", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     security_group_reference_set: [
    #       {
    #         group_id: "sg-903004f8", 
    #         referencing_vpc_id: "vpc-1a2b3c4d", 
    #         vpc_peering_connection_id: "pcx-b04deed9", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_security_group_references({
    #     dry_run: false,
    #     group_id: ["String"], # required
    #   })
    #
    # @example Response structure
    #
    #   resp.security_group_reference_set #=> Array
    #   resp.security_group_reference_set[0].group_id #=> String
    #   resp.security_group_reference_set[0].referencing_vpc_id #=> String
    #   resp.security_group_reference_set[0].vpc_peering_connection_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroupReferences AWS API Documentation
    #
    # @overload describe_security_group_references(params = {})
    # @param [Hash] params ({})
    def describe_security_group_references(params = {}, options = {})
      req = build_request(:describe_security_group_references, params)
      req.send_request(options)
    end

    # Describes the specified security groups or all of your security
    # groups.
    #
    # A security group is for use with instances either in the EC2-Classic
    # platform or in a specific VPC. For more information, see [Amazon EC2
    # Security Groups][1] in the *Amazon Elastic Compute Cloud User Guide*
    # and [Security Groups for Your VPC][2] in the *Amazon Virtual Private
    # Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html
    # [2]: https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters. If using multiple filters for rules, the results include
    #   security groups for which any combination of rules - not necessarily a
    #   single rule - match all filters.
    #
    #   * `description` - The description of the security group.
    #
    #   * `egress.ip-permission.cidr` - An IPv4 CIDR block for an outbound
    #     security group rule.
    #
    #   * `egress.ip-permission.from-port` - For an outbound rule, the start
    #     of port range for the TCP and UDP protocols, or an ICMP type number.
    #
    #   * `egress.ip-permission.group-id` - The ID of a security group that
    #     has been referenced in an outbound security group rule.
    #
    #   * `egress.ip-permission.group-name` - The name of a security group
    #     that has been referenced in an outbound security group rule.
    #
    #   * `egress.ip-permission.ipv6-cidr` - An IPv6 CIDR block for an
    #     outbound security group rule.
    #
    #   * `egress.ip-permission.prefix-list-id` - The ID (prefix) of the AWS
    #     service to which a security group rule allows outbound access.
    #
    #   * `egress.ip-permission.protocol` - The IP protocol for an outbound
    #     security group rule (`tcp` \| `udp` \| `icmp` or a protocol number).
    #
    #   * `egress.ip-permission.to-port` - For an outbound rule, the end of
    #     port range for the TCP and UDP protocols, or an ICMP code.
    #
    #   * `egress.ip-permission.user-id` - The ID of an AWS account that has
    #     been referenced in an outbound security group rule.
    #
    #   * `group-id` - The ID of the security group.
    #
    #   * `group-name` - The name of the security group.
    #
    #   * `ip-permission.cidr` - An IPv4 CIDR block for an inbound security
    #     group rule.
    #
    #   * `ip-permission.from-port` - For an inbound rule, the start of port
    #     range for the TCP and UDP protocols, or an ICMP type number.
    #
    #   * `ip-permission.group-id` - The ID of a security group that has been
    #     referenced in an inbound security group rule.
    #
    #   * `ip-permission.group-name` - The name of a security group that has
    #     been referenced in an inbound security group rule.
    #
    #   * `ip-permission.ipv6-cidr` - An IPv6 CIDR block for an inbound
    #     security group rule.
    #
    #   * `ip-permission.prefix-list-id` - The ID (prefix) of the AWS service
    #     from which a security group rule allows inbound access.
    #
    #   * `ip-permission.protocol` - The IP protocol for an inbound security
    #     group rule (`tcp` \| `udp` \| `icmp` or a protocol number).
    #
    #   * `ip-permission.to-port` - For an inbound rule, the end of port range
    #     for the TCP and UDP protocols, or an ICMP code.
    #
    #   * `ip-permission.user-id` - The ID of an AWS account that has been
    #     referenced in an inbound security group rule.
    #
    #   * `owner-id` - The AWS account ID of the owner of the security group.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `vpc-id` - The ID of the VPC specified when the security group was
    #     created.
    #
    # @option params [Array<String>] :group_ids
    #   The IDs of the security groups. Required for security groups in a
    #   nondefault VPC.
    #
    #   Default: Describes all your security groups.
    #
    # @option params [Array<String>] :group_names
    #   \[EC2-Classic and default VPC only\] The names of the security groups.
    #   You can specify either the security group name or the security group
    #   ID. For security groups in a nondefault VPC, use the `group-name`
    #   filter to describe security groups by name.
    #
    #   Default: Describes all your security groups.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :next_token
    #   The token to request the next page of results.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. To retrieve
    #   the remaining results, make another request with the returned
    #   `NextToken` value. This value can be between 5 and 1000. If this
    #   parameter is not specified, then all results are returned.
    #
    # @return [Types::DescribeSecurityGroupsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeSecurityGroupsResult#security_groups #security_groups} => Array&lt;Types::SecurityGroup&gt;
    #   * {Types::DescribeSecurityGroupsResult#next_token #next_token} => String
    #
    #
    # @example Example: To describe a security group
    #
    #   # This example describes the specified security group.
    #
    #   resp = client.describe_security_groups({
    #     group_ids: [
    #       "sg-903004f8", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Example: To describe a tagged security group
    #
    #   # This example describes the security groups that include the specified tag (Purpose=test).
    #
    #   resp = client.describe_security_groups({
    #     filters: [
    #       {
    #         name: "tag:Purpose", 
    #         values: [
    #           "test", 
    #         ], 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_security_groups({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     group_ids: ["String"],
    #     group_names: ["String"],
    #     dry_run: false,
    #     next_token: "String",
    #     max_results: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.security_groups #=> Array
    #   resp.security_groups[0].description #=> String
    #   resp.security_groups[0].group_name #=> String
    #   resp.security_groups[0].ip_permissions #=> Array
    #   resp.security_groups[0].ip_permissions[0].from_port #=> Integer
    #   resp.security_groups[0].ip_permissions[0].ip_protocol #=> String
    #   resp.security_groups[0].ip_permissions[0].ip_ranges #=> Array
    #   resp.security_groups[0].ip_permissions[0].ip_ranges[0].cidr_ip #=> String
    #   resp.security_groups[0].ip_permissions[0].ip_ranges[0].description #=> String
    #   resp.security_groups[0].ip_permissions[0].ipv_6_ranges #=> Array
    #   resp.security_groups[0].ip_permissions[0].ipv_6_ranges[0].cidr_ipv_6 #=> String
    #   resp.security_groups[0].ip_permissions[0].ipv_6_ranges[0].description #=> String
    #   resp.security_groups[0].ip_permissions[0].prefix_list_ids #=> Array
    #   resp.security_groups[0].ip_permissions[0].prefix_list_ids[0].description #=> String
    #   resp.security_groups[0].ip_permissions[0].prefix_list_ids[0].prefix_list_id #=> String
    #   resp.security_groups[0].ip_permissions[0].to_port #=> Integer
    #   resp.security_groups[0].ip_permissions[0].user_id_group_pairs #=> Array
    #   resp.security_groups[0].ip_permissions[0].user_id_group_pairs[0].description #=> String
    #   resp.security_groups[0].ip_permissions[0].user_id_group_pairs[0].group_id #=> String
    #   resp.security_groups[0].ip_permissions[0].user_id_group_pairs[0].group_name #=> String
    #   resp.security_groups[0].ip_permissions[0].user_id_group_pairs[0].peering_status #=> String
    #   resp.security_groups[0].ip_permissions[0].user_id_group_pairs[0].user_id #=> String
    #   resp.security_groups[0].ip_permissions[0].user_id_group_pairs[0].vpc_id #=> String
    #   resp.security_groups[0].ip_permissions[0].user_id_group_pairs[0].vpc_peering_connection_id #=> String
    #   resp.security_groups[0].owner_id #=> String
    #   resp.security_groups[0].group_id #=> String
    #   resp.security_groups[0].ip_permissions_egress #=> Array
    #   resp.security_groups[0].ip_permissions_egress[0].from_port #=> Integer
    #   resp.security_groups[0].ip_permissions_egress[0].ip_protocol #=> String
    #   resp.security_groups[0].ip_permissions_egress[0].ip_ranges #=> Array
    #   resp.security_groups[0].ip_permissions_egress[0].ip_ranges[0].cidr_ip #=> String
    #   resp.security_groups[0].ip_permissions_egress[0].ip_ranges[0].description #=> String
    #   resp.security_groups[0].ip_permissions_egress[0].ipv_6_ranges #=> Array
    #   resp.security_groups[0].ip_permissions_egress[0].ipv_6_ranges[0].cidr_ipv_6 #=> String
    #   resp.security_groups[0].ip_permissions_egress[0].ipv_6_ranges[0].description #=> String
    #   resp.security_groups[0].ip_permissions_egress[0].prefix_list_ids #=> Array
    #   resp.security_groups[0].ip_permissions_egress[0].prefix_list_ids[0].description #=> String
    #   resp.security_groups[0].ip_permissions_egress[0].prefix_list_ids[0].prefix_list_id #=> String
    #   resp.security_groups[0].ip_permissions_egress[0].to_port #=> Integer
    #   resp.security_groups[0].ip_permissions_egress[0].user_id_group_pairs #=> Array
    #   resp.security_groups[0].ip_permissions_egress[0].user_id_group_pairs[0].description #=> String
    #   resp.security_groups[0].ip_permissions_egress[0].user_id_group_pairs[0].group_id #=> String
    #   resp.security_groups[0].ip_permissions_egress[0].user_id_group_pairs[0].group_name #=> String
    #   resp.security_groups[0].ip_permissions_egress[0].user_id_group_pairs[0].peering_status #=> String
    #   resp.security_groups[0].ip_permissions_egress[0].user_id_group_pairs[0].user_id #=> String
    #   resp.security_groups[0].ip_permissions_egress[0].user_id_group_pairs[0].vpc_id #=> String
    #   resp.security_groups[0].ip_permissions_egress[0].user_id_group_pairs[0].vpc_peering_connection_id #=> String
    #   resp.security_groups[0].tags #=> Array
    #   resp.security_groups[0].tags[0].key #=> String
    #   resp.security_groups[0].tags[0].value #=> String
    #   resp.security_groups[0].vpc_id #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroups AWS API Documentation
    #
    # @overload describe_security_groups(params = {})
    # @param [Hash] params ({})
    def describe_security_groups(params = {}, options = {})
      req = build_request(:describe_security_groups, params)
      req.send_request(options)
    end

    # Describes the specified attribute of the specified snapshot. You can
    # specify only one attribute at a time.
    #
    # For more information about EBS snapshots, see [Amazon EBS
    # Snapshots][1] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html
    #
    # @option params [required, String] :attribute
    #   The snapshot attribute you would like to view.
    #
    # @option params [required, String] :snapshot_id
    #   The ID of the EBS snapshot.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeSnapshotAttributeResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeSnapshotAttributeResult#create_volume_permissions #create_volume_permissions} => Array&lt;Types::CreateVolumePermission&gt;
    #   * {Types::DescribeSnapshotAttributeResult#product_codes #product_codes} => Array&lt;Types::ProductCode&gt;
    #   * {Types::DescribeSnapshotAttributeResult#snapshot_id #snapshot_id} => String
    #
    #
    # @example Example: To describe snapshot attributes
    #
    #   # This example describes the ``createVolumePermission`` attribute on a snapshot with the snapshot ID of
    #   # ``snap-066877671789bd71b``.
    #
    #   resp = client.describe_snapshot_attribute({
    #     attribute: "createVolumePermission", 
    #     snapshot_id: "snap-066877671789bd71b", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     create_volume_permissions: [
    #     ], 
    #     snapshot_id: "snap-066877671789bd71b", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_snapshot_attribute({
    #     attribute: "productCodes", # required, accepts productCodes, createVolumePermission
    #     snapshot_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.create_volume_permissions #=> Array
    #   resp.create_volume_permissions[0].group #=> String, one of "all"
    #   resp.create_volume_permissions[0].user_id #=> String
    #   resp.product_codes #=> Array
    #   resp.product_codes[0].product_code_id #=> String
    #   resp.product_codes[0].product_code_type #=> String, one of "devpay", "marketplace"
    #   resp.snapshot_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSnapshotAttribute AWS API Documentation
    #
    # @overload describe_snapshot_attribute(params = {})
    # @param [Hash] params ({})
    def describe_snapshot_attribute(params = {}, options = {})
      req = build_request(:describe_snapshot_attribute, params)
      req.send_request(options)
    end

    # Describes the specified EBS snapshots available to you or all of the
    # EBS snapshots available to you.
    #
    # The snapshots available to you include public snapshots, private
    # snapshots that you own, and private snapshots owned by other AWS
    # accounts for which you have explicit create volume permissions.
    #
    # The create volume permissions fall into the following categories:
    #
    # * *public*\: The owner of the snapshot granted create volume
    #   permissions for the snapshot to the `all` group. All AWS accounts
    #   have create volume permissions for these snapshots.
    #
    # * *explicit*\: The owner of the snapshot granted create volume
    #   permissions to a specific AWS account.
    #
    # * *implicit*\: An AWS account has implicit create volume permissions
    #   for all snapshots it owns.
    #
    # The list of snapshots returned can be modified by specifying snapshot
    # IDs, snapshot owners, or AWS accounts with create volume permissions.
    # If no options are specified, Amazon EC2 returns all snapshots for
    # which you have create volume permissions.
    #
    # If you specify one or more snapshot IDs, only snapshots that have the
    # specified IDs are returned. If you specify an invalid snapshot ID, an
    # error is returned. If you specify a snapshot ID for which you do not
    # have access, it is not included in the returned results.
    #
    # If you specify one or more snapshot owners using the `OwnerIds`
    # option, only snapshots from the specified owners and for which you
    # have access are returned. The results can include the AWS account IDs
    # of the specified owners, `amazon` for snapshots owned by Amazon, or
    # `self` for snapshots that you own.
    #
    # If you specify a list of restorable users, only snapshots with create
    # snapshot permissions for those users are returned. You can specify AWS
    # account IDs (if you own the snapshots), `self` for snapshots for which
    # you own or have explicit permissions, or `all` for public snapshots.
    #
    # If you are describing a long list of snapshots, you can paginate the
    # output to make the list more manageable. The `MaxResults` parameter
    # sets the maximum number of results returned in a single page. If the
    # list of results exceeds your `MaxResults` value, then that number of
    # results is returned along with a `NextToken` value that can be passed
    # to a subsequent `DescribeSnapshots` request to retrieve the remaining
    # results.
    #
    # For more information about EBS snapshots, see [Amazon EBS
    # Snapshots][1] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `description` - A description of the snapshot.
    #
    #   * `encrypted` - Indicates whether the snapshot is encrypted (`true` \|
    #     `false`)
    #
    #   * `owner-alias` - Value from an Amazon-maintained list (`amazon` \|
    #     `self` \| `all` \| `aws-marketplace` \| `microsoft`) of snapshot
    #     owners. Not to be confused with the user-configured AWS account
    #     alias, which is set from the IAM console.
    #
    #   * `owner-id` - The ID of the AWS account that owns the snapshot.
    #
    #   * `progress` - The progress of the snapshot, as a percentage (for
    #     example, 80%).
    #
    #   * `snapshot-id` - The snapshot ID.
    #
    #   * `start-time` - The time stamp when the snapshot was initiated.
    #
    #   * `status` - The status of the snapshot (`pending` \| `completed` \|
    #     `error`).
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `volume-id` - The ID of the volume the snapshot is for.
    #
    #   * `volume-size` - The size of the volume, in GiB.
    #
    # @option params [Integer] :max_results
    #   The maximum number of snapshot results returned by `DescribeSnapshots`
    #   in paginated output. When this parameter is used, `DescribeSnapshots`
    #   only returns `MaxResults` results in a single page along with a
    #   `NextToken` response element. The remaining results of the initial
    #   request can be seen by sending another `DescribeSnapshots` request
    #   with the returned `NextToken` value. This value can be between 5 and
    #   1000; if `MaxResults` is given a value larger than 1000, only 1000
    #   results are returned. If this parameter is not used, then
    #   `DescribeSnapshots` returns all results. You cannot specify this
    #   parameter and the snapshot IDs parameter in the same request.
    #
    # @option params [String] :next_token
    #   The `NextToken` value returned from a previous paginated
    #   `DescribeSnapshots` request where `MaxResults` was used and the
    #   results exceeded the value of that parameter. Pagination continues
    #   from the end of the previous results that returned the `NextToken`
    #   value. This value is `null` when there are no more results to return.
    #
    # @option params [Array<String>] :owner_ids
    #   Describes the snapshots owned by these owners.
    #
    # @option params [Array<String>] :restorable_by_user_ids
    #   The IDs of the AWS accounts that can create volumes from the snapshot.
    #
    # @option params [Array<String>] :snapshot_ids
    #   The snapshot IDs.
    #
    #   Default: Describes the snapshots for which you have create volume
    #   permissions.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeSnapshotsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeSnapshotsResult#snapshots #snapshots} => Array&lt;Types::Snapshot&gt;
    #   * {Types::DescribeSnapshotsResult#next_token #next_token} => String
    #
    #
    # @example Example: To describe a snapshot
    #
    #   # This example describes a snapshot with the snapshot ID of ``snap-1234567890abcdef0``.
    #
    #   resp = client.describe_snapshots({
    #     snapshot_ids: [
    #       "snap-1234567890abcdef0", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     next_token: "", 
    #     snapshots: [
    #       {
    #         description: "This is my snapshot.", 
    #         owner_id: "012345678910", 
    #         progress: "100%", 
    #         snapshot_id: "snap-1234567890abcdef0", 
    #         start_time: Time.parse("2014-02-28T21:28:32.000Z"), 
    #         state: "completed", 
    #         volume_id: "vol-049df61146c4d7901", 
    #         volume_size: 8, 
    #       }, 
    #     ], 
    #   }
    #
    # @example Example: To describe snapshots using filters
    #
    #   # This example describes all snapshots owned by the ID 012345678910 that are in the ``pending`` status.
    #
    #   resp = client.describe_snapshots({
    #     filters: [
    #       {
    #         name: "status", 
    #         values: [
    #           "pending", 
    #         ], 
    #       }, 
    #     ], 
    #     owner_ids: [
    #       "012345678910", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     next_token: "", 
    #     snapshots: [
    #       {
    #         description: "This is my copied snapshot.", 
    #         owner_id: "012345678910", 
    #         progress: "87%", 
    #         snapshot_id: "snap-066877671789bd71b", 
    #         start_time: Time.parse("2014-02-28T21:37:27.000Z"), 
    #         state: "pending", 
    #         volume_id: "vol-1234567890abcdef0", 
    #         volume_size: 8, 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_snapshots({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #     next_token: "String",
    #     owner_ids: ["String"],
    #     restorable_by_user_ids: ["String"],
    #     snapshot_ids: ["String"],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.snapshots #=> Array
    #   resp.snapshots[0].data_encryption_key_id #=> String
    #   resp.snapshots[0].description #=> String
    #   resp.snapshots[0].encrypted #=> Boolean
    #   resp.snapshots[0].kms_key_id #=> String
    #   resp.snapshots[0].owner_id #=> String
    #   resp.snapshots[0].progress #=> String
    #   resp.snapshots[0].snapshot_id #=> String
    #   resp.snapshots[0].start_time #=> Time
    #   resp.snapshots[0].state #=> String, one of "pending", "completed", "error"
    #   resp.snapshots[0].state_message #=> String
    #   resp.snapshots[0].volume_id #=> String
    #   resp.snapshots[0].volume_size #=> Integer
    #   resp.snapshots[0].owner_alias #=> String
    #   resp.snapshots[0].tags #=> Array
    #   resp.snapshots[0].tags[0].key #=> String
    #   resp.snapshots[0].tags[0].value #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSnapshots AWS API Documentation
    #
    # @overload describe_snapshots(params = {})
    # @param [Hash] params ({})
    def describe_snapshots(params = {}, options = {})
      req = build_request(:describe_snapshots, params)
      req.send_request(options)
    end

    # Describes the data feed for Spot Instances. For more information, see
    # [Spot Instance Data Feed][1] in the *Amazon EC2 User Guide for Linux
    # Instances*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeSpotDatafeedSubscriptionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeSpotDatafeedSubscriptionResult#spot_datafeed_subscription #spot_datafeed_subscription} => Types::SpotDatafeedSubscription
    #
    #
    # @example Example: To describe the datafeed for your AWS account
    #
    #   # This example describes the Spot Instance datafeed subscription for your AWS account.
    #
    #   resp = client.describe_spot_datafeed_subscription({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     spot_datafeed_subscription: {
    #       bucket: "my-s3-bucket", 
    #       owner_id: "123456789012", 
    #       prefix: "spotdata", 
    #       state: "Active", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_spot_datafeed_subscription({
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.spot_datafeed_subscription.bucket #=> String
    #   resp.spot_datafeed_subscription.fault.code #=> String
    #   resp.spot_datafeed_subscription.fault.message #=> String
    #   resp.spot_datafeed_subscription.owner_id #=> String
    #   resp.spot_datafeed_subscription.prefix #=> String
    #   resp.spot_datafeed_subscription.state #=> String, one of "Active", "Inactive"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotDatafeedSubscription AWS API Documentation
    #
    # @overload describe_spot_datafeed_subscription(params = {})
    # @param [Hash] params ({})
    def describe_spot_datafeed_subscription(params = {}, options = {})
      req = build_request(:describe_spot_datafeed_subscription, params)
      req.send_request(options)
    end

    # Describes the running instances for the specified Spot Fleet.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. Specify a
    #   value between 1 and 1000. The default value is 1000. To retrieve the
    #   remaining results, make another call with the returned `NextToken`
    #   value.
    #
    # @option params [String] :next_token
    #   The token for the next set of results.
    #
    # @option params [required, String] :spot_fleet_request_id
    #   The ID of the Spot Fleet request.
    #
    # @return [Types::DescribeSpotFleetInstancesResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeSpotFleetInstancesResponse#active_instances #active_instances} => Array&lt;Types::ActiveInstance&gt;
    #   * {Types::DescribeSpotFleetInstancesResponse#next_token #next_token} => String
    #   * {Types::DescribeSpotFleetInstancesResponse#spot_fleet_request_id #spot_fleet_request_id} => String
    #
    #
    # @example Example: To describe the Spot Instances associated with a Spot fleet
    #
    #   # This example lists the Spot Instances associated with the specified Spot fleet.
    #
    #   resp = client.describe_spot_fleet_instances({
    #     spot_fleet_request_id: "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     active_instances: [
    #       {
    #         instance_id: "i-1234567890abcdef0", 
    #         instance_type: "m3.medium", 
    #         spot_instance_request_id: "sir-08b93456", 
    #       }, 
    #     ], 
    #     spot_fleet_request_id: "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_spot_fleet_instances({
    #     dry_run: false,
    #     max_results: 1,
    #     next_token: "String",
    #     spot_fleet_request_id: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.active_instances #=> Array
    #   resp.active_instances[0].instance_id #=> String
    #   resp.active_instances[0].instance_type #=> String
    #   resp.active_instances[0].spot_instance_request_id #=> String
    #   resp.active_instances[0].instance_health #=> String, one of "healthy", "unhealthy"
    #   resp.next_token #=> String
    #   resp.spot_fleet_request_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetInstances AWS API Documentation
    #
    # @overload describe_spot_fleet_instances(params = {})
    # @param [Hash] params ({})
    def describe_spot_fleet_instances(params = {}, options = {})
      req = build_request(:describe_spot_fleet_instances, params)
      req.send_request(options)
    end

    # Describes the events for the specified Spot Fleet request during the
    # specified time.
    #
    # Spot Fleet events are delayed by up to 30 seconds before they can be
    # described. This ensures that you can query by the last evaluated time
    # and not miss a recorded event. Spot Fleet events are available for 48
    # hours.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :event_type
    #   The type of events to describe. By default, all events are described.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. Specify a
    #   value between 1 and 1000. The default value is 1000. To retrieve the
    #   remaining results, make another call with the returned `NextToken`
    #   value.
    #
    # @option params [String] :next_token
    #   The token for the next set of results.
    #
    # @option params [required, String] :spot_fleet_request_id
    #   The ID of the Spot Fleet request.
    #
    # @option params [required, Time,DateTime,Date,Integer,String] :start_time
    #   The starting date and time for the events, in UTC format (for example,
    #   *YYYY*-*MM*-*DD*T*HH*\:*MM*\:*SS*Z).
    #
    # @return [Types::DescribeSpotFleetRequestHistoryResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeSpotFleetRequestHistoryResponse#history_records #history_records} => Array&lt;Types::HistoryRecord&gt;
    #   * {Types::DescribeSpotFleetRequestHistoryResponse#last_evaluated_time #last_evaluated_time} => Time
    #   * {Types::DescribeSpotFleetRequestHistoryResponse#next_token #next_token} => String
    #   * {Types::DescribeSpotFleetRequestHistoryResponse#spot_fleet_request_id #spot_fleet_request_id} => String
    #   * {Types::DescribeSpotFleetRequestHistoryResponse#start_time #start_time} => Time
    #
    #
    # @example Example: To describe Spot fleet history
    #
    #   # This example returns the history for the specified Spot fleet starting at the specified time.
    #
    #   resp = client.describe_spot_fleet_request_history({
    #     spot_fleet_request_id: "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE", 
    #     start_time: Time.parse("2015-05-26T00:00:00Z"), 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     history_records: [
    #       {
    #         event_information: {
    #           event_sub_type: "submitted", 
    #         }, 
    #         event_type: "fleetRequestChange", 
    #         timestamp: Time.parse("2015-05-26T23:17:20.697Z"), 
    #       }, 
    #       {
    #         event_information: {
    #           event_sub_type: "active", 
    #         }, 
    #         event_type: "fleetRequestChange", 
    #         timestamp: Time.parse("2015-05-26T23:17:20.873Z"), 
    #       }, 
    #       {
    #         event_information: {
    #           event_sub_type: "launched", 
    #           instance_id: "i-1234567890abcdef0", 
    #         }, 
    #         event_type: "instanceChange", 
    #         timestamp: Time.parse("2015-05-26T23:21:21.712Z"), 
    #       }, 
    #       {
    #         event_information: {
    #           event_sub_type: "launched", 
    #           instance_id: "i-1234567890abcdef1", 
    #         }, 
    #         event_type: "instanceChange", 
    #         timestamp: Time.parse("2015-05-26T23:21:21.816Z"), 
    #       }, 
    #     ], 
    #     next_token: "CpHNsscimcV5oH7bSbub03CI2Qms5+ypNpNm+53MNlR0YcXAkp0xFlfKf91yVxSExmbtma3awYxMFzNA663ZskT0AHtJ6TCb2Z8bQC2EnZgyELbymtWPfpZ1ZbauVg+P+TfGlWxWWB/Vr5dk5d4LfdgA/DRAHUrYgxzrEXAMPLE=", 
    #     spot_fleet_request_id: "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE", 
    #     start_time: Time.parse("2015-05-26T00:00:00Z"), 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_spot_fleet_request_history({
    #     dry_run: false,
    #     event_type: "instanceChange", # accepts instanceChange, fleetRequestChange, error, information
    #     max_results: 1,
    #     next_token: "String",
    #     spot_fleet_request_id: "String", # required
    #     start_time: Time.now, # required
    #   })
    #
    # @example Response structure
    #
    #   resp.history_records #=> Array
    #   resp.history_records[0].event_information.event_description #=> String
    #   resp.history_records[0].event_information.event_sub_type #=> String
    #   resp.history_records[0].event_information.instance_id #=> String
    #   resp.history_records[0].event_type #=> String, one of "instanceChange", "fleetRequestChange", "error", "information"
    #   resp.history_records[0].timestamp #=> Time
    #   resp.last_evaluated_time #=> Time
    #   resp.next_token #=> String
    #   resp.spot_fleet_request_id #=> String
    #   resp.start_time #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetRequestHistory AWS API Documentation
    #
    # @overload describe_spot_fleet_request_history(params = {})
    # @param [Hash] params ({})
    def describe_spot_fleet_request_history(params = {}, options = {})
      req = build_request(:describe_spot_fleet_request_history, params)
      req.send_request(options)
    end

    # Describes your Spot Fleet requests.
    #
    # Spot Fleet requests are deleted 48 hours after they are canceled and
    # their instances are terminated.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. Specify a
    #   value between 1 and 1000. The default value is 1000. To retrieve the
    #   remaining results, make another call with the returned `NextToken`
    #   value.
    #
    # @option params [String] :next_token
    #   The token for the next set of results.
    #
    # @option params [Array<String>] :spot_fleet_request_ids
    #   The IDs of the Spot Fleet requests.
    #
    # @return [Types::DescribeSpotFleetRequestsResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeSpotFleetRequestsResponse#next_token #next_token} => String
    #   * {Types::DescribeSpotFleetRequestsResponse#spot_fleet_request_configs #spot_fleet_request_configs} => Array&lt;Types::SpotFleetRequestConfig&gt;
    #
    #
    # @example Example: To describe a Spot fleet request
    #
    #   # This example describes the specified Spot fleet request.
    #
    #   resp = client.describe_spot_fleet_requests({
    #     spot_fleet_request_ids: [
    #       "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     spot_fleet_request_configs: [
    #       {
    #         spot_fleet_request_config: {
    #           iam_fleet_role: "arn:aws:iam::123456789012:role/my-spot-fleet-role", 
    #           launch_specifications: [
    #             {
    #               ebs_optimized: false, 
    #               image_id: "ami-1a2b3c4d", 
    #               instance_type: "cc2.8xlarge", 
    #               network_interfaces: [
    #                 {
    #                   associate_public_ip_address: true, 
    #                   delete_on_termination: false, 
    #                   device_index: 0, 
    #                   secondary_private_ip_address_count: 0, 
    #                   subnet_id: "subnet-a61dafcf", 
    #                 }, 
    #               ], 
    #             }, 
    #             {
    #               ebs_optimized: false, 
    #               image_id: "ami-1a2b3c4d", 
    #               instance_type: "r3.8xlarge", 
    #               network_interfaces: [
    #                 {
    #                   associate_public_ip_address: true, 
    #                   delete_on_termination: false, 
    #                   device_index: 0, 
    #                   secondary_private_ip_address_count: 0, 
    #                   subnet_id: "subnet-a61dafcf", 
    #                 }, 
    #               ], 
    #             }, 
    #           ], 
    #           spot_price: "0.05", 
    #           target_capacity: 20, 
    #         }, 
    #         spot_fleet_request_id: "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE", 
    #         spot_fleet_request_state: "active", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_spot_fleet_requests({
    #     dry_run: false,
    #     max_results: 1,
    #     next_token: "String",
    #     spot_fleet_request_ids: ["String"],
    #   })
    #
    # @example Response structure
    #
    #   resp.next_token #=> String
    #   resp.spot_fleet_request_configs #=> Array
    #   resp.spot_fleet_request_configs[0].activity_status #=> String, one of "error", "pending_fulfillment", "pending_termination", "fulfilled"
    #   resp.spot_fleet_request_configs[0].create_time #=> Time
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.allocation_strategy #=> String, one of "lowestPrice", "diversified", "capacityOptimized"
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.on_demand_allocation_strategy #=> String, one of "lowestPrice", "prioritized"
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.client_token #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.excess_capacity_termination_policy #=> String, one of "noTermination", "default"
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.fulfilled_capacity #=> Float
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.on_demand_fulfilled_capacity #=> Float
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.iam_fleet_role #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications #=> Array
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].security_groups #=> Array
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].security_groups[0].group_name #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].security_groups[0].group_id #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].addressing_type #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].block_device_mappings #=> Array
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].block_device_mappings[0].device_name #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].block_device_mappings[0].virtual_name #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].block_device_mappings[0].ebs.delete_on_termination #=> Boolean
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].block_device_mappings[0].ebs.iops #=> Integer
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].block_device_mappings[0].ebs.snapshot_id #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].block_device_mappings[0].ebs.volume_size #=> Integer
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].block_device_mappings[0].ebs.volume_type #=> String, one of "standard", "io1", "gp2", "sc1", "st1"
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].block_device_mappings[0].ebs.encrypted #=> Boolean
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].block_device_mappings[0].ebs.kms_key_id #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].block_device_mappings[0].no_device #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].ebs_optimized #=> Boolean
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].iam_instance_profile.arn #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].iam_instance_profile.name #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].image_id #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.18xlarge", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge"
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].kernel_id #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].key_name #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].monitoring.enabled #=> Boolean
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].network_interfaces #=> Array
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].network_interfaces[0].associate_public_ip_address #=> Boolean
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].network_interfaces[0].delete_on_termination #=> Boolean
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].network_interfaces[0].description #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].network_interfaces[0].device_index #=> Integer
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].network_interfaces[0].groups #=> Array
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].network_interfaces[0].groups[0] #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].network_interfaces[0].ipv_6_address_count #=> Integer
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].network_interfaces[0].ipv_6_addresses #=> Array
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].network_interfaces[0].ipv_6_addresses[0].ipv_6_address #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].network_interfaces[0].network_interface_id #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].network_interfaces[0].private_ip_address #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].network_interfaces[0].private_ip_addresses #=> Array
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].network_interfaces[0].private_ip_addresses[0].primary #=> Boolean
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].network_interfaces[0].private_ip_addresses[0].private_ip_address #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].network_interfaces[0].secondary_private_ip_address_count #=> Integer
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].network_interfaces[0].subnet_id #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].network_interfaces[0].interface_type #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].placement.availability_zone #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].placement.group_name #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].placement.tenancy #=> String, one of "default", "dedicated", "host"
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].ramdisk_id #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].spot_price #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].subnet_id #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].user_data #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].weighted_capacity #=> Float
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].tag_specifications #=> Array
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].tag_specifications[0].resource_type #=> String, one of "client-vpn-endpoint", "customer-gateway", "dedicated-host", "dhcp-options", "elastic-ip", "fleet", "fpga-image", "host-reservation", "image", "instance", "internet-gateway", "launch-template", "natgateway", "network-acl", "network-interface", "reserved-instances", "route-table", "security-group", "snapshot", "spot-instances-request", "subnet", "traffic-mirror-filter", "traffic-mirror-session", "traffic-mirror-target", "transit-gateway", "transit-gateway-attachment", "transit-gateway-route-table", "volume", "vpc", "vpc-peering-connection", "vpn-connection", "vpn-gateway"
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].tag_specifications[0].tags #=> Array
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].tag_specifications[0].tags[0].key #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_specifications[0].tag_specifications[0].tags[0].value #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_template_configs #=> Array
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_template_configs[0].launch_template_specification.launch_template_id #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_template_configs[0].launch_template_specification.launch_template_name #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_template_configs[0].launch_template_specification.version #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_template_configs[0].overrides #=> Array
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_template_configs[0].overrides[0].instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.18xlarge", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge"
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_template_configs[0].overrides[0].spot_price #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_template_configs[0].overrides[0].subnet_id #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_template_configs[0].overrides[0].availability_zone #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_template_configs[0].overrides[0].weighted_capacity #=> Float
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.launch_template_configs[0].overrides[0].priority #=> Float
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.spot_price #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.target_capacity #=> Integer
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.on_demand_target_capacity #=> Integer
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.on_demand_max_total_price #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.spot_max_total_price #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.terminate_instances_with_expiration #=> Boolean
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.type #=> String, one of "request", "maintain", "instant"
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.valid_from #=> Time
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.valid_until #=> Time
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.replace_unhealthy_instances #=> Boolean
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.instance_interruption_behavior #=> String, one of "hibernate", "stop", "terminate"
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.load_balancers_config.classic_load_balancers_config.classic_load_balancers #=> Array
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.load_balancers_config.classic_load_balancers_config.classic_load_balancers[0].name #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.load_balancers_config.target_groups_config.target_groups #=> Array
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.load_balancers_config.target_groups_config.target_groups[0].arn #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_config.instance_pools_to_use_count #=> Integer
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_id #=> String
    #   resp.spot_fleet_request_configs[0].spot_fleet_request_state #=> String, one of "submitted", "active", "cancelled", "failed", "cancelled_running", "cancelled_terminating", "modifying"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetRequests AWS API Documentation
    #
    # @overload describe_spot_fleet_requests(params = {})
    # @param [Hash] params ({})
    def describe_spot_fleet_requests(params = {}, options = {})
      req = build_request(:describe_spot_fleet_requests, params)
      req.send_request(options)
    end

    # Describes the specified Spot Instance requests.
    #
    # You can use `DescribeSpotInstanceRequests` to find a running Spot
    # Instance by examining the response. If the status of the Spot Instance
    # is `fulfilled`, the instance ID appears in the response and contains
    # the identifier of the instance. Alternatively, you can use
    # DescribeInstances with a filter to look for instances where the
    # instance lifecycle is `spot`.
    #
    # We recommend that you set `MaxResults` to a value between 5 and 1000
    # to limit the number of results returned. This paginates the output,
    # which makes the list more manageable and returns the results faster.
    # If the list of results exceeds your `MaxResults` value, then that
    # number of results is returned along with a `NextToken` value that can
    # be passed to a subsequent `DescribeSpotInstanceRequests` request to
    # retrieve the remaining results.
    #
    # Spot Instance requests are deleted four hours after they are canceled
    # and their instances are terminated.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `availability-zone-group` - The Availability Zone group.
    #
    #   * `create-time` - The time stamp when the Spot Instance request was
    #     created.
    #
    #   * `fault-code` - The fault code related to the request.
    #
    #   * `fault-message` - The fault message related to the request.
    #
    #   * `instance-id` - The ID of the instance that fulfilled the request.
    #
    #   * `launch-group` - The Spot Instance launch group.
    #
    #   * `launch.block-device-mapping.delete-on-termination` - Indicates
    #     whether the EBS volume is deleted on instance termination.
    #
    #   * `launch.block-device-mapping.device-name` - The device name for the
    #     volume in the block device mapping (for example, `/dev/sdh` or
    #     `xvdh`).
    #
    #   * `launch.block-device-mapping.snapshot-id` - The ID of the snapshot
    #     for the EBS volume.
    #
    #   * `launch.block-device-mapping.volume-size` - The size of the EBS
    #     volume, in GiB.
    #
    #   * `launch.block-device-mapping.volume-type` - The type of EBS volume:
    #     `gp2` for General Purpose SSD, `io1` for Provisioned IOPS SSD, `st1`
    #     for Throughput Optimized HDD, `sc1`for Cold HDD, or `standard` for
    #     Magnetic.
    #
    #   * `launch.group-id` - The ID of the security group for the instance.
    #
    #   * `launch.group-name` - The name of the security group for the
    #     instance.
    #
    #   * `launch.image-id` - The ID of the AMI.
    #
    #   * `launch.instance-type` - The type of instance (for example,
    #     `m3.medium`).
    #
    #   * `launch.kernel-id` - The kernel ID.
    #
    #   * `launch.key-name` - The name of the key pair the instance launched
    #     with.
    #
    #   * `launch.monitoring-enabled` - Whether detailed monitoring is enabled
    #     for the Spot Instance.
    #
    #   * `launch.ramdisk-id` - The RAM disk ID.
    #
    #   * `launched-availability-zone` - The Availability Zone in which the
    #     request is launched.
    #
    #   * `network-interface.addresses.primary` - Indicates whether the IP
    #     address is the primary private IP address.
    #
    #   * `network-interface.delete-on-termination` - Indicates whether the
    #     network interface is deleted when the instance is terminated.
    #
    #   * `network-interface.description` - A description of the network
    #     interface.
    #
    #   * `network-interface.device-index` - The index of the device for the
    #     network interface attachment on the instance.
    #
    #   * `network-interface.group-id` - The ID of the security group
    #     associated with the network interface.
    #
    #   * `network-interface.network-interface-id` - The ID of the network
    #     interface.
    #
    #   * `network-interface.private-ip-address` - The primary private IP
    #     address of the network interface.
    #
    #   * `network-interface.subnet-id` - The ID of the subnet for the
    #     instance.
    #
    #   * `product-description` - The product description associated with the
    #     instance (`Linux/UNIX` \| `Windows`).
    #
    #   * `spot-instance-request-id` - The Spot Instance request ID.
    #
    #   * `spot-price` - The maximum hourly price for any Spot Instance
    #     launched to fulfill the request.
    #
    #   * `state` - The state of the Spot Instance request (`open` \| `active`
    #     \| `closed` \| `cancelled` \| `failed`). Spot request status
    #     information can help you track your Amazon EC2 Spot Instance
    #     requests. For more information, see [Spot Request Status][1] in the
    #     *Amazon EC2 User Guide for Linux Instances*.
    #
    #   * `status-code` - The short code describing the most recent evaluation
    #     of your Spot Instance request.
    #
    #   * `status-message` - The message explaining the status of the Spot
    #     Instance request.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `type` - The type of Spot Instance request (`one-time` \|
    #     `persistent`).
    #
    #   * `valid-from` - The start date of the request.
    #
    #   * `valid-until` - The end date of the request.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<String>] :spot_instance_request_ids
    #   One or more Spot Instance request IDs.
    #
    # @option params [String] :next_token
    #   The token to request the next set of results. This value is `null`
    #   when there are no more results to return.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. Specify a
    #   value between 5 and 1000. To retrieve the remaining results, make
    #   another call with the returned `NextToken` value.
    #
    # @return [Types::DescribeSpotInstanceRequestsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeSpotInstanceRequestsResult#spot_instance_requests #spot_instance_requests} => Array&lt;Types::SpotInstanceRequest&gt;
    #   * {Types::DescribeSpotInstanceRequestsResult#next_token #next_token} => String
    #
    #
    # @example Example: To describe a Spot Instance request
    #
    #   # This example describes the specified Spot Instance request.
    #
    #   resp = client.describe_spot_instance_requests({
    #     spot_instance_request_ids: [
    #       "sir-08b93456", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     spot_instance_requests: [
    #       {
    #         create_time: Time.parse("2014-04-30T18:14:55.000Z"), 
    #         instance_id: "i-1234567890abcdef0", 
    #         launch_specification: {
    #           block_device_mappings: [
    #             {
    #               device_name: "/dev/sda1", 
    #               ebs: {
    #                 delete_on_termination: true, 
    #                 volume_size: 8, 
    #                 volume_type: "standard", 
    #               }, 
    #             }, 
    #           ], 
    #           ebs_optimized: false, 
    #           image_id: "ami-7aba833f", 
    #           instance_type: "m1.small", 
    #           key_name: "my-key-pair", 
    #           security_groups: [
    #             {
    #               group_id: "sg-e38f24a7", 
    #               group_name: "my-security-group", 
    #             }, 
    #           ], 
    #         }, 
    #         launched_availability_zone: "us-west-1b", 
    #         product_description: "Linux/UNIX", 
    #         spot_instance_request_id: "sir-08b93456", 
    #         spot_price: "0.010000", 
    #         state: "active", 
    #         status: {
    #           code: "fulfilled", 
    #           message: "Your Spot request is fulfilled.", 
    #           update_time: Time.parse("2014-04-30T18:16:21.000Z"), 
    #         }, 
    #         type: "one-time", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_spot_instance_requests({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     dry_run: false,
    #     spot_instance_request_ids: ["String"],
    #     next_token: "String",
    #     max_results: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.spot_instance_requests #=> Array
    #   resp.spot_instance_requests[0].actual_block_hourly_price #=> String
    #   resp.spot_instance_requests[0].availability_zone_group #=> String
    #   resp.spot_instance_requests[0].block_duration_minutes #=> Integer
    #   resp.spot_instance_requests[0].create_time #=> Time
    #   resp.spot_instance_requests[0].fault.code #=> String
    #   resp.spot_instance_requests[0].fault.message #=> String
    #   resp.spot_instance_requests[0].instance_id #=> String
    #   resp.spot_instance_requests[0].launch_group #=> String
    #   resp.spot_instance_requests[0].launch_specification.user_data #=> String
    #   resp.spot_instance_requests[0].launch_specification.security_groups #=> Array
    #   resp.spot_instance_requests[0].launch_specification.security_groups[0].group_name #=> String
    #   resp.spot_instance_requests[0].launch_specification.security_groups[0].group_id #=> String
    #   resp.spot_instance_requests[0].launch_specification.addressing_type #=> String
    #   resp.spot_instance_requests[0].launch_specification.block_device_mappings #=> Array
    #   resp.spot_instance_requests[0].launch_specification.block_device_mappings[0].device_name #=> String
    #   resp.spot_instance_requests[0].launch_specification.block_device_mappings[0].virtual_name #=> String
    #   resp.spot_instance_requests[0].launch_specification.block_device_mappings[0].ebs.delete_on_termination #=> Boolean
    #   resp.spot_instance_requests[0].launch_specification.block_device_mappings[0].ebs.iops #=> Integer
    #   resp.spot_instance_requests[0].launch_specification.block_device_mappings[0].ebs.snapshot_id #=> String
    #   resp.spot_instance_requests[0].launch_specification.block_device_mappings[0].ebs.volume_size #=> Integer
    #   resp.spot_instance_requests[0].launch_specification.block_device_mappings[0].ebs.volume_type #=> String, one of "standard", "io1", "gp2", "sc1", "st1"
    #   resp.spot_instance_requests[0].launch_specification.block_device_mappings[0].ebs.encrypted #=> Boolean
    #   resp.spot_instance_requests[0].launch_specification.block_device_mappings[0].ebs.kms_key_id #=> String
    #   resp.spot_instance_requests[0].launch_specification.block_device_mappings[0].no_device #=> String
    #   resp.spot_instance_requests[0].launch_specification.ebs_optimized #=> Boolean
    #   resp.spot_instance_requests[0].launch_specification.iam_instance_profile.arn #=> String
    #   resp.spot_instance_requests[0].launch_specification.iam_instance_profile.name #=> String
    #   resp.spot_instance_requests[0].launch_specification.image_id #=> String
    #   resp.spot_instance_requests[0].launch_specification.instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.18xlarge", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge"
    #   resp.spot_instance_requests[0].launch_specification.kernel_id #=> String
    #   resp.spot_instance_requests[0].launch_specification.key_name #=> String
    #   resp.spot_instance_requests[0].launch_specification.network_interfaces #=> Array
    #   resp.spot_instance_requests[0].launch_specification.network_interfaces[0].associate_public_ip_address #=> Boolean
    #   resp.spot_instance_requests[0].launch_specification.network_interfaces[0].delete_on_termination #=> Boolean
    #   resp.spot_instance_requests[0].launch_specification.network_interfaces[0].description #=> String
    #   resp.spot_instance_requests[0].launch_specification.network_interfaces[0].device_index #=> Integer
    #   resp.spot_instance_requests[0].launch_specification.network_interfaces[0].groups #=> Array
    #   resp.spot_instance_requests[0].launch_specification.network_interfaces[0].groups[0] #=> String
    #   resp.spot_instance_requests[0].launch_specification.network_interfaces[0].ipv_6_address_count #=> Integer
    #   resp.spot_instance_requests[0].launch_specification.network_interfaces[0].ipv_6_addresses #=> Array
    #   resp.spot_instance_requests[0].launch_specification.network_interfaces[0].ipv_6_addresses[0].ipv_6_address #=> String
    #   resp.spot_instance_requests[0].launch_specification.network_interfaces[0].network_interface_id #=> String
    #   resp.spot_instance_requests[0].launch_specification.network_interfaces[0].private_ip_address #=> String
    #   resp.spot_instance_requests[0].launch_specification.network_interfaces[0].private_ip_addresses #=> Array
    #   resp.spot_instance_requests[0].launch_specification.network_interfaces[0].private_ip_addresses[0].primary #=> Boolean
    #   resp.spot_instance_requests[0].launch_specification.network_interfaces[0].private_ip_addresses[0].private_ip_address #=> String
    #   resp.spot_instance_requests[0].launch_specification.network_interfaces[0].secondary_private_ip_address_count #=> Integer
    #   resp.spot_instance_requests[0].launch_specification.network_interfaces[0].subnet_id #=> String
    #   resp.spot_instance_requests[0].launch_specification.network_interfaces[0].interface_type #=> String
    #   resp.spot_instance_requests[0].launch_specification.placement.availability_zone #=> String
    #   resp.spot_instance_requests[0].launch_specification.placement.group_name #=> String
    #   resp.spot_instance_requests[0].launch_specification.placement.tenancy #=> String, one of "default", "dedicated", "host"
    #   resp.spot_instance_requests[0].launch_specification.ramdisk_id #=> String
    #   resp.spot_instance_requests[0].launch_specification.subnet_id #=> String
    #   resp.spot_instance_requests[0].launch_specification.monitoring.enabled #=> Boolean
    #   resp.spot_instance_requests[0].launched_availability_zone #=> String
    #   resp.spot_instance_requests[0].product_description #=> String, one of "Linux/UNIX", "Linux/UNIX (Amazon VPC)", "Windows", "Windows (Amazon VPC)"
    #   resp.spot_instance_requests[0].spot_instance_request_id #=> String
    #   resp.spot_instance_requests[0].spot_price #=> String
    #   resp.spot_instance_requests[0].state #=> String, one of "open", "active", "closed", "cancelled", "failed"
    #   resp.spot_instance_requests[0].status.code #=> String
    #   resp.spot_instance_requests[0].status.message #=> String
    #   resp.spot_instance_requests[0].status.update_time #=> Time
    #   resp.spot_instance_requests[0].tags #=> Array
    #   resp.spot_instance_requests[0].tags[0].key #=> String
    #   resp.spot_instance_requests[0].tags[0].value #=> String
    #   resp.spot_instance_requests[0].type #=> String, one of "one-time", "persistent"
    #   resp.spot_instance_requests[0].valid_from #=> Time
    #   resp.spot_instance_requests[0].valid_until #=> Time
    #   resp.spot_instance_requests[0].instance_interruption_behavior #=> String, one of "hibernate", "stop", "terminate"
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotInstanceRequests AWS API Documentation
    #
    # @overload describe_spot_instance_requests(params = {})
    # @param [Hash] params ({})
    def describe_spot_instance_requests(params = {}, options = {})
      req = build_request(:describe_spot_instance_requests, params)
      req.send_request(options)
    end

    # Describes the Spot price history. For more information, see [Spot
    # Instance Pricing History][1] in the *Amazon EC2 User Guide for Linux
    # Instances*.
    #
    # When you specify a start and end time, this operation returns the
    # prices of the instance types within the time range that you specified
    # and the time when the price changed. The price is valid within the
    # time period that you specified; the response merely indicates the last
    # time that the price changed.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances-history.html
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `availability-zone` - The Availability Zone for which prices should
    #     be returned.
    #
    #   * `instance-type` - The type of instance (for example, `m3.medium`).
    #
    #   * `product-description` - The product description for the Spot price
    #     (`Linux/UNIX` \| `SUSE Linux` \| `Windows` \| `Linux/UNIX (Amazon
    #     VPC)` \| `SUSE Linux (Amazon VPC)` \| `Windows (Amazon VPC)`).
    #
    #   * `spot-price` - The Spot price. The value must match exactly (or use
    #     wildcards; greater than or less than comparison is not supported).
    #
    #   * `timestamp` - The time stamp of the Spot price history, in UTC
    #     format (for example, *YYYY*-*MM*-*DD*T*HH*\:*MM*\:*SS*Z). You can
    #     use wildcards (* and ?). Greater than or less than comparison is
    #     not supported.
    #
    # @option params [String] :availability_zone
    #   Filters the results by the specified Availability Zone.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Time,DateTime,Date,Integer,String] :end_time
    #   The date and time, up to the current date, from which to stop
    #   retrieving the price history data, in UTC format (for example,
    #   *YYYY*-*MM*-*DD*T*HH*\:*MM*\:*SS*Z).
    #
    # @option params [Array<String>] :instance_types
    #   Filters the results by the specified instance types.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. Specify a
    #   value between 1 and 1000. The default value is 1000. To retrieve the
    #   remaining results, make another call with the returned `NextToken`
    #   value.
    #
    # @option params [String] :next_token
    #   The token for the next set of results.
    #
    # @option params [Array<String>] :product_descriptions
    #   Filters the results by the specified basic product descriptions.
    #
    # @option params [Time,DateTime,Date,Integer,String] :start_time
    #   The date and time, up to the past 90 days, from which to start
    #   retrieving the price history data, in UTC format (for example,
    #   *YYYY*-*MM*-*DD*T*HH*\:*MM*\:*SS*Z).
    #
    # @return [Types::DescribeSpotPriceHistoryResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeSpotPriceHistoryResult#next_token #next_token} => String
    #   * {Types::DescribeSpotPriceHistoryResult#spot_price_history #spot_price_history} => Array&lt;Types::SpotPrice&gt;
    #
    #
    # @example Example: To describe Spot price history for Linux/UNIX (Amazon VPC)
    #
    #   # This example returns the Spot Price history for m1.xlarge, Linux/UNIX (Amazon VPC) instances for a particular day in
    #   # January.
    #
    #   resp = client.describe_spot_price_history({
    #     end_time: Time.parse("2014-01-06T08:09:10"), 
    #     instance_types: [
    #       "m1.xlarge", 
    #     ], 
    #     product_descriptions: [
    #       "Linux/UNIX (Amazon VPC)", 
    #     ], 
    #     start_time: Time.parse("2014-01-06T07:08:09"), 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     spot_price_history: [
    #       {
    #         availability_zone: "us-west-1a", 
    #         instance_type: "m1.xlarge", 
    #         product_description: "Linux/UNIX (Amazon VPC)", 
    #         spot_price: "0.080000", 
    #         timestamp: Time.parse("2014-01-06T04:32:53.000Z"), 
    #       }, 
    #       {
    #         availability_zone: "us-west-1c", 
    #         instance_type: "m1.xlarge", 
    #         product_description: "Linux/UNIX (Amazon VPC)", 
    #         spot_price: "0.080000", 
    #         timestamp: Time.parse("2014-01-05T11:28:26.000Z"), 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_spot_price_history({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     availability_zone: "String",
    #     dry_run: false,
    #     end_time: Time.now,
    #     instance_types: ["t1.micro"], # accepts t1.micro, t2.nano, t2.micro, t2.small, t2.medium, t2.large, t2.xlarge, t2.2xlarge, t3.nano, t3.micro, t3.small, t3.medium, t3.large, t3.xlarge, t3.2xlarge, t3a.nano, t3a.micro, t3a.small, t3a.medium, t3a.large, t3a.xlarge, t3a.2xlarge, m1.small, m1.medium, m1.large, m1.xlarge, m3.medium, m3.large, m3.xlarge, m3.2xlarge, m4.large, m4.xlarge, m4.2xlarge, m4.4xlarge, m4.10xlarge, m4.16xlarge, m2.xlarge, m2.2xlarge, m2.4xlarge, cr1.8xlarge, r3.large, r3.xlarge, r3.2xlarge, r3.4xlarge, r3.8xlarge, r4.large, r4.xlarge, r4.2xlarge, r4.4xlarge, r4.8xlarge, r4.16xlarge, r5.large, r5.xlarge, r5.2xlarge, r5.4xlarge, r5.8xlarge, r5.12xlarge, r5.16xlarge, r5.24xlarge, r5.metal, r5a.large, r5a.xlarge, r5a.2xlarge, r5a.4xlarge, r5a.8xlarge, r5a.12xlarge, r5a.16xlarge, r5a.24xlarge, r5d.large, r5d.xlarge, r5d.2xlarge, r5d.4xlarge, r5d.8xlarge, r5d.12xlarge, r5d.16xlarge, r5d.24xlarge, r5d.metal, r5ad.large, r5ad.xlarge, r5ad.2xlarge, r5ad.4xlarge, r5ad.8xlarge, r5ad.12xlarge, r5ad.16xlarge, r5ad.24xlarge, x1.16xlarge, x1.32xlarge, x1e.xlarge, x1e.2xlarge, x1e.4xlarge, x1e.8xlarge, x1e.16xlarge, x1e.32xlarge, i2.xlarge, i2.2xlarge, i2.4xlarge, i2.8xlarge, i3.large, i3.xlarge, i3.2xlarge, i3.4xlarge, i3.8xlarge, i3.16xlarge, i3.metal, i3en.large, i3en.xlarge, i3en.2xlarge, i3en.3xlarge, i3en.6xlarge, i3en.12xlarge, i3en.24xlarge, i3en.metal, hi1.4xlarge, hs1.8xlarge, c1.medium, c1.xlarge, c3.large, c3.xlarge, c3.2xlarge, c3.4xlarge, c3.8xlarge, c4.large, c4.xlarge, c4.2xlarge, c4.4xlarge, c4.8xlarge, c5.large, c5.xlarge, c5.2xlarge, c5.4xlarge, c5.9xlarge, c5.12xlarge, c5.18xlarge, c5.24xlarge, c5.metal, c5d.large, c5d.xlarge, c5d.2xlarge, c5d.4xlarge, c5d.9xlarge, c5d.18xlarge, c5n.large, c5n.xlarge, c5n.2xlarge, c5n.4xlarge, c5n.9xlarge, c5n.18xlarge, cc1.4xlarge, cc2.8xlarge, g2.2xlarge, g2.8xlarge, g3.4xlarge, g3.8xlarge, g3.16xlarge, g3s.xlarge, cg1.4xlarge, p2.xlarge, p2.8xlarge, p2.16xlarge, p3.2xlarge, p3.8xlarge, p3.16xlarge, p3dn.24xlarge, d2.xlarge, d2.2xlarge, d2.4xlarge, d2.8xlarge, f1.2xlarge, f1.4xlarge, f1.16xlarge, m5.large, m5.xlarge, m5.2xlarge, m5.4xlarge, m5.8xlarge, m5.12xlarge, m5.16xlarge, m5.24xlarge, m5.metal, m5a.large, m5a.xlarge, m5a.2xlarge, m5a.4xlarge, m5a.8xlarge, m5a.12xlarge, m5a.16xlarge, m5a.24xlarge, m5d.large, m5d.xlarge, m5d.2xlarge, m5d.4xlarge, m5d.8xlarge, m5d.12xlarge, m5d.16xlarge, m5d.24xlarge, m5d.metal, m5ad.large, m5ad.xlarge, m5ad.2xlarge, m5ad.4xlarge, m5ad.8xlarge, m5ad.12xlarge, m5ad.16xlarge, m5ad.24xlarge, h1.2xlarge, h1.4xlarge, h1.8xlarge, h1.16xlarge, z1d.large, z1d.xlarge, z1d.2xlarge, z1d.3xlarge, z1d.6xlarge, z1d.12xlarge, z1d.metal, u-6tb1.metal, u-9tb1.metal, u-12tb1.metal, a1.medium, a1.large, a1.xlarge, a1.2xlarge, a1.4xlarge
    #     max_results: 1,
    #     next_token: "String",
    #     product_descriptions: ["String"],
    #     start_time: Time.now,
    #   })
    #
    # @example Response structure
    #
    #   resp.next_token #=> String
    #   resp.spot_price_history #=> Array
    #   resp.spot_price_history[0].availability_zone #=> String
    #   resp.spot_price_history[0].instance_type #=> String, one of "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "cr1.8xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "hi1.4xlarge", "hs1.8xlarge", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.18xlarge", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "cc1.4xlarge", "cc2.8xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "cg1.4xlarge", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge"
    #   resp.spot_price_history[0].product_description #=> String, one of "Linux/UNIX", "Linux/UNIX (Amazon VPC)", "Windows", "Windows (Amazon VPC)"
    #   resp.spot_price_history[0].spot_price #=> String
    #   resp.spot_price_history[0].timestamp #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotPriceHistory AWS API Documentation
    #
    # @overload describe_spot_price_history(params = {})
    # @param [Hash] params ({})
    def describe_spot_price_history(params = {}, options = {})
      req = build_request(:describe_spot_price_history, params)
      req.send_request(options)
    end

    # \[VPC only\] Describes the stale security group rules for security
    # groups in a specified VPC. Rules are stale when they reference a
    # deleted security group in a peer VPC, or a security group in a peer
    # VPC for which the VPC peering connection has been deleted.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Integer] :max_results
    #   The maximum number of items to return for this request. The request
    #   returns a token that you can specify in a subsequent call to get the
    #   next set of results.
    #
    # @option params [String] :next_token
    #   The token for the next set of items to return. (You received this
    #   token from a prior call.)
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @return [Types::DescribeStaleSecurityGroupsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeStaleSecurityGroupsResult#next_token #next_token} => String
    #   * {Types::DescribeStaleSecurityGroupsResult#stale_security_group_set #stale_security_group_set} => Array&lt;Types::StaleSecurityGroup&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_stale_security_groups({
    #     dry_run: false,
    #     max_results: 1,
    #     next_token: "DescribeStaleSecurityGroupsNextToken",
    #     vpc_id: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.next_token #=> String
    #   resp.stale_security_group_set #=> Array
    #   resp.stale_security_group_set[0].description #=> String
    #   resp.stale_security_group_set[0].group_id #=> String
    #   resp.stale_security_group_set[0].group_name #=> String
    #   resp.stale_security_group_set[0].stale_ip_permissions #=> Array
    #   resp.stale_security_group_set[0].stale_ip_permissions[0].from_port #=> Integer
    #   resp.stale_security_group_set[0].stale_ip_permissions[0].ip_protocol #=> String
    #   resp.stale_security_group_set[0].stale_ip_permissions[0].ip_ranges #=> Array
    #   resp.stale_security_group_set[0].stale_ip_permissions[0].ip_ranges[0] #=> String
    #   resp.stale_security_group_set[0].stale_ip_permissions[0].prefix_list_ids #=> Array
    #   resp.stale_security_group_set[0].stale_ip_permissions[0].prefix_list_ids[0] #=> String
    #   resp.stale_security_group_set[0].stale_ip_permissions[0].to_port #=> Integer
    #   resp.stale_security_group_set[0].stale_ip_permissions[0].user_id_group_pairs #=> Array
    #   resp.stale_security_group_set[0].stale_ip_permissions[0].user_id_group_pairs[0].description #=> String
    #   resp.stale_security_group_set[0].stale_ip_permissions[0].user_id_group_pairs[0].group_id #=> String
    #   resp.stale_security_group_set[0].stale_ip_permissions[0].user_id_group_pairs[0].group_name #=> String
    #   resp.stale_security_group_set[0].stale_ip_permissions[0].user_id_group_pairs[0].peering_status #=> String
    #   resp.stale_security_group_set[0].stale_ip_permissions[0].user_id_group_pairs[0].user_id #=> String
    #   resp.stale_security_group_set[0].stale_ip_permissions[0].user_id_group_pairs[0].vpc_id #=> String
    #   resp.stale_security_group_set[0].stale_ip_permissions[0].user_id_group_pairs[0].vpc_peering_connection_id #=> String
    #   resp.stale_security_group_set[0].stale_ip_permissions_egress #=> Array
    #   resp.stale_security_group_set[0].stale_ip_permissions_egress[0].from_port #=> Integer
    #   resp.stale_security_group_set[0].stale_ip_permissions_egress[0].ip_protocol #=> String
    #   resp.stale_security_group_set[0].stale_ip_permissions_egress[0].ip_ranges #=> Array
    #   resp.stale_security_group_set[0].stale_ip_permissions_egress[0].ip_ranges[0] #=> String
    #   resp.stale_security_group_set[0].stale_ip_permissions_egress[0].prefix_list_ids #=> Array
    #   resp.stale_security_group_set[0].stale_ip_permissions_egress[0].prefix_list_ids[0] #=> String
    #   resp.stale_security_group_set[0].stale_ip_permissions_egress[0].to_port #=> Integer
    #   resp.stale_security_group_set[0].stale_ip_permissions_egress[0].user_id_group_pairs #=> Array
    #   resp.stale_security_group_set[0].stale_ip_permissions_egress[0].user_id_group_pairs[0].description #=> String
    #   resp.stale_security_group_set[0].stale_ip_permissions_egress[0].user_id_group_pairs[0].group_id #=> String
    #   resp.stale_security_group_set[0].stale_ip_permissions_egress[0].user_id_group_pairs[0].group_name #=> String
    #   resp.stale_security_group_set[0].stale_ip_permissions_egress[0].user_id_group_pairs[0].peering_status #=> String
    #   resp.stale_security_group_set[0].stale_ip_permissions_egress[0].user_id_group_pairs[0].user_id #=> String
    #   resp.stale_security_group_set[0].stale_ip_permissions_egress[0].user_id_group_pairs[0].vpc_id #=> String
    #   resp.stale_security_group_set[0].stale_ip_permissions_egress[0].user_id_group_pairs[0].vpc_peering_connection_id #=> String
    #   resp.stale_security_group_set[0].vpc_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeStaleSecurityGroups AWS API Documentation
    #
    # @overload describe_stale_security_groups(params = {})
    # @param [Hash] params ({})
    def describe_stale_security_groups(params = {}, options = {})
      req = build_request(:describe_stale_security_groups, params)
      req.send_request(options)
    end

    # Describes one or more of your subnets.
    #
    # For more information, see [Your VPC and Subnets][1] in the *Amazon
    # Virtual Private Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters.
    #
    #   * `availability-zone` - The Availability Zone for the subnet. You can
    #     also use `availabilityZone` as the filter name.
    #
    #   * `availability-zone-id` - The ID of the Availability Zone for the
    #     subnet. You can also use `availabilityZoneId` as the filter name.
    #
    #   * `available-ip-address-count` - The number of IPv4 addresses in the
    #     subnet that are available.
    #
    #   * `cidr-block` - The IPv4 CIDR block of the subnet. The CIDR block you
    #     specify must exactly match the subnet's CIDR block for information
    #     to be returned for the subnet. You can also use `cidr` or
    #     `cidrBlock` as the filter names.
    #
    #   * `default-for-az` - Indicates whether this is the default subnet for
    #     the Availability Zone. You can also use `defaultForAz` as the filter
    #     name.
    #
    #   * `ipv6-cidr-block-association.ipv6-cidr-block` - An IPv6 CIDR block
    #     associated with the subnet.
    #
    #   * `ipv6-cidr-block-association.association-id` - An association ID for
    #     an IPv6 CIDR block associated with the subnet.
    #
    #   * `ipv6-cidr-block-association.state` - The state of an IPv6 CIDR
    #     block associated with the subnet.
    #
    #   * `owner-id` - The ID of the AWS account that owns the subnet.
    #
    #   * `state` - The state of the subnet (`pending` \| `available`).
    #
    #   * `subnet-arn` - The Amazon Resource Name (ARN) of the subnet.
    #
    #   * `subnet-id` - The ID of the subnet.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned to
    #     the resource. Use the tag key in the filter name and the tag value
    #     as the filter value. For example, to find all resources that have a
    #     tag with the key `Owner` and the value `TeamA`, specify `tag:Owner`
    #     for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `vpc-id` - The ID of the VPC for the subnet.
    #
    # @option params [Array<String>] :subnet_ids
    #   One or more subnet IDs.
    #
    #   Default: Describes all your subnets.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @return [Types::DescribeSubnetsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeSubnetsResult#subnets #subnets} => Array&lt;Types::Subnet&gt;
    #   * {Types::DescribeSubnetsResult#next_token #next_token} => String
    #
    #
    # @example Example: To describe the subnets for a VPC
    #
    #   # This example describes the subnets for the specified VPC.
    #
    #   resp = client.describe_subnets({
    #     filters: [
    #       {
    #         name: "vpc-id", 
    #         values: [
    #           "vpc-a01106c2", 
    #         ], 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     subnets: [
    #       {
    #         availability_zone: "us-east-1c", 
    #         available_ip_address_count: 251, 
    #         cidr_block: "10.0.1.0/24", 
    #         default_for_az: false, 
    #         map_public_ip_on_launch: false, 
    #         state: "available", 
    #         subnet_id: "subnet-9d4a7b6c", 
    #         vpc_id: "vpc-a01106c2", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_subnets({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     subnet_ids: ["String"],
    #     dry_run: false,
    #     next_token: "String",
    #     max_results: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.subnets #=> Array
    #   resp.subnets[0].availability_zone #=> String
    #   resp.subnets[0].availability_zone_id #=> String
    #   resp.subnets[0].available_ip_address_count #=> Integer
    #   resp.subnets[0].cidr_block #=> String
    #   resp.subnets[0].default_for_az #=> Boolean
    #   resp.subnets[0].map_public_ip_on_launch #=> Boolean
    #   resp.subnets[0].state #=> String, one of "pending", "available"
    #   resp.subnets[0].subnet_id #=> String
    #   resp.subnets[0].vpc_id #=> String
    #   resp.subnets[0].owner_id #=> String
    #   resp.subnets[0].assign_ipv_6_address_on_creation #=> Boolean
    #   resp.subnets[0].ipv_6_cidr_block_association_set #=> Array
    #   resp.subnets[0].ipv_6_cidr_block_association_set[0].association_id #=> String
    #   resp.subnets[0].ipv_6_cidr_block_association_set[0].ipv_6_cidr_block #=> String
    #   resp.subnets[0].ipv_6_cidr_block_association_set[0].ipv_6_cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.subnets[0].ipv_6_cidr_block_association_set[0].ipv_6_cidr_block_state.status_message #=> String
    #   resp.subnets[0].tags #=> Array
    #   resp.subnets[0].tags[0].key #=> String
    #   resp.subnets[0].tags[0].value #=> String
    #   resp.subnets[0].subnet_arn #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSubnets AWS API Documentation
    #
    # @overload describe_subnets(params = {})
    # @param [Hash] params ({})
    def describe_subnets(params = {}, options = {})
      req = build_request(:describe_subnets, params)
      req.send_request(options)
    end

    # Describes the specified tags for your EC2 resources.
    #
    # For more information about tags, see [Tagging Your Resources][1] in
    # the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `key` - The tag key.
    #
    #   * `resource-id` - The ID of the resource.
    #
    #   * `resource-type` - The resource type (`customer-gateway` \|
    #     `dedicated-host` \| `dhcp-options` \| `elastic-ip` \| `fleet` \|
    #     `fpga-image` \| `image` \| `instance` \| `host-reservation` \|
    #     `internet-gateway` \| `launch-template` \| `natgateway` \|
    #     `network-acl` \| `network-interface` \| `reserved-instances` \|
    #     `route-table` \| `security-group` \| `snapshot` \|
    #     `spot-instances-request` \| `subnet` \| `volume` \| `vpc` \|
    #     `vpc-peering-connection` \| `vpn-connection` \| `vpn-gateway`).
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of the tag. For
    #     example, specify "tag:Owner" for the filter name and "TeamA" for
    #     the filter value to find resources with the tag "Owner=TeamA".
    #
    #   * `value` - The tag value.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return in a single call. This value
    #   can be between 5 and 1000. To retrieve the remaining results, make
    #   another call with the returned `NextToken` value.
    #
    # @option params [String] :next_token
    #   The token to retrieve the next page of results.
    #
    # @return [Types::DescribeTagsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeTagsResult#next_token #next_token} => String
    #   * {Types::DescribeTagsResult#tags #tags} => Array&lt;Types::TagDescription&gt;
    #
    #
    # @example Example: To describe the tags for a single resource
    #
    #   # This example describes the tags for the specified instance.
    #
    #   resp = client.describe_tags({
    #     filters: [
    #       {
    #         name: "resource-id", 
    #         values: [
    #           "i-1234567890abcdef8", 
    #         ], 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     tags: [
    #       {
    #         key: "Stack", 
    #         resource_id: "i-1234567890abcdef8", 
    #         resource_type: "instance", 
    #         value: "test", 
    #       }, 
    #       {
    #         key: "Name", 
    #         resource_id: "i-1234567890abcdef8", 
    #         resource_type: "instance", 
    #         value: "Beta Server", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_tags({
    #     dry_run: false,
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #     next_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.next_token #=> String
    #   resp.tags #=> Array
    #   resp.tags[0].key #=> String
    #   resp.tags[0].resource_id #=> String
    #   resp.tags[0].resource_type #=> String, one of "client-vpn-endpoint", "customer-gateway", "dedicated-host", "dhcp-options", "elastic-ip", "fleet", "fpga-image", "host-reservation", "image", "instance", "internet-gateway", "launch-template", "natgateway", "network-acl", "network-interface", "reserved-instances", "route-table", "security-group", "snapshot", "spot-instances-request", "subnet", "traffic-mirror-filter", "traffic-mirror-session", "traffic-mirror-target", "transit-gateway", "transit-gateway-attachment", "transit-gateway-route-table", "volume", "vpc", "vpc-peering-connection", "vpn-connection", "vpn-gateway"
    #   resp.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTags AWS API Documentation
    #
    # @overload describe_tags(params = {})
    # @param [Hash] params ({})
    def describe_tags(params = {}, options = {})
      req = build_request(:describe_tags, params)
      req.send_request(options)
    end

    # Describes one or more Traffic Mirror filters.
    #
    # @option params [Array<String>] :traffic_mirror_filter_ids
    #   The ID of the Traffic Mirror filter.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters. The possible values are:
    #
    #   * `description`\: The Traffic Mirror filter description.
    #
    #   * `traffic-mirror-filter-id`\: The ID of the Traffic Mirror filter.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @return [Types::DescribeTrafficMirrorFiltersResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeTrafficMirrorFiltersResult#traffic_mirror_filters #traffic_mirror_filters} => Array&lt;Types::TrafficMirrorFilter&gt;
    #   * {Types::DescribeTrafficMirrorFiltersResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_traffic_mirror_filters({
    #     traffic_mirror_filter_ids: ["String"],
    #     dry_run: false,
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #     next_token: "NextToken",
    #   })
    #
    # @example Response structure
    #
    #   resp.traffic_mirror_filters #=> Array
    #   resp.traffic_mirror_filters[0].traffic_mirror_filter_id #=> String
    #   resp.traffic_mirror_filters[0].ingress_filter_rules #=> Array
    #   resp.traffic_mirror_filters[0].ingress_filter_rules[0].traffic_mirror_filter_rule_id #=> String
    #   resp.traffic_mirror_filters[0].ingress_filter_rules[0].traffic_mirror_filter_id #=> String
    #   resp.traffic_mirror_filters[0].ingress_filter_rules[0].traffic_direction #=> String, one of "ingress", "egress"
    #   resp.traffic_mirror_filters[0].ingress_filter_rules[0].rule_number #=> Integer
    #   resp.traffic_mirror_filters[0].ingress_filter_rules[0].rule_action #=> String, one of "accept", "reject"
    #   resp.traffic_mirror_filters[0].ingress_filter_rules[0].protocol #=> Integer
    #   resp.traffic_mirror_filters[0].ingress_filter_rules[0].destination_port_range.from_port #=> Integer
    #   resp.traffic_mirror_filters[0].ingress_filter_rules[0].destination_port_range.to_port #=> Integer
    #   resp.traffic_mirror_filters[0].ingress_filter_rules[0].source_port_range.from_port #=> Integer
    #   resp.traffic_mirror_filters[0].ingress_filter_rules[0].source_port_range.to_port #=> Integer
    #   resp.traffic_mirror_filters[0].ingress_filter_rules[0].destination_cidr_block #=> String
    #   resp.traffic_mirror_filters[0].ingress_filter_rules[0].source_cidr_block #=> String
    #   resp.traffic_mirror_filters[0].ingress_filter_rules[0].description #=> String
    #   resp.traffic_mirror_filters[0].egress_filter_rules #=> Array
    #   resp.traffic_mirror_filters[0].egress_filter_rules[0].traffic_mirror_filter_rule_id #=> String
    #   resp.traffic_mirror_filters[0].egress_filter_rules[0].traffic_mirror_filter_id #=> String
    #   resp.traffic_mirror_filters[0].egress_filter_rules[0].traffic_direction #=> String, one of "ingress", "egress"
    #   resp.traffic_mirror_filters[0].egress_filter_rules[0].rule_number #=> Integer
    #   resp.traffic_mirror_filters[0].egress_filter_rules[0].rule_action #=> String, one of "accept", "reject"
    #   resp.traffic_mirror_filters[0].egress_filter_rules[0].protocol #=> Integer
    #   resp.traffic_mirror_filters[0].egress_filter_rules[0].destination_port_range.from_port #=> Integer
    #   resp.traffic_mirror_filters[0].egress_filter_rules[0].destination_port_range.to_port #=> Integer
    #   resp.traffic_mirror_filters[0].egress_filter_rules[0].source_port_range.from_port #=> Integer
    #   resp.traffic_mirror_filters[0].egress_filter_rules[0].source_port_range.to_port #=> Integer
    #   resp.traffic_mirror_filters[0].egress_filter_rules[0].destination_cidr_block #=> String
    #   resp.traffic_mirror_filters[0].egress_filter_rules[0].source_cidr_block #=> String
    #   resp.traffic_mirror_filters[0].egress_filter_rules[0].description #=> String
    #   resp.traffic_mirror_filters[0].network_services #=> Array
    #   resp.traffic_mirror_filters[0].network_services[0] #=> String, one of "amazon-dns"
    #   resp.traffic_mirror_filters[0].description #=> String
    #   resp.traffic_mirror_filters[0].tags #=> Array
    #   resp.traffic_mirror_filters[0].tags[0].key #=> String
    #   resp.traffic_mirror_filters[0].tags[0].value #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTrafficMirrorFilters AWS API Documentation
    #
    # @overload describe_traffic_mirror_filters(params = {})
    # @param [Hash] params ({})
    def describe_traffic_mirror_filters(params = {}, options = {})
      req = build_request(:describe_traffic_mirror_filters, params)
      req.send_request(options)
    end

    # Describes one or more Traffic Mirror sessions. By default, all Traffic
    # Mirror sessions are described. Alternatively, you can filter the
    # results.
    #
    # @option params [Array<String>] :traffic_mirror_session_ids
    #   The ID of the Traffic Mirror session.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters. The possible values are:
    #
    #   * `description`\: The Traffic Mirror session description.
    #
    #   * `network-interface-id`\: The ID of the Traffic Mirror session
    #     network interface.
    #
    #   * `owner-id`\: The ID of the account that owns the Traffic Mirror
    #     session.
    #
    #   * `packet-length`\: The assigned number of packets to mirror.
    #
    #   * `session-number`\: The assigned session number.
    #
    #   * `traffic-mirror-filter-id`\: The ID of the Traffic Mirror filter.
    #
    #   * `traffic-mirror-session-id`\: The ID of the Traffic Mirror session.
    #
    #   * `traffic-mirror-target-id`\: The ID of the Traffic Mirror target.
    #
    #   * `virtual-network-id`\: The virtual network ID of the Traffic Mirror
    #     session.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @return [Types::DescribeTrafficMirrorSessionsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeTrafficMirrorSessionsResult#traffic_mirror_sessions #traffic_mirror_sessions} => Array&lt;Types::TrafficMirrorSession&gt;
    #   * {Types::DescribeTrafficMirrorSessionsResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_traffic_mirror_sessions({
    #     traffic_mirror_session_ids: ["String"],
    #     dry_run: false,
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #     next_token: "NextToken",
    #   })
    #
    # @example Response structure
    #
    #   resp.traffic_mirror_sessions #=> Array
    #   resp.traffic_mirror_sessions[0].traffic_mirror_session_id #=> String
    #   resp.traffic_mirror_sessions[0].traffic_mirror_target_id #=> String
    #   resp.traffic_mirror_sessions[0].traffic_mirror_filter_id #=> String
    #   resp.traffic_mirror_sessions[0].network_interface_id #=> String
    #   resp.traffic_mirror_sessions[0].owner_id #=> String
    #   resp.traffic_mirror_sessions[0].packet_length #=> Integer
    #   resp.traffic_mirror_sessions[0].session_number #=> Integer
    #   resp.traffic_mirror_sessions[0].virtual_network_id #=> Integer
    #   resp.traffic_mirror_sessions[0].description #=> String
    #   resp.traffic_mirror_sessions[0].tags #=> Array
    #   resp.traffic_mirror_sessions[0].tags[0].key #=> String
    #   resp.traffic_mirror_sessions[0].tags[0].value #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTrafficMirrorSessions AWS API Documentation
    #
    # @overload describe_traffic_mirror_sessions(params = {})
    # @param [Hash] params ({})
    def describe_traffic_mirror_sessions(params = {}, options = {})
      req = build_request(:describe_traffic_mirror_sessions, params)
      req.send_request(options)
    end

    # Information about one or more Traffic Mirror targets.
    #
    # @option params [Array<String>] :traffic_mirror_target_ids
    #   The ID of the Traffic Mirror targets.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters. The possible values are:
    #
    #   * `description`\: The Traffic Mirror target description.
    #
    #   * `network-interface-id`\: The ID of the Traffic Mirror session
    #     network interface.
    #
    #   * `network-load-balancer-arn`\: The Amazon Resource Name (ARN) of the
    #     Network Load Balancer that is associated with the session.
    #
    #   * `owner-id`\: The ID of the account that owns the Traffic Mirror
    #     session.
    #
    #   * `traffic-mirror-target-id`\: The ID of the Traffic Mirror target.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @return [Types::DescribeTrafficMirrorTargetsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeTrafficMirrorTargetsResult#traffic_mirror_targets #traffic_mirror_targets} => Array&lt;Types::TrafficMirrorTarget&gt;
    #   * {Types::DescribeTrafficMirrorTargetsResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_traffic_mirror_targets({
    #     traffic_mirror_target_ids: ["String"],
    #     dry_run: false,
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #     next_token: "NextToken",
    #   })
    #
    # @example Response structure
    #
    #   resp.traffic_mirror_targets #=> Array
    #   resp.traffic_mirror_targets[0].traffic_mirror_target_id #=> String
    #   resp.traffic_mirror_targets[0].network_interface_id #=> String
    #   resp.traffic_mirror_targets[0].network_load_balancer_arn #=> String
    #   resp.traffic_mirror_targets[0].type #=> String, one of "network-interface", "network-load-balancer"
    #   resp.traffic_mirror_targets[0].description #=> String
    #   resp.traffic_mirror_targets[0].owner_id #=> String
    #   resp.traffic_mirror_targets[0].tags #=> Array
    #   resp.traffic_mirror_targets[0].tags[0].key #=> String
    #   resp.traffic_mirror_targets[0].tags[0].value #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTrafficMirrorTargets AWS API Documentation
    #
    # @overload describe_traffic_mirror_targets(params = {})
    # @param [Hash] params ({})
    def describe_traffic_mirror_targets(params = {}, options = {})
      req = build_request(:describe_traffic_mirror_targets, params)
      req.send_request(options)
    end

    # Describes one or more attachments between resources and transit
    # gateways. By default, all attachments are described. Alternatively,
    # you can filter the results by attachment ID, attachment state,
    # resource ID, or resource owner.
    #
    # @option params [Array<String>] :transit_gateway_attachment_ids
    #   The IDs of the attachments.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters. The possible values are:
    #
    #   * `association.state` - The state of the association (`associating` \|
    #     `associated` \| `disassociating`).
    #
    #   * `association.transit-gateway-route-table-id` - The ID of the route
    #     table for the transit gateway.
    #
    #   * `resource-id` - The ID of the resource.
    #
    #   * `resource-owner-id` - The ID of the AWS account that owns the
    #     resource.
    #
    #   * `resource-type` - The resource type (`vpc` \| `vpn`).
    #
    #   * `state` - The state of the attachment (`available` \| `deleted` \|
    #     `deleting` \| `failed` \| `modifying` \| `pendingAcceptance` \|
    #     `pending` \| `rollingBack` \| `rejected` \| `rejecting`).
    #
    #   * `transit-gateway-attachment-id` - The ID of the attachment.
    #
    #   * `transit-gateway-id` - The ID of the transit gateway.
    #
    #   * `transit-gateway-owner-id` - The ID of the AWS account that owns the
    #     transit gateway.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeTransitGatewayAttachmentsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeTransitGatewayAttachmentsResult#transit_gateway_attachments #transit_gateway_attachments} => Array&lt;Types::TransitGatewayAttachment&gt;
    #   * {Types::DescribeTransitGatewayAttachmentsResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_transit_gateway_attachments({
    #     transit_gateway_attachment_ids: ["String"],
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #     next_token: "String",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_attachments #=> Array
    #   resp.transit_gateway_attachments[0].transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_attachments[0].transit_gateway_id #=> String
    #   resp.transit_gateway_attachments[0].transit_gateway_owner_id #=> String
    #   resp.transit_gateway_attachments[0].resource_owner_id #=> String
    #   resp.transit_gateway_attachments[0].resource_type #=> String, one of "vpc", "vpn", "direct-connect-gateway"
    #   resp.transit_gateway_attachments[0].resource_id #=> String
    #   resp.transit_gateway_attachments[0].state #=> String, one of "pendingAcceptance", "rollingBack", "pending", "available", "modifying", "deleting", "deleted", "failed", "rejected", "rejecting", "failing"
    #   resp.transit_gateway_attachments[0].association.transit_gateway_route_table_id #=> String
    #   resp.transit_gateway_attachments[0].association.state #=> String, one of "associating", "associated", "disassociating", "disassociated"
    #   resp.transit_gateway_attachments[0].creation_time #=> Time
    #   resp.transit_gateway_attachments[0].tags #=> Array
    #   resp.transit_gateway_attachments[0].tags[0].key #=> String
    #   resp.transit_gateway_attachments[0].tags[0].value #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayAttachments AWS API Documentation
    #
    # @overload describe_transit_gateway_attachments(params = {})
    # @param [Hash] params ({})
    def describe_transit_gateway_attachments(params = {}, options = {})
      req = build_request(:describe_transit_gateway_attachments, params)
      req.send_request(options)
    end

    # Describes one or more transit gateway route tables. By default, all
    # transit gateway route tables are described. Alternatively, you can
    # filter the results.
    #
    # @option params [Array<String>] :transit_gateway_route_table_ids
    #   The IDs of the transit gateway route tables.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters. The possible values are:
    #
    #   * `default-association-route-table` - Indicates whether this is the
    #     default association route table for the transit gateway (`true` \|
    #     `false`).
    #
    #   * `default-propagation-route-table` - Indicates whether this is the
    #     default propagation route table for the transit gateway (`true` \|
    #     `false`).
    #
    #   * `state` - The state of the attachment (`available` \| `deleted` \|
    #     `deleting` \| `failed` \| `modifying` \| `pendingAcceptance` \|
    #     `pending` \| `rollingBack` \| `rejected` \| `rejecting`).
    #
    #   * `transit-gateway-id` - The ID of the transit gateway.
    #
    #   * `transit-gateway-route-table-id` - The ID of the transit gateway
    #     route table.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeTransitGatewayRouteTablesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeTransitGatewayRouteTablesResult#transit_gateway_route_tables #transit_gateway_route_tables} => Array&lt;Types::TransitGatewayRouteTable&gt;
    #   * {Types::DescribeTransitGatewayRouteTablesResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_transit_gateway_route_tables({
    #     transit_gateway_route_table_ids: ["String"],
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #     next_token: "String",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_route_tables #=> Array
    #   resp.transit_gateway_route_tables[0].transit_gateway_route_table_id #=> String
    #   resp.transit_gateway_route_tables[0].transit_gateway_id #=> String
    #   resp.transit_gateway_route_tables[0].state #=> String, one of "pending", "available", "deleting", "deleted"
    #   resp.transit_gateway_route_tables[0].default_association_route_table #=> Boolean
    #   resp.transit_gateway_route_tables[0].default_propagation_route_table #=> Boolean
    #   resp.transit_gateway_route_tables[0].creation_time #=> Time
    #   resp.transit_gateway_route_tables[0].tags #=> Array
    #   resp.transit_gateway_route_tables[0].tags[0].key #=> String
    #   resp.transit_gateway_route_tables[0].tags[0].value #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayRouteTables AWS API Documentation
    #
    # @overload describe_transit_gateway_route_tables(params = {})
    # @param [Hash] params ({})
    def describe_transit_gateway_route_tables(params = {}, options = {})
      req = build_request(:describe_transit_gateway_route_tables, params)
      req.send_request(options)
    end

    # Describes one or more VPC attachments. By default, all VPC attachments
    # are described. Alternatively, you can filter the results.
    #
    # @option params [Array<String>] :transit_gateway_attachment_ids
    #   The IDs of the attachments.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters. The possible values are:
    #
    #   * `state` - The state of the attachment (`available` \| `deleted` \|
    #     `deleting` \| `failed` \| `modifying` \| `pendingAcceptance` \|
    #     `pending` \| `rollingBack` \| `rejected` \| `rejecting`).
    #
    #   * `transit-gateway-attachment-id` - The ID of the attachment.
    #
    #   * `transit-gateway-id` - The ID of the transit gateway.
    #
    #   * `vpc-id` - The ID of the VPC.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeTransitGatewayVpcAttachmentsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeTransitGatewayVpcAttachmentsResult#transit_gateway_vpc_attachments #transit_gateway_vpc_attachments} => Array&lt;Types::TransitGatewayVpcAttachment&gt;
    #   * {Types::DescribeTransitGatewayVpcAttachmentsResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_transit_gateway_vpc_attachments({
    #     transit_gateway_attachment_ids: ["String"],
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #     next_token: "String",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_vpc_attachments #=> Array
    #   resp.transit_gateway_vpc_attachments[0].transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_vpc_attachments[0].transit_gateway_id #=> String
    #   resp.transit_gateway_vpc_attachments[0].vpc_id #=> String
    #   resp.transit_gateway_vpc_attachments[0].vpc_owner_id #=> String
    #   resp.transit_gateway_vpc_attachments[0].state #=> String, one of "pendingAcceptance", "rollingBack", "pending", "available", "modifying", "deleting", "deleted", "failed", "rejected", "rejecting", "failing"
    #   resp.transit_gateway_vpc_attachments[0].subnet_ids #=> Array
    #   resp.transit_gateway_vpc_attachments[0].subnet_ids[0] #=> String
    #   resp.transit_gateway_vpc_attachments[0].creation_time #=> Time
    #   resp.transit_gateway_vpc_attachments[0].options.dns_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_vpc_attachments[0].options.ipv_6_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_vpc_attachments[0].tags #=> Array
    #   resp.transit_gateway_vpc_attachments[0].tags[0].key #=> String
    #   resp.transit_gateway_vpc_attachments[0].tags[0].value #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayVpcAttachments AWS API Documentation
    #
    # @overload describe_transit_gateway_vpc_attachments(params = {})
    # @param [Hash] params ({})
    def describe_transit_gateway_vpc_attachments(params = {}, options = {})
      req = build_request(:describe_transit_gateway_vpc_attachments, params)
      req.send_request(options)
    end

    # Describes one or more transit gateways. By default, all transit
    # gateways are described. Alternatively, you can filter the results.
    #
    # @option params [Array<String>] :transit_gateway_ids
    #   The IDs of the transit gateways.
    #
    # @option params [Array<Types::Filter>] :filters
    #   One or more filters. The possible values are:
    #
    #   * `options.propagation-default-route-table-id` - The ID of the default
    #     propagation route table.
    #
    #   * `options.amazon-side-asn` - The private ASN for the Amazon side of a
    #     BGP session.
    #
    #   * `options.association-default-route-table-id` - The ID of the default
    #     association route table.
    #
    #   * `options.auto-accept-shared-attachments` - Indicates whether there
    #     is automatic acceptance of attachment requests (`enable` \|
    #     `disable`).
    #
    #   * `options.default-route-table-association` - Indicates whether
    #     resource attachments are automatically associated with the default
    #     association route table (`enable` \| `disable`).
    #
    #   * `options.default-route-table-propagation` - Indicates whether
    #     resource attachments automatically propagate routes to the default
    #     propagation route table (`enable` \| `disable`).
    #
    #   * `options.dns-support` - Indicates whether DNS support is enabled
    #     (`enable` \| `disable`).
    #
    #   * `options.vpn-ecmp-support` - Indicates whether Equal Cost Multipath
    #     Protocol support is enabled (`enable` \| `disable`).
    #
    #   * `owner-id` - The ID of the AWS account that owns the transit
    #     gateway.
    #
    #   * `state` - The state of the attachment (`available` \| `deleted` \|
    #     `deleting` \| `failed` \| `modifying` \| `pendingAcceptance` \|
    #     `pending` \| `rollingBack` \| `rejected` \| `rejecting`).
    #
    #   * `transit-gateway-id` - The ID of the transit gateway.
    #
    # @option params [Integer] :max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    # @option params [String] :next_token
    #   The token for the next page of results.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeTransitGatewaysResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeTransitGatewaysResult#transit_gateways #transit_gateways} => Array&lt;Types::TransitGateway&gt;
    #   * {Types::DescribeTransitGatewaysResult#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_transit_gateways({
    #     transit_gateway_ids: ["String"],
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #     next_token: "String",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateways #=> Array
    #   resp.transit_gateways[0].transit_gateway_id #=> String
    #   resp.transit_gateways[0].transit_gateway_arn #=> String
    #   resp.transit_gateways[0].state #=> String, one of "pending", "available", "modifying", "deleting", "deleted"
    #   resp.transit_gateways[0].owner_id #=> String
    #   resp.transit_gateways[0].description #=> String
    #   resp.transit_gateways[0].creation_time #=> Time
    #   resp.transit_gateways[0].options.amazon_side_asn #=> Integer
    #   resp.transit_gateways[0].options.auto_accept_shared_attachments #=> String, one of "enable", "disable"
    #   resp.transit_gateways[0].options.default_route_table_association #=> String, one of "enable", "disable"
    #   resp.transit_gateways[0].options.association_default_route_table_id #=> String
    #   resp.transit_gateways[0].options.default_route_table_propagation #=> String, one of "enable", "disable"
    #   resp.transit_gateways[0].options.propagation_default_route_table_id #=> String
    #   resp.transit_gateways[0].options.vpn_ecmp_support #=> String, one of "enable", "disable"
    #   resp.transit_gateways[0].options.dns_support #=> String, one of "enable", "disable"
    #   resp.transit_gateways[0].tags #=> Array
    #   resp.transit_gateways[0].tags[0].key #=> String
    #   resp.transit_gateways[0].tags[0].value #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGateways AWS API Documentation
    #
    # @overload describe_transit_gateways(params = {})
    # @param [Hash] params ({})
    def describe_transit_gateways(params = {}, options = {})
      req = build_request(:describe_transit_gateways, params)
      req.send_request(options)
    end

    # Describes the specified attribute of the specified volume. You can
    # specify only one attribute at a time.
    #
    # For more information about EBS volumes, see [Amazon EBS Volumes][1] in
    # the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumes.html
    #
    # @option params [required, String] :attribute
    #   The attribute of the volume. This parameter is required.
    #
    # @option params [required, String] :volume_id
    #   The ID of the volume.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeVolumeAttributeResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeVolumeAttributeResult#auto_enable_io #auto_enable_io} => Types::AttributeBooleanValue
    #   * {Types::DescribeVolumeAttributeResult#product_codes #product_codes} => Array&lt;Types::ProductCode&gt;
    #   * {Types::DescribeVolumeAttributeResult#volume_id #volume_id} => String
    #
    #
    # @example Example: To describe a volume attribute
    #
    #   # This example describes the ``autoEnableIo`` attribute of the volume with the ID ``vol-049df61146c4d7901``.
    #
    #   resp = client.describe_volume_attribute({
    #     attribute: "autoEnableIO", 
    #     volume_id: "vol-049df61146c4d7901", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     auto_enable_io: {
    #       value: false, 
    #     }, 
    #     volume_id: "vol-049df61146c4d7901", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_volume_attribute({
    #     attribute: "autoEnableIO", # required, accepts autoEnableIO, productCodes
    #     volume_id: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.auto_enable_io.value #=> Boolean
    #   resp.product_codes #=> Array
    #   resp.product_codes[0].product_code_id #=> String
    #   resp.product_codes[0].product_code_type #=> String, one of "devpay", "marketplace"
    #   resp.volume_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumeAttribute AWS API Documentation
    #
    # @overload describe_volume_attribute(params = {})
    # @param [Hash] params ({})
    def describe_volume_attribute(params = {}, options = {})
      req = build_request(:describe_volume_attribute, params)
      req.send_request(options)
    end

    # Describes the status of the specified volumes. Volume status provides
    # the result of the checks performed on your volumes to determine events
    # that can impair the performance of your volumes. The performance of a
    # volume can be affected if an issue occurs on the volume's underlying
    # host. If the volume's underlying host experiences a power outage or
    # system issue, after the system is restored, there could be data
    # inconsistencies on the volume. Volume events notify you if this
    # occurs. Volume actions notify you if any action needs to be taken in
    # response to the event.
    #
    # The `DescribeVolumeStatus` operation provides the following
    # information about the specified volumes:
    #
    # *Status*\: Reflects the current status of the volume. The possible
    # values are `ok`, `impaired` , `warning`, or `insufficient-data`. If
    # all checks pass, the overall status of the volume is `ok`. If the
    # check fails, the overall status is `impaired`. If the status is
    # `insufficient-data`, then the checks may still be taking place on your
    # volume at the time. We recommend that you retry the request. For more
    # information about volume status, see [Monitoring the Status of Your
    # Volumes][1] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    # *Events*\: Reflect the cause of a volume status and may require you to
    # take action. For example, if your volume returns an `impaired` status,
    # then the volume event might be `potential-data-inconsistency`. This
    # means that your volume has been affected by an issue with the
    # underlying host, has all I/O operations disabled, and may have
    # inconsistent data.
    #
    # *Actions*\: Reflect the actions you may have to take in response to an
    # event. For example, if the status of the volume is `impaired` and the
    # volume event shows `potential-data-inconsistency`, then the action
    # shows `enable-volume-io`. This means that you may want to enable the
    # I/O operations for the volume by calling the EnableVolumeIO action and
    # then check the volume for data consistency.
    #
    # Volume status is based on the volume status checks, and does not
    # reflect the volume state. Therefore, volume status does not indicate
    # volumes in the `error` state (for example, when a volume is incapable
    # of accepting I/O.)
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-volume-status.html
    #
    # @option params [Array<Types::Filter>] :filters
    #   The filters.
    #
    #   * `action.code` - The action code for the event (for example,
    #     `enable-volume-io`).
    #
    #   * `action.description` - A description of the action.
    #
    #   * `action.event-id` - The event ID associated with the action.
    #
    #   * `availability-zone` - The Availability Zone of the instance.
    #
    #   * `event.description` - A description of the event.
    #
    #   * `event.event-id` - The event ID.
    #
    #   * `event.event-type` - The event type (for `io-enabled`\: `passed` \|
    #     `failed`; for `io-performance`\: `io-performance:degraded` \|
    #     `io-performance:severely-degraded` \| `io-performance:stalled`).
    #
    #   * `event.not-after` - The latest end time for the event.
    #
    #   * `event.not-before` - The earliest start time for the event.
    #
    #   * `volume-status.details-name` - The cause for `volume-status.status`
    #     (`io-enabled` \| `io-performance`).
    #
    #   * `volume-status.details-status` - The status of
    #     `volume-status.details-name` (for `io-enabled`\: `passed` \|
    #     `failed`; for `io-performance`\: `normal` \| `degraded` \|
    #     `severely-degraded` \| `stalled`).
    #
    #   * `volume-status.status` - The status of the volume (`ok` \|
    #     `impaired` \| `warning` \| `insufficient-data`).
    #
    # @option params [Integer] :max_results
    #   The maximum number of volume results returned by
    #   `DescribeVolumeStatus` in paginated output. When this parameter is
    #   used, the request only returns `MaxResults` results in a single page
    #   along with a `NextToken` response element. The remaining results of
    #   the initial request can be seen by sending another request with the
    #   returned `NextToken` value. This value can be between 5 and 1000; if
    #   `MaxResults` is given a value larger than 1000, only 1000 results are
    #   returned. If this parameter is not used, then `DescribeVolumeStatus`
    #   returns all results. You cannot specify this parameter and the volume
    #   IDs parameter in the same request.
    #
    # @option params [String] :next_token
    #   The `NextToken` value to include in a future `DescribeVolumeStatus`
    #   request. When the results of the request exceed `MaxResults`, this
    #   value can be used to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #
    # @option params [Array<String>] :volume_ids
    #   The IDs of the volumes.
    #
    #   Default: Describes all your volumes.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::DescribeVolumeStatusResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeVolumeStatusResult#next_token #next_token} => String
    #   * {Types::DescribeVolumeStatusResult#volume_statuses #volume_statuses} => Array&lt;Types::VolumeStatusItem&gt;
    #
    #
    # @example Example: To describe the status of a single volume
    #
    #   # This example describes the status for the volume ``vol-1234567890abcdef0``.
    #
    #   resp = client.describe_volume_status({
    #     volume_ids: [
    #       "vol-1234567890abcdef0", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     volume_statuses: [
    #       {
    #         actions: [
    #         ], 
    #         availability_zone: "us-east-1a", 
    #         events: [
    #         ], 
    #         volume_id: "vol-1234567890abcdef0", 
    #         volume_status: {
    #           details: [
    #             {
    #               name: "io-enabled", 
    #               status: "passed", 
    #             }, 
    #             {
    #               name: "io-performance", 
    #               status: "not-applicable", 
    #             }, 
    #           ], 
    #           status: "ok", 
    #         }, 
    #       }, 
    #     ], 
    #   }
    #
    # @example Example: To describe the status of impaired volumes
    #
    #   # This example describes the status for all volumes that are impaired. In this example output, there are no impaired
    #   # volumes.
    #
    #   resp = client.describe_volume_status({
    #     filters: [
    #       {
    #         name: "volume-status.status", 
    #         values: [
    #           "impaired", 
    #         ], 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     volume_statuses: [
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_volume_status({
    #     filters: [
    #       {
    #         name: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     max_results: 1,
    #     next_token: "String",
    #     volume_ids: ["String"],
    #     dry_run: false,
    #   })
    #
    # 