/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.KVisibility;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.Argument;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.InternalArgument;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.utils.StringsKt;

public class ArgumentUtils {
    private ArgumentUtils() {
    }

    @NotNull
    public static List<String> convertArgumentsToStringList(@NotNull CommonToolArguments arguments2) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (arguments2 == null) {
            ArgumentUtils.$$$reportNull$$$0(0);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        Class<?> argumentsClass = arguments2.getClass();
        ArgumentUtils.convertArgumentsToStringList(arguments2, (CommonToolArguments)argumentsClass.newInstance(), JvmClassMappingKt.getKotlinClass(argumentsClass), result2);
        result2.addAll(arguments2.getFreeArgs());
        result2.addAll(CollectionsKt.map(arguments2.getInternalArguments(), InternalArgument::getStringRepresentation));
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            ArgumentUtils.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static void convertArgumentsToStringList(@NotNull CommonToolArguments arguments2, @NotNull CommonToolArguments defaultArguments, @NotNull KClass<?> clazz, @NotNull List<String> result2) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        if (arguments2 == null) {
            ArgumentUtils.$$$reportNull$$$0(2);
        }
        if (defaultArguments == null) {
            ArgumentUtils.$$$reportNull$$$0(3);
        }
        if (clazz == null) {
            ArgumentUtils.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            ArgumentUtils.$$$reportNull$$$0(5);
        }
        for (KProperty1<?, ?> property : KClasses.getMemberProperties(clazz)) {
            Argument argument = ArgumentUtils.findInstance(property.getAnnotations(), Argument.class);
            if (argument == null || property.getVisibility() != KVisibility.PUBLIC) continue;
            Object value = property.get(arguments2);
            Object defaultValue2 = property.get(defaultArguments);
            if (value == null || Objects.equals(value, defaultValue2)) continue;
            Type propertyJavaType = ReflectJvmMapping.getJavaType(property.getReturnType());
            if (propertyJavaType instanceof Class && ((Class)propertyJavaType).isArray()) {
                Object[] values = (Object[])value;
                if (values.length == 0) continue;
                value = StringsKt.join(Arrays.asList(values), ",");
            }
            result2.add(argument.value());
            if (propertyJavaType == Boolean.TYPE || propertyJavaType == Boolean.class) continue;
            if (ParseCommandLineArgumentsKt.isAdvanced(argument)) {
                result2.set(result2.size() - 1, argument.value() + "=" + value.toString());
                continue;
            }
            result2.add(value.toString());
        }
    }

    @Nullable
    private static <T> T findInstance(Iterable<? super T> iterable, Class<T> clazz) {
        for (T item : iterable) {
            if (!clazz.isInstance(item)) continue;
            return clazz.cast(item);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/compilerRunner/ArgumentUtils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultArguments";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/compilerRunner/ArgumentUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "convertArgumentsToStringList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertArgumentsToStringList";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

