import { phantom } from './function';
export const URI = 'Writer';
/**
 * @since 1.0.0
 */
export class Writer {
    constructor(run) {
        this.run = run;
    }
    eval() {
        return this.run()[0];
    }
    exec() {
        return this.run()[1];
    }
    map(f) {
        return new Writer(() => {
            const [a, w] = this.run();
            return [f(a), w];
        });
    }
}
const map = (fa, f) => {
    return fa.map(f);
};
const of = (M) => (a) => {
    return new Writer(() => [a, M.empty]);
};
const ap = (S) => (fab, fa) => {
    return new Writer(() => {
        const [f, w1] = fab.run();
        const [a, w2] = fa.run();
        return [f(a), S.concat(w1, w2)];
    });
};
const chain = (S) => (fa, f) => {
    return new Writer(() => {
        const [a, w1] = fa.run();
        const [b, w2] = f(a).run();
        return [b, S.concat(w1, w2)];
    });
};
/**
 * Appends a value to the accumulator
 *
 * @since 1.0.0
 */
export const tell = (w) => {
    return new Writer(() => [undefined, w]);
};
/**
 * Modifies the result to include the changes to the accumulator
 *
 * @since 1.3.0
 */
export const listen = (fa) => {
    return new Writer(() => {
        const [a, w] = fa.run();
        return [[a, w], w];
    });
};
/**
 * Applies the returned function to the accumulator
 *
 * @since 1.3.0
 */
export const pass = (fa) => {
    return new Writer(() => {
        const [[a, f], w] = fa.run();
        return [a, f(w)];
    });
};
/**
 * Projects a value from modifications made to the accumulator during an action
 *
 * @since 1.3.0
 */
export const listens = (fa, f) => {
    return new Writer(() => {
        const [a, w] = fa.run();
        return [[a, f(w)], w];
    });
};
/**
 * Modify the final accumulator value by applying a function
 *
 * @since 1.3.0
 */
export const censor = (fa, f) => {
    return new Writer(() => {
        const [a, w] = fa.run();
        return [a, f(w)];
    });
};
/**
 *
 * @since 1.0.0
 */
export const getMonad = (M) => {
    return {
        URI,
        _L: phantom,
        map,
        of: of(M),
        ap: ap(M),
        chain: chain(M)
    };
};
/**
 * @since 1.0.0
 */
export const writer = {
    URI,
    map
};
