/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.util.EnumSet;
import org.jboss.as.clustering.controller.ContextualSubsystemRegistration;
import org.jboss.as.clustering.controller.descriptions.SubsystemResourceDescriptionResolver;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.extension.mod_cluster.ModClusterModel;
import org.wildfly.extension.mod_cluster.ModClusterSchema;
import org.wildfly.extension.mod_cluster.ModClusterSubsystemResourceDefinition;
import org.wildfly.extension.mod_cluster.ModClusterSubsystemXMLReader;
import org.wildfly.extension.mod_cluster.ModClusterSubsystemXMLWriter;

public class ModClusterExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "modcluster";
    static final SubsystemResourceDescriptionResolver SUBSYSTEM_RESOLVER = new SubsystemResourceDescriptionResolver("modcluster", ModClusterExtension.class);
    public static final SensitiveTargetAccessConstraintDefinition MOD_CLUSTER_SECURITY_DEF = new SensitiveTargetAccessConstraintDefinition(new SensitivityClassification("modcluster", "mod_cluster-security", false, true, true));
    public static final SensitiveTargetAccessConstraintDefinition MOD_CLUSTER_PROXIES_DEF = new SensitiveTargetAccessConstraintDefinition(new SensitivityClassification("modcluster", "mod_cluster-proxies", false, false, false));

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, ModClusterModel.CURRENT.getVersion());
        new ModClusterSubsystemResourceDefinition().register((org.jboss.as.clustering.controller.SubsystemRegistration)new ContextualSubsystemRegistration(registration, context));
        registration.registerXMLElementWriter((XMLElementWriter)new ModClusterSubsystemXMLWriter());
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (ModClusterSchema schema : EnumSet.allOf(ModClusterSchema.class)) {
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, schema.getNamespaceUri(), (XMLElementReader)new ModClusterSubsystemXMLReader(schema));
        }
    }
}

