/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.net.URI;
import java.util.Locale;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.common.ClientConnection;
import org.keycloak.locale.LocaleSelectorProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.sessions.AuthenticationSessionModel;

public class DefaultKeycloakContext
implements KeycloakContext {
    private RealmModel realm;
    private ClientModel client;
    private ClientConnection connection;
    private KeycloakSession session;
    private KeycloakUriInfo uriInfo;
    private AuthenticationSessionModel authenticationSession;

    public DefaultKeycloakContext(KeycloakSession session) {
        this.session = session;
    }

    public URI getAuthServerUrl() {
        KeycloakUriInfo uri = this.getUri();
        KeycloakApplication keycloakApplication = this.getContextObject(KeycloakApplication.class);
        return keycloakApplication.getBaseUri((UriInfo)uri);
    }

    public String getContextPath() {
        KeycloakApplication app = this.getContextObject(KeycloakApplication.class);
        if (app == null) {
            return null;
        }
        return app.getContextPath();
    }

    public KeycloakUriInfo getUri() {
        if (this.uriInfo == null) {
            this.uriInfo = new KeycloakUriInfo(this.session, this.getContextObject(UriInfo.class));
        }
        return this.uriInfo;
    }

    public HttpHeaders getRequestHeaders() {
        return this.getContextObject(HttpHeaders.class);
    }

    public <T> T getContextObject(Class<T> clazz) {
        return (T)ResteasyProviderFactory.getContextData(clazz);
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public void setRealm(RealmModel realm) {
        this.realm = realm;
        this.uriInfo = null;
    }

    public ClientModel getClient() {
        return this.client;
    }

    public void setClient(ClientModel client) {
        this.client = client;
    }

    public ClientConnection getConnection() {
        return this.connection;
    }

    public void setConnection(ClientConnection connection) {
        this.connection = connection;
    }

    public Locale resolveLocale(UserModel user) {
        return ((LocaleSelectorProvider)this.session.getProvider(LocaleSelectorProvider.class)).resolveLocale(this.realm, user);
    }

    public AuthenticationSessionModel getAuthenticationSession() {
        return this.authenticationSession;
    }

    public void setAuthenticationSession(AuthenticationSessionModel authenticationSession) {
        this.authenticationSession = authenticationSession;
    }
}

