/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.netty.transport;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import java.io.IOException;
import java.net.SocketAddress;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.channels.AcceptingChannel;
import org.xnio.netty.transport.AbstractXnioServerSocketChannel;
import org.xnio.netty.transport.AbstractXnioSocketChannel;
import org.xnio.netty.transport.IoThreadPowered;
import org.xnio.netty.transport.WrappingXnioServerSocketChannel;
import org.xnio.netty.transport.XnioChannelCloseFuture;
import org.xnio.netty.transport.XnioChannelPromiseCloseFuture;
import org.xnio.netty.transport.XnioEventLoop;

public final class WrappingXnioSocketChannel
extends AbstractXnioSocketChannel
implements IoThreadPowered {
    private final StreamConnection channel;
    private final XnioIoThread thread;
    private volatile XnioChannelCloseFuture closeFuture;

    WrappingXnioSocketChannel(AbstractXnioServerSocketChannel parent, StreamConnection channel) {
        super(parent);
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        this.channel = channel;
        this.thread = channel.getIoThread();
        this.config().setTcpNoDelay(true);
        channel.getSourceChannel().getReadSetter().set((ChannelListener)new AbstractXnioSocketChannel.ReadListener());
    }

    public WrappingXnioSocketChannel(AcceptingChannel<StreamConnection> parent, StreamConnection channel) {
        this(new WrappingXnioServerSocketChannel(parent), channel);
        this.unsafe().register((EventLoop)new XnioEventLoop(this.thread), this.unsafe().voidPromise());
        this.read();
    }

    public WrappingXnioSocketChannel(StreamConnection channel) {
        this((AbstractXnioServerSocketChannel)null, channel);
        this.unsafe().register((EventLoop)new XnioEventLoop(this.thread), this.unsafe().voidPromise());
        this.read();
    }

    @Override
    public XnioIoThread ioThread() {
        return this.thread;
    }

    @Override
    protected XnioUnsafe newUnsafe() {
        return new XnioUnsafe();
    }

    protected void doBind(SocketAddress localAddress) throws Exception {
        throw new UnsupportedOperationException("Wrapped XNIO Channel");
    }

    @Override
    protected <T> void setOption0(Option<T> option, T value) throws IOException {
        this.channel.setOption(option, value);
    }

    @Override
    protected <T> T getOption0(Option<T> option) throws IOException {
        return (T)this.channel.getOption(option);
    }

    @Override
    protected StreamConnection connection() {
        return this.channel;
    }

    public ChannelFuture shutdownInput() {
        if (this.closeFuture != null) {
            this.closeFuture = new XnioChannelCloseFuture(this);
        }
        this.channel.getSourceChannel().setCloseListener((ChannelListener)this.closeFuture);
        try {
            this.channel.getSourceChannel().shutdownReads();
        }
        catch (IOException e) {
            this.closeFuture.setError(e);
        }
        return this.closeFuture;
    }

    public ChannelFuture shutdownInput(ChannelPromise channelPromise) {
        this.closeFuture = new XnioChannelPromiseCloseFuture(this, channelPromise);
        return this.shutdownInput();
    }

    private final class XnioUnsafe
    extends AbstractXnioSocketChannel.AbstractXnioUnsafe {
        private XnioUnsafe() {
        }

        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            promise.setFailure((Throwable)new UnsupportedOperationException("Wrapped XNIO Channel"));
        }
    }
}

