/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.AttributeTranslation;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.dmr.ModelNode;

public class WriteAttributeTranslationHandler
implements OperationStepHandler {
    private final AttributeTranslation translation;

    public WriteAttributeTranslationHandler(AttributeTranslation translation) {
        this.translation = translation;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode value = context.resolveExpressions(Operations.getAttributeValue(operation));
        ModelNode targetValue = this.translation.getWriteTranslator().translate(context, value);
        Attribute targetAttribute = this.translation.getTargetAttribute();
        PathAddress currentAddress = context.getCurrentAddress();
        PathAddress targetAddress = (PathAddress)this.translation.getPathAddressTransformation().apply(currentAddress);
        ModelNode targetOperation = Operations.createWriteAttributeOperation(targetAddress, targetAttribute, targetValue);
        ImmutableManagementResourceRegistration targetRegistration = (ImmutableManagementResourceRegistration)this.translation.getResourceRegistrationTransformation().apply(context.getResourceRegistration());
        OperationStepHandler writeAttributeHandler = targetRegistration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, targetAttribute.getName()).getWriteHandler();
        if (targetAddress == currentAddress) {
            writeAttributeHandler.execute(context, targetOperation);
        } else {
            context.addStep(targetOperation, writeAttributeHandler, context.getCurrentStage());
        }
    }
}

