/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.ldap.LdapName;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.credential.AbstractBaseCredentials;
import org.picketlink.idm.credential.Credentials;

public class X509CertificateCredentials
extends AbstractBaseCredentials
implements Credentials {
    private String subjectRegex;
    private X509Certificate certificate;
    private String userName;
    private boolean trusted;

    public X509CertificateCredentials(X509Certificate certificate) {
        this(certificate, null);
    }

    public X509CertificateCredentials(X509Certificate certificate, String subjectRegex) {
        this.certificate = certificate;
        this.subjectRegex = subjectRegex;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public String getUsername() {
        if (this.userName == null) {
            this.userName = this.getCertificatePrincipal().getName();
            if (this.subjectRegex == null) {
                try {
                    LdapName ldapName = new LdapName(this.userName);
                    this.userName = ldapName.getRdn(ldapName.size() - 1).getValue().toString();
                }
                catch (Exception e) {
                    throw new IdentityManagementException("Could not extract CN from X509.", e);
                }
            } else {
                Matcher matcher = Pattern.compile(this.subjectRegex).matcher(this.userName);
                if (matcher.find() && matcher.groupCount() != 1) {
                    throw new IdentityManagementException("Single group expected from expression.");
                }
                this.userName = matcher.group(1);
            }
        }
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public void invalidate() {
        this.certificate = null;
        this.subjectRegex = null;
        this.trusted = false;
        this.userName = null;
    }

    private Principal getCertificatePrincipal() {
        Principal certprincipal = this.certificate.getSubjectDN();
        if (certprincipal == null) {
            certprincipal = this.certificate.getIssuerDN();
        }
        return certprincipal;
    }

    public void setTrusted(boolean trusted) {
        this.trusted = trusted;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public String toString() {
        return "userName: " + this.getUsername();
    }
}

