/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.resource.ContractInfo;
import com.sun.faces.application.resource.FaceletResourceInfo;
import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.Resource;
import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.ResourcePathsIterator;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.faces.FacesException;
import javax.faces.application.ResourceVisitOption;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.flow.Flow;

public class FaceletWebappResourceHelper
extends ResourceHelper {
    private static final String[] RESTRICTED_DIRECTORIES = new String[]{"/WEB-INF/", "/META-INF/"};
    private final String webAppContractsDirectory;
    private final String[] configuredExtensions;

    public FaceletWebappResourceHelper() {
        WebConfiguration webConfig = WebConfiguration.getInstance();
        this.webAppContractsDirectory = webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.WebAppContractsDirectory);
        this.configuredExtensions = webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.FaceletsSuffix, " ");
    }

    public boolean equals(Object obj) {
        return obj instanceof FaceletWebappResourceHelper;
    }

    public int hashCode() {
        return 3;
    }

    @Override
    public LibraryInfo findLibrary(String libraryName, String localePrefix, String contract, FacesContext ctx) {
        return null;
    }

    @Override
    public ResourceInfo findResource(LibraryInfo library, String resourceName, String localePrefix, boolean compressable, FacesContext ctx) {
        if (localePrefix != null) {
            return null;
        }
        FaceletResourceInfo result = null;
        try {
            List contracts = ctx.getResourceLibraryContracts();
            ContractInfo[] outContract = new ContractInfo[1];
            boolean[] outDoNotCache = new boolean[1];
            URL url = null;
            if (library == null && !contracts.isEmpty()) {
                url = this.findResourceInfoConsideringContracts(ctx, resourceName, outContract, contracts);
            }
            if (url == null) {
                url = Resource.getResourceUrl(ctx, this.createPath(library, resourceName));
            }
            if (url == null) {
                url = this.findResourceUrlConsideringFlows(resourceName, outDoNotCache);
            }
            if (url != null) {
                result = new FaceletResourceInfo(outContract[0], resourceName, null, this, url);
                result.setDoNotCache(outDoNotCache[0]);
            }
        }
        catch (IOException ex) {
            throw new FacesException((Throwable)ex);
        }
        return result;
    }

    public Stream<String> getViewResources(FacesContext facesContext, String path, int maxDepth, ResourceVisitOption ... options) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new ResourcePathsIterator(path, maxDepth, this.configuredExtensions, FaceletWebappResourceHelper.getRestrictedDirectories(options), facesContext.getExternalContext()), 1), false);
    }

    private static String[] getRestrictedDirectories(ResourceVisitOption ... options) {
        for (ResourceVisitOption option : options) {
            if (option != ResourceVisitOption.TOP_LEVEL_VIEWS_ONLY) continue;
            return RESTRICTED_DIRECTORIES;
        }
        return null;
    }

    private String createPath(LibraryInfo library, String resourceName) {
        String path = resourceName;
        if (library != null) {
            path = library.getPath() + "/" + resourceName;
        } else if (path.charAt(0) != '/') {
            path = "/" + path;
        }
        return path;
    }

    private URL findResourceInfoConsideringContracts(FacesContext ctx, String baseResourceName, ContractInfo[] outContract, List<String> contracts) throws MalformedURLException {
        URL url = null;
        for (String contract : contracts) {
            String resourceName = baseResourceName.startsWith("/") ? this.webAppContractsDirectory + "/" + contract + baseResourceName : this.webAppContractsDirectory + "/" + contract + "/" + baseResourceName;
            url = Resource.getResourceUrl(ctx, resourceName);
            if (url != null) {
                outContract[0] = new ContractInfo(contract);
                break;
            }
            resourceName = baseResourceName.startsWith("/") ? WebConfiguration.META_INF_CONTRACTS_DIR + "/" + contract + baseResourceName : WebConfiguration.META_INF_CONTRACTS_DIR + "/" + contract + "/" + baseResourceName;
            url = Util.getCurrentLoader(this).getResource(resourceName);
            if (url == null) continue;
            outContract[0] = new ContractInfo(contract);
            break;
        }
        return url;
    }

    private URL findResourceUrlConsideringFlows(String resourceName, boolean[] outDoNotCache) throws IOException {
        URL url = null;
        ClassLoader cl = Util.getCurrentLoader(this);
        Enumeration<URL> matches = cl.getResources("META-INF/flows" + resourceName);
        try {
            url = matches.nextElement();
        }
        catch (NoSuchElementException nsee) {
            url = null;
        }
        if (url != null && matches.hasMoreElements()) {
            boolean keepGoing = true;
            FacesContext context = FacesContext.getCurrentInstance();
            Flow currentFlow = context.getApplication().getFlowHandler().getCurrentFlow(context);
            do {
                if (currentFlow != null && 0 < currentFlow.getDefiningDocumentId().length()) {
                    String definingDocumentId = currentFlow.getDefiningDocumentId();
                    ExternalContext extContext = context.getExternalContext();
                    ApplicationAssociate associate = ApplicationAssociate.getInstance(extContext);
                    if (associate.urlIsRelatedToDefiningDocumentInJar(url, definingDocumentId)) {
                        keepGoing = false;
                        outDoNotCache[0] = true;
                        continue;
                    }
                    if (matches.hasMoreElements()) {
                        url = matches.nextElement();
                        continue;
                    }
                    keepGoing = false;
                    continue;
                }
                keepGoing = false;
            } while (keepGoing);
        }
        return url;
    }

    @Override
    public String getBaseResourcePath() {
        return "";
    }

    @Override
    public String getBaseContractsPath() {
        return this.webAppContractsDirectory;
    }

    @Override
    protected InputStream getNonCompressedInputStream(ResourceInfo info, FacesContext ctx) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public URL getURL(ResourceInfo resource, FacesContext ctx) {
        return ((FaceletResourceInfo)resource).getUrl();
    }
}

