/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.Base32;

public class OTPPolicy
implements Serializable {
    protected static final Logger logger = Logger.getLogger(OTPPolicy.class);
    protected String type;
    protected String algorithm;
    protected int initialCounter;
    protected int digits;
    protected int lookAheadWindow;
    protected int period;
    private static final Map<String, String> algToKeyUriAlg = new HashMap<String, String>();
    private static final OtpApp[] allApplications = new OtpApp[]{new FreeOTP(), new GoogleAuthenticator()};
    public static OTPPolicy DEFAULT_POLICY;

    public OTPPolicy() {
    }

    public OTPPolicy(String type, String algorithm, int initialCounter, int digits, int lookAheadWindow, int period) {
        this.type = type;
        this.algorithm = algorithm;
        this.initialCounter = initialCounter;
        this.digits = digits;
        this.lookAheadWindow = lookAheadWindow;
        this.period = period;
    }

    public String getAlgorithmKey() {
        return algToKeyUriAlg.containsKey(this.algorithm) ? algToKeyUriAlg.get(this.algorithm) : this.algorithm;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public int getInitialCounter() {
        return this.initialCounter;
    }

    public void setInitialCounter(int initialCounter) {
        this.initialCounter = initialCounter;
    }

    public int getDigits() {
        return this.digits;
    }

    public void setDigits(int digits) {
        this.digits = digits;
    }

    public int getLookAheadWindow() {
        return this.lookAheadWindow;
    }

    public void setLookAheadWindow(int lookAheadWindow) {
        this.lookAheadWindow = lookAheadWindow;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public String getKeyURI(RealmModel realm, UserModel user, String secret) {
        try {
            String displayName = realm.getDisplayName() != null && !realm.getDisplayName().isEmpty() ? realm.getDisplayName() : realm.getName();
            String accountName = URLEncoder.encode(user.getUsername(), "UTF-8");
            String issuerName = URLEncoder.encode(displayName, "UTF-8").replaceAll("\\+", "%20");
            String label = issuerName + ":" + accountName;
            String parameters = "secret=" + Base32.encode(secret.getBytes()) + "&digits=" + this.digits + "&algorithm=" + algToKeyUriAlg.get(this.algorithm) + "&issuer=" + issuerName;
            if (this.type.equals("hotp")) {
                parameters = parameters + "&counter=" + this.initialCounter;
            } else if (this.type.equals("totp")) {
                parameters = parameters + "&period=" + this.period;
            }
            return "otpauth://" + this.type + "/" + label + "?" + parameters;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getSupportedApplications() {
        LinkedList<String> applications = new LinkedList<String>();
        for (OtpApp a : allApplications) {
            if (!a.supports(this)) continue;
            applications.add(a.getName());
        }
        return applications;
    }

    static {
        algToKeyUriAlg.put("HmacSHA1", "SHA1");
        algToKeyUriAlg.put("HmacSHA256", "SHA256");
        algToKeyUriAlg.put("HmacSHA512", "SHA512");
        DEFAULT_POLICY = new OTPPolicy("totp", "HmacSHA1", 0, 6, 1, 30);
    }

    public static class FreeOTP
    implements OtpApp {
        @Override
        public String getName() {
            return "FreeOTP";
        }

        @Override
        public boolean supports(OTPPolicy policy) {
            return true;
        }
    }

    public static class GoogleAuthenticator
    implements OtpApp {
        @Override
        public String getName() {
            return "Google Authenticator";
        }

        @Override
        public boolean supports(OTPPolicy policy) {
            if (policy.digits != 6) {
                return false;
            }
            if (!policy.getAlgorithm().equals("HmacSHA1")) {
                return false;
            }
            return !policy.getType().equals("totp") || policy.getPeriod() == 30;
        }
    }

    public static interface OtpApp {
        public String getName();

        public boolean supports(OTPPolicy var1);
    }
}

