/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.msc.Service;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.inject.Injectors;
import org.jboss.msc.service.AbstractServiceBuilder;
import org.jboss.msc.service.IdentityHashSet;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ReadableValueImpl;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceControllerImpl;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTargetImpl;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.ValueInjection;
import org.jboss.msc.service.WritableValueImpl;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

final class ServiceBuilderImpl<T>
extends AbstractServiceBuilder<T> {
    private final Thread thread = Thread.currentThread();
    private final Map<ServiceName, WritableValueImpl> provides = new HashMap<ServiceName, WritableValueImpl>();
    private Service service;
    private Set<ServiceName> aliases;
    private ServiceController.Mode initialMode;
    private Map<ServiceName, AbstractServiceBuilder.Dependency> requires;
    private Set<StabilityMonitor> monitors;
    private Set<ServiceListener<? super T>> serviceListeners;
    private Set<LifecycleListener> lifecycleListeners;
    private List<ValueInjection<?>> valueInjections;
    private List<Injector<? super T>> outInjections;
    private boolean installed;

    ServiceBuilderImpl(ServiceName serviceId, ServiceTargetImpl serviceTarget, org.jboss.msc.service.Service<T> service, ServiceControllerImpl<?> parent) {
        this(serviceId, serviceTarget, parent);
        if (service == null) {
            throw new IllegalArgumentException("Service can not be null");
        }
        this.service = service;
    }

    ServiceBuilderImpl(ServiceName serviceId, ServiceTargetImpl serviceTarget, ServiceControllerImpl<?> parent) {
        super(serviceId, serviceTarget, parent);
        this.addProvidesInternal(serviceId, null);
    }

    @Override
    public ServiceBuilder<T> addAliases(ServiceName ... aliases) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull(aliases);
        this.assertThreadSafety();
        for (ServiceName alias : aliases) {
            ServiceBuilderImpl.assertNotNull(alias);
            this.assertNotRequired(alias, false);
        }
        for (ServiceName alias : aliases) {
            if (alias.equals(this.getServiceId()) || !this.addAliasInternal(alias)) continue;
            this.addProvidesInternal(alias, null);
        }
        return this;
    }

    @Override
    public <V> Supplier<V> requires(ServiceName dependency) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull(dependency);
        this.assertThreadSafety();
        this.assertNotInstanceId(dependency);
        this.assertNotProvided(dependency, true);
        ReadableValueImpl retVal = this.getServiceTarget().getOrCreateRegistration(dependency).getReadableValue();
        this.addRequiresInternal(dependency, ServiceBuilder.DependencyType.REQUIRED);
        return retVal;
    }

    @Override
    public <V> Consumer<V> provides(ServiceName ... dependencies) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull(dependencies);
        this.assertThreadSafety();
        for (ServiceName dependency : dependencies) {
            ServiceBuilderImpl.assertNotNull(dependency);
            this.assertNotRequired(dependency, false);
            this.assertNotProvided(dependency, false);
        }
        WritableValueImpl retVal = new WritableValueImpl();
        for (ServiceName dependency : dependencies) {
            this.addProvidesInternal(dependency, retVal);
        }
        return retVal;
    }

    @Override
    public ServiceBuilder<T> setInstance(Service service) {
        this.assertNotInstalled();
        this.assertThreadSafety();
        this.assertServiceNotConfigured();
        this.service = service != null ? service : Service.NULL;
        return this;
    }

    @Override
    public ServiceBuilder<T> setInitialMode(ServiceController.Mode mode) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull((Object)mode);
        ServiceBuilderImpl.assertNotRemove(mode);
        this.assertModeNotConfigured();
        this.assertThreadSafety();
        this.initialMode = mode;
        return this;
    }

    @Override
    public ServiceBuilder<T> addMonitor(StabilityMonitor monitor) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull(monitor);
        this.assertThreadSafety();
        this.addMonitorInternal(monitor);
        return this;
    }

    @Override
    public ServiceBuilder<T> addListener(LifecycleListener listener) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull(listener);
        this.assertThreadSafety();
        this.addListenerInternal(listener);
        return this;
    }

    @Override
    public ServiceController<T> install() throws ServiceRegistryException {
        this.assertNotInstalled();
        this.assertThreadSafety();
        this.installed = true;
        if (this.service == null) {
            this.service = Service.NULL;
        }
        if (this.initialMode == null) {
            this.initialMode = ServiceController.Mode.ACTIVE;
        }
        return this.getServiceTarget().install(this);
    }

    @Override
    public ServiceBuilder<T> addMonitors(StabilityMonitor ... monitors) {
        this.assertNotInstalled();
        this.assertThreadSafety();
        if (monitors != null) {
            for (StabilityMonitor monitor : monitors) {
                if (monitor == null) continue;
                this.addMonitorInternal(monitor);
            }
        }
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependencies(ServiceName ... dependencies) {
        return this.addDependencies(ServiceBuilder.DependencyType.REQUIRED, dependencies);
    }

    @Override
    public ServiceBuilder<T> addDependencies(ServiceBuilder.DependencyType dependencyType, ServiceName ... dependencies) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull((Object)dependencyType);
        ServiceBuilderImpl.assertNotNull(dependencies);
        this.assertThreadSafety();
        for (ServiceName dependency : dependencies) {
            ServiceBuilderImpl.assertNotNull(dependency);
        }
        for (ServiceName dependency : dependencies) {
            this.addRequiresInternal(dependency, dependencyType);
        }
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependencies(Iterable<ServiceName> newDependencies) {
        return this.addDependencies(ServiceBuilder.DependencyType.REQUIRED, newDependencies);
    }

    @Override
    public ServiceBuilder<T> addDependencies(ServiceBuilder.DependencyType dependencyType, Iterable<ServiceName> dependencies) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull((Object)dependencyType);
        ServiceBuilderImpl.assertNotNull(dependencies);
        this.assertThreadSafety();
        for (ServiceName dependency : dependencies) {
            ServiceBuilderImpl.assertNotNull(dependency);
        }
        for (ServiceName dependency : dependencies) {
            this.addRequiresInternal(dependency, dependencyType);
        }
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependency(ServiceName dependency) {
        return this.addDependency(ServiceBuilder.DependencyType.REQUIRED, dependency);
    }

    @Override
    public ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull((Object)dependencyType);
        ServiceBuilderImpl.assertNotNull(dependency);
        this.assertThreadSafety();
        this.addRequiresInternal(dependency, dependencyType);
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependency(ServiceName dependency, Injector<Object> target) {
        return this.addDependency(ServiceBuilder.DependencyType.REQUIRED, dependency, target);
    }

    @Override
    public ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency, Injector<Object> target) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull((Object)dependencyType);
        ServiceBuilderImpl.assertNotNull(dependency);
        ServiceBuilderImpl.assertNotNull(target);
        this.assertThreadSafety();
        this.addRequiresInternal(dependency, dependencyType).getInjectorList().add(target);
        return this;
    }

    @Override
    public <I> ServiceBuilder<T> addDependency(ServiceName dependency, Class<I> type, Injector<I> target) {
        return this.addDependency(ServiceBuilder.DependencyType.REQUIRED, dependency, type, target);
    }

    @Override
    public <I> ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency, Class<I> type, Injector<I> target) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull((Object)dependencyType);
        ServiceBuilderImpl.assertNotNull(dependency);
        ServiceBuilderImpl.assertNotNull(type);
        ServiceBuilderImpl.assertNotNull(target);
        this.assertThreadSafety();
        this.addRequiresInternal(dependency, dependencyType).getInjectorList().add(Injectors.cast(target, type));
        return this;
    }

    @Override
    public <I> ServiceBuilder<T> addInjection(Injector<? super I> target, I value) {
        return this.addInjectionValue(target, new ImmediateValue<I>(value));
    }

    @Override
    public <I> ServiceBuilder<T> addInjectionValue(Injector<? super I> target, Value<I> value) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull(target);
        ServiceBuilderImpl.assertNotNull(value);
        this.assertThreadSafety();
        this.addValueInjectionInternal(new ValueInjection<I>(value, target));
        return this;
    }

    @Override
    public ServiceBuilder<T> addInjection(Injector<? super T> target) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull(target);
        ServiceBuilderImpl.assertNotNull(target);
        this.assertThreadSafety();
        this.addOutInjectionInternal(target);
        return this;
    }

    @Override
    public ServiceBuilder<T> addListener(ServiceListener<? super T> listener) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull(listener);
        this.assertThreadSafety();
        this.addListenerInternal(listener);
        return this;
    }

    @Override
    public ServiceBuilder<T> addListener(ServiceListener<? super T> ... listeners) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull(listeners);
        for (ServiceListener<? super T> listener : listeners) {
            ServiceBuilderImpl.assertNotNull(listener);
        }
        this.assertThreadSafety();
        for (ServiceListener<? super T> listener : listeners) {
            this.addListenerInternal(listener);
        }
        return this;
    }

    @Override
    public ServiceBuilder<T> addListener(Collection<? extends ServiceListener<? super T>> listeners) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull(listeners);
        for (ServiceListener<T> serviceListener : listeners) {
            ServiceBuilderImpl.assertNotNull(serviceListener);
        }
        this.assertThreadSafety();
        for (ServiceListener<T> serviceListener : listeners) {
            this.addListenerInternal(serviceListener);
        }
        return this;
    }

    @Override
    void addServiceListenersNoCheck(Set<? extends ServiceListener<? super T>> listeners) {
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        if (this.serviceListeners == null) {
            this.serviceListeners = new IdentityHashSet<ServiceListener<? super T>>();
        }
        this.serviceListeners.addAll(listeners);
    }

    @Override
    void addLifecycleListenersNoCheck(Set<LifecycleListener> listeners) {
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        for (LifecycleListener listener : listeners) {
            if (listener == null) continue;
            this.addListenerInternal(listener);
        }
    }

    @Override
    void addMonitorsNoCheck(Collection<? extends StabilityMonitor> monitors) {
        for (StabilityMonitor stabilityMonitor : monitors) {
            if (stabilityMonitor == null) continue;
            this.addMonitorInternal(stabilityMonitor);
        }
    }

    @Override
    void addDependenciesNoCheck(Iterable<ServiceName> dependencies) {
        for (ServiceName dependency : dependencies) {
            if (dependency == null || this.requires != null && this.requires.containsKey(dependency) || this.provides != null && this.provides.containsKey(dependency)) continue;
            this.addRequiresInternal(dependency, ServiceBuilder.DependencyType.REQUIRED);
        }
    }

    @Override
    Service getService() {
        return this.service;
    }

    private AbstractServiceBuilder.Dependency addRequiresInternal(ServiceName name, ServiceBuilder.DependencyType dependencyType) {
        if (this.requires == null) {
            this.requires = new HashMap<ServiceName, AbstractServiceBuilder.Dependency>();
        }
        if (this.requires.size() == 16383) {
            throw new IllegalArgumentException("Too many dependencies specified (max is 16383)");
        }
        AbstractServiceBuilder.Dependency existing = this.requires.get(name);
        if (existing != null) {
            if (dependencyType == ServiceBuilder.DependencyType.REQUIRED) {
                existing.setDependencyType(ServiceBuilder.DependencyType.REQUIRED);
            }
            return existing;
        }
        AbstractServiceBuilder.Dependency dependency = new AbstractServiceBuilder.Dependency(name, dependencyType);
        this.requires.put(name, dependency);
        return dependency;
    }

    boolean addAliasInternal(ServiceName alias) {
        if (this.aliases == null) {
            this.aliases = new HashSet<ServiceName>();
        }
        if (!this.aliases.contains(alias)) {
            this.aliases.add(alias);
            return true;
        }
        return false;
    }

    void addProvidesInternal(ServiceName name, WritableValueImpl dependency) {
        if (dependency != null) {
            this.provides.put(name, dependency);
        } else if (!this.provides.containsKey(name)) {
            this.provides.put(name, null);
        }
    }

    void addMonitorInternal(StabilityMonitor monitor) {
        if (this.monitors == null) {
            this.monitors = new IdentityHashSet<StabilityMonitor>();
        }
        this.monitors.add(monitor);
    }

    void addListenerInternal(LifecycleListener listener) {
        if (this.lifecycleListeners == null) {
            this.lifecycleListeners = new IdentityHashSet<LifecycleListener>();
        }
        this.lifecycleListeners.add(listener);
    }

    void addListenerInternal(ServiceListener<? super T> listener) {
        if (this.serviceListeners == null) {
            this.serviceListeners = new IdentityHashSet<ServiceListener<? super T>>();
        }
        this.serviceListeners.add(listener);
    }

    void addValueInjectionInternal(ValueInjection<?> valueInjection) {
        if (this.valueInjections == null) {
            this.valueInjections = new ArrayList();
        }
        this.valueInjections.add(valueInjection);
    }

    void addOutInjectionInternal(Injector<? super T> outInjection) {
        if (this.outInjections == null) {
            this.outInjections = new ArrayList<Injector<? super T>>();
        }
        this.outInjections.add(outInjection);
    }

    @Override
    Collection<ServiceName> getServiceAliases() {
        return this.aliases == null ? Collections.emptySet() : this.aliases;
    }

    @Override
    Map<ServiceName, WritableValueImpl> getProvides() {
        return this.provides;
    }

    @Override
    Map<ServiceName, AbstractServiceBuilder.Dependency> getDependencies() {
        return this.requires == null ? Collections.emptyMap() : this.requires;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Set<StabilityMonitor> getMonitors() {
        for (ServiceController<Object> parent = this.getParent(); parent != null; parent = parent.getParent()) {
            ServiceControllerImpl<?> serviceControllerImpl = parent;
            synchronized (serviceControllerImpl) {
                this.addMonitorsNoCheck(parent.getMonitors());
                continue;
            }
        }
        return this.monitors == null ? Collections.emptySet() : this.monitors;
    }

    @Override
    Set<ServiceListener<? super T>> getServiceListeners() {
        return this.serviceListeners == null ? Collections.emptySet() : this.serviceListeners;
    }

    @Override
    Set<LifecycleListener> getLifecycleListeners() {
        return this.lifecycleListeners == null ? Collections.emptySet() : this.lifecycleListeners;
    }

    @Override
    ServiceController.Mode getInitialMode() {
        return this.initialMode;
    }

    @Override
    List<Injector<? super T>> getOutInjections() {
        return this.outInjections == null ? new ArrayList() : this.outInjections;
    }

    @Override
    List<ValueInjection<?>> getValueInjections() {
        return this.valueInjections == null ? new ArrayList() : this.valueInjections;
    }

    private void assertNotInstalled() {
        if (this.installed) {
            throw new IllegalStateException("ServiceBuilder already installed");
        }
    }

    private void assertThreadSafety() {
        if (this.thread != Thread.currentThread()) {
            throw new ConcurrentModificationException("ServiceBuilder used by multiple threads");
        }
    }

    private void assertNotInstanceId(ServiceName dependency) {
        if (this.getServiceId().equals(dependency)) {
            throw new IllegalArgumentException("Cannot both require and provide same dependency:" + dependency);
        }
    }

    private void assertNotRequired(ServiceName dependency, boolean processingRequires) {
        if (this.requires != null && this.requires.keySet().contains(dependency)) {
            if (processingRequires) {
                throw new IllegalArgumentException("Cannot require dependency more than once:" + dependency);
            }
            throw new IllegalArgumentException("Cannot both require and provide same dependency:" + dependency);
        }
    }

    private void assertNotProvided(ServiceName dependency, boolean processingRequires) {
        if (processingRequires) {
            if (this.provides.containsKey(dependency)) {
                throw new IllegalArgumentException("Cannot both require and provide same dependency:" + dependency);
            }
        } else if (this.provides.get(dependency) != null) {
            throw new IllegalArgumentException("Cannot provide dependency more than once: " + dependency);
        }
    }

    private void assertServiceNotConfigured() {
        if (this.service != null) {
            throw new IllegalStateException("Detected addAliases(), requires(), provides() or setService() call after setService() method call");
        }
    }

    private void assertModeNotConfigured() {
        if (this.initialMode != null) {
            throw new IllegalStateException("setInitialMode() method called twice");
        }
    }

    private static void assertNotNull(Object parameter) {
        if (parameter == null) {
            throw new NullPointerException("Method parameter cannot be null");
        }
    }

    private static void assertNotRemove(ServiceController.Mode mode) {
        if (mode == ServiceController.Mode.REMOVE) {
            throw new IllegalArgumentException("Initial service mode cannot be REMOVE");
        }
    }
}

