/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import org.wildfly.clustering.marshalling.Externalizer;

public class IntExternalizer<T>
implements Externalizer<T> {
    private final IntFunction<T> reader;
    private final ToIntFunction<T> writer;
    private final Class<T> targetClass;

    public IntExternalizer(Class<T> targetClass, IntFunction<T> reader, ToIntFunction<T> writer) {
        this.reader = reader;
        this.writer = writer;
        this.targetClass = targetClass;
    }

    public void writeObject(ObjectOutput output, T object) throws IOException {
        output.writeInt(this.writer.applyAsInt(object));
    }

    public T readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return this.reader.apply(input.readInt());
    }

    public Class<T> getTargetClass() {
        return this.targetClass;
    }
}

