/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.Random;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.SimpleSecretKey;
import org.jruby.ext.openssl.StringHelper;
import org.jruby.ext.openssl.Utils;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.TypeConverter;

public class Cipher
extends RubyObject {
    private static final long serialVersionUID = -5390983669951165103L;
    private static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public Cipher allocate(Ruby runtime, RubyClass klass) {
            return new Cipher(runtime, klass);
        }
    };
    private javax.crypto.Cipher cipher;
    private String name;
    private String cryptoBase;
    private String cryptoVersion;
    private String cryptoMode;
    private String paddingType;
    private String realName;
    private int keyLength = -1;
    private int generateKeyLength = -1;
    private int ivLength = -1;
    private boolean encryptMode = true;
    private boolean cipherInited = false;
    private byte[] key;
    private byte[] realIV;
    private byte[] orgIV;
    private String padding;
    private int processedDataBytes = 0;
    private byte[] lastIV;
    private transient ByteList auth_tag;
    private static final int MAX_AUTH_TAG_LENGTH = 16;
    private transient ByteList auth_data;

    static void createCipher(Ruby runtime, RubyModule OpenSSL2, RubyClass OpenSSLError) {
        RubyClass Cipher2 = OpenSSL2.defineClassUnder("Cipher", runtime.getObject(), ALLOCATOR);
        Cipher2.defineClassUnder("CipherError", OpenSSLError, OpenSSLError.getAllocator());
        Cipher2.defineAnnotatedMethods(Cipher.class);
        String cipherName = "AES";
        Cipher2.defineClassUnder(cipherName, Cipher2, (ObjectAllocator)new NamedCipherAllocator(cipherName)).defineAnnotatedMethods(Named.class);
        cipherName = "CAST5";
        Cipher2.defineClassUnder(cipherName, Cipher2, (ObjectAllocator)new NamedCipherAllocator(cipherName)).defineAnnotatedMethods(Named.class);
        cipherName = "BF";
        Cipher2.defineClassUnder(cipherName, Cipher2, (ObjectAllocator)new NamedCipherAllocator(cipherName)).defineAnnotatedMethods(Named.class);
        cipherName = "DES";
        Cipher2.defineClassUnder(cipherName, Cipher2, (ObjectAllocator)new NamedCipherAllocator(cipherName)).defineAnnotatedMethods(Named.class);
        cipherName = "IDEA";
        Cipher2.defineClassUnder(cipherName, Cipher2, (ObjectAllocator)new NamedCipherAllocator(cipherName)).defineAnnotatedMethods(Named.class);
        cipherName = "RC2";
        Cipher2.defineClassUnder(cipherName, Cipher2, (ObjectAllocator)new NamedCipherAllocator(cipherName)).defineAnnotatedMethods(Named.class);
        cipherName = "RC4";
        Cipher2.defineClassUnder(cipherName, Cipher2, (ObjectAllocator)new NamedCipherAllocator(cipherName)).defineAnnotatedMethods(Named.class);
        cipherName = "RC5";
        Cipher2.defineClassUnder(cipherName, Cipher2, (ObjectAllocator)new NamedCipherAllocator(cipherName)).defineAnnotatedMethods(Named.class);
        String keyLength = "128";
        Cipher2.defineClassUnder("AES" + keyLength, Cipher2, (ObjectAllocator)new AESCipherAllocator(keyLength)).defineAnnotatedMethods(AES.class);
        keyLength = "192";
        Cipher2.defineClassUnder("AES" + keyLength, Cipher2, (ObjectAllocator)new AESCipherAllocator(keyLength)).defineAnnotatedMethods(AES.class);
        keyLength = "256";
        Cipher2.defineClassUnder("AES" + keyLength, Cipher2, (ObjectAllocator)new AESCipherAllocator(keyLength)).defineAnnotatedMethods(AES.class);
    }

    static RubyClass _Cipher(Ruby runtime) {
        return (RubyClass)runtime.getModule("OpenSSL").getConstantAt("Cipher");
    }

    @JRubyMethod(meta=true)
    public static IRubyObject ciphers(ThreadContext context2, IRubyObject self) {
        Ruby runtime = context2.runtime;
        Set<String> ciphers2 = Algorithm.allSupportedCiphers().keySet();
        RubyArray result = runtime.newArray(ciphers2.size() * 2);
        for (String cipher2 : ciphers2) {
            result.append((IRubyObject)runtime.newString(cipher2));
        }
        for (String cipher2 : ciphers2) {
            result.append((IRubyObject)runtime.newString(cipher2.toLowerCase()));
        }
        return result;
    }

    public static boolean isSupportedCipher(String name2) {
        String osslName = name2.toUpperCase();
        if (Algorithm.allSupportedCiphers().get(osslName) != null) {
            return true;
        }
        Algorithm alg = Algorithm.osslToJava(osslName);
        if (OpenSSL.isDebug()) {
            OpenSSL.debug("isSupportedCipher( " + name2 + " ) try new cipher = " + alg.getRealName());
        }
        try {
            return Cipher.getCipherInstance(alg.getRealName(), true) != null;
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }

    private static String[] cipherModes(String alg) {
        String[] modes = Cipher.providerCipherModes(alg);
        return modes == null ? Cipher.registeredCipherModes(alg) : modes;
    }

    private static String[] providerCipherModes(String alg) {
        Provider.Service service = Cipher.providerCipherService(alg);
        if (service != null) {
            String supportedModes = service.getAttribute("SupportedModes");
            if (supportedModes == null) {
                return Algorithm.OPENSSL_BLOCK_MODES;
            }
            return StringHelper.split(supportedModes, '|');
        }
        return null;
    }

    private static Provider.Service providerCipherService(String alg) {
        Provider securityProvider = SecurityHelper.securityProvider;
        if (securityProvider != null) {
            return securityProvider.getService("Cipher", alg);
        }
        return null;
    }

    private static String[] registeredCipherModes(String alg) {
        boolean serviceFound = false;
        Provider[] providers = Security.getProviders();
        for (int i2 = 0; i2 < providers.length; ++i2) {
            Provider.Service service;
            String name2;
            Provider provider = providers[i2];
            String string = name2 = provider.getName() == null ? "" : provider.getName();
            if (name2.contains("JGSS") || name2.contains("SASL") || name2.contains("XMLD") || name2.contains("PCSC") || name2.contains("JSSE") || (service = provider.getService("Cipher", alg)) == null) continue;
            serviceFound = true;
            String supportedModes = service.getAttribute("SupportedModes");
            if (supportedModes == null) continue;
            return StringHelper.split(supportedModes, '|');
        }
        return serviceFound ? Algorithm.OPENSSL_BLOCK_MODES : null;
    }

    private static javax.crypto.Cipher getCipherInstance(String transformation, boolean silent) throws NoSuchAlgorithmException, NoSuchPaddingException {
        try {
            return SecurityHelper.getCipher(transformation);
        }
        catch (NoSuchAlgorithmException e) {
            if (silent) {
                return null;
            }
            throw e;
        }
        catch (NoSuchPaddingException e) {
            if (silent) {
                return null;
            }
            throw e;
        }
    }

    public Cipher(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    private void dumpVars(PrintStream out, String header) {
        out.println(this.toString() + ' ' + header + "\n name = " + this.name + " cryptoBase = " + this.cryptoBase + " cryptoVersion = " + this.cryptoVersion + " cryptoMode = " + this.cryptoMode + " padding_type = " + this.paddingType + " realName = " + this.realName + " keyLength = " + this.keyLength + " ivLength = " + this.ivLength + "\n cipher.alg = " + (this.cipher == null ? null : this.cipher.getAlgorithm()) + " cipher.blockSize = " + (this.cipher == null ? null : Integer.valueOf(this.cipher.getBlockSize())) + " encryptMode = " + this.encryptMode + " cipherInited = " + this.cipherInited + " key.length = " + (this.key == null ? 0 : this.key.length) + " iv.length = " + (this.realIV == null ? 0 : this.realIV.length) + " padding = " + this.padding);
    }

    @JRubyMethod(required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2, IRubyObject name2) {
        this.initializeImpl(context2.runtime, name2.toString());
        return this;
    }

    final void initializeImpl(Ruby runtime, String name2) {
        if (this.cipher != null) {
            throw runtime.newRuntimeError("Cipher already inititalized!");
        }
        this.updateCipher(name2, this.padding);
    }

    @JRubyMethod(required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject obj) {
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        Cipher other = (Cipher)obj;
        this.cryptoBase = other.cryptoBase;
        this.cryptoVersion = other.cryptoVersion;
        this.cryptoMode = other.cryptoMode;
        this.paddingType = other.paddingType;
        this.realName = other.realName;
        this.name = other.name;
        this.keyLength = other.keyLength;
        this.ivLength = other.ivLength;
        this.encryptMode = other.encryptMode;
        this.cipherInited = false;
        this.key = (byte[])(other.key != null ? Arrays.copyOf(other.key, other.key.length) : null);
        this.realIV = (byte[])(other.realIV != null ? Arrays.copyOf(other.realIV, other.realIV.length) : null);
        this.orgIV = this.realIV;
        this.padding = other.padding;
        this.cipher = this.getCipherInstance();
        return this;
    }

    @JRubyMethod
    public final RubyString name() {
        return this.getRuntime().newString(this.name);
    }

    @JRubyMethod
    public final RubyInteger key_len() {
        return this.getRuntime().newFixnum(this.keyLength);
    }

    @JRubyMethod
    public final RubyInteger iv_len() {
        return this.getRuntime().newFixnum(this.ivLength);
    }

    @JRubyMethod(name={"key_len="}, required=1)
    public final IRubyObject set_key_len(IRubyObject len) {
        this.keyLength = RubyNumeric.fix2int((IRubyObject)len);
        return len;
    }

    @JRubyMethod(name={"key="}, required=1)
    public IRubyObject set_key(ThreadContext context2, IRubyObject key) {
        ByteList keyBytes;
        try {
            keyBytes = key.asString().getByteList();
        }
        catch (Exception e) {
            Ruby runtime = context2.runtime;
            OpenSSL.debugStackTrace(runtime, e);
            throw Cipher.newCipherError(runtime, e);
        }
        if (keyBytes.getRealSize() < this.keyLength) {
            throw Cipher.newCipherError(context2.runtime, "key length too short");
        }
        byte[] k = new byte[this.keyLength];
        System.arraycopy(keyBytes.unsafeBytes(), keyBytes.getBegin(), k, 0, this.keyLength);
        this.key = k;
        return key;
    }

    @JRubyMethod(name={"iv="}, required=1)
    public IRubyObject set_iv(ThreadContext context2, IRubyObject iv) {
        ByteList ivBytes;
        try {
            ivBytes = iv.asString().getByteList();
        }
        catch (Exception e) {
            Ruby runtime = context2.runtime;
            OpenSSL.debugStackTrace(runtime, e);
            throw Cipher.newCipherError(runtime, e);
        }
        if (ivBytes.getRealSize() < this.ivLength) {
            throw Cipher.newCipherError(context2.runtime, "iv length too short");
        }
        byte[] i2 = new byte[this.ivLength];
        System.arraycopy(ivBytes.unsafeBytes(), ivBytes.getBegin(), i2, 0, this.ivLength);
        this.realIV = i2;
        this.orgIV = this.realIV;
        if (!this.isStreamCipher()) {
            this.cipherInited = false;
        }
        return iv;
    }

    @JRubyMethod
    public IRubyObject block_size(ThreadContext context2) {
        Ruby runtime = context2.runtime;
        this.checkCipherNotNull(runtime);
        if (this.isStreamCipher()) {
            return runtime.newFixnum(1);
        }
        return runtime.newFixnum(this.cipher.getBlockSize());
    }

    private void init(ThreadContext context2, IRubyObject[] args, boolean encrypt2) {
        Ruby runtime = context2.runtime;
        Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)0, (int)2);
        this.encryptMode = encrypt2;
        this.cipherInited = false;
        if (args.length > 0) {
            byte[] iv22;
            byte[] pass = args[0].asString().getBytes();
            byte[] iv = null;
            try {
                iv = "OpenSSL for Ruby rulez!".getBytes("ISO8859-1");
                iv22 = new byte[this.ivLength];
                System.arraycopy(iv, 0, iv22, 0, this.ivLength);
                iv = iv22;
            }
            catch (Exception iv22) {
                // empty catch block
            }
            if (args.length > 1 && !args[1].isNil()) {
                runtime.getWarnings().warning(IRubyWarnings.ID.MISCELLANEOUS, "key derivation by " + this.getMetaClass().getRealClass().getName() + "#encrypt is deprecated; use " + this.getMetaClass().getRealClass().getName() + "::pkcs5_keyivgen instead");
                iv = args[1].asString().getBytes();
                if (iv.length > this.ivLength) {
                    iv22 = new byte[this.ivLength];
                    System.arraycopy(iv, 0, iv22, 0, this.ivLength);
                    iv = iv22;
                }
            }
            MessageDigest digest2 = Digest.getDigest(runtime, "MD5");
            KeyAndIv result = Cipher.evpBytesToKey(this.keyLength, this.ivLength, digest2, iv, pass, 2048);
            this.key = result.key;
            this.realIV = iv;
            this.orgIV = this.realIV;
        }
    }

    @JRubyMethod(optional=2)
    public IRubyObject encrypt(ThreadContext context2, IRubyObject[] args) {
        this.realIV = this.orgIV;
        this.init(context2, args, true);
        return this;
    }

    @JRubyMethod(optional=2)
    public IRubyObject decrypt(ThreadContext context2, IRubyObject[] args) {
        this.realIV = this.orgIV;
        this.init(context2, args, false);
        return this;
    }

    @JRubyMethod
    public IRubyObject reset(ThreadContext context2) {
        Ruby runtime = context2.runtime;
        this.checkCipherNotNull(runtime);
        if (!this.isStreamCipher()) {
            this.realIV = this.orgIV;
            this.doInitCipher(runtime);
        }
        return this;
    }

    private void updateCipher(String name2, String padding) {
        this.name = name2.toUpperCase();
        this.padding = padding;
        Algorithm alg = Algorithm.osslToJava(this.name, this.padding);
        this.cryptoBase = alg.base;
        this.cryptoVersion = alg.version;
        this.cryptoMode = alg.mode;
        this.realName = alg.getRealName();
        this.paddingType = alg.getPadding();
        this.keyLength = alg.getKeyLength();
        this.ivLength = alg.getIvLength();
        if ("DES".equalsIgnoreCase(this.cryptoBase)) {
            this.generateKeyLength = this.keyLength / 8 * 7;
        }
        this.cipher = this.getCipherInstance();
    }

    final javax.crypto.Cipher getCipherInstance() {
        try {
            return Cipher.getCipherInstance(this.realName, false);
        }
        catch (NoSuchAlgorithmException e) {
            throw Cipher.newCipherError(this.getRuntime(), "unsupported cipher algorithm (" + this.realName + ")");
        }
        catch (NoSuchPaddingException e) {
            throw Cipher.newCipherError(this.getRuntime(), "unsupported cipher padding (" + this.realName + ")");
        }
    }

    @JRubyMethod(required=1, optional=3)
    public IRubyObject pkcs5_keyivgen(ThreadContext context2, IRubyObject[] args) {
        Ruby runtime = context2.runtime;
        Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)1, (int)4);
        byte[] pass = args[0].asString().getBytes();
        byte[] salt = null;
        int iter = 2048;
        IRubyObject vdigest = context2.nil;
        if (args.length > 1) {
            if (args[1] != context2.nil) {
                salt = args[1].asString().getBytes();
            }
            if (args.length > 2) {
                if (args[2] != context2.nil && (iter = RubyNumeric.num2int((IRubyObject)args[2])) <= 0) {
                    throw runtime.newArgumentError("iterations must be a positive integer");
                }
                if (args.length > 3) {
                    vdigest = args[3];
                }
            }
        }
        if (salt != null && salt.length != 8) {
            throw Cipher.newCipherError(runtime, "salt must be an 8-octet string");
        }
        String algorithm = vdigest.isNil() ? "MD5" : (vdigest instanceof Digest ? ((Digest)vdigest).getAlgorithm() : vdigest.asJavaString());
        MessageDigest digest2 = Digest.getDigest(runtime, algorithm);
        KeyAndIv result = Cipher.evpBytesToKey(this.keyLength, this.ivLength, digest2, salt, pass, iter);
        this.key = result.key;
        this.realIV = result.iv;
        this.orgIV = this.realIV;
        this.doInitCipher(runtime);
        return runtime.getNil();
    }

    private void doInitCipher(Ruby runtime) {
        if (OpenSSL.isDebug(runtime)) {
            this.dumpVars(runtime.getOut(), "doInitCipher()");
        }
        this.checkCipherNotNull(runtime);
        if (this.key == null) {
            throw Cipher.newCipherError(runtime, "key not specified");
        }
        try {
            if ("ECB".equalsIgnoreCase(this.cryptoMode)) {
                this.cipher.init(this.encryptMode ? 1 : 2, new SimpleSecretKey(this.getCipherAlgorithm(), this.key));
            } else {
                if (this.realIV == null) {
                    this.realIV = new byte[this.ivLength];
                }
                if ("RC2".equalsIgnoreCase(this.cryptoBase)) {
                    this.cipher.init(this.encryptMode ? 1 : 2, (Key)new SimpleSecretKey("RC2", this.key), new RC2ParameterSpec(this.key.length * 8, this.realIV));
                } else if ("RC4".equalsIgnoreCase(this.cryptoBase)) {
                    this.cipher.init(this.encryptMode ? 1 : 2, new SimpleSecretKey("RC4", this.key));
                } else {
                    AlgorithmParameterSpec ivSpec = "GCM".equalsIgnoreCase(this.cryptoMode) ? new GCMParameterSpec(this.getAuthTagLength() * 8, this.realIV) : new IvParameterSpec(this.realIV);
                    this.cipher.init(this.encryptMode ? 1 : 2, (Key)new SimpleSecretKey(this.getCipherAlgorithm(), this.key), ivSpec);
                }
            }
        }
        catch (InvalidKeyException e) {
            throw Cipher.newCipherError(runtime, e + "\n possibly you need to install Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files for your JRE");
        }
        catch (Exception e) {
            OpenSSL.debugStackTrace(runtime, e);
            throw Cipher.newCipherError(runtime, e);
        }
        this.cipherInited = true;
        this.processedDataBytes = 0;
    }

    private String getCipherAlgorithm() {
        int idx = this.realName.indexOf(47);
        return idx <= 0 ? this.realName : this.realName.substring(0, idx);
    }

    @JRubyMethod
    public IRubyObject update(ThreadContext context2, IRubyObject arg) {
        return this.update(context2, arg, null);
    }

    @JRubyMethod
    public IRubyObject update(ThreadContext context2, IRubyObject arg, IRubyObject buffer) {
        ByteList str;
        Ruby runtime = context2.runtime;
        if (OpenSSL.isDebug(runtime)) {
            this.dumpVars(runtime.getOut(), "update()");
        }
        this.checkCipherNotNull(runtime);
        this.checkAuthTag(runtime);
        ByteList data = arg.asString().getByteList();
        int length = data.getRealSize();
        if (length == 0) {
            throw runtime.newArgumentError("data must not be empty");
        }
        if (!this.cipherInited) {
            this.doInitCipher(runtime);
        }
        try {
            this.updateAuthData(runtime);
            byte[] in = data.getUnsafeBytes();
            int offset = data.begin();
            byte[] out = this.cipher.update(in, offset, length);
            if (out != null) {
                str = new ByteList(out, false);
                if (this.realIV != null) {
                    if (this.encryptMode) {
                        this.setLastIVIfNeeded(out);
                    } else {
                        this.setLastIVIfNeeded(in, offset, length);
                    }
                }
                this.processedDataBytes += length;
            } else {
                str = new ByteList(ByteList.NULL_ARRAY);
            }
        }
        catch (Exception e) {
            OpenSSL.debugStackTrace(runtime, e);
            throw Cipher.newCipherError(runtime, e);
        }
        if (buffer == null) {
            return RubyString.newString((Ruby)runtime, (ByteList)str);
        }
        buffer = TypeConverter.convertToType((IRubyObject)buffer, (RubyClass)context2.runtime.getString(), (String)"to_str", (boolean)true);
        ((RubyString)buffer).setValue(str);
        return buffer;
    }

    @JRubyMethod(name={"<<"})
    public IRubyObject update_deprecated(ThreadContext context2, IRubyObject data) {
        context2.runtime.getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, this.getMetaClass().getRealClass().getName() + "#<< is deprecated; use #update instead");
        return this.update(context2, data);
    }

    @JRubyMethod(name={"final"})
    public IRubyObject do_final(ThreadContext context2) {
        ByteList str;
        Ruby runtime = context2.runtime;
        this.checkCipherNotNull(runtime);
        this.checkAuthTag(runtime);
        if (!this.cipherInited) {
            this.doInitCipher(runtime);
        }
        if ("RC4".equalsIgnoreCase(this.cryptoBase)) {
            return runtime.newString("");
        }
        try {
            if (this.isAuthDataMode()) {
                str = this.do_final_with_auth(runtime);
            } else {
                byte[] out = this.cipher.doFinal();
                if (out != null) {
                    str = new ByteList(out, false);
                    if (this.realIV != null) {
                        this.setLastIVIfNeeded(out);
                    }
                } else {
                    str = new ByteList(ByteList.NULL_ARRAY);
                }
            }
            if (this.realIV != null) {
                this.realIV = this.lastIV;
                this.doInitCipher(runtime);
            }
        }
        catch (GeneralSecurityException e) {
            OpenSSL.debugStackTrace(runtime, e);
            throw Cipher.newCipherError(runtime, e);
        }
        catch (RuntimeException e) {
            OpenSSL.debugStackTrace(runtime, e);
            throw Cipher.newCipherError(runtime, e);
        }
        return RubyString.newString((Ruby)runtime, (ByteList)str);
    }

    private ByteList do_final_with_auth(Ruby runtime) throws GeneralSecurityException {
        byte[] out;
        this.updateAuthData(runtime);
        if (this.encryptMode) {
            ByteList str;
            int len;
            byte[] out2 = this.cipher.doFinal();
            int strLen = out2.length - (len = this.getAuthTagLength());
            if (strLen > 0) {
                str = new ByteList(out2, 0, strLen, false);
            } else {
                str = new ByteList(ByteList.NULL_ARRAY);
                strLen = 0;
            }
            this.auth_tag = new ByteList(out2, strLen, out2.length - strLen);
            return str;
        }
        if (this.auth_tag != null) {
            byte[] tag = this.auth_tag.getUnsafeBytes();
            out = this.cipher.doFinal(tag, this.auth_tag.getBegin(), this.auth_tag.getRealSize());
        } else {
            out = this.cipher.doFinal();
        }
        return new ByteList(out, false);
    }

    private void checkAuthTag(Ruby runtime) {
        if (this.auth_tag != null && this.encryptMode) {
            throw Cipher.newCipherError(runtime, "authentication tag already generated by cipher");
        }
    }

    private void setLastIVIfNeeded(byte[] tmpIV) {
        this.setLastIVIfNeeded(tmpIV, 0, tmpIV.length);
    }

    private void setLastIVIfNeeded(byte[] tmpIV, int offset, int length) {
        int ivLen = this.ivLength;
        if (this.lastIV == null) {
            this.lastIV = new byte[ivLen];
        }
        if (length >= ivLen) {
            System.arraycopy(tmpIV, offset + (length - ivLen), this.lastIV, 0, ivLen);
        }
    }

    @JRubyMethod(name={"padding="})
    public IRubyObject set_padding(IRubyObject padding) {
        this.updateCipher(this.name, padding.toString());
        return padding;
    }

    @JRubyMethod(name={"auth_tag"})
    public IRubyObject auth_tag(ThreadContext context2) {
        if (this.auth_tag != null) {
            return RubyString.newString((Ruby)context2.runtime, (ByteList)this.auth_tag);
        }
        if (!this.isAuthDataMode()) {
            throw Cipher.newCipherError(context2.runtime, "authentication tag not supported by this cipher");
        }
        return context2.nil;
    }

    @JRubyMethod(name={"auth_tag="})
    public IRubyObject set_auth_tag(ThreadContext context2, IRubyObject tag) {
        if (!this.isAuthDataMode()) {
            throw Cipher.newCipherError(context2.runtime, "authentication tag not supported by this cipher");
        }
        RubyString auth_tag2 = tag.asString();
        this.auth_tag = StringHelper.setByteListShared(auth_tag2);
        return auth_tag2;
    }

    private boolean isAuthDataMode() {
        return "GCM".equalsIgnoreCase(this.cryptoMode) || "CCM".equalsIgnoreCase(this.cryptoMode);
    }

    private int getAuthTagLength() {
        return Math.min(16, this.key.length);
    }

    @JRubyMethod(name={"auth_data="})
    public IRubyObject set_auth_data(ThreadContext context2, IRubyObject data) {
        if (!this.isAuthDataMode()) {
            throw Cipher.newCipherError(context2.runtime, "authentication data not supported by this cipher");
        }
        RubyString auth_data = data.asString();
        this.auth_data = StringHelper.setByteListShared(auth_data);
        return auth_data;
    }

    private boolean updateAuthData(Ruby runtime) {
        if (this.auth_data == null) {
            return false;
        }
        byte[] data = this.auth_data.getUnsafeBytes();
        this.cipher.updateAAD(data, this.auth_data.getBegin(), this.auth_data.getRealSize());
        this.auth_data = null;
        return true;
    }

    @JRubyMethod(name={"authenticated?"})
    public RubyBoolean authenticated_p(ThreadContext context2) {
        return context2.runtime.newBoolean(this.isAuthDataMode());
    }

    @JRubyMethod
    public IRubyObject random_key(ThreadContext context2) {
        RubyString str = Random.random_bytes(context2, this.keyLength);
        this.set_key(context2, (IRubyObject)str);
        return str;
    }

    @JRubyMethod
    public IRubyObject random_iv(ThreadContext context2) {
        RubyString str = Random.random_bytes(context2, this.ivLength);
        this.set_iv(context2, (IRubyObject)str);
        return str;
    }

    final String getName() {
        return this.name;
    }

    final int getKeyLength() {
        return this.keyLength;
    }

    final int getGenerateKeyLength() {
        return this.generateKeyLength == -1 ? this.keyLength : this.generateKeyLength;
    }

    private void checkCipherNotNull(Ruby runtime) {
        if (this.cipher == null) {
            throw runtime.newRuntimeError("Cipher not inititalized!");
        }
    }

    private boolean isStreamCipher() {
        return this.cipher.getBlockSize() == 0;
    }

    private static RaiseException newCipherError(Ruby runtime, Exception e) {
        return Utils.newError(runtime, Cipher._Cipher(runtime).getClass("CipherError"), e);
    }

    private static RaiseException newCipherError(Ruby runtime, String message) {
        return Utils.newError(runtime, Cipher._Cipher(runtime).getClass("CipherError"), message);
    }

    private static KeyAndIv evpBytesToKey(int key_len2, int iv_len2, MessageDigest md, byte[] salt, byte[] data, int count) {
        byte[] key = new byte[key_len2];
        byte[] iv = new byte[iv_len2];
        if (data == null) {
            return new KeyAndIv(key, iv);
        }
        int key_ix = 0;
        int iv_ix = 0;
        byte[] md_buf = null;
        int nkey = key_len2;
        int niv = iv_len2;
        int addmd = 0;
        do {
            int i2;
            md.reset();
            if (addmd++ > 0) {
                md.update(md_buf);
            }
            md.update(data);
            if (salt != null) {
                md.update(salt, 0, 8);
            }
            md_buf = md.digest();
            for (i2 = 1; i2 < count; ++i2) {
                md.reset();
                md.update(md_buf);
                md_buf = md.digest();
            }
            if (nkey > 0) {
                for (i2 = 0; nkey != 0 && i2 != md_buf.length; --nkey, ++i2) {
                    key[key_ix++] = md_buf[i2];
                }
            }
            if (niv <= 0 || i2 == md_buf.length) continue;
            while (niv != 0 && i2 != md_buf.length) {
                iv[iv_ix++] = md_buf[i2];
                --niv;
                ++i2;
            }
        } while (nkey != 0 || niv != 0);
        return new KeyAndIv(key, iv);
    }

    public static class AES
    extends Cipher {
        private static final long serialVersionUID = -3627749495034257750L;
        final String keyLength;

        AES(Ruby runtime, RubyClass type, String keyLength) {
            super(runtime, type);
            this.keyLength = keyLength;
        }

        @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
        public IRubyObject initialize(ThreadContext context2, IRubyObject[] args) {
            String mode = args != null && args.length > 0 ? args[0].toString() : "CBC";
            this.initializeImpl(context2.runtime, "AES-" + this.keyLength + '-' + mode);
            return this;
        }
    }

    private static class AESCipherAllocator
    implements ObjectAllocator {
        private final String keyLength;

        AESCipherAllocator(String keyLength) {
            this.keyLength = keyLength;
        }

        public AES allocate(Ruby runtime, RubyClass klass) {
            return new AES(runtime, klass, this.keyLength);
        }
    }

    public static class Named
    extends Cipher {
        private static final long serialVersionUID = 5599069534014317221L;
        final String cipherBase;

        Named(Ruby runtime, RubyClass type, String cipherBase) {
            super(runtime, type);
            this.cipherBase = cipherBase;
        }

        @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
        public IRubyObject initialize(ThreadContext context2, IRubyObject[] args) {
            StringBuilder name2 = new StringBuilder();
            name2.append(this.cipherBase);
            if (args != null) {
                for (int i2 = 0; i2 < args.length; ++i2) {
                    name2.append('-').append(args[i2].asString());
                }
            }
            this.initializeImpl(context2.runtime, name2.toString());
            return this;
        }
    }

    private static class NamedCipherAllocator
    implements ObjectAllocator {
        private final String cipherBase;

        NamedCipherAllocator(String cipherBase) {
            this.cipherBase = cipherBase;
        }

        public Named allocate(Ruby runtime, RubyClass klass) {
            return new Named(runtime, klass, this.cipherBase);
        }
    }

    private static class KeyAndIv {
        final byte[] key;
        final byte[] iv;

        KeyAndIv(byte[] key, byte[] iv) {
            this.key = key;
            this.iv = iv;
        }
    }

    public static final class Algorithm {
        final String base;
        final String version;
        final String mode;
        private String padding;
        private String realName;
        private boolean realNameNeedsPadding;
        private int keyLength = -1;
        private int ivLength = -1;
        private static final Set<String> KNOWN_BLOCK_MODES;
        private static final String[] OPENSSL_BLOCK_MODES;
        private static final Set<String> NO_PADDING_BLOCK_MODES;
        static final HashMap<String, String[]> supportedCiphers;
        static boolean supportedCiphersAll;

        Algorithm(String cryptoBase, String cryptoVersion, String cryptoMode) {
            this.base = cryptoBase;
            this.version = cryptoVersion;
            this.mode = cryptoMode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Map<String, String[]> allSupportedCiphers() {
            if (supportedCiphersAll) {
                return supportedCiphers;
            }
            HashMap<String, String[]> hashMap = supportedCiphers;
            synchronized (hashMap) {
                if (supportedCiphersAll) {
                    return supportedCiphers;
                }
                String[] modes = Cipher.cipherModes("AES");
                if (modes != null) {
                    for (String mode : modes) {
                        String realName2 = "AES/" + mode;
                        supportedCiphers.put("AES-128-" + mode, new String[]{"AES", mode, "128", realName2});
                        supportedCiphers.put("AES-192-" + mode, new String[]{"AES", mode, "192", realName2});
                        supportedCiphers.put("AES-256-" + mode, new String[]{"AES", mode, "256", realName2});
                    }
                    String string = "AES/CBC";
                    supportedCiphers.put("AES128", new String[]{"AES", "CBC", "128", "AES/CBC"});
                    supportedCiphers.put("AES192", new String[]{"AES", "CBC", "192", "AES/CBC"});
                    supportedCiphers.put("AES256", new String[]{"AES", "CBC", "256", "AES/CBC"});
                }
                if ((modes = Cipher.cipherModes("Blowfish")) != null) {
                    supportedCiphers.put("BF", new String[]{"BF", "CBC", null, "Blowfish/CBC"});
                    for (String mode : modes) {
                        supportedCiphers.put("BF-" + mode, new String[]{"BF", mode, null, "Blowfish/" + mode});
                    }
                }
                if ((modes = Cipher.cipherModes("Camellia")) != null) {
                    for (String mode : modes) {
                        String realName = "Camellia/" + mode;
                        supportedCiphers.put("CAMELLIA-128-" + mode, new String[]{"CAMELLIA", mode, "128", realName});
                        supportedCiphers.put("CAMELLIA-192-" + mode, new String[]{"CAMELLIA", mode, "192", realName});
                        supportedCiphers.put("CAMELLIA-256-" + mode, new String[]{"CAMELLIA", mode, "256", realName});
                    }
                    String string = "Camellia/CBC";
                    supportedCiphers.put("CAMELLIA128", new String[]{"CAMELLIA", "CBC", "128", "Camellia/CBC"});
                    supportedCiphers.put("CAMELLIA192", new String[]{"CAMELLIA", "CBC", "192", "Camellia/CBC"});
                    supportedCiphers.put("CAMELLIA256", new String[]{"CAMELLIA", "CBC", "256", "Camellia/CBC"});
                }
                if ((modes = Cipher.cipherModes("CAST5")) != null) {
                    supportedCiphers.put("CAST", new String[]{"CAST", "CBC", null, "CAST5/CBC"});
                    supportedCiphers.put("CAST-CBC", supportedCiphers.get("CAST"));
                    for (String mode : modes) {
                        supportedCiphers.put("CAST5-" + mode, new String[]{"CAST", mode, null, "CAST5/" + mode});
                    }
                }
                if ((modes = Cipher.cipherModes("CAST6")) != null) {
                    for (String mode : modes) {
                        supportedCiphers.put("CAST6-" + mode, new String[]{"CAST6", mode, null, "CAST6/" + mode});
                    }
                }
                if ((modes = Cipher.cipherModes("DES")) != null) {
                    supportedCiphers.put("DES", new String[]{"DES", "CBC", null, "DES/CBC"});
                    for (String mode : modes) {
                        supportedCiphers.put("DES-" + mode, new String[]{"DES", mode, null, "DES/" + mode});
                    }
                }
                if ((modes = Cipher.cipherModes("DESede")) != null) {
                    supportedCiphers.put("DES-EDE", new String[]{"DES", "ECB", "EDE", "DESede/ECB"});
                    supportedCiphers.put("DES-EDE-CBC", new String[]{"DES", "CBC", "EDE", "DESede/CBC"});
                    supportedCiphers.put("DES-EDE-CFB", new String[]{"DES", "CBC", "EDE", "DESede/CFB"});
                    supportedCiphers.put("DES-EDE-OFB", new String[]{"DES", "CBC", "EDE", "DESede/OFB"});
                    supportedCiphers.put("DES-EDE3", new String[]{"DES", "ECB", "EDE3", "DESede/ECB"});
                    for (String mode : modes) {
                        supportedCiphers.put("DES-EDE3-" + mode, new String[]{"DES", mode, "EDE3", "DESede/" + mode});
                    }
                    supportedCiphers.put("DES3", new String[]{"DES", "CBC", "EDE3", "DESede/CBC"});
                }
                if ((modes = Cipher.cipherModes("RC2")) != null) {
                    supportedCiphers.put("RC2", new String[]{"RC2", "CBC", null, "RC2/CBC"});
                    for (String mode : modes) {
                        supportedCiphers.put("RC2-" + mode, new String[]{"RC2", mode, null, "RC2/" + mode});
                    }
                    supportedCiphers.put("RC2-40-CBC", new String[]{"RC2", "CBC", "40", "RC2/CBC"});
                    supportedCiphers.put("RC2-64-CBC", new String[]{"RC2", "CBC", "64", "RC2/CBC"});
                }
                if ((modes = Cipher.cipherModes("RC4")) != null) {
                    supportedCiphers.put("RC4", new String[]{"RC4", null, null, "RC4"});
                    supportedCiphers.put("RC4-40", new String[]{"RC4", null, "40", "RC4"});
                }
                if ((modes = Cipher.cipherModes("SEED")) != null) {
                    supportedCiphers.put("SEED", new String[]{"SEED", "CBC", null, "SEED/CBC"});
                    for (String mode : modes) {
                        supportedCiphers.put("SEED-" + mode, new String[]{"SEED", mode, null, "SEED/" + mode});
                    }
                }
                supportedCiphersAll = true;
                return supportedCiphers;
            }
        }

        @Deprecated
        public static String jsseToOssl(String cipherName, int keyLength) {
            return Algorithm.javaToOssl(cipherName, keyLength);
        }

        public static String javaToOssl(String cipherName, int keyLength) {
            String cryptoVersion = null;
            String cryptoMode = null;
            ArrayList<String> parts = StringHelper.split(cipherName, '/');
            int partsLength = parts.size();
            if (partsLength != 1 && partsLength != 3) {
                return null;
            }
            if (partsLength > 2) {
                cryptoMode = (String)parts.get(1);
            }
            String cryptoBase = (String)parts.get(0);
            if (!KNOWN_BLOCK_MODES.contains(cryptoMode)) {
                cryptoVersion = cryptoMode;
                cryptoMode = "CBC";
            }
            if (cryptoMode == null) {
                cryptoMode = "CBC";
            }
            if ("DESede".equals(cryptoBase)) {
                cryptoBase = "DES";
                cryptoVersion = "EDE3";
            } else if ("Blowfish".equals(cryptoBase)) {
                cryptoBase = "BF";
            }
            if (cryptoVersion == null) {
                cryptoVersion = String.valueOf(keyLength);
            }
            return cryptoBase + '-' + cryptoVersion + '-' + cryptoMode;
        }

        static Algorithm osslToJava(String osslName) {
            return Algorithm.osslToJava(osslName, null);
        }

        private static Algorithm osslToJava(String osslName, String padding) {
            String version2;
            String realName;
            String cryptoMode;
            String cryptoBase;
            String[] algVals = supportedCiphers.get(osslName);
            if (algVals != null) {
                String cryptoMode2 = algVals[1];
                Algorithm alg = new Algorithm(algVals[0], algVals[2], cryptoMode2);
                alg.realName = algVals[3];
                alg.realNameNeedsPadding = true;
                alg.padding = Algorithm.getPaddingType(padding, cryptoMode2);
                return alg;
            }
            String cryptoVersion = null;
            String paddingType = null;
            if (osslName.indexOf(47) != -1) {
                ArrayList<String> names = StringHelper.split(osslName, '/');
                String cryptoBase2 = (String)names.get(0);
                String cryptoMode3 = names.size() > 1 ? (String)names.get(1) : "CBC";
                paddingType = Algorithm.getPaddingType(padding, cryptoMode3);
                if (names.size() > 2) {
                    paddingType = (String)names.get(2);
                }
                Algorithm alg = new Algorithm(cryptoBase2, null, cryptoMode3);
                alg.realName = osslName;
                alg.padding = paddingType;
                return alg;
            }
            int s2 = osslName.indexOf(45);
            int i2 = 0;
            if (s2 == -1) {
                cryptoBase = osslName;
                cryptoMode = null;
            } else {
                cryptoBase = osslName.substring(i2, s2);
                i2 = s2 + 1;
                if ((s2 = osslName.indexOf(45, i2)) == -1) {
                    cryptoMode = osslName.substring(i2);
                } else {
                    cryptoVersion = osslName.substring(i2, s2);
                    i2 = s2 + 1;
                    cryptoMode = (s2 = osslName.indexOf(45, i2)) == -1 ? osslName.substring(i2) : osslName.substring(i2, s2);
                }
            }
            cryptoBase = cryptoBase.toUpperCase();
            if (cryptoMode != null) {
                cryptoMode = cryptoMode.toUpperCase();
            }
            boolean realNameSet = false;
            boolean setDefaultCryptoMode = true;
            if ("BF".equals(cryptoBase)) {
                realName = "Blowfish";
            } else if ("CAST".equals(cryptoBase)) {
                realName = "CAST5";
            } else if (cryptoBase.startsWith("DES")) {
                if ("DES3".equals(cryptoBase)) {
                    cryptoBase = "DES";
                    realName = "DESede";
                    cryptoVersion = "EDE3";
                } else if ("EDE3".equalsIgnoreCase(cryptoVersion) || "EDE".equalsIgnoreCase(cryptoVersion)) {
                    realName = "DESede";
                    if (cryptoMode == null) {
                        cryptoMode = "ECB";
                    }
                } else if ("EDE3".equalsIgnoreCase(cryptoMode) || "EDE".equalsIgnoreCase(cryptoMode)) {
                    realName = "DESede";
                    cryptoVersion = cryptoMode;
                    cryptoMode = "ECB";
                } else {
                    realName = "DES";
                }
            } else if (cryptoBase.length() > 3 && cryptoBase.startsWith("AES")) {
                try {
                    version2 = cryptoBase.substring(3);
                    Integer.parseInt(version2);
                    cryptoBase = "AES";
                    realName = "AES";
                    cryptoVersion = version2;
                }
                catch (NumberFormatException e) {
                    realName = cryptoBase;
                }
            } else if (cryptoBase.length() > 8 && cryptoBase.startsWith("CAMELLIA")) {
                try {
                    version2 = cryptoBase.substring(8);
                    Integer.parseInt(version2);
                    cryptoBase = "CAMELLIA";
                    realName = "CAMELLIA";
                    cryptoVersion = version2;
                }
                catch (NumberFormatException e) {
                    realName = cryptoBase;
                }
            } else {
                realName = cryptoBase;
                if ("RC4".equals(cryptoBase)) {
                    if (!KNOWN_BLOCK_MODES.contains(cryptoMode)) {
                        cryptoVersion = cryptoMode;
                    }
                    cryptoMode = null;
                    setDefaultCryptoMode = false;
                    realNameSet = true;
                }
            }
            if (cryptoMode == null && setDefaultCryptoMode) {
                cryptoMode = "CBC";
            }
            if (paddingType == null) {
                paddingType = Algorithm.getPaddingType(padding, cryptoMode);
            }
            if (cryptoMode != null) {
                if (!realNameSet) {
                    realName = realName + '/' + cryptoMode + '/' + paddingType;
                }
            } else if (!realNameSet && padding != null) {
                realName = realName + '/' + "NONE" + '/' + paddingType;
            }
            Algorithm alg = new Algorithm(cryptoBase, cryptoVersion, cryptoMode);
            alg.realName = realName;
            alg.padding = paddingType;
            return alg;
        }

        String getPadding() {
            if (this.mode == null) {
                return null;
            }
            return this.padding;
        }

        private static String getPaddingType(String padding, String cryptoMode) {
            String defaultPadding = "PKCS5Padding";
            if (padding == null) {
                if (NO_PADDING_BLOCK_MODES.contains(cryptoMode)) {
                    return "NoPadding";
                }
                return "PKCS5Padding";
            }
            if (padding.equalsIgnoreCase("PKCS5Padding")) {
                return "PKCS5Padding";
            }
            if (padding.equals("0") || padding.equalsIgnoreCase("NoPadding")) {
                return "NoPadding";
            }
            if (padding.equalsIgnoreCase("ISO10126Padding")) {
                return "ISO10126Padding";
            }
            if (padding.equalsIgnoreCase("PKCS1Padding")) {
                return "PKCS1Padding";
            }
            if (padding.equalsIgnoreCase("SSL3Padding")) {
                return "SSL3Padding";
            }
            if (padding.equalsIgnoreCase("OAEPPadding")) {
                return "OAEPPadding";
            }
            return "PKCS5Padding";
        }

        String getRealName() {
            if (this.realName != null) {
                if (this.realNameNeedsPadding) {
                    String padding = this.getPadding();
                    if (padding != null) {
                        this.realName = this.realName + '/' + padding;
                    }
                    this.realNameNeedsPadding = false;
                }
                return this.realName;
            }
            this.realName = this.base + '/' + (this.mode == null ? "NONE" : this.mode) + '/' + this.padding;
            return this.realName;
        }

        public static String getAlgorithmBase(javax.crypto.Cipher cipher2) {
            String algorithm = cipher2.getAlgorithm();
            int idx = algorithm.indexOf(47);
            if (idx != -1) {
                return algorithm.substring(0, idx);
            }
            return algorithm;
        }

        public static String getRealName(String osslName) {
            return Algorithm.osslToJava(osslName).getRealName();
        }

        public int getIvLength() {
            if (this.ivLength != -1) {
                return this.ivLength;
            }
            this.getKeyLength();
            if (this.ivLength == -1) {
                if ("AES".equals(this.base)) {
                    this.ivLength = 16;
                    if ("GCM".equals(this.mode) || "CCM".equals(this.mode)) {
                        this.ivLength = 12;
                    }
                } else {
                    this.ivLength = "ECB".equals(this.mode) ? 0 : 8;
                }
            }
            return this.ivLength;
        }

        public int getKeyLength() {
            if (this.keyLength != -1) {
                return this.keyLength;
            }
            int keyLen = -1;
            if (this.version != null) {
                try {
                    keyLen = Integer.parseInt(this.version) / 8;
                }
                catch (NumberFormatException e) {
                    keyLen = -1;
                }
            }
            if (keyLen == -1) {
                if ("DES".equals(this.base)) {
                    keyLen = "EDE".equalsIgnoreCase(this.version) ? 16 : ("EDE3".equalsIgnoreCase(this.version) ? 24 : 8);
                } else if ("RC4".equals(this.base)) {
                    keyLen = 16;
                } else {
                    keyLen = 16;
                    try {
                        String name2 = this.getRealName();
                        int maxLen = javax.crypto.Cipher.getMaxAllowedKeyLength(name2) / 8;
                        if (maxLen < keyLen) {
                            keyLen = maxLen;
                        }
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        // empty catch block
                    }
                }
            }
            this.keyLength = keyLen;
            return this.keyLength;
        }

        @Deprecated
        public static int[] osslKeyIvLength(String cipherName) {
            Algorithm alg = Algorithm.osslToJava(cipherName);
            return new int[]{alg.getKeyLength(), alg.getIvLength()};
        }

        public String toString() {
            return this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode()) + "<base=" + this.base + " mode=" + this.mode + " version=" + this.version + " padding=" + this.padding + " realName=" + this.realName + " realNameNeedsPadding=" + this.realNameNeedsPadding + ">";
        }

        static {
            OPENSSL_BLOCK_MODES = new String[]{"CBC", "CFB", "CFB8", "ECB", "OFB"};
            KNOWN_BLOCK_MODES = new HashSet<String>(10, 1.0f);
            for (String mode : OPENSSL_BLOCK_MODES) {
                KNOWN_BLOCK_MODES.add(mode);
            }
            KNOWN_BLOCK_MODES.add("CTR");
            KNOWN_BLOCK_MODES.add("CTS");
            KNOWN_BLOCK_MODES.add("PCBC");
            KNOWN_BLOCK_MODES.add("NONE");
            NO_PADDING_BLOCK_MODES = new HashSet<String>(6, 1.0f);
            NO_PADDING_BLOCK_MODES.add("CFB");
            NO_PADDING_BLOCK_MODES.add("CFB8");
            NO_PADDING_BLOCK_MODES.add("OFB");
            NO_PADDING_BLOCK_MODES.add("CTR");
            NO_PADDING_BLOCK_MODES.add("GCM");
            supportedCiphers = new LinkedHashMap<String, String[]>(120, 1.0f);
        }
    }
}

