/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericImageEncoder;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.Interface;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

abstract class OutputManager {
    protected Viewer vwr;
    protected double privateKey;
    protected static final String SCENE_TAG = "###scene.spt###";

    OutputManager() {
    }

    protected abstract String getLogPath(String var1);

    abstract String clipImageOrPasteText(String var1);

    abstract String getClipboardText();

    abstract OC openOutputChannel(double var1, String var3, boolean var4, boolean var5) throws IOException;

    protected abstract String createSceneSet(String var1, String var2, int var3, int var4);

    OutputManager setViewer(Viewer vwr, double privateKey) {
        this.vwr = vwr;
        this.privateKey = privateKey;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeToOutputChannel(Map<String, Object> params) {
        String type = (String)params.get("type");
        String fileName = (String)params.get("fileName");
        String text = (String)params.get("text");
        byte[] bytes = (byte[])params.get("bytes");
        int quality = OutputManager.getInt(params, "quality", Integer.MIN_VALUE);
        OC out = (OC)params.get("outputChannel");
        boolean closeStream = out == null;
        int len = -1;
        String ret = null;
        try {
            if (!this.vwr.checkPrivateKey(this.privateKey)) {
                String string = "ERROR: SECURITY";
                return string;
            }
            if (bytes != null) {
                if (out == null) {
                    out = this.openOutputChannel(this.privateKey, fileName, false, false);
                }
                out.write(bytes, 0, bytes.length);
            } else if (text != null && !type.equals("ZIPDATA") && !type.equals("BINARY")) {
                if (out == null) {
                    out = this.openOutputChannel(this.privateKey, fileName, true, false);
                }
                out.append(text);
            } else {
                String errMsg = (String)this.getOrSaveImage(params);
                if (errMsg != null) {
                    String string = errMsg;
                    return string;
                }
                len = (Integer)params.get("byteCount");
            }
        }
        catch (Exception exc) {
            Logger.errorEx("IO Exception", exc);
            String string = exc.toString();
            return string;
        }
        finally {
            if (out != null) {
                if (closeStream) {
                    ret = out.closeChannel();
                }
                len = out.getByteCount();
            }
        }
        int pt = fileName.indexOf("?POST?");
        if (pt >= 0) {
            fileName = fileName.substring(0, pt);
        }
        return len < 0 ? "Creation of " + fileName + " failed: " + (ret == null ? this.vwr.getErrorMessageUn() : ret) : "OK " + type + " " + (len > 0 ? len + " " : "") + fileName + (quality == Integer.MIN_VALUE ? "" : "; quality=" + quality);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Object getOrSaveImage(Map<String, Object> params) throws Exception {
        block41: {
            block44: {
                block39: {
                    block40: {
                        block43: {
                            block42: {
                                block37: {
                                    block38: {
                                        block35: {
                                            block36: {
                                                block33: {
                                                    block34: {
                                                        bytes = null;
                                                        errMsg = null;
                                                        type = ((String)params.get("type")).toUpperCase();
                                                        fileName = (String)params.get("fileName");
                                                        scripts = (String[])params.get("scripts");
                                                        objImage = params.get("image");
                                                        rgbbuf = (int[])params.get("rgbbuf");
                                                        out = (OC)params.get("outputChannel");
                                                        asBytes = out == null && fileName == null;
                                                        closeChannel = out == null && fileName != null;
                                                        v0 = releaseImage = objImage == null;
                                                        image = type.equals("BINARY") != false || type.equals("ZIPDATA") != false ? "" : (rgbbuf != null ? (Object)rgbbuf : (objImage != null ? objImage : this.vwr.getScreenImageBuffer(null, true)));
                                                        isOK = false;
                                                        try {
                                                            if (image != null) break block33;
                                                            var15_15 = errMsg = this.vwr.getErrorMessage();
                                                            if (releaseImage) {
                                                                this.vwr.releaseScreenImage();
                                                            }
                                                            if (bytes == null && out == null) break block34;
                                                            params.put("byteCount", bytes != null ? bytes.length : (isOK != false ? out.getByteCount() : -1));
                                                        }
                                                        catch (Throwable var20_24) {
                                                            if (releaseImage) {
                                                                this.vwr.releaseScreenImage();
                                                            }
                                                            if (bytes != null || out != null) {
                                                                params.put("byteCount", bytes != null ? bytes.length : (isOK != false ? out.getByteCount() : -1));
                                                            }
                                                            if (objImage != null) {
                                                                return fileName;
                                                            }
                                                            throw var20_24;
                                                        }
                                                    }
                                                    if (objImage != null) {
                                                        return fileName;
                                                    }
                                                    return var15_15;
                                                }
                                                if (fileName == null || !fileName.startsWith("\u0001")) break block35;
                                                isOK = true;
                                                info = new Hashtable<String, String>();
                                                info.put("_IMAGE_", image);
                                                this.vwr.fm.loadImage(info, fileName, false);
                                                var16_18 = errMsg = "OK - viewing " + fileName.substring(1);
                                                if (releaseImage) {
                                                    this.vwr.releaseScreenImage();
                                                }
                                                if (bytes == null && out == null) break block36;
                                                params.put("byteCount", bytes != null ? bytes.length : (isOK != false ? out.getByteCount() : -1));
                                            }
                                            if (objImage != null) {
                                                return fileName;
                                            }
                                            return var16_18;
                                        }
                                        isPngj = type.equals("PNGJ");
                                        if (isPngj) ** GOTO lbl73
                                        if (out != null || (out = this.openOutputChannel(this.privateKey, fileName, false, false)) != null) break block37;
                                        errMsg = "ERROR: canceled";
                                        var16_19 = "ERROR: canceled";
                                        if (releaseImage) {
                                            this.vwr.releaseScreenImage();
                                        }
                                        if (bytes == null && out == null) break block38;
                                        params.put("byteCount", bytes != null ? bytes.length : (isOK != false ? out.getByteCount() : -1));
                                    }
                                    if (objImage != null) {
                                        return fileName;
                                    }
                                    return var16_19;
                                }
                                fileName = out.getFileName();
lbl73:
                                // 2 sources

                                comment = null;
                                stateData = null;
                                params.put("date", this.vwr.apiPlatform.getDateFormat("8601"));
                                if (!type.startsWith("JP")) break block42;
                                if ((type = PT.rep(type, "E", "")).equals("JPG64")) {
                                    params.put("outputChannelTemp", this.getOutputChannel(null, null));
                                    comment = "";
                                } else {
                                    comment = asBytes == false ? (String)this.getWrappedState(null, null, image, null) : "";
                                }
                                params.put("jpgAppTag", " #Jmol...\u0000");
                                ** GOTO lbl122
                            }
                            if (!type.equals("PDF")) break block43;
                            comment = "";
                            ** GOTO lbl122
                        }
                        if (!type.startsWith("PNG")) ** GOTO lbl122
                        comment = "";
                        if (!isPngj) ** GOTO lbl114
                        outTemp = this.getOutputChannel(null, null);
                        this.getWrappedState(fileName, scripts, image, outTemp);
                        stateData = outTemp.toByteArray();
                        if (out != null || (out = this.openOutputChannel(this.privateKey, fileName, false, false)) != null) break block39;
                        errMsg = "ERROR: canceled";
                        var19_23 = "ERROR: canceled";
                        if (releaseImage) {
                            this.vwr.releaseScreenImage();
                        }
                        if (bytes == null && out == null) break block40;
                        params.put("byteCount", bytes != null ? bytes.length : (isOK != false ? out.getByteCount() : -1));
                    }
                    if (objImage != null) {
                        return fileName;
                    }
                    return var19_23;
                }
                break block44;
lbl114:
                // 1 sources

                if (rgbbuf == null && !asBytes && !params.containsKey("captureMode")) {
                    stateData = ((String)this.getWrappedState(null, scripts, image, null)).getBytes();
                }
            }
            if (stateData != null) {
                params.put("pngAppData", stateData);
                params.put("pngAppPrefix", "Jmol Type");
            }
lbl122:
            // 6 sources

            if (type.equals("PNGT") || type.equals("GIFT")) {
                params.put("transparentColor", this.vwr.getBackgroundArgb());
            }
            if (type.length() == 4) {
                type = type.substring(0, 3);
            }
            if (comment != null) {
                params.put("comment", comment.length() == 0 ? Viewer.getJmolVersion() : comment);
            }
            errRet = new String[1];
            isOK = this.createTheImage(image, type, out, params, errRet);
            if (closeChannel) {
                out.closeChannel();
            }
            if (isOK) {
                if (params.containsKey("captureMsg") && !params.containsKey("captureSilent")) {
                    this.vwr.prompt((String)params.get("captureMsg"), "OK", null, true);
                }
                if (asBytes) {
                    bytes = out.toByteArray();
                } else if (params.containsKey("captureByteCount")) {
                    errMsg = "OK: " + params.get("captureByteCount").toString() + " bytes";
                }
            } else {
                errMsg = errRet[0];
            }
            if (releaseImage) {
                this.vwr.releaseScreenImage();
            }
            if (bytes == null && out == null) break block41;
            params.put("byteCount", bytes != null ? bytes.length : (isOK != false ? out.getByteCount() : -1));
        }
        if (objImage != null) {
            return fileName;
        }
        return errMsg == null ? bytes : (byte[])errMsg;
    }

    Object getWrappedState(String pngjName, String[] scripts, Object objImage, OC pgjOut) {
        int width = this.vwr.apiPlatform.getImageWidth(objImage);
        int height = this.vwr.apiPlatform.getImageHeight(objImage);
        if (width > 0 && !this.vwr.g.imageState && pgjOut == null || !this.vwr.g.preserveState) {
            return "";
        }
        String s = this.vwr.getStateInfo3(null, width, height);
        if (pgjOut != null) {
            return this.createZipSet(s, scripts, true, pgjOut, pngjName);
        }
        try {
            s = JC.embedScript(FileManager.setScriptFileReferences(s, ".", null, null));
        }
        catch (Throwable e) {
            Logger.error("state could not be saved: " + e.toString());
            s = "Jmol " + Viewer.getJmolVersion();
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createTheImage(Object objImage, String type, OC out, Map<String, Object> params, String[] errRet) {
        GenericImageEncoder ie;
        boolean isZipData = (type = type.substring(0, 1) + type.substring(1).toLowerCase()).equals("Zipdata");
        if (isZipData || type.equals("Binary")) {
            Lst v = (Lst)params.get("imageData");
            if (v.size() >= 2 && v.get(0).equals("_IMAGE_")) {
                if (isZipData) {
                    errRet[0] = this.writeZipFile(out, v, "OK JMOL", null);
                    return true;
                }
                objImage = null;
                v.removeItemAt(0);
                v.removeItemAt(0);
                params.put("pngImgData", v.removeItemAt(0));
                OC oz = this.getOutputChannel(null, null);
                errRet[0] = this.writeZipFile(oz, v, "OK JMOL", null);
                params.put("type", "PNGJ");
                type = "Png";
                params.put("pngAppPrefix", "Jmol Type");
                params.put("pngAppData", oz.toByteArray());
            } else {
                if (v.size() == 1) {
                    byte[] b = (byte[])v.removeItemAt(0);
                    out.write(b, 0, b.length);
                    return true;
                }
                errRet[0] = this.writeZipFile(out, v, "OK JMOL", null);
                return true;
            }
        }
        if ((ie = (GenericImageEncoder)Interface.getInterface("javajs.img." + type + "Encoder", this.vwr, "file")) == null) {
            errRet[0] = "Image encoder type " + type + " not available";
            return false;
        }
        boolean doClose = true;
        try {
            int w;
            if (type.equals("Gif") && this.vwr.getBoolean(603979962)) {
                params.put("reducedColors", Boolean.TRUE);
            }
            int n = objImage == null ? -1 : (w = AU.isAI(objImage) ? ((Integer)params.get("width")).intValue() : this.vwr.apiPlatform.getImageWidth(objImage));
            int h = objImage == null ? -1 : (AU.isAI(objImage) ? ((Integer)params.get("height")).intValue() : this.vwr.apiPlatform.getImageHeight(objImage));
            params.put("imageWidth", w);
            params.put("imageHeight", h);
            int[] pixels = this.encodeImage(w, h, objImage);
            if (pixels != null) {
                params.put("imagePixels", pixels);
            }
            params.put("logging", Logger.debugging);
            doClose = ie.createImage(type, out, params);
        }
        catch (Exception e) {
            errRet[0] = e.toString();
            out.cancel();
            doClose = true;
        }
        finally {
            if (doClose) {
                out.closeChannel();
            }
        }
        return errRet[0] == null;
    }

    private int[] encodeImage(int width, int height, Object objImage) throws Exception {
        int[] pixels;
        if (width < 0) {
            return null;
        }
        if (AU.isAI(objImage)) {
            pixels = (int[])objImage;
        } else {
            pixels = new int[width * height];
            pixels = this.vwr.apiPlatform.grabPixels(objImage, width, height, pixels, 0, height);
        }
        return pixels;
    }

    String outputToFile(Map<String, Object> params) {
        return this.handleOutputToFile(params, true);
    }

    OC getOutputChannel(String fileName, String[] fullPath) {
        boolean isRemote;
        if (!this.vwr.haveAccess(Viewer.ACCESS.ALL)) {
            return null;
        }
        boolean isCache = fileName != null && fileName.startsWith("cache://");
        boolean bl = isRemote = fileName != null && (fileName.startsWith("http://") || fileName.startsWith("https://"));
        if (fileName != null && !isCache && !isRemote && (fileName = this.getOutputFileNameFromDialog(fileName, Integer.MIN_VALUE, null)) == null) {
            return null;
        }
        if (fullPath != null) {
            fullPath[0] = fileName;
        }
        String localName = isRemote || isCache || OC.isLocal(fileName) ? fileName : null;
        try {
            return this.openOutputChannel(this.privateKey, localName, false, false);
        }
        catch (IOException e) {
            Logger.info(e.toString());
            return null;
        }
    }

    String processWriteOrCapture(Map<String, Object> params) {
        String fileName = (String)params.get("fileName");
        if (fileName == null) {
            return this.vwr.clipImageOrPasteText((String)params.get("text"));
        }
        BS bsFrames = (BS)params.get("bsFrames");
        int nVibes = OutputManager.getInt(params, "nVibes", 0);
        return bsFrames != null || nVibes != 0 ? this.processMultiFrameOutput(fileName, bsFrames, nVibes, params) : this.handleOutputToFile(params, true);
    }

    private static int getInt(Map<String, Object> params, String key, int def) {
        Integer p = (Integer)params.get(key);
        return p == null ? def : p;
    }

    private String processMultiFrameOutput(String fileName, BS bsFrames, int nVibes, Map<String, Object> params) {
        String info = "";
        int n = 0;
        int quality = OutputManager.getInt(params, "quality", -1);
        if ((fileName = this.setFullPath(params, this.getOutputFileNameFromDialog(fileName, quality, null))) == null) {
            return null;
        }
        String[] rootExt = new String[2];
        OutputManager.getRootExt(fileName, rootExt, 0);
        SB sb = new SB();
        if (bsFrames == null) {
            this.vwr.tm.vibrationOn = true;
            sb = new SB();
            for (int i = 0; i < nVibes; ++i) {
                for (int j = 0; j < 20; ++j) {
                    this.vwr.tm.setVibrationT((float)j / 20.0f + 0.2501f);
                    if (this.writeFrame(++n, rootExt, params, sb)) continue;
                    return "ERROR WRITING FILE SET: \n" + info;
                }
            }
            this.vwr.tm.setVibrationPeriod(0.0f);
        } else {
            int i = bsFrames.nextSetBit(0);
            while (i >= 0) {
                this.vwr.setCurrentModelIndex(i);
                if (!this.writeFrame(++n, rootExt, params, sb)) {
                    return "ERROR WRITING FILE SET: \n" + info;
                }
                i = bsFrames.nextSetBit(i + 1);
            }
        }
        if (info.length() == 0) {
            info = "OK\n";
        }
        return info + "\n" + n + " files created";
    }

    private static Object getRootExt(String fileName, String[] rootExt, int n) {
        String froot;
        if (fileName == null) {
            fileName = "0000" + n;
            return rootExt[0] + fileName.substring(fileName.length() - 4) + rootExt[1];
        }
        int ptDot = fileName.lastIndexOf(".");
        if (ptDot < 0) {
            ptDot = fileName.length();
        }
        if ((froot = fileName.substring(0, ptDot)).endsWith("0")) {
            froot = PT.trim(froot, "0");
        }
        rootExt[0] = froot;
        rootExt[1] = fileName.substring(ptDot);
        return rootExt;
    }

    private String setFullPath(Map<String, Object> params, String fileName) {
        String[] fullPath = (String[])params.get("fullPath");
        if (fullPath != null) {
            fullPath[0] = fileName;
        }
        if (fileName == null) {
            return null;
        }
        params.put("fileName", fileName);
        return fileName;
    }

    String getOutputFromExport(Map<String, Object> params) {
        int width = OutputManager.getInt(params, "width", 0);
        int height = OutputManager.getInt(params, "height", 0);
        String fileName = (String)params.get("fileName");
        if (fileName != null && (fileName = this.setFullPath(params, this.getOutputFileNameFromDialog(fileName, Integer.MIN_VALUE, null))) == null) {
            return null;
        }
        this.vwr.mustRender = true;
        int saveWidth = this.vwr.screenWidth;
        int saveHeight = this.vwr.screenHeight;
        this.vwr.resizeImage(width, height, true, true, false);
        this.vwr.setModelVisibility();
        String data = this.vwr.rm.renderExport(this.vwr.gdata, this.vwr.ms, params);
        this.vwr.resizeImage(saveWidth, saveHeight, true, true, true);
        return data;
    }

    byte[] getImageAsBytes(String type, int width, int height, int quality, String[] errMsg) {
        int saveWidth = this.vwr.screenWidth;
        int saveHeight = this.vwr.screenHeight;
        this.vwr.mustRender = true;
        this.vwr.resizeImage(width, height, true, false, false);
        this.vwr.setModelVisibility();
        this.vwr.creatingImage = true;
        byte[] bytes = null;
        try {
            Object bytesOrError;
            Hashtable<String, Object> params = new Hashtable<String, Object>();
            params.put("type", type);
            if (quality > 0) {
                params.put("quality", quality);
            }
            if ((bytesOrError = this.getOrSaveImage(params)) instanceof String) {
                errMsg[0] = (String)bytesOrError;
            } else {
                bytes = (byte[])bytesOrError;
            }
        }
        catch (Exception e) {
            errMsg[0] = e.toString();
            this.vwr.setErrorMessage("Error creating image: " + e, null);
        }
        catch (Error er) {
            this.vwr.handleError(er, false);
            this.vwr.setErrorMessage("Error creating image: " + er, null);
            errMsg[0] = this.vwr.getErrorMessage();
        }
        this.vwr.creatingImage = false;
        this.vwr.resizeImage(saveWidth, saveHeight, true, false, true);
        return bytes;
    }

    String writeFileData(String fileName, String type, int modelIndex, Object[] plotParameters) {
        boolean asBytes;
        String[] fullPath = new String[1];
        OC out = this.getOutputChannel(fileName, fullPath);
        if (out == null) {
            return "";
        }
        fileName = fullPath[0];
        String pathName = type.equals("FILE") ? this.vwr.fm.getFullPathName(false) : null;
        boolean getCurrentFile = pathName != null && (pathName.equals("string") || pathName.equals("String[]") || pathName.equals("JSNode"));
        boolean bl = asBytes = pathName != null && !getCurrentFile;
        if (asBytes && (pathName = this.vwr.getModelSetPathName()) == null) {
            return null;
        }
        out.setType(type);
        String msg = type.startsWith("PDB") ? this.vwr.getPdbAtomData(null, out, false, false) : (type.startsWith("PLOT") ? this.vwr.getPdbData(modelIndex, type.substring(5), null, plotParameters, out, true) : (getCurrentFile ? out.append(this.vwr.getCurrentFileAsString("write")).toString() : (String)this.vwr.fm.getFileAsBytes(pathName, out)));
        out.closeChannel();
        if (msg != null) {
            msg = "OK " + msg + " " + fileName;
        }
        return msg;
    }

    private boolean writeFrame(int n, String[] rootExt, Map<String, Object> params, SB sb) {
        String fileName = (String)OutputManager.getRootExt(null, rootExt, n);
        if ((fileName = this.setFullPath(params, fileName)) == null) {
            return false;
        }
        String msg = this.handleOutputToFile(params, false);
        this.vwr.scriptEcho(msg);
        sb.append(msg).append("\n");
        return msg.startsWith("OK");
    }

    private String getOutputFileNameFromDialog(String fileName, int quality, Map<String, Object> params) {
        if (fileName == null || this.vwr.isKiosk) {
            return null;
        }
        boolean useDialog = fileName.startsWith("?");
        if (useDialog) {
            fileName = fileName.substring(1);
        }
        boolean bl = this.vwr.isApplet && fileName.indexOf("http://") != 0 && fileName.indexOf("https://") != 0;
        fileName = FileManager.getLocalPathForWritingFile(this.vwr, fileName);
        if (useDialog |= bl) {
            fileName = this.vwr.dialogAsk(quality == Integer.MIN_VALUE ? "Save" : "Save Image", fileName, params);
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String handleOutputToFile(Map<String, Object> params, boolean doCheck) {
        boolean mustRender;
        String fileName = (String)params.get("fileName");
        OC out = (OC)params.get("outputChannel");
        if (fileName == null && out == null) {
            return null;
        }
        String sret = null;
        String type = (String)params.get("type");
        String text = (String)params.get("text");
        int width = OutputManager.getInt(params, "width", 0);
        int height = OutputManager.getInt(params, "height", 0);
        int saveWidth = 0;
        int saveHeight = 0;
        int quality = OutputManager.getInt(params, "quality", Integer.MIN_VALUE);
        String captureMode = (String)params.get("captureMode");
        boolean is2D = params.get("is2D") == Boolean.TRUE;
        String localName = null;
        if (captureMode != null && !this.vwr.allowCapture()) {
            return "ERROR: Cannot capture on this platform.";
        }
        boolean bl = mustRender = !is2D && quality != Integer.MIN_VALUE;
        if (captureMode != null) {
            doCheck = false;
            mustRender = false;
        }
        if (out == null) {
            if (!fileName.startsWith("\u0001")) {
                if (doCheck) {
                    fileName = this.getOutputFileNameFromDialog(fileName, quality, params);
                }
                fileName = this.setFullPath(params, fileName);
            }
            if (fileName == null) {
                return null;
            }
            params.put("fileName", fileName);
            if (OC.isLocal(fileName)) {
                localName = fileName;
            }
            saveWidth = this.vwr.screenWidth;
            saveHeight = this.vwr.screenHeight;
            this.vwr.creatingImage = true;
            if (mustRender) {
                this.vwr.mustRender = true;
                this.vwr.resizeImage(width, height, true, false, false);
                this.vwr.setModelVisibility();
            }
        }
        try {
            if (type.equals("JMOL")) {
                type = "ZIPALL";
            }
            if (type.equals("ZIP") || type.equals("ZIPALL")) {
                String[] scripts = (String[])params.get("scripts");
                if (scripts != null && type.equals("ZIP")) {
                    type = "ZIPALL";
                }
                sret = this.createZipSet(text, scripts, type.equals("ZIPALL"), out == null ? this.getOutputChannel(fileName, null) : out, null);
            } else if (type.equals("SCENE")) {
                sret = this.createSceneSet(fileName, text, width, height);
            } else {
                byte[] bytes = (byte[])params.get("bytes");
                sret = this.vwr.sm.createImage(fileName, type, text, bytes, quality);
                if (sret == null) {
                    boolean createImage = true;
                    String captureMsg = null;
                    if (captureMode != null) {
                        String[] rootExt;
                        out = null;
                        Map<String, Object> cparams = this.vwr.captureParams;
                        int imode = "ad on of en ca mo ".indexOf(captureMode.substring(0, 2));
                        if (imode == 15) {
                            boolean streaming;
                            if (cparams != null && cparams.containsKey("outputChannel")) {
                                ((OC)cparams.get("outputChannel")).closeChannel();
                            }
                            if ((streaming = params.containsKey("streaming")) && (out = this.getOutputChannel(localName, null)) == null) {
                                captureMsg = "ERROR: capture canceled";
                                sret = "ERROR: capture canceled";
                                this.vwr.captureParams = null;
                            } else {
                                this.vwr.captureParams = params;
                                if (params.containsKey("captureRootExt")) {
                                    imode = 0;
                                } else {
                                    if (out != null) {
                                        localName = out.getFileName();
                                    }
                                    params.put("captureFileName", localName);
                                    if (streaming) {
                                        captureMsg = type + "_STREAM_OPEN " + localName;
                                        params.put("captureMode", "movie");
                                    } else {
                                        rootExt = new String[2];
                                        params.put("captureRootExt", OutputManager.getRootExt(localName, rootExt, 0));
                                        localName = (String)OutputManager.getRootExt(null, rootExt, 1);
                                        imode = -1;
                                        cparams = params;
                                        createImage = false;
                                    }
                                }
                                if (!params.containsKey("captureCount")) {
                                    params.put("captureCount", 0);
                                }
                            }
                        }
                        if (imode >= 0 && imode != 15) {
                            if (cparams == null) {
                                captureMsg = "ERROR: capture not active";
                                sret = "ERROR: capture not active";
                            } else {
                                params = cparams;
                                switch (imode) {
                                    default: {
                                        sret = captureMsg = "ERROR: CAPTURE MODE=" + captureMode + "?";
                                        break;
                                    }
                                    case 0: {
                                        if (Boolean.FALSE == params.get("captureEnabled")) {
                                            captureMsg = "capturing OFF; use CAPTURE ON/END/CANCEL to continue";
                                            sret = "capturing OFF; use CAPTURE ON/END/CANCEL to continue";
                                            break;
                                        }
                                        int count = OutputManager.getInt(params, "captureCount", 0);
                                        params.put("captureCount", ++count);
                                        rootExt = (String[])params.get("captureRootExt");
                                        if (rootExt != null) {
                                            localName = (String)OutputManager.getRootExt(null, rootExt, count);
                                            captureMsg = null;
                                            createImage = true;
                                            break;
                                        }
                                        captureMsg = type + "_STREAM_ADD " + count;
                                        break;
                                    }
                                    case 3: 
                                    case 6: {
                                        params = cparams;
                                        params.put("captureEnabled", captureMode.equals("on") ? Boolean.TRUE : Boolean.FALSE);
                                        sret = type + "_STREAM_" + (captureMode.equals("on") ? "ON" : "OFF");
                                        params.put("captureMode", "add");
                                        break;
                                    }
                                    case 9: 
                                    case 12: {
                                        params = cparams;
                                        params.put("captureMode", captureMode);
                                        fileName = (String)params.get("captureFileName");
                                        captureMsg = type + "_STREAM_" + (captureMode.equals("end") ? "CLOSE " : "CANCEL ") + fileName;
                                        this.vwr.captureParams = null;
                                        params.put("captureMsg", GT.$("Capture") + ": " + (captureMode.equals("cancel") ? GT.$("canceled") : GT.o(GT.$("{0} saved"), fileName)));
                                        if (!params.containsKey("captureRootExt")) break;
                                        createImage = false;
                                    }
                                }
                            }
                        }
                        if (createImage && out != null) {
                            params.put("outputChannel", out);
                        }
                    }
                    if (createImage) {
                        if (localName != null) {
                            params.put("fileName", localName);
                        }
                        if (sret == null) {
                            sret = this.writeToOutputChannel(params);
                        }
                        if (!is2D) {
                            this.vwr.sm.createImage(sret, type, null, null, quality);
                            if (captureMode != null) {
                                captureMsg = captureMsg == null ? sret : captureMsg + " (" + params.get(params.containsKey("captureByteCount") ? "captureByteCount" : "byteCount") + " bytes)";
                            }
                        }
                    }
                    if (captureMsg != null) {
                        this.vwr.showString(captureMsg, false);
                    }
                }
            }
        }
        catch (Throwable er) {
            er.printStackTrace();
            sret = "ERROR creating image??: " + er;
            Logger.error(this.vwr.setErrorMessage(sret, null));
        }
        finally {
            this.vwr.creatingImage = false;
            if (quality != Integer.MIN_VALUE && saveWidth > 0) {
                this.vwr.resizeImage(saveWidth, saveHeight, true, false, true);
            }
        }
        return sret;
    }

    String setLogFile(String value) {
        String path = null;
        if (this.vwr.logFilePath == null || value.indexOf("\\") >= 0) {
            value = null;
        } else if (value.startsWith("http://") || value.startsWith("https://")) {
            path = value;
        } else if (value.indexOf("/") >= 0) {
            value = null;
        } else if (value.length() > 0) {
            if (!value.startsWith("JmolLog_")) {
                value = "JmolLog_" + value;
            }
            path = this.getLogPath(this.vwr.logFilePath + value);
        }
        if (path == null) {
            value = null;
        } else {
            Logger.info(GT.o(GT.$("Setting log file to {0}"), path));
        }
        if (value == null || !this.vwr.haveAccess(Viewer.ACCESS.ALL)) {
            Logger.info(GT.$("Cannot set log file path."));
            value = null;
        } else {
            this.vwr.logFileName = path;
            this.vwr.g.setO("_logFile", this.vwr.isApplet ? value : path);
        }
        return value;
    }

    void logToFile(String data) {
        block7: {
            try {
                OC out;
                boolean doClear = data.equals("$CLEAR$");
                if (data.indexOf("$NOW$") >= 0) {
                    data = PT.rep(data, "$NOW$", this.vwr.apiPlatform.getDateFormat(null));
                }
                if (this.vwr.logFileName == null) {
                    Logger.info(data);
                    return;
                }
                OC oC = this.vwr.haveAccess(Viewer.ACCESS.ALL) ? this.openOutputChannel(this.privateKey, this.vwr.logFileName, true, !doClear) : (out = null);
                if (!doClear) {
                    int ptEnd = data.indexOf(0);
                    if (ptEnd >= 0) {
                        data = data.substring(0, ptEnd);
                    }
                    out.append(data);
                    if (ptEnd < 0) {
                        out.append("\n");
                    }
                }
                String s = out.closeChannel();
                Logger.info(s);
            }
            catch (Exception e) {
                if (!Logger.debugging) break block7;
                Logger.debug("cannot log " + data);
            }
        }
    }

    private String createZipSet(String script, String[] scripts, boolean includeRemoteFiles, OC out, String pngjName) {
        byte[] bytes;
        boolean haveScripts;
        boolean sceneScriptOnly;
        Lst<Object> v = new Lst<Object>();
        FileManager fm = this.vwr.fm;
        Lst<String> fileNames = new Lst<String>();
        Hashtable<Object, String> crcMap = new Hashtable<Object, String>();
        boolean haveSceneScript = scripts != null && scripts.length == 3 && scripts[1].startsWith(SCENE_TAG);
        boolean bl = sceneScriptOnly = haveSceneScript && scripts[2].equals("min");
        if (!sceneScriptOnly) {
            FileManager.getFileReferences(script, fileNames);
            if (haveSceneScript) {
                FileManager.getFileReferences(scripts[1], fileNames);
            }
        }
        boolean bl2 = haveScripts = !haveSceneScript && scripts != null && scripts.length > 0;
        if (haveScripts) {
            script = this.wrapPathForAllFiles("script " + PT.esc(scripts[0]), "");
            for (int i = 0; i < scripts.length; ++i) {
                fileNames.addLast(scripts[i]);
            }
        }
        int nFiles = fileNames.size();
        Lst<String> newFileNames = new Lst<String>();
        for (int iFile = 0; iFile < nFiles; ++iFile) {
            String name = (String)fileNames.get(iFile);
            boolean isLocal = !Viewer.isJS && OC.isLocal(name);
            String newName = name;
            if (isLocal || includeRemoteFiles) {
                boolean isSparDir;
                int ptSlash = name.lastIndexOf("/");
                newName = name.indexOf("?") > 0 && name.indexOf("|") < 0 ? PT.replaceAllCharacters(name, "/:?\"'=&", "_") : FileManager.stripPath(name);
                newName = PT.replaceAllCharacters(newName, "[]", "_");
                newName = PT.rep(newName, "#_DOCACHE_", "");
                boolean bl3 = isSparDir = fm.spardirCache != null && fm.spardirCache.containsKey(name);
                if (isLocal && name.indexOf("|") < 0 && !isSparDir) {
                    v.addLast(name);
                    v.addLast(newName);
                    v.addLast((Object)null);
                } else {
                    Object ret;
                    Object object = ret = isSparDir ? fm.spardirCache.get(name) : (Object)fm.getFileAsBytes(name, null);
                    if (!AU.isAB(ret)) {
                        return "ERROR: " + (String)ret;
                    }
                    newName = this.addPngFileBytes(name, (byte[])ret, iFile, crcMap, isSparDir, newName, ptSlash, v);
                }
                name = "$SCRIPT_PATH$" + newName;
            }
            crcMap.put(newName, newName);
            newFileNames.addLast(name);
        }
        if (!sceneScriptOnly) {
            script = PT.replaceQuotedStrings(script, fileNames, newFileNames);
            v.addLast("state.spt");
            v.addLast((Object)null);
            v.addLast(script.getBytes());
        }
        if (haveSceneScript) {
            if (scripts[0] != null) {
                v.addLast("animate.spt");
                v.addLast((Object)null);
                v.addLast(scripts[0].getBytes());
            }
            v.addLast("scene.spt");
            v.addLast((Object)null);
            script = PT.replaceQuotedStrings(scripts[1], fileNames, newFileNames);
            v.addLast(script.getBytes());
        }
        String sname = haveSceneScript ? "scene.spt" : "state.spt";
        v.addLast("JmolManifest.txt");
        v.addLast((Object)null);
        String sinfo = "# Jmol Manifest Zip Format 1.1\n# Created " + new Date() + "\n# JmolVersion " + Viewer.getJmolVersion() + "\n" + sname;
        v.addLast(sinfo.getBytes());
        v.addLast("Jmol_version_" + Viewer.getJmolVersion().replace(' ', '_').replace(':', '.'));
        v.addLast((Object)null);
        v.addLast(new byte[0]);
        if (out.getFileName() != null && (bytes = this.vwr.getImageAsBytes("PNG", 0, 0, -1, null)) != null) {
            v.addLast("preview.png");
            v.addLast((Object)null);
            v.addLast(bytes);
        }
        return this.writeZipFile(out, v, "OK JMOL", pngjName);
    }

    private String addPngFileBytes(String name, byte[] ret, int iFile, Hashtable<Object, String> crcMap, boolean isSparDir, String newName, int ptSlash, Lst<Object> v) {
        Integer crcValue = this.vwr.getJzt().getCrcValue(ret);
        if (crcMap.containsKey(crcValue)) {
            newName = crcMap.get(crcValue);
        } else {
            if (isSparDir) {
                newName = newName.replace('.', '_');
            }
            if (crcMap.containsKey(newName)) {
                int pt = newName.lastIndexOf(".");
                newName = pt > ptSlash ? newName.substring(0, pt) + "[" + iFile + "]" + newName.substring(pt) : newName + "[" + iFile + "]";
            }
            v.addLast(name);
            v.addLast(newName);
            v.addLast(ret);
            crcMap.put(crcValue, newName);
        }
        return newName;
    }

    private String writeZipFile(OC out, Lst<Object> fileNamesAndByteArrays, String msg, String pngjName) {
        byte[] buf = new byte[1024];
        long nBytesOut = 0L;
        long nBytes = 0L;
        String outFileName = out.getFileName();
        if (pngjName != null && pngjName.startsWith("//")) {
            pngjName = "file:" + pngjName.substring(1);
        }
        Logger.info("creating zip file " + (outFileName == null ? "" : outFileName) + "...");
        String fileList = "";
        try {
            BufferedOutputStream bos = new BufferedOutputStream(out);
            FileManager fm = this.vwr.fm;
            OutputStream zos = (OutputStream)this.vwr.getJzt().getZipOutputStream(bos);
            for (int i = 0; i < fileNamesAndByteArrays.size(); i += 3) {
                String key;
                String fnameShort;
                String fname = (String)fileNamesAndByteArrays.get(i);
                byte[] bytes = null;
                Object data = fm.cacheGet(fname, false);
                if (data instanceof Map) continue;
                if (fname.indexOf("file:/") == 0) {
                    if ((fname = fname.substring(5)).length() > 2 && fname.charAt(2) == ':') {
                        fname = fname.substring(1);
                    }
                } else if (fname.indexOf("cache://") == 0) {
                    fname = fname.substring(8);
                }
                if ((fnameShort = (String)fileNamesAndByteArrays.get(i + 1)) == null) {
                    fnameShort = fname;
                }
                if (data != null) {
                    byte[] byArray = bytes = AU.isAB(data) ? (byte[])data : ((String)data).getBytes();
                }
                if (bytes == null) {
                    bytes = (byte[])fileNamesAndByteArrays.get(i + 2);
                }
                if (fileList.indexOf(key = ";" + fnameShort + ";") >= 0) {
                    Logger.info("duplicate entry");
                    continue;
                }
                fileList = fileList + key;
                this.vwr.getJzt().addZipEntry(zos, fnameShort);
                int nOut = 0;
                if (bytes == null) {
                    int len;
                    BufferedInputStream in = this.vwr.getBufferedInputStream(fname);
                    while ((len = in.read(buf, 0, 1024)) > 0) {
                        zos.write(buf, 0, len);
                        nOut += len;
                    }
                    in.close();
                } else {
                    zos.write(bytes, 0, bytes.length);
                    if (pngjName != null) {
                        this.vwr.fm.recachePngjBytes(pngjName + "|" + fnameShort, bytes);
                    }
                    nOut += bytes.length;
                }
                nBytesOut += (long)nOut;
                this.vwr.getJzt().closeZipEntry(zos);
                Logger.info("...added " + fname + " (" + nOut + " bytes)");
            }
            zos.flush();
            zos.close();
            Logger.info(nBytesOut + " bytes prior to compression");
            String ret = out.closeChannel();
            if (ret != null) {
                if (ret.indexOf("Exception") >= 0) {
                    return ret;
                }
                msg = msg + " " + ret;
            }
            nBytes = out.getByteCount();
        }
        catch (IOException e) {
            Logger.info(e.toString());
            return e.toString();
        }
        String fileName = out.getFileName();
        return fileName == null ? null : msg + " " + nBytes + " " + fileName;
    }

    protected String wrapPathForAllFiles(String cmd, String strCatch) {
        String vname = "v__" + ("" + Math.random()).substring(3);
        return "# Jmol script\n{\n\tVar " + vname + " = pathForAllFiles\n\tpathForAllFiles=\"$SCRIPT_PATH$\"\n\ttry{\n\t\t" + cmd + "\n\t}catch(e){" + strCatch + "}\n\tpathForAllFiles = " + vname + "\n}\n";
    }
}

