/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.publication;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.component.ComponentWithVariants;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.CompositeDomainObjectSet;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.dsl.dependencies.PlatformSupport;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.component.IvyPublishingAwareContext;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.java.JavaLibraryPlatform;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.publish.VersionMappingStrategy;
import org.gradle.api.publish.internal.CompositePublicationArtifactSet;
import org.gradle.api.publish.internal.DefaultPublicationArtifactSet;
import org.gradle.api.publish.internal.PublicationArtifactSet;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.publish.internal.validation.PublicationWarningsCollector;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.IvyConfigurationContainer;
import org.gradle.api.publish.ivy.IvyModuleDescriptorSpec;
import org.gradle.api.publish.ivy.internal.artifact.DefaultIvyArtifactSet;
import org.gradle.api.publish.ivy.internal.artifact.DerivedIvyArtifact;
import org.gradle.api.publish.ivy.internal.artifact.SingleOutputTaskIvyArtifact;
import org.gradle.api.publish.ivy.internal.dependency.DefaultIvyDependency;
import org.gradle.api.publish.ivy.internal.dependency.DefaultIvyDependencySet;
import org.gradle.api.publish.ivy.internal.dependency.DefaultIvyExcludeRule;
import org.gradle.api.publish.ivy.internal.dependency.IvyDependencyInternal;
import org.gradle.api.publish.ivy.internal.dependency.IvyExcludeRule;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyConfigurationContainer;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyModuleDescriptorSpec;
import org.gradle.api.publish.ivy.internal.publication.IvyModuleDescriptorSpecInternal;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.api.publish.ivy.internal.publisher.IvyNormalizedPublication;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GUtil;

public class DefaultIvyPublication
implements IvyPublicationInternal {
    private static final Logger LOG = Logging.getLogger(DefaultIvyPublication.class);
    private static final String API_VARIANT = "api";
    private static final String API_ELEMENTS_VARIANT = "apiElements";
    private static final String RUNTIME_VARIANT = "runtime";
    private static final String RUNTIME_ELEMENTS_VARIANT = "runtimeElements";
    private static final Comparator<String> VARIANT_ORDERING = (left, right) -> {
        if (API_VARIANT.equals(left) || API_ELEMENTS_VARIANT.equals(left)) {
            return -1;
        }
        if (API_VARIANT.equals(right) || API_ELEMENTS_VARIANT.equals(right)) {
            return 1;
        }
        return left.compareTo((String)right);
    };
    @VisibleForTesting
    public static final String UNSUPPORTED_FEATURE = " contains dependencies that cannot be represented in a published ivy descriptor.";
    private final String name;
    private final IvyModuleDescriptorSpecInternal descriptor;
    private final IvyPublicationIdentity publicationIdentity;
    private final IvyConfigurationContainer configurations;
    private final DefaultIvyArtifactSet mainArtifacts;
    private final PublicationArtifactSet<IvyArtifact> metadataArtifacts;
    private final PublicationArtifactSet<IvyArtifact> derivedArtifacts;
    private final PublicationArtifactSet<IvyArtifact> publishableArtifacts;
    private final DefaultIvyDependencySet ivyDependencies;
    private final ProjectDependencyPublicationResolver projectDependencyResolver;
    private final PlatformSupport platformSupport;
    private final ImmutableAttributesFactory immutableAttributesFactory;
    private final VersionMappingStrategyInternal versionMappingStrategy;
    private final FeaturePreviews featurePreviews;
    private IvyArtifact ivyDescriptorArtifact;
    private TaskProvider<? extends Task> moduleDescriptorGenerator;
    private SingleOutputTaskIvyArtifact gradleModuleDescriptorArtifact;
    private SoftwareComponentInternal component;
    private boolean alias;
    private Set<IvyExcludeRule> globalExcludes = new LinkedHashSet<IvyExcludeRule>();
    private boolean populated;
    private boolean artifactsOverridden;
    private boolean versionMappingInUse = false;

    @Inject
    public DefaultIvyPublication(String name, Instantiator instantiator, ObjectFactory objectFactory, IvyPublicationIdentity publicationIdentity, NotationParser<Object, IvyArtifact> ivyArtifactNotationParser, ProjectDependencyPublicationResolver projectDependencyResolver, FileCollectionFactory fileCollectionFactory, ImmutableAttributesFactory immutableAttributesFactory, FeaturePreviews featurePreviews, CollectionCallbackActionDecorator collectionCallbackActionDecorator, VersionMappingStrategyInternal versionMappingStrategy, PlatformSupport platformSupport) {
        this.name = name;
        this.publicationIdentity = publicationIdentity;
        this.projectDependencyResolver = projectDependencyResolver;
        this.platformSupport = platformSupport;
        this.configurations = (IvyConfigurationContainer)instantiator.newInstance(DefaultIvyConfigurationContainer.class, new Object[]{instantiator, collectionCallbackActionDecorator});
        this.immutableAttributesFactory = immutableAttributesFactory;
        this.versionMappingStrategy = versionMappingStrategy;
        this.featurePreviews = featurePreviews;
        this.mainArtifacts = (DefaultIvyArtifactSet)instantiator.newInstance(DefaultIvyArtifactSet.class, new Object[]{name, ivyArtifactNotationParser, fileCollectionFactory, collectionCallbackActionDecorator});
        this.metadataArtifacts = new DefaultPublicationArtifactSet(IvyArtifact.class, "metadata artifacts for " + name, fileCollectionFactory, collectionCallbackActionDecorator);
        this.derivedArtifacts = new DefaultPublicationArtifactSet(IvyArtifact.class, "derived artifacts for " + name, fileCollectionFactory, collectionCallbackActionDecorator);
        this.publishableArtifacts = new CompositePublicationArtifactSet(IvyArtifact.class, new PublicationArtifactSet[]{this.mainArtifacts, this.metadataArtifacts, this.derivedArtifacts});
        this.ivyDependencies = (DefaultIvyDependencySet)((Object)instantiator.newInstance(DefaultIvyDependencySet.class, new Object[]{collectionCallbackActionDecorator}));
        this.descriptor = (IvyModuleDescriptorSpecInternal)instantiator.newInstance(DefaultIvyModuleDescriptorSpec.class, new Object[]{this, instantiator, objectFactory});
    }

    public String getName() {
        return this.name;
    }

    public DisplayName getDisplayName() {
        return Describables.withTypeAndName((String)"Ivy publication", (String)this.name);
    }

    public boolean isLegacy() {
        return false;
    }

    @Nullable
    public SoftwareComponentInternal getComponent() {
        return this.component;
    }

    @Override
    public IvyModuleDescriptorSpecInternal getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void setIvyDescriptorGenerator(TaskProvider<? extends Task> descriptorGenerator) {
        if (this.ivyDescriptorArtifact != null) {
            this.metadataArtifacts.remove((Object)this.ivyDescriptorArtifact);
        }
        this.ivyDescriptorArtifact = new SingleOutputTaskIvyArtifact(descriptorGenerator, this.publicationIdentity, "xml", "ivy", null);
        this.ivyDescriptorArtifact.setName("ivy");
        this.metadataArtifacts.add((Object)this.ivyDescriptorArtifact);
    }

    @Override
    public void setModuleDescriptorGenerator(TaskProvider<? extends Task> descriptorGenerator) {
        this.moduleDescriptorGenerator = descriptorGenerator;
        if (this.gradleModuleDescriptorArtifact != null) {
            this.metadataArtifacts.remove((Object)this.gradleModuleDescriptorArtifact);
        }
        this.gradleModuleDescriptorArtifact = null;
        this.updateModuleDescriptorArtifact();
    }

    private void updateModuleDescriptorArtifact() {
        if (!this.canPublishModuleMetadata()) {
            return;
        }
        if (this.moduleDescriptorGenerator == null) {
            return;
        }
        this.gradleModuleDescriptorArtifact = new SingleOutputTaskIvyArtifact(this.moduleDescriptorGenerator, this.publicationIdentity, "module", "json", null);
        this.metadataArtifacts.add((Object)this.gradleModuleDescriptorArtifact);
        this.moduleDescriptorGenerator = null;
    }

    @Override
    public void descriptor(Action<? super IvyModuleDescriptorSpec> configure) {
        configure.execute((Object)this.descriptor);
    }

    public boolean isAlias() {
        return this.alias;
    }

    public void setAlias(boolean alias) {
        this.alias = alias;
    }

    @Override
    public void from(SoftwareComponent component) {
        if (this.component != null) {
            throw new InvalidUserDataException(String.format("Ivy publication '%s' cannot include multiple components", this.name));
        }
        this.component = (SoftwareComponentInternal)component;
        if (component instanceof JavaLibraryPlatform) {
            DeprecationLogger.nagUserWithDeprecatedIndirectUserCodeCause((String)"components.javaLibraryPlatform", (String)"Use the 'java-platform' plugin instead.");
        }
        this.artifactsOverridden = false;
        this.updateModuleDescriptorArtifact();
    }

    private void populateFromComponent() {
        if (this.populated) {
            return;
        }
        this.populated = true;
        if (this.component == null) {
            return;
        }
        PublicationWarningsCollector publicationWarningsCollector = new PublicationWarningsCollector(LOG, UNSUPPORTED_FEATURE, "");
        this.configurations.maybeCreate("default");
        HashSet seenArtifacts = Sets.newHashSet();
        HashSet seenDependencies = Sets.newHashSet();
        for (UsageContext usageContext : this.getSortedUsageContexts()) {
            String conf = this.mapUsage(usageContext.getName());
            this.configurations.maybeCreate(conf);
            if (usageContext instanceof IvyPublishingAwareContext) {
                if (!((IvyPublishingAwareContext)usageContext).isOptional()) {
                    ((IvyConfiguration)this.configurations.getByName("default")).extend(conf);
                }
            } else {
                ((IvyConfiguration)this.configurations.getByName("default")).extend(conf);
            }
            for (PublishArtifact publishArtifact : usageContext.getArtifacts()) {
                if (this.artifactsOverridden || !seenArtifacts.add(publishArtifact)) continue;
                this.artifact(publishArtifact).setConf(conf);
            }
            for (ModuleDependency dependency : usageContext.getDependencies()) {
                if (!seenDependencies.add(dependency)) continue;
                String confMapping = String.format("%s->%s", conf, dependency.getTargetConfiguration() == null ? "default" : dependency.getTargetConfiguration());
                if (!dependency.getAttributes().isEmpty()) {
                    publicationWarningsCollector.addUnsupported(String.format("%s:%s:%s declared with Gradle attributes", dependency.getGroup(), dependency.getName(), dependency.getVersion()));
                }
                if (dependency instanceof ProjectDependency) {
                    this.addProjectDependency((ProjectDependency)dependency, confMapping);
                    continue;
                }
                ExternalDependency externalDependency = (ExternalDependency)dependency;
                if (this.platformSupport.isTargettingPlatform((HasConfigurableAttributes)dependency)) {
                    publicationWarningsCollector.addUnsupported(String.format("%s:%s:%s declared as platform", dependency.getGroup(), dependency.getName(), dependency.getVersion()));
                }
                if (!this.versionMappingInUse && externalDependency.getVersion() == null) {
                    publicationWarningsCollector.addUnsupported(String.format("%s:%s declared without version", externalDependency.getGroup(), externalDependency.getName()));
                }
                this.addExternalDependency(externalDependency, confMapping, ((AttributeContainerInternal)usageContext.getAttributes()).asImmutable());
            }
            if (!usageContext.getDependencyConstraints().isEmpty()) {
                for (DependencyConstraint constraint : usageContext.getDependencyConstraints()) {
                    publicationWarningsCollector.addUnsupported(String.format("%s:%s:%s declared as a dependency constraint", constraint.getGroup(), constraint.getName(), constraint.getVersion()));
                }
            }
            if (!usageContext.getCapabilities().isEmpty()) {
                for (Capability capability : usageContext.getCapabilities()) {
                    publicationWarningsCollector.addUnsupported(String.format("Declares capability %s:%s:%s", capability.getGroup(), capability.getName(), capability.getVersion()));
                }
            }
            for (ExcludeRule excludeRule : usageContext.getGlobalExcludes()) {
                this.globalExcludes.add(new DefaultIvyExcludeRule(excludeRule, conf));
            }
        }
        publicationWarningsCollector.complete(this.getDisplayName());
    }

    private List<UsageContext> getSortedUsageContexts() {
        ArrayList usageContexts = Lists.newArrayList((Iterable)this.component.getUsages());
        Collections.sort(usageContexts, (u1, u2) -> VARIANT_ORDERING.compare(u1.getName(), u2.getName()));
        return usageContexts;
    }

    private String mapUsage(String name) {
        if (API_VARIANT.equals(name) || API_ELEMENTS_VARIANT.equals(name)) {
            return "compile";
        }
        if (RUNTIME_VARIANT.equals(name) || RUNTIME_ELEMENTS_VARIANT.equals(name)) {
            return RUNTIME_VARIANT;
        }
        return name;
    }

    private void addProjectDependency(ProjectDependency dependency, String confMapping) {
        ModuleVersionIdentifier identifier = (ModuleVersionIdentifier)this.projectDependencyResolver.resolve(ModuleVersionIdentifier.class, dependency);
        this.ivyDependencies.add(new DefaultIvyDependency(identifier.getGroup(), identifier.getName(), identifier.getVersion(), confMapping, dependency.isTransitive(), Collections.emptyList(), dependency.getExcludeRules()));
    }

    private void addExternalDependency(ExternalDependency dependency, String confMapping, ImmutableAttributes attributes) {
        this.ivyDependencies.add(new DefaultIvyDependency(dependency, confMapping, attributes));
    }

    @Override
    public void configurations(Action<? super IvyConfigurationContainer> config) {
        this.populateFromComponent();
        config.execute((Object)this.configurations);
    }

    @Override
    public IvyConfigurationContainer getConfigurations() {
        this.populateFromComponent();
        return this.configurations;
    }

    @Override
    public IvyArtifact artifact(Object source) {
        return this.mainArtifacts.artifact(source);
    }

    @Override
    public IvyArtifact artifact(Object source, Action<? super IvyArtifact> config) {
        return this.mainArtifacts.artifact(source, config);
    }

    @Override
    public void setArtifacts(Iterable<?> sources) {
        this.artifactsOverridden = true;
        this.mainArtifacts.clear();
        for (Object source : sources) {
            this.artifact(source);
        }
    }

    @Override
    public DefaultIvyArtifactSet getArtifacts() {
        this.populateFromComponent();
        return this.mainArtifacts;
    }

    @Override
    public String getOrganisation() {
        return this.publicationIdentity.getOrganisation();
    }

    @Override
    public void setOrganisation(String organisation) {
        this.publicationIdentity.setOrganisation(organisation);
    }

    @Override
    public String getModule() {
        return this.publicationIdentity.getModule();
    }

    @Override
    public void setModule(String module) {
        this.publicationIdentity.setModule(module);
    }

    @Override
    public String getRevision() {
        return this.publicationIdentity.getRevision();
    }

    @Override
    public void setRevision(String revision) {
        this.publicationIdentity.setRevision(revision);
    }

    @Override
    public FileCollection getPublishableFiles() {
        this.populateFromComponent();
        return this.getPublishableArtifacts().getFiles();
    }

    public PublicationArtifactSet<IvyArtifact> getPublishableArtifacts() {
        this.populateFromComponent();
        return this.publishableArtifacts;
    }

    public void allPublishableArtifacts(Action<? super IvyArtifact> action) {
        this.publishableArtifacts.all(action);
    }

    public void whenPublishableArtifactRemoved(Action<? super IvyArtifact> action) {
        this.publishableArtifacts.whenObjectRemoved(action);
    }

    public IvyArtifact addDerivedArtifact(IvyArtifact originalArtifact, Factory<File> fileProvider) {
        DerivedIvyArtifact artifact = new DerivedIvyArtifact(originalArtifact, fileProvider);
        this.derivedArtifacts.add((Object)artifact);
        return artifact;
    }

    public void removeDerivedArtifact(IvyArtifact artifact) {
        this.derivedArtifacts.remove((Object)artifact);
    }

    @Override
    public IvyPublicationIdentity getIdentity() {
        return this.publicationIdentity;
    }

    @Override
    public Set<IvyDependencyInternal> getDependencies() {
        this.populateFromComponent();
        return this.ivyDependencies;
    }

    @Override
    public IvyNormalizedPublication asNormalisedPublication() {
        this.populateFromComponent();
        DomainObjectSet existingDerivedArtifacts = this.derivedArtifacts.matching((Spec)new Spec<IvyArtifact>(){

            public boolean isSatisfiedBy(IvyArtifact artifact) {
                return artifact.getFile().exists();
            }
        });
        DomainObjectSet artifactsToBePublished = CompositeDomainObjectSet.create(IvyArtifact.class, (DomainObjectCollection[])new DomainObjectCollection[]{this.mainArtifacts, this.metadataArtifacts, existingDerivedArtifacts}).matching((Spec)new Spec<IvyArtifact>(){

            public boolean isSatisfiedBy(IvyArtifact element) {
                if (DefaultIvyPublication.this.gradleModuleDescriptorArtifact == element) {
                    return DefaultIvyPublication.this.gradleModuleDescriptorArtifact.isEnabled();
                }
                return true;
            }
        });
        return new IvyNormalizedPublication(this.name, this.getIdentity(), this.getIvyDescriptorFile(), (Set<IvyArtifact>)artifactsToBePublished);
    }

    @Override
    public boolean writeGradleMetadataMarker() {
        return this.canPublishModuleMetadata() && this.gradleModuleDescriptorArtifact != null && this.gradleModuleDescriptorArtifact.isEnabled();
    }

    private boolean canPublishModuleMetadata() {
        if (this.getComponent() == null) {
            return false;
        }
        if (this.getComponent() instanceof ComponentWithVariants) {
            return true;
        }
        return this.featurePreviews.isFeatureEnabled(FeaturePreviews.Feature.GRADLE_METADATA);
    }

    private File getIvyDescriptorFile() {
        if (this.ivyDescriptorArtifact == null) {
            throw new IllegalStateException("ivyDescriptorArtifact not set for publication");
        }
        return this.ivyDescriptorArtifact.getFile();
    }

    public ModuleVersionIdentifier getCoordinates() {
        return DefaultModuleVersionIdentifier.newId((String)this.getOrganisation(), (String)this.getModule(), (String)this.getRevision());
    }

    @Nullable
    public <T> T getCoordinates(Class<T> type) {
        if (type.isAssignableFrom(ModuleVersionIdentifier.class)) {
            return type.cast(this.getCoordinates());
        }
        return null;
    }

    public ImmutableAttributes getAttributes() {
        return this.immutableAttributesFactory.of(ProjectInternal.STATUS_ATTRIBUTE, (Object)this.getDescriptor().getStatus());
    }

    private String getPublishedUrl(PublishArtifact source) {
        return this.getArtifactFileName(source.getClassifier(), source.getExtension());
    }

    private String getArtifactFileName(String classifier, String extension) {
        StringBuilder artifactPath = new StringBuilder();
        ModuleVersionIdentifier coordinates = this.getCoordinates();
        artifactPath.append(coordinates.getName());
        artifactPath.append('-');
        artifactPath.append(coordinates.getVersion());
        if (GUtil.isTrue((Object)classifier)) {
            artifactPath.append('-');
            artifactPath.append(classifier);
        }
        if (GUtil.isTrue((Object)extension)) {
            artifactPath.append('.');
            artifactPath.append(extension);
        }
        return artifactPath.toString();
    }

    public PublicationInternal.PublishedFile getPublishedFile(PublishArtifact source) {
        final String publishedUrl = this.getPublishedUrl(source);
        return new PublicationInternal.PublishedFile(){

            public String getName() {
                return publishedUrl;
            }

            public String getUri() {
                return publishedUrl;
            }
        };
    }

    @Override
    public void versionMapping(Action<? super VersionMappingStrategy> configureAction) {
        this.versionMappingInUse = true;
        configureAction.execute((Object)this.versionMappingStrategy);
    }

    @Nullable
    public VersionMappingStrategyInternal getVersionMappingStrategy() {
        return this.versionMappingStrategy;
    }

    @Override
    public Set<IvyExcludeRule> getGlobalExcludes() {
        return this.globalExcludes;
    }
}

