/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.StringUtils;
import org.w3c.dom.Element;

public abstract class UnitLocation
extends FreeColGameObject
implements Location {
    private static final Logger logger = Logger.getLogger(UnitLocation.class.getName());
    private final List<Unit> units = new ArrayList<Unit>();

    public UnitLocation(Game game) {
        super(game);
    }

    public UnitLocation(Game game, String id) {
        super(game, id);
    }

    public UnitLocation(Game game, Element e) {
        super(game, null);
    }

    public final boolean isEmpty() {
        return this.getUnitCount() == 0;
    }

    public final boolean isFull() {
        return this.getUnitCount() >= this.getUnitCapacity();
    }

    public final Unit getFirstUnit() {
        if (this.isEmpty()) {
            return null;
        }
        List<Unit> units = this.getUnitList();
        return units.get(0);
    }

    public final Unit getLastUnit() {
        if (this.isEmpty()) {
            return null;
        }
        List<Unit> units = this.getUnitList();
        return units.get(units.size() - 1);
    }

    public int getTotalUnitCount() {
        return this.getUnitList().stream().mapToInt(u -> 1 + u.getUnitCount()).sum();
    }

    public boolean hasCarrierWithSpace(int space) {
        return CollectionUtils.any(this.getUnitList(), u -> u.isCarrier() && !u.isDamaged() && u.getSpaceLeft() >= space);
    }

    public List<Unit> getNavalUnits() {
        return this.getUnitList().stream().filter(Unit::isNaval).collect(Collectors.toList());
    }

    public Unit getCarrierForUnit(Unit unit) {
        for (Unit u : this.getUnitList()) {
            if (!u.couldCarry(unit)) continue;
            return u;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FreeColGameObject> getDisposeList() {
        ArrayList<FreeColGameObject> objects = new ArrayList<FreeColGameObject>();
        List<Unit> list = this.units;
        synchronized (list) {
            for (Unit u : this.units) {
                objects.addAll(u.getDisposeList());
            }
        }
        objects.addAll(super.getDisposeList());
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeResources() {
        List<Unit> list = this.units;
        synchronized (list) {
            this.units.clear();
        }
        super.disposeResources();
    }

    @Override
    public Tile getTile() {
        return null;
    }

    @Override
    public StringTemplate getLocationLabel() {
        return StringTemplate.key(this.getId());
    }

    @Override
    public StringTemplate getLocationLabelFor(Player player) {
        return this.getLocationLabel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Locatable locatable) {
        if (locatable instanceof Unit) {
            Unit unit = (Unit)locatable;
            if (this.contains(unit)) {
                return true;
            }
            if (this.canAdd(unit)) {
                List<Unit> list = this.units;
                synchronized (list) {
                    if (!this.units.add(unit)) {
                        return false;
                    }
                    unit.setLocationNoUpdate(this);
                    return true;
                }
            }
        } else {
            if (locatable instanceof Goods) {
                locatable.setLocation(null);
                logger.finest("Dumped " + locatable + " in UnitLocation with id " + this.getId());
                return true;
            }
            logger.warning("Tried to add Locatable " + locatable + " to UnitLocation with id " + this.getId() + ".");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Locatable locatable) {
        if (locatable instanceof Unit) {
            Unit unit = (Unit)locatable;
            List<Unit> list = this.units;
            synchronized (list) {
                if (!this.units.remove(unit)) {
                    return false;
                }
                unit.setLocationNoUpdate(null);
                return true;
            }
        }
        logger.warning("Tried to remove non-Unit " + locatable + " from UnitLocation: " + this.getId());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Locatable locatable) {
        if (!(locatable instanceof Unit)) {
            return false;
        }
        List<Unit> list = this.units;
        synchronized (list) {
            return this.units.contains(locatable);
        }
    }

    @Override
    public boolean canAdd(Locatable locatable) {
        return this.getNoAddReason(locatable) == NoAddReason.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUnitCount() {
        List<Unit> list = this.units;
        synchronized (list) {
            return this.units.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Unit> getUnitList() {
        List<Unit> list = this.units;
        synchronized (list) {
            return new ArrayList<Unit>(this.units);
        }
    }

    @Override
    public final Iterator<Unit> getUnitIterator() {
        return this.getUnitList().iterator();
    }

    @Override
    public GoodsContainer getGoodsContainer() {
        return null;
    }

    @Override
    public Settlement getSettlement() {
        return null;
    }

    @Override
    public final Colony getColony() {
        Settlement settlement = this.getSettlement();
        return settlement instanceof Colony ? (Colony)settlement : null;
    }

    @Override
    public final IndianSettlement getIndianSettlement() {
        Settlement settlement = this.getSettlement();
        return settlement instanceof IndianSettlement ? (IndianSettlement)settlement : null;
    }

    public int getSpaceTaken() {
        return this.getUnitList().stream().mapToInt(u -> u.getSpaceTaken()).sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToFront(Unit u) {
        List<Unit> list = this.units;
        synchronized (list) {
            if (this.units.remove(u)) {
                this.units.add(0, u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearUnitList() {
        List<Unit> list = this.units;
        synchronized (list) {
            this.units.clear();
        }
    }

    public NoAddReason getNoAddReason(Locatable locatable) {
        Unit unit;
        Unit unit2 = unit = locatable instanceof Unit ? (Unit)locatable : null;
        return unit == null ? NoAddReason.WRONG_TYPE : (!this.isEmpty() && this.getFirstUnit().getOwner() != unit.getOwner() ? NoAddReason.OCCUPIED_BY_ENEMY : (this.contains(unit) ? NoAddReason.ALREADY_PRESENT : (unit.getSpaceTaken() + this.getSpaceTaken() > this.getUnitCapacity() ? NoAddReason.CAPACITY_EXCEEDED : NoAddReason.NONE)));
    }

    public int getUnitCapacity() {
        return Integer.MAX_VALUE;
    }

    public int priceGoods(List<AbstractGoods> goods) {
        return -1;
    }

    public boolean equipForRole(Unit unit, Role role, int roleCount) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        List<Unit> list = this.units;
        synchronized (list) {
            for (Unit unit : this.units) {
                if (unit.getLocation() != this) {
                    logger.warning("UnitLocation contains unit " + unit + " with bogus location " + unit.getLocation() + ", fixing.");
                    unit.setLocationNoUpdate(this);
                }
                unit.toXML(xw);
            }
        }
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.clearUnitList();
        super.readChildren(xr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (Unit.getXMLElementTagName().equals(tag)) {
            Unit u = xr.readFreeColGameObject(this.getGame(), Unit.class);
            if (u.getLocation() != this) {
                logger.warning("Fixing bogus unit location for " + u.getId() + ", expected " + this.getId() + " but found " + u.getLocation());
                u.setLocationNoUpdate(this);
            }
            if (u != null) {
                List<Unit> list = this.units;
                synchronized (list) {
                    this.units.add(u);
                }
            }
        } else {
            super.readChild(xr);
        }
    }

    public static enum NoAddReason {
        NONE,
        ALREADY_PRESENT,
        WRONG_TYPE,
        CAPACITY_EXCEEDED,
        OCCUPIED_BY_ENEMY,
        OWNED_BY_ENEMY,
        ANOTHER_COLONY,
        COLONY_CENTER,
        MISSING_ABILITY,
        MISSING_SKILL,
        MINIMUM_SKILL,
        MAXIMUM_SKILL,
        CLAIM_REQUIRED;


        private String getKey() {
            return "noAddReason." + StringUtils.getEnumKey(this);
        }

        public String getDescriptionKey() {
            return Messages.descriptionKey("model." + this.getKey());
        }
    }
}

