/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.util.Utils;

public class TileTypeChange
implements Comparable<TileTypeChange> {
    private TileType from;
    private TileType to;
    private AbstractGoods production;
    private static final String FROM_TAG = "from";
    private static final String GOODS_TYPE_TAG = "goods-type";
    private static final String PRODUCTION_TAG = "production";
    private static final String TO_TAG = "to";
    private static final String VALUE_TAG = "value";

    public final TileType getFrom() {
        return this.from;
    }

    public final void setFrom(TileType from) {
        this.from = from;
    }

    public final TileType getTo() {
        return this.to;
    }

    public final void setTo(TileType to) {
        this.to = to;
    }

    public final AbstractGoods getProduction() {
        return this.production;
    }

    public final void setProduction(AbstractGoods production) {
        this.production = production;
    }

    @Override
    public int compareTo(TileTypeChange other) {
        int cmp;
        int n = this.from == null ? (other.from == null ? 0 : -1) : (cmp = other.from == null ? 1 : FreeColObject.compareIds(this.from, other.from));
        if (cmp != 0) {
            return cmp;
        }
        return this.to == null ? (other.to == null ? 0 : -1) : (other.to == null ? 1 : FreeColObject.compareIds(this.to, other.to));
    }

    public boolean equals(Object other) {
        if (other instanceof TileTypeChange) {
            return this.compareTo((TileTypeChange)other) == 0;
        }
        return super.equals(other);
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = 37 * hash + Utils.hashCode(this.from);
        hash = 37 * hash + Utils.hashCode(this.to);
        return 37 * hash + Utils.hashCode(this.production);
    }

    public void toXML(FreeColXMLWriter xw) throws XMLStreamException {
        xw.writeStartElement(TileTypeChange.getXMLElementTagName());
        xw.writeAttribute(FROM_TAG, this.from);
        xw.writeAttribute(TO_TAG, this.to);
        if (this.production != null) {
            xw.writeStartElement(PRODUCTION_TAG);
            xw.writeAttribute(GOODS_TYPE_TAG, this.production.getType());
            xw.writeAttribute(VALUE_TAG, this.production.getAmount());
            xw.writeEndElement();
        }
        xw.writeEndElement();
    }

    public void readFromXML(FreeColXMLReader xr, Specification spec) throws XMLStreamException {
        this.from = xr.getType(spec, FROM_TAG, TileType.class, null);
        this.to = xr.getType(spec, TO_TAG, TileType.class, null);
        while (xr.nextTag() != 2) {
            String tag = xr.getLocalName();
            if (PRODUCTION_TAG.equals(tag)) {
                GoodsType type = xr.getType(spec, GOODS_TYPE_TAG, GoodsType.class, null);
                int amount = xr.getAttribute(VALUE_TAG, 0);
                this.production = new AbstractGoods(type, amount);
                xr.closeTag(PRODUCTION_TAG);
                continue;
            }
            throw new XMLStreamException("Bogus TileTypeChange tag: " + tag);
        }
    }

    public String getXMLTagName() {
        return TileTypeChange.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "change";
    }
}

