/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.time.ZoneOffset;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.plain.BinaryDVIndexFieldData;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public enum ValueType implements Writeable
{
    STRING(1, "string", "string", ValuesSourceType.BYTES, IndexFieldData.class, DocValueFormat.RAW),
    LONG(2, "byte|short|integer|long", "long", ValuesSourceType.NUMERIC, IndexNumericFieldData.class, DocValueFormat.RAW),
    DOUBLE(3, "float|double", "double", ValuesSourceType.NUMERIC, IndexNumericFieldData.class, DocValueFormat.RAW),
    NUMBER(4, "number", "number", ValuesSourceType.NUMERIC, IndexNumericFieldData.class, DocValueFormat.RAW),
    DATE(5, "date", "date", ValuesSourceType.NUMERIC, IndexNumericFieldData.class, new DocValueFormat.DateTime(DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER, ZoneOffset.UTC, DateFieldMapper.Resolution.MILLISECONDS)),
    IP(6, "ip", "ip", ValuesSourceType.BYTES, IndexFieldData.class, DocValueFormat.IP),
    NUMERIC(7, "numeric", "numeric", ValuesSourceType.NUMERIC, IndexNumericFieldData.class, DocValueFormat.RAW),
    GEOPOINT(8, "geo_point", "geo_point", ValuesSourceType.GEOPOINT, IndexGeoPointFieldData.class, DocValueFormat.GEOHASH),
    BOOLEAN(9, "boolean", "boolean", ValuesSourceType.NUMERIC, IndexNumericFieldData.class, DocValueFormat.BOOLEAN),
    RANGE(10, "range", "range", ValuesSourceType.RANGE, BinaryDVIndexFieldData.class, DocValueFormat.RAW);

    final String description;
    final ValuesSourceType valuesSourceType;
    final Class<? extends IndexFieldData> fieldDataType;
    final DocValueFormat defaultFormat;
    private final byte id;
    private String preferredName;
    public static final ParseField VALUE_TYPE;

    private ValueType(byte id, String description, String preferredName, ValuesSourceType valuesSourceType, Class<? extends IndexFieldData> fieldDataType, DocValueFormat defaultFormat) {
        this.id = id;
        this.description = description;
        this.preferredName = preferredName;
        this.valuesSourceType = valuesSourceType;
        this.fieldDataType = fieldDataType;
        this.defaultFormat = defaultFormat;
    }

    public String getPreferredName() {
        return this.preferredName;
    }

    public ValuesSourceType getValuesSourceType() {
        return this.valuesSourceType;
    }

    public boolean isA(ValueType valueType) {
        return valueType.valuesSourceType == this.valuesSourceType && valueType.fieldDataType.isAssignableFrom(this.fieldDataType);
    }

    public boolean isNotA(ValueType valueType) {
        return !this.isA(valueType);
    }

    public DocValueFormat defaultFormat() {
        return this.defaultFormat;
    }

    public static ValueType resolveForScript(String type) {
        switch (type) {
            case "string": {
                return STRING;
            }
            case "double": 
            case "float": {
                return DOUBLE;
            }
            case "long": 
            case "integer": 
            case "short": 
            case "byte": {
                return LONG;
            }
            case "date": {
                return DATE;
            }
            case "ip": {
                return IP;
            }
            case "boolean": {
                return BOOLEAN;
            }
        }
        return null;
    }

    public String toString() {
        return this.description;
    }

    public static ValueType readFromStream(StreamInput in) throws IOException {
        byte id = in.readByte();
        for (ValueType valueType : ValueType.values()) {
            if (id != valueType.id) continue;
            return valueType;
        }
        throw new IOException("No valueType found for id [" + id + "]");
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.id);
    }

    static {
        VALUE_TYPE = new ParseField("value_type", new String[]{"valueType"});
    }
}

