/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.creation.ui.viewers;

import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.cxf.core.model.Java2WSDataModel;
import org.eclipse.jst.ws.internal.cxf.creation.ui.CXFCreationUIPlugin;
import org.eclipse.swt.graphics.Image;

public class AnnotationColumnLabelProvider
extends ColumnLabelProvider {
    private Image addAnnotationImage;
    private Image removeAnnotationImage;
    private Image disabled;
    private Map<IMethod, Map<String, Boolean>> methodMap;
    private String annotationKey;
    private IType type;

    public AnnotationColumnLabelProvider(Java2WSDataModel model, String annotationKey, IType type) {
        this.methodMap = model.getMethodMap();
        this.annotationKey = annotationKey;
        this.type = type;
        this.addAnnotationImage = CXFCreationUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jst.ws.cxf.creation.ui", (String)"icons/obj16/true.gif").createImage();
        this.removeAnnotationImage = CXFCreationUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jst.ws.cxf.creation.ui", (String)"icons/obj16/false.gif").createImage();
        this.disabled = CXFCreationUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jst.ws.cxf.creation.ui", (String)"icons/obj16/disabled.gif").createImage();
    }

    public String getText(Object element) {
        return "";
    }

    public Image getImage(Object element) {
        if (element instanceof SourceMethod) {
            if (this.methodMap == null || this.annotationKey == null || this.type == null) {
                return null;
            }
            SourceMethod method = (SourceMethod)element;
            if (this.annotationKey.equals("WebParam")) {
                List parameters = AnnotationUtils.getSingleVariableDeclarations((IMethod)method);
                if (parameters.size() == 0) {
                    return this.disabled;
                }
                for (SingleVariableDeclaration parameter : parameters) {
                    ILocalVariable variable = (ILocalVariable)parameter.resolveBinding().getJavaElement();
                    if (!AnnotationUtils.isAnnotationPresent((IJavaElement)variable, (String)this.annotationKey)) continue;
                    return this.disabled;
                }
            }
            if (AnnotationUtils.isAnnotationPresent((IJavaElement)method, (String)this.annotationKey)) {
                return this.disabled;
            }
            if (this.methodMap.get(method) != null) {
                Boolean addAnnotation = this.methodMap.get(method).get(this.annotationKey);
                if (addAnnotation.booleanValue()) {
                    return this.addAnnotationImage;
                }
                return this.removeAnnotationImage;
            }
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        this.addAnnotationImage.dispose();
        this.removeAnnotationImage.dispose();
        this.disabled.dispose();
    }
}

