/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.componentcore;

import java.io.File;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.RARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.RARFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.RarImportStrategyImpl;
import org.eclipse.jst.j2ee.internal.componentcore.EnterpriseBinaryComponentHelper;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class JCABinaryComponentHelper
extends EnterpriseBinaryComponentHelper {
    public static boolean handlesComponent(IVirtualComponent component) {
        JCABinaryComponentHelper helper = null;
        try {
            helper = new JCABinaryComponentHelper(component);
            boolean bl = helper.isArchiveValid();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
        finally {
            if (helper != null) {
                helper.dispose();
            }
        }
    }

    @Override
    protected ArchiveTypeDiscriminator getDiscriminator() {
        return Discriminator.getInstance();
    }

    public JCABinaryComponentHelper(IVirtualComponent component) {
        super(component);
    }

    public EObject getPrimaryRootObject() {
        return ((RARFile)this.getArchive()).getDeploymentDescriptor();
    }

    protected static class Discriminator
    extends RarImportStrategyImpl.Discriminator {
        private static Discriminator instance;

        protected Discriminator() {
        }

        public static Discriminator getInstance() {
            if (instance == null) {
                instance = new Discriminator();
            }
            return instance;
        }

        public Archive createConvertedArchive() {
            ReferenceCountedRARFileImpl archive = new ReferenceCountedRARFileImpl();
            return archive;
        }
    }

    protected static class ReferenceCountedRARFileImpl
    extends RARFileImpl
    implements EnterpriseBinaryComponentHelper.IReferenceCountedArchive {
        private int count = 0;
        private EnterpriseBinaryComponentHelper helper = null;

        protected ReferenceCountedRARFileImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void access() {
            ReferenceCountedRARFileImpl referenceCountedRARFileImpl = this;
            synchronized (referenceCountedRARFileImpl) {
                ++this.count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.helper.aboutToClose();
            ReferenceCountedRARFileImpl referenceCountedRARFileImpl = this;
            synchronized (referenceCountedRARFileImpl) {
                --this.count;
                if (this.count > 0) {
                    return;
                }
            }
            JCABinaryComponentHelper.physicallyClose(this);
        }

        @Override
        public void forceClose() {
            this.count = 0;
            this.helper.aboutToClose();
            super.close();
        }

        @Override
        public EnterpriseBinaryComponentHelper getEnterpriseBinaryComponentHelper() {
            return this.helper;
        }

        @Override
        public void setEnterpriseBinaryComponentHelper(EnterpriseBinaryComponentHelper helper) {
            this.helper = helper;
        }

        protected LoadStrategy createLoadStrategyForReopen(Archive parent) throws IOException {
            try {
                return JCABinaryComponentHelper.createBinaryLoadStrategy(this.getEnterpriseBinaryComponentHelper());
            }
            catch (OpenFailureException e) {
                throw new IOException(e.getMessage());
            }
        }

        protected void cleanupAfterTempSave(String uri, File original, File destinationFile) throws SaveFailureException {
            this.helper.preCleanupAfterTempSave(uri, original, destinationFile);
            super.cleanupAfterTempSave(uri, original, destinationFile);
            this.helper.postCleanupAfterTempSave(uri, original, destinationFile);
        }
    }
}

