/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import jnr.ffi.CallingConvention;
import jnr.ffi.LibraryOption;
import jnr.ffi.Runtime;
import jnr.ffi.Variable;
import jnr.ffi.annotations.Synchronized;
import jnr.ffi.mapper.CachingTypeMapper;
import jnr.ffi.mapper.CompositeTypeMapper;
import jnr.ffi.mapper.FunctionMapper;
import jnr.ffi.mapper.SignatureTypeMapper;
import jnr.ffi.mapper.SignatureTypeMapperAdapter;
import jnr.ffi.mapper.TypeMapper;
import jnr.ffi.provider.IdentityFunctionMapper;
import jnr.ffi.provider.Invoker;
import jnr.ffi.provider.LoadedLibrary;
import jnr.ffi.provider.NativeInvocationHandler;
import jnr.ffi.provider.NullTypeMapper;
import jnr.ffi.provider.jffi.AsmClassLoader;
import jnr.ffi.provider.jffi.DefaultInvokerFactory;
import jnr.ffi.provider.jffi.InvokerTypeMapper;
import jnr.ffi.provider.jffi.InvokerUtil;
import jnr.ffi.provider.jffi.LibraryLoader;
import jnr.ffi.provider.jffi.NativeClosureManager;
import jnr.ffi.provider.jffi.NativeFunctionMapperContext;
import jnr.ffi.provider.jffi.NativeLibrary;
import jnr.ffi.provider.jffi.NativeLibraryLoader;
import jnr.ffi.provider.jffi.NativeRuntime;
import jnr.ffi.provider.jffi.ReflectionVariableAccessorGenerator;
import jnr.ffi.util.Annotations;

class ReflectionLibraryLoader
extends LibraryLoader {
    ReflectionLibraryLoader() {
    }

    @Override
    <T> T loadLibrary(NativeLibrary library, Class<T> interfaceClass, Map<LibraryOption, ?> libraryOptions) {
        return interfaceClass.cast(Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass, LoadedLibrary.class}, (InvocationHandler)new NativeInvocationHandler(new LazyLoader(library, interfaceClass, libraryOptions))));
    }

    private static final class FunctionNotFoundInvoker
    implements Invoker {
        private final Method method;
        private final String functionName;

        private FunctionNotFoundInvoker(Method method, String functionName) {
            this.method = method;
            this.functionName = functionName;
        }

        @Override
        public Object invoke(Object self, Object[] parameters) {
            throw new UnsatisfiedLinkError(String.format("native method '%s' not found for method %s", this.functionName, this.method));
        }
    }

    private static final class GetRuntimeInvoker
    implements Invoker {
        private final Runtime runtime;

        private GetRuntimeInvoker(Runtime runtime) {
            this.runtime = runtime;
        }

        @Override
        public Object invoke(Object self, Object[] parameters) {
            return this.runtime;
        }
    }

    private static final class LazyLoader<T>
    extends AbstractMap<Method, Invoker> {
        private final DefaultInvokerFactory invokerFactory;
        private final Runtime runtime = NativeRuntime.getInstance();
        private final AsmClassLoader classLoader = new AsmClassLoader();
        private final SignatureTypeMapper typeMapper;
        private final FunctionMapper functionMapper;
        private final CallingConvention libraryCallingConvention;
        private final boolean libraryIsSynchronized;
        private final NativeLibrary library;
        private final Class<T> interfaceClass;
        private final Map<LibraryOption, ?> libraryOptions;

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private LazyLoader(NativeLibrary library, Class<T> interfaceClass, Map<LibraryOption, ?> libraryOptions) {
            void var4_9;
            this.library = library;
            this.interfaceClass = interfaceClass;
            this.libraryOptions = libraryOptions;
            FunctionMapper functionMapper = this.functionMapper = libraryOptions.containsKey((Object)LibraryOption.FunctionMapper) ? (FunctionMapper)libraryOptions.get((Object)LibraryOption.FunctionMapper) : IdentityFunctionMapper.getInstance();
            if (libraryOptions.containsKey((Object)LibraryOption.TypeMapper)) {
                Object tm = libraryOptions.get((Object)LibraryOption.TypeMapper);
                if (tm instanceof SignatureTypeMapper) {
                    SignatureTypeMapper signatureTypeMapper = (SignatureTypeMapper)tm;
                } else {
                    if (!(tm instanceof TypeMapper)) throw new IllegalArgumentException("TypeMapper option is not a valid TypeMapper instance");
                    SignatureTypeMapperAdapter signatureTypeMapperAdapter = new SignatureTypeMapperAdapter((TypeMapper)tm);
                }
            } else {
                NullTypeMapper nullTypeMapper = new NullTypeMapper();
            }
            this.typeMapper = new CompositeTypeMapper(new SignatureTypeMapper[]{var4_9, new CachingTypeMapper(new InvokerTypeMapper(new NativeClosureManager(this.runtime, (SignatureTypeMapper)var4_9, this.classLoader), this.classLoader, NativeLibraryLoader.ASM_ENABLED))});
            this.libraryCallingConvention = InvokerUtil.getCallingConvention(interfaceClass, libraryOptions);
            this.libraryIsSynchronized = interfaceClass.isAnnotationPresent(Synchronized.class);
            this.invokerFactory = new DefaultInvokerFactory(this.runtime, library, this.typeMapper, this.functionMapper, this.libraryCallingConvention, libraryOptions, this.libraryIsSynchronized);
        }

        @Override
        public Set<Map.Entry<Method, Invoker>> entrySet() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public synchronized Invoker get(Object key) {
            if (!(key instanceof Method)) {
                throw new IllegalArgumentException("key not instance of Method");
            }
            Method method = (Method)key;
            if (Variable.class.isAssignableFrom(method.getReturnType())) {
                return this.getVariableAccessor(method);
            }
            if (method.getName().equals("getRuntime") && method.getReturnType().isAssignableFrom(NativeRuntime.class)) {
                return new GetRuntimeInvoker(this.runtime);
            }
            return this.invokerFactory.createInvoker(method);
        }

        private Invoker getVariableAccessor(Method method) {
            Collection<Annotation> annotations = Annotations.sortedAnnotationCollection(method.getAnnotations());
            String functionName = this.functionMapper.mapFunctionName(method.getName(), new NativeFunctionMapperContext(this.library, annotations));
            long symbolAddress = this.library.getSymbolAddress(functionName);
            if (symbolAddress == 0L) {
                return new FunctionNotFoundInvoker(method, functionName);
            }
            Variable variable = ReflectionVariableAccessorGenerator.createVariableAccessor(this.runtime, method, symbolAddress, this.typeMapper, annotations);
            return new VariableAcccessorInvoker(variable);
        }

        private static final class VariableAcccessorInvoker
        implements Invoker {
            private final Variable variable;

            private VariableAcccessorInvoker(Variable variable) {
                this.variable = variable;
            }

            @Override
            public Object invoke(Object self, Object[] parameters) {
                return this.variable;
            }
        }
    }
}

