/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.core.session;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.common.core.xml.XmlUtils;
import org.eclipse.tracecompass.internal.lttng2.control.core.Activator;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IChannelInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IDomainInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ISessionInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEnablement;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEventType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.lttng2.control.core.session.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class SessionConfigGenerator {
    private static final String SESSION_XSD_FILENAME = "session.xsd";
    private static final String INDENT_AMOUNT_PROPERTY_NAME = "{http://xml.apache.org/xslt}indent-amount";
    private static final String INDENT_AMOUNT_PROPERTY_VALUE = "4";

    private SessionConfigGenerator() {
    }

    public static IStatus generateSessionConfig(Set<ISessionInfo> sessions, IPath sessionFileDestination) {
        if (sessions == null || sessions.isEmpty()) {
            return new Status(4, "org.eclipse.tracecompass.lttng2.control.core", Messages.SessionConfigXML_InvalidSessionInfoList);
        }
        if (sessionFileDestination == null) {
            return new Status(4, "org.eclipse.tracecompass.lttng2.control.core", Messages.SessionConfigXML_InvalidTraceSessionPath);
        }
        try {
            Document sessionConfigDocument = SessionConfigGenerator.generateSessionConfig(sessions);
            SessionConfigGenerator.saveSessionConfig(sessionConfigDocument, sessionFileDestination.toString());
        }
        catch (IllegalArgumentException | ParserConfigurationException | TransformerException e) {
            Activator.getDefault().logError("Error generating the session configuration file: " + sessionFileDestination.toString(), e);
            return new Status(4, "org.eclipse.tracecompass.lttng2.control.core", e.getMessage());
        }
        return Status.OK_STATUS;
    }

    private static @NonNull Document generateSessionConfig(Iterable<ISessionInfo> sessions) throws IllegalArgumentException, ParserConfigurationException {
        DocumentBuilder docBuilder = XmlUtils.newSafeDocumentBuilderFactory().newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element rootElement = document.createElement("sessions");
        document.appendChild(rootElement);
        for (ISessionInfo session : sessions) {
            Element sessionElement = document.createElement("session");
            String enabled = session.getSessionState().equals((Object)TraceSessionState.ACTIVE) ? "true" : "false";
            SessionConfigGenerator.addElementContent(document, sessionElement, "name", session.getName());
            SessionConfigGenerator.addElementContent(document, sessionElement, "started", enabled);
            if (session.isSnapshotSession()) {
                Element attributesElement = document.createElement("attributes");
                SessionConfigGenerator.addElementContent(document, attributesElement, "snapshot_mode", "true");
                sessionElement.appendChild(attributesElement);
            }
            sessionElement.appendChild(SessionConfigGenerator.getDomainsElement(document, session));
            sessionElement.appendChild(SessionConfigGenerator.getOutputElement(document, session));
            rootElement.appendChild(sessionElement);
        }
        return document;
    }

    private static Element getDomainsElement(Document document, ISessionInfo session) {
        Element domainsElement = document.createElement("domains");
        IDomainInfo[] iDomainInfoArray = session.getDomains();
        int n = iDomainInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDomainInfo domain = iDomainInfoArray[n2];
            Element domainElement = document.createElement("domain");
            String domainType = null;
            switch (domain.getDomain()) {
                case KERNEL: {
                    domainType = "KERNEL";
                    break;
                }
                case UST: {
                    domainType = "UST";
                    break;
                }
            }
            SessionConfigGenerator.addElementContent(document, domainElement, "type", domainType);
            String bufferType = null;
            switch (domain.getBufferType()) {
                case BUFFER_PER_UID: {
                    bufferType = "PER_UID";
                    break;
                }
                case BUFFER_PER_PID: {
                    bufferType = "PER_PID";
                    break;
                }
                case BUFFER_SHARED: {
                    bufferType = "GLOBAL";
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Messages.SessionConfigXML_UnknownDomainBufferType);
                }
            }
            SessionConfigGenerator.addElementContent(document, domainElement, "buffer_type", bufferType);
            domainElement.appendChild(SessionConfigGenerator.getChannelsElement(document, domain.getDomain(), domain.getChannels()));
            domainsElement.appendChild(domainElement);
            ++n2;
        }
        return domainsElement;
    }

    private static Element getOutputElement(Document document, ISessionInfo session) {
        Element outputElement = document.createElement("output");
        if (session.isSnapshotSession()) {
            outputElement.appendChild(SessionConfigGenerator.getSnapshotOuputsElement(document, session));
        } else if (session.isStreamedTrace()) {
            outputElement.appendChild(SessionConfigGenerator.getNetOutputElement(document, session));
        } else {
            outputElement.appendChild(SessionConfigGenerator.getConsumerOutputElement(document, session));
        }
        return outputElement;
    }

    private static Element getChannelsElement(Document document, TraceDomainType domain, IChannelInfo[] channels) {
        Element channelsElement = document.createElement("channels");
        IChannelInfo[] iChannelInfoArray = channels;
        int n = channels.length;
        int n2 = 0;
        while (n2 < n) {
            IChannelInfo channel = iChannelInfoArray[n2];
            Element channelElement = document.createElement("channel");
            SessionConfigGenerator.addElementContent(document, channelElement, "name", channel.getName());
            String overwriteMode = channel.isOverwriteMode() ? "OVERWRITE" : "DISCARD";
            String enabled = channel.getState().equals((Object)TraceEnablement.ENABLED) ? "true" : "false";
            SessionConfigGenerator.addElementContent(document, channelElement, "enabled", enabled);
            SessionConfigGenerator.addElementContent(document, channelElement, "overwrite_mode", overwriteMode);
            SessionConfigGenerator.addElementContent(document, channelElement, "subbuffer_size", channel.getSubBufferSize());
            SessionConfigGenerator.addElementContent(document, channelElement, "subbuffer_count", channel.getNumberOfSubBuffers());
            SessionConfigGenerator.addElementContent(document, channelElement, "switch_timer_interval", channel.getSwitchTimer());
            SessionConfigGenerator.addElementContent(document, channelElement, "read_timer_interval", channel.getReadTimer());
            String outputType = channel.getOutputType().getInName().startsWith("MMAP") ? "MMAP" : "SPLICE";
            SessionConfigGenerator.addElementContent(document, channelElement, "output_type", outputType);
            SessionConfigGenerator.addElementContent(document, channelElement, "tracefile_size", channel.getMaxSizeTraceFiles());
            SessionConfigGenerator.addElementContent(document, channelElement, "tracefile_count", channel.getMaxNumberTraceFiles());
            SessionConfigGenerator.addElementContent(document, channelElement, "live_timer_interval", "0");
            channelElement.appendChild(SessionConfigGenerator.getEventsElement(document, domain, channel.getEvents()));
            channelsElement.appendChild(channelElement);
            ++n2;
        }
        return channelsElement;
    }

    private static Element getEventsElement(Document document, TraceDomainType domain, IEventInfo[] events) {
        Element eventsElement = document.createElement("events");
        IEventInfo[] iEventInfoArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            IEventInfo event = iEventInfoArray[n2];
            Element eventElement = document.createElement("event");
            String enabled = event.getState().equals((Object)TraceEnablement.ENABLED) ? "true" : "false";
            SessionConfigGenerator.addElementContent(document, eventElement, "name", event.getName());
            SessionConfigGenerator.addElementContent(document, eventElement, "enabled", enabled);
            TraceEventType eventType = event.getEventType();
            if (eventType.equals((Object)TraceEventType.UNKNOWN)) {
                throw new IllegalArgumentException(Messages.SessionConfigXML_UnknownEventType);
            }
            SessionConfigGenerator.addElementContent(document, eventElement, "type", eventType.getInName().toUpperCase());
            if (domain.equals((Object)TraceDomainType.UST) && !event.getLogLevel().equals(TraceLogLevel.LEVEL_UNKNOWN)) {
                SessionConfigGenerator.addElementContent(document, eventElement, "loglevel", event.getLogLevel().ordinal());
            }
            eventsElement.appendChild(eventElement);
            ++n2;
        }
        return eventsElement;
    }

    private static Element getConsumerOutputElement(Document document, ISessionInfo session) {
        Element consumerOutputElement = document.createElement("consumer_output");
        Element destinationElement = document.createElement("destination");
        SessionConfigGenerator.addElementContent(document, consumerOutputElement, "enabled", "true");
        if (session.isStreamedTrace()) {
            destinationElement.appendChild(SessionConfigGenerator.getNetOutputElement(document, session));
        } else {
            SessionConfigGenerator.addElementContent(document, destinationElement, "path", session.getSessionPath());
        }
        consumerOutputElement.appendChild(destinationElement);
        return consumerOutputElement;
    }

    private static Element getNetOutputElement(Document document, ISessionInfo session) {
        Element netOutputElement = document.createElement("net_output");
        String networkUrl = session.getNetworkUrl();
        String controlUri = networkUrl == null ? session.getControlUrl() : networkUrl;
        String dataUri = networkUrl == null ? session.getDataUrl() : networkUrl;
        SessionConfigGenerator.addElementContent(document, netOutputElement, "control_uri", controlUri);
        SessionConfigGenerator.addElementContent(document, netOutputElement, "data_uri", dataUri);
        return netOutputElement;
    }

    private static Element getSnapshotOuputsElement(Document document, ISessionInfo session) {
        Element snapshotOutputsElement = document.createElement("snapshot_outputs");
        Element outputElement = document.createElement("output");
        SessionConfigGenerator.addElementContent(document, outputElement, "name", session.getSnapshotInfo().getName());
        SessionConfigGenerator.addElementContent(document, outputElement, "max_size", "0");
        outputElement.appendChild(SessionConfigGenerator.getConsumerOutputElement(document, session));
        snapshotOutputsElement.appendChild(outputElement);
        return snapshotOutputsElement;
    }

    public static IStatus sessionValidate(File sessionFile) {
        URL url = SessionConfigGenerator.class.getResource(SESSION_XSD_FILENAME);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource xmlSource = new StreamSource(sessionFile);
        try {
            Schema schema = schemaFactory.newSchema(url);
            Validator validator = schema.newValidator();
            validator.validate(xmlSource);
        }
        catch (SAXParseException e) {
            String error = NLS.bind((String)Messages.SessionConfigXML_XmlParseError, (Object)e.getLineNumber(), (Object)e.getLocalizedMessage());
            Activator.getDefault().logError(error);
            return new Status(4, "org.eclipse.tracecompass.lttng2.control.core", error, (Throwable)e);
        }
        catch (SAXException e) {
            String error = NLS.bind((String)Messages.SessionConfigXML_XmlValidationError, (Object)e.getLocalizedMessage());
            Activator.getDefault().logError(error);
            return new Status(4, "org.eclipse.tracecompass.lttng2.control.core", error, (Throwable)e);
        }
        catch (IOException e) {
            String error = Messages.SessionConfigXML_XmlValidateError;
            Activator.getDefault().logError("IO exception occurred", e);
            return new Status(4, "org.eclipse.tracecompass.lttng2.control.core", error, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private static void saveSessionConfig(Document document, String destination) throws TransformerException {
        Transformer transformer = XmlUtils.newSecureTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty(INDENT_AMOUNT_PROPERTY_NAME, INDENT_AMOUNT_PROPERTY_VALUE);
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(new File(destination));
        transformer.transform(source, result);
    }

    private static void addElementContent(Document document, Element parent, String elementName, Object elementContent) {
        Element contentElement = document.createElement(elementName);
        contentElement.appendChild(document.createTextNode(elementContent.toString()));
        parent.appendChild(contentElement);
    }
}

