/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrized;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntityElement;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class GotoObjectDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_ID = "GotoObjectDialog";
    private static final boolean SHOW_OBJECT_TYPES = true;
    public static final int MAX_RESULT_COUNT = 1000;
    private final DBCExecutionContext context;
    private DBSObject container;
    private Map<String, Boolean> enabledTypes = new HashMap<String, Boolean>();
    private boolean hasMoreResults;

    public GotoObjectDialog(Shell shell, DBCExecutionContext context, DBSObject container) {
        super(shell, true);
        this.context = context;
        this.container = container;
        this.setTitle(String.valueOf(UINavigatorMessages.dialog_project_goto_object_title) + " '" + context.getDataSource().getContainer().getName() + "'");
        this.setListLabelProvider((ILabelProvider)new ObjectLabelProvider(null, null));
        this.setDetailsLabelProvider((ILabelProvider)new DetailsLabelProvider());
    }

    protected Control createExtendedContentArea(Composite parent) {
        final IDialogSettings driverSettings = DialogSettings.getOrCreateSection((IDialogSettings)this.getDialogSettings(), (String)this.context.getDataSource().getContainer().getDriver().getId());
        DBSStructureAssistant structureAssistant = (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)this.context.getDataSource());
        if (structureAssistant == null) {
            return null;
        }
        ArrayList<DBSObjectType> typesToSearch = new ArrayList<DBSObjectType>();
        DBSObjectType[] dBSObjectTypeArray = structureAssistant.getSearchObjectTypes();
        int n = dBSObjectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBSObjectType type = dBSObjectTypeArray[n2];
            Class typeClass = type.getTypeClass();
            if (!DBSEntityElement.class.isAssignableFrom(typeClass)) {
                typesToSearch.add(type);
            }
            ++n2;
        }
        if (!CommonUtils.isEmpty(typesToSearch)) {
            Group cbGroup = new Group(parent, 0);
            cbGroup.setText("Objects:");
            RowLayout rowLayout = new RowLayout(256);
            rowLayout.wrap = true;
            cbGroup.setLayout((Layout)rowLayout);
            cbGroup.setLayoutData((Object)new GridData(768));
            for (DBSObjectType type : typesToSearch) {
                if (!this.isValidObjectType(type)) continue;
                final Button cb = new Button((Composite)cbGroup, 32);
                cb.setData((Object)type);
                final String typeName = CommonUtils.notEmpty((String)type.getTypeName());
                cb.setText(typeName);
                boolean enabled = driverSettings.get(typeName) != null ? driverSettings.getBoolean(typeName) : true;
                cb.setSelection(enabled);
                this.enabledTypes.put(typeName, enabled);
                cb.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        GotoObjectDialog.this.enabledTypes.put(typeName, cb.getSelection());
                        driverSettings.put(typeName, cb.getSelection());
                        GotoObjectDialog.this.applyFilter();
                    }
                });
            }
            return cbGroup;
        }
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ObjectFilter();
    }

    protected boolean isValidObjectType(DBSObjectType objectType) {
        Class typeClass = objectType.getTypeClass();
        return !DBSEntityElement.class.isAssignableFrom(typeClass);
    }

    protected Comparator getItemsComparator() {
        return (o1, o2) -> {
            if (o1 instanceof DBPNamedObject && o2 instanceof DBPNamedObject) {
                return DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)o1), (DBPEvaluationContext)DBPEvaluationContext.UI).compareToIgnoreCase(DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)o2), (DBPEvaluationContext)DBPEvaluationContext.UI));
            }
            return 0;
        };
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        DBSStructureAssistant structureAssistant = (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)this.context.getDataSource());
        if (structureAssistant == null) {
            return;
        }
        String nameMask = ((ObjectFilter)itemsFilter).getNameMask();
        DBRProgressMonitor monitor = RuntimeUtils.makeMonitor((IProgressMonitor)progressMonitor);
        try {
            try {
                monitor.beginTask("Search for '" + nameMask + "'", 100);
                ArrayList<DBSObjectType> typesToSearch = new ArrayList<DBSObjectType>();
                DBSObjectType[] dBSObjectTypeArray = structureAssistant.getSearchObjectTypes();
                int n = dBSObjectTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DBSObjectType type = dBSObjectTypeArray[n2];
                    if (this.isValidObjectType(type) && Boolean.TRUE.equals(this.enabledTypes.get(type.getTypeName()))) {
                        typesToSearch.add(type);
                    }
                    ++n2;
                }
                ObjectFinder objectFinder = new ObjectFinder(structureAssistant, monitor, typesToSearch, nameMask);
                DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)this.context.getDataSource(), (DBRRunnableParametrized)objectFinder);
                DBPDataSourceContainer dsContainer = this.context.getDataSource().getContainer();
                for (DBSObjectReference ref : objectFinder.getResult()) {
                    DBSObjectFilter filter = dsContainer.getObjectFilter(ref.getObjectClass(), ref.getContainer(), true);
                    if (filter != null && filter.isEnabled() && !filter.matches(ref.getName())) continue;
                    contentProvider.add((Object)ref, itemsFilter);
                }
            }
            catch (DBException e) {
                throw new CoreException(GeneralUtils.makeExceptionStatus((Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    public String getElementName(Object item) {
        if (item instanceof DBPNamedObject) {
            return DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)item), (DBPEvaluationContext)DBPEvaluationContext.UI);
        }
        return item.toString();
    }

    private static class DetailsLabelProvider
    extends ObjectLabelProvider {
        private DetailsLabelProvider() {
        }

        @Override
        public String getText(Object element) {
            if (element instanceof DBPNamedObject) {
                return DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)element), (DBPEvaluationContext)DBPEvaluationContext.UI);
            }
            return super.getText(element);
        }
    }

    private class ObjectFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private Pattern namePattern;
        private Map<String, Boolean> enabledTypesCopy;

        public ObjectFilter() {
            super((FilteredItemsSelectionDialog)GotoObjectDialog.this);
            this.namePattern = null;
            this.enabledTypesCopy = new HashMap<String, Boolean>(GotoObjectDialog.this.enabledTypes);
        }

        public int getMatchRule() {
            return 3;
        }

        public boolean matchItem(Object item) {
            if (item instanceof DBPNamedObject) {
                String objectName = ((DBPNamedObject)item).getName();
                this.getPattern().replaceAll("[\\*\\%\\?]", "");
                return this.getNamePattern().matcher(objectName).matches();
            }
            return false;
        }

        public boolean isConsistentItem(Object item) {
            return false;
        }

        public String getNameMask() {
            String nameMask = this.getPattern();
            nameMask = nameMask.replace("*", "%").replace("?", "_");
            int matchRule = this.getMatchRule();
            if ((matchRule & 1) != 0 && !nameMask.endsWith("%")) {
                nameMask = String.valueOf(nameMask) + "%";
            }
            return nameMask;
        }

        private Pattern getNamePattern() {
            if (this.namePattern == null) {
                this.namePattern = Pattern.compile(SQLUtils.makeLikePattern((String)this.getNameMask()), 10);
            }
            return this.namePattern;
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            return filter instanceof ObjectFilter && super.equalsFilter(filter) && CommonUtils.equalObjects(this.enabledTypesCopy, ((ObjectFilter)filter).enabledTypesCopy);
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            return !GotoObjectDialog.this.hasMoreResults && super.isSubFilter(filter) && CommonUtils.equalObjects(this.enabledTypesCopy, ((ObjectFilter)filter).enabledTypesCopy);
        }
    }

    private class ObjectFinder
    implements DBRRunnableParametrized<DBRProgressMonitor> {
        private final DBSStructureAssistant structureAssistant;
        private final DBRProgressMonitor monitor;
        private final List<DBSObjectType> typesToSearch;
        private final String nameMask;
        private List<DBSObjectReference> result;

        public ObjectFinder(DBSStructureAssistant structureAssistant, DBRProgressMonitor monitor, List<DBSObjectType> typesToSearch, String nameMask) {
            this.structureAssistant = structureAssistant;
            this.monitor = monitor;
            this.typesToSearch = typesToSearch;
            this.nameMask = nameMask;
        }

        public List<DBSObjectReference> getResult() {
            return this.result;
        }

        public void run(DBRProgressMonitor param) throws InvocationTargetException, InterruptedException {
            try {
                this.result = this.structureAssistant.findObjectsByMask(this.monitor, GotoObjectDialog.this.container, this.typesToSearch.toArray(new DBSObjectType[this.typesToSearch.size()]), this.nameMask, false, true, 1000);
                GotoObjectDialog.this.hasMoreResults = this.result.size() >= 1000;
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
    }

    private static class ObjectLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private ObjectLabelProvider() {
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof DBPNamedObject) {
                DBPNamedObject namedObject = (DBPNamedObject)element;
                StyledString str = new StyledString(namedObject.getName());
                String fullName = DBUtils.getObjectFullName((DBPNamedObject)namedObject, (DBPEvaluationContext)DBPEvaluationContext.UI);
                if (!CommonUtils.equalObjects((Object)fullName, (Object)namedObject.getName())) {
                    str.append(" - ", StyledString.QUALIFIER_STYLER);
                    str.append(fullName, StyledString.QUALIFIER_STYLER);
                }
                return str;
            }
            return new StyledString("?");
        }

        public Image getImage(Object element) {
            DBSObjectType objectType;
            if (element instanceof DBSObjectReference && (objectType = ((DBSObjectReference)element).getObjectType()) != null) {
                return DBeaverIcons.getImage((DBPImage)objectType.getImage());
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof DBPNamedObject) {
                return ((DBPNamedObject)element).getName();
            }
            return null;
        }

        /* synthetic */ ObjectLabelProvider(ObjectLabelProvider objectLabelProvider, ObjectLabelProvider objectLabelProvider2) {
            this();
        }
    }
}

