import { DateArray, UnitOfTime } from '../types';
import { Locale, LocaleData } from '../locale/locale.class';
import { DateParsingConfig } from '../create/parsing.types';
import { CalendarSpec } from '../moment/calendar';
import { Duration } from '../duration/constructor';
export declare type DateInput = string | number | Date | string[] | DateArray | MomentInputObject;
export declare const moment: MomentFn;
export interface MomentFn {
    (input?: DateInput | Khronos, format?: string | string[], localeKey?: string | boolean, strict?: boolean, isUTC?: boolean): Khronos;
    ISO_8601: string;
    RFC_2822: string;
    utc(input?: DateInput | Khronos, format?: string | string[], localeKey?: string | boolean, strict?: boolean): Khronos;
    parseZone(input?: DateInput | Khronos, format?: string | string[], localeKey?: string | boolean, strict?: boolean): Khronos;
    unix(num: number): Khronos;
    locale(key?: string | string[], values?: LocaleData): string;
    duration(inp?: Duration | DateInput | Khronos, unit?: MomentUnitOfTime): Duration;
    defineLocale(name: string, config?: LocaleData): Locale;
    parseTwoDigitYear(input: string): number;
    isDate(input?: any): input is Date;
    months(): string[];
    months(index: number): string;
    months(format: string): string[];
    months(format: string, index: number): string;
    monthsShort(): string[];
    monthsShort(index: number): string;
    monthsShort(format: string): string[];
    monthsShort(format: string, index: number): string;
    weekdays(): string[];
    weekdays(index: number): string;
    weekdays(format: string): string[];
    weekdays(format: string, index: number): string;
    weekdays(localeSorted: boolean): string[];
    weekdays(localeSorted: boolean, index: number): string;
    weekdays(localeSorted: boolean, format: string): string[];
    weekdays(localeSorted: boolean, format: string, index: number): string;
    weekdaysShort(): string[];
    weekdaysShort(index: number): string;
    weekdaysShort(format: string): string[];
    weekdaysShort(format: string, index: number): string;
    weekdaysShort(localeSorted: boolean): string[];
    weekdaysShort(localeSorted: boolean, index: number): string;
    weekdaysShort(localeSorted: boolean, format: string): string[];
    weekdaysShort(localeSorted: boolean, format: string, index: number): string;
    weekdaysMin(): string[];
    weekdaysMin(index: number): string;
    weekdaysMin(format: string): string[];
    weekdaysMin(format: string, index: number): string;
    weekdaysMin(localeSorted: boolean): string[];
    weekdaysMin(localeSorted: boolean, index: number): string;
    weekdaysMin(localeSorted: boolean, format: string): string[];
    weekdaysMin(localeSorted: boolean, format: string, index: number): string;
    relativeTimeThreshold(threshold: string): number | boolean;
    relativeTimeThreshold(threshold: string, limit: number): boolean;
    min(...dates: ((DateInput | Khronos)[] | (DateInput | Khronos))[]): Khronos;
    max(...dates: ((DateInput | Khronos)[] | (DateInput | Khronos))[]): Khronos;
    localeData(key?: string | string[] | Khronos): Locale;
    updateLocale(language: string, localeSpec?: LocaleData): Locale;
    calendarFormat(m: Date, now: Date): string;
    calendarFormat(m: Khronos, now: Khronos): string;
    invalid(): Khronos;
    locales(): string[];
    updateOffset(m: Khronos, keepTime?: boolean): void;
}
export interface MomentInputObject {
    years?: number;
    year?: number;
    y?: number;
    months?: number;
    month?: number;
    M?: number;
    days?: number;
    day?: number;
    d?: number;
    dates?: number;
    date?: number;
    D?: number;
    hours?: number;
    hour?: number;
    h?: number;
    minutes?: number;
    minute?: number;
    m?: number;
    seconds?: number;
    second?: number;
    s?: number;
    milliseconds?: number;
    millisecond?: number;
    ms?: number;
    w?: number;
    week?: number;
    weeks?: number;
    Q?: number;
    quarter?: number;
    quarters?: number;
    weekYear?: number;
}
export declare type MomentUnitOfTime = ('year' | 'years' | 'y' | 'month' | 'months' | 'M' | 'week' | 'weeks' | 'w' | 'day' | 'days' | 'd' | 'hour' | 'hours' | 'h' | 'minute' | 'minutes' | 'm' | 'second' | 'seconds' | 's' | 'millisecond' | 'milliseconds' | 'ms' | 'q' | 'quarter' | 'quarters' | 'Q' | 'isoWeek' | 'isoWeeks' | 'W' | 'date' | 'dates' | 'D');
export declare type MomentAll = MomentUnitOfTime | 'weekYear' | 'weekYears' | 'gg' | 'isoWeekYear' | 'isoWeekYears' | 'GG' | 'dayOfYear' | 'dayOfYears' | 'DDD' | 'weekday' | 'weekdays' | 'e' | 'isoWeekday' | 'isoWeekdays' | 'E';
export declare class Khronos {
    _date: Date;
    _isUTC: boolean;
    _isStrict: boolean;
    _locale: Locale;
    _format: string | string[];
    _offset: number;
    _tzm: number;
    constructor(input?: DateInput, format?: string | string[], localeKey?: string, strict?: boolean, isUTC?: boolean, offset?: number);
    _toConfig(): DateParsingConfig;
    locale(): string;
    locale(localeKey: string | string[] | Khronos): Khronos;
    localeData(): Locale;
    add(val: number | string | MomentInputObject, period?: UnitOfTime | MomentUnitOfTime): Khronos;
    calendar(time?: DateInput | Khronos, formats?: CalendarSpec): string;
    clone(): Khronos;
    diff(b: DateInput | Khronos, unitOfTime?: MomentUnitOfTime, precise?: boolean): number;
    endOf(period?: MomentUnitOfTime): Khronos;
    format(format?: string): string;
    from(time?: DateInput | Khronos, withoutSuffix?: boolean): string;
    fromNow(withoutSuffix?: boolean): string;
    to(inp: DateInput | Khronos, suffix?: boolean): string;
    toNow(withoutPrefix?: boolean): string;
    subtract(val: number | string | MomentInputObject, period?: UnitOfTime | MomentUnitOfTime): Khronos;
    get(period: MomentAll): number;
    set(period: MomentAll | MomentInputObject, input?: number): Khronos;
    toString(): string;
    toISOString(): string;
    inspect(): string;
    toJSON(): string;
    toDate(): Date;
    toObject(): {
        [key in MomentUnitOfTime]?: number;
    };
    toArray(): DateArray;
    isAfter(date: Khronos, unit?: MomentUnitOfTime): boolean;
    isBefore(date: Khronos, unit?: MomentUnitOfTime): boolean;
    isBetween(from: Khronos, to: Khronos, unit?: MomentUnitOfTime, inclusivity?: string): boolean;
    isSame(date: Khronos, unit?: MomentUnitOfTime): boolean;
    isSameOrAfter(date: Khronos, unit?: MomentUnitOfTime): boolean;
    isSameOrBefore(date: Khronos, unit?: MomentUnitOfTime): boolean;
    isValid(): boolean;
    valueOf(): number;
    unix(): number;
    utcOffset(): number;
    utcOffset(b: number | string, keepLocalTime?: boolean): Khronos;
    utc(keepLocalTime?: boolean): Khronos;
    local(keepLocalTime?: boolean): Khronos;
    parseZone(input?: string): Khronos;
    hasAlignedHourOffset(input?: Khronos): boolean;
    isDST(): boolean;
    isLocal(): boolean;
    isUtcOffset(): boolean;
    isUTC(): boolean;
    isUtc(): boolean;
    zoneAbbr(): string;
    zoneName(): string;
    year(): number;
    year(year: number): Khronos;
    weekYear(): number;
    weekYear(val: number): Khronos;
    isoWeekYear(): number;
    isoWeekYear(val: number): Khronos;
    isLeapYear(): boolean;
    month(): number;
    month(month: number | string): Khronos;
    /** @deprecated */
    hour(): number;
    hour(hours: number): Khronos;
    hours(): number;
    hours(hours: number): Khronos;
    /** @deprecated */
    minute(): number;
    minute(minutes: number): Khronos;
    minutes(): number;
    minutes(minutes: number): Khronos;
    /** @deprecated */
    second(): number;
    second(seconds: number): Khronos;
    seconds(): number;
    seconds(seconds: number): Khronos;
    /** @deprecated */
    millisecond(): number;
    millisecond(ms: number): Khronos;
    milliseconds(): number;
    milliseconds(seconds: number): Khronos;
    date(): number;
    date(date: number): Khronos;
    day(): number;
    day(input: number | string): Khronos;
    weekday(): number;
    weekday(val: number): Khronos;
    isoWeekday(): number;
    isoWeekday(val: number | string): Khronos;
    dayOfYear(): number;
    dayOfYear(val: number): Khronos;
    week(): number;
    week(input: number): Khronos;
    /** @deprecated */
    weeks(): number;
    weeks(input: number): Khronos;
    isoWeek(): number;
    isoWeek(val: number): Khronos;
    /** @deprecated */
    isoWeeks(): number;
    isoWeeks(val: number): Khronos;
    weeksInYear(): number;
    isoWeeksInYear(): number;
    daysInMonth(): number;
    quarter(): number;
    quarter(val: number): Khronos;
    /** @deprecated */
    quarters(): number;
    quarters(val: number): Khronos;
    startOf(period?: MomentUnitOfTime): Khronos;
}
