"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function appendPropertyInAstObject(recorder, node, propertyName, value, indent) {
    const indentStr = _buildIndent(indent);
    if (node.properties.length > 0) {
        // Insert comma.
        const last = node.properties[node.properties.length - 1];
        recorder.insertRight(last.start.offset + last.text.replace(/\s+$/, '').length, ',');
    }
    recorder.insertLeft(node.end.offset - 1, '  '
        + `"${propertyName}": ${JSON.stringify(value, null, 2).replace(/\n/g, indentStr)}`
        + indentStr.slice(0, -2));
}
exports.appendPropertyInAstObject = appendPropertyInAstObject;
function insertPropertyInAstObjectInOrder(recorder, node, propertyName, value, indent) {
    if (node.properties.length === 0) {
        appendPropertyInAstObject(recorder, node, propertyName, value, indent);
        return;
    }
    // Find insertion info.
    let insertAfterProp = null;
    let prev = null;
    let isLastProp = false;
    const last = node.properties[node.properties.length - 1];
    for (const prop of node.properties) {
        if (prop.key.value > propertyName) {
            if (prev) {
                insertAfterProp = prev;
            }
            break;
        }
        if (prop === last) {
            isLastProp = true;
            insertAfterProp = last;
        }
        prev = prop;
    }
    if (isLastProp) {
        appendPropertyInAstObject(recorder, node, propertyName, value, indent);
        return;
    }
    const indentStr = _buildIndent(indent);
    const insertIndex = insertAfterProp === null
        ? node.start.offset + 1
        : insertAfterProp.end.offset + 1;
    recorder.insertRight(insertIndex, indentStr
        + `"${propertyName}": ${JSON.stringify(value, null, 2).replace(/\n/g, indentStr)}`
        + ',');
}
exports.insertPropertyInAstObjectInOrder = insertPropertyInAstObjectInOrder;
function appendValueInAstArray(recorder, node, value, indent = 4) {
    const indentStr = _buildIndent(indent);
    if (node.elements.length > 0) {
        // Insert comma.
        const last = node.elements[node.elements.length - 1];
        recorder.insertRight(last.start.offset + last.text.replace(/\s+$/, '').length, ',');
    }
    recorder.insertLeft(node.end.offset - 1, '  '
        + JSON.stringify(value, null, 2).replace(/\n/g, indentStr)
        + indentStr.slice(0, -2));
}
exports.appendValueInAstArray = appendValueInAstArray;
function findPropertyInAstObject(node, propertyName) {
    let maybeNode = null;
    for (const property of node.properties) {
        if (property.key.value == propertyName) {
            maybeNode = property.value;
        }
    }
    return maybeNode;
}
exports.findPropertyInAstObject = findPropertyInAstObject;
function _buildIndent(count) {
    return '\n' + new Array(count + 1).join(' ');
}
//# sourceMappingURL=data:application/json;base64,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