"use strict";
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@angular-devkit/core");
const rxjs_1 = require("rxjs");
const operators_1 = require("rxjs/operators");
const src_1 = require("../src");
/**
 * @deprecated
 */
exports.DefaultTimeout = 45000;
/**
 * @deprecated
 */
function runTargetSpec(host, targetSpec, overrides = {}, timeout = exports.DefaultTimeout, logger = new core_1.logging.NullLogger()) {
    targetSpec = Object.assign({}, targetSpec, { overrides });
    const workspaceFile = core_1.normalize('angular.json');
    const workspace = new core_1.experimental.workspace.Workspace(host.root(), host);
    // Emit when runArchitect$ completes or errors.
    // TODO: There must be a better way of doing this...
    let finalizeCB = () => { };
    const runArchitectFinalize$ = new rxjs_1.Observable(obs => {
        finalizeCB = () => obs.next();
    });
    // Load the workspace from the root of the host, then run a target.
    const builderContext = {
        logger,
        targetSpecifier: targetSpec,
    };
    const runArchitect$ = workspace.loadWorkspaceFromHost(workspaceFile).pipe(operators_1.concatMap(ws => new src_1.Architect(ws).loadArchitect()), operators_1.concatMap(arch => arch.run(arch.getBuilderConfiguration(targetSpec), builderContext)), operators_1.finalize(() => finalizeCB()));
    // Error out after the timeout if runArchitect$ hasn't finalized.
    const timeout$ = rxjs_1.timer(timeout).pipe(operators_1.takeUntil(runArchitectFinalize$), operators_1.concatMapTo(rxjs_1.throwError(`runTargetSpec timeout (${timeout}) reached.`)));
    return rxjs_1.merge(timeout$, runArchitect$);
}
exports.runTargetSpec = runTargetSpec;
//# sourceMappingURL=data:application/json;base64,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