/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.ExpressionMixin;
import lombok.ast.Identifier;
import lombok.ast.Node;
import lombok.ast.Position;

public class Select
extends AbstractNode
implements Expression {
    private List<Position> parensPositions = new ArrayList<Position>();
    private AbstractNode operand = null;
    private AbstractNode identifier = this.adopt(new Identifier());

    @Override
    public List<Position> astParensPositions() {
        return this.parensPositions;
    }

    public Expression astOperand() {
        if (!(this.operand instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.operand);
    }

    public Select astOperand(Expression operand) {
        if (operand == null) {
            throw new NullPointerException("operand is mandatory");
        }
        return this.rawOperand(operand);
    }

    public Node rawOperand() {
        return this.operand;
    }

    public Select rawOperand(Node operand) {
        if (operand == this.operand) {
            return this;
        }
        if (operand != null) {
            this.adopt((AbstractNode)operand);
        }
        if (this.operand != null) {
            this.disown(this.operand);
        }
        this.operand = (AbstractNode)operand;
        return this;
    }

    public Identifier astIdentifier() {
        if (!(this.identifier instanceof Identifier)) {
            return null;
        }
        return (Identifier)this.identifier;
    }

    public Select astIdentifier(Identifier identifier) {
        return this.rawIdentifier(identifier);
    }

    private Select rawIdentifier(Node identifier) {
        if (identifier == this.identifier) {
            return this;
        }
        if (identifier != null) {
            this.adopt((AbstractNode)identifier);
        }
        if (this.identifier != null) {
            this.disown(this.identifier);
        }
        this.identifier = (AbstractNode)identifier;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.operand != null) {
            result.add(this.operand);
        }
        if (this.identifier != null) {
            result.add(this.identifier);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.operand == original) {
            this.rawOperand(replacement);
            return true;
        }
        if (this.identifier == original) {
            if (replacement instanceof Identifier) {
                this.astIdentifier((Identifier)replacement);
                return true;
            }
            throw new AstException(this, String.format("Cannot replace node: replacement must be of type %s but is of type %s", "Identifier", replacement == null ? "null" : replacement.getClass().getName()));
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.operand == child) {
            this.disown((AbstractNode)child);
            this.operand = null;
            return true;
        }
        if (this.identifier == child) {
            this.disown((AbstractNode)child);
            this.identifier = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitSelect(this)) {
            return;
        }
        if (this.operand != null) {
            this.operand.accept(visitor);
        }
        if (this.identifier != null) {
            this.identifier.accept(visitor);
        }
        visitor.afterVisitSelect(this);
        visitor.endVisit(this);
    }

    @Override
    public Select copy() {
        Select result = new Select();
        result.parensPositions = new ArrayList<Position>(this.parensPositions);
        if (this.operand != null) {
            result.rawOperand(this.operand.copy());
        }
        if (this.identifier != null) {
            result.rawIdentifier(this.identifier.copy());
        }
        return result;
    }

    @Override
    public int getParens() {
        return ExpressionMixin.getParens(this);
    }

    @Override
    public int getIntendedParens() {
        return ExpressionMixin.getIntendedParens(this);
    }

    @Override
    public boolean needsParentheses() {
        return ExpressionMixin.needsParentheses(this);
    }

    @Override
    public boolean isStatementExpression() {
        return ExpressionMixin.isStatementExpression(this);
    }
}

