/*
 * Decompiled with CFR 0.152.
 */
package javax.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public interface StandardJavaFileManager
extends JavaFileManager {
    @Override
    public boolean isSameFile(FileObject var1, FileObject var2);

    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> var1);

    default public Iterable<? extends JavaFileObject> getJavaFileObjectsFromPaths(Iterable<? extends Path> paths) {
        return this.getJavaFileObjectsFromFiles(StandardJavaFileManager.asFiles(paths));
    }

    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... var1);

    default public Iterable<? extends JavaFileObject> getJavaFileObjects(Path ... paths) {
        return this.getJavaFileObjectsFromPaths(Arrays.asList(paths));
    }

    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> var1);

    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... var1);

    public void setLocation(JavaFileManager.Location var1, Iterable<? extends File> var2) throws IOException;

    default public void setLocationFromPaths(JavaFileManager.Location location, Collection<? extends Path> paths) throws IOException {
        this.setLocation(location, StandardJavaFileManager.asFiles(paths));
    }

    default public void setLocationForModule(JavaFileManager.Location location, String moduleName, Collection<? extends Path> paths) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Iterable<? extends File> getLocation(JavaFileManager.Location var1);

    default public Iterable<? extends Path> getLocationAsPaths(JavaFileManager.Location location) {
        return StandardJavaFileManager.asPaths(this.getLocation(location));
    }

    default public Path asPath(FileObject file) {
        throw new UnsupportedOperationException();
    }

    default public void setPathFactory(PathFactory f) {
    }

    private static Iterable<Path> asPaths(final Iterable<? extends File> files) {
        return () -> new Iterator<Path>(){
            Iterator iter;
            {
                this.iter = files.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Path next() {
                return ((File)this.iter.next()).toPath();
            }
        };
    }

    private static Iterable<File> asFiles(final Iterable<? extends Path> paths) {
        return () -> new Iterator<File>(){
            Iterator iter;
            {
                this.iter = paths.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public File next() {
                Path p = (Path)this.iter.next();
                try {
                    return p.toFile();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalArgumentException(p.toString(), e);
                }
            }
        };
    }

    public static interface PathFactory {
        public Path getPath(String var1, String ... var2);
    }
}

