'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});
Object.defineProperty(exports, 'bind', {
  enumerable: true,
  get: function get() {
    return _bind.default;
  }
});
exports.default = void 0;

var _bind = _interopRequireDefault(require('./bind'));

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : {default: obj};
}

/**
 * Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 */
const install = (g, ...args) => {
  const test = (title, test, timeout) =>
    (0, _bind.default)(g.test)(...args)(title, test, timeout);

  test.skip = (0, _bind.default)(g.test.skip)(...args);
  test.only = (0, _bind.default)(g.test.only)(...args);

  const it = (title, test, timeout) =>
    (0, _bind.default)(g.it)(...args)(title, test, timeout);

  it.skip = (0, _bind.default)(g.it.skip)(...args);
  it.only = (0, _bind.default)(g.it.only)(...args);
  const xit = (0, _bind.default)(g.xit)(...args);
  const fit = (0, _bind.default)(g.fit)(...args);
  const xtest = (0, _bind.default)(g.xtest)(...args);

  const describe = (title, suite, timeout) =>
    (0, _bind.default)(g.describe, false)(...args)(title, suite, timeout);

  describe.skip = (0, _bind.default)(g.describe.skip, false)(...args);
  describe.only = (0, _bind.default)(g.describe.only, false)(...args);
  const fdescribe = (0, _bind.default)(g.fdescribe, false)(...args);
  const xdescribe = (0, _bind.default)(g.xdescribe, false)(...args);
  return {
    describe,
    fdescribe,
    fit,
    it,
    test,
    xdescribe,
    xit,
    xtest
  };
};

const each = (...args) => install(global, ...args);

each.withGlobal = g => (...args) => install(g, ...args);

var _default = each;
exports.default = _default;
