'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});
exports.default = void 0;

function _realpathNative() {
  const data = require('realpath-native');

  _realpathNative = function _realpathNative() {
    return data;
  };

  return data;
}

/**
 * Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 */
const path = require('path');

const os = require('os');

const getCacheDirectory = () => {
  const _process = process,
    getuid = _process.getuid;
  const tmpdir = path.join((0, _realpathNative().sync)(os.tmpdir()), 'jest');

  if (getuid == null) {
    return tmpdir;
  } else {
    // On some platforms tmpdir() is `/tmp`, causing conflicts between different
    // users and permission issues. Adding an additional subdivision by UID can
    // help.
    return `${tmpdir}_${getuid.call(process).toString(36)}`;
  }
};

var _default = getCacheDirectory;
exports.default = _default;
