/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.Icon;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ChartItemChange;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemChange;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYChartContext;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.snaptracer.impl.IdeSnapshot;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineXYPainter;

class TimelineIconPainter
extends TimelineXYPainter {
    private static final Icon ICON = Icons.getIcon((String)"TracerIcons.GenericAction");
    private static final int ICON_EXTENT = 8;
    protected final Color color;
    protected final IdeSnapshot snapshot;

    TimelineIconPainter(Color color, IdeSnapshot ideSnapshot) {
        super(8, true, 1.0);
        this.color = color;
        this.snapshot = ideSnapshot;
    }

    @Override
    protected void paint(XYItem xYItem, List<ItemSelection> list, List<ItemSelection> list2, Graphics2D graphics2D, Rectangle rectangle, SynchronousXYChartContext synchronousXYChartContext) {
        if (synchronousXYChartContext.getViewWidth() == 0L) {
            return;
        }
        int[][] nArray = synchronousXYChartContext.getVisibleBounds(rectangle);
        int n = nArray[0][0];
        int n2 = n;
        if (n2 == -1) {
            n2 = nArray[0][1];
        }
        if (n2 == -1) {
            return;
        }
        int n3 = rectangle.x - 8;
        while (synchronousXYChartContext.getViewX((double)xYItem.getXValue(n2)) > (double)n3 && n2 > 0) {
            --n2;
        }
        int n4 = xYItem.getValuesCount() - 1;
        int n5 = nArray[1][0];
        int n6 = n5;
        if (n6 == -1) {
            n6 = nArray[1][1];
        }
        if (n6 == -1) {
            n6 = n4;
        }
        int n7 = rectangle.x + rectangle.width + 8;
        while (synchronousXYChartContext.getViewX((double)xYItem.getXValue(n6)) < (double)n7 && n6 < n4) {
            ++n6;
        }
        graphics2D.setColor(this.color);
        for (int i = n2; i <= n6; ++i) {
            long l = xYItem.getYValue(i);
            if (l == 0L) continue;
            long l2 = xYItem.getXValue(i);
            int n8 = Utils.checkedInt((double)synchronousXYChartContext.getViewX((double)l2));
            Icon icon = this.snapshot.getLogInfoForValue(l).getIcon();
            if (icon == null) {
                icon = ICON;
            }
            int n9 = icon.getIconWidth();
            int n10 = icon.getIconHeight();
            icon.paintIcon(null, graphics2D, n8 - n9 / 2, (synchronousXYChartContext.getViewportHeight() - n10) / 2);
        }
    }

    @Override
    protected Color getDefiningColor() {
        return this.color;
    }

    @Override
    public LongRect getItemBounds(ChartItem chartItem) {
        XYItem xYItem = (XYItem)chartItem;
        return this.getDataBounds(xYItem.getBounds());
    }

    @Override
    public LongRect getItemBounds(ChartItem chartItem, ChartContext chartContext) {
        XYItem xYItem = (XYItem)chartItem;
        return this.getViewBounds(xYItem.getBounds(), chartContext);
    }

    @Override
    public boolean isBoundsChange(ChartItemChange chartItemChange) {
        XYItemChange xYItemChange = (XYItemChange)chartItemChange;
        return !LongRect.equals((LongRect)xYItemChange.getOldValuesBounds(), (LongRect)xYItemChange.getNewValuesBounds());
    }

    @Override
    public boolean isAppearanceChange(ChartItemChange chartItemChange) {
        XYItemChange xYItemChange = (XYItemChange)chartItemChange;
        LongRect longRect = xYItemChange.getDirtyValuesBounds();
        return longRect.width != 0L && longRect.height != 0L;
    }

    @Override
    public LongRect getDirtyBounds(ChartItemChange chartItemChange, ChartContext chartContext) {
        XYItemChange xYItemChange = (XYItemChange)chartItemChange;
        return this.getViewBounds(xYItemChange.getDirtyValuesBounds(), chartContext);
    }

    @Override
    public boolean supportsHovering(ChartItem chartItem) {
        return true;
    }

    @Override
    public boolean supportsSelecting(ChartItem chartItem) {
        return true;
    }

    @Override
    public LongRect getSelectionBounds(ItemSelection itemSelection, ChartContext chartContext) {
        XYItemSelection xYItemSelection = (XYItemSelection)itemSelection;
        XYItem xYItem = xYItemSelection.getItem();
        int n = xYItemSelection.getValueIndex();
        if (n == -1 || n >= xYItem.getValuesCount()) {
            return new LongRect(0L, 0L, (long)chartContext.getViewportWidth(), (long)chartContext.getViewportHeight());
        }
        return this.getViewBounds(xYItem, n, chartContext);
    }

    @Override
    public XYItemSelection getClosestSelection(ChartItem chartItem, int n, int n2, ChartContext chartContext) {
        int n3;
        SynchronousXYChartContext synchronousXYChartContext = (SynchronousXYChartContext)chartContext;
        SynchronousXYItem synchronousXYItem = (SynchronousXYItem)chartItem;
        int n4 = synchronousXYChartContext.getNearestTimestampIndex(n, n2);
        if (n4 == -1) {
            return new XYItemSelection.Default((XYItem)synchronousXYItem, n4, Integer.MAX_VALUE);
        }
        int n5 = n - 8;
        int n6 = n + 8;
        int n7 = Utils.checkedInt((double)synchronousXYChartContext.getViewX((double)synchronousXYItem.getXValue(n4)));
        if (n7 > n6 || n7 < n5) {
            return new XYItemSelection.Default((XYItem)synchronousXYItem, n4, Integer.MAX_VALUE);
        }
        int n8 = -1;
        for (n3 = n4; n3 < synchronousXYItem.getValuesCount() && Utils.checkedInt((double)synchronousXYChartContext.getViewX((double)synchronousXYItem.getXValue(n3))) <= n6; ++n3) {
            if (synchronousXYItem.getYValue(n3) == 0L) continue;
            n8 = n3;
        }
        if (n8 != -1) {
            return new XYItemSelection.Default((XYItem)synchronousXYItem, n8, Integer.MAX_VALUE);
        }
        for (n3 = n4 - 1; n3 >= 0 && Utils.checkedInt((double)synchronousXYChartContext.getViewX((double)synchronousXYItem.getXValue(n3))) >= n5; --n3) {
            if (synchronousXYItem.getYValue(n3) == 0L) continue;
            n8 = n3;
        }
        if (n8 != -1) {
            return new XYItemSelection.Default((XYItem)synchronousXYItem, n8, Integer.MAX_VALUE);
        }
        return new XYItemSelection.Default((XYItem)synchronousXYItem, n4, Integer.MAX_VALUE);
    }

    @Override
    public double getItemView(double d, XYItem xYItem, ChartContext chartContext) {
        return -1.0;
    }

    @Override
    public double getItemValue(double d, XYItem xYItem, ChartContext chartContext) {
        return -1.0;
    }

    @Override
    public double getItemValueScale(XYItem xYItem, ChartContext chartContext) {
        return -1.0;
    }

    private LongRect getDataBounds(LongRect longRect) {
        LongRect longRect2 = new LongRect(longRect);
        longRect2.y = 0L;
        longRect2.height = 1000L;
        return longRect2;
    }

    private LongRect getViewBounds(LongRect longRect, ChartContext chartContext) {
        boolean bl = longRect.height != 0L;
        LongRect longRect2 = chartContext.getViewRect(longRect);
        if (bl) {
            longRect2.y = Utils.checkedInt((double)chartContext.getViewY((double)(chartContext.getDataHeight() / 2L)));
            longRect2.height = 0L;
            LongRect.addBorder((LongRect)longRect2, (long)8L);
        } else {
            LongRect.clear((LongRect)longRect2);
        }
        return longRect2;
    }

    private LongRect getViewBounds(XYItem xYItem, int n, ChartContext chartContext) {
        long l = xYItem.getXValue(n);
        LongRect longRect = new LongRect((long)Utils.checkedInt((double)chartContext.getViewX((double)l)), (long)Utils.checkedInt((double)chartContext.getViewY((double)(chartContext.getDataHeight() / 2L))), 0L, 0L);
        if (xYItem.getYValue(n) != 0L) {
            LongRect.addBorder((LongRect)longRect, (long)8L);
        }
        return longRect;
    }
}

