/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.security.AccessController;
import sun.awt.SunToolkit;
import sun.awt.X11.XErrorEvent;
import sun.awt.X11.XErrorHandler;
import sun.awt.X11.XlibWrapper;
import sun.security.action.GetBooleanAction;
import sun.util.logging.PlatformLogger;

public final class XErrorHandlerUtil {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.XErrorHandlerUtil");
    private static long display;
    private static long saved_error_handler;
    static volatile XErrorEvent saved_error;
    private static XErrorHandler current_error_handler;
    private static boolean noisyAwtHandler;
    private static boolean initPassed;

    private XErrorHandlerUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init(long display) {
        SunToolkit.awtLock();
        try {
            if (!initPassed) {
                XErrorHandlerUtil.display = display;
                saved_error_handler = XlibWrapper.SetToolkitErrorHandler();
                initPassed = true;
            }
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    public static void WITH_XERROR_HANDLER(XErrorHandler handler) {
        XErrorHandlerUtil.XSync();
        saved_error = null;
        current_error_handler = handler;
    }

    public static void RESTORE_XERROR_HANDLER() {
        XErrorHandlerUtil.XSync();
        current_error_handler = null;
    }

    public static int SAVED_XERROR_HANDLER(long display, XErrorEvent error) {
        if (saved_error_handler != 0L) {
            // empty if block
        }
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("Unhandled XErrorEvent: id=" + error.get_resourceid() + ", " + "serial=" + error.get_serial() + ", " + "ec=" + error.get_error_code() + ", " + "rc=" + error.get_request_code() + ", " + "mc=" + error.get_minor_code());
        }
        return 0;
    }

    private static int globalErrorHandler(long display, long event_ptr) {
        XErrorEvent event;
        if (noisyAwtHandler) {
            XlibWrapper.PrintXErrorEvent(display, event_ptr);
        }
        saved_error = event = new XErrorEvent(event_ptr);
        try {
            if (current_error_handler != null) {
                return current_error_handler.handleError(display, event);
            }
            return XErrorHandlerUtil.SAVED_XERROR_HANDLER(display, event);
        }
        catch (Throwable z) {
            log.fine("Error in GlobalErrorHandler", z);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void XSync() {
        SunToolkit.awtLock();
        try {
            XlibWrapper.XSync(display, 0);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    static {
        noisyAwtHandler = AccessController.doPrivileged(new GetBooleanAction("sun.awt.noisyerrorhandler"));
    }
}

