/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.x86;

import sun.jvm.hotspot.asm.Address;
import sun.jvm.hotspot.asm.MemoryInstruction;
import sun.jvm.hotspot.asm.SymbolFinder;
import sun.jvm.hotspot.asm.x86.X86Instruction;
import sun.jvm.hotspot.asm.x86.X86Register;

public abstract class X86MemoryInstruction
extends X86Instruction
implements MemoryInstruction {
    protected final Address address;
    protected final X86Register register;
    protected final int dataType;
    protected final String description;

    public X86MemoryInstruction(String name, Address address, X86Register register, int dataType, int size, int prefixes) {
        super(name, size, prefixes);
        this.address = address;
        this.register = register;
        this.dataType = dataType;
        this.description = this.initDescription();
    }

    protected String initDescription() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getPrefixString());
        buf.append(this.getName());
        buf.append(spaces);
        buf.append(this.register.toString());
        buf.append(comma);
        buf.append(this.address.toString());
        return buf.toString();
    }

    @Override
    public String asString(long currentPc, SymbolFinder symFinder) {
        return this.description;
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    @Override
    public boolean isConditional() {
        return false;
    }
}

