# -*- coding: utf-8 -*-
info = {
    "name": "fr",
    "date_order": "DMY",
    "january": [
        "janvier",
        "janv",
        "jan"
    ],
    "february": [
        "février",
        "févr",
        "fév"
    ],
    "march": [
        "mars"
    ],
    "april": [
        "avril",
        "avr"
    ],
    "may": [
        "mai"
    ],
    "june": [
        "juin",
        "jun"
    ],
    "july": [
        "juillet",
        "juil",
        "jul"
    ],
    "august": [
        "août",
        "aoû"
    ],
    "september": [
        "septembre",
        "sept",
        "sep"
    ],
    "october": [
        "octobre",
        "oct"
    ],
    "november": [
        "novembre",
        "nov"
    ],
    "december": [
        "décembre",
        "déc"
    ],
    "monday": [
        "lundi",
        "lun",
        "lu"
    ],
    "tuesday": [
        "mardi",
        "mar",
        "ma"
    ],
    "wednesday": [
        "mercredi",
        "mer",
        "me"
    ],
    "thursday": [
        "jeudi",
        "jeu",
        "je"
    ],
    "friday": [
        "vendredi",
        "ven",
        "ve"
    ],
    "saturday": [
        "samedi",
        "sam",
        "sa"
    ],
    "sunday": [
        "dimanche",
        "dim",
        "di"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "année",
        "an",
        "a",
        "années"
    ],
    "month": [
        "mois",
        "m"
    ],
    "week": [
        "semaine",
        "sem",
        "semaines"
    ],
    "day": [
        "jour",
        "j",
        "jours"
    ],
    "hour": [
        "heure",
        "h",
        "heures"
    ],
    "minute": [
        "minute",
        "min",
        "minutes"
    ],
    "second": [
        "seconde",
        "s",
        "secondes"
    ],
    "relative-type": {
        "1 year ago": [
            "l'année dernière"
        ],
        "0 year ago": [
            "cette année"
        ],
        "in 1 year": [
            "l'année prochaine"
        ],
        "1 month ago": [
            "le mois dernier"
        ],
        "0 month ago": [
            "ce mois-ci"
        ],
        "in 1 month": [
            "le mois prochain"
        ],
        "1 week ago": [
            "la semaine dernière"
        ],
        "0 week ago": [
            "cette semaine"
        ],
        "in 1 week": [
            "la semaine prochaine"
        ],
        "1 day ago": [
            "hier"
        ],
        "0 day ago": [
            "aujourd'hui"
        ],
        "in 1 day": [
            "demain"
        ],
        "0 hour ago": [
            "cette heure-ci"
        ],
        "0 minute ago": [
            "cette minute-ci"
        ],
        "0 second ago": [
            "maintenant"
        ],
        "2 day ago": [
            "avant-hier"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "dans (\\d+) an",
            "dans (\\d+) ans",
            "dans (\\d+) a"
        ],
        "\\1 year ago": [
            "il y a (\\d+) an",
            "il y a (\\d+) ans",
            "il y a (\\d+) a"
        ],
        "in \\1 month": [
            "dans (\\d+) mois",
            "dans (\\d+) m"
        ],
        "\\1 month ago": [
            "il y a (\\d+) mois",
            "il y a (\\d+) m"
        ],
        "in \\1 week": [
            "dans (\\d+) semaine",
            "dans (\\d+) semaines",
            "dans (\\d+) sem"
        ],
        "\\1 week ago": [
            "il y a (\\d+) semaine",
            "il y a (\\d+) semaines",
            "il y a (\\d+) sem"
        ],
        "in \\1 day": [
            "dans (\\d+) jour",
            "dans (\\d+) jours",
            "dans (\\d+) j"
        ],
        "\\1 day ago": [
            "il y a (\\d+) jour",
            "il y a (\\d+) jours",
            "il y a (\\d+) j"
        ],
        "in \\1 hour": [
            "dans (\\d+) heure",
            "dans (\\d+) heures",
            "dans (\\d+) h",
            "dans (\\d+)h"
        ],
        "\\1 hour ago": [
            "il y a (\\d+) heure",
            "il y a (\\d+) heures",
            "il y a (\\d+) h",
            "il y a (\\d+)h"
        ],
        "in \\1 minute": [
            "dans (\\d+) minute",
            "dans (\\d+) minutes",
            "dans (\\d+) min"
        ],
        "\\1 minute ago": [
            "il y a (\\d+) minute",
            "il y a (\\d+) minutes",
            "il y a (\\d+) min",
            "il y a (\\d+)min"
        ],
        "in \\1 second": [
            "dans (\\d+) seconde",
            "dans (\\d+) secondes",
            "dans (\\d+) s"
        ],
        "\\1 second ago": [
            "il y a (\\d+) seconde",
            "il y a (\\d+) secondes",
            "il y a (\\d+) s"
        ]
    },
    "locale_specific": {
        "fr-CI": {
            "name": "fr-CI"
        },
        "fr-WF": {
            "name": "fr-WF"
        },
        "fr-BL": {
            "name": "fr-BL"
        },
        "fr-PF": {
            "name": "fr-PF"
        },
        "fr-NC": {
            "name": "fr-NC"
        },
        "fr-MU": {
            "name": "fr-MU"
        },
        "fr-MQ": {
            "name": "fr-MQ"
        },
        "fr-CH": {
            "name": "fr-CH"
        },
        "fr-NE": {
            "name": "fr-NE"
        },
        "fr-BF": {
            "name": "fr-BF"
        },
        "fr-CG": {
            "name": "fr-CG"
        },
        "fr-MA": {
            "name": "fr-MA",
            "january": [
                "jan"
            ],
            "february": [
                "fév"
            ],
            "march": [
                "mar"
            ],
            "june": [
                "jui"
            ]
        },
        "fr-RE": {
            "name": "fr-RE"
        },
        "fr-KM": {
            "name": "fr-KM"
        },
        "fr-BI": {
            "name": "fr-BI"
        },
        "fr-BE": {
            "name": "fr-BE"
        },
        "fr-CA": {
            "name": "fr-CA",
            "date_order": "YMD",
            "july": [
                "juill"
            ]
        },
        "fr-SY": {
            "name": "fr-SY"
        },
        "fr-TD": {
            "name": "fr-TD"
        },
        "fr-CM": {
            "name": "fr-CM",
            "am": [
                "matin",
                "mat"
            ],
            "pm": [
                "soir"
            ]
        },
        "fr-DZ": {
            "name": "fr-DZ"
        },
        "fr-MF": {
            "name": "fr-MF"
        },
        "fr-RW": {
            "name": "fr-RW"
        },
        "fr-MR": {
            "name": "fr-MR"
        },
        "fr-GN": {
            "name": "fr-GN"
        },
        "fr-ML": {
            "name": "fr-ML"
        },
        "fr-VU": {
            "name": "fr-VU"
        },
        "fr-SC": {
            "name": "fr-SC"
        },
        "fr-MG": {
            "name": "fr-MG"
        },
        "fr-SN": {
            "name": "fr-SN"
        },
        "fr-LU": {
            "name": "fr-LU"
        },
        "fr-HT": {
            "name": "fr-HT",
            "day": [
                "jr"
            ],
            "hour": [
                "hr"
            ],
            "second": [
                "sec"
            ]
        },
        "fr-BJ": {
            "name": "fr-BJ"
        },
        "fr-DJ": {
            "name": "fr-DJ"
        },
        "fr-GA": {
            "name": "fr-GA"
        },
        "fr-GQ": {
            "name": "fr-GQ"
        },
        "fr-CF": {
            "name": "fr-CF"
        },
        "fr-TG": {
            "name": "fr-TG"
        },
        "fr-GF": {
            "name": "fr-GF"
        },
        "fr-PM": {
            "name": "fr-PM"
        },
        "fr-YT": {
            "name": "fr-YT"
        },
        "fr-MC": {
            "name": "fr-MC"
        },
        "fr-GP": {
            "name": "fr-GP"
        },
        "fr-TN": {
            "name": "fr-TN"
        },
        "fr-CD": {
            "name": "fr-CD"
        }
    },
    "skip": [
        "le",
        "environ",
        "et",
        "à",
        "er",
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "il ya",
        "il y a"
    ],
    "in": [
        "dans",
        "en"
    ],
    "simplifications": [
        {
            "d'une": "1"
        },
        {
            "une": "1"
        },
        {
            "un": "1"
        },
        {
            "(\\d+)\\s+h\\s+(\\d+)\\s+min": "\\1h\\2m"
        },
        {
            "(\\d+)h(\\d+)m?": "\\1:\\2"
        },
        {
            "moins\\s(?:de\\s)?(\\d+)\\s?(minute|seconde|heure)": "\\1 \\2"
        },
        {
            "moins\\s(?:de\\s)?(\\d+)\\s?s": "\\1 seconde"
        },
        {
            "moins\\s(?:de\\s)?(\\d+)\\s?m": "\\1 minute"
        },
        {
            "moins\\s(?:de\\s)?(\\d+)\\s?h": "\\1 heure"
        }
    ]
}