/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.arrangement;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jetbrains.plugins.terminal.TerminalView;
import org.jetbrains.plugins.terminal.arrangement.TerminalArrangementState;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;

@State(name="TerminalArrangementManager", storages={@Storage(value="$CACHE_FILE$")})
public class TerminalArrangementManager
implements PersistentStateComponent<TerminalArrangementState> {
    private static final Logger LOG = Logger.getInstance(TerminalArrangementManager.class);
    private final TerminalWorkingDirectoryManager myWorkingDirectoryManager;
    private ToolWindow myTerminalToolWindow;
    private TerminalArrangementState myState;
    private final Set<String> myTrackingCommandHistoryFileNames = ContainerUtil.newConcurrentSet();

    public TerminalArrangementManager() {
        this.myWorkingDirectoryManager = new TerminalWorkingDirectoryManager();
    }

    public void setToolWindow(@NotNull ToolWindow terminalToolWindow) {
        if (terminalToolWindow == null) {
            TerminalArrangementManager.$$$reportNull$$$0(0);
        }
        this.myTerminalToolWindow = terminalToolWindow;
        this.myWorkingDirectoryManager.init(terminalToolWindow);
    }

    @Nullable
    public TerminalArrangementState getState() {
        if (!TerminalArrangementManager.isAvailable() || this.myTerminalToolWindow == null) {
            return null;
        }
        return this.calcArrangementState(this.myTerminalToolWindow);
    }

    public void loadState(@NotNull TerminalArrangementState state) {
        if (state == null) {
            TerminalArrangementManager.$$$reportNull$$$0(1);
        }
        if (TerminalArrangementManager.isAvailable()) {
            this.myState = state;
            this.myTrackingCommandHistoryFileNames.addAll(TerminalArrangementManager.getCommandHistoryFileNames(state));
        }
    }

    @NotNull
    private static List<String> getCommandHistoryFileNames(@NotNull TerminalArrangementState state) {
        if (state == null) {
            TerminalArrangementManager.$$$reportNull$$$0(2);
        }
        List list = ContainerUtil.mapNotNull(state.myTabStates, tabState -> tabState.myCommandHistoryFileName);
        if (list == null) {
            TerminalArrangementManager.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public TerminalArrangementState getArrangementState() {
        return this.myState;
    }

    @NotNull
    private TerminalArrangementState calcArrangementState(@NotNull ToolWindow terminalToolWindow) {
        if (terminalToolWindow == null) {
            TerminalArrangementManager.$$$reportNull$$$0(4);
        }
        TerminalArrangementState arrangementState = new TerminalArrangementState();
        ContentManager contentManager = terminalToolWindow.getContentManager();
        for (Content content : contentManager.getContents()) {
            JBTerminalWidget terminalWidget = TerminalView.getWidgetByContent(content);
            if (terminalWidget == null) continue;
            TerminalTabState tabState = new TerminalTabState();
            tabState.myTabName = content.getTabName();
            tabState.myWorkingDirectory = this.myWorkingDirectoryManager.getWorkingDirectory(content);
            String historyFilePath = terminalWidget.getCommandHistoryFilePath();
            tabState.myCommandHistoryFileName = historyFilePath != null ? PathUtil.getFileName((String)historyFilePath) : null;
            arrangementState.myTabStates.add(tabState);
        }
        Content selectedContent = contentManager.getSelectedContent();
        arrangementState.mySelectedTabIndex = selectedContent == null ? -1 : contentManager.getIndexOfContent(selectedContent);
        this.deleteUnusedCommandHistoryFiles(TerminalArrangementManager.getCommandHistoryFileNames(arrangementState));
        TerminalArrangementState terminalArrangementState = arrangementState;
        if (terminalArrangementState == null) {
            TerminalArrangementManager.$$$reportNull$$$0(5);
        }
        return terminalArrangementState;
    }

    public void register(@NotNull JBTerminalWidget terminalWidget, @Nullable TerminalTabState tabState) {
        File historyFile;
        String historyFileName;
        if (terminalWidget == null) {
            TerminalArrangementManager.$$$reportNull$$$0(6);
        }
        if (!TerminalArrangementManager.isAvailable()) {
            return;
        }
        File historyDir = TerminalArrangementManager.getCommandHistoryDirectory();
        if (!FileUtil.createDirectory((File)historyDir)) {
            LOG.warn("No such directory " + historyDir.getAbsolutePath());
            return;
        }
        String string = historyFileName = tabState != null ? tabState.myCommandHistoryFileName : null;
        if (historyFileName == null) {
            try {
                historyFile = FileUtil.createTempFile((File)historyDir, (String)"history-", null, (boolean)true, (boolean)false);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return;
            }
        }
        historyFile = new File(historyDir, historyFileName);
        if (!historyFile.isFile()) {
            try {
                historyFile.createNewFile();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        this.myTrackingCommandHistoryFileNames.add(historyFile.getName());
        terminalWidget.setCommandHistoryFilePath(historyFile.getAbsolutePath());
    }

    @NotNull
    private static File getCommandHistoryDirectory() {
        File file = new File(PathManager.getConfigPath() + File.separatorChar + "terminal" + File.separatorChar + "history");
        if (file == null) {
            TerminalArrangementManager.$$$reportNull$$$0(7);
        }
        return file;
    }

    private void deleteUnusedCommandHistoryFiles(@NotNull List<String> keepCommandHistoryFileNames) {
        if (keepCommandHistoryFileNames == null) {
            TerminalArrangementManager.$$$reportNull$$$0(8);
        }
        this.myTrackingCommandHistoryFileNames.removeAll(keepCommandHistoryFileNames);
        File historyDir = null;
        for (String fileName : this.myTrackingCommandHistoryFileNames) {
            File file;
            if (historyDir == null) {
                historyDir = TerminalArrangementManager.getCommandHistoryDirectory();
            }
            if (!(file = new File(historyDir, fileName)).exists() || FileUtil.delete((File)file)) continue;
            LOG.warn("Cannot delete " + file.getAbsolutePath());
        }
        this.myTrackingCommandHistoryFileNames.clear();
    }

    @NotNull
    public static TerminalArrangementManager getInstance(@NotNull Project project) {
        if (project == null) {
            TerminalArrangementManager.$$$reportNull$$$0(9);
        }
        TerminalArrangementManager terminalArrangementManager = (TerminalArrangementManager)ServiceManager.getService((Project)project, TerminalArrangementManager.class);
        if (terminalArrangementManager == null) {
            TerminalArrangementManager.$$$reportNull$$$0(10);
        }
        return terminalArrangementManager;
    }

    static boolean isAvailable() {
        return Registry.is((String)"terminal.persistent.tabs");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalToolWindow";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/arrangement/TerminalArrangementManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalWidget";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keepCommandHistoryFileNames";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/arrangement/TerminalArrangementManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandHistoryFileNames";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calcArrangementState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandHistoryDirectory";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setToolWindow";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCommandHistoryFileNames";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcArrangementState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deleteUnusedCommandHistoryFiles";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

