/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json;

import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonParserDefinition;
import com.intellij.json.editor.JsonTypedHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonQuoteHandler
extends SimpleTokenSetQuoteHandler
implements MultiCharQuoteHandler {
    public JsonQuoteHandler() {
        super(JsonParserDefinition.STRING_LITERALS);
    }

    @Nullable
    public CharSequence getClosingQuote(@NotNull HighlighterIterator iterator, int offset) {
        int index;
        IElementType tokenType;
        if (iterator == null) {
            JsonQuoteHandler.$$$reportNull$$$0(0);
        }
        if ((tokenType = iterator.getTokenType()) == TokenType.WHITE_SPACE && (index = iterator.getStart() - 1) >= 0) {
            return String.valueOf(iterator.getDocument().getCharsSequence().charAt(index));
        }
        return tokenType == JsonElementTypes.SINGLE_QUOTED_STRING ? "'" : "\"";
    }

    public void insertClosingQuote(@NotNull Editor editor, int offset, PsiFile file, @NotNull CharSequence closingQuote) {
        if (editor == null) {
            JsonQuoteHandler.$$$reportNull$$$0(1);
        }
        if (closingQuote == null) {
            JsonQuoteHandler.$$$reportNull$$$0(2);
        }
        editor.getDocument().insertString(offset, closingQuote);
        JsonTypedHandler.processPairedBracesComma(closingQuote.charAt(0), editor, file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closingQuote";
                break;
            }
        }
        objectArray2[1] = "com/intellij/json/JsonQuoteHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getClosingQuote";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "insertClosingQuote";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

