/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.log;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.impl.VcsChangesLazilyParsedDetails;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.log.HgHistoryUtil;
import org.zmlx.hg4idea.provider.HgChangeProvider;

class HgChangesParser
implements VcsChangesLazilyParsedDetails.ChangesParser {
    @NotNull
    private final HgRevisionNumber myRevisionNumber;

    HgChangesParser(@NotNull HgRevisionNumber revisionNumber) {
        if (revisionNumber == null) {
            HgChangesParser.$$$reportNull$$$0(0);
        }
        this.myRevisionNumber = revisionNumber;
    }

    public List<Change> parseStatusInfo(@NotNull Project project, @NotNull VcsShortCommitDetails commit, @NotNull List<VcsFileStatusInfo> changes, int parentIndex) {
        if (project == null) {
            HgChangesParser.$$$reportNull$$$0(1);
        }
        if (commit == null) {
            HgChangesParser.$$$reportNull$$$0(2);
        }
        if (changes == null) {
            HgChangesParser.$$$reportNull$$$0(3);
        }
        ArrayList<Change> result = new ArrayList<Change>();
        for (VcsFileStatusInfo info : changes) {
            String filePath = info.getFirstPath();
            HgRevisionNumber parentRevision = this.myRevisionNumber.getParents().isEmpty() ? null : this.myRevisionNumber.getParents().get(parentIndex);
            switch (info.getType()) {
                case MODIFICATION: {
                    result.add(HgHistoryUtil.createChange(project, commit.getRoot(), filePath, parentRevision, filePath, this.myRevisionNumber, FileStatus.MODIFIED));
                    break;
                }
                case NEW: {
                    result.add(HgHistoryUtil.createChange(project, commit.getRoot(), null, null, filePath, this.myRevisionNumber, FileStatus.ADDED));
                    break;
                }
                case DELETED: {
                    result.add(HgHistoryUtil.createChange(project, commit.getRoot(), filePath, parentRevision, null, this.myRevisionNumber, FileStatus.DELETED));
                    break;
                }
                case MOVED: {
                    result.add(HgHistoryUtil.createChange(project, commit.getRoot(), filePath, parentRevision, info.getSecondPath(), this.myRevisionNumber, HgChangeProvider.RENAMED));
                }
            }
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionNumber";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
        }
        objectArray2[1] = "org/zmlx/hg4idea/log/HgChangesParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "parseStatusInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

