/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import git4idea.GitUtil;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitUpdateConfigurable;
import git4idea.update.GitUpdateInfoAsLog;
import git4idea.update.GitUpdateProcess;
import git4idea.update.GitUpdateSession;
import git4idea.update.HashRange;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUpdateEnvironment
implements UpdateEnvironment {
    private final Project myProject;
    private final GitVcsSettings mySettings;

    public GitUpdateEnvironment(@NotNull Project project, @NotNull GitVcsSettings settings) {
        if (project == null) {
            GitUpdateEnvironment.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            GitUpdateEnvironment.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.mySettings = settings;
    }

    public void fillGroups(UpdatedFiles updatedFiles) {
    }

    @NotNull
    public UpdateSession updateDirectories(@NotNull FilePath[] filePaths, UpdatedFiles updatedFiles, ProgressIndicator progressIndicator, @NotNull Ref<SequentialUpdatesContext> sequentialUpdatesContextRef) throws ProcessCanceledException {
        if (filePaths == null) {
            GitUpdateEnvironment.$$$reportNull$$$0(2);
        }
        if (sequentialUpdatesContextRef == null) {
            GitUpdateEnvironment.$$$reportNull$$$0(3);
        }
        Set<VirtualFile> roots = GitUtil.getRootsForFilePathsIfAny(this.myProject, Arrays.asList(filePaths));
        GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(this.myProject);
        GitUpdateProcess gitUpdateProcess = new GitUpdateProcess(this.myProject, progressIndicator, GitUtil.getRepositoriesFromRoots(repositoryManager, roots), updatedFiles, true, true);
        boolean result2 = gitUpdateProcess.update(this.mySettings.getUpdateMethod()).isSuccess();
        Map<GitRepository, HashRange> updatedRanges = gitUpdateProcess.getUpdatedRanges();
        GitUpdateInfoAsLog.NotificationData notificationData = updatedRanges != null ? new GitUpdateInfoAsLog(this.myProject, updatedRanges).calculateDataAndCreateLogTab() : null;
        GitUpdateSession gitUpdateSession = new GitUpdateSession(this.myProject, notificationData, result2, gitUpdateProcess.getSkippedRoots());
        if (gitUpdateSession == null) {
            GitUpdateEnvironment.$$$reportNull$$$0(4);
        }
        return gitUpdateSession;
    }

    public boolean validateOptions(Collection<FilePath> filePaths) {
        for (FilePath p : filePaths) {
            if (GitUtil.isUnderGit(p)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public Configurable createConfigurable(Collection<FilePath> files) {
        return new GitUpdateConfigurable(this.mySettings);
    }

    public boolean hasCustomNotification() {
        boolean keepLogUpToDate = PostponableLogRefresher.keepUpToDate();
        return Registry.is((String)"git.update.project.info.as.log") && keepLogUpToDate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequentialUpdatesContextRef";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/update/GitUpdateEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/update/GitUpdateEnvironment";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "updateDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateDirectories";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

