/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v1.api.lowlevel;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.snakeyaml.engine.v1.api.LoadSettings;
import org.snakeyaml.engine.v1.api.YamlUnicodeReader;
import org.snakeyaml.engine.v1.composer.Composer;
import org.snakeyaml.engine.v1.nodes.Node;
import org.snakeyaml.engine.v1.parser.ParserImpl;
import org.snakeyaml.engine.v1.scanner.StreamReader;

public class Compose {
    private LoadSettings settings;

    public Compose(LoadSettings settings) {
        Objects.requireNonNull(settings, "LoadSettings cannot be null");
        this.settings = settings;
    }

    public Optional<Node> composeReader(Reader yaml) {
        Objects.requireNonNull(yaml, "Reader cannot be null");
        return new Composer(new ParserImpl(new StreamReader(yaml, this.settings), this.settings), this.settings.getScalarResolver()).getSingleNode();
    }

    public Optional<Node> composeInputStream(InputStream yaml) {
        Objects.requireNonNull(yaml, "InputStream cannot be null");
        return new Composer(new ParserImpl(new StreamReader(new YamlUnicodeReader(yaml), this.settings), this.settings), this.settings.getScalarResolver()).getSingleNode();
    }

    public Optional<Node> composeString(String yaml) {
        Objects.requireNonNull(yaml, "String cannot be null");
        return new Composer(new ParserImpl(new StreamReader(new StringReader(yaml), this.settings), this.settings), this.settings.getScalarResolver()).getSingleNode();
    }

    public Iterable<Node> composeAllFromReader(Reader yaml) {
        Objects.requireNonNull(yaml, "Reader cannot be null");
        return () -> new Composer(new ParserImpl(new StreamReader(yaml, this.settings), this.settings), this.settings.getScalarResolver());
    }

    public Iterable<Node> composeAllFromInputStream(InputStream yaml) {
        Objects.requireNonNull(yaml, "InputStream cannot be null");
        return () -> new Composer(new ParserImpl(new StreamReader(new YamlUnicodeReader(yaml), this.settings), this.settings), this.settings.getScalarResolver());
    }

    public Iterable<Node> composeAllFromString(final String yaml) {
        Objects.requireNonNull(yaml, "String cannot be null");
        return new Iterable(){

            public Iterator<Node> iterator() {
                return new Composer(new ParserImpl(new StreamReader(new StringReader(yaml), Compose.this.settings), Compose.this.settings), Compose.this.settings.getScalarResolver());
            }
        };
    }
}

