/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.ui.ClickListener;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsLogPopupComponent
extends JPanel {
    private static final int GAP_BEFORE_ARROW = 3;
    private static final int BORDER_SIZE = 2;
    @NotNull
    protected final String myName;
    @Nullable
    private JLabel myNameLabel;
    @NotNull
    private JLabel myValueLabel;

    protected VcsLogPopupComponent(@NotNull String name) {
        if (name == null) {
            VcsLogPopupComponent.$$$reportNull$$$0(0);
        }
        this.myName = name;
    }

    public JComponent initUi() {
        this.myNameLabel = this.shouldDrawLabel() ? new JLabel(this.myName + ": ") : null;
        this.myValueLabel = new JLabel(){

            @Override
            public String getText() {
                return VcsLogPopupComponent.this.getCurrentText();
            }
        };
        this.setDefaultForeground();
        this.setFocusable(true);
        this.setBorder(VcsLogPopupComponent.createUnfocusedBorder());
        this.setLayout(new BoxLayout(this, 0));
        if (this.myNameLabel != null) {
            this.add(this.myNameLabel);
        }
        this.add(this.myValueLabel);
        this.add(Box.createHorizontalStrut(3));
        this.add(new JLabel(AllIcons.Ide.Statusbar_arrows));
        this.installChangeListener(() -> {
            this.myValueLabel.revalidate();
            this.myValueLabel.repaint();
        });
        this.showPopupMenuOnClick();
        this.showPopupMenuFromKeyboard();
        if (this.shouldIndicateHovering()) {
            this.indicateHovering();
        }
        this.indicateFocusing();
        return this;
    }

    public abstract String getCurrentText();

    public abstract void installChangeListener(@NotNull Runnable var1);

    @NotNull
    protected Color getDefaultSelectorForeground() {
        Color color = UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getInactiveTextColor().darker().darker();
        if (color == null) {
            VcsLogPopupComponent.$$$reportNull$$$0(1);
        }
        return color;
    }

    protected boolean shouldIndicateHovering() {
        return true;
    }

    protected boolean shouldDrawLabel() {
        return true;
    }

    protected abstract ActionGroup createActionGroup();

    private void indicateFocusing() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                VcsLogPopupComponent.this.setBorder(VcsLogPopupComponent.createFocusedBorder());
            }

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                VcsLogPopupComponent.this.setBorder(VcsLogPopupComponent.createUnfocusedBorder());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogPopupComponent$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusGained";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusLost";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void showPopupMenuFromKeyboard() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (e.getKeyCode() == 10 || e.getKeyCode() == 40) {
                    VcsLogPopupComponent.this.showPopupMenu();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/VcsLogPopupComponent$3", "keyPressed"));
            }
        });
    }

    private void showPopupMenuOnClick() {
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                VcsLogPopupComponent.this.showPopupMenu();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/vcs/log/ui/filter/VcsLogPopupComponent$4", "onClick"));
            }
        }.installOn((Component)this);
    }

    private void indicateHovering() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(@NotNull MouseEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                VcsLogPopupComponent.this.setOnHoverForeground();
            }

            @Override
            public void mouseExited(@NotNull MouseEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(1);
                }
                VcsLogPopupComponent.this.setDefaultForeground();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogPopupComponent$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseEntered";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseExited";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void setDefaultForeground() {
        if (this.myNameLabel != null) {
            this.myNameLabel.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getInactiveTextColor());
        }
        this.myValueLabel.setForeground(this.getDefaultSelectorForeground());
    }

    private void setOnHoverForeground() {
        if (this.myNameLabel != null) {
            this.myNameLabel.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getTextAreaForeground());
        }
        this.myValueLabel.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getTextFieldForeground());
    }

    private void showPopupMenu() {
        ListPopup popup = this.createPopupMenu();
        popup.showUnderneathOf((Component)this);
    }

    @NotNull
    protected ListPopup createPopupMenu() {
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, this.createActionGroup(), DataManager.getInstance().getDataContext((Component)this), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        if (listPopup == null) {
            VcsLogPopupComponent.$$$reportNull$$$0(2);
        }
        return listPopup;
    }

    private static Border createFocusedBorder() {
        return BorderFactory.createCompoundBorder(new FilledRoundedBorder(UIUtil.getFocusedBorderColor(), 10, 2), JBUI.Borders.empty((int)2));
    }

    private static Border createUnfocusedBorder() {
        return BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), JBUI.Borders.empty((int)2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogPopupComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogPopupComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSelectorForeground";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupMenu";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FilledRoundedBorder
    extends LineBorder {
        private final int myArcSize;

        FilledRoundedBorder(@NotNull Color color, int arcSize, int thickness) {
            if (color == null) {
                FilledRoundedBorder.$$$reportNull$$$0(0);
            }
            super(color, thickness);
            this.myArcSize = arcSize;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
            g.setColor(this.lineColor);
            Area area = new Area(new RoundRectangle2D.Double(x, y, width, height, this.myArcSize, this.myArcSize));
            int innerArc = Math.max(this.myArcSize - this.thickness, 0);
            area.subtract(new Area(new RoundRectangle2D.Double(x + this.thickness, y + this.thickness, width - 2 * this.thickness, height - 2 * this.thickness, innerArc, innerArc)));
            ((Graphics2D)g).fill(area);
            config.restore();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/vcs/log/ui/filter/VcsLogPopupComponent$FilledRoundedBorder", "<init>"));
        }
    }
}

