/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.skeletons;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PythonHelpersLocator;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

public class SkeletonVersionChecker {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.sdk.PythonSdkType.SkeletonVersionChecker");
    static final Pattern ONE_LINE = Pattern.compile("^(?:(\\w+(?:\\.\\w+)*|\\(built-in\\)|\\(default\\))\\s+(\\d+\\.\\d+))?\\s*(?:#.*)?$");
    public static final int PREGENERATED_VERSION = -1;
    @NonNls
    static final String REQUIRED_VERSION_FNAME = "required_gen_version";
    @NonNls
    static final String DEFAULT_NAME = "(default)";
    @NonNls
    public static final String BUILTIN_NAME = "(built-in)";
    @NonNls
    public static final String PREGENERATED = "(pre-generated)";
    private final TreeMap<QualifiedName, Integer> myExplicitVersion;
    private Integer myDefaultVersion;
    private Integer myBuiltinsVersion;

    public SkeletonVersionChecker(int defaultVersion) {
        this.myExplicitVersion = SkeletonVersionChecker.createTreeMap();
        this.myDefaultVersion = defaultVersion;
        this.load();
    }

    public boolean isPregenerated() {
        return this.myDefaultVersion == -1;
    }

    private static TreeMap<QualifiedName, Integer> createTreeMap() {
        return new TreeMap<QualifiedName, Integer>((left, right) -> {
            Iterator lefts = left.getComponents().iterator();
            Iterator rights = right.getComponents().iterator();
            while (lefts.hasNext() && rights.hasNext()) {
                int res = ((String)lefts.next()).compareTo((String)rights.next());
                if (res == 0) continue;
                return res;
            }
            if (lefts.hasNext()) {
                return 1;
            }
            if (rights.hasNext()) {
                return -1;
            }
            return 0;
        });
    }

    SkeletonVersionChecker(TreeMap<QualifiedName, Integer> explicit, Integer builtins) {
        this.myExplicitVersion = explicit;
        this.myBuiltinsVersion = builtins;
    }

    public SkeletonVersionChecker withDefaultVersionIfUnknown(int version) {
        SkeletonVersionChecker ret = new SkeletonVersionChecker(this.myExplicitVersion, this.myBuiltinsVersion);
        ret.myDefaultVersion = this.myDefaultVersion != 0 ? this.myDefaultVersion : version;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        block11: {
            File infile = PythonHelpersLocator.getHelperFile(REQUIRED_VERSION_FNAME);
            try {
                if (!infile.canRead()) break block11;
                FileReader input = new FileReader(infile);
                try (LineNumberReader lines = new LineNumberReader(input);){
                    String line2;
                    do {
                        if ((line2 = lines.readLine()) == null) continue;
                        Matcher matcher = ONE_LINE.matcher(line2);
                        if (matcher.matches()) {
                            String package_name = matcher.group(1);
                            String ver = matcher.group(2);
                            if (package_name == null) continue;
                            int version = SkeletonVersionChecker.fromVersionString(ver);
                            if (DEFAULT_NAME.equals(package_name)) {
                                if (this.myDefaultVersion == -1) continue;
                                this.myDefaultVersion = version;
                                continue;
                            }
                            if (BUILTIN_NAME.equals(package_name)) {
                                this.myBuiltinsVersion = version;
                                continue;
                            }
                            this.myExplicitVersion.put(QualifiedName.fromDottedString((String)package_name), version);
                            continue;
                        }
                        LOG.warn("required_gen_version:" + lines.getLineNumber() + " Incorrect line, ignored");
                    } while (line2 != null);
                    if (this.myBuiltinsVersion == null) {
                        this.myBuiltinsVersion = this.myDefaultVersion;
                        LOG.warn("Assuming default version for built-ins");
                    }
                    assert (this.myDefaultVersion != null) : "Default version not known somehow!";
                }
            }
            catch (IOException e) {
                throw new LoadException(e);
            }
        }
    }

    public int getRequiredVersion(String package_name) {
        QualifiedName qname = QualifiedName.fromDottedString((String)package_name);
        Map.Entry<QualifiedName, Integer> found = this.myExplicitVersion.floorEntry(qname);
        if (found != null && qname.matchesPrefix(found.getKey())) {
            return found.getValue();
        }
        return this.myDefaultVersion;
    }

    public int getBuiltinVersion() {
        if (this.myBuiltinsVersion == null) {
            this.myBuiltinsVersion = this.myDefaultVersion;
        }
        return this.myBuiltinsVersion;
    }

    public static int fromVersionString(String input) {
        int dot_pos = input.indexOf(46);
        try {
            if (dot_pos > 0) {
                int major = Integer.parseInt(input.substring(0, dot_pos));
                int minor = Integer.parseInt(input.substring(dot_pos + 1));
                return (major << 8) + minor;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0;
    }

    public static String toVersionString(int input) {
        int major = input >> 8;
        int minor = input - (major << 8);
        return major + "." + minor;
    }

    public static class LoadException
    extends RuntimeException {
        public LoadException(Throwable e) {
            super(e);
        }
    }
}

