/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.model.gotosymbol;

import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoToSymbolProvider
implements ChooseByNameContributor {
    private final Key<CachedValue<Collection<Module>>> ACCEPTABLE_MODULES = Key.create((String)("ACCEPTABLE_MODULES_" + this.toString()));

    protected abstract void addNames(@NotNull Module var1, Set<String> var2);

    protected abstract void addItems(@NotNull Module var1, String var2, List<NavigationItem> var3);

    protected abstract boolean acceptModule(Module var1);

    protected static void addNewNames(@NotNull List<? extends DomElement> elements, Set<? super String> existingNames) {
        if (elements == null) {
            GoToSymbolProvider.$$$reportNull$$$0(0);
        }
        for (DomElement domElement : elements) {
            existingNames.add(domElement.getGenericInfo().getElementName(domElement));
        }
    }

    private Collection<Module> getAcceptableModules(Project project) {
        return (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, this.ACCEPTABLE_MODULES, () -> CachedValueProvider.Result.create(this.calcAcceptableModules(project), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
    }

    @NotNull
    protected Collection<Module> calcAcceptableModules(@NotNull Project project) {
        if (project == null) {
            GoToSymbolProvider.$$$reportNull$$$0(1);
        }
        List list = ContainerUtil.findAll((Object[])ModuleManager.getInstance((Project)project).getModules(), module2 -> this.acceptModule((Module)module2));
        if (list == null) {
            GoToSymbolProvider.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public String[] getNames(Project project, boolean includeNonProjectItems) {
        HashSet<String> result = new HashSet<String>();
        for (Module module2 : this.getAcceptableModules(project)) {
            this.addNames(module2, result);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(result);
        if (stringArray == null) {
            GoToSymbolProvider.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name, String pattern, Project project, boolean includeNonProjectItems) {
        ArrayList<NavigationItem> result = new ArrayList<NavigationItem>();
        for (Module module2 : this.getAcceptableModules(project)) {
            this.addItems(module2, name, result);
        }
        NavigationItem[] navigationItemArray = result.toArray(NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY);
        if (navigationItemArray == null) {
            GoToSymbolProvider.$$$reportNull$$$0(4);
        }
        return navigationItemArray;
    }

    @Nullable
    protected static NavigationItem createNavigationItem(DomElement domElement) {
        GenericDomValue name = domElement.getGenericInfo().getNameDomElement(domElement);
        assert (name != null);
        XmlElement psiElement = name.getXmlElement();
        String value = name.getStringValue();
        if (psiElement == null || value == null) {
            return null;
        }
        Icon icon = ElementPresentationManager.getIcon((Object)domElement);
        return GoToSymbolProvider.createNavigationItem((PsiElement)psiElement, value, icon);
    }

    @NotNull
    protected static NavigationItem createNavigationItem(@NotNull PsiElement element, @NotNull @NonNls String text2, @Nullable Icon icon) {
        if (element == null) {
            GoToSymbolProvider.$$$reportNull$$$0(5);
        }
        if (text2 == null) {
            GoToSymbolProvider.$$$reportNull$$$0(6);
        }
        BaseNavigationItem baseNavigationItem = new BaseNavigationItem(element, text2, icon);
        if (baseNavigationItem == null) {
            GoToSymbolProvider.$$$reportNull$$$0(7);
        }
        return baseNavigationItem;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/model/gotosymbol/GoToSymbolProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/model/gotosymbol/GoToSymbolProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calcAcceptableModules";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsByName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createNavigationItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addNewNames";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calcAcceptableModules";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNavigationItem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class BaseNavigationItem
    extends FakePsiElement {
        private final PsiElement myPsiElement;
        private final String myText;
        private final Icon myIcon;

        public BaseNavigationItem(@NotNull PsiElement psiElement, @NotNull @NonNls String text2, @Nullable Icon icon) {
            if (psiElement == null) {
                BaseNavigationItem.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                BaseNavigationItem.$$$reportNull$$$0(1);
            }
            this.myPsiElement = psiElement;
            this.myText = text2;
            this.myIcon = icon;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = this.myPsiElement;
            if (psiElement == null) {
                BaseNavigationItem.$$$reportNull$$$0(2);
            }
            return psiElement;
        }

        public Icon getIcon(boolean flags) {
            return this.myIcon;
        }

        public String getName() {
            return this.myText;
        }

        public ItemPresentation getPresentation() {
            return new ItemPresentation(){

                public String getPresentableText() {
                    return myText;
                }

                public String getLocationString() {
                    return '(' + myPsiElement.getContainingFile().getName() + ')';
                }

                @Nullable
                public Icon getIcon(boolean open2) {
                    return myIcon;
                }
            };
        }

        public PsiElement getParent() {
            return this.myPsiElement.getParent();
        }

        @NotNull
        public Project getProject() {
            Project project = this.myPsiElement.getProject();
            if (project == null) {
                BaseNavigationItem.$$$reportNull$$$0(3);
            }
            return project;
        }

        public PsiFile getContainingFile() {
            return this.myPsiElement.getContainingFile();
        }

        public boolean isValid() {
            return this.myPsiElement.isValid();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            BaseNavigationItem that = (BaseNavigationItem)((Object)o);
            if (!this.myPsiElement.equals(that.myPsiElement)) {
                return false;
            }
            return this.myText.equals(that.myText);
        }

        public int hashCode() {
            int result = this.myPsiElement.hashCode();
            result = 31 * result + this.myText.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/xml/model/gotosymbol/GoToSymbolProvider$BaseNavigationItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/xml/model/gotosymbol/GoToSymbolProvider$BaseNavigationItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

