/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.stubs.IndexedStubs;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexImpl;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StubCumulativeInputDiffBuilder
extends InputDataDiffBuilder<Integer, SerializedStubTree> {
    private static final Logger LOG = Logger.getInstance(StubCumulativeInputDiffBuilder.class);
    private final int myInputId;
    @Nullable
    private final IndexedStubs myIndexedStubs;

    StubCumulativeInputDiffBuilder(int inputId, @Nullable IndexedStubs indexedStubs) {
        super(inputId);
        this.myInputId = inputId;
        this.myIndexedStubs = indexedStubs;
    }

    public boolean differentiate(@NotNull Map<Integer, SerializedStubTree> newData, @NotNull KeyValueUpdateProcessor<? super Integer, ? super SerializedStubTree> addProcessor, @NotNull KeyValueUpdateProcessor<? super Integer, ? super SerializedStubTree> updateProcessor, @NotNull RemovedKeyProcessor<? super Integer> removeProcessor) throws StorageException {
        if (newData == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(0);
        }
        if (addProcessor == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(1);
        }
        if (updateProcessor == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(2);
        }
        if (removeProcessor == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(3);
        }
        if (newData.containsKey(this.myInputId)) {
            SerializedStubTree newSerializedStubTree = newData.get(this.myInputId);
            if (this.myIndexedStubs != null) {
                byte[] currentHash = this.myIndexedStubs.getStubTreeHash();
                boolean[] treesAreEqual = new boolean[1];
                StorageException[] exception = new StorageException[1];
                ProgressManager.getInstance().executeNonCancelableSection(() -> {
                    try {
                        treesAreEqual[0] = this.treesAreEqual(newSerializedStubTree, currentHash);
                    }
                    catch (StorageException e) {
                        exception[0] = e;
                    }
                });
                if (treesAreEqual[0]) {
                    return false;
                }
                if (exception[0] != null) {
                    throw exception[0];
                }
                removeProcessor.process((Object)this.myInputId, this.myInputId);
            }
            addProcessor.process((Object)this.myInputId, (Object)newSerializedStubTree, this.myInputId);
            this.updateStubIndices(newSerializedStubTree);
        } else {
            removeProcessor.process((Object)this.myInputId, this.myInputId);
            this.updateStubIndices(null);
        }
        return true;
    }

    private boolean treesAreEqual(@NotNull SerializedStubTree newSerializedStubTree, @NotNull byte[] currentHash) throws StorageException {
        if (newSerializedStubTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(4);
        }
        if (currentHash == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(5);
        }
        return Arrays.equals(currentHash, newSerializedStubTree.getIndexedStubs().getStubTreeHash()) && this.treesAreReallyEqual(newSerializedStubTree, currentHash);
    }

    private boolean treesAreReallyEqual(@NotNull SerializedStubTree newSerializedStubTree, @NotNull byte[] hash) throws StorageException {
        Map<Integer, SerializedStubTree> data;
        if (newSerializedStubTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(6);
        }
        if (hash == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(7);
        }
        if ((data = ((FileBasedIndexImpl)FileBasedIndex.getInstance()).getIndex(StubUpdatingIndex.INDEX_ID).getIndexedFileData(this.myInputId)).isEmpty()) {
            LOG.error("inconsistent '" + StubUpdatingIndex.INDEX_ID.getName() + "' index storage & forward-index. Serialized stub tree isn't present");
        } else if (data.size() != 1) {
            LOG.error(StubUpdatingIndex.INDEX_ID.getName() + " should contain only one tree per file: " + this.getIndexingFileName());
            return false;
        }
        SerializedStubTree storedTree = data.values().iterator().next();
        if (storedTree == null) {
            LOG.error("nullable trees are not allowed but found in " + this.getIndexingFileName());
            return false;
        }
        if (newSerializedStubTree.equals(storedTree)) {
            return true;
        }
        if (DebugAssertions.DEBUG) {
            SerializedStubTree.reportStubTreeHashCollision(newSerializedStubTree, storedTree, hash);
        }
        return false;
    }

    private String getIndexingFileName() {
        VirtualFile file2 = ManagingFS.getInstance().findFileById(this.myInputId);
        return file2 == null ? null : file2.getName();
    }

    private void updateStubIndices(@Nullable SerializedStubTree newSerializedStubTree) {
        Map<StubIndexKey, Map<Object, StubIdList>> previousStubIndicesValueMap = this.myIndexedStubs == null ? Collections.emptyMap() : this.myIndexedStubs.getStubIndicesValueMap();
        Map<StubIndexKey, Map<Object, StubIdList>> newStubIndicesValueMap = newSerializedStubTree == null ? Collections.emptyMap() : newSerializedStubTree.getIndexedStubs().getStubIndicesValueMap();
        StubCumulativeInputDiffBuilder.updateStubIndices(StubCumulativeInputDiffBuilder.getAffectedIndices(previousStubIndicesValueMap, newStubIndicesValueMap), this.myInputId, previousStubIndicesValueMap, newStubIndicesValueMap);
    }

    private static void updateStubIndices(@NotNull Collection<StubIndexKey> indexKeys, int inputId, @NotNull Map<StubIndexKey, Map<Object, StubIdList>> oldStubTree, @NotNull Map<StubIndexKey, Map<Object, StubIdList>> newStubTree) {
        if (indexKeys == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(8);
        }
        if (oldStubTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(9);
        }
        if (newStubTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(10);
        }
        StubIndexImpl stubIndex = (StubIndexImpl)StubIndex.getInstance();
        for (StubIndexKey key : indexKeys) {
            Map<Object, StubIdList> oldMap = oldStubTree.get(key);
            Map<Object, StubIdList> newMap = newStubTree.get(key);
            Map<Object, StubIdList> _oldMap = oldMap != null ? oldMap : Collections.emptyMap();
            Map<Object, StubIdList> _newMap = newMap != null ? newMap : Collections.emptyMap();
            stubIndex.updateIndex(key, inputId, _oldMap, _newMap);
        }
    }

    @NotNull
    private static Collection<StubIndexKey> getAffectedIndices(@NotNull Map<StubIndexKey, Map<Object, StubIdList>> oldStubTree, @NotNull Map<StubIndexKey, Map<Object, StubIdList>> newStubTree) {
        if (oldStubTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(11);
        }
        if (newStubTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(12);
        }
        HashSet<StubIndexKey> allIndices = new HashSet<StubIndexKey>();
        allIndices.addAll(oldStubTree.keySet());
        allIndices.addAll(newStubTree.keySet());
        HashSet<StubIndexKey> hashSet = allIndices;
        if (hashSet == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removeProcessor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSerializedStubTree";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentHash";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKeys";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldStubTree";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStubTree";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubCumulativeInputDiffBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubCumulativeInputDiffBuilder";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedIndices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "differentiate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "treesAreEqual";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "treesAreReallyEqual";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateStubIndices";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedIndices";
                break;
            }
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

