/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.FileIndexBase;
import com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import com.intellij.openapi.roots.impl.RootIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ModuleFileIndexImpl
extends FileIndexBase
implements ModuleFileIndex {
    @NotNull
    private final Module myModule;

    public ModuleFileIndexImpl(@NotNull Module module, @NotNull DirectoryIndex directoryIndex) {
        if (module == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(0);
        }
        if (directoryIndex == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(1);
        }
        super(directoryIndex, FileTypeRegistry.getInstance());
        this.myModule = module;
    }

    public boolean iterateContent(@NotNull ContentIterator processor2, @Nullable VirtualFileFilter filter) {
        if (processor2 == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(2);
        }
        Set<VirtualFile> contentRoots = this.getModuleRootsToIterate();
        for (VirtualFile contentRoot : contentRoots) {
            if (this.iterateContentUnderDirectory(contentRoot, processor2, filter)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    Set<VirtualFile> getModuleRootsToIterate() {
        Set set = (Set)ReadAction.compute(() -> {
            VirtualFile[][] allRoots;
            if (this.myModule.isDisposed()) {
                return Collections.emptySet();
            }
            LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
            VirtualFile[][] virtualFileArray = allRoots = ModuleFileIndexImpl.getModuleContentAndSourceRoots(this.myModule);
            int n = virtualFileArray.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile[] roots;
                for (VirtualFile root : roots = virtualFileArray[i]) {
                    DirectoryInfo parentInfo;
                    VirtualFile parent;
                    DirectoryInfo info = this.getInfoForFileOrDirectory(root);
                    if (!info.isInProject(root) || (parent = root.getParent()) != null && this.myModule.equals((parentInfo = this.myDirectoryIndex.getInfoForFile(parent)).getModule())) continue;
                    result2.add(root);
                }
            }
            return result2;
        });
        if (set == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(3);
        }
        return set;
    }

    public boolean isInContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(4);
        }
        return this.isInContent(fileOrDir, this.getInfoForFileOrDirectory(fileOrDir));
    }

    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(5);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInModuleSource(fileOrDir) && this.myModule.equals(info.getModule());
    }

    @NotNull
    public List<OrderEntry> getOrderEntriesForFile(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(6);
        }
        List<OrderEntry> list2 = ModuleFileIndexImpl.findAllOrderEntriesWithOwnerModule(this.myModule, this.myDirectoryIndex.getOrderEntries(this.getInfoForFileOrDirectory(fileOrDir)));
        if (list2 == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(7);
        }
        return list2;
    }

    public OrderEntry getOrderEntryForFile(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(8);
        }
        return ModuleFileIndexImpl.findOrderEntryWithOwnerModule(this.myModule, this.myDirectoryIndex.getOrderEntries(this.getInfoForFileOrDirectory(fileOrDir)));
    }

    public boolean isInTestSourceContent(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(9);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInModuleSource(fileOrDir) && this.myModule.equals(info.getModule()) && this.isTestSourcesRoot(info);
    }

    public boolean isUnderSourceRootOfType(@NotNull VirtualFile fileOrDir, @NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(10);
        }
        if (rootTypes == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(11);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInModuleSource(fileOrDir) && this.myModule.equals(info.getModule()) && rootTypes.contains(this.myDirectoryIndex.getSourceRootType(info));
    }

    @Override
    protected boolean isScopeDisposed() {
        return this.myModule.isDisposed();
    }

    @Nullable
    public static OrderEntry findOrderEntryWithOwnerModule(@NotNull Module ownerModule, @NotNull List<? extends OrderEntry> orderEntries) {
        if (ownerModule == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(12);
        }
        if (orderEntries == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(13);
        }
        if (orderEntries.size() < 10) {
            for (OrderEntry orderEntry : orderEntries) {
                if (orderEntry.getOwnerModule() != ownerModule) continue;
                return orderEntry;
            }
            return null;
        }
        int index = Collections.binarySearch(orderEntries, new FakeOrderEntry(ownerModule), RootIndex.BY_OWNER_MODULE);
        return index < 0 ? null : orderEntries.get(index);
    }

    @NotNull
    private static List<OrderEntry> findAllOrderEntriesWithOwnerModule(@NotNull Module ownerModule, @NotNull List<? extends OrderEntry> entries) {
        int lastIndex;
        if (ownerModule == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(14);
        }
        if (entries == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(15);
        }
        if (entries.isEmpty()) {
            List<OrderEntry> list2 = Collections.emptyList();
            if (list2 == null) {
                ModuleFileIndexImpl.$$$reportNull$$$0(16);
            }
            return list2;
        }
        if (entries.size() == 1) {
            OrderEntry entry = entries.get(0);
            ArrayList<OrderEntry> arrayList = entry.getOwnerModule() == ownerModule ? new ArrayList<OrderEntry>(entries) : Collections.emptyList();
            if (arrayList == null) {
                ModuleFileIndexImpl.$$$reportNull$$$0(17);
            }
            return arrayList;
        }
        int index = Collections.binarySearch(entries, new FakeOrderEntry(ownerModule), RootIndex.BY_OWNER_MODULE);
        if (index < 0) {
            List<OrderEntry> list3 = Collections.emptyList();
            if (list3 == null) {
                ModuleFileIndexImpl.$$$reportNull$$$0(18);
            }
            return list3;
        }
        int firstIndex = index;
        while (firstIndex - 1 >= 0 && entries.get(firstIndex - 1).getOwnerModule() == ownerModule) {
            --firstIndex;
        }
        for (lastIndex = index + 1; lastIndex < entries.size() && entries.get(lastIndex).getOwnerModule() == ownerModule; ++lastIndex) {
        }
        ArrayList<OrderEntry> arrayList = new ArrayList<OrderEntry>(entries.subList(firstIndex, lastIndex));
        if (arrayList == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @Override
    protected boolean isInContent(@NotNull VirtualFile file2, @NotNull DirectoryInfo info) {
        if (file2 == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(20);
        }
        if (info == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(21);
        }
        return ProjectFileIndexImpl.isFileInContent(file2, info) && this.myModule.equals(info.getModule());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ModuleFileIndexImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerModule";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntries";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ModuleFileIndexImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleRootsToIterate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntriesForFile";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllOrderEntriesWithOwnerModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "iterateContent";
                break;
            }
            case 3: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 4: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isInContent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInSourceContent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntriesForFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntryForFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isInTestSourceContent";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isUnderSourceRootOfType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findOrderEntryWithOwnerModule";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findAllOrderEntriesWithOwnerModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FakeOrderEntry
    implements OrderEntry {
        private final Module myOwnerModule;

        FakeOrderEntry(@NotNull Module ownerModule) {
            if (ownerModule == null) {
                FakeOrderEntry.$$$reportNull$$$0(0);
            }
            this.myOwnerModule = ownerModule;
        }

        @NotNull
        public VirtualFile[] getFiles(@NotNull OrderRootType type) {
            if (type == null) {
                FakeOrderEntry.$$$reportNull$$$0(1);
            }
            throw new IncorrectOperationException();
        }

        @NotNull
        public String[] getUrls(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                FakeOrderEntry.$$$reportNull$$$0(2);
            }
            throw new IncorrectOperationException();
        }

        @NotNull
        public String getPresentableName() {
            throw new IncorrectOperationException();
        }

        public boolean isValid() {
            throw new IncorrectOperationException();
        }

        @NotNull
        public Module getOwnerModule() {
            Module module = this.myOwnerModule;
            if (module == null) {
                FakeOrderEntry.$$$reportNull$$$0(3);
            }
            return module;
        }

        public <R> R accept(@NotNull RootPolicy<R> policy, @Nullable R initialValue) {
            if (policy == null) {
                FakeOrderEntry.$$$reportNull$$$0(4);
            }
            throw new IncorrectOperationException();
        }

        public int compareTo(@NotNull OrderEntry o) {
            if (o == null) {
                FakeOrderEntry.$$$reportNull$$$0(5);
            }
            throw new IncorrectOperationException();
        }

        public boolean isSynthetic() {
            throw new IncorrectOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ownerModule";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/ModuleFileIndexImpl$FakeOrderEntry";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "policy";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/ModuleFileIndexImpl$FakeOrderEntry";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOwnerModule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getFiles";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getUrls";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

