/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class RemovedMappingTracker {
    private final Map<FileNameMatcher, RemovedMapping> myRemovedMappings = new HashMap<FileNameMatcher, RemovedMapping>();
    @NonNls
    private static final String ELEMENT_REMOVED_MAPPING = "removed_mapping";
    @NonNls
    private static final String ATTRIBUTE_APPROVED = "approved";
    @NonNls
    static final String ATTRIBUTE_TYPE = "type";

    RemovedMappingTracker() {
    }

    void clear() {
        this.myRemovedMappings.clear();
    }

    public void add(FileNameMatcher matcher, String fileTypeName, boolean approved) {
        this.myRemovedMappings.put(matcher, new RemovedMapping(matcher, fileTypeName, approved));
    }

    public void load(@NotNull Element e) {
        if (e == null) {
            RemovedMappingTracker.$$$reportNull$$$0(0);
        }
        for (RemovedMapping mapping : RemovedMappingTracker.readRemovedMappings(e)) {
            this.myRemovedMappings.put(mapping.myFileNameMatcher, mapping);
        }
    }

    @NotNull
    static List<RemovedMapping> readRemovedMappings(@NotNull Element e) {
        List children2;
        if (e == null) {
            RemovedMappingTracker.$$$reportNull$$$0(1);
        }
        if ((children2 = e.getChildren(ELEMENT_REMOVED_MAPPING)).isEmpty()) {
            List<RemovedMapping> list2 = Collections.emptyList();
            if (list2 == null) {
                RemovedMappingTracker.$$$reportNull$$$0(2);
            }
            return list2;
        }
        ArrayList<RemovedMapping> result2 = new ArrayList<RemovedMapping>();
        for (Element mapping : children2) {
            String ext = mapping.getAttributeValue("ext");
            ExtensionFileNameMatcher matcher = ext == null ? FileTypeManager.parseFromString((String)mapping.getAttributeValue("pattern")) : new ExtensionFileNameMatcher(ext);
            boolean approved = Boolean.parseBoolean(mapping.getAttributeValue(ATTRIBUTE_APPROVED));
            String fileTypeName = mapping.getAttributeValue(ATTRIBUTE_TYPE);
            if (fileTypeName == null) continue;
            RemovedMapping removedMapping = new RemovedMapping((FileNameMatcher)matcher, fileTypeName, approved);
            result2.add(removedMapping);
        }
        ArrayList<RemovedMapping> arrayList = result2;
        if (arrayList == null) {
            RemovedMappingTracker.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public void save(Element element) {
        for (RemovedMapping mapping : this.myRemovedMappings.values()) {
            Element content2 = RemovedMappingTracker.writeRemovedMapping(mapping.myFileTypeName, mapping.myFileNameMatcher, true, mapping.myApproved);
            if (content2 == null) continue;
            element.addContent(content2);
        }
    }

    public void saveRemovedMappingsForFileType(Element map2, String fileTypeName, Set<FileNameMatcher> associations, boolean specifyTypeName) {
        for (FileNameMatcher matcher : associations) {
            Element content2 = RemovedMappingTracker.writeRemovedMapping(fileTypeName, matcher, specifyTypeName, this.isApproved(matcher));
            if (content2 == null) continue;
            map2.addContent(content2);
        }
    }

    boolean hasRemovedMapping(FileNameMatcher matcher) {
        return this.myRemovedMappings.containsKey(matcher);
    }

    boolean isApproved(FileNameMatcher matcher) {
        RemovedMapping mapping = this.myRemovedMappings.get(matcher);
        return mapping != null && mapping.isApproved();
    }

    public void approveRemoval(String fileTypeName, FileNameMatcher matcher) {
        this.myRemovedMappings.put(matcher, new RemovedMapping(matcher, fileTypeName, true));
    }

    public List<RemovedMapping> getRemovedMappings() {
        return new ArrayList<RemovedMapping>(this.myRemovedMappings.values());
    }

    public List<FileNameMatcher> getMappingsForFileType(String name) {
        ArrayList<FileNameMatcher> result2 = new ArrayList<FileNameMatcher>();
        for (RemovedMapping mapping : this.myRemovedMappings.values()) {
            if (!mapping.myFileTypeName.equals(name)) continue;
            result2.add(mapping.myFileNameMatcher);
        }
        return result2;
    }

    void removeMatching(BiPredicate<FileNameMatcher, String> predicate) {
        Iterator<Map.Entry<FileNameMatcher, RemovedMapping>> it = this.myRemovedMappings.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<FileNameMatcher, RemovedMapping> next = it.next();
            if (!predicate.test(next.getValue().myFileNameMatcher, next.getValue().myFileTypeName)) continue;
            it.remove();
        }
    }

    List<RemovedMapping> retrieveUnapprovedMappings() {
        ArrayList<RemovedMapping> result2 = new ArrayList<RemovedMapping>();
        Iterator<Map.Entry<FileNameMatcher, RemovedMapping>> it = this.myRemovedMappings.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<FileNameMatcher, RemovedMapping> next = it.next();
            if (next.getValue().isApproved()) continue;
            result2.add(next.getValue());
            it.remove();
        }
        return result2;
    }

    static Element writeRemovedMapping(@NotNull String fileTypeName, @NotNull FileNameMatcher matcher, boolean specifyTypeName, boolean approved) {
        if (fileTypeName == null) {
            RemovedMappingTracker.$$$reportNull$$$0(4);
        }
        if (matcher == null) {
            RemovedMappingTracker.$$$reportNull$$$0(5);
        }
        Element mapping = new Element(ELEMENT_REMOVED_MAPPING);
        if (matcher instanceof ExtensionFileNameMatcher) {
            mapping.setAttribute("ext", ((ExtensionFileNameMatcher)matcher).getExtension());
        } else if (AbstractFileType.writePattern(matcher, mapping)) {
            return null;
        }
        if (approved) {
            mapping.setAttribute(ATTRIBUTE_APPROVED, "true");
        }
        if (specifyTypeName) {
            mapping.setAttribute(ATTRIBUTE_TYPE, fileTypeName);
        }
        return mapping;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/RemovedMappingTracker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/RemovedMappingTracker";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "readRemovedMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readRemovedMappings";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeRemovedMapping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RemovedMapping {
        private final FileNameMatcher myFileNameMatcher;
        private final String myFileTypeName;
        private boolean myApproved;

        private RemovedMapping(FileNameMatcher matcher, String name, boolean approved) {
            this.myFileNameMatcher = matcher;
            this.myFileTypeName = name;
            this.myApproved = approved;
        }

        public FileNameMatcher getFileNameMatcher() {
            return this.myFileNameMatcher;
        }

        public String getFileTypeName() {
            return this.myFileTypeName;
        }

        public boolean isApproved() {
            return this.myApproved;
        }

        public void setApproved(boolean approved) {
            this.myApproved = approved;
        }
    }
}

