/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaSpinnerUI;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.LafIconLookup;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;

public class WinIntelliJSpinnerUI
extends DarculaSpinnerUI {
    static final String HOVER_PROPERTY = "JSpinner.hover";
    static final int BUTTON_WIDTH = 20;
    static final int SPINNER_HEIGHT = 22;
    private MouseListener editorMouseListener;

    public static ComponentUI createUI(JComponent c2) {
        return new WinIntelliJSpinnerUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.spinner.setOpaque(false);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.editorMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                this.setHover(Boolean.TRUE);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.setHover(Boolean.FALSE);
            }

            private void setHover(Boolean value) {
                if (WinIntelliJSpinnerUI.this.spinner.isEnabled()) {
                    WinIntelliJSpinnerUI.this.spinner.putClientProperty(WinIntelliJSpinnerUI.HOVER_PROPERTY, value);
                    WinIntelliJSpinnerUI.this.spinner.repaint();
                }
            }
        };
        this.spinner.addMouseListener(this.editorMouseListener);
        WinIntelliJSpinnerUI.getEditorFocusOwner(this.spinner).addMouseListener(this.editorMouseListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.editorMouseListener != null) {
            this.spinner.removeMouseListener(this.editorMouseListener);
            WinIntelliJSpinnerUI.getEditorFocusOwner(this.spinner).removeMouseListener(this.editorMouseListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Component getEditorFocusOwner(JSpinner spinner2) {
        Object object = spinner2.getEditor().getTreeLock();
        synchronized (object) {
            return spinner2.getEditor().getComponent(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, JComponent c2) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            Rectangle r = new Rectangle(c2.getWidth(), c2.getHeight());
            Container parent = c2.getParent();
            if (c2.isOpaque() && parent != null) {
                g2.setColor(parent.getBackground());
                g2.fill(r);
            }
            JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1, (int)1, (int)1, (int)20));
            JBInsets.removeFrom((Rectangle)r, (Insets)c2.getInsets());
            g2.setColor(c2.isEnabled() ? c2.getBackground() : UIManager.getColor("Button.background"));
            if (!c2.isEnabled()) {
                g2.setComposite(AlphaComposite.getInstance(3, 0.35f));
            }
            g2.fill(r);
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    protected JButton createButton(int direction, String name) {
        BasicArrowButton button2 = new BasicArrowButton(direction){
            private final String iconName;
            {
                this.iconName = "spinner" + (this.getDirection() == 1 ? "Up" : "Down") + "Triangle";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g.create();
                try {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                    int bw = JBUIScale.scale((int)1);
                    ButtonModel bm = this.getModel();
                    Area clip = new Area(g2.getClip());
                    if (!bm.isRollover() && !bm.isPressed()) {
                        clip.subtract(new Area(new Rectangle2D.Double(0.0, 0.0, bw, this.getHeight())));
                    }
                    if (this.getDirection() == 1 && WinIntelliJSpinnerUI.this.prevButton.getModel().isRollover()) {
                        clip.subtract(new Area(new Rectangle(0, this.getHeight() - bw, this.getWidth() - bw, bw)));
                    } else if (this.getDirection() == 5 && WinIntelliJSpinnerUI.this.nextButton.getModel().isRollover()) {
                        clip.subtract(new Area(new Rectangle(0, 0, this.getWidth() - bw, bw)));
                    }
                    g2.setClip(clip);
                    Rectangle outerRect = new Rectangle(0, this.getDirection() == 1 ? bw : 0, this.getWidth() - bw, this.getHeight() - bw);
                    if (WinIntelliJSpinnerUI.this.spinner.isEnabled()) {
                        if (bm.isPressed()) {
                            g2.setColor(UIManager.getColor("Button.intellij.native.pressedBackgroundColor"));
                        } else if (bm.isRollover()) {
                            g2.setColor(UIManager.getColor("Button.intellij.native.focusedBackgroundColor"));
                        } else {
                            g2.setColor(UIManager.getColor("Button.background"));
                        }
                    } else {
                        g2.setColor(UIManager.getColor("Button.background"));
                        g2.setComposite(AlphaComposite.getInstance(3, 0.47f));
                    }
                    g2.fill(outerRect);
                    Icon icon = LafIconLookup.getIcon((String)this.iconName, (boolean)false, (boolean)false, (boolean)this.isEnabled());
                    icon.paintIcon(this, g2, JBUIScale.scale((int)5), JBUIScale.scale((int)3));
                    if (WinIntelliJSpinnerUI.this.spinner.isEnabled()) {
                        if (bm.isPressed()) {
                            g2.setColor(UIManager.getColor("Button.intellij.native.pressedBorderColor"));
                        } else if (bm.isRollover()) {
                            g2.setColor(UIManager.getColor("Button.intellij.native.focusedBorderColor"));
                        } else {
                            g2.setColor(UIManager.getColor("Button.intellij.native.borderColor"));
                        }
                    } else {
                        g2.setColor(UIManager.getColor("Button.intellij.native.borderColor"));
                    }
                    Path2D.Float border = new Path2D.Float(0);
                    border.append(outerRect, false);
                    Rectangle innerRect = new Rectangle(outerRect);
                    JBInsets.removeFrom((Rectangle)innerRect, (Insets)JBUI.insets((int)1));
                    border.append(innerRect, false);
                    g2.fill(border);
                }
                finally {
                    g2.dispose();
                }
            }

            @Override
            public Dimension getPreferredSize() {
                Insets si = WinIntelliJSpinnerUI.this.spinner.getInsets();
                return JBUI.size((int)(20 + si.right), (int)(this.getDirection() == 1 ? 13 : 12));
            }
        };
        button2.setName(name);
        button2.setRolloverEnabled(true);
        button2.setOpaque(false);
        if (direction == 1) {
            this.installNextButtonListeners(button2);
            button2.setBorder((Border)JBUI.Borders.empty((int)2, (int)1, (int)1, (int)2));
        } else {
            this.installPreviousButtonListeners(button2);
            button2.setBorder((Border)JBUI.Borders.empty((int)1, (int)1, (int)2, (int)2));
        }
        return button2;
    }

    @Override
    protected LayoutManager createLayout() {
        return new DarculaSpinnerUI.LayoutManagerDelegate(super.createLayout()){

            @Override
            public void layoutContainer(Container parent) {
                super.layoutContainer(parent);
                Rectangle bounds2 = parent.getBounds();
                Dimension nextButtonSize = WinIntelliJSpinnerUI.this.nextButton.getPreferredSize();
                Dimension prevButtonSize = WinIntelliJSpinnerUI.this.prevButton.getPreferredSize();
                nextButtonSize.height = bounds2.height * nextButtonSize.height / (nextButtonSize.height + prevButtonSize.height - JBUIScale.scale((int)1));
                WinIntelliJSpinnerUI.this.nextButton.setBounds(bounds2.width - nextButtonSize.width, 0, nextButtonSize.width, nextButtonSize.height);
                WinIntelliJSpinnerUI.this.prevButton.setBounds(bounds2.width - prevButtonSize.width, nextButtonSize.height - JBUIScale.scale((int)1), prevButtonSize.width, bounds2.height - nextButtonSize.height + JBUIScale.scale((int)1));
                JComponent editor = WinIntelliJSpinnerUI.this.spinner.getEditor();
                if (editor != null) {
                    int w = WinIntelliJSpinnerUI.this.spinner.getWidth();
                    int h = WinIntelliJSpinnerUI.this.spinner.getHeight();
                    Insets i = WinIntelliJSpinnerUI.this.spinner.getInsets();
                    Insets m = WinIntelliJSpinnerUI.this.editorMargins();
                    int editorHeight = editor.getPreferredSize().height;
                    int editorOffset = (h - i.top - i.bottom - m.top - m.bottom - editorHeight) / 2;
                    editor.setBounds(i.left + m.left, i.top + m.top + editorOffset, w - (i.left + m.left + JBUIScale.scale((int)20) + m.right + i.right), editorHeight);
                }
            }
        };
    }

    @Override
    protected JComponent createEditor() {
        JComponent editor = super.createEditor();
        editor.setBorder((Border)JBUI.Borders.empty((int)1, (int)0));
        editor.setOpaque(false);
        return editor;
    }

    @Override
    protected void replaceEditor(JComponent oldEditor, JComponent newEditor) {
        super.replaceEditor(oldEditor, newEditor);
        newEditor.setBorder((Border)JBUI.Borders.empty((int)1, (int)0));
        newEditor.setOpaque(false);
    }

    @Override
    protected Dimension getSizeWithButtons(Insets i, Dimension size) {
        int iconWidth = JBUIScale.scale((int)20) + i.right;
        int iconHeight = JBUIScale.scale((int)22) + i.top + i.bottom;
        Dimension minSize = new Dimension(i.left + MINIMUM_WIDTH.get() + i.right, iconHeight);
        size = DarculaUIUtil.maximize(size, minSize);
        JBDimension editorSize = this.spinner.getEditor() != null ? this.spinner.getEditor().getPreferredSize() : JBUI.emptySize();
        Insets m = this.editorMargins();
        return new Dimension(Math.max(size.width, i.left + m.left + editorSize.width + m.right + iconWidth), Math.max(size.height, i.top + m.top + editorSize.height + m.bottom + i.bottom));
    }
}

