/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.openapi.ui.ErrorBorderCapable;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class DarculaTextBorder
implements Border,
UIResource,
ErrorBorderCapable {
    @Override
    public Insets getBorderInsets(Component c2) {
        int topBottom = DarculaUIUtil.isTableCellEditor(c2) || DarculaUIUtil.isCompact(c2) ? 2 : 3;
        return JBInsets.create((int)topBottom, (int)3).asUIResource();
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c2, Graphics g, int x, int y, int width, int height) {
        if (((JComponent)c2).getClientProperty("JTextField.Search.noBorderRing") == Boolean.TRUE) {
            return;
        }
        Rectangle r = new Rectangle(x, y, width, height);
        boolean focused = this.isFocused(c2);
        if (TextFieldWithPopupHandlerUI.isSearchField(c2)) {
            this.paintSearchArea((Graphics2D)g, r, (JTextComponent)c2, false);
        } else if (DarculaUIUtil.isTableCellEditor(c2)) {
            DarculaUIUtil.paintCellEditorBorder((Graphics2D)g, c2, r, focused);
        } else if (!(c2.getParent() instanceof JComboBox)) {
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
                JBInsets.removeFrom((Rectangle)r, (Insets)this.paddings());
                g2.translate(r.x, r.y);
                float lw = this.lw(g2);
                float bw = this.bw();
                this.clipForBorder(c2, g2, r.width, r.height);
                Object op = ((JComponent)c2).getClientProperty("JComponent.outline");
                if (c2.isEnabled() && op != null) {
                    DarculaUIUtil.paintOutlineBorder(g2, r.width, r.height, 0.0f, this.isSymmetric(), focused, DarculaUIUtil.Outline.valueOf(op.toString()));
                } else {
                    if (focused) {
                        DarculaUIUtil.paintOutlineBorder(g2, r.width, r.height, 0.0f, this.isSymmetric(), true, DarculaUIUtil.Outline.focus);
                    }
                    Path2D.Float border = new Path2D.Float(0);
                    border.append(new Rectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f), false);
                    border.append(new Rectangle2D.Float(bw + lw, bw + lw, (float)r.width - (bw + lw) * 2.0f, (float)r.height - (bw + lw) * 2.0f), false);
                    boolean editable = !(c2 instanceof JTextComponent) || ((JTextComponent)c2).isEditable();
                    g2.setColor(this.getOutlineColor(c2.isEnabled() && editable, focused));
                    g2.fill(border);
                }
            }
            finally {
                g2.dispose();
            }
        }
    }

    protected void paintSearchArea(Graphics2D g, Rectangle r, JTextComponent c2, boolean fillBackground) {
        DarculaTextBorder.paintDarculaSearchArea(g, r, c2, fillBackground);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintDarculaSearchArea(Graphics2D g, Rectangle r, JTextComponent c2, boolean fillBackground) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1));
            g2.translate(r.x, r.y);
            float arc = DarculaUIUtil.COMPONENT_ARC.get();
            float lw = DarculaUIUtil.LW.getFloat();
            float bw = DarculaUIUtil.BW.getFloat();
            RoundRectangle2D.Float outerShape = new RoundRectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc);
            if (fillBackground) {
                g2.setColor(c2.getBackground());
                g2.fill(outerShape);
            }
            if (c2.getClientProperty("JTextField.Search.noBorderRing") != Boolean.TRUE) {
                if (c2.hasFocus()) {
                    DarculaUIUtil.paintFocusBorder(g2, r.width, r.height, arc, true);
                }
                Path2D.Float path = new Path2D.Float(0);
                path.append(outerShape, false);
                arc = arc > lw ? arc - lw : 0.0f;
                path.append(new RoundRectangle2D.Float(bw + lw, bw + lw, (float)r.width - (bw + lw) * 2.0f, (float)r.height - (bw + lw) * 2.0f, arc, arc), false);
                g2.setColor(DarculaUIUtil.getOutlineColor(c2.isEnabled() && c2.isEditable(), c2.hasFocus()));
                g2.fill(path);
            }
        }
        finally {
            g2.dispose();
        }
    }

    protected boolean isFocused(Component c2) {
        return c2 instanceof JScrollPane ? ((JScrollPane)c2).getViewport().getView().hasFocus() : c2.hasFocus();
    }

    protected void clipForBorder(Component c2, Graphics2D g2, int width, int height) {
        Area area = new Area(new Rectangle2D.Float(0.0f, 0.0f, width, height));
        float lw = this.lw(g2);
        float bw = this.bw();
        area.subtract(new Area(new Rectangle2D.Float(bw + lw, bw + lw, (float)width - (bw + lw) * 2.0f, (float)height - (bw + lw) * 2.0f)));
        area.intersect(new Area(g2.getClip()));
        g2.setClip(area);
    }

    protected boolean isSymmetric() {
        return true;
    }

    protected float lw(Graphics2D g2) {
        return DarculaUIUtil.LW.getFloat();
    }

    protected float bw() {
        return DarculaUIUtil.BW.getFloat();
    }

    protected Color getOutlineColor(boolean enabled, boolean focused) {
        return DarculaUIUtil.getOutlineColor(enabled, focused);
    }

    protected Insets paddings() {
        return DarculaUIUtil.paddings();
    }
}

