/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.HideToolWindowAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.DesktopLayout;
import org.jetbrains.annotations.NotNull;

public class HideAllToolWindowsAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            HideAllToolWindowsAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        HideAllToolWindowsAction.performAction(project);
    }

    public static void performAction(Project project) {
        ToolWindowManagerEx toolWindowManager = ToolWindowManagerEx.getInstanceEx(project);
        DesktopLayout layout = new DesktopLayout();
        layout.copyFrom(toolWindowManager.getLayout());
        toolWindowManager.clearSideStack();
        String[] ids = toolWindowManager.getToolWindowIds();
        boolean hasVisible = false;
        for (String id : ids) {
            if (!HideToolWindowAction.shouldBeHiddenByShortCut(toolWindowManager, id)) continue;
            toolWindowManager.getToolWindow(id).hide(null);
            hasVisible = true;
        }
        if (hasVisible) {
            toolWindowManager.setLayoutToRestoreLater(layout);
            toolWindowManager.activateEditorComponent();
        } else {
            DesktopLayout restoredLayout = toolWindowManager.getLayoutToRestoreLater();
            if (restoredLayout != null) {
                toolWindowManager.setLayoutToRestoreLater(null);
                toolWindowManager.setLayout(restoredLayout);
            }
        }
    }

    public void update(@NotNull AnActionEvent event) {
        String[] ids;
        if (event == null) {
            HideAllToolWindowsAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = event.getPresentation();
        Project project = event.getProject();
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        ToolWindowManagerEx toolWindowManager = ToolWindowManagerEx.getInstanceEx(project);
        for (String id : ids = toolWindowManager.getToolWindowIds()) {
            if (!HideToolWindowAction.shouldBeHiddenByShortCut(toolWindowManager, id)) continue;
            presentation.setEnabled(true);
            presentation.setText(IdeBundle.message((String)"action.hide.all.windows", (Object[])new Object[0]), true);
            return;
        }
        DesktopLayout layout = toolWindowManager.getLayoutToRestoreLater();
        if (layout != null) {
            presentation.setEnabled(true);
            presentation.setText(IdeBundle.message((String)"action.restore.windows", (Object[])new Object[0]));
            return;
        }
        presentation.setEnabled(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/HideAllToolWindowsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

